/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ReadCustomerMaterialsNamespace {

    public static class CustomerMaterialFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_CUSTOMER_MATERIAL_SRV", (String)"A_CustomerMaterial");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public CustomerMaterialFluentHelper filter(ExpressionFluentHelper<CustomerMaterial> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public CustomerMaterialFluentHelper orderBy(EntityField<?, CustomerMaterial> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final CustomerMaterialFluentHelper select(EntityField<?, CustomerMaterial> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public CustomerMaterialFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public CustomerMaterialFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public CustomerMaterialFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<CustomerMaterial> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(CustomerMaterial.class);
            for (CustomerMaterial entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class CustomerMaterialByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public CustomerMaterialByKeyFluentHelper(String salesOrganization, String distributionChannel, String customer, String material) {
            this.values.add(salesOrganization);
            this.values.add(distributionChannel);
            this.values.add(customer);
            this.values.add(material);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_CUSTOMER_MATERIAL_SRV", (String)"A_CustomerMaterial");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrganization", this.values.get(0));
            keys.put("DistributionChannel", this.values.get(1));
            keys.put("Customer", this.values.get(2));
            keys.put("Material", this.values.get(3));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final CustomerMaterialByKeyFluentHelper select(EntityField<?, CustomerMaterial> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public CustomerMaterialByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public CustomerMaterial execute(ErpConfigContext erpConfigContext) throws ODataException {
            CustomerMaterial entity = (CustomerMaterial)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(CustomerMaterial.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class CustomerMaterial {
        @ElementName(value="SalesOrganization")
        private String salesOrganization;
        public static EntityField<String, CustomerMaterial> SALES_ORGANIZATION = new EntityField("SalesOrganization");
        @ElementName(value="BaseUnit")
        private String baseUnit;
        public static EntityField<String, CustomerMaterial> BASE_UNIT = new EntityField("BaseUnit");
        @ElementName(value="PartialDeliveryIsAllowed")
        private String partialDeliveryIsAllowed;
        public static EntityField<String, CustomerMaterial> PARTIAL_DELIVERY_IS_ALLOWED = new EntityField("PartialDeliveryIsAllowed");
        @ElementName(value="MaxNmbrOfPartialDelivery")
        private BigDecimal maxNmbrOfPartialDelivery;
        public static EntityField<BigDecimal, CustomerMaterial> MAX_NMBR_OF_PARTIAL_DELIVERY = new EntityField("MaxNmbrOfPartialDelivery");
        @ElementName(value="UnderdelivTolrtdLmtRatioInPct")
        private BigDecimal underdelivTolrtdLmtRatioInPct;
        public static EntityField<BigDecimal, CustomerMaterial> UNDERDELIV_TOLRTD_LMT_RATIO_IN_PCT = new EntityField("UnderdelivTolrtdLmtRatioInPct");
        @ElementName(value="OverdelivTolrtdLmtRatioInPct")
        private BigDecimal overdelivTolrtdLmtRatioInPct;
        public static EntityField<BigDecimal, CustomerMaterial> OVERDELIV_TOLRTD_LMT_RATIO_IN_PCT = new EntityField("OverdelivTolrtdLmtRatioInPct");
        @ElementName(value="UnlimitedOverdeliveryIsAllowed")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean unlimitedOverdeliveryIsAllowed;
        public static EntityField<Boolean, CustomerMaterial> UNLIMITED_OVERDELIVERY_IS_ALLOWED = new EntityField("UnlimitedOverdeliveryIsAllowed");
        @ElementName(value="CustomerMaterialItemUsage")
        private String customerMaterialItemUsage;
        public static EntityField<String, CustomerMaterial> CUSTOMER_MATERIAL_ITEM_USAGE = new EntityField("CustomerMaterialItemUsage");
        @ElementName(value="DistributionChannel")
        private String distributionChannel;
        public static EntityField<String, CustomerMaterial> DISTRIBUTION_CHANNEL = new EntityField("DistributionChannel");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, CustomerMaterial> CUSTOMER = new EntityField("Customer");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, CustomerMaterial> MATERIAL = new EntityField("Material");
        @ElementName(value="MaterialByCustomer")
        private String materialByCustomer;
        public static EntityField<String, CustomerMaterial> MATERIAL_BY_CUSTOMER = new EntityField("MaterialByCustomer");
        @ElementName(value="MaterialDescriptionByCustomer")
        private String materialDescriptionByCustomer;
        public static EntityField<String, CustomerMaterial> MATERIAL_DESCRIPTION_BY_CUSTOMER = new EntityField("MaterialDescriptionByCustomer");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, CustomerMaterial> PLANT = new EntityField("Plant");
        @ElementName(value="DeliveryPriority")
        private String deliveryPriority;
        public static EntityField<String, CustomerMaterial> DELIVERY_PRIORITY = new EntityField("DeliveryPriority");
        @ElementName(value="MinDeliveryQtyInBaseUnit")
        private BigDecimal minDeliveryQtyInBaseUnit;
        public static EntityField<BigDecimal, CustomerMaterial> MIN_DELIVERY_QTY_IN_BASE_UNIT = new EntityField("MinDeliveryQtyInBaseUnit");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_CUSTOMER_MATERIAL_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_CustomerMaterial";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ReadCustomerMaterialsNamespace.CustomerMaterial(salesOrganization=" + this.salesOrganization + ", baseUnit=" + this.baseUnit + ", partialDeliveryIsAllowed=" + this.partialDeliveryIsAllowed + ", maxNmbrOfPartialDelivery=" + this.maxNmbrOfPartialDelivery + ", underdelivTolrtdLmtRatioInPct=" + this.underdelivTolrtdLmtRatioInPct + ", overdelivTolrtdLmtRatioInPct=" + this.overdelivTolrtdLmtRatioInPct + ", unlimitedOverdeliveryIsAllowed=" + this.unlimitedOverdeliveryIsAllowed + ", customerMaterialItemUsage=" + this.customerMaterialItemUsage + ", distributionChannel=" + this.distributionChannel + ", customer=" + this.customer + ", material=" + this.material + ", materialByCustomer=" + this.materialByCustomer + ", materialDescriptionByCustomer=" + this.materialDescriptionByCustomer + ", plant=" + this.plant + ", deliveryPriority=" + this.deliveryPriority + ", minDeliveryQtyInBaseUnit=" + this.minDeliveryQtyInBaseUnit + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerMaterial)) {
                return false;
            }
            CustomerMaterial other = (CustomerMaterial)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrganization = this.salesOrganization;
            String other$salesOrganization = other.salesOrganization;
            if (this$salesOrganization == null ? other$salesOrganization != null : !this$salesOrganization.equals(other$salesOrganization)) {
                return false;
            }
            String this$baseUnit = this.baseUnit;
            String other$baseUnit = other.baseUnit;
            if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
                return false;
            }
            String this$partialDeliveryIsAllowed = this.partialDeliveryIsAllowed;
            String other$partialDeliveryIsAllowed = other.partialDeliveryIsAllowed;
            if (this$partialDeliveryIsAllowed == null ? other$partialDeliveryIsAllowed != null : !this$partialDeliveryIsAllowed.equals(other$partialDeliveryIsAllowed)) {
                return false;
            }
            BigDecimal this$maxNmbrOfPartialDelivery = this.maxNmbrOfPartialDelivery;
            BigDecimal other$maxNmbrOfPartialDelivery = other.maxNmbrOfPartialDelivery;
            if (this$maxNmbrOfPartialDelivery == null ? other$maxNmbrOfPartialDelivery != null : !((Object)this$maxNmbrOfPartialDelivery).equals(other$maxNmbrOfPartialDelivery)) {
                return false;
            }
            BigDecimal this$underdelivTolrtdLmtRatioInPct = this.underdelivTolrtdLmtRatioInPct;
            BigDecimal other$underdelivTolrtdLmtRatioInPct = other.underdelivTolrtdLmtRatioInPct;
            if (this$underdelivTolrtdLmtRatioInPct == null ? other$underdelivTolrtdLmtRatioInPct != null : !((Object)this$underdelivTolrtdLmtRatioInPct).equals(other$underdelivTolrtdLmtRatioInPct)) {
                return false;
            }
            BigDecimal this$overdelivTolrtdLmtRatioInPct = this.overdelivTolrtdLmtRatioInPct;
            BigDecimal other$overdelivTolrtdLmtRatioInPct = other.overdelivTolrtdLmtRatioInPct;
            if (this$overdelivTolrtdLmtRatioInPct == null ? other$overdelivTolrtdLmtRatioInPct != null : !((Object)this$overdelivTolrtdLmtRatioInPct).equals(other$overdelivTolrtdLmtRatioInPct)) {
                return false;
            }
            Boolean this$unlimitedOverdeliveryIsAllowed = this.unlimitedOverdeliveryIsAllowed;
            Boolean other$unlimitedOverdeliveryIsAllowed = other.unlimitedOverdeliveryIsAllowed;
            if (this$unlimitedOverdeliveryIsAllowed == null ? other$unlimitedOverdeliveryIsAllowed != null : !((Object)this$unlimitedOverdeliveryIsAllowed).equals(other$unlimitedOverdeliveryIsAllowed)) {
                return false;
            }
            String this$customerMaterialItemUsage = this.customerMaterialItemUsage;
            String other$customerMaterialItemUsage = other.customerMaterialItemUsage;
            if (this$customerMaterialItemUsage == null ? other$customerMaterialItemUsage != null : !this$customerMaterialItemUsage.equals(other$customerMaterialItemUsage)) {
                return false;
            }
            String this$distributionChannel = this.distributionChannel;
            String other$distributionChannel = other.distributionChannel;
            if (this$distributionChannel == null ? other$distributionChannel != null : !this$distributionChannel.equals(other$distributionChannel)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$materialByCustomer = this.materialByCustomer;
            String other$materialByCustomer = other.materialByCustomer;
            if (this$materialByCustomer == null ? other$materialByCustomer != null : !this$materialByCustomer.equals(other$materialByCustomer)) {
                return false;
            }
            String this$materialDescriptionByCustomer = this.materialDescriptionByCustomer;
            String other$materialDescriptionByCustomer = other.materialDescriptionByCustomer;
            if (this$materialDescriptionByCustomer == null ? other$materialDescriptionByCustomer != null : !this$materialDescriptionByCustomer.equals(other$materialDescriptionByCustomer)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$deliveryPriority = this.deliveryPriority;
            String other$deliveryPriority = other.deliveryPriority;
            if (this$deliveryPriority == null ? other$deliveryPriority != null : !this$deliveryPriority.equals(other$deliveryPriority)) {
                return false;
            }
            BigDecimal this$minDeliveryQtyInBaseUnit = this.minDeliveryQtyInBaseUnit;
            BigDecimal other$minDeliveryQtyInBaseUnit = other.minDeliveryQtyInBaseUnit;
            return !(this$minDeliveryQtyInBaseUnit == null ? other$minDeliveryQtyInBaseUnit != null : !((Object)this$minDeliveryQtyInBaseUnit).equals(other$minDeliveryQtyInBaseUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomerMaterial;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrganization = this.salesOrganization;
            result = result * 59 + ($salesOrganization == null ? 43 : $salesOrganization.hashCode());
            String $baseUnit = this.baseUnit;
            result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
            String $partialDeliveryIsAllowed = this.partialDeliveryIsAllowed;
            result = result * 59 + ($partialDeliveryIsAllowed == null ? 43 : $partialDeliveryIsAllowed.hashCode());
            BigDecimal $maxNmbrOfPartialDelivery = this.maxNmbrOfPartialDelivery;
            result = result * 59 + ($maxNmbrOfPartialDelivery == null ? 43 : ((Object)$maxNmbrOfPartialDelivery).hashCode());
            BigDecimal $underdelivTolrtdLmtRatioInPct = this.underdelivTolrtdLmtRatioInPct;
            result = result * 59 + ($underdelivTolrtdLmtRatioInPct == null ? 43 : ((Object)$underdelivTolrtdLmtRatioInPct).hashCode());
            BigDecimal $overdelivTolrtdLmtRatioInPct = this.overdelivTolrtdLmtRatioInPct;
            result = result * 59 + ($overdelivTolrtdLmtRatioInPct == null ? 43 : ((Object)$overdelivTolrtdLmtRatioInPct).hashCode());
            Boolean $unlimitedOverdeliveryIsAllowed = this.unlimitedOverdeliveryIsAllowed;
            result = result * 59 + ($unlimitedOverdeliveryIsAllowed == null ? 43 : ((Object)$unlimitedOverdeliveryIsAllowed).hashCode());
            String $customerMaterialItemUsage = this.customerMaterialItemUsage;
            result = result * 59 + ($customerMaterialItemUsage == null ? 43 : $customerMaterialItemUsage.hashCode());
            String $distributionChannel = this.distributionChannel;
            result = result * 59 + ($distributionChannel == null ? 43 : $distributionChannel.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $materialByCustomer = this.materialByCustomer;
            result = result * 59 + ($materialByCustomer == null ? 43 : $materialByCustomer.hashCode());
            String $materialDescriptionByCustomer = this.materialDescriptionByCustomer;
            result = result * 59 + ($materialDescriptionByCustomer == null ? 43 : $materialDescriptionByCustomer.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $deliveryPriority = this.deliveryPriority;
            result = result * 59 + ($deliveryPriority == null ? 43 : $deliveryPriority.hashCode());
            BigDecimal $minDeliveryQtyInBaseUnit = this.minDeliveryQtyInBaseUnit;
            result = result * 59 + ($minDeliveryQtyInBaseUnit == null ? 43 : ((Object)$minDeliveryQtyInBaseUnit).hashCode());
            return result;
        }

        public String getSalesOrganization() {
            return this.salesOrganization;
        }

        public CustomerMaterial setSalesOrganization(String salesOrganization) {
            this.salesOrganization = salesOrganization;
            return this;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public CustomerMaterial setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        public String getPartialDeliveryIsAllowed() {
            return this.partialDeliveryIsAllowed;
        }

        public CustomerMaterial setPartialDeliveryIsAllowed(String partialDeliveryIsAllowed) {
            this.partialDeliveryIsAllowed = partialDeliveryIsAllowed;
            return this;
        }

        public BigDecimal getMaxNmbrOfPartialDelivery() {
            return this.maxNmbrOfPartialDelivery;
        }

        public CustomerMaterial setMaxNmbrOfPartialDelivery(BigDecimal maxNmbrOfPartialDelivery) {
            this.maxNmbrOfPartialDelivery = maxNmbrOfPartialDelivery;
            return this;
        }

        public BigDecimal getUnderdelivTolrtdLmtRatioInPct() {
            return this.underdelivTolrtdLmtRatioInPct;
        }

        public CustomerMaterial setUnderdelivTolrtdLmtRatioInPct(BigDecimal underdelivTolrtdLmtRatioInPct) {
            this.underdelivTolrtdLmtRatioInPct = underdelivTolrtdLmtRatioInPct;
            return this;
        }

        public BigDecimal getOverdelivTolrtdLmtRatioInPct() {
            return this.overdelivTolrtdLmtRatioInPct;
        }

        public CustomerMaterial setOverdelivTolrtdLmtRatioInPct(BigDecimal overdelivTolrtdLmtRatioInPct) {
            this.overdelivTolrtdLmtRatioInPct = overdelivTolrtdLmtRatioInPct;
            return this;
        }

        public Boolean getUnlimitedOverdeliveryIsAllowed() {
            return this.unlimitedOverdeliveryIsAllowed;
        }

        public CustomerMaterial setUnlimitedOverdeliveryIsAllowed(Boolean unlimitedOverdeliveryIsAllowed) {
            this.unlimitedOverdeliveryIsAllowed = unlimitedOverdeliveryIsAllowed;
            return this;
        }

        public String getCustomerMaterialItemUsage() {
            return this.customerMaterialItemUsage;
        }

        public CustomerMaterial setCustomerMaterialItemUsage(String customerMaterialItemUsage) {
            this.customerMaterialItemUsage = customerMaterialItemUsage;
            return this;
        }

        public String getDistributionChannel() {
            return this.distributionChannel;
        }

        public CustomerMaterial setDistributionChannel(String distributionChannel) {
            this.distributionChannel = distributionChannel;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public CustomerMaterial setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public CustomerMaterial setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getMaterialByCustomer() {
            return this.materialByCustomer;
        }

        public CustomerMaterial setMaterialByCustomer(String materialByCustomer) {
            this.materialByCustomer = materialByCustomer;
            return this;
        }

        public String getMaterialDescriptionByCustomer() {
            return this.materialDescriptionByCustomer;
        }

        public CustomerMaterial setMaterialDescriptionByCustomer(String materialDescriptionByCustomer) {
            this.materialDescriptionByCustomer = materialDescriptionByCustomer;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public CustomerMaterial setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getDeliveryPriority() {
            return this.deliveryPriority;
        }

        public CustomerMaterial setDeliveryPriority(String deliveryPriority) {
            this.deliveryPriority = deliveryPriority;
            return this;
        }

        public BigDecimal getMinDeliveryQtyInBaseUnit() {
            return this.minDeliveryQtyInBaseUnit;
        }

        public CustomerMaterial setMinDeliveryQtyInBaseUnit(BigDecimal minDeliveryQtyInBaseUnit) {
            this.minDeliveryQtyInBaseUnit = minDeliveryQtyInBaseUnit;
            return this;
        }

        public CustomerMaterial setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

