/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ProductMasterNamespace {

    public static class ProductStorageLocationFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductStorageLocation");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProductStorageLocationFluentHelper filter(ExpressionFluentHelper<ProductStorageLocation> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProductStorageLocationFluentHelper orderBy(EntityField<?, ProductStorageLocation> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProductStorageLocationFluentHelper select(EntityField<?, ProductStorageLocation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProductStorageLocationFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProductStorageLocationFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProductStorageLocationFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProductStorageLocation> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProductStorageLocation.class);
            for (ProductStorageLocation entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProductStorageLocationByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProductStorageLocationByKeyFluentHelper(String product, String plant, String storageLocation) {
            this.values.add(product);
            this.values.add(plant);
            this.values.add(storageLocation);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductStorageLocation");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Product", this.values.get(0));
            keys.put("Plant", this.values.get(1));
            keys.put("StorageLocation", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProductStorageLocationByKeyFluentHelper select(EntityField<?, ProductStorageLocation> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProductStorageLocationByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProductStorageLocation execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProductStorageLocation entity = (ProductStorageLocation)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProductStorageLocation.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProductStorageLocation {
        @ElementName(value="Product")
        private String product;
        public static EntityField<String, ProductStorageLocation> PRODUCT = new EntityField("Product");
        @ElementName(value="InventoryCorrectionFactor")
        private Double inventoryCorrectionFactor;
        public static EntityField<Double, ProductStorageLocation> INVENTORY_CORRECTION_FACTOR = new EntityField("InventoryCorrectionFactor");
        @ElementName(value="InvtryRestrictedUseStockInd")
        private String invtryRestrictedUseStockInd;
        public static EntityField<String, ProductStorageLocation> INVTRY_RESTRICTED_USE_STOCK_IND = new EntityField("InvtryRestrictedUseStockInd");
        @ElementName(value="InvtryCurrentYearStockInd")
        private String invtryCurrentYearStockInd;
        public static EntityField<String, ProductStorageLocation> INVTRY_CURRENT_YEAR_STOCK_IND = new EntityField("InvtryCurrentYearStockInd");
        @ElementName(value="InvtryQualInspCurrentYrStkInd")
        private String invtryQualInspCurrentYrStkInd;
        public static EntityField<String, ProductStorageLocation> INVTRY_QUAL_INSP_CURRENT_YR_STK_IND = new EntityField("InvtryQualInspCurrentYrStkInd");
        @ElementName(value="InventoryBlockStockInd")
        private String inventoryBlockStockInd;
        public static EntityField<String, ProductStorageLocation> INVENTORY_BLOCK_STOCK_IND = new EntityField("InventoryBlockStockInd");
        @ElementName(value="InvtryRestStockPrevPeriodInd")
        private String invtryRestStockPrevPeriodInd;
        public static EntityField<String, ProductStorageLocation> INVTRY_REST_STOCK_PREV_PERIOD_IND = new EntityField("InvtryRestStockPrevPeriodInd");
        @ElementName(value="InventoryStockPrevPeriod")
        private String inventoryStockPrevPeriod;
        public static EntityField<String, ProductStorageLocation> INVENTORY_STOCK_PREV_PERIOD = new EntityField("InventoryStockPrevPeriod");
        @ElementName(value="InvtryStockQltyInspPrevPeriod")
        private String invtryStockQltyInspPrevPeriod;
        public static EntityField<String, ProductStorageLocation> INVTRY_STOCK_QLTY_INSP_PREV_PERIOD = new EntityField("InvtryStockQltyInspPrevPeriod");
        @ElementName(value="HasInvtryBlockStockPrevPeriod")
        private String hasInvtryBlockStockPrevPeriod;
        public static EntityField<String, ProductStorageLocation> HAS_INVTRY_BLOCK_STOCK_PREV_PERIOD = new EntityField("HasInvtryBlockStockPrevPeriod");
        @ElementName(value="FiscalYearCurrentPeriod")
        private String fiscalYearCurrentPeriod;
        public static EntityField<String, ProductStorageLocation> FISCAL_YEAR_CURRENT_PERIOD = new EntityField("FiscalYearCurrentPeriod");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, ProductStorageLocation> PLANT = new EntityField("Plant");
        @ElementName(value="FiscalMonthCurrentPeriod")
        private String fiscalMonthCurrentPeriod;
        public static EntityField<String, ProductStorageLocation> FISCAL_MONTH_CURRENT_PERIOD = new EntityField("FiscalMonthCurrentPeriod");
        @ElementName(value="FiscalYearCurrentInvtryPeriod")
        private String fiscalYearCurrentInvtryPeriod;
        public static EntityField<String, ProductStorageLocation> FISCAL_YEAR_CURRENT_INVTRY_PERIOD = new EntityField("FiscalYearCurrentInvtryPeriod");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, ProductStorageLocation> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="WarehouseStorageBin")
        private String warehouseStorageBin;
        public static EntityField<String, ProductStorageLocation> WAREHOUSE_STORAGE_BIN = new EntityField("WarehouseStorageBin");
        @ElementName(value="MaintenanceStatus")
        private String maintenanceStatus;
        public static EntityField<String, ProductStorageLocation> MAINTENANCE_STATUS = new EntityField("MaintenanceStatus");
        @ElementName(value="PhysicalInventoryBlockInd")
        private String physicalInventoryBlockInd;
        public static EntityField<String, ProductStorageLocation> PHYSICAL_INVENTORY_BLOCK_IND = new EntityField("PhysicalInventoryBlockInd");
        @ElementName(value="CreationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar creationDate;
        public static EntityField<Calendar, ProductStorageLocation> CREATION_DATE = new EntityField("CreationDate");
        @ElementName(value="IsMarkedForDeletion")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isMarkedForDeletion;
        public static EntityField<Boolean, ProductStorageLocation> IS_MARKED_FOR_DELETION = new EntityField("IsMarkedForDeletion");
        @ElementName(value="DateOfLastPostedCntUnRstrcdStk")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar dateOfLastPostedCntUnRstrcdStk;
        public static EntityField<Calendar, ProductStorageLocation> DATE_OF_LAST_POSTED_CNT_UN_RSTRCD_STK = new EntityField("DateOfLastPostedCntUnRstrcdStk");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PRODUCT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProductStorageLocation";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ProductMasterNamespace.ProductStorageLocation(product=" + this.product + ", inventoryCorrectionFactor=" + this.inventoryCorrectionFactor + ", invtryRestrictedUseStockInd=" + this.invtryRestrictedUseStockInd + ", invtryCurrentYearStockInd=" + this.invtryCurrentYearStockInd + ", invtryQualInspCurrentYrStkInd=" + this.invtryQualInspCurrentYrStkInd + ", inventoryBlockStockInd=" + this.inventoryBlockStockInd + ", invtryRestStockPrevPeriodInd=" + this.invtryRestStockPrevPeriodInd + ", inventoryStockPrevPeriod=" + this.inventoryStockPrevPeriod + ", invtryStockQltyInspPrevPeriod=" + this.invtryStockQltyInspPrevPeriod + ", hasInvtryBlockStockPrevPeriod=" + this.hasInvtryBlockStockPrevPeriod + ", fiscalYearCurrentPeriod=" + this.fiscalYearCurrentPeriod + ", plant=" + this.plant + ", fiscalMonthCurrentPeriod=" + this.fiscalMonthCurrentPeriod + ", fiscalYearCurrentInvtryPeriod=" + this.fiscalYearCurrentInvtryPeriod + ", storageLocation=" + this.storageLocation + ", warehouseStorageBin=" + this.warehouseStorageBin + ", maintenanceStatus=" + this.maintenanceStatus + ", physicalInventoryBlockInd=" + this.physicalInventoryBlockInd + ", creationDate=" + this.creationDate + ", isMarkedForDeletion=" + this.isMarkedForDeletion + ", dateOfLastPostedCntUnRstrcdStk=" + this.dateOfLastPostedCntUnRstrcdStk + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProductStorageLocation)) {
                return false;
            }
            ProductStorageLocation other = (ProductStorageLocation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.product;
            String other$product = other.product;
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            Double this$inventoryCorrectionFactor = this.inventoryCorrectionFactor;
            Double other$inventoryCorrectionFactor = other.inventoryCorrectionFactor;
            if (this$inventoryCorrectionFactor == null ? other$inventoryCorrectionFactor != null : !((Object)this$inventoryCorrectionFactor).equals(other$inventoryCorrectionFactor)) {
                return false;
            }
            String this$invtryRestrictedUseStockInd = this.invtryRestrictedUseStockInd;
            String other$invtryRestrictedUseStockInd = other.invtryRestrictedUseStockInd;
            if (this$invtryRestrictedUseStockInd == null ? other$invtryRestrictedUseStockInd != null : !this$invtryRestrictedUseStockInd.equals(other$invtryRestrictedUseStockInd)) {
                return false;
            }
            String this$invtryCurrentYearStockInd = this.invtryCurrentYearStockInd;
            String other$invtryCurrentYearStockInd = other.invtryCurrentYearStockInd;
            if (this$invtryCurrentYearStockInd == null ? other$invtryCurrentYearStockInd != null : !this$invtryCurrentYearStockInd.equals(other$invtryCurrentYearStockInd)) {
                return false;
            }
            String this$invtryQualInspCurrentYrStkInd = this.invtryQualInspCurrentYrStkInd;
            String other$invtryQualInspCurrentYrStkInd = other.invtryQualInspCurrentYrStkInd;
            if (this$invtryQualInspCurrentYrStkInd == null ? other$invtryQualInspCurrentYrStkInd != null : !this$invtryQualInspCurrentYrStkInd.equals(other$invtryQualInspCurrentYrStkInd)) {
                return false;
            }
            String this$inventoryBlockStockInd = this.inventoryBlockStockInd;
            String other$inventoryBlockStockInd = other.inventoryBlockStockInd;
            if (this$inventoryBlockStockInd == null ? other$inventoryBlockStockInd != null : !this$inventoryBlockStockInd.equals(other$inventoryBlockStockInd)) {
                return false;
            }
            String this$invtryRestStockPrevPeriodInd = this.invtryRestStockPrevPeriodInd;
            String other$invtryRestStockPrevPeriodInd = other.invtryRestStockPrevPeriodInd;
            if (this$invtryRestStockPrevPeriodInd == null ? other$invtryRestStockPrevPeriodInd != null : !this$invtryRestStockPrevPeriodInd.equals(other$invtryRestStockPrevPeriodInd)) {
                return false;
            }
            String this$inventoryStockPrevPeriod = this.inventoryStockPrevPeriod;
            String other$inventoryStockPrevPeriod = other.inventoryStockPrevPeriod;
            if (this$inventoryStockPrevPeriod == null ? other$inventoryStockPrevPeriod != null : !this$inventoryStockPrevPeriod.equals(other$inventoryStockPrevPeriod)) {
                return false;
            }
            String this$invtryStockQltyInspPrevPeriod = this.invtryStockQltyInspPrevPeriod;
            String other$invtryStockQltyInspPrevPeriod = other.invtryStockQltyInspPrevPeriod;
            if (this$invtryStockQltyInspPrevPeriod == null ? other$invtryStockQltyInspPrevPeriod != null : !this$invtryStockQltyInspPrevPeriod.equals(other$invtryStockQltyInspPrevPeriod)) {
                return false;
            }
            String this$hasInvtryBlockStockPrevPeriod = this.hasInvtryBlockStockPrevPeriod;
            String other$hasInvtryBlockStockPrevPeriod = other.hasInvtryBlockStockPrevPeriod;
            if (this$hasInvtryBlockStockPrevPeriod == null ? other$hasInvtryBlockStockPrevPeriod != null : !this$hasInvtryBlockStockPrevPeriod.equals(other$hasInvtryBlockStockPrevPeriod)) {
                return false;
            }
            String this$fiscalYearCurrentPeriod = this.fiscalYearCurrentPeriod;
            String other$fiscalYearCurrentPeriod = other.fiscalYearCurrentPeriod;
            if (this$fiscalYearCurrentPeriod == null ? other$fiscalYearCurrentPeriod != null : !this$fiscalYearCurrentPeriod.equals(other$fiscalYearCurrentPeriod)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$fiscalMonthCurrentPeriod = this.fiscalMonthCurrentPeriod;
            String other$fiscalMonthCurrentPeriod = other.fiscalMonthCurrentPeriod;
            if (this$fiscalMonthCurrentPeriod == null ? other$fiscalMonthCurrentPeriod != null : !this$fiscalMonthCurrentPeriod.equals(other$fiscalMonthCurrentPeriod)) {
                return false;
            }
            String this$fiscalYearCurrentInvtryPeriod = this.fiscalYearCurrentInvtryPeriod;
            String other$fiscalYearCurrentInvtryPeriod = other.fiscalYearCurrentInvtryPeriod;
            if (this$fiscalYearCurrentInvtryPeriod == null ? other$fiscalYearCurrentInvtryPeriod != null : !this$fiscalYearCurrentInvtryPeriod.equals(other$fiscalYearCurrentInvtryPeriod)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$warehouseStorageBin = this.warehouseStorageBin;
            String other$warehouseStorageBin = other.warehouseStorageBin;
            if (this$warehouseStorageBin == null ? other$warehouseStorageBin != null : !this$warehouseStorageBin.equals(other$warehouseStorageBin)) {
                return false;
            }
            String this$maintenanceStatus = this.maintenanceStatus;
            String other$maintenanceStatus = other.maintenanceStatus;
            if (this$maintenanceStatus == null ? other$maintenanceStatus != null : !this$maintenanceStatus.equals(other$maintenanceStatus)) {
                return false;
            }
            String this$physicalInventoryBlockInd = this.physicalInventoryBlockInd;
            String other$physicalInventoryBlockInd = other.physicalInventoryBlockInd;
            if (this$physicalInventoryBlockInd == null ? other$physicalInventoryBlockInd != null : !this$physicalInventoryBlockInd.equals(other$physicalInventoryBlockInd)) {
                return false;
            }
            Calendar this$creationDate = this.creationDate;
            Calendar other$creationDate = other.creationDate;
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            Boolean this$isMarkedForDeletion = this.isMarkedForDeletion;
            Boolean other$isMarkedForDeletion = other.isMarkedForDeletion;
            if (this$isMarkedForDeletion == null ? other$isMarkedForDeletion != null : !((Object)this$isMarkedForDeletion).equals(other$isMarkedForDeletion)) {
                return false;
            }
            Calendar this$dateOfLastPostedCntUnRstrcdStk = this.dateOfLastPostedCntUnRstrcdStk;
            Calendar other$dateOfLastPostedCntUnRstrcdStk = other.dateOfLastPostedCntUnRstrcdStk;
            return !(this$dateOfLastPostedCntUnRstrcdStk == null ? other$dateOfLastPostedCntUnRstrcdStk != null : !((Object)this$dateOfLastPostedCntUnRstrcdStk).equals(other$dateOfLastPostedCntUnRstrcdStk));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProductStorageLocation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.product;
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            Double $inventoryCorrectionFactor = this.inventoryCorrectionFactor;
            result = result * 59 + ($inventoryCorrectionFactor == null ? 43 : ((Object)$inventoryCorrectionFactor).hashCode());
            String $invtryRestrictedUseStockInd = this.invtryRestrictedUseStockInd;
            result = result * 59 + ($invtryRestrictedUseStockInd == null ? 43 : $invtryRestrictedUseStockInd.hashCode());
            String $invtryCurrentYearStockInd = this.invtryCurrentYearStockInd;
            result = result * 59 + ($invtryCurrentYearStockInd == null ? 43 : $invtryCurrentYearStockInd.hashCode());
            String $invtryQualInspCurrentYrStkInd = this.invtryQualInspCurrentYrStkInd;
            result = result * 59 + ($invtryQualInspCurrentYrStkInd == null ? 43 : $invtryQualInspCurrentYrStkInd.hashCode());
            String $inventoryBlockStockInd = this.inventoryBlockStockInd;
            result = result * 59 + ($inventoryBlockStockInd == null ? 43 : $inventoryBlockStockInd.hashCode());
            String $invtryRestStockPrevPeriodInd = this.invtryRestStockPrevPeriodInd;
            result = result * 59 + ($invtryRestStockPrevPeriodInd == null ? 43 : $invtryRestStockPrevPeriodInd.hashCode());
            String $inventoryStockPrevPeriod = this.inventoryStockPrevPeriod;
            result = result * 59 + ($inventoryStockPrevPeriod == null ? 43 : $inventoryStockPrevPeriod.hashCode());
            String $invtryStockQltyInspPrevPeriod = this.invtryStockQltyInspPrevPeriod;
            result = result * 59 + ($invtryStockQltyInspPrevPeriod == null ? 43 : $invtryStockQltyInspPrevPeriod.hashCode());
            String $hasInvtryBlockStockPrevPeriod = this.hasInvtryBlockStockPrevPeriod;
            result = result * 59 + ($hasInvtryBlockStockPrevPeriod == null ? 43 : $hasInvtryBlockStockPrevPeriod.hashCode());
            String $fiscalYearCurrentPeriod = this.fiscalYearCurrentPeriod;
            result = result * 59 + ($fiscalYearCurrentPeriod == null ? 43 : $fiscalYearCurrentPeriod.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $fiscalMonthCurrentPeriod = this.fiscalMonthCurrentPeriod;
            result = result * 59 + ($fiscalMonthCurrentPeriod == null ? 43 : $fiscalMonthCurrentPeriod.hashCode());
            String $fiscalYearCurrentInvtryPeriod = this.fiscalYearCurrentInvtryPeriod;
            result = result * 59 + ($fiscalYearCurrentInvtryPeriod == null ? 43 : $fiscalYearCurrentInvtryPeriod.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $warehouseStorageBin = this.warehouseStorageBin;
            result = result * 59 + ($warehouseStorageBin == null ? 43 : $warehouseStorageBin.hashCode());
            String $maintenanceStatus = this.maintenanceStatus;
            result = result * 59 + ($maintenanceStatus == null ? 43 : $maintenanceStatus.hashCode());
            String $physicalInventoryBlockInd = this.physicalInventoryBlockInd;
            result = result * 59 + ($physicalInventoryBlockInd == null ? 43 : $physicalInventoryBlockInd.hashCode());
            Calendar $creationDate = this.creationDate;
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            Boolean $isMarkedForDeletion = this.isMarkedForDeletion;
            result = result * 59 + ($isMarkedForDeletion == null ? 43 : ((Object)$isMarkedForDeletion).hashCode());
            Calendar $dateOfLastPostedCntUnRstrcdStk = this.dateOfLastPostedCntUnRstrcdStk;
            result = result * 59 + ($dateOfLastPostedCntUnRstrcdStk == null ? 43 : ((Object)$dateOfLastPostedCntUnRstrcdStk).hashCode());
            return result;
        }

        public String getProduct() {
            return this.product;
        }

        public ProductStorageLocation setProduct(String product) {
            this.product = product;
            return this;
        }

        public Double getInventoryCorrectionFactor() {
            return this.inventoryCorrectionFactor;
        }

        public ProductStorageLocation setInventoryCorrectionFactor(Double inventoryCorrectionFactor) {
            this.inventoryCorrectionFactor = inventoryCorrectionFactor;
            return this;
        }

        public String getInvtryRestrictedUseStockInd() {
            return this.invtryRestrictedUseStockInd;
        }

        public ProductStorageLocation setInvtryRestrictedUseStockInd(String invtryRestrictedUseStockInd) {
            this.invtryRestrictedUseStockInd = invtryRestrictedUseStockInd;
            return this;
        }

        public String getInvtryCurrentYearStockInd() {
            return this.invtryCurrentYearStockInd;
        }

        public ProductStorageLocation setInvtryCurrentYearStockInd(String invtryCurrentYearStockInd) {
            this.invtryCurrentYearStockInd = invtryCurrentYearStockInd;
            return this;
        }

        public String getInvtryQualInspCurrentYrStkInd() {
            return this.invtryQualInspCurrentYrStkInd;
        }

        public ProductStorageLocation setInvtryQualInspCurrentYrStkInd(String invtryQualInspCurrentYrStkInd) {
            this.invtryQualInspCurrentYrStkInd = invtryQualInspCurrentYrStkInd;
            return this;
        }

        public String getInventoryBlockStockInd() {
            return this.inventoryBlockStockInd;
        }

        public ProductStorageLocation setInventoryBlockStockInd(String inventoryBlockStockInd) {
            this.inventoryBlockStockInd = inventoryBlockStockInd;
            return this;
        }

        public String getInvtryRestStockPrevPeriodInd() {
            return this.invtryRestStockPrevPeriodInd;
        }

        public ProductStorageLocation setInvtryRestStockPrevPeriodInd(String invtryRestStockPrevPeriodInd) {
            this.invtryRestStockPrevPeriodInd = invtryRestStockPrevPeriodInd;
            return this;
        }

        public String getInventoryStockPrevPeriod() {
            return this.inventoryStockPrevPeriod;
        }

        public ProductStorageLocation setInventoryStockPrevPeriod(String inventoryStockPrevPeriod) {
            this.inventoryStockPrevPeriod = inventoryStockPrevPeriod;
            return this;
        }

        public String getInvtryStockQltyInspPrevPeriod() {
            return this.invtryStockQltyInspPrevPeriod;
        }

        public ProductStorageLocation setInvtryStockQltyInspPrevPeriod(String invtryStockQltyInspPrevPeriod) {
            this.invtryStockQltyInspPrevPeriod = invtryStockQltyInspPrevPeriod;
            return this;
        }

        public String getHasInvtryBlockStockPrevPeriod() {
            return this.hasInvtryBlockStockPrevPeriod;
        }

        public ProductStorageLocation setHasInvtryBlockStockPrevPeriod(String hasInvtryBlockStockPrevPeriod) {
            this.hasInvtryBlockStockPrevPeriod = hasInvtryBlockStockPrevPeriod;
            return this;
        }

        public String getFiscalYearCurrentPeriod() {
            return this.fiscalYearCurrentPeriod;
        }

        public ProductStorageLocation setFiscalYearCurrentPeriod(String fiscalYearCurrentPeriod) {
            this.fiscalYearCurrentPeriod = fiscalYearCurrentPeriod;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public ProductStorageLocation setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getFiscalMonthCurrentPeriod() {
            return this.fiscalMonthCurrentPeriod;
        }

        public ProductStorageLocation setFiscalMonthCurrentPeriod(String fiscalMonthCurrentPeriod) {
            this.fiscalMonthCurrentPeriod = fiscalMonthCurrentPeriod;
            return this;
        }

        public String getFiscalYearCurrentInvtryPeriod() {
            return this.fiscalYearCurrentInvtryPeriod;
        }

        public ProductStorageLocation setFiscalYearCurrentInvtryPeriod(String fiscalYearCurrentInvtryPeriod) {
            this.fiscalYearCurrentInvtryPeriod = fiscalYearCurrentInvtryPeriod;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public ProductStorageLocation setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getWarehouseStorageBin() {
            return this.warehouseStorageBin;
        }

        public ProductStorageLocation setWarehouseStorageBin(String warehouseStorageBin) {
            this.warehouseStorageBin = warehouseStorageBin;
            return this;
        }

        public String getMaintenanceStatus() {
            return this.maintenanceStatus;
        }

        public ProductStorageLocation setMaintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
            return this;
        }

        public String getPhysicalInventoryBlockInd() {
            return this.physicalInventoryBlockInd;
        }

        public ProductStorageLocation setPhysicalInventoryBlockInd(String physicalInventoryBlockInd) {
            this.physicalInventoryBlockInd = physicalInventoryBlockInd;
            return this;
        }

        public Calendar getCreationDate() {
            return this.creationDate;
        }

        public ProductStorageLocation setCreationDate(Calendar creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Boolean getIsMarkedForDeletion() {
            return this.isMarkedForDeletion;
        }

        public ProductStorageLocation setIsMarkedForDeletion(Boolean isMarkedForDeletion) {
            this.isMarkedForDeletion = isMarkedForDeletion;
            return this;
        }

        public Calendar getDateOfLastPostedCntUnRstrcdStk() {
            return this.dateOfLastPostedCntUnRstrcdStk;
        }

        public ProductStorageLocation setDateOfLastPostedCntUnRstrcdStk(Calendar dateOfLastPostedCntUnRstrcdStk) {
            this.dateOfLastPostedCntUnRstrcdStk = dateOfLastPostedCntUnRstrcdStk;
            return this;
        }

        public ProductStorageLocation setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProductSalesTaxFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductSalesTax");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProductSalesTaxFluentHelper filter(ExpressionFluentHelper<ProductSalesTax> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProductSalesTaxFluentHelper orderBy(EntityField<?, ProductSalesTax> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProductSalesTaxFluentHelper select(EntityField<?, ProductSalesTax> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProductSalesTaxFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProductSalesTaxFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProductSalesTaxFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProductSalesTax> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProductSalesTax.class);
            for (ProductSalesTax entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProductSalesTaxByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProductSalesTaxByKeyFluentHelper(String product, String country, String taxCategory, String taxClassification) {
            this.values.add(product);
            this.values.add(country);
            this.values.add(taxCategory);
            this.values.add(taxClassification);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductSalesTax");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Product", this.values.get(0));
            keys.put("Country", this.values.get(1));
            keys.put("TaxCategory", this.values.get(2));
            keys.put("TaxClassification", this.values.get(3));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProductSalesTaxByKeyFluentHelper select(EntityField<?, ProductSalesTax> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProductSalesTaxByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProductSalesTax execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProductSalesTax entity = (ProductSalesTax)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProductSalesTax.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProductSalesTax {
        @ElementName(value="Product")
        private String product;
        public static EntityField<String, ProductSalesTax> PRODUCT = new EntityField("Product");
        @ElementName(value="Country")
        private String country;
        public static EntityField<String, ProductSalesTax> COUNTRY = new EntityField("Country");
        @ElementName(value="TaxCategory")
        private String taxCategory;
        public static EntityField<String, ProductSalesTax> TAX_CATEGORY = new EntityField("TaxCategory");
        @ElementName(value="TaxClassification")
        private String taxClassification;
        public static EntityField<String, ProductSalesTax> TAX_CLASSIFICATION = new EntityField("TaxClassification");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PRODUCT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProductSalesTax";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ProductMasterNamespace.ProductSalesTax(product=" + this.product + ", country=" + this.country + ", taxCategory=" + this.taxCategory + ", taxClassification=" + this.taxClassification + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProductSalesTax)) {
                return false;
            }
            ProductSalesTax other = (ProductSalesTax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.product;
            String other$product = other.product;
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$country = this.country;
            String other$country = other.country;
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            String this$taxCategory = this.taxCategory;
            String other$taxCategory = other.taxCategory;
            if (this$taxCategory == null ? other$taxCategory != null : !this$taxCategory.equals(other$taxCategory)) {
                return false;
            }
            String this$taxClassification = this.taxClassification;
            String other$taxClassification = other.taxClassification;
            return !(this$taxClassification == null ? other$taxClassification != null : !this$taxClassification.equals(other$taxClassification));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProductSalesTax;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.product;
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $country = this.country;
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            String $taxCategory = this.taxCategory;
            result = result * 59 + ($taxCategory == null ? 43 : $taxCategory.hashCode());
            String $taxClassification = this.taxClassification;
            result = result * 59 + ($taxClassification == null ? 43 : $taxClassification.hashCode());
            return result;
        }

        public String getProduct() {
            return this.product;
        }

        public ProductSalesTax setProduct(String product) {
            this.product = product;
            return this;
        }

        public String getCountry() {
            return this.country;
        }

        public ProductSalesTax setCountry(String country) {
            this.country = country;
            return this;
        }

        public String getTaxCategory() {
            return this.taxCategory;
        }

        public ProductSalesTax setTaxCategory(String taxCategory) {
            this.taxCategory = taxCategory;
            return this;
        }

        public String getTaxClassification() {
            return this.taxClassification;
        }

        public ProductSalesTax setTaxClassification(String taxClassification) {
            this.taxClassification = taxClassification;
            return this;
        }

        public ProductSalesTax setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProductSalesDeliveryFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductSalesDelivery");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProductSalesDeliveryFluentHelper filter(ExpressionFluentHelper<ProductSalesDelivery> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProductSalesDeliveryFluentHelper orderBy(EntityField<?, ProductSalesDelivery> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProductSalesDeliveryFluentHelper select(EntityField<?, ProductSalesDelivery> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProductSalesDeliveryFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProductSalesDeliveryFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProductSalesDeliveryFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProductSalesDelivery> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProductSalesDelivery.class);
            for (ProductSalesDelivery entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProductSalesDeliveryByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProductSalesDeliveryByKeyFluentHelper(String product, String productSalesOrg, String productDistributionChnl) {
            this.values.add(product);
            this.values.add(productSalesOrg);
            this.values.add(productDistributionChnl);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductSalesDelivery");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Product", this.values.get(0));
            keys.put("ProductSalesOrg", this.values.get(1));
            keys.put("ProductDistributionChnl", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProductSalesDeliveryByKeyFluentHelper select(EntityField<?, ProductSalesDelivery> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProductSalesDeliveryByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProductSalesDelivery execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProductSalesDelivery entity = (ProductSalesDelivery)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProductSalesDelivery.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProductSalesDelivery {
        @ElementName(value="Product")
        private String product;
        public static EntityField<String, ProductSalesDelivery> PRODUCT = new EntityField("Product");
        @ElementName(value="DeliveryQuantityUnit")
        private String deliveryQuantityUnit;
        public static EntityField<String, ProductSalesDelivery> DELIVERY_QUANTITY_UNIT = new EntityField("DeliveryQuantityUnit");
        @ElementName(value="DeliveryQuantity")
        private BigDecimal deliveryQuantity;
        public static EntityField<BigDecimal, ProductSalesDelivery> DELIVERY_QUANTITY = new EntityField("DeliveryQuantity");
        @ElementName(value="ProductSalesStatus")
        private String productSalesStatus;
        public static EntityField<String, ProductSalesDelivery> PRODUCT_SALES_STATUS = new EntityField("ProductSalesStatus");
        @ElementName(value="ProductSalesStatusValidityDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar productSalesStatusValidityDate;
        public static EntityField<Calendar, ProductSalesDelivery> PRODUCT_SALES_STATUS_VALIDITY_DATE = new EntityField("ProductSalesStatusValidityDate");
        @ElementName(value="SalesMeasureUnit")
        private String salesMeasureUnit;
        public static EntityField<String, ProductSalesDelivery> SALES_MEASURE_UNIT = new EntityField("SalesMeasureUnit");
        @ElementName(value="IsMarkedForDeletion")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isMarkedForDeletion;
        public static EntityField<Boolean, ProductSalesDelivery> IS_MARKED_FOR_DELETION = new EntityField("IsMarkedForDeletion");
        @ElementName(value="ProductHierarchy")
        private String productHierarchy;
        public static EntityField<String, ProductSalesDelivery> PRODUCT_HIERARCHY = new EntityField("ProductHierarchy");
        @ElementName(value="FirstSalesSpecProductGroup")
        private String firstSalesSpecProductGroup;
        public static EntityField<String, ProductSalesDelivery> FIRST_SALES_SPEC_PRODUCT_GROUP = new EntityField("FirstSalesSpecProductGroup");
        @ElementName(value="SecondSalesSpecProductGroup")
        private String secondSalesSpecProductGroup;
        public static EntityField<String, ProductSalesDelivery> SECOND_SALES_SPEC_PRODUCT_GROUP = new EntityField("SecondSalesSpecProductGroup");
        @ElementName(value="ThirdSalesSpecProductGroup")
        private String thirdSalesSpecProductGroup;
        public static EntityField<String, ProductSalesDelivery> THIRD_SALES_SPEC_PRODUCT_GROUP = new EntityField("ThirdSalesSpecProductGroup");
        @ElementName(value="ProductSalesOrg")
        private String productSalesOrg;
        public static EntityField<String, ProductSalesDelivery> PRODUCT_SALES_ORG = new EntityField("ProductSalesOrg");
        @ElementName(value="FourthSalesSpecProductGroup")
        private String fourthSalesSpecProductGroup;
        public static EntityField<String, ProductSalesDelivery> FOURTH_SALES_SPEC_PRODUCT_GROUP = new EntityField("FourthSalesSpecProductGroup");
        @ElementName(value="FifthSalesSpecProductGroup")
        private String fifthSalesSpecProductGroup;
        public static EntityField<String, ProductSalesDelivery> FIFTH_SALES_SPEC_PRODUCT_GROUP = new EntityField("FifthSalesSpecProductGroup");
        @ElementName(value="MinimumMakeToOrderOrderQty")
        private BigDecimal minimumMakeToOrderOrderQty;
        public static EntityField<BigDecimal, ProductSalesDelivery> MINIMUM_MAKE_TO_ORDER_ORDER_QTY = new EntityField("MinimumMakeToOrderOrderQty");
        @ElementName(value="ProductDistributionChnl")
        private String productDistributionChnl;
        public static EntityField<String, ProductSalesDelivery> PRODUCT_DISTRIBUTION_CHNL = new EntityField("ProductDistributionChnl");
        @ElementName(value="MinimumOrderQuantity")
        private BigDecimal minimumOrderQuantity;
        public static EntityField<BigDecimal, ProductSalesDelivery> MINIMUM_ORDER_QUANTITY = new EntityField("MinimumOrderQuantity");
        @ElementName(value="SupplyingPlant")
        private String supplyingPlant;
        public static EntityField<String, ProductSalesDelivery> SUPPLYING_PLANT = new EntityField("SupplyingPlant");
        @ElementName(value="PriceSpecificationProductGroup")
        private String priceSpecificationProductGroup;
        public static EntityField<String, ProductSalesDelivery> PRICE_SPECIFICATION_PRODUCT_GROUP = new EntityField("PriceSpecificationProductGroup");
        @ElementName(value="AccountDetnProductGroup")
        private String accountDetnProductGroup;
        public static EntityField<String, ProductSalesDelivery> ACCOUNT_DETN_PRODUCT_GROUP = new EntityField("AccountDetnProductGroup");
        @ElementName(value="DeliveryNoteProcMinDelivQty")
        private BigDecimal deliveryNoteProcMinDelivQty;
        public static EntityField<BigDecimal, ProductSalesDelivery> DELIVERY_NOTE_PROC_MIN_DELIV_QTY = new EntityField("DeliveryNoteProcMinDelivQty");
        @ElementName(value="ItemCategoryGroup")
        private String itemCategoryGroup;
        public static EntityField<String, ProductSalesDelivery> ITEM_CATEGORY_GROUP = new EntityField("ItemCategoryGroup");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PRODUCT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProductSalesDelivery";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ProductMasterNamespace.ProductSalesDelivery(product=" + this.product + ", deliveryQuantityUnit=" + this.deliveryQuantityUnit + ", deliveryQuantity=" + this.deliveryQuantity + ", productSalesStatus=" + this.productSalesStatus + ", productSalesStatusValidityDate=" + this.productSalesStatusValidityDate + ", salesMeasureUnit=" + this.salesMeasureUnit + ", isMarkedForDeletion=" + this.isMarkedForDeletion + ", productHierarchy=" + this.productHierarchy + ", firstSalesSpecProductGroup=" + this.firstSalesSpecProductGroup + ", secondSalesSpecProductGroup=" + this.secondSalesSpecProductGroup + ", thirdSalesSpecProductGroup=" + this.thirdSalesSpecProductGroup + ", productSalesOrg=" + this.productSalesOrg + ", fourthSalesSpecProductGroup=" + this.fourthSalesSpecProductGroup + ", fifthSalesSpecProductGroup=" + this.fifthSalesSpecProductGroup + ", minimumMakeToOrderOrderQty=" + this.minimumMakeToOrderOrderQty + ", productDistributionChnl=" + this.productDistributionChnl + ", minimumOrderQuantity=" + this.minimumOrderQuantity + ", supplyingPlant=" + this.supplyingPlant + ", priceSpecificationProductGroup=" + this.priceSpecificationProductGroup + ", accountDetnProductGroup=" + this.accountDetnProductGroup + ", deliveryNoteProcMinDelivQty=" + this.deliveryNoteProcMinDelivQty + ", itemCategoryGroup=" + this.itemCategoryGroup + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProductSalesDelivery)) {
                return false;
            }
            ProductSalesDelivery other = (ProductSalesDelivery)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.product;
            String other$product = other.product;
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$deliveryQuantityUnit = this.deliveryQuantityUnit;
            String other$deliveryQuantityUnit = other.deliveryQuantityUnit;
            if (this$deliveryQuantityUnit == null ? other$deliveryQuantityUnit != null : !this$deliveryQuantityUnit.equals(other$deliveryQuantityUnit)) {
                return false;
            }
            BigDecimal this$deliveryQuantity = this.deliveryQuantity;
            BigDecimal other$deliveryQuantity = other.deliveryQuantity;
            if (this$deliveryQuantity == null ? other$deliveryQuantity != null : !((Object)this$deliveryQuantity).equals(other$deliveryQuantity)) {
                return false;
            }
            String this$productSalesStatus = this.productSalesStatus;
            String other$productSalesStatus = other.productSalesStatus;
            if (this$productSalesStatus == null ? other$productSalesStatus != null : !this$productSalesStatus.equals(other$productSalesStatus)) {
                return false;
            }
            Calendar this$productSalesStatusValidityDate = this.productSalesStatusValidityDate;
            Calendar other$productSalesStatusValidityDate = other.productSalesStatusValidityDate;
            if (this$productSalesStatusValidityDate == null ? other$productSalesStatusValidityDate != null : !((Object)this$productSalesStatusValidityDate).equals(other$productSalesStatusValidityDate)) {
                return false;
            }
            String this$salesMeasureUnit = this.salesMeasureUnit;
            String other$salesMeasureUnit = other.salesMeasureUnit;
            if (this$salesMeasureUnit == null ? other$salesMeasureUnit != null : !this$salesMeasureUnit.equals(other$salesMeasureUnit)) {
                return false;
            }
            Boolean this$isMarkedForDeletion = this.isMarkedForDeletion;
            Boolean other$isMarkedForDeletion = other.isMarkedForDeletion;
            if (this$isMarkedForDeletion == null ? other$isMarkedForDeletion != null : !((Object)this$isMarkedForDeletion).equals(other$isMarkedForDeletion)) {
                return false;
            }
            String this$productHierarchy = this.productHierarchy;
            String other$productHierarchy = other.productHierarchy;
            if (this$productHierarchy == null ? other$productHierarchy != null : !this$productHierarchy.equals(other$productHierarchy)) {
                return false;
            }
            String this$firstSalesSpecProductGroup = this.firstSalesSpecProductGroup;
            String other$firstSalesSpecProductGroup = other.firstSalesSpecProductGroup;
            if (this$firstSalesSpecProductGroup == null ? other$firstSalesSpecProductGroup != null : !this$firstSalesSpecProductGroup.equals(other$firstSalesSpecProductGroup)) {
                return false;
            }
            String this$secondSalesSpecProductGroup = this.secondSalesSpecProductGroup;
            String other$secondSalesSpecProductGroup = other.secondSalesSpecProductGroup;
            if (this$secondSalesSpecProductGroup == null ? other$secondSalesSpecProductGroup != null : !this$secondSalesSpecProductGroup.equals(other$secondSalesSpecProductGroup)) {
                return false;
            }
            String this$thirdSalesSpecProductGroup = this.thirdSalesSpecProductGroup;
            String other$thirdSalesSpecProductGroup = other.thirdSalesSpecProductGroup;
            if (this$thirdSalesSpecProductGroup == null ? other$thirdSalesSpecProductGroup != null : !this$thirdSalesSpecProductGroup.equals(other$thirdSalesSpecProductGroup)) {
                return false;
            }
            String this$productSalesOrg = this.productSalesOrg;
            String other$productSalesOrg = other.productSalesOrg;
            if (this$productSalesOrg == null ? other$productSalesOrg != null : !this$productSalesOrg.equals(other$productSalesOrg)) {
                return false;
            }
            String this$fourthSalesSpecProductGroup = this.fourthSalesSpecProductGroup;
            String other$fourthSalesSpecProductGroup = other.fourthSalesSpecProductGroup;
            if (this$fourthSalesSpecProductGroup == null ? other$fourthSalesSpecProductGroup != null : !this$fourthSalesSpecProductGroup.equals(other$fourthSalesSpecProductGroup)) {
                return false;
            }
            String this$fifthSalesSpecProductGroup = this.fifthSalesSpecProductGroup;
            String other$fifthSalesSpecProductGroup = other.fifthSalesSpecProductGroup;
            if (this$fifthSalesSpecProductGroup == null ? other$fifthSalesSpecProductGroup != null : !this$fifthSalesSpecProductGroup.equals(other$fifthSalesSpecProductGroup)) {
                return false;
            }
            BigDecimal this$minimumMakeToOrderOrderQty = this.minimumMakeToOrderOrderQty;
            BigDecimal other$minimumMakeToOrderOrderQty = other.minimumMakeToOrderOrderQty;
            if (this$minimumMakeToOrderOrderQty == null ? other$minimumMakeToOrderOrderQty != null : !((Object)this$minimumMakeToOrderOrderQty).equals(other$minimumMakeToOrderOrderQty)) {
                return false;
            }
            String this$productDistributionChnl = this.productDistributionChnl;
            String other$productDistributionChnl = other.productDistributionChnl;
            if (this$productDistributionChnl == null ? other$productDistributionChnl != null : !this$productDistributionChnl.equals(other$productDistributionChnl)) {
                return false;
            }
            BigDecimal this$minimumOrderQuantity = this.minimumOrderQuantity;
            BigDecimal other$minimumOrderQuantity = other.minimumOrderQuantity;
            if (this$minimumOrderQuantity == null ? other$minimumOrderQuantity != null : !((Object)this$minimumOrderQuantity).equals(other$minimumOrderQuantity)) {
                return false;
            }
            String this$supplyingPlant = this.supplyingPlant;
            String other$supplyingPlant = other.supplyingPlant;
            if (this$supplyingPlant == null ? other$supplyingPlant != null : !this$supplyingPlant.equals(other$supplyingPlant)) {
                return false;
            }
            String this$priceSpecificationProductGroup = this.priceSpecificationProductGroup;
            String other$priceSpecificationProductGroup = other.priceSpecificationProductGroup;
            if (this$priceSpecificationProductGroup == null ? other$priceSpecificationProductGroup != null : !this$priceSpecificationProductGroup.equals(other$priceSpecificationProductGroup)) {
                return false;
            }
            String this$accountDetnProductGroup = this.accountDetnProductGroup;
            String other$accountDetnProductGroup = other.accountDetnProductGroup;
            if (this$accountDetnProductGroup == null ? other$accountDetnProductGroup != null : !this$accountDetnProductGroup.equals(other$accountDetnProductGroup)) {
                return false;
            }
            BigDecimal this$deliveryNoteProcMinDelivQty = this.deliveryNoteProcMinDelivQty;
            BigDecimal other$deliveryNoteProcMinDelivQty = other.deliveryNoteProcMinDelivQty;
            if (this$deliveryNoteProcMinDelivQty == null ? other$deliveryNoteProcMinDelivQty != null : !((Object)this$deliveryNoteProcMinDelivQty).equals(other$deliveryNoteProcMinDelivQty)) {
                return false;
            }
            String this$itemCategoryGroup = this.itemCategoryGroup;
            String other$itemCategoryGroup = other.itemCategoryGroup;
            return !(this$itemCategoryGroup == null ? other$itemCategoryGroup != null : !this$itemCategoryGroup.equals(other$itemCategoryGroup));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProductSalesDelivery;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.product;
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $deliveryQuantityUnit = this.deliveryQuantityUnit;
            result = result * 59 + ($deliveryQuantityUnit == null ? 43 : $deliveryQuantityUnit.hashCode());
            BigDecimal $deliveryQuantity = this.deliveryQuantity;
            result = result * 59 + ($deliveryQuantity == null ? 43 : ((Object)$deliveryQuantity).hashCode());
            String $productSalesStatus = this.productSalesStatus;
            result = result * 59 + ($productSalesStatus == null ? 43 : $productSalesStatus.hashCode());
            Calendar $productSalesStatusValidityDate = this.productSalesStatusValidityDate;
            result = result * 59 + ($productSalesStatusValidityDate == null ? 43 : ((Object)$productSalesStatusValidityDate).hashCode());
            String $salesMeasureUnit = this.salesMeasureUnit;
            result = result * 59 + ($salesMeasureUnit == null ? 43 : $salesMeasureUnit.hashCode());
            Boolean $isMarkedForDeletion = this.isMarkedForDeletion;
            result = result * 59 + ($isMarkedForDeletion == null ? 43 : ((Object)$isMarkedForDeletion).hashCode());
            String $productHierarchy = this.productHierarchy;
            result = result * 59 + ($productHierarchy == null ? 43 : $productHierarchy.hashCode());
            String $firstSalesSpecProductGroup = this.firstSalesSpecProductGroup;
            result = result * 59 + ($firstSalesSpecProductGroup == null ? 43 : $firstSalesSpecProductGroup.hashCode());
            String $secondSalesSpecProductGroup = this.secondSalesSpecProductGroup;
            result = result * 59 + ($secondSalesSpecProductGroup == null ? 43 : $secondSalesSpecProductGroup.hashCode());
            String $thirdSalesSpecProductGroup = this.thirdSalesSpecProductGroup;
            result = result * 59 + ($thirdSalesSpecProductGroup == null ? 43 : $thirdSalesSpecProductGroup.hashCode());
            String $productSalesOrg = this.productSalesOrg;
            result = result * 59 + ($productSalesOrg == null ? 43 : $productSalesOrg.hashCode());
            String $fourthSalesSpecProductGroup = this.fourthSalesSpecProductGroup;
            result = result * 59 + ($fourthSalesSpecProductGroup == null ? 43 : $fourthSalesSpecProductGroup.hashCode());
            String $fifthSalesSpecProductGroup = this.fifthSalesSpecProductGroup;
            result = result * 59 + ($fifthSalesSpecProductGroup == null ? 43 : $fifthSalesSpecProductGroup.hashCode());
            BigDecimal $minimumMakeToOrderOrderQty = this.minimumMakeToOrderOrderQty;
            result = result * 59 + ($minimumMakeToOrderOrderQty == null ? 43 : ((Object)$minimumMakeToOrderOrderQty).hashCode());
            String $productDistributionChnl = this.productDistributionChnl;
            result = result * 59 + ($productDistributionChnl == null ? 43 : $productDistributionChnl.hashCode());
            BigDecimal $minimumOrderQuantity = this.minimumOrderQuantity;
            result = result * 59 + ($minimumOrderQuantity == null ? 43 : ((Object)$minimumOrderQuantity).hashCode());
            String $supplyingPlant = this.supplyingPlant;
            result = result * 59 + ($supplyingPlant == null ? 43 : $supplyingPlant.hashCode());
            String $priceSpecificationProductGroup = this.priceSpecificationProductGroup;
            result = result * 59 + ($priceSpecificationProductGroup == null ? 43 : $priceSpecificationProductGroup.hashCode());
            String $accountDetnProductGroup = this.accountDetnProductGroup;
            result = result * 59 + ($accountDetnProductGroup == null ? 43 : $accountDetnProductGroup.hashCode());
            BigDecimal $deliveryNoteProcMinDelivQty = this.deliveryNoteProcMinDelivQty;
            result = result * 59 + ($deliveryNoteProcMinDelivQty == null ? 43 : ((Object)$deliveryNoteProcMinDelivQty).hashCode());
            String $itemCategoryGroup = this.itemCategoryGroup;
            result = result * 59 + ($itemCategoryGroup == null ? 43 : $itemCategoryGroup.hashCode());
            return result;
        }

        public String getProduct() {
            return this.product;
        }

        public ProductSalesDelivery setProduct(String product) {
            this.product = product;
            return this;
        }

        public String getDeliveryQuantityUnit() {
            return this.deliveryQuantityUnit;
        }

        public ProductSalesDelivery setDeliveryQuantityUnit(String deliveryQuantityUnit) {
            this.deliveryQuantityUnit = deliveryQuantityUnit;
            return this;
        }

        public BigDecimal getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        public ProductSalesDelivery setDeliveryQuantity(BigDecimal deliveryQuantity) {
            this.deliveryQuantity = deliveryQuantity;
            return this;
        }

        public String getProductSalesStatus() {
            return this.productSalesStatus;
        }

        public ProductSalesDelivery setProductSalesStatus(String productSalesStatus) {
            this.productSalesStatus = productSalesStatus;
            return this;
        }

        public Calendar getProductSalesStatusValidityDate() {
            return this.productSalesStatusValidityDate;
        }

        public ProductSalesDelivery setProductSalesStatusValidityDate(Calendar productSalesStatusValidityDate) {
            this.productSalesStatusValidityDate = productSalesStatusValidityDate;
            return this;
        }

        public String getSalesMeasureUnit() {
            return this.salesMeasureUnit;
        }

        public ProductSalesDelivery setSalesMeasureUnit(String salesMeasureUnit) {
            this.salesMeasureUnit = salesMeasureUnit;
            return this;
        }

        public Boolean getIsMarkedForDeletion() {
            return this.isMarkedForDeletion;
        }

        public ProductSalesDelivery setIsMarkedForDeletion(Boolean isMarkedForDeletion) {
            this.isMarkedForDeletion = isMarkedForDeletion;
            return this;
        }

        public String getProductHierarchy() {
            return this.productHierarchy;
        }

        public ProductSalesDelivery setProductHierarchy(String productHierarchy) {
            this.productHierarchy = productHierarchy;
            return this;
        }

        public String getFirstSalesSpecProductGroup() {
            return this.firstSalesSpecProductGroup;
        }

        public ProductSalesDelivery setFirstSalesSpecProductGroup(String firstSalesSpecProductGroup) {
            this.firstSalesSpecProductGroup = firstSalesSpecProductGroup;
            return this;
        }

        public String getSecondSalesSpecProductGroup() {
            return this.secondSalesSpecProductGroup;
        }

        public ProductSalesDelivery setSecondSalesSpecProductGroup(String secondSalesSpecProductGroup) {
            this.secondSalesSpecProductGroup = secondSalesSpecProductGroup;
            return this;
        }

        public String getThirdSalesSpecProductGroup() {
            return this.thirdSalesSpecProductGroup;
        }

        public ProductSalesDelivery setThirdSalesSpecProductGroup(String thirdSalesSpecProductGroup) {
            this.thirdSalesSpecProductGroup = thirdSalesSpecProductGroup;
            return this;
        }

        public String getProductSalesOrg() {
            return this.productSalesOrg;
        }

        public ProductSalesDelivery setProductSalesOrg(String productSalesOrg) {
            this.productSalesOrg = productSalesOrg;
            return this;
        }

        public String getFourthSalesSpecProductGroup() {
            return this.fourthSalesSpecProductGroup;
        }

        public ProductSalesDelivery setFourthSalesSpecProductGroup(String fourthSalesSpecProductGroup) {
            this.fourthSalesSpecProductGroup = fourthSalesSpecProductGroup;
            return this;
        }

        public String getFifthSalesSpecProductGroup() {
            return this.fifthSalesSpecProductGroup;
        }

        public ProductSalesDelivery setFifthSalesSpecProductGroup(String fifthSalesSpecProductGroup) {
            this.fifthSalesSpecProductGroup = fifthSalesSpecProductGroup;
            return this;
        }

        public BigDecimal getMinimumMakeToOrderOrderQty() {
            return this.minimumMakeToOrderOrderQty;
        }

        public ProductSalesDelivery setMinimumMakeToOrderOrderQty(BigDecimal minimumMakeToOrderOrderQty) {
            this.minimumMakeToOrderOrderQty = minimumMakeToOrderOrderQty;
            return this;
        }

        public String getProductDistributionChnl() {
            return this.productDistributionChnl;
        }

        public ProductSalesDelivery setProductDistributionChnl(String productDistributionChnl) {
            this.productDistributionChnl = productDistributionChnl;
            return this;
        }

        public BigDecimal getMinimumOrderQuantity() {
            return this.minimumOrderQuantity;
        }

        public ProductSalesDelivery setMinimumOrderQuantity(BigDecimal minimumOrderQuantity) {
            this.minimumOrderQuantity = minimumOrderQuantity;
            return this;
        }

        public String getSupplyingPlant() {
            return this.supplyingPlant;
        }

        public ProductSalesDelivery setSupplyingPlant(String supplyingPlant) {
            this.supplyingPlant = supplyingPlant;
            return this;
        }

        public String getPriceSpecificationProductGroup() {
            return this.priceSpecificationProductGroup;
        }

        public ProductSalesDelivery setPriceSpecificationProductGroup(String priceSpecificationProductGroup) {
            this.priceSpecificationProductGroup = priceSpecificationProductGroup;
            return this;
        }

        public String getAccountDetnProductGroup() {
            return this.accountDetnProductGroup;
        }

        public ProductSalesDelivery setAccountDetnProductGroup(String accountDetnProductGroup) {
            this.accountDetnProductGroup = accountDetnProductGroup;
            return this;
        }

        public BigDecimal getDeliveryNoteProcMinDelivQty() {
            return this.deliveryNoteProcMinDelivQty;
        }

        public ProductSalesDelivery setDeliveryNoteProcMinDelivQty(BigDecimal deliveryNoteProcMinDelivQty) {
            this.deliveryNoteProcMinDelivQty = deliveryNoteProcMinDelivQty;
            return this;
        }

        public String getItemCategoryGroup() {
            return this.itemCategoryGroup;
        }

        public ProductSalesDelivery setItemCategoryGroup(String itemCategoryGroup) {
            this.itemCategoryGroup = itemCategoryGroup;
            return this;
        }

        public ProductSalesDelivery setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProductPlantFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductPlant");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProductPlantFluentHelper filter(ExpressionFluentHelper<ProductPlant> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProductPlantFluentHelper orderBy(EntityField<?, ProductPlant> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProductPlantFluentHelper select(EntityField<?, ProductPlant> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProductPlantFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProductPlantFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProductPlantFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProductPlant> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProductPlant.class);
            for (ProductPlant entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProductPlantByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProductPlantByKeyFluentHelper(String product, String plant) {
            this.values.add(product);
            this.values.add(plant);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductPlant");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Product", this.values.get(0));
            keys.put("Plant", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProductPlantByKeyFluentHelper select(EntityField<?, ProductPlant> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProductPlantByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProductPlant execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProductPlant entity = (ProductPlant)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProductPlant.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProductPlant {
        @ElementName(value="Product")
        private String product;
        public static EntityField<String, ProductPlant> PRODUCT = new EntityField("Product");
        @ElementName(value="FiscalYearVariant")
        private String fiscalYearVariant;
        public static EntityField<String, ProductPlant> FISCAL_YEAR_VARIANT = new EntityField("FiscalYearVariant");
        @ElementName(value="PeriodType")
        private String periodType;
        public static EntityField<String, ProductPlant> PERIOD_TYPE = new EntityField("PeriodType");
        @ElementName(value="ProfitCenter")
        private String profitCenter;
        public static EntityField<String, ProductPlant> PROFIT_CENTER = new EntityField("ProfitCenter");
        @ElementName(value="Commodity")
        private String commodity;
        public static EntityField<String, ProductPlant> COMMODITY = new EntityField("Commodity");
        @ElementName(value="GoodsReceiptDuration")
        private BigDecimal goodsReceiptDuration;
        public static EntityField<BigDecimal, ProductPlant> GOODS_RECEIPT_DURATION = new EntityField("GoodsReceiptDuration");
        @ElementName(value="MaintenanceStatusName")
        private String maintenanceStatusName;
        public static EntityField<String, ProductPlant> MAINTENANCE_STATUS_NAME = new EntityField("MaintenanceStatusName");
        @ElementName(value="IsMarkedForDeletion")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isMarkedForDeletion;
        public static EntityField<Boolean, ProductPlant> IS_MARKED_FOR_DELETION = new EntityField("IsMarkedForDeletion");
        @ElementName(value="MRPType")
        private String mRPType;
        public static EntityField<String, ProductPlant> M_R_P_TYPE = new EntityField("MRPType");
        @ElementName(value="MRPResponsible")
        private String mRPResponsible;
        public static EntityField<String, ProductPlant> M_R_P_RESPONSIBLE = new EntityField("MRPResponsible");
        @ElementName(value="ABCIndicator")
        private String aBCIndicator;
        public static EntityField<String, ProductPlant> A_B_C_INDICATOR = new EntityField("ABCIndicator");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, ProductPlant> PLANT = new EntityField("Plant");
        @ElementName(value="MinimumLotSizeQuantity")
        private BigDecimal minimumLotSizeQuantity;
        public static EntityField<BigDecimal, ProductPlant> MINIMUM_LOT_SIZE_QUANTITY = new EntityField("MinimumLotSizeQuantity");
        @ElementName(value="MaximumLotSizeQuantity")
        private BigDecimal maximumLotSizeQuantity;
        public static EntityField<BigDecimal, ProductPlant> MAXIMUM_LOT_SIZE_QUANTITY = new EntityField("MaximumLotSizeQuantity");
        @ElementName(value="FixedLotSizeQuantity")
        private BigDecimal fixedLotSizeQuantity;
        public static EntityField<BigDecimal, ProductPlant> FIXED_LOT_SIZE_QUANTITY = new EntityField("FixedLotSizeQuantity");
        @ElementName(value="ConsumptionTaxCtrlCode")
        private String consumptionTaxCtrlCode;
        public static EntityField<String, ProductPlant> CONSUMPTION_TAX_CTRL_CODE = new EntityField("ConsumptionTaxCtrlCode");
        @ElementName(value="IsCoProduct")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isCoProduct;
        public static EntityField<Boolean, ProductPlant> IS_CO_PRODUCT = new EntityField("IsCoProduct");
        @ElementName(value="ProductIsConfigurable")
        private String productIsConfigurable;
        public static EntityField<String, ProductPlant> PRODUCT_IS_CONFIGURABLE = new EntityField("ProductIsConfigurable");
        @ElementName(value="StockDeterminationGroup")
        private String stockDeterminationGroup;
        public static EntityField<String, ProductPlant> STOCK_DETERMINATION_GROUP = new EntityField("StockDeterminationGroup");
        @ElementName(value="StockInTransferQuantity")
        private BigDecimal stockInTransferQuantity;
        public static EntityField<BigDecimal, ProductPlant> STOCK_IN_TRANSFER_QUANTITY = new EntityField("StockInTransferQuantity");
        @ElementName(value="StockInTransitQuantity")
        private BigDecimal stockInTransitQuantity;
        public static EntityField<BigDecimal, ProductPlant> STOCK_IN_TRANSIT_QUANTITY = new EntityField("StockInTransitQuantity");
        @ElementName(value="HasPostToInspectionStock")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean hasPostToInspectionStock;
        public static EntityField<Boolean, ProductPlant> HAS_POST_TO_INSPECTION_STOCK = new EntityField("HasPostToInspectionStock");
        @ElementName(value="PurchasingGroup")
        private String purchasingGroup;
        public static EntityField<String, ProductPlant> PURCHASING_GROUP = new EntityField("PurchasingGroup");
        @ElementName(value="IsBatchManagementRequired")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isBatchManagementRequired;
        public static EntityField<Boolean, ProductPlant> IS_BATCH_MANAGEMENT_REQUIRED = new EntityField("IsBatchManagementRequired");
        @ElementName(value="SerialNumberProfile")
        private String serialNumberProfile;
        public static EntityField<String, ProductPlant> SERIAL_NUMBER_PROFILE = new EntityField("SerialNumberProfile");
        @ElementName(value="IsNegativeStockAllowed")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isNegativeStockAllowed;
        public static EntityField<Boolean, ProductPlant> IS_NEGATIVE_STOCK_ALLOWED = new EntityField("IsNegativeStockAllowed");
        @ElementName(value="GoodsReceiptBlockedStockQty")
        private BigDecimal goodsReceiptBlockedStockQty;
        public static EntityField<BigDecimal, ProductPlant> GOODS_RECEIPT_BLOCKED_STOCK_QTY = new EntityField("GoodsReceiptBlockedStockQty");
        @ElementName(value="HasConsignmentCtrl")
        private String hasConsignmentCtrl;
        public static EntityField<String, ProductPlant> HAS_CONSIGNMENT_CTRL = new EntityField("HasConsignmentCtrl");
        @ElementName(value="FiscalYearCurrentPeriod")
        private String fiscalYearCurrentPeriod;
        public static EntityField<String, ProductPlant> FISCAL_YEAR_CURRENT_PERIOD = new EntityField("FiscalYearCurrentPeriod");
        @ElementName(value="FiscalMonthCurrentPeriod")
        private String fiscalMonthCurrentPeriod;
        public static EntityField<String, ProductPlant> FISCAL_MONTH_CURRENT_PERIOD = new EntityField("FiscalMonthCurrentPeriod");
        @ElementName(value="ProcurementType")
        private String procurementType;
        public static EntityField<String, ProductPlant> PROCUREMENT_TYPE = new EntityField("ProcurementType");
        @ElementName(value="IsInternalBatchManaged")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isInternalBatchManaged;
        public static EntityField<Boolean, ProductPlant> IS_INTERNAL_BATCH_MANAGED = new EntityField("IsInternalBatchManaged");
        @ElementName(value="ProductCFOPCategory")
        private String productCFOPCategory;
        public static EntityField<String, ProductPlant> PRODUCT_C_F_O_P_CATEGORY = new EntityField("ProductCFOPCategory");
        @ElementName(value="CountryOfOrigin")
        private String countryOfOrigin;
        public static EntityField<String, ProductPlant> COUNTRY_OF_ORIGIN = new EntityField("CountryOfOrigin");
        @ElementName(value="RegionOfOrigin")
        private String regionOfOrigin;
        public static EntityField<String, ProductPlant> REGION_OF_ORIGIN = new EntityField("RegionOfOrigin");
        @ElementName(value="ProductionInvtryManagedLoc")
        private String productionInvtryManagedLoc;
        public static EntityField<String, ProductPlant> PRODUCTION_INVTRY_MANAGED_LOC = new EntityField("ProductionInvtryManagedLoc");
        @ElementName(value="ProfileCode")
        private String profileCode;
        public static EntityField<String, ProductPlant> PROFILE_CODE = new EntityField("ProfileCode");
        @ElementName(value="ProfileValidityStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar profileValidityStartDate;
        public static EntityField<Calendar, ProductPlant> PROFILE_VALIDITY_START_DATE = new EntityField("ProfileValidityStartDate");
        @ElementName(value="AvailabilityCheckType")
        private String availabilityCheckType;
        public static EntityField<String, ProductPlant> AVAILABILITY_CHECK_TYPE = new EntityField("AvailabilityCheckType");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PRODUCT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProductPlant";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<ProductStorageLocation> fetchStorageLocation() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("Product=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.product));
            odataResourceUrl.append(",Plant=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.plant));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_StorageLocation");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProductStorageLocation.class);
            for (ProductStorageLocation entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ProductMasterNamespace.ProductPlant(product=" + this.product + ", fiscalYearVariant=" + this.fiscalYearVariant + ", periodType=" + this.periodType + ", profitCenter=" + this.profitCenter + ", commodity=" + this.commodity + ", goodsReceiptDuration=" + this.goodsReceiptDuration + ", maintenanceStatusName=" + this.maintenanceStatusName + ", isMarkedForDeletion=" + this.isMarkedForDeletion + ", mRPType=" + this.mRPType + ", mRPResponsible=" + this.mRPResponsible + ", aBCIndicator=" + this.aBCIndicator + ", plant=" + this.plant + ", minimumLotSizeQuantity=" + this.minimumLotSizeQuantity + ", maximumLotSizeQuantity=" + this.maximumLotSizeQuantity + ", fixedLotSizeQuantity=" + this.fixedLotSizeQuantity + ", consumptionTaxCtrlCode=" + this.consumptionTaxCtrlCode + ", isCoProduct=" + this.isCoProduct + ", productIsConfigurable=" + this.productIsConfigurable + ", stockDeterminationGroup=" + this.stockDeterminationGroup + ", stockInTransferQuantity=" + this.stockInTransferQuantity + ", stockInTransitQuantity=" + this.stockInTransitQuantity + ", hasPostToInspectionStock=" + this.hasPostToInspectionStock + ", purchasingGroup=" + this.purchasingGroup + ", isBatchManagementRequired=" + this.isBatchManagementRequired + ", serialNumberProfile=" + this.serialNumberProfile + ", isNegativeStockAllowed=" + this.isNegativeStockAllowed + ", goodsReceiptBlockedStockQty=" + this.goodsReceiptBlockedStockQty + ", hasConsignmentCtrl=" + this.hasConsignmentCtrl + ", fiscalYearCurrentPeriod=" + this.fiscalYearCurrentPeriod + ", fiscalMonthCurrentPeriod=" + this.fiscalMonthCurrentPeriod + ", procurementType=" + this.procurementType + ", isInternalBatchManaged=" + this.isInternalBatchManaged + ", productCFOPCategory=" + this.productCFOPCategory + ", countryOfOrigin=" + this.countryOfOrigin + ", regionOfOrigin=" + this.regionOfOrigin + ", productionInvtryManagedLoc=" + this.productionInvtryManagedLoc + ", profileCode=" + this.profileCode + ", profileValidityStartDate=" + this.profileValidityStartDate + ", availabilityCheckType=" + this.availabilityCheckType + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProductPlant)) {
                return false;
            }
            ProductPlant other = (ProductPlant)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.product;
            String other$product = other.product;
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$fiscalYearVariant = this.fiscalYearVariant;
            String other$fiscalYearVariant = other.fiscalYearVariant;
            if (this$fiscalYearVariant == null ? other$fiscalYearVariant != null : !this$fiscalYearVariant.equals(other$fiscalYearVariant)) {
                return false;
            }
            String this$periodType = this.periodType;
            String other$periodType = other.periodType;
            if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) {
                return false;
            }
            String this$profitCenter = this.profitCenter;
            String other$profitCenter = other.profitCenter;
            if (this$profitCenter == null ? other$profitCenter != null : !this$profitCenter.equals(other$profitCenter)) {
                return false;
            }
            String this$commodity = this.commodity;
            String other$commodity = other.commodity;
            if (this$commodity == null ? other$commodity != null : !this$commodity.equals(other$commodity)) {
                return false;
            }
            BigDecimal this$goodsReceiptDuration = this.goodsReceiptDuration;
            BigDecimal other$goodsReceiptDuration = other.goodsReceiptDuration;
            if (this$goodsReceiptDuration == null ? other$goodsReceiptDuration != null : !((Object)this$goodsReceiptDuration).equals(other$goodsReceiptDuration)) {
                return false;
            }
            String this$maintenanceStatusName = this.maintenanceStatusName;
            String other$maintenanceStatusName = other.maintenanceStatusName;
            if (this$maintenanceStatusName == null ? other$maintenanceStatusName != null : !this$maintenanceStatusName.equals(other$maintenanceStatusName)) {
                return false;
            }
            Boolean this$isMarkedForDeletion = this.isMarkedForDeletion;
            Boolean other$isMarkedForDeletion = other.isMarkedForDeletion;
            if (this$isMarkedForDeletion == null ? other$isMarkedForDeletion != null : !((Object)this$isMarkedForDeletion).equals(other$isMarkedForDeletion)) {
                return false;
            }
            String this$mRPType = this.mRPType;
            String other$mRPType = other.mRPType;
            if (this$mRPType == null ? other$mRPType != null : !this$mRPType.equals(other$mRPType)) {
                return false;
            }
            String this$mRPResponsible = this.mRPResponsible;
            String other$mRPResponsible = other.mRPResponsible;
            if (this$mRPResponsible == null ? other$mRPResponsible != null : !this$mRPResponsible.equals(other$mRPResponsible)) {
                return false;
            }
            String this$aBCIndicator = this.aBCIndicator;
            String other$aBCIndicator = other.aBCIndicator;
            if (this$aBCIndicator == null ? other$aBCIndicator != null : !this$aBCIndicator.equals(other$aBCIndicator)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            BigDecimal this$minimumLotSizeQuantity = this.minimumLotSizeQuantity;
            BigDecimal other$minimumLotSizeQuantity = other.minimumLotSizeQuantity;
            if (this$minimumLotSizeQuantity == null ? other$minimumLotSizeQuantity != null : !((Object)this$minimumLotSizeQuantity).equals(other$minimumLotSizeQuantity)) {
                return false;
            }
            BigDecimal this$maximumLotSizeQuantity = this.maximumLotSizeQuantity;
            BigDecimal other$maximumLotSizeQuantity = other.maximumLotSizeQuantity;
            if (this$maximumLotSizeQuantity == null ? other$maximumLotSizeQuantity != null : !((Object)this$maximumLotSizeQuantity).equals(other$maximumLotSizeQuantity)) {
                return false;
            }
            BigDecimal this$fixedLotSizeQuantity = this.fixedLotSizeQuantity;
            BigDecimal other$fixedLotSizeQuantity = other.fixedLotSizeQuantity;
            if (this$fixedLotSizeQuantity == null ? other$fixedLotSizeQuantity != null : !((Object)this$fixedLotSizeQuantity).equals(other$fixedLotSizeQuantity)) {
                return false;
            }
            String this$consumptionTaxCtrlCode = this.consumptionTaxCtrlCode;
            String other$consumptionTaxCtrlCode = other.consumptionTaxCtrlCode;
            if (this$consumptionTaxCtrlCode == null ? other$consumptionTaxCtrlCode != null : !this$consumptionTaxCtrlCode.equals(other$consumptionTaxCtrlCode)) {
                return false;
            }
            Boolean this$isCoProduct = this.isCoProduct;
            Boolean other$isCoProduct = other.isCoProduct;
            if (this$isCoProduct == null ? other$isCoProduct != null : !((Object)this$isCoProduct).equals(other$isCoProduct)) {
                return false;
            }
            String this$productIsConfigurable = this.productIsConfigurable;
            String other$productIsConfigurable = other.productIsConfigurable;
            if (this$productIsConfigurable == null ? other$productIsConfigurable != null : !this$productIsConfigurable.equals(other$productIsConfigurable)) {
                return false;
            }
            String this$stockDeterminationGroup = this.stockDeterminationGroup;
            String other$stockDeterminationGroup = other.stockDeterminationGroup;
            if (this$stockDeterminationGroup == null ? other$stockDeterminationGroup != null : !this$stockDeterminationGroup.equals(other$stockDeterminationGroup)) {
                return false;
            }
            BigDecimal this$stockInTransferQuantity = this.stockInTransferQuantity;
            BigDecimal other$stockInTransferQuantity = other.stockInTransferQuantity;
            if (this$stockInTransferQuantity == null ? other$stockInTransferQuantity != null : !((Object)this$stockInTransferQuantity).equals(other$stockInTransferQuantity)) {
                return false;
            }
            BigDecimal this$stockInTransitQuantity = this.stockInTransitQuantity;
            BigDecimal other$stockInTransitQuantity = other.stockInTransitQuantity;
            if (this$stockInTransitQuantity == null ? other$stockInTransitQuantity != null : !((Object)this$stockInTransitQuantity).equals(other$stockInTransitQuantity)) {
                return false;
            }
            Boolean this$hasPostToInspectionStock = this.hasPostToInspectionStock;
            Boolean other$hasPostToInspectionStock = other.hasPostToInspectionStock;
            if (this$hasPostToInspectionStock == null ? other$hasPostToInspectionStock != null : !((Object)this$hasPostToInspectionStock).equals(other$hasPostToInspectionStock)) {
                return false;
            }
            String this$purchasingGroup = this.purchasingGroup;
            String other$purchasingGroup = other.purchasingGroup;
            if (this$purchasingGroup == null ? other$purchasingGroup != null : !this$purchasingGroup.equals(other$purchasingGroup)) {
                return false;
            }
            Boolean this$isBatchManagementRequired = this.isBatchManagementRequired;
            Boolean other$isBatchManagementRequired = other.isBatchManagementRequired;
            if (this$isBatchManagementRequired == null ? other$isBatchManagementRequired != null : !((Object)this$isBatchManagementRequired).equals(other$isBatchManagementRequired)) {
                return false;
            }
            String this$serialNumberProfile = this.serialNumberProfile;
            String other$serialNumberProfile = other.serialNumberProfile;
            if (this$serialNumberProfile == null ? other$serialNumberProfile != null : !this$serialNumberProfile.equals(other$serialNumberProfile)) {
                return false;
            }
            Boolean this$isNegativeStockAllowed = this.isNegativeStockAllowed;
            Boolean other$isNegativeStockAllowed = other.isNegativeStockAllowed;
            if (this$isNegativeStockAllowed == null ? other$isNegativeStockAllowed != null : !((Object)this$isNegativeStockAllowed).equals(other$isNegativeStockAllowed)) {
                return false;
            }
            BigDecimal this$goodsReceiptBlockedStockQty = this.goodsReceiptBlockedStockQty;
            BigDecimal other$goodsReceiptBlockedStockQty = other.goodsReceiptBlockedStockQty;
            if (this$goodsReceiptBlockedStockQty == null ? other$goodsReceiptBlockedStockQty != null : !((Object)this$goodsReceiptBlockedStockQty).equals(other$goodsReceiptBlockedStockQty)) {
                return false;
            }
            String this$hasConsignmentCtrl = this.hasConsignmentCtrl;
            String other$hasConsignmentCtrl = other.hasConsignmentCtrl;
            if (this$hasConsignmentCtrl == null ? other$hasConsignmentCtrl != null : !this$hasConsignmentCtrl.equals(other$hasConsignmentCtrl)) {
                return false;
            }
            String this$fiscalYearCurrentPeriod = this.fiscalYearCurrentPeriod;
            String other$fiscalYearCurrentPeriod = other.fiscalYearCurrentPeriod;
            if (this$fiscalYearCurrentPeriod == null ? other$fiscalYearCurrentPeriod != null : !this$fiscalYearCurrentPeriod.equals(other$fiscalYearCurrentPeriod)) {
                return false;
            }
            String this$fiscalMonthCurrentPeriod = this.fiscalMonthCurrentPeriod;
            String other$fiscalMonthCurrentPeriod = other.fiscalMonthCurrentPeriod;
            if (this$fiscalMonthCurrentPeriod == null ? other$fiscalMonthCurrentPeriod != null : !this$fiscalMonthCurrentPeriod.equals(other$fiscalMonthCurrentPeriod)) {
                return false;
            }
            String this$procurementType = this.procurementType;
            String other$procurementType = other.procurementType;
            if (this$procurementType == null ? other$procurementType != null : !this$procurementType.equals(other$procurementType)) {
                return false;
            }
            Boolean this$isInternalBatchManaged = this.isInternalBatchManaged;
            Boolean other$isInternalBatchManaged = other.isInternalBatchManaged;
            if (this$isInternalBatchManaged == null ? other$isInternalBatchManaged != null : !((Object)this$isInternalBatchManaged).equals(other$isInternalBatchManaged)) {
                return false;
            }
            String this$productCFOPCategory = this.productCFOPCategory;
            String other$productCFOPCategory = other.productCFOPCategory;
            if (this$productCFOPCategory == null ? other$productCFOPCategory != null : !this$productCFOPCategory.equals(other$productCFOPCategory)) {
                return false;
            }
            String this$countryOfOrigin = this.countryOfOrigin;
            String other$countryOfOrigin = other.countryOfOrigin;
            if (this$countryOfOrigin == null ? other$countryOfOrigin != null : !this$countryOfOrigin.equals(other$countryOfOrigin)) {
                return false;
            }
            String this$regionOfOrigin = this.regionOfOrigin;
            String other$regionOfOrigin = other.regionOfOrigin;
            if (this$regionOfOrigin == null ? other$regionOfOrigin != null : !this$regionOfOrigin.equals(other$regionOfOrigin)) {
                return false;
            }
            String this$productionInvtryManagedLoc = this.productionInvtryManagedLoc;
            String other$productionInvtryManagedLoc = other.productionInvtryManagedLoc;
            if (this$productionInvtryManagedLoc == null ? other$productionInvtryManagedLoc != null : !this$productionInvtryManagedLoc.equals(other$productionInvtryManagedLoc)) {
                return false;
            }
            String this$profileCode = this.profileCode;
            String other$profileCode = other.profileCode;
            if (this$profileCode == null ? other$profileCode != null : !this$profileCode.equals(other$profileCode)) {
                return false;
            }
            Calendar this$profileValidityStartDate = this.profileValidityStartDate;
            Calendar other$profileValidityStartDate = other.profileValidityStartDate;
            if (this$profileValidityStartDate == null ? other$profileValidityStartDate != null : !((Object)this$profileValidityStartDate).equals(other$profileValidityStartDate)) {
                return false;
            }
            String this$availabilityCheckType = this.availabilityCheckType;
            String other$availabilityCheckType = other.availabilityCheckType;
            return !(this$availabilityCheckType == null ? other$availabilityCheckType != null : !this$availabilityCheckType.equals(other$availabilityCheckType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProductPlant;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.product;
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $fiscalYearVariant = this.fiscalYearVariant;
            result = result * 59 + ($fiscalYearVariant == null ? 43 : $fiscalYearVariant.hashCode());
            String $periodType = this.periodType;
            result = result * 59 + ($periodType == null ? 43 : $periodType.hashCode());
            String $profitCenter = this.profitCenter;
            result = result * 59 + ($profitCenter == null ? 43 : $profitCenter.hashCode());
            String $commodity = this.commodity;
            result = result * 59 + ($commodity == null ? 43 : $commodity.hashCode());
            BigDecimal $goodsReceiptDuration = this.goodsReceiptDuration;
            result = result * 59 + ($goodsReceiptDuration == null ? 43 : ((Object)$goodsReceiptDuration).hashCode());
            String $maintenanceStatusName = this.maintenanceStatusName;
            result = result * 59 + ($maintenanceStatusName == null ? 43 : $maintenanceStatusName.hashCode());
            Boolean $isMarkedForDeletion = this.isMarkedForDeletion;
            result = result * 59 + ($isMarkedForDeletion == null ? 43 : ((Object)$isMarkedForDeletion).hashCode());
            String $mRPType = this.mRPType;
            result = result * 59 + ($mRPType == null ? 43 : $mRPType.hashCode());
            String $mRPResponsible = this.mRPResponsible;
            result = result * 59 + ($mRPResponsible == null ? 43 : $mRPResponsible.hashCode());
            String $aBCIndicator = this.aBCIndicator;
            result = result * 59 + ($aBCIndicator == null ? 43 : $aBCIndicator.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            BigDecimal $minimumLotSizeQuantity = this.minimumLotSizeQuantity;
            result = result * 59 + ($minimumLotSizeQuantity == null ? 43 : ((Object)$minimumLotSizeQuantity).hashCode());
            BigDecimal $maximumLotSizeQuantity = this.maximumLotSizeQuantity;
            result = result * 59 + ($maximumLotSizeQuantity == null ? 43 : ((Object)$maximumLotSizeQuantity).hashCode());
            BigDecimal $fixedLotSizeQuantity = this.fixedLotSizeQuantity;
            result = result * 59 + ($fixedLotSizeQuantity == null ? 43 : ((Object)$fixedLotSizeQuantity).hashCode());
            String $consumptionTaxCtrlCode = this.consumptionTaxCtrlCode;
            result = result * 59 + ($consumptionTaxCtrlCode == null ? 43 : $consumptionTaxCtrlCode.hashCode());
            Boolean $isCoProduct = this.isCoProduct;
            result = result * 59 + ($isCoProduct == null ? 43 : ((Object)$isCoProduct).hashCode());
            String $productIsConfigurable = this.productIsConfigurable;
            result = result * 59 + ($productIsConfigurable == null ? 43 : $productIsConfigurable.hashCode());
            String $stockDeterminationGroup = this.stockDeterminationGroup;
            result = result * 59 + ($stockDeterminationGroup == null ? 43 : $stockDeterminationGroup.hashCode());
            BigDecimal $stockInTransferQuantity = this.stockInTransferQuantity;
            result = result * 59 + ($stockInTransferQuantity == null ? 43 : ((Object)$stockInTransferQuantity).hashCode());
            BigDecimal $stockInTransitQuantity = this.stockInTransitQuantity;
            result = result * 59 + ($stockInTransitQuantity == null ? 43 : ((Object)$stockInTransitQuantity).hashCode());
            Boolean $hasPostToInspectionStock = this.hasPostToInspectionStock;
            result = result * 59 + ($hasPostToInspectionStock == null ? 43 : ((Object)$hasPostToInspectionStock).hashCode());
            String $purchasingGroup = this.purchasingGroup;
            result = result * 59 + ($purchasingGroup == null ? 43 : $purchasingGroup.hashCode());
            Boolean $isBatchManagementRequired = this.isBatchManagementRequired;
            result = result * 59 + ($isBatchManagementRequired == null ? 43 : ((Object)$isBatchManagementRequired).hashCode());
            String $serialNumberProfile = this.serialNumberProfile;
            result = result * 59 + ($serialNumberProfile == null ? 43 : $serialNumberProfile.hashCode());
            Boolean $isNegativeStockAllowed = this.isNegativeStockAllowed;
            result = result * 59 + ($isNegativeStockAllowed == null ? 43 : ((Object)$isNegativeStockAllowed).hashCode());
            BigDecimal $goodsReceiptBlockedStockQty = this.goodsReceiptBlockedStockQty;
            result = result * 59 + ($goodsReceiptBlockedStockQty == null ? 43 : ((Object)$goodsReceiptBlockedStockQty).hashCode());
            String $hasConsignmentCtrl = this.hasConsignmentCtrl;
            result = result * 59 + ($hasConsignmentCtrl == null ? 43 : $hasConsignmentCtrl.hashCode());
            String $fiscalYearCurrentPeriod = this.fiscalYearCurrentPeriod;
            result = result * 59 + ($fiscalYearCurrentPeriod == null ? 43 : $fiscalYearCurrentPeriod.hashCode());
            String $fiscalMonthCurrentPeriod = this.fiscalMonthCurrentPeriod;
            result = result * 59 + ($fiscalMonthCurrentPeriod == null ? 43 : $fiscalMonthCurrentPeriod.hashCode());
            String $procurementType = this.procurementType;
            result = result * 59 + ($procurementType == null ? 43 : $procurementType.hashCode());
            Boolean $isInternalBatchManaged = this.isInternalBatchManaged;
            result = result * 59 + ($isInternalBatchManaged == null ? 43 : ((Object)$isInternalBatchManaged).hashCode());
            String $productCFOPCategory = this.productCFOPCategory;
            result = result * 59 + ($productCFOPCategory == null ? 43 : $productCFOPCategory.hashCode());
            String $countryOfOrigin = this.countryOfOrigin;
            result = result * 59 + ($countryOfOrigin == null ? 43 : $countryOfOrigin.hashCode());
            String $regionOfOrigin = this.regionOfOrigin;
            result = result * 59 + ($regionOfOrigin == null ? 43 : $regionOfOrigin.hashCode());
            String $productionInvtryManagedLoc = this.productionInvtryManagedLoc;
            result = result * 59 + ($productionInvtryManagedLoc == null ? 43 : $productionInvtryManagedLoc.hashCode());
            String $profileCode = this.profileCode;
            result = result * 59 + ($profileCode == null ? 43 : $profileCode.hashCode());
            Calendar $profileValidityStartDate = this.profileValidityStartDate;
            result = result * 59 + ($profileValidityStartDate == null ? 43 : ((Object)$profileValidityStartDate).hashCode());
            String $availabilityCheckType = this.availabilityCheckType;
            result = result * 59 + ($availabilityCheckType == null ? 43 : $availabilityCheckType.hashCode());
            return result;
        }

        public String getProduct() {
            return this.product;
        }

        public ProductPlant setProduct(String product) {
            this.product = product;
            return this;
        }

        public String getFiscalYearVariant() {
            return this.fiscalYearVariant;
        }

        public ProductPlant setFiscalYearVariant(String fiscalYearVariant) {
            this.fiscalYearVariant = fiscalYearVariant;
            return this;
        }

        public String getPeriodType() {
            return this.periodType;
        }

        public ProductPlant setPeriodType(String periodType) {
            this.periodType = periodType;
            return this;
        }

        public String getProfitCenter() {
            return this.profitCenter;
        }

        public ProductPlant setProfitCenter(String profitCenter) {
            this.profitCenter = profitCenter;
            return this;
        }

        public String getCommodity() {
            return this.commodity;
        }

        public ProductPlant setCommodity(String commodity) {
            this.commodity = commodity;
            return this;
        }

        public BigDecimal getGoodsReceiptDuration() {
            return this.goodsReceiptDuration;
        }

        public ProductPlant setGoodsReceiptDuration(BigDecimal goodsReceiptDuration) {
            this.goodsReceiptDuration = goodsReceiptDuration;
            return this;
        }

        public String getMaintenanceStatusName() {
            return this.maintenanceStatusName;
        }

        public ProductPlant setMaintenanceStatusName(String maintenanceStatusName) {
            this.maintenanceStatusName = maintenanceStatusName;
            return this;
        }

        public Boolean getIsMarkedForDeletion() {
            return this.isMarkedForDeletion;
        }

        public ProductPlant setIsMarkedForDeletion(Boolean isMarkedForDeletion) {
            this.isMarkedForDeletion = isMarkedForDeletion;
            return this;
        }

        public String getMRPType() {
            return this.mRPType;
        }

        public ProductPlant setMRPType(String mRPType) {
            this.mRPType = mRPType;
            return this;
        }

        public String getMRPResponsible() {
            return this.mRPResponsible;
        }

        public ProductPlant setMRPResponsible(String mRPResponsible) {
            this.mRPResponsible = mRPResponsible;
            return this;
        }

        public String getABCIndicator() {
            return this.aBCIndicator;
        }

        public ProductPlant setABCIndicator(String aBCIndicator) {
            this.aBCIndicator = aBCIndicator;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public ProductPlant setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public BigDecimal getMinimumLotSizeQuantity() {
            return this.minimumLotSizeQuantity;
        }

        public ProductPlant setMinimumLotSizeQuantity(BigDecimal minimumLotSizeQuantity) {
            this.minimumLotSizeQuantity = minimumLotSizeQuantity;
            return this;
        }

        public BigDecimal getMaximumLotSizeQuantity() {
            return this.maximumLotSizeQuantity;
        }

        public ProductPlant setMaximumLotSizeQuantity(BigDecimal maximumLotSizeQuantity) {
            this.maximumLotSizeQuantity = maximumLotSizeQuantity;
            return this;
        }

        public BigDecimal getFixedLotSizeQuantity() {
            return this.fixedLotSizeQuantity;
        }

        public ProductPlant setFixedLotSizeQuantity(BigDecimal fixedLotSizeQuantity) {
            this.fixedLotSizeQuantity = fixedLotSizeQuantity;
            return this;
        }

        public String getConsumptionTaxCtrlCode() {
            return this.consumptionTaxCtrlCode;
        }

        public ProductPlant setConsumptionTaxCtrlCode(String consumptionTaxCtrlCode) {
            this.consumptionTaxCtrlCode = consumptionTaxCtrlCode;
            return this;
        }

        public Boolean getIsCoProduct() {
            return this.isCoProduct;
        }

        public ProductPlant setIsCoProduct(Boolean isCoProduct) {
            this.isCoProduct = isCoProduct;
            return this;
        }

        public String getProductIsConfigurable() {
            return this.productIsConfigurable;
        }

        public ProductPlant setProductIsConfigurable(String productIsConfigurable) {
            this.productIsConfigurable = productIsConfigurable;
            return this;
        }

        public String getStockDeterminationGroup() {
            return this.stockDeterminationGroup;
        }

        public ProductPlant setStockDeterminationGroup(String stockDeterminationGroup) {
            this.stockDeterminationGroup = stockDeterminationGroup;
            return this;
        }

        public BigDecimal getStockInTransferQuantity() {
            return this.stockInTransferQuantity;
        }

        public ProductPlant setStockInTransferQuantity(BigDecimal stockInTransferQuantity) {
            this.stockInTransferQuantity = stockInTransferQuantity;
            return this;
        }

        public BigDecimal getStockInTransitQuantity() {
            return this.stockInTransitQuantity;
        }

        public ProductPlant setStockInTransitQuantity(BigDecimal stockInTransitQuantity) {
            this.stockInTransitQuantity = stockInTransitQuantity;
            return this;
        }

        public Boolean getHasPostToInspectionStock() {
            return this.hasPostToInspectionStock;
        }

        public ProductPlant setHasPostToInspectionStock(Boolean hasPostToInspectionStock) {
            this.hasPostToInspectionStock = hasPostToInspectionStock;
            return this;
        }

        public String getPurchasingGroup() {
            return this.purchasingGroup;
        }

        public ProductPlant setPurchasingGroup(String purchasingGroup) {
            this.purchasingGroup = purchasingGroup;
            return this;
        }

        public Boolean getIsBatchManagementRequired() {
            return this.isBatchManagementRequired;
        }

        public ProductPlant setIsBatchManagementRequired(Boolean isBatchManagementRequired) {
            this.isBatchManagementRequired = isBatchManagementRequired;
            return this;
        }

        public String getSerialNumberProfile() {
            return this.serialNumberProfile;
        }

        public ProductPlant setSerialNumberProfile(String serialNumberProfile) {
            this.serialNumberProfile = serialNumberProfile;
            return this;
        }

        public Boolean getIsNegativeStockAllowed() {
            return this.isNegativeStockAllowed;
        }

        public ProductPlant setIsNegativeStockAllowed(Boolean isNegativeStockAllowed) {
            this.isNegativeStockAllowed = isNegativeStockAllowed;
            return this;
        }

        public BigDecimal getGoodsReceiptBlockedStockQty() {
            return this.goodsReceiptBlockedStockQty;
        }

        public ProductPlant setGoodsReceiptBlockedStockQty(BigDecimal goodsReceiptBlockedStockQty) {
            this.goodsReceiptBlockedStockQty = goodsReceiptBlockedStockQty;
            return this;
        }

        public String getHasConsignmentCtrl() {
            return this.hasConsignmentCtrl;
        }

        public ProductPlant setHasConsignmentCtrl(String hasConsignmentCtrl) {
            this.hasConsignmentCtrl = hasConsignmentCtrl;
            return this;
        }

        public String getFiscalYearCurrentPeriod() {
            return this.fiscalYearCurrentPeriod;
        }

        public ProductPlant setFiscalYearCurrentPeriod(String fiscalYearCurrentPeriod) {
            this.fiscalYearCurrentPeriod = fiscalYearCurrentPeriod;
            return this;
        }

        public String getFiscalMonthCurrentPeriod() {
            return this.fiscalMonthCurrentPeriod;
        }

        public ProductPlant setFiscalMonthCurrentPeriod(String fiscalMonthCurrentPeriod) {
            this.fiscalMonthCurrentPeriod = fiscalMonthCurrentPeriod;
            return this;
        }

        public String getProcurementType() {
            return this.procurementType;
        }

        public ProductPlant setProcurementType(String procurementType) {
            this.procurementType = procurementType;
            return this;
        }

        public Boolean getIsInternalBatchManaged() {
            return this.isInternalBatchManaged;
        }

        public ProductPlant setIsInternalBatchManaged(Boolean isInternalBatchManaged) {
            this.isInternalBatchManaged = isInternalBatchManaged;
            return this;
        }

        public String getProductCFOPCategory() {
            return this.productCFOPCategory;
        }

        public ProductPlant setProductCFOPCategory(String productCFOPCategory) {
            this.productCFOPCategory = productCFOPCategory;
            return this;
        }

        public String getCountryOfOrigin() {
            return this.countryOfOrigin;
        }

        public ProductPlant setCountryOfOrigin(String countryOfOrigin) {
            this.countryOfOrigin = countryOfOrigin;
            return this;
        }

        public String getRegionOfOrigin() {
            return this.regionOfOrigin;
        }

        public ProductPlant setRegionOfOrigin(String regionOfOrigin) {
            this.regionOfOrigin = regionOfOrigin;
            return this;
        }

        public String getProductionInvtryManagedLoc() {
            return this.productionInvtryManagedLoc;
        }

        public ProductPlant setProductionInvtryManagedLoc(String productionInvtryManagedLoc) {
            this.productionInvtryManagedLoc = productionInvtryManagedLoc;
            return this;
        }

        public String getProfileCode() {
            return this.profileCode;
        }

        public ProductPlant setProfileCode(String profileCode) {
            this.profileCode = profileCode;
            return this;
        }

        public Calendar getProfileValidityStartDate() {
            return this.profileValidityStartDate;
        }

        public ProductPlant setProfileValidityStartDate(Calendar profileValidityStartDate) {
            this.profileValidityStartDate = profileValidityStartDate;
            return this;
        }

        public String getAvailabilityCheckType() {
            return this.availabilityCheckType;
        }

        public ProductPlant setAvailabilityCheckType(String availabilityCheckType) {
            this.availabilityCheckType = availabilityCheckType;
            return this;
        }

        public ProductPlant setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProductFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_Product");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProductFluentHelper filter(ExpressionFluentHelper<Product> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProductFluentHelper orderBy(EntityField<?, Product> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProductFluentHelper select(EntityField<?, Product> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProductFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProductFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProductFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<Product> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(Product.class);
            for (Product entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProductDescriptionFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductDescription");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public ProductDescriptionFluentHelper filter(ExpressionFluentHelper<ProductDescription> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public ProductDescriptionFluentHelper orderBy(EntityField<?, ProductDescription> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final ProductDescriptionFluentHelper select(EntityField<?, ProductDescription> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ProductDescriptionFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public ProductDescriptionFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public ProductDescriptionFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<ProductDescription> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(ProductDescription.class);
            for (ProductDescription entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class ProductDescriptionByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProductDescriptionByKeyFluentHelper(String product, String language) {
            this.values.add(product);
            this.values.add(language);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_ProductDescription");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Product", this.values.get(0));
            keys.put("Language", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProductDescriptionByKeyFluentHelper select(EntityField<?, ProductDescription> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProductDescriptionByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ProductDescription execute(ErpConfigContext erpConfigContext) throws ODataException {
            ProductDescription entity = (ProductDescription)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(ProductDescription.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class ProductDescription {
        @ElementName(value="Product")
        private String product;
        public static EntityField<String, ProductDescription> PRODUCT = new EntityField("Product");
        @ElementName(value="Language")
        private String language;
        public static EntityField<String, ProductDescription> LANGUAGE = new EntityField("Language");
        @ElementName(value="ProductDescription")
        private String productDescription;
        public static EntityField<String, ProductDescription> PRODUCT_DESCRIPTION = new EntityField("ProductDescription");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PRODUCT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_ProductDescription";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ProductMasterNamespace.ProductDescription(product=" + this.product + ", language=" + this.language + ", productDescription=" + this.productDescription + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProductDescription)) {
                return false;
            }
            ProductDescription other = (ProductDescription)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.product;
            String other$product = other.product;
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$language = this.language;
            String other$language = other.language;
            if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
                return false;
            }
            String this$productDescription = this.productDescription;
            String other$productDescription = other.productDescription;
            return !(this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProductDescription;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.product;
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $language = this.language;
            result = result * 59 + ($language == null ? 43 : $language.hashCode());
            String $productDescription = this.productDescription;
            result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
            return result;
        }

        public String getProduct() {
            return this.product;
        }

        public ProductDescription setProduct(String product) {
            this.product = product;
            return this;
        }

        public String getLanguage() {
            return this.language;
        }

        public ProductDescription setLanguage(String language) {
            this.language = language;
            return this;
        }

        public String getProductDescription() {
            return this.productDescription;
        }

        public ProductDescription setProductDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public ProductDescription setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class ProductByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public ProductByKeyFluentHelper(String product) {
            this.values.add(product);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PRODUCT_SRV", (String)"A_Product");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("Product", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final ProductByKeyFluentHelper select(EntityField<?, Product> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public ProductByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public Product execute(ErpConfigContext erpConfigContext) throws ODataException {
            Product entity = (Product)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(Product.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class Product {
        @ElementName(value="Product")
        private String product;
        public static EntityField<String, Product> PRODUCT = new EntityField("Product");
        @ElementName(value="ProductOldID")
        private String productOldID;
        public static EntityField<String, Product> PRODUCT_OLD_I_D = new EntityField("ProductOldID");
        @ElementName(value="GrossWeight")
        private BigDecimal grossWeight;
        public static EntityField<BigDecimal, Product> GROSS_WEIGHT = new EntityField("GrossWeight");
        @ElementName(value="PurchaseOrderQuantityUnit")
        private String purchaseOrderQuantityUnit;
        public static EntityField<String, Product> PURCHASE_ORDER_QUANTITY_UNIT = new EntityField("PurchaseOrderQuantityUnit");
        @ElementName(value="SourceOfSupply")
        private String sourceOfSupply;
        public static EntityField<String, Product> SOURCE_OF_SUPPLY = new EntityField("SourceOfSupply");
        @ElementName(value="WeightUnit")
        private String weightUnit;
        public static EntityField<String, Product> WEIGHT_UNIT = new EntityField("WeightUnit");
        @ElementName(value="NetWeight")
        private BigDecimal netWeight;
        public static EntityField<BigDecimal, Product> NET_WEIGHT = new EntityField("NetWeight");
        @ElementName(value="CountryOfOrigin")
        private String countryOfOrigin;
        public static EntityField<String, Product> COUNTRY_OF_ORIGIN = new EntityField("CountryOfOrigin");
        @ElementName(value="CompetitorID")
        private String competitorID;
        public static EntityField<String, Product> COMPETITOR_I_D = new EntityField("CompetitorID");
        @ElementName(value="ProductGroup")
        private String productGroup;
        public static EntityField<String, Product> PRODUCT_GROUP = new EntityField("ProductGroup");
        @ElementName(value="BaseUnit")
        private String baseUnit;
        public static EntityField<String, Product> BASE_UNIT = new EntityField("BaseUnit");
        @ElementName(value="ProductType")
        private String productType;
        public static EntityField<String, Product> PRODUCT_TYPE = new EntityField("ProductType");
        @ElementName(value="ItemCategoryGroup")
        private String itemCategoryGroup;
        public static EntityField<String, Product> ITEM_CATEGORY_GROUP = new EntityField("ItemCategoryGroup");
        @ElementName(value="ProductHierarchy")
        private String productHierarchy;
        public static EntityField<String, Product> PRODUCT_HIERARCHY = new EntityField("ProductHierarchy");
        @ElementName(value="Division")
        private String division;
        public static EntityField<String, Product> DIVISION = new EntityField("Division");
        @ElementName(value="VolumeUnit")
        private String volumeUnit;
        public static EntityField<String, Product> VOLUME_UNIT = new EntityField("VolumeUnit");
        @ElementName(value="MaterialVolume")
        private BigDecimal materialVolume;
        public static EntityField<BigDecimal, Product> MATERIAL_VOLUME = new EntityField("MaterialVolume");
        @ElementName(value="ANPCode")
        private String aNPCode;
        public static EntityField<String, Product> A_N_P_CODE = new EntityField("ANPCode");
        @ElementName(value="Brand")
        private String brand;
        public static EntityField<String, Product> BRAND = new EntityField("Brand");
        @ElementName(value="ProcurementRule")
        private String procurementRule;
        public static EntityField<String, Product> PROCUREMENT_RULE = new EntityField("ProcurementRule");
        @ElementName(value="ValidityStartDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar validityStartDate;
        public static EntityField<Calendar, Product> VALIDITY_START_DATE = new EntityField("ValidityStartDate");
        @ElementName(value="LowLevelCode")
        private String lowLevelCode;
        public static EntityField<String, Product> LOW_LEVEL_CODE = new EntityField("LowLevelCode");
        @ElementName(value="CrossPlantStatus")
        private String crossPlantStatus;
        public static EntityField<String, Product> CROSS_PLANT_STATUS = new EntityField("CrossPlantStatus");
        @ElementName(value="ProdNoInGenProdInPrepackProd")
        private String prodNoInGenProdInPrepackProd;
        public static EntityField<String, Product> PROD_NO_IN_GEN_PROD_IN_PREPACK_PROD = new EntityField("ProdNoInGenProdInPrepackProd");
        @ElementName(value="SerialIdentifierAssgmtProfile")
        private String serialIdentifierAssgmtProfile;
        public static EntityField<String, Product> SERIAL_IDENTIFIER_ASSGMT_PROFILE = new EntityField("SerialIdentifierAssgmtProfile");
        @ElementName(value="SizeOrDimensionText")
        private String sizeOrDimensionText;
        public static EntityField<String, Product> SIZE_OR_DIMENSION_TEXT = new EntityField("SizeOrDimensionText");
        @ElementName(value="IndustryStandardName")
        private String industryStandardName;
        public static EntityField<String, Product> INDUSTRY_STANDARD_NAME = new EntityField("IndustryStandardName");
        @ElementName(value="ProductStandardID")
        private String productStandardID;
        public static EntityField<String, Product> PRODUCT_STANDARD_I_D = new EntityField("ProductStandardID");
        @ElementName(value="InternationalArticleNumberCat")
        private String internationalArticleNumberCat;
        public static EntityField<String, Product> INTERNATIONAL_ARTICLE_NUMBER_CAT = new EntityField("InternationalArticleNumberCat");
        @ElementName(value="ProductIsConfigurable")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean productIsConfigurable;
        public static EntityField<Boolean, Product> PRODUCT_IS_CONFIGURABLE = new EntityField("ProductIsConfigurable");
        @ElementName(value="IsBatchManagementRequired")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isBatchManagementRequired;
        public static EntityField<Boolean, Product> IS_BATCH_MANAGEMENT_REQUIRED = new EntityField("IsBatchManagementRequired");
        @ElementName(value="ExternalProductGroup")
        private String externalProductGroup;
        public static EntityField<String, Product> EXTERNAL_PRODUCT_GROUP = new EntityField("ExternalProductGroup");
        @ElementName(value="CrossPlantConfigurableProduct")
        private String crossPlantConfigurableProduct;
        public static EntityField<String, Product> CROSS_PLANT_CONFIGURABLE_PRODUCT = new EntityField("CrossPlantConfigurableProduct");
        @ElementName(value="CrossPlantStatusValidityDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar crossPlantStatusValidityDate;
        public static EntityField<Calendar, Product> CROSS_PLANT_STATUS_VALIDITY_DATE = new EntityField("CrossPlantStatusValidityDate");
        @ElementName(value="SerialNoExplicitnessLevel")
        private String serialNoExplicitnessLevel;
        public static EntityField<String, Product> SERIAL_NO_EXPLICITNESS_LEVEL = new EntityField("SerialNoExplicitnessLevel");
        @ElementName(value="ProductManufacturerNumber")
        private String productManufacturerNumber;
        public static EntityField<String, Product> PRODUCT_MANUFACTURER_NUMBER = new EntityField("ProductManufacturerNumber");
        @ElementName(value="ManufacturerPartProfile")
        private String manufacturerPartProfile;
        public static EntityField<String, Product> MANUFACTURER_PART_PROFILE = new EntityField("ManufacturerPartProfile");
        @ElementName(value="ChangeNumber")
        private String changeNumber;
        public static EntityField<String, Product> CHANGE_NUMBER = new EntityField("ChangeNumber");
        @ElementName(value="MaterialRevisionLevel")
        private String materialRevisionLevel;
        public static EntityField<String, Product> MATERIAL_REVISION_LEVEL = new EntityField("MaterialRevisionLevel");
        @ElementName(value="HandlingIndicator")
        private String handlingIndicator;
        public static EntityField<String, Product> HANDLING_INDICATOR = new EntityField("HandlingIndicator");
        @ElementName(value="WarehouseProductGroup")
        private String warehouseProductGroup;
        public static EntityField<String, Product> WAREHOUSE_PRODUCT_GROUP = new EntityField("WarehouseProductGroup");
        @ElementName(value="WarehouseStorageCondition")
        private String warehouseStorageCondition;
        public static EntityField<String, Product> WAREHOUSE_STORAGE_CONDITION = new EntityField("WarehouseStorageCondition");
        @ElementName(value="StandardHandlingUnitType")
        private String standardHandlingUnitType;
        public static EntityField<String, Product> STANDARD_HANDLING_UNIT_TYPE = new EntityField("StandardHandlingUnitType");
        @ElementName(value="SerialNumberProfile")
        private String serialNumberProfile;
        public static EntityField<String, Product> SERIAL_NUMBER_PROFILE = new EntityField("SerialNumberProfile");
        @ElementName(value="CreationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar creationDate;
        public static EntityField<Calendar, Product> CREATION_DATE = new EntityField("CreationDate");
        @ElementName(value="AdjustmentProfile")
        private String adjustmentProfile;
        public static EntityField<String, Product> ADJUSTMENT_PROFILE = new EntityField("AdjustmentProfile");
        @ElementName(value="IsPilferable")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isPilferable;
        public static EntityField<Boolean, Product> IS_PILFERABLE = new EntityField("IsPilferable");
        @ElementName(value="IsRelevantForHzdsSubstances")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isRelevantForHzdsSubstances;
        public static EntityField<Boolean, Product> IS_RELEVANT_FOR_HZDS_SUBSTANCES = new EntityField("IsRelevantForHzdsSubstances");
        @ElementName(value="QuarantinePeriod")
        private BigDecimal quarantinePeriod;
        public static EntityField<BigDecimal, Product> QUARANTINE_PERIOD = new EntityField("QuarantinePeriod");
        @ElementName(value="TimeUnitForQuarantinePeriod")
        private String timeUnitForQuarantinePeriod;
        public static EntityField<String, Product> TIME_UNIT_FOR_QUARANTINE_PERIOD = new EntityField("TimeUnitForQuarantinePeriod");
        @ElementName(value="QualityInspectionGroup")
        private String qualityInspectionGroup;
        public static EntityField<String, Product> QUALITY_INSPECTION_GROUP = new EntityField("QualityInspectionGroup");
        @ElementName(value="AuthorizationGroup")
        private String authorizationGroup;
        public static EntityField<String, Product> AUTHORIZATION_GROUP = new EntityField("AuthorizationGroup");
        @ElementName(value="HandlingUnitType")
        private String handlingUnitType;
        public static EntityField<String, Product> HANDLING_UNIT_TYPE = new EntityField("HandlingUnitType");
        @ElementName(value="HasVariableTareWeight")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean hasVariableTareWeight;
        public static EntityField<Boolean, Product> HAS_VARIABLE_TARE_WEIGHT = new EntityField("HasVariableTareWeight");
        @ElementName(value="MaximumPackagingLength")
        private BigDecimal maximumPackagingLength;
        public static EntityField<BigDecimal, Product> MAXIMUM_PACKAGING_LENGTH = new EntityField("MaximumPackagingLength");
        @ElementName(value="CreatedByUser")
        private String createdByUser;
        public static EntityField<String, Product> CREATED_BY_USER = new EntityField("CreatedByUser");
        @ElementName(value="MaximumPackagingWidth")
        private BigDecimal maximumPackagingWidth;
        public static EntityField<BigDecimal, Product> MAXIMUM_PACKAGING_WIDTH = new EntityField("MaximumPackagingWidth");
        @ElementName(value="MaximumPackagingHeight")
        private BigDecimal maximumPackagingHeight;
        public static EntityField<BigDecimal, Product> MAXIMUM_PACKAGING_HEIGHT = new EntityField("MaximumPackagingHeight");
        @ElementName(value="LastChangeDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDate;
        public static EntityField<Calendar, Product> LAST_CHANGE_DATE = new EntityField("LastChangeDate");
        @ElementName(value="LastChangedByUser")
        private String lastChangedByUser;
        public static EntityField<String, Product> LAST_CHANGED_BY_USER = new EntityField("LastChangedByUser");
        @ElementName(value="IsMarkedForDeletion")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isMarkedForDeletion;
        public static EntityField<Boolean, Product> IS_MARKED_FOR_DELETION = new EntityField("IsMarkedForDeletion");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PRODUCT_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_Product";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<ProductDescription> fetchDescription() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("Product=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.product));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Description");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProductDescription.class);
            for (ProductDescription entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<ProductPlant> fetchPlant() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("Product=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.product));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Plant");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProductPlant.class);
            for (ProductPlant entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<ProductSalesTax> fetchProductSalesTax() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("Product=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.product));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_ProductSalesTax");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProductSalesTax.class);
            for (ProductSalesTax entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<ProductSalesDelivery> fetchSalesDelivery() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("Product=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.product));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesDelivery");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(ProductSalesDelivery.class);
            for (ProductSalesDelivery entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ProductMasterNamespace.Product(product=" + this.product + ", productOldID=" + this.productOldID + ", grossWeight=" + this.grossWeight + ", purchaseOrderQuantityUnit=" + this.purchaseOrderQuantityUnit + ", sourceOfSupply=" + this.sourceOfSupply + ", weightUnit=" + this.weightUnit + ", netWeight=" + this.netWeight + ", countryOfOrigin=" + this.countryOfOrigin + ", competitorID=" + this.competitorID + ", productGroup=" + this.productGroup + ", baseUnit=" + this.baseUnit + ", productType=" + this.productType + ", itemCategoryGroup=" + this.itemCategoryGroup + ", productHierarchy=" + this.productHierarchy + ", division=" + this.division + ", volumeUnit=" + this.volumeUnit + ", materialVolume=" + this.materialVolume + ", aNPCode=" + this.aNPCode + ", brand=" + this.brand + ", procurementRule=" + this.procurementRule + ", validityStartDate=" + this.validityStartDate + ", lowLevelCode=" + this.lowLevelCode + ", crossPlantStatus=" + this.crossPlantStatus + ", prodNoInGenProdInPrepackProd=" + this.prodNoInGenProdInPrepackProd + ", serialIdentifierAssgmtProfile=" + this.serialIdentifierAssgmtProfile + ", sizeOrDimensionText=" + this.sizeOrDimensionText + ", industryStandardName=" + this.industryStandardName + ", productStandardID=" + this.productStandardID + ", internationalArticleNumberCat=" + this.internationalArticleNumberCat + ", productIsConfigurable=" + this.productIsConfigurable + ", isBatchManagementRequired=" + this.isBatchManagementRequired + ", externalProductGroup=" + this.externalProductGroup + ", crossPlantConfigurableProduct=" + this.crossPlantConfigurableProduct + ", crossPlantStatusValidityDate=" + this.crossPlantStatusValidityDate + ", serialNoExplicitnessLevel=" + this.serialNoExplicitnessLevel + ", productManufacturerNumber=" + this.productManufacturerNumber + ", manufacturerPartProfile=" + this.manufacturerPartProfile + ", changeNumber=" + this.changeNumber + ", materialRevisionLevel=" + this.materialRevisionLevel + ", handlingIndicator=" + this.handlingIndicator + ", warehouseProductGroup=" + this.warehouseProductGroup + ", warehouseStorageCondition=" + this.warehouseStorageCondition + ", standardHandlingUnitType=" + this.standardHandlingUnitType + ", serialNumberProfile=" + this.serialNumberProfile + ", creationDate=" + this.creationDate + ", adjustmentProfile=" + this.adjustmentProfile + ", isPilferable=" + this.isPilferable + ", isRelevantForHzdsSubstances=" + this.isRelevantForHzdsSubstances + ", quarantinePeriod=" + this.quarantinePeriod + ", timeUnitForQuarantinePeriod=" + this.timeUnitForQuarantinePeriod + ", qualityInspectionGroup=" + this.qualityInspectionGroup + ", authorizationGroup=" + this.authorizationGroup + ", handlingUnitType=" + this.handlingUnitType + ", hasVariableTareWeight=" + this.hasVariableTareWeight + ", maximumPackagingLength=" + this.maximumPackagingLength + ", createdByUser=" + this.createdByUser + ", maximumPackagingWidth=" + this.maximumPackagingWidth + ", maximumPackagingHeight=" + this.maximumPackagingHeight + ", lastChangeDate=" + this.lastChangeDate + ", lastChangedByUser=" + this.lastChangedByUser + ", isMarkedForDeletion=" + this.isMarkedForDeletion + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Product)) {
                return false;
            }
            Product other = (Product)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$product = this.product;
            String other$product = other.product;
            if (this$product == null ? other$product != null : !this$product.equals(other$product)) {
                return false;
            }
            String this$productOldID = this.productOldID;
            String other$productOldID = other.productOldID;
            if (this$productOldID == null ? other$productOldID != null : !this$productOldID.equals(other$productOldID)) {
                return false;
            }
            BigDecimal this$grossWeight = this.grossWeight;
            BigDecimal other$grossWeight = other.grossWeight;
            if (this$grossWeight == null ? other$grossWeight != null : !((Object)this$grossWeight).equals(other$grossWeight)) {
                return false;
            }
            String this$purchaseOrderQuantityUnit = this.purchaseOrderQuantityUnit;
            String other$purchaseOrderQuantityUnit = other.purchaseOrderQuantityUnit;
            if (this$purchaseOrderQuantityUnit == null ? other$purchaseOrderQuantityUnit != null : !this$purchaseOrderQuantityUnit.equals(other$purchaseOrderQuantityUnit)) {
                return false;
            }
            String this$sourceOfSupply = this.sourceOfSupply;
            String other$sourceOfSupply = other.sourceOfSupply;
            if (this$sourceOfSupply == null ? other$sourceOfSupply != null : !this$sourceOfSupply.equals(other$sourceOfSupply)) {
                return false;
            }
            String this$weightUnit = this.weightUnit;
            String other$weightUnit = other.weightUnit;
            if (this$weightUnit == null ? other$weightUnit != null : !this$weightUnit.equals(other$weightUnit)) {
                return false;
            }
            BigDecimal this$netWeight = this.netWeight;
            BigDecimal other$netWeight = other.netWeight;
            if (this$netWeight == null ? other$netWeight != null : !((Object)this$netWeight).equals(other$netWeight)) {
                return false;
            }
            String this$countryOfOrigin = this.countryOfOrigin;
            String other$countryOfOrigin = other.countryOfOrigin;
            if (this$countryOfOrigin == null ? other$countryOfOrigin != null : !this$countryOfOrigin.equals(other$countryOfOrigin)) {
                return false;
            }
            String this$competitorID = this.competitorID;
            String other$competitorID = other.competitorID;
            if (this$competitorID == null ? other$competitorID != null : !this$competitorID.equals(other$competitorID)) {
                return false;
            }
            String this$productGroup = this.productGroup;
            String other$productGroup = other.productGroup;
            if (this$productGroup == null ? other$productGroup != null : !this$productGroup.equals(other$productGroup)) {
                return false;
            }
            String this$baseUnit = this.baseUnit;
            String other$baseUnit = other.baseUnit;
            if (this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit)) {
                return false;
            }
            String this$productType = this.productType;
            String other$productType = other.productType;
            if (this$productType == null ? other$productType != null : !this$productType.equals(other$productType)) {
                return false;
            }
            String this$itemCategoryGroup = this.itemCategoryGroup;
            String other$itemCategoryGroup = other.itemCategoryGroup;
            if (this$itemCategoryGroup == null ? other$itemCategoryGroup != null : !this$itemCategoryGroup.equals(other$itemCategoryGroup)) {
                return false;
            }
            String this$productHierarchy = this.productHierarchy;
            String other$productHierarchy = other.productHierarchy;
            if (this$productHierarchy == null ? other$productHierarchy != null : !this$productHierarchy.equals(other$productHierarchy)) {
                return false;
            }
            String this$division = this.division;
            String other$division = other.division;
            if (this$division == null ? other$division != null : !this$division.equals(other$division)) {
                return false;
            }
            String this$volumeUnit = this.volumeUnit;
            String other$volumeUnit = other.volumeUnit;
            if (this$volumeUnit == null ? other$volumeUnit != null : !this$volumeUnit.equals(other$volumeUnit)) {
                return false;
            }
            BigDecimal this$materialVolume = this.materialVolume;
            BigDecimal other$materialVolume = other.materialVolume;
            if (this$materialVolume == null ? other$materialVolume != null : !((Object)this$materialVolume).equals(other$materialVolume)) {
                return false;
            }
            String this$aNPCode = this.aNPCode;
            String other$aNPCode = other.aNPCode;
            if (this$aNPCode == null ? other$aNPCode != null : !this$aNPCode.equals(other$aNPCode)) {
                return false;
            }
            String this$brand = this.brand;
            String other$brand = other.brand;
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            String this$procurementRule = this.procurementRule;
            String other$procurementRule = other.procurementRule;
            if (this$procurementRule == null ? other$procurementRule != null : !this$procurementRule.equals(other$procurementRule)) {
                return false;
            }
            Calendar this$validityStartDate = this.validityStartDate;
            Calendar other$validityStartDate = other.validityStartDate;
            if (this$validityStartDate == null ? other$validityStartDate != null : !((Object)this$validityStartDate).equals(other$validityStartDate)) {
                return false;
            }
            String this$lowLevelCode = this.lowLevelCode;
            String other$lowLevelCode = other.lowLevelCode;
            if (this$lowLevelCode == null ? other$lowLevelCode != null : !this$lowLevelCode.equals(other$lowLevelCode)) {
                return false;
            }
            String this$crossPlantStatus = this.crossPlantStatus;
            String other$crossPlantStatus = other.crossPlantStatus;
            if (this$crossPlantStatus == null ? other$crossPlantStatus != null : !this$crossPlantStatus.equals(other$crossPlantStatus)) {
                return false;
            }
            String this$prodNoInGenProdInPrepackProd = this.prodNoInGenProdInPrepackProd;
            String other$prodNoInGenProdInPrepackProd = other.prodNoInGenProdInPrepackProd;
            if (this$prodNoInGenProdInPrepackProd == null ? other$prodNoInGenProdInPrepackProd != null : !this$prodNoInGenProdInPrepackProd.equals(other$prodNoInGenProdInPrepackProd)) {
                return false;
            }
            String this$serialIdentifierAssgmtProfile = this.serialIdentifierAssgmtProfile;
            String other$serialIdentifierAssgmtProfile = other.serialIdentifierAssgmtProfile;
            if (this$serialIdentifierAssgmtProfile == null ? other$serialIdentifierAssgmtProfile != null : !this$serialIdentifierAssgmtProfile.equals(other$serialIdentifierAssgmtProfile)) {
                return false;
            }
            String this$sizeOrDimensionText = this.sizeOrDimensionText;
            String other$sizeOrDimensionText = other.sizeOrDimensionText;
            if (this$sizeOrDimensionText == null ? other$sizeOrDimensionText != null : !this$sizeOrDimensionText.equals(other$sizeOrDimensionText)) {
                return false;
            }
            String this$industryStandardName = this.industryStandardName;
            String other$industryStandardName = other.industryStandardName;
            if (this$industryStandardName == null ? other$industryStandardName != null : !this$industryStandardName.equals(other$industryStandardName)) {
                return false;
            }
            String this$productStandardID = this.productStandardID;
            String other$productStandardID = other.productStandardID;
            if (this$productStandardID == null ? other$productStandardID != null : !this$productStandardID.equals(other$productStandardID)) {
                return false;
            }
            String this$internationalArticleNumberCat = this.internationalArticleNumberCat;
            String other$internationalArticleNumberCat = other.internationalArticleNumberCat;
            if (this$internationalArticleNumberCat == null ? other$internationalArticleNumberCat != null : !this$internationalArticleNumberCat.equals(other$internationalArticleNumberCat)) {
                return false;
            }
            Boolean this$productIsConfigurable = this.productIsConfigurable;
            Boolean other$productIsConfigurable = other.productIsConfigurable;
            if (this$productIsConfigurable == null ? other$productIsConfigurable != null : !((Object)this$productIsConfigurable).equals(other$productIsConfigurable)) {
                return false;
            }
            Boolean this$isBatchManagementRequired = this.isBatchManagementRequired;
            Boolean other$isBatchManagementRequired = other.isBatchManagementRequired;
            if (this$isBatchManagementRequired == null ? other$isBatchManagementRequired != null : !((Object)this$isBatchManagementRequired).equals(other$isBatchManagementRequired)) {
                return false;
            }
            String this$externalProductGroup = this.externalProductGroup;
            String other$externalProductGroup = other.externalProductGroup;
            if (this$externalProductGroup == null ? other$externalProductGroup != null : !this$externalProductGroup.equals(other$externalProductGroup)) {
                return false;
            }
            String this$crossPlantConfigurableProduct = this.crossPlantConfigurableProduct;
            String other$crossPlantConfigurableProduct = other.crossPlantConfigurableProduct;
            if (this$crossPlantConfigurableProduct == null ? other$crossPlantConfigurableProduct != null : !this$crossPlantConfigurableProduct.equals(other$crossPlantConfigurableProduct)) {
                return false;
            }
            Calendar this$crossPlantStatusValidityDate = this.crossPlantStatusValidityDate;
            Calendar other$crossPlantStatusValidityDate = other.crossPlantStatusValidityDate;
            if (this$crossPlantStatusValidityDate == null ? other$crossPlantStatusValidityDate != null : !((Object)this$crossPlantStatusValidityDate).equals(other$crossPlantStatusValidityDate)) {
                return false;
            }
            String this$serialNoExplicitnessLevel = this.serialNoExplicitnessLevel;
            String other$serialNoExplicitnessLevel = other.serialNoExplicitnessLevel;
            if (this$serialNoExplicitnessLevel == null ? other$serialNoExplicitnessLevel != null : !this$serialNoExplicitnessLevel.equals(other$serialNoExplicitnessLevel)) {
                return false;
            }
            String this$productManufacturerNumber = this.productManufacturerNumber;
            String other$productManufacturerNumber = other.productManufacturerNumber;
            if (this$productManufacturerNumber == null ? other$productManufacturerNumber != null : !this$productManufacturerNumber.equals(other$productManufacturerNumber)) {
                return false;
            }
            String this$manufacturerPartProfile = this.manufacturerPartProfile;
            String other$manufacturerPartProfile = other.manufacturerPartProfile;
            if (this$manufacturerPartProfile == null ? other$manufacturerPartProfile != null : !this$manufacturerPartProfile.equals(other$manufacturerPartProfile)) {
                return false;
            }
            String this$changeNumber = this.changeNumber;
            String other$changeNumber = other.changeNumber;
            if (this$changeNumber == null ? other$changeNumber != null : !this$changeNumber.equals(other$changeNumber)) {
                return false;
            }
            String this$materialRevisionLevel = this.materialRevisionLevel;
            String other$materialRevisionLevel = other.materialRevisionLevel;
            if (this$materialRevisionLevel == null ? other$materialRevisionLevel != null : !this$materialRevisionLevel.equals(other$materialRevisionLevel)) {
                return false;
            }
            String this$handlingIndicator = this.handlingIndicator;
            String other$handlingIndicator = other.handlingIndicator;
            if (this$handlingIndicator == null ? other$handlingIndicator != null : !this$handlingIndicator.equals(other$handlingIndicator)) {
                return false;
            }
            String this$warehouseProductGroup = this.warehouseProductGroup;
            String other$warehouseProductGroup = other.warehouseProductGroup;
            if (this$warehouseProductGroup == null ? other$warehouseProductGroup != null : !this$warehouseProductGroup.equals(other$warehouseProductGroup)) {
                return false;
            }
            String this$warehouseStorageCondition = this.warehouseStorageCondition;
            String other$warehouseStorageCondition = other.warehouseStorageCondition;
            if (this$warehouseStorageCondition == null ? other$warehouseStorageCondition != null : !this$warehouseStorageCondition.equals(other$warehouseStorageCondition)) {
                return false;
            }
            String this$standardHandlingUnitType = this.standardHandlingUnitType;
            String other$standardHandlingUnitType = other.standardHandlingUnitType;
            if (this$standardHandlingUnitType == null ? other$standardHandlingUnitType != null : !this$standardHandlingUnitType.equals(other$standardHandlingUnitType)) {
                return false;
            }
            String this$serialNumberProfile = this.serialNumberProfile;
            String other$serialNumberProfile = other.serialNumberProfile;
            if (this$serialNumberProfile == null ? other$serialNumberProfile != null : !this$serialNumberProfile.equals(other$serialNumberProfile)) {
                return false;
            }
            Calendar this$creationDate = this.creationDate;
            Calendar other$creationDate = other.creationDate;
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            String this$adjustmentProfile = this.adjustmentProfile;
            String other$adjustmentProfile = other.adjustmentProfile;
            if (this$adjustmentProfile == null ? other$adjustmentProfile != null : !this$adjustmentProfile.equals(other$adjustmentProfile)) {
                return false;
            }
            Boolean this$isPilferable = this.isPilferable;
            Boolean other$isPilferable = other.isPilferable;
            if (this$isPilferable == null ? other$isPilferable != null : !((Object)this$isPilferable).equals(other$isPilferable)) {
                return false;
            }
            Boolean this$isRelevantForHzdsSubstances = this.isRelevantForHzdsSubstances;
            Boolean other$isRelevantForHzdsSubstances = other.isRelevantForHzdsSubstances;
            if (this$isRelevantForHzdsSubstances == null ? other$isRelevantForHzdsSubstances != null : !((Object)this$isRelevantForHzdsSubstances).equals(other$isRelevantForHzdsSubstances)) {
                return false;
            }
            BigDecimal this$quarantinePeriod = this.quarantinePeriod;
            BigDecimal other$quarantinePeriod = other.quarantinePeriod;
            if (this$quarantinePeriod == null ? other$quarantinePeriod != null : !((Object)this$quarantinePeriod).equals(other$quarantinePeriod)) {
                return false;
            }
            String this$timeUnitForQuarantinePeriod = this.timeUnitForQuarantinePeriod;
            String other$timeUnitForQuarantinePeriod = other.timeUnitForQuarantinePeriod;
            if (this$timeUnitForQuarantinePeriod == null ? other$timeUnitForQuarantinePeriod != null : !this$timeUnitForQuarantinePeriod.equals(other$timeUnitForQuarantinePeriod)) {
                return false;
            }
            String this$qualityInspectionGroup = this.qualityInspectionGroup;
            String other$qualityInspectionGroup = other.qualityInspectionGroup;
            if (this$qualityInspectionGroup == null ? other$qualityInspectionGroup != null : !this$qualityInspectionGroup.equals(other$qualityInspectionGroup)) {
                return false;
            }
            String this$authorizationGroup = this.authorizationGroup;
            String other$authorizationGroup = other.authorizationGroup;
            if (this$authorizationGroup == null ? other$authorizationGroup != null : !this$authorizationGroup.equals(other$authorizationGroup)) {
                return false;
            }
            String this$handlingUnitType = this.handlingUnitType;
            String other$handlingUnitType = other.handlingUnitType;
            if (this$handlingUnitType == null ? other$handlingUnitType != null : !this$handlingUnitType.equals(other$handlingUnitType)) {
                return false;
            }
            Boolean this$hasVariableTareWeight = this.hasVariableTareWeight;
            Boolean other$hasVariableTareWeight = other.hasVariableTareWeight;
            if (this$hasVariableTareWeight == null ? other$hasVariableTareWeight != null : !((Object)this$hasVariableTareWeight).equals(other$hasVariableTareWeight)) {
                return false;
            }
            BigDecimal this$maximumPackagingLength = this.maximumPackagingLength;
            BigDecimal other$maximumPackagingLength = other.maximumPackagingLength;
            if (this$maximumPackagingLength == null ? other$maximumPackagingLength != null : !((Object)this$maximumPackagingLength).equals(other$maximumPackagingLength)) {
                return false;
            }
            String this$createdByUser = this.createdByUser;
            String other$createdByUser = other.createdByUser;
            if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
                return false;
            }
            BigDecimal this$maximumPackagingWidth = this.maximumPackagingWidth;
            BigDecimal other$maximumPackagingWidth = other.maximumPackagingWidth;
            if (this$maximumPackagingWidth == null ? other$maximumPackagingWidth != null : !((Object)this$maximumPackagingWidth).equals(other$maximumPackagingWidth)) {
                return false;
            }
            BigDecimal this$maximumPackagingHeight = this.maximumPackagingHeight;
            BigDecimal other$maximumPackagingHeight = other.maximumPackagingHeight;
            if (this$maximumPackagingHeight == null ? other$maximumPackagingHeight != null : !((Object)this$maximumPackagingHeight).equals(other$maximumPackagingHeight)) {
                return false;
            }
            Calendar this$lastChangeDate = this.lastChangeDate;
            Calendar other$lastChangeDate = other.lastChangeDate;
            if (this$lastChangeDate == null ? other$lastChangeDate != null : !((Object)this$lastChangeDate).equals(other$lastChangeDate)) {
                return false;
            }
            String this$lastChangedByUser = this.lastChangedByUser;
            String other$lastChangedByUser = other.lastChangedByUser;
            if (this$lastChangedByUser == null ? other$lastChangedByUser != null : !this$lastChangedByUser.equals(other$lastChangedByUser)) {
                return false;
            }
            Boolean this$isMarkedForDeletion = this.isMarkedForDeletion;
            Boolean other$isMarkedForDeletion = other.isMarkedForDeletion;
            return !(this$isMarkedForDeletion == null ? other$isMarkedForDeletion != null : !((Object)this$isMarkedForDeletion).equals(other$isMarkedForDeletion));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Product;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $product = this.product;
            result = result * 59 + ($product == null ? 43 : $product.hashCode());
            String $productOldID = this.productOldID;
            result = result * 59 + ($productOldID == null ? 43 : $productOldID.hashCode());
            BigDecimal $grossWeight = this.grossWeight;
            result = result * 59 + ($grossWeight == null ? 43 : ((Object)$grossWeight).hashCode());
            String $purchaseOrderQuantityUnit = this.purchaseOrderQuantityUnit;
            result = result * 59 + ($purchaseOrderQuantityUnit == null ? 43 : $purchaseOrderQuantityUnit.hashCode());
            String $sourceOfSupply = this.sourceOfSupply;
            result = result * 59 + ($sourceOfSupply == null ? 43 : $sourceOfSupply.hashCode());
            String $weightUnit = this.weightUnit;
            result = result * 59 + ($weightUnit == null ? 43 : $weightUnit.hashCode());
            BigDecimal $netWeight = this.netWeight;
            result = result * 59 + ($netWeight == null ? 43 : ((Object)$netWeight).hashCode());
            String $countryOfOrigin = this.countryOfOrigin;
            result = result * 59 + ($countryOfOrigin == null ? 43 : $countryOfOrigin.hashCode());
            String $competitorID = this.competitorID;
            result = result * 59 + ($competitorID == null ? 43 : $competitorID.hashCode());
            String $productGroup = this.productGroup;
            result = result * 59 + ($productGroup == null ? 43 : $productGroup.hashCode());
            String $baseUnit = this.baseUnit;
            result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
            String $productType = this.productType;
            result = result * 59 + ($productType == null ? 43 : $productType.hashCode());
            String $itemCategoryGroup = this.itemCategoryGroup;
            result = result * 59 + ($itemCategoryGroup == null ? 43 : $itemCategoryGroup.hashCode());
            String $productHierarchy = this.productHierarchy;
            result = result * 59 + ($productHierarchy == null ? 43 : $productHierarchy.hashCode());
            String $division = this.division;
            result = result * 59 + ($division == null ? 43 : $division.hashCode());
            String $volumeUnit = this.volumeUnit;
            result = result * 59 + ($volumeUnit == null ? 43 : $volumeUnit.hashCode());
            BigDecimal $materialVolume = this.materialVolume;
            result = result * 59 + ($materialVolume == null ? 43 : ((Object)$materialVolume).hashCode());
            String $aNPCode = this.aNPCode;
            result = result * 59 + ($aNPCode == null ? 43 : $aNPCode.hashCode());
            String $brand = this.brand;
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            String $procurementRule = this.procurementRule;
            result = result * 59 + ($procurementRule == null ? 43 : $procurementRule.hashCode());
            Calendar $validityStartDate = this.validityStartDate;
            result = result * 59 + ($validityStartDate == null ? 43 : ((Object)$validityStartDate).hashCode());
            String $lowLevelCode = this.lowLevelCode;
            result = result * 59 + ($lowLevelCode == null ? 43 : $lowLevelCode.hashCode());
            String $crossPlantStatus = this.crossPlantStatus;
            result = result * 59 + ($crossPlantStatus == null ? 43 : $crossPlantStatus.hashCode());
            String $prodNoInGenProdInPrepackProd = this.prodNoInGenProdInPrepackProd;
            result = result * 59 + ($prodNoInGenProdInPrepackProd == null ? 43 : $prodNoInGenProdInPrepackProd.hashCode());
            String $serialIdentifierAssgmtProfile = this.serialIdentifierAssgmtProfile;
            result = result * 59 + ($serialIdentifierAssgmtProfile == null ? 43 : $serialIdentifierAssgmtProfile.hashCode());
            String $sizeOrDimensionText = this.sizeOrDimensionText;
            result = result * 59 + ($sizeOrDimensionText == null ? 43 : $sizeOrDimensionText.hashCode());
            String $industryStandardName = this.industryStandardName;
            result = result * 59 + ($industryStandardName == null ? 43 : $industryStandardName.hashCode());
            String $productStandardID = this.productStandardID;
            result = result * 59 + ($productStandardID == null ? 43 : $productStandardID.hashCode());
            String $internationalArticleNumberCat = this.internationalArticleNumberCat;
            result = result * 59 + ($internationalArticleNumberCat == null ? 43 : $internationalArticleNumberCat.hashCode());
            Boolean $productIsConfigurable = this.productIsConfigurable;
            result = result * 59 + ($productIsConfigurable == null ? 43 : ((Object)$productIsConfigurable).hashCode());
            Boolean $isBatchManagementRequired = this.isBatchManagementRequired;
            result = result * 59 + ($isBatchManagementRequired == null ? 43 : ((Object)$isBatchManagementRequired).hashCode());
            String $externalProductGroup = this.externalProductGroup;
            result = result * 59 + ($externalProductGroup == null ? 43 : $externalProductGroup.hashCode());
            String $crossPlantConfigurableProduct = this.crossPlantConfigurableProduct;
            result = result * 59 + ($crossPlantConfigurableProduct == null ? 43 : $crossPlantConfigurableProduct.hashCode());
            Calendar $crossPlantStatusValidityDate = this.crossPlantStatusValidityDate;
            result = result * 59 + ($crossPlantStatusValidityDate == null ? 43 : ((Object)$crossPlantStatusValidityDate).hashCode());
            String $serialNoExplicitnessLevel = this.serialNoExplicitnessLevel;
            result = result * 59 + ($serialNoExplicitnessLevel == null ? 43 : $serialNoExplicitnessLevel.hashCode());
            String $productManufacturerNumber = this.productManufacturerNumber;
            result = result * 59 + ($productManufacturerNumber == null ? 43 : $productManufacturerNumber.hashCode());
            String $manufacturerPartProfile = this.manufacturerPartProfile;
            result = result * 59 + ($manufacturerPartProfile == null ? 43 : $manufacturerPartProfile.hashCode());
            String $changeNumber = this.changeNumber;
            result = result * 59 + ($changeNumber == null ? 43 : $changeNumber.hashCode());
            String $materialRevisionLevel = this.materialRevisionLevel;
            result = result * 59 + ($materialRevisionLevel == null ? 43 : $materialRevisionLevel.hashCode());
            String $handlingIndicator = this.handlingIndicator;
            result = result * 59 + ($handlingIndicator == null ? 43 : $handlingIndicator.hashCode());
            String $warehouseProductGroup = this.warehouseProductGroup;
            result = result * 59 + ($warehouseProductGroup == null ? 43 : $warehouseProductGroup.hashCode());
            String $warehouseStorageCondition = this.warehouseStorageCondition;
            result = result * 59 + ($warehouseStorageCondition == null ? 43 : $warehouseStorageCondition.hashCode());
            String $standardHandlingUnitType = this.standardHandlingUnitType;
            result = result * 59 + ($standardHandlingUnitType == null ? 43 : $standardHandlingUnitType.hashCode());
            String $serialNumberProfile = this.serialNumberProfile;
            result = result * 59 + ($serialNumberProfile == null ? 43 : $serialNumberProfile.hashCode());
            Calendar $creationDate = this.creationDate;
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            String $adjustmentProfile = this.adjustmentProfile;
            result = result * 59 + ($adjustmentProfile == null ? 43 : $adjustmentProfile.hashCode());
            Boolean $isPilferable = this.isPilferable;
            result = result * 59 + ($isPilferable == null ? 43 : ((Object)$isPilferable).hashCode());
            Boolean $isRelevantForHzdsSubstances = this.isRelevantForHzdsSubstances;
            result = result * 59 + ($isRelevantForHzdsSubstances == null ? 43 : ((Object)$isRelevantForHzdsSubstances).hashCode());
            BigDecimal $quarantinePeriod = this.quarantinePeriod;
            result = result * 59 + ($quarantinePeriod == null ? 43 : ((Object)$quarantinePeriod).hashCode());
            String $timeUnitForQuarantinePeriod = this.timeUnitForQuarantinePeriod;
            result = result * 59 + ($timeUnitForQuarantinePeriod == null ? 43 : $timeUnitForQuarantinePeriod.hashCode());
            String $qualityInspectionGroup = this.qualityInspectionGroup;
            result = result * 59 + ($qualityInspectionGroup == null ? 43 : $qualityInspectionGroup.hashCode());
            String $authorizationGroup = this.authorizationGroup;
            result = result * 59 + ($authorizationGroup == null ? 43 : $authorizationGroup.hashCode());
            String $handlingUnitType = this.handlingUnitType;
            result = result * 59 + ($handlingUnitType == null ? 43 : $handlingUnitType.hashCode());
            Boolean $hasVariableTareWeight = this.hasVariableTareWeight;
            result = result * 59 + ($hasVariableTareWeight == null ? 43 : ((Object)$hasVariableTareWeight).hashCode());
            BigDecimal $maximumPackagingLength = this.maximumPackagingLength;
            result = result * 59 + ($maximumPackagingLength == null ? 43 : ((Object)$maximumPackagingLength).hashCode());
            String $createdByUser = this.createdByUser;
            result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
            BigDecimal $maximumPackagingWidth = this.maximumPackagingWidth;
            result = result * 59 + ($maximumPackagingWidth == null ? 43 : ((Object)$maximumPackagingWidth).hashCode());
            BigDecimal $maximumPackagingHeight = this.maximumPackagingHeight;
            result = result * 59 + ($maximumPackagingHeight == null ? 43 : ((Object)$maximumPackagingHeight).hashCode());
            Calendar $lastChangeDate = this.lastChangeDate;
            result = result * 59 + ($lastChangeDate == null ? 43 : ((Object)$lastChangeDate).hashCode());
            String $lastChangedByUser = this.lastChangedByUser;
            result = result * 59 + ($lastChangedByUser == null ? 43 : $lastChangedByUser.hashCode());
            Boolean $isMarkedForDeletion = this.isMarkedForDeletion;
            result = result * 59 + ($isMarkedForDeletion == null ? 43 : ((Object)$isMarkedForDeletion).hashCode());
            return result;
        }

        public String getProduct() {
            return this.product;
        }

        public Product setProduct(String product) {
            this.product = product;
            return this;
        }

        public String getProductOldID() {
            return this.productOldID;
        }

        public Product setProductOldID(String productOldID) {
            this.productOldID = productOldID;
            return this;
        }

        public BigDecimal getGrossWeight() {
            return this.grossWeight;
        }

        public Product setGrossWeight(BigDecimal grossWeight) {
            this.grossWeight = grossWeight;
            return this;
        }

        public String getPurchaseOrderQuantityUnit() {
            return this.purchaseOrderQuantityUnit;
        }

        public Product setPurchaseOrderQuantityUnit(String purchaseOrderQuantityUnit) {
            this.purchaseOrderQuantityUnit = purchaseOrderQuantityUnit;
            return this;
        }

        public String getSourceOfSupply() {
            return this.sourceOfSupply;
        }

        public Product setSourceOfSupply(String sourceOfSupply) {
            this.sourceOfSupply = sourceOfSupply;
            return this;
        }

        public String getWeightUnit() {
            return this.weightUnit;
        }

        public Product setWeightUnit(String weightUnit) {
            this.weightUnit = weightUnit;
            return this;
        }

        public BigDecimal getNetWeight() {
            return this.netWeight;
        }

        public Product setNetWeight(BigDecimal netWeight) {
            this.netWeight = netWeight;
            return this;
        }

        public String getCountryOfOrigin() {
            return this.countryOfOrigin;
        }

        public Product setCountryOfOrigin(String countryOfOrigin) {
            this.countryOfOrigin = countryOfOrigin;
            return this;
        }

        public String getCompetitorID() {
            return this.competitorID;
        }

        public Product setCompetitorID(String competitorID) {
            this.competitorID = competitorID;
            return this;
        }

        public String getProductGroup() {
            return this.productGroup;
        }

        public Product setProductGroup(String productGroup) {
            this.productGroup = productGroup;
            return this;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public Product setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        public String getProductType() {
            return this.productType;
        }

        public Product setProductType(String productType) {
            this.productType = productType;
            return this;
        }

        public String getItemCategoryGroup() {
            return this.itemCategoryGroup;
        }

        public Product setItemCategoryGroup(String itemCategoryGroup) {
            this.itemCategoryGroup = itemCategoryGroup;
            return this;
        }

        public String getProductHierarchy() {
            return this.productHierarchy;
        }

        public Product setProductHierarchy(String productHierarchy) {
            this.productHierarchy = productHierarchy;
            return this;
        }

        public String getDivision() {
            return this.division;
        }

        public Product setDivision(String division) {
            this.division = division;
            return this;
        }

        public String getVolumeUnit() {
            return this.volumeUnit;
        }

        public Product setVolumeUnit(String volumeUnit) {
            this.volumeUnit = volumeUnit;
            return this;
        }

        public BigDecimal getMaterialVolume() {
            return this.materialVolume;
        }

        public Product setMaterialVolume(BigDecimal materialVolume) {
            this.materialVolume = materialVolume;
            return this;
        }

        public String getANPCode() {
            return this.aNPCode;
        }

        public Product setANPCode(String aNPCode) {
            this.aNPCode = aNPCode;
            return this;
        }

        public String getBrand() {
            return this.brand;
        }

        public Product setBrand(String brand) {
            this.brand = brand;
            return this;
        }

        public String getProcurementRule() {
            return this.procurementRule;
        }

        public Product setProcurementRule(String procurementRule) {
            this.procurementRule = procurementRule;
            return this;
        }

        public Calendar getValidityStartDate() {
            return this.validityStartDate;
        }

        public Product setValidityStartDate(Calendar validityStartDate) {
            this.validityStartDate = validityStartDate;
            return this;
        }

        public String getLowLevelCode() {
            return this.lowLevelCode;
        }

        public Product setLowLevelCode(String lowLevelCode) {
            this.lowLevelCode = lowLevelCode;
            return this;
        }

        public String getCrossPlantStatus() {
            return this.crossPlantStatus;
        }

        public Product setCrossPlantStatus(String crossPlantStatus) {
            this.crossPlantStatus = crossPlantStatus;
            return this;
        }

        public String getProdNoInGenProdInPrepackProd() {
            return this.prodNoInGenProdInPrepackProd;
        }

        public Product setProdNoInGenProdInPrepackProd(String prodNoInGenProdInPrepackProd) {
            this.prodNoInGenProdInPrepackProd = prodNoInGenProdInPrepackProd;
            return this;
        }

        public String getSerialIdentifierAssgmtProfile() {
            return this.serialIdentifierAssgmtProfile;
        }

        public Product setSerialIdentifierAssgmtProfile(String serialIdentifierAssgmtProfile) {
            this.serialIdentifierAssgmtProfile = serialIdentifierAssgmtProfile;
            return this;
        }

        public String getSizeOrDimensionText() {
            return this.sizeOrDimensionText;
        }

        public Product setSizeOrDimensionText(String sizeOrDimensionText) {
            this.sizeOrDimensionText = sizeOrDimensionText;
            return this;
        }

        public String getIndustryStandardName() {
            return this.industryStandardName;
        }

        public Product setIndustryStandardName(String industryStandardName) {
            this.industryStandardName = industryStandardName;
            return this;
        }

        public String getProductStandardID() {
            return this.productStandardID;
        }

        public Product setProductStandardID(String productStandardID) {
            this.productStandardID = productStandardID;
            return this;
        }

        public String getInternationalArticleNumberCat() {
            return this.internationalArticleNumberCat;
        }

        public Product setInternationalArticleNumberCat(String internationalArticleNumberCat) {
            this.internationalArticleNumberCat = internationalArticleNumberCat;
            return this;
        }

        public Boolean getProductIsConfigurable() {
            return this.productIsConfigurable;
        }

        public Product setProductIsConfigurable(Boolean productIsConfigurable) {
            this.productIsConfigurable = productIsConfigurable;
            return this;
        }

        public Boolean getIsBatchManagementRequired() {
            return this.isBatchManagementRequired;
        }

        public Product setIsBatchManagementRequired(Boolean isBatchManagementRequired) {
            this.isBatchManagementRequired = isBatchManagementRequired;
            return this;
        }

        public String getExternalProductGroup() {
            return this.externalProductGroup;
        }

        public Product setExternalProductGroup(String externalProductGroup) {
            this.externalProductGroup = externalProductGroup;
            return this;
        }

        public String getCrossPlantConfigurableProduct() {
            return this.crossPlantConfigurableProduct;
        }

        public Product setCrossPlantConfigurableProduct(String crossPlantConfigurableProduct) {
            this.crossPlantConfigurableProduct = crossPlantConfigurableProduct;
            return this;
        }

        public Calendar getCrossPlantStatusValidityDate() {
            return this.crossPlantStatusValidityDate;
        }

        public Product setCrossPlantStatusValidityDate(Calendar crossPlantStatusValidityDate) {
            this.crossPlantStatusValidityDate = crossPlantStatusValidityDate;
            return this;
        }

        public String getSerialNoExplicitnessLevel() {
            return this.serialNoExplicitnessLevel;
        }

        public Product setSerialNoExplicitnessLevel(String serialNoExplicitnessLevel) {
            this.serialNoExplicitnessLevel = serialNoExplicitnessLevel;
            return this;
        }

        public String getProductManufacturerNumber() {
            return this.productManufacturerNumber;
        }

        public Product setProductManufacturerNumber(String productManufacturerNumber) {
            this.productManufacturerNumber = productManufacturerNumber;
            return this;
        }

        public String getManufacturerPartProfile() {
            return this.manufacturerPartProfile;
        }

        public Product setManufacturerPartProfile(String manufacturerPartProfile) {
            this.manufacturerPartProfile = manufacturerPartProfile;
            return this;
        }

        public String getChangeNumber() {
            return this.changeNumber;
        }

        public Product setChangeNumber(String changeNumber) {
            this.changeNumber = changeNumber;
            return this;
        }

        public String getMaterialRevisionLevel() {
            return this.materialRevisionLevel;
        }

        public Product setMaterialRevisionLevel(String materialRevisionLevel) {
            this.materialRevisionLevel = materialRevisionLevel;
            return this;
        }

        public String getHandlingIndicator() {
            return this.handlingIndicator;
        }

        public Product setHandlingIndicator(String handlingIndicator) {
            this.handlingIndicator = handlingIndicator;
            return this;
        }

        public String getWarehouseProductGroup() {
            return this.warehouseProductGroup;
        }

        public Product setWarehouseProductGroup(String warehouseProductGroup) {
            this.warehouseProductGroup = warehouseProductGroup;
            return this;
        }

        public String getWarehouseStorageCondition() {
            return this.warehouseStorageCondition;
        }

        public Product setWarehouseStorageCondition(String warehouseStorageCondition) {
            this.warehouseStorageCondition = warehouseStorageCondition;
            return this;
        }

        public String getStandardHandlingUnitType() {
            return this.standardHandlingUnitType;
        }

        public Product setStandardHandlingUnitType(String standardHandlingUnitType) {
            this.standardHandlingUnitType = standardHandlingUnitType;
            return this;
        }

        public String getSerialNumberProfile() {
            return this.serialNumberProfile;
        }

        public Product setSerialNumberProfile(String serialNumberProfile) {
            this.serialNumberProfile = serialNumberProfile;
            return this;
        }

        public Calendar getCreationDate() {
            return this.creationDate;
        }

        public Product setCreationDate(Calendar creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public String getAdjustmentProfile() {
            return this.adjustmentProfile;
        }

        public Product setAdjustmentProfile(String adjustmentProfile) {
            this.adjustmentProfile = adjustmentProfile;
            return this;
        }

        public Boolean getIsPilferable() {
            return this.isPilferable;
        }

        public Product setIsPilferable(Boolean isPilferable) {
            this.isPilferable = isPilferable;
            return this;
        }

        public Boolean getIsRelevantForHzdsSubstances() {
            return this.isRelevantForHzdsSubstances;
        }

        public Product setIsRelevantForHzdsSubstances(Boolean isRelevantForHzdsSubstances) {
            this.isRelevantForHzdsSubstances = isRelevantForHzdsSubstances;
            return this;
        }

        public BigDecimal getQuarantinePeriod() {
            return this.quarantinePeriod;
        }

        public Product setQuarantinePeriod(BigDecimal quarantinePeriod) {
            this.quarantinePeriod = quarantinePeriod;
            return this;
        }

        public String getTimeUnitForQuarantinePeriod() {
            return this.timeUnitForQuarantinePeriod;
        }

        public Product setTimeUnitForQuarantinePeriod(String timeUnitForQuarantinePeriod) {
            this.timeUnitForQuarantinePeriod = timeUnitForQuarantinePeriod;
            return this;
        }

        public String getQualityInspectionGroup() {
            return this.qualityInspectionGroup;
        }

        public Product setQualityInspectionGroup(String qualityInspectionGroup) {
            this.qualityInspectionGroup = qualityInspectionGroup;
            return this;
        }

        public String getAuthorizationGroup() {
            return this.authorizationGroup;
        }

        public Product setAuthorizationGroup(String authorizationGroup) {
            this.authorizationGroup = authorizationGroup;
            return this;
        }

        public String getHandlingUnitType() {
            return this.handlingUnitType;
        }

        public Product setHandlingUnitType(String handlingUnitType) {
            this.handlingUnitType = handlingUnitType;
            return this;
        }

        public Boolean getHasVariableTareWeight() {
            return this.hasVariableTareWeight;
        }

        public Product setHasVariableTareWeight(Boolean hasVariableTareWeight) {
            this.hasVariableTareWeight = hasVariableTareWeight;
            return this;
        }

        public BigDecimal getMaximumPackagingLength() {
            return this.maximumPackagingLength;
        }

        public Product setMaximumPackagingLength(BigDecimal maximumPackagingLength) {
            this.maximumPackagingLength = maximumPackagingLength;
            return this;
        }

        public String getCreatedByUser() {
            return this.createdByUser;
        }

        public Product setCreatedByUser(String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        public BigDecimal getMaximumPackagingWidth() {
            return this.maximumPackagingWidth;
        }

        public Product setMaximumPackagingWidth(BigDecimal maximumPackagingWidth) {
            this.maximumPackagingWidth = maximumPackagingWidth;
            return this;
        }

        public BigDecimal getMaximumPackagingHeight() {
            return this.maximumPackagingHeight;
        }

        public Product setMaximumPackagingHeight(BigDecimal maximumPackagingHeight) {
            this.maximumPackagingHeight = maximumPackagingHeight;
            return this;
        }

        public Calendar getLastChangeDate() {
            return this.lastChangeDate;
        }

        public Product setLastChangeDate(Calendar lastChangeDate) {
            this.lastChangeDate = lastChangeDate;
            return this;
        }

        public String getLastChangedByUser() {
            return this.lastChangedByUser;
        }

        public Product setLastChangedByUser(String lastChangedByUser) {
            this.lastChangedByUser = lastChangedByUser;
            return this;
        }

        public Boolean getIsMarkedForDeletion() {
            return this.isMarkedForDeletion;
        }

        public Product setIsMarkedForDeletion(Boolean isMarkedForDeletion) {
            this.isMarkedForDeletion = isMarkedForDeletion;
            return this;
        }

        public Product setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

