/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ProcessSalesOrdersNamespace {

    public static class SalesOrderScheduleLineFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderScheduleLine");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderScheduleLineFluentHelper filter(ExpressionFluentHelper<SalesOrderScheduleLine> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderScheduleLineFluentHelper orderBy(EntityField<?, SalesOrderScheduleLine> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderScheduleLineFluentHelper select(EntityField<?, SalesOrderScheduleLine> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderScheduleLineFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderScheduleLineFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderScheduleLineFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrderScheduleLine> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrderScheduleLine.class);
            for (SalesOrderScheduleLine entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderScheduleLineByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderScheduleLineByKeyFluentHelper(String salesOrder, String salesOrderItem, String scheduleLine) {
            this.values.add(salesOrder);
            this.values.add(salesOrderItem);
            this.values.add(scheduleLine);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderScheduleLine");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            keys.put("SalesOrderItem", this.values.get(1));
            keys.put("ScheduleLine", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderScheduleLineByKeyFluentHelper select(EntityField<?, SalesOrderScheduleLine> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderScheduleLineByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrderScheduleLine execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrderScheduleLine entity = (SalesOrderScheduleLine)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrderScheduleLine.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrderScheduleLine {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrderScheduleLine> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, SalesOrderScheduleLine> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="ScheduleLine")
        private String scheduleLine;
        public static EntityField<String, SalesOrderScheduleLine> SCHEDULE_LINE = new EntityField("ScheduleLine");
        @ElementName(value="OrderQuantityUnit")
        private String orderQuantityUnit;
        public static EntityField<String, SalesOrderScheduleLine> ORDER_QUANTITY_UNIT = new EntityField("OrderQuantityUnit");
        @ElementName(value="ConfdOrderQtyByMatlAvailCheck")
        private BigDecimal confdOrderQtyByMatlAvailCheck;
        public static EntityField<BigDecimal, SalesOrderScheduleLine> CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK = new EntityField("ConfdOrderQtyByMatlAvailCheck");
        @ElementName(value="DeliveredQtyInOrderQtyUnit")
        private BigDecimal deliveredQtyInOrderQtyUnit;
        public static EntityField<BigDecimal, SalesOrderScheduleLine> DELIVERED_QTY_IN_ORDER_QTY_UNIT = new EntityField("DeliveredQtyInOrderQtyUnit");
        @ElementName(value="OpenConfdDelivQtyInOrdQtyUnit")
        private BigDecimal openConfdDelivQtyInOrdQtyUnit;
        public static EntityField<BigDecimal, SalesOrderScheduleLine> OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT = new EntityField("OpenConfdDelivQtyInOrdQtyUnit");
        @ElementName(value="DelivBlockReasonForSchedLine")
        private String delivBlockReasonForSchedLine;
        public static EntityField<String, SalesOrderScheduleLine> DELIV_BLOCK_REASON_FOR_SCHED_LINE = new EntityField("DelivBlockReasonForSchedLine");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrderScheduleLine";
        private transient ErpConfigContext erpConfigContext;

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrderScheduleLine(salesOrder=" + this.salesOrder + ", salesOrderItem=" + this.salesOrderItem + ", scheduleLine=" + this.scheduleLine + ", orderQuantityUnit=" + this.orderQuantityUnit + ", confdOrderQtyByMatlAvailCheck=" + this.confdOrderQtyByMatlAvailCheck + ", deliveredQtyInOrderQtyUnit=" + this.deliveredQtyInOrderQtyUnit + ", openConfdDelivQtyInOrdQtyUnit=" + this.openConfdDelivQtyInOrdQtyUnit + ", delivBlockReasonForSchedLine=" + this.delivBlockReasonForSchedLine + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrderScheduleLine)) {
                return false;
            }
            SalesOrderScheduleLine other = (SalesOrderScheduleLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$scheduleLine = this.scheduleLine;
            String other$scheduleLine = other.scheduleLine;
            if (this$scheduleLine == null ? other$scheduleLine != null : !this$scheduleLine.equals(other$scheduleLine)) {
                return false;
            }
            String this$orderQuantityUnit = this.orderQuantityUnit;
            String other$orderQuantityUnit = other.orderQuantityUnit;
            if (this$orderQuantityUnit == null ? other$orderQuantityUnit != null : !this$orderQuantityUnit.equals(other$orderQuantityUnit)) {
                return false;
            }
            BigDecimal this$confdOrderQtyByMatlAvailCheck = this.confdOrderQtyByMatlAvailCheck;
            BigDecimal other$confdOrderQtyByMatlAvailCheck = other.confdOrderQtyByMatlAvailCheck;
            if (this$confdOrderQtyByMatlAvailCheck == null ? other$confdOrderQtyByMatlAvailCheck != null : !((Object)this$confdOrderQtyByMatlAvailCheck).equals(other$confdOrderQtyByMatlAvailCheck)) {
                return false;
            }
            BigDecimal this$deliveredQtyInOrderQtyUnit = this.deliveredQtyInOrderQtyUnit;
            BigDecimal other$deliveredQtyInOrderQtyUnit = other.deliveredQtyInOrderQtyUnit;
            if (this$deliveredQtyInOrderQtyUnit == null ? other$deliveredQtyInOrderQtyUnit != null : !((Object)this$deliveredQtyInOrderQtyUnit).equals(other$deliveredQtyInOrderQtyUnit)) {
                return false;
            }
            BigDecimal this$openConfdDelivQtyInOrdQtyUnit = this.openConfdDelivQtyInOrdQtyUnit;
            BigDecimal other$openConfdDelivQtyInOrdQtyUnit = other.openConfdDelivQtyInOrdQtyUnit;
            if (this$openConfdDelivQtyInOrdQtyUnit == null ? other$openConfdDelivQtyInOrdQtyUnit != null : !((Object)this$openConfdDelivQtyInOrdQtyUnit).equals(other$openConfdDelivQtyInOrdQtyUnit)) {
                return false;
            }
            String this$delivBlockReasonForSchedLine = this.delivBlockReasonForSchedLine;
            String other$delivBlockReasonForSchedLine = other.delivBlockReasonForSchedLine;
            return !(this$delivBlockReasonForSchedLine == null ? other$delivBlockReasonForSchedLine != null : !this$delivBlockReasonForSchedLine.equals(other$delivBlockReasonForSchedLine));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrderScheduleLine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $scheduleLine = this.scheduleLine;
            result = result * 59 + ($scheduleLine == null ? 43 : $scheduleLine.hashCode());
            String $orderQuantityUnit = this.orderQuantityUnit;
            result = result * 59 + ($orderQuantityUnit == null ? 43 : $orderQuantityUnit.hashCode());
            BigDecimal $confdOrderQtyByMatlAvailCheck = this.confdOrderQtyByMatlAvailCheck;
            result = result * 59 + ($confdOrderQtyByMatlAvailCheck == null ? 43 : ((Object)$confdOrderQtyByMatlAvailCheck).hashCode());
            BigDecimal $deliveredQtyInOrderQtyUnit = this.deliveredQtyInOrderQtyUnit;
            result = result * 59 + ($deliveredQtyInOrderQtyUnit == null ? 43 : ((Object)$deliveredQtyInOrderQtyUnit).hashCode());
            BigDecimal $openConfdDelivQtyInOrdQtyUnit = this.openConfdDelivQtyInOrdQtyUnit;
            result = result * 59 + ($openConfdDelivQtyInOrdQtyUnit == null ? 43 : ((Object)$openConfdDelivQtyInOrdQtyUnit).hashCode());
            String $delivBlockReasonForSchedLine = this.delivBlockReasonForSchedLine;
            result = result * 59 + ($delivBlockReasonForSchedLine == null ? 43 : $delivBlockReasonForSchedLine.hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrderScheduleLine setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public SalesOrderScheduleLine setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getScheduleLine() {
            return this.scheduleLine;
        }

        public SalesOrderScheduleLine setScheduleLine(String scheduleLine) {
            this.scheduleLine = scheduleLine;
            return this;
        }

        public String getOrderQuantityUnit() {
            return this.orderQuantityUnit;
        }

        public SalesOrderScheduleLine setOrderQuantityUnit(String orderQuantityUnit) {
            this.orderQuantityUnit = orderQuantityUnit;
            return this;
        }

        public BigDecimal getConfdOrderQtyByMatlAvailCheck() {
            return this.confdOrderQtyByMatlAvailCheck;
        }

        public SalesOrderScheduleLine setConfdOrderQtyByMatlAvailCheck(BigDecimal confdOrderQtyByMatlAvailCheck) {
            this.confdOrderQtyByMatlAvailCheck = confdOrderQtyByMatlAvailCheck;
            return this;
        }

        public BigDecimal getDeliveredQtyInOrderQtyUnit() {
            return this.deliveredQtyInOrderQtyUnit;
        }

        public SalesOrderScheduleLine setDeliveredQtyInOrderQtyUnit(BigDecimal deliveredQtyInOrderQtyUnit) {
            this.deliveredQtyInOrderQtyUnit = deliveredQtyInOrderQtyUnit;
            return this;
        }

        public BigDecimal getOpenConfdDelivQtyInOrdQtyUnit() {
            return this.openConfdDelivQtyInOrdQtyUnit;
        }

        public SalesOrderScheduleLine setOpenConfdDelivQtyInOrdQtyUnit(BigDecimal openConfdDelivQtyInOrdQtyUnit) {
            this.openConfdDelivQtyInOrdQtyUnit = openConfdDelivQtyInOrdQtyUnit;
            return this;
        }

        public String getDelivBlockReasonForSchedLine() {
            return this.delivBlockReasonForSchedLine;
        }

        public SalesOrderScheduleLine setDelivBlockReasonForSchedLine(String delivBlockReasonForSchedLine) {
            this.delivBlockReasonForSchedLine = delivBlockReasonForSchedLine;
            return this;
        }

        public SalesOrderScheduleLine setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class SalesOrderItemPrElementFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderItemPrElement");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderItemPrElementFluentHelper filter(ExpressionFluentHelper<SalesOrderItemPrElement> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderItemPrElementFluentHelper orderBy(EntityField<?, SalesOrderItemPrElement> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderItemPrElementFluentHelper select(EntityField<?, SalesOrderItemPrElement> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderItemPrElementFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderItemPrElementFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderItemPrElementFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrderItemPrElement> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrderItemPrElement.class);
            for (SalesOrderItemPrElement entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderItemPrElementByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderItemPrElementByKeyFluentHelper(String salesOrder, String salesOrderItem, String pricingProcedureStep, String pricingProcedureCounter) {
            this.values.add(salesOrder);
            this.values.add(salesOrderItem);
            this.values.add(pricingProcedureStep);
            this.values.add(pricingProcedureCounter);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderItemPrElement");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            keys.put("SalesOrderItem", this.values.get(1));
            keys.put("PricingProcedureStep", this.values.get(2));
            keys.put("PricingProcedureCounter", this.values.get(3));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderItemPrElementByKeyFluentHelper select(EntityField<?, SalesOrderItemPrElement> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderItemPrElementByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrderItemPrElement execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrderItemPrElement entity = (SalesOrderItemPrElement)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrderItemPrElement.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrderItemPrElement {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrderItemPrElement> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="ConditionCurrency")
        private String conditionCurrency;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_CURRENCY = new EntityField("ConditionCurrency");
        @ElementName(value="ConditionQuantity")
        private BigDecimal conditionQuantity;
        public static EntityField<BigDecimal, SalesOrderItemPrElement> CONDITION_QUANTITY = new EntityField("ConditionQuantity");
        @ElementName(value="ConditionQuantityUnit")
        private String conditionQuantityUnit;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_QUANTITY_UNIT = new EntityField("ConditionQuantityUnit");
        @ElementName(value="ConditionCategory")
        private String conditionCategory;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_CATEGORY = new EntityField("ConditionCategory");
        @ElementName(value="ConditionIsForStatistics")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForStatistics;
        public static EntityField<Boolean, SalesOrderItemPrElement> CONDITION_IS_FOR_STATISTICS = new EntityField("ConditionIsForStatistics");
        @ElementName(value="PricingScaleType")
        private String pricingScaleType;
        public static EntityField<String, SalesOrderItemPrElement> PRICING_SCALE_TYPE = new EntityField("PricingScaleType");
        @ElementName(value="IsRelevantForAccrual")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isRelevantForAccrual;
        public static EntityField<Boolean, SalesOrderItemPrElement> IS_RELEVANT_FOR_ACCRUAL = new EntityField("IsRelevantForAccrual");
        @ElementName(value="CndnIsRelevantForInvoiceList")
        private String cndnIsRelevantForInvoiceList;
        public static EntityField<String, SalesOrderItemPrElement> CNDN_IS_RELEVANT_FOR_INVOICE_LIST = new EntityField("CndnIsRelevantForInvoiceList");
        @ElementName(value="ConditionOrigin")
        private String conditionOrigin;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_ORIGIN = new EntityField("ConditionOrigin");
        @ElementName(value="IsGroupCondition")
        private String isGroupCondition;
        public static EntityField<String, SalesOrderItemPrElement> IS_GROUP_CONDITION = new EntityField("IsGroupCondition");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, SalesOrderItemPrElement> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="ConditionRecord")
        private String conditionRecord;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_RECORD = new EntityField("ConditionRecord");
        @ElementName(value="ConditionSequentialNumber")
        private String conditionSequentialNumber;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_SEQUENTIAL_NUMBER = new EntityField("ConditionSequentialNumber");
        @ElementName(value="TaxCode")
        private String taxCode;
        public static EntityField<String, SalesOrderItemPrElement> TAX_CODE = new EntityField("TaxCode");
        @ElementName(value="WithholdingTaxCode")
        private String withholdingTaxCode;
        public static EntityField<String, SalesOrderItemPrElement> WITHHOLDING_TAX_CODE = new EntityField("WithholdingTaxCode");
        @ElementName(value="CndnRoundingOffDiffAmount")
        private BigDecimal cndnRoundingOffDiffAmount;
        public static EntityField<BigDecimal, SalesOrderItemPrElement> CNDN_ROUNDING_OFF_DIFF_AMOUNT = new EntityField("CndnRoundingOffDiffAmount");
        @ElementName(value="ConditionAmount")
        private BigDecimal conditionAmount;
        public static EntityField<BigDecimal, SalesOrderItemPrElement> CONDITION_AMOUNT = new EntityField("ConditionAmount");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, SalesOrderItemPrElement> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="ConditionControl")
        private String conditionControl;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_CONTROL = new EntityField("ConditionControl");
        @ElementName(value="ConditionInactiveReason")
        private String conditionInactiveReason;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_INACTIVE_REASON = new EntityField("ConditionInactiveReason");
        @ElementName(value="ConditionClass")
        private String conditionClass;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_CLASS = new EntityField("ConditionClass");
        @ElementName(value="PricingProcedureStep")
        private String pricingProcedureStep;
        public static EntityField<String, SalesOrderItemPrElement> PRICING_PROCEDURE_STEP = new EntityField("PricingProcedureStep");
        @ElementName(value="PrcgProcedureCounterForHeader")
        private String prcgProcedureCounterForHeader;
        public static EntityField<String, SalesOrderItemPrElement> PRCG_PROCEDURE_COUNTER_FOR_HEADER = new EntityField("PrcgProcedureCounterForHeader");
        @ElementName(value="FactorForConditionBasisValue")
        private Double factorForConditionBasisValue;
        public static EntityField<Double, SalesOrderItemPrElement> FACTOR_FOR_CONDITION_BASIS_VALUE = new EntityField("FactorForConditionBasisValue");
        @ElementName(value="StructureCondition")
        private String structureCondition;
        public static EntityField<String, SalesOrderItemPrElement> STRUCTURE_CONDITION = new EntityField("StructureCondition");
        @ElementName(value="PeriodFactorForCndnBasisValue")
        private Double periodFactorForCndnBasisValue;
        public static EntityField<Double, SalesOrderItemPrElement> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE = new EntityField("PeriodFactorForCndnBasisValue");
        @ElementName(value="PricingScaleBasis")
        private String pricingScaleBasis;
        public static EntityField<String, SalesOrderItemPrElement> PRICING_SCALE_BASIS = new EntityField("PricingScaleBasis");
        @ElementName(value="ConditionScaleBasisValue")
        private BigDecimal conditionScaleBasisValue;
        public static EntityField<BigDecimal, SalesOrderItemPrElement> CONDITION_SCALE_BASIS_VALUE = new EntityField("ConditionScaleBasisValue");
        @ElementName(value="ConditionScaleBasisUnit")
        private String conditionScaleBasisUnit;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_SCALE_BASIS_UNIT = new EntityField("ConditionScaleBasisUnit");
        @ElementName(value="ConditionScaleBasisCurrency")
        private String conditionScaleBasisCurrency;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_SCALE_BASIS_CURRENCY = new EntityField("ConditionScaleBasisCurrency");
        @ElementName(value="CndnIsRelevantForIntcoBilling")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean cndnIsRelevantForIntcoBilling;
        public static EntityField<Boolean, SalesOrderItemPrElement> CNDN_IS_RELEVANT_FOR_INTCO_BILLING = new EntityField("CndnIsRelevantForIntcoBilling");
        @ElementName(value="ConditionIsManuallyChanged")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsManuallyChanged;
        public static EntityField<Boolean, SalesOrderItemPrElement> CONDITION_IS_MANUALLY_CHANGED = new EntityField("ConditionIsManuallyChanged");
        @ElementName(value="PricingProcedureCounter")
        private String pricingProcedureCounter;
        public static EntityField<String, SalesOrderItemPrElement> PRICING_PROCEDURE_COUNTER = new EntityField("PricingProcedureCounter");
        @ElementName(value="ConditionIsForConfiguration")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForConfiguration;
        public static EntityField<Boolean, SalesOrderItemPrElement> CONDITION_IS_FOR_CONFIGURATION = new EntityField("ConditionIsForConfiguration");
        @ElementName(value="VariantCondition")
        private String variantCondition;
        public static EntityField<String, SalesOrderItemPrElement> VARIANT_CONDITION = new EntityField("VariantCondition");
        @ElementName(value="ConditionType")
        private String conditionType;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_TYPE = new EntityField("ConditionType");
        @ElementName(value="PricingDateTime")
        private String pricingDateTime;
        public static EntityField<String, SalesOrderItemPrElement> PRICING_DATE_TIME = new EntityField("PricingDateTime");
        @ElementName(value="ConditionCalculationType")
        private String conditionCalculationType;
        public static EntityField<String, SalesOrderItemPrElement> CONDITION_CALCULATION_TYPE = new EntityField("ConditionCalculationType");
        @ElementName(value="ConditionBaseValue")
        private BigDecimal conditionBaseValue;
        public static EntityField<BigDecimal, SalesOrderItemPrElement> CONDITION_BASE_VALUE = new EntityField("ConditionBaseValue");
        @ElementName(value="ConditionRateValue")
        private BigDecimal conditionRateValue;
        public static EntityField<BigDecimal, SalesOrderItemPrElement> CONDITION_RATE_VALUE = new EntityField("ConditionRateValue");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrderItemPrElement";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public SalesOrder fetchSalesOrder() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(",PricingProcedureStep=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureStep));
            odataResourceUrl.append(",PricingProcedureCounter=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureCounter));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrder");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrder entityList = (SalesOrder)result.as(SalesOrder.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public SalesOrderItem fetchSalesOrderItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(",PricingProcedureStep=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureStep));
            odataResourceUrl.append(",PricingProcedureCounter=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureCounter));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrderItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrderItem entityList = (SalesOrderItem)result.as(SalesOrderItem.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrderItemPrElement(salesOrder=" + this.salesOrder + ", conditionCurrency=" + this.conditionCurrency + ", conditionQuantity=" + this.conditionQuantity + ", conditionQuantityUnit=" + this.conditionQuantityUnit + ", conditionCategory=" + this.conditionCategory + ", conditionIsForStatistics=" + this.conditionIsForStatistics + ", pricingScaleType=" + this.pricingScaleType + ", isRelevantForAccrual=" + this.isRelevantForAccrual + ", cndnIsRelevantForInvoiceList=" + this.cndnIsRelevantForInvoiceList + ", conditionOrigin=" + this.conditionOrigin + ", isGroupCondition=" + this.isGroupCondition + ", salesOrderItem=" + this.salesOrderItem + ", conditionRecord=" + this.conditionRecord + ", conditionSequentialNumber=" + this.conditionSequentialNumber + ", taxCode=" + this.taxCode + ", withholdingTaxCode=" + this.withholdingTaxCode + ", cndnRoundingOffDiffAmount=" + this.cndnRoundingOffDiffAmount + ", conditionAmount=" + this.conditionAmount + ", transactionCurrency=" + this.transactionCurrency + ", conditionControl=" + this.conditionControl + ", conditionInactiveReason=" + this.conditionInactiveReason + ", conditionClass=" + this.conditionClass + ", pricingProcedureStep=" + this.pricingProcedureStep + ", prcgProcedureCounterForHeader=" + this.prcgProcedureCounterForHeader + ", factorForConditionBasisValue=" + this.factorForConditionBasisValue + ", structureCondition=" + this.structureCondition + ", periodFactorForCndnBasisValue=" + this.periodFactorForCndnBasisValue + ", pricingScaleBasis=" + this.pricingScaleBasis + ", conditionScaleBasisValue=" + this.conditionScaleBasisValue + ", conditionScaleBasisUnit=" + this.conditionScaleBasisUnit + ", conditionScaleBasisCurrency=" + this.conditionScaleBasisCurrency + ", cndnIsRelevantForIntcoBilling=" + this.cndnIsRelevantForIntcoBilling + ", conditionIsManuallyChanged=" + this.conditionIsManuallyChanged + ", pricingProcedureCounter=" + this.pricingProcedureCounter + ", conditionIsForConfiguration=" + this.conditionIsForConfiguration + ", variantCondition=" + this.variantCondition + ", conditionType=" + this.conditionType + ", pricingDateTime=" + this.pricingDateTime + ", conditionCalculationType=" + this.conditionCalculationType + ", conditionBaseValue=" + this.conditionBaseValue + ", conditionRateValue=" + this.conditionRateValue + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrderItemPrElement)) {
                return false;
            }
            SalesOrderItemPrElement other = (SalesOrderItemPrElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$conditionCurrency = this.conditionCurrency;
            String other$conditionCurrency = other.conditionCurrency;
            if (this$conditionCurrency == null ? other$conditionCurrency != null : !this$conditionCurrency.equals(other$conditionCurrency)) {
                return false;
            }
            BigDecimal this$conditionQuantity = this.conditionQuantity;
            BigDecimal other$conditionQuantity = other.conditionQuantity;
            if (this$conditionQuantity == null ? other$conditionQuantity != null : !((Object)this$conditionQuantity).equals(other$conditionQuantity)) {
                return false;
            }
            String this$conditionQuantityUnit = this.conditionQuantityUnit;
            String other$conditionQuantityUnit = other.conditionQuantityUnit;
            if (this$conditionQuantityUnit == null ? other$conditionQuantityUnit != null : !this$conditionQuantityUnit.equals(other$conditionQuantityUnit)) {
                return false;
            }
            String this$conditionCategory = this.conditionCategory;
            String other$conditionCategory = other.conditionCategory;
            if (this$conditionCategory == null ? other$conditionCategory != null : !this$conditionCategory.equals(other$conditionCategory)) {
                return false;
            }
            Boolean this$conditionIsForStatistics = this.conditionIsForStatistics;
            Boolean other$conditionIsForStatistics = other.conditionIsForStatistics;
            if (this$conditionIsForStatistics == null ? other$conditionIsForStatistics != null : !((Object)this$conditionIsForStatistics).equals(other$conditionIsForStatistics)) {
                return false;
            }
            String this$pricingScaleType = this.pricingScaleType;
            String other$pricingScaleType = other.pricingScaleType;
            if (this$pricingScaleType == null ? other$pricingScaleType != null : !this$pricingScaleType.equals(other$pricingScaleType)) {
                return false;
            }
            Boolean this$isRelevantForAccrual = this.isRelevantForAccrual;
            Boolean other$isRelevantForAccrual = other.isRelevantForAccrual;
            if (this$isRelevantForAccrual == null ? other$isRelevantForAccrual != null : !((Object)this$isRelevantForAccrual).equals(other$isRelevantForAccrual)) {
                return false;
            }
            String this$cndnIsRelevantForInvoiceList = this.cndnIsRelevantForInvoiceList;
            String other$cndnIsRelevantForInvoiceList = other.cndnIsRelevantForInvoiceList;
            if (this$cndnIsRelevantForInvoiceList == null ? other$cndnIsRelevantForInvoiceList != null : !this$cndnIsRelevantForInvoiceList.equals(other$cndnIsRelevantForInvoiceList)) {
                return false;
            }
            String this$conditionOrigin = this.conditionOrigin;
            String other$conditionOrigin = other.conditionOrigin;
            if (this$conditionOrigin == null ? other$conditionOrigin != null : !this$conditionOrigin.equals(other$conditionOrigin)) {
                return false;
            }
            String this$isGroupCondition = this.isGroupCondition;
            String other$isGroupCondition = other.isGroupCondition;
            if (this$isGroupCondition == null ? other$isGroupCondition != null : !this$isGroupCondition.equals(other$isGroupCondition)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$conditionRecord = this.conditionRecord;
            String other$conditionRecord = other.conditionRecord;
            if (this$conditionRecord == null ? other$conditionRecord != null : !this$conditionRecord.equals(other$conditionRecord)) {
                return false;
            }
            String this$conditionSequentialNumber = this.conditionSequentialNumber;
            String other$conditionSequentialNumber = other.conditionSequentialNumber;
            if (this$conditionSequentialNumber == null ? other$conditionSequentialNumber != null : !this$conditionSequentialNumber.equals(other$conditionSequentialNumber)) {
                return false;
            }
            String this$taxCode = this.taxCode;
            String other$taxCode = other.taxCode;
            if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
                return false;
            }
            String this$withholdingTaxCode = this.withholdingTaxCode;
            String other$withholdingTaxCode = other.withholdingTaxCode;
            if (this$withholdingTaxCode == null ? other$withholdingTaxCode != null : !this$withholdingTaxCode.equals(other$withholdingTaxCode)) {
                return false;
            }
            BigDecimal this$cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            BigDecimal other$cndnRoundingOffDiffAmount = other.cndnRoundingOffDiffAmount;
            if (this$cndnRoundingOffDiffAmount == null ? other$cndnRoundingOffDiffAmount != null : !((Object)this$cndnRoundingOffDiffAmount).equals(other$cndnRoundingOffDiffAmount)) {
                return false;
            }
            BigDecimal this$conditionAmount = this.conditionAmount;
            BigDecimal other$conditionAmount = other.conditionAmount;
            if (this$conditionAmount == null ? other$conditionAmount != null : !((Object)this$conditionAmount).equals(other$conditionAmount)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            String this$conditionControl = this.conditionControl;
            String other$conditionControl = other.conditionControl;
            if (this$conditionControl == null ? other$conditionControl != null : !this$conditionControl.equals(other$conditionControl)) {
                return false;
            }
            String this$conditionInactiveReason = this.conditionInactiveReason;
            String other$conditionInactiveReason = other.conditionInactiveReason;
            if (this$conditionInactiveReason == null ? other$conditionInactiveReason != null : !this$conditionInactiveReason.equals(other$conditionInactiveReason)) {
                return false;
            }
            String this$conditionClass = this.conditionClass;
            String other$conditionClass = other.conditionClass;
            if (this$conditionClass == null ? other$conditionClass != null : !this$conditionClass.equals(other$conditionClass)) {
                return false;
            }
            String this$pricingProcedureStep = this.pricingProcedureStep;
            String other$pricingProcedureStep = other.pricingProcedureStep;
            if (this$pricingProcedureStep == null ? other$pricingProcedureStep != null : !this$pricingProcedureStep.equals(other$pricingProcedureStep)) {
                return false;
            }
            String this$prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            String other$prcgProcedureCounterForHeader = other.prcgProcedureCounterForHeader;
            if (this$prcgProcedureCounterForHeader == null ? other$prcgProcedureCounterForHeader != null : !this$prcgProcedureCounterForHeader.equals(other$prcgProcedureCounterForHeader)) {
                return false;
            }
            Double this$factorForConditionBasisValue = this.factorForConditionBasisValue;
            Double other$factorForConditionBasisValue = other.factorForConditionBasisValue;
            if (this$factorForConditionBasisValue == null ? other$factorForConditionBasisValue != null : !((Object)this$factorForConditionBasisValue).equals(other$factorForConditionBasisValue)) {
                return false;
            }
            String this$structureCondition = this.structureCondition;
            String other$structureCondition = other.structureCondition;
            if (this$structureCondition == null ? other$structureCondition != null : !this$structureCondition.equals(other$structureCondition)) {
                return false;
            }
            Double this$periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            Double other$periodFactorForCndnBasisValue = other.periodFactorForCndnBasisValue;
            if (this$periodFactorForCndnBasisValue == null ? other$periodFactorForCndnBasisValue != null : !((Object)this$periodFactorForCndnBasisValue).equals(other$periodFactorForCndnBasisValue)) {
                return false;
            }
            String this$pricingScaleBasis = this.pricingScaleBasis;
            String other$pricingScaleBasis = other.pricingScaleBasis;
            if (this$pricingScaleBasis == null ? other$pricingScaleBasis != null : !this$pricingScaleBasis.equals(other$pricingScaleBasis)) {
                return false;
            }
            BigDecimal this$conditionScaleBasisValue = this.conditionScaleBasisValue;
            BigDecimal other$conditionScaleBasisValue = other.conditionScaleBasisValue;
            if (this$conditionScaleBasisValue == null ? other$conditionScaleBasisValue != null : !((Object)this$conditionScaleBasisValue).equals(other$conditionScaleBasisValue)) {
                return false;
            }
            String this$conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            String other$conditionScaleBasisUnit = other.conditionScaleBasisUnit;
            if (this$conditionScaleBasisUnit == null ? other$conditionScaleBasisUnit != null : !this$conditionScaleBasisUnit.equals(other$conditionScaleBasisUnit)) {
                return false;
            }
            String this$conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            String other$conditionScaleBasisCurrency = other.conditionScaleBasisCurrency;
            if (this$conditionScaleBasisCurrency == null ? other$conditionScaleBasisCurrency != null : !this$conditionScaleBasisCurrency.equals(other$conditionScaleBasisCurrency)) {
                return false;
            }
            Boolean this$cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            Boolean other$cndnIsRelevantForIntcoBilling = other.cndnIsRelevantForIntcoBilling;
            if (this$cndnIsRelevantForIntcoBilling == null ? other$cndnIsRelevantForIntcoBilling != null : !((Object)this$cndnIsRelevantForIntcoBilling).equals(other$cndnIsRelevantForIntcoBilling)) {
                return false;
            }
            Boolean this$conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            Boolean other$conditionIsManuallyChanged = other.conditionIsManuallyChanged;
            if (this$conditionIsManuallyChanged == null ? other$conditionIsManuallyChanged != null : !((Object)this$conditionIsManuallyChanged).equals(other$conditionIsManuallyChanged)) {
                return false;
            }
            String this$pricingProcedureCounter = this.pricingProcedureCounter;
            String other$pricingProcedureCounter = other.pricingProcedureCounter;
            if (this$pricingProcedureCounter == null ? other$pricingProcedureCounter != null : !this$pricingProcedureCounter.equals(other$pricingProcedureCounter)) {
                return false;
            }
            Boolean this$conditionIsForConfiguration = this.conditionIsForConfiguration;
            Boolean other$conditionIsForConfiguration = other.conditionIsForConfiguration;
            if (this$conditionIsForConfiguration == null ? other$conditionIsForConfiguration != null : !((Object)this$conditionIsForConfiguration).equals(other$conditionIsForConfiguration)) {
                return false;
            }
            String this$variantCondition = this.variantCondition;
            String other$variantCondition = other.variantCondition;
            if (this$variantCondition == null ? other$variantCondition != null : !this$variantCondition.equals(other$variantCondition)) {
                return false;
            }
            String this$conditionType = this.conditionType;
            String other$conditionType = other.conditionType;
            if (this$conditionType == null ? other$conditionType != null : !this$conditionType.equals(other$conditionType)) {
                return false;
            }
            String this$pricingDateTime = this.pricingDateTime;
            String other$pricingDateTime = other.pricingDateTime;
            if (this$pricingDateTime == null ? other$pricingDateTime != null : !this$pricingDateTime.equals(other$pricingDateTime)) {
                return false;
            }
            String this$conditionCalculationType = this.conditionCalculationType;
            String other$conditionCalculationType = other.conditionCalculationType;
            if (this$conditionCalculationType == null ? other$conditionCalculationType != null : !this$conditionCalculationType.equals(other$conditionCalculationType)) {
                return false;
            }
            BigDecimal this$conditionBaseValue = this.conditionBaseValue;
            BigDecimal other$conditionBaseValue = other.conditionBaseValue;
            if (this$conditionBaseValue == null ? other$conditionBaseValue != null : !((Object)this$conditionBaseValue).equals(other$conditionBaseValue)) {
                return false;
            }
            BigDecimal this$conditionRateValue = this.conditionRateValue;
            BigDecimal other$conditionRateValue = other.conditionRateValue;
            return !(this$conditionRateValue == null ? other$conditionRateValue != null : !((Object)this$conditionRateValue).equals(other$conditionRateValue));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrderItemPrElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $conditionCurrency = this.conditionCurrency;
            result = result * 59 + ($conditionCurrency == null ? 43 : $conditionCurrency.hashCode());
            BigDecimal $conditionQuantity = this.conditionQuantity;
            result = result * 59 + ($conditionQuantity == null ? 43 : ((Object)$conditionQuantity).hashCode());
            String $conditionQuantityUnit = this.conditionQuantityUnit;
            result = result * 59 + ($conditionQuantityUnit == null ? 43 : $conditionQuantityUnit.hashCode());
            String $conditionCategory = this.conditionCategory;
            result = result * 59 + ($conditionCategory == null ? 43 : $conditionCategory.hashCode());
            Boolean $conditionIsForStatistics = this.conditionIsForStatistics;
            result = result * 59 + ($conditionIsForStatistics == null ? 43 : ((Object)$conditionIsForStatistics).hashCode());
            String $pricingScaleType = this.pricingScaleType;
            result = result * 59 + ($pricingScaleType == null ? 43 : $pricingScaleType.hashCode());
            Boolean $isRelevantForAccrual = this.isRelevantForAccrual;
            result = result * 59 + ($isRelevantForAccrual == null ? 43 : ((Object)$isRelevantForAccrual).hashCode());
            String $cndnIsRelevantForInvoiceList = this.cndnIsRelevantForInvoiceList;
            result = result * 59 + ($cndnIsRelevantForInvoiceList == null ? 43 : $cndnIsRelevantForInvoiceList.hashCode());
            String $conditionOrigin = this.conditionOrigin;
            result = result * 59 + ($conditionOrigin == null ? 43 : $conditionOrigin.hashCode());
            String $isGroupCondition = this.isGroupCondition;
            result = result * 59 + ($isGroupCondition == null ? 43 : $isGroupCondition.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $conditionRecord = this.conditionRecord;
            result = result * 59 + ($conditionRecord == null ? 43 : $conditionRecord.hashCode());
            String $conditionSequentialNumber = this.conditionSequentialNumber;
            result = result * 59 + ($conditionSequentialNumber == null ? 43 : $conditionSequentialNumber.hashCode());
            String $taxCode = this.taxCode;
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            String $withholdingTaxCode = this.withholdingTaxCode;
            result = result * 59 + ($withholdingTaxCode == null ? 43 : $withholdingTaxCode.hashCode());
            BigDecimal $cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            result = result * 59 + ($cndnRoundingOffDiffAmount == null ? 43 : ((Object)$cndnRoundingOffDiffAmount).hashCode());
            BigDecimal $conditionAmount = this.conditionAmount;
            result = result * 59 + ($conditionAmount == null ? 43 : ((Object)$conditionAmount).hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            String $conditionControl = this.conditionControl;
            result = result * 59 + ($conditionControl == null ? 43 : $conditionControl.hashCode());
            String $conditionInactiveReason = this.conditionInactiveReason;
            result = result * 59 + ($conditionInactiveReason == null ? 43 : $conditionInactiveReason.hashCode());
            String $conditionClass = this.conditionClass;
            result = result * 59 + ($conditionClass == null ? 43 : $conditionClass.hashCode());
            String $pricingProcedureStep = this.pricingProcedureStep;
            result = result * 59 + ($pricingProcedureStep == null ? 43 : $pricingProcedureStep.hashCode());
            String $prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            result = result * 59 + ($prcgProcedureCounterForHeader == null ? 43 : $prcgProcedureCounterForHeader.hashCode());
            Double $factorForConditionBasisValue = this.factorForConditionBasisValue;
            result = result * 59 + ($factorForConditionBasisValue == null ? 43 : ((Object)$factorForConditionBasisValue).hashCode());
            String $structureCondition = this.structureCondition;
            result = result * 59 + ($structureCondition == null ? 43 : $structureCondition.hashCode());
            Double $periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            result = result * 59 + ($periodFactorForCndnBasisValue == null ? 43 : ((Object)$periodFactorForCndnBasisValue).hashCode());
            String $pricingScaleBasis = this.pricingScaleBasis;
            result = result * 59 + ($pricingScaleBasis == null ? 43 : $pricingScaleBasis.hashCode());
            BigDecimal $conditionScaleBasisValue = this.conditionScaleBasisValue;
            result = result * 59 + ($conditionScaleBasisValue == null ? 43 : ((Object)$conditionScaleBasisValue).hashCode());
            String $conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            result = result * 59 + ($conditionScaleBasisUnit == null ? 43 : $conditionScaleBasisUnit.hashCode());
            String $conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            result = result * 59 + ($conditionScaleBasisCurrency == null ? 43 : $conditionScaleBasisCurrency.hashCode());
            Boolean $cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            result = result * 59 + ($cndnIsRelevantForIntcoBilling == null ? 43 : ((Object)$cndnIsRelevantForIntcoBilling).hashCode());
            Boolean $conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            result = result * 59 + ($conditionIsManuallyChanged == null ? 43 : ((Object)$conditionIsManuallyChanged).hashCode());
            String $pricingProcedureCounter = this.pricingProcedureCounter;
            result = result * 59 + ($pricingProcedureCounter == null ? 43 : $pricingProcedureCounter.hashCode());
            Boolean $conditionIsForConfiguration = this.conditionIsForConfiguration;
            result = result * 59 + ($conditionIsForConfiguration == null ? 43 : ((Object)$conditionIsForConfiguration).hashCode());
            String $variantCondition = this.variantCondition;
            result = result * 59 + ($variantCondition == null ? 43 : $variantCondition.hashCode());
            String $conditionType = this.conditionType;
            result = result * 59 + ($conditionType == null ? 43 : $conditionType.hashCode());
            String $pricingDateTime = this.pricingDateTime;
            result = result * 59 + ($pricingDateTime == null ? 43 : $pricingDateTime.hashCode());
            String $conditionCalculationType = this.conditionCalculationType;
            result = result * 59 + ($conditionCalculationType == null ? 43 : $conditionCalculationType.hashCode());
            BigDecimal $conditionBaseValue = this.conditionBaseValue;
            result = result * 59 + ($conditionBaseValue == null ? 43 : ((Object)$conditionBaseValue).hashCode());
            BigDecimal $conditionRateValue = this.conditionRateValue;
            result = result * 59 + ($conditionRateValue == null ? 43 : ((Object)$conditionRateValue).hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrderItemPrElement setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getConditionCurrency() {
            return this.conditionCurrency;
        }

        public SalesOrderItemPrElement setConditionCurrency(String conditionCurrency) {
            this.conditionCurrency = conditionCurrency;
            return this;
        }

        public BigDecimal getConditionQuantity() {
            return this.conditionQuantity;
        }

        public SalesOrderItemPrElement setConditionQuantity(BigDecimal conditionQuantity) {
            this.conditionQuantity = conditionQuantity;
            return this;
        }

        public String getConditionQuantityUnit() {
            return this.conditionQuantityUnit;
        }

        public SalesOrderItemPrElement setConditionQuantityUnit(String conditionQuantityUnit) {
            this.conditionQuantityUnit = conditionQuantityUnit;
            return this;
        }

        public String getConditionCategory() {
            return this.conditionCategory;
        }

        public SalesOrderItemPrElement setConditionCategory(String conditionCategory) {
            this.conditionCategory = conditionCategory;
            return this;
        }

        public Boolean getConditionIsForStatistics() {
            return this.conditionIsForStatistics;
        }

        public SalesOrderItemPrElement setConditionIsForStatistics(Boolean conditionIsForStatistics) {
            this.conditionIsForStatistics = conditionIsForStatistics;
            return this;
        }

        public String getPricingScaleType() {
            return this.pricingScaleType;
        }

        public SalesOrderItemPrElement setPricingScaleType(String pricingScaleType) {
            this.pricingScaleType = pricingScaleType;
            return this;
        }

        public Boolean getIsRelevantForAccrual() {
            return this.isRelevantForAccrual;
        }

        public SalesOrderItemPrElement setIsRelevantForAccrual(Boolean isRelevantForAccrual) {
            this.isRelevantForAccrual = isRelevantForAccrual;
            return this;
        }

        public String getCndnIsRelevantForInvoiceList() {
            return this.cndnIsRelevantForInvoiceList;
        }

        public SalesOrderItemPrElement setCndnIsRelevantForInvoiceList(String cndnIsRelevantForInvoiceList) {
            this.cndnIsRelevantForInvoiceList = cndnIsRelevantForInvoiceList;
            return this;
        }

        public String getConditionOrigin() {
            return this.conditionOrigin;
        }

        public SalesOrderItemPrElement setConditionOrigin(String conditionOrigin) {
            this.conditionOrigin = conditionOrigin;
            return this;
        }

        public String getIsGroupCondition() {
            return this.isGroupCondition;
        }

        public SalesOrderItemPrElement setIsGroupCondition(String isGroupCondition) {
            this.isGroupCondition = isGroupCondition;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public SalesOrderItemPrElement setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getConditionRecord() {
            return this.conditionRecord;
        }

        public SalesOrderItemPrElement setConditionRecord(String conditionRecord) {
            this.conditionRecord = conditionRecord;
            return this;
        }

        public String getConditionSequentialNumber() {
            return this.conditionSequentialNumber;
        }

        public SalesOrderItemPrElement setConditionSequentialNumber(String conditionSequentialNumber) {
            this.conditionSequentialNumber = conditionSequentialNumber;
            return this;
        }

        public String getTaxCode() {
            return this.taxCode;
        }

        public SalesOrderItemPrElement setTaxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public String getWithholdingTaxCode() {
            return this.withholdingTaxCode;
        }

        public SalesOrderItemPrElement setWithholdingTaxCode(String withholdingTaxCode) {
            this.withholdingTaxCode = withholdingTaxCode;
            return this;
        }

        public BigDecimal getCndnRoundingOffDiffAmount() {
            return this.cndnRoundingOffDiffAmount;
        }

        public SalesOrderItemPrElement setCndnRoundingOffDiffAmount(BigDecimal cndnRoundingOffDiffAmount) {
            this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
            return this;
        }

        public BigDecimal getConditionAmount() {
            return this.conditionAmount;
        }

        public SalesOrderItemPrElement setConditionAmount(BigDecimal conditionAmount) {
            this.conditionAmount = conditionAmount;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public SalesOrderItemPrElement setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public String getConditionControl() {
            return this.conditionControl;
        }

        public SalesOrderItemPrElement setConditionControl(String conditionControl) {
            this.conditionControl = conditionControl;
            return this;
        }

        public String getConditionInactiveReason() {
            return this.conditionInactiveReason;
        }

        public SalesOrderItemPrElement setConditionInactiveReason(String conditionInactiveReason) {
            this.conditionInactiveReason = conditionInactiveReason;
            return this;
        }

        public String getConditionClass() {
            return this.conditionClass;
        }

        public SalesOrderItemPrElement setConditionClass(String conditionClass) {
            this.conditionClass = conditionClass;
            return this;
        }

        public String getPricingProcedureStep() {
            return this.pricingProcedureStep;
        }

        public SalesOrderItemPrElement setPricingProcedureStep(String pricingProcedureStep) {
            this.pricingProcedureStep = pricingProcedureStep;
            return this;
        }

        public String getPrcgProcedureCounterForHeader() {
            return this.prcgProcedureCounterForHeader;
        }

        public SalesOrderItemPrElement setPrcgProcedureCounterForHeader(String prcgProcedureCounterForHeader) {
            this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
            return this;
        }

        public Double getFactorForConditionBasisValue() {
            return this.factorForConditionBasisValue;
        }

        public SalesOrderItemPrElement setFactorForConditionBasisValue(Double factorForConditionBasisValue) {
            this.factorForConditionBasisValue = factorForConditionBasisValue;
            return this;
        }

        public String getStructureCondition() {
            return this.structureCondition;
        }

        public SalesOrderItemPrElement setStructureCondition(String structureCondition) {
            this.structureCondition = structureCondition;
            return this;
        }

        public Double getPeriodFactorForCndnBasisValue() {
            return this.periodFactorForCndnBasisValue;
        }

        public SalesOrderItemPrElement setPeriodFactorForCndnBasisValue(Double periodFactorForCndnBasisValue) {
            this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
            return this;
        }

        public String getPricingScaleBasis() {
            return this.pricingScaleBasis;
        }

        public SalesOrderItemPrElement setPricingScaleBasis(String pricingScaleBasis) {
            this.pricingScaleBasis = pricingScaleBasis;
            return this;
        }

        public BigDecimal getConditionScaleBasisValue() {
            return this.conditionScaleBasisValue;
        }

        public SalesOrderItemPrElement setConditionScaleBasisValue(BigDecimal conditionScaleBasisValue) {
            this.conditionScaleBasisValue = conditionScaleBasisValue;
            return this;
        }

        public String getConditionScaleBasisUnit() {
            return this.conditionScaleBasisUnit;
        }

        public SalesOrderItemPrElement setConditionScaleBasisUnit(String conditionScaleBasisUnit) {
            this.conditionScaleBasisUnit = conditionScaleBasisUnit;
            return this;
        }

        public String getConditionScaleBasisCurrency() {
            return this.conditionScaleBasisCurrency;
        }

        public SalesOrderItemPrElement setConditionScaleBasisCurrency(String conditionScaleBasisCurrency) {
            this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
            return this;
        }

        public Boolean getCndnIsRelevantForIntcoBilling() {
            return this.cndnIsRelevantForIntcoBilling;
        }

        public SalesOrderItemPrElement setCndnIsRelevantForIntcoBilling(Boolean cndnIsRelevantForIntcoBilling) {
            this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
            return this;
        }

        public Boolean getConditionIsManuallyChanged() {
            return this.conditionIsManuallyChanged;
        }

        public SalesOrderItemPrElement setConditionIsManuallyChanged(Boolean conditionIsManuallyChanged) {
            this.conditionIsManuallyChanged = conditionIsManuallyChanged;
            return this;
        }

        public String getPricingProcedureCounter() {
            return this.pricingProcedureCounter;
        }

        public SalesOrderItemPrElement setPricingProcedureCounter(String pricingProcedureCounter) {
            this.pricingProcedureCounter = pricingProcedureCounter;
            return this;
        }

        public Boolean getConditionIsForConfiguration() {
            return this.conditionIsForConfiguration;
        }

        public SalesOrderItemPrElement setConditionIsForConfiguration(Boolean conditionIsForConfiguration) {
            this.conditionIsForConfiguration = conditionIsForConfiguration;
            return this;
        }

        public String getVariantCondition() {
            return this.variantCondition;
        }

        public SalesOrderItemPrElement setVariantCondition(String variantCondition) {
            this.variantCondition = variantCondition;
            return this;
        }

        public String getConditionType() {
            return this.conditionType;
        }

        public SalesOrderItemPrElement setConditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        public String getPricingDateTime() {
            return this.pricingDateTime;
        }

        public SalesOrderItemPrElement setPricingDateTime(String pricingDateTime) {
            this.pricingDateTime = pricingDateTime;
            return this;
        }

        public String getConditionCalculationType() {
            return this.conditionCalculationType;
        }

        public SalesOrderItemPrElement setConditionCalculationType(String conditionCalculationType) {
            this.conditionCalculationType = conditionCalculationType;
            return this;
        }

        public BigDecimal getConditionBaseValue() {
            return this.conditionBaseValue;
        }

        public SalesOrderItemPrElement setConditionBaseValue(BigDecimal conditionBaseValue) {
            this.conditionBaseValue = conditionBaseValue;
            return this;
        }

        public BigDecimal getConditionRateValue() {
            return this.conditionRateValue;
        }

        public SalesOrderItemPrElement setConditionRateValue(BigDecimal conditionRateValue) {
            this.conditionRateValue = conditionRateValue;
            return this;
        }

        public SalesOrderItemPrElement setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class SalesOrderItemPartnerFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderItemPartner");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderItemPartnerFluentHelper filter(ExpressionFluentHelper<SalesOrderItemPartner> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderItemPartnerFluentHelper orderBy(EntityField<?, SalesOrderItemPartner> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderItemPartnerFluentHelper select(EntityField<?, SalesOrderItemPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderItemPartnerFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderItemPartnerFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderItemPartnerFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrderItemPartner> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrderItemPartner.class);
            for (SalesOrderItemPartner entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderItemPartnerByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderItemPartnerByKeyFluentHelper(String salesOrder, String salesOrderItem, String partnerFunction) {
            this.values.add(salesOrder);
            this.values.add(salesOrderItem);
            this.values.add(partnerFunction);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderItemPartner");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            keys.put("SalesOrderItem", this.values.get(1));
            keys.put("PartnerFunction", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderItemPartnerByKeyFluentHelper select(EntityField<?, SalesOrderItemPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderItemPartnerByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrderItemPartner execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrderItemPartner entity = (SalesOrderItemPartner)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrderItemPartner.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrderItemPartner {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrderItemPartner> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, SalesOrderItemPartner> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="PartnerFunction")
        private String partnerFunction;
        public static EntityField<String, SalesOrderItemPartner> PARTNER_FUNCTION = new EntityField("PartnerFunction");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, SalesOrderItemPartner> CUSTOMER = new EntityField("Customer");
        @ElementName(value="Supplier")
        private String supplier;
        public static EntityField<String, SalesOrderItemPartner> SUPPLIER = new EntityField("Supplier");
        @ElementName(value="Personnel")
        private String personnel;
        public static EntityField<String, SalesOrderItemPartner> PERSONNEL = new EntityField("Personnel");
        @ElementName(value="ContactPerson")
        private String contactPerson;
        public static EntityField<String, SalesOrderItemPartner> CONTACT_PERSON = new EntityField("ContactPerson");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrderItemPartner";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public SalesOrder fetchSalesOrder() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(",PartnerFunction=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.partnerFunction));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrder");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrder entityList = (SalesOrder)result.as(SalesOrder.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public SalesOrderItem fetchSalesOrderItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(",PartnerFunction=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.partnerFunction));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrderItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrderItem entityList = (SalesOrderItem)result.as(SalesOrderItem.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrderItemPartner(salesOrder=" + this.salesOrder + ", salesOrderItem=" + this.salesOrderItem + ", partnerFunction=" + this.partnerFunction + ", customer=" + this.customer + ", supplier=" + this.supplier + ", personnel=" + this.personnel + ", contactPerson=" + this.contactPerson + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrderItemPartner)) {
                return false;
            }
            SalesOrderItemPartner other = (SalesOrderItemPartner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$partnerFunction = this.partnerFunction;
            String other$partnerFunction = other.partnerFunction;
            if (this$partnerFunction == null ? other$partnerFunction != null : !this$partnerFunction.equals(other$partnerFunction)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$supplier = this.supplier;
            String other$supplier = other.supplier;
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            String this$personnel = this.personnel;
            String other$personnel = other.personnel;
            if (this$personnel == null ? other$personnel != null : !this$personnel.equals(other$personnel)) {
                return false;
            }
            String this$contactPerson = this.contactPerson;
            String other$contactPerson = other.contactPerson;
            return !(this$contactPerson == null ? other$contactPerson != null : !this$contactPerson.equals(other$contactPerson));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrderItemPartner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $partnerFunction = this.partnerFunction;
            result = result * 59 + ($partnerFunction == null ? 43 : $partnerFunction.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $supplier = this.supplier;
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            String $personnel = this.personnel;
            result = result * 59 + ($personnel == null ? 43 : $personnel.hashCode());
            String $contactPerson = this.contactPerson;
            result = result * 59 + ($contactPerson == null ? 43 : $contactPerson.hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrderItemPartner setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public SalesOrderItemPartner setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getPartnerFunction() {
            return this.partnerFunction;
        }

        public SalesOrderItemPartner setPartnerFunction(String partnerFunction) {
            this.partnerFunction = partnerFunction;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public SalesOrderItemPartner setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public SalesOrderItemPartner setSupplier(String supplier) {
            this.supplier = supplier;
            return this;
        }

        public String getPersonnel() {
            return this.personnel;
        }

        public SalesOrderItemPartner setPersonnel(String personnel) {
            this.personnel = personnel;
            return this;
        }

        public String getContactPerson() {
            return this.contactPerson;
        }

        public SalesOrderItemPartner setContactPerson(String contactPerson) {
            this.contactPerson = contactPerson;
            return this;
        }

        public SalesOrderItemPartner setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class SalesOrderItemFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderItem");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderItemFluentHelper filter(ExpressionFluentHelper<SalesOrderItem> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderItemFluentHelper orderBy(EntityField<?, SalesOrderItem> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderItemFluentHelper select(EntityField<?, SalesOrderItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderItemFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderItemFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderItemFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrderItem> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrderItem.class);
            for (SalesOrderItem entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderItemByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderItemByKeyFluentHelper(String salesOrder, String salesOrderItem) {
            this.values.add(salesOrder);
            this.values.add(salesOrderItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderItem");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            keys.put("SalesOrderItem", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderItemByKeyFluentHelper select(EntityField<?, SalesOrderItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderItemByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrderItem execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrderItem entity = (SalesOrderItem)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrderItem.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrderItem {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrderItem> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="RequestedQuantity")
        private BigDecimal requestedQuantity;
        public static EntityField<BigDecimal, SalesOrderItem> REQUESTED_QUANTITY = new EntityField("RequestedQuantity");
        @ElementName(value="RequestedQuantityUnit")
        private String requestedQuantityUnit;
        public static EntityField<String, SalesOrderItem> REQUESTED_QUANTITY_UNIT = new EntityField("RequestedQuantityUnit");
        @ElementName(value="ItemGrossWeight")
        private BigDecimal itemGrossWeight;
        public static EntityField<BigDecimal, SalesOrderItem> ITEM_GROSS_WEIGHT = new EntityField("ItemGrossWeight");
        @ElementName(value="ItemNetWeight")
        private BigDecimal itemNetWeight;
        public static EntityField<BigDecimal, SalesOrderItem> ITEM_NET_WEIGHT = new EntityField("ItemNetWeight");
        @ElementName(value="ItemWeightUnit")
        private String itemWeightUnit;
        public static EntityField<String, SalesOrderItem> ITEM_WEIGHT_UNIT = new EntityField("ItemWeightUnit");
        @ElementName(value="ItemVolume")
        private BigDecimal itemVolume;
        public static EntityField<BigDecimal, SalesOrderItem> ITEM_VOLUME = new EntityField("ItemVolume");
        @ElementName(value="ItemVolumeUnit")
        private String itemVolumeUnit;
        public static EntityField<String, SalesOrderItem> ITEM_VOLUME_UNIT = new EntityField("ItemVolumeUnit");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, SalesOrderItem> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="NetAmount")
        private BigDecimal netAmount;
        public static EntityField<BigDecimal, SalesOrderItem> NET_AMOUNT = new EntityField("NetAmount");
        @ElementName(value="MaterialGroup")
        private String materialGroup;
        public static EntityField<String, SalesOrderItem> MATERIAL_GROUP = new EntityField("MaterialGroup");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, SalesOrderItem> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="Batch")
        private String batch;
        public static EntityField<String, SalesOrderItem> BATCH = new EntityField("Batch");
        @ElementName(value="ProductionPlant")
        private String productionPlant;
        public static EntityField<String, SalesOrderItem> PRODUCTION_PLANT = new EntityField("ProductionPlant");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, SalesOrderItem> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="ShippingPoint")
        private String shippingPoint;
        public static EntityField<String, SalesOrderItem> SHIPPING_POINT = new EntityField("ShippingPoint");
        @ElementName(value="ShippingType")
        private String shippingType;
        public static EntityField<String, SalesOrderItem> SHIPPING_TYPE = new EntityField("ShippingType");
        @ElementName(value="DeliveryPriority")
        private String deliveryPriority;
        public static EntityField<String, SalesOrderItem> DELIVERY_PRIORITY = new EntityField("DeliveryPriority");
        @ElementName(value="IncotermsClassification")
        private String incotermsClassification;
        public static EntityField<String, SalesOrderItem> INCOTERMS_CLASSIFICATION = new EntityField("IncotermsClassification");
        @ElementName(value="IncotermsTransferLocation")
        private String incotermsTransferLocation;
        public static EntityField<String, SalesOrderItem> INCOTERMS_TRANSFER_LOCATION = new EntityField("IncotermsTransferLocation");
        @ElementName(value="CustomerPaymentTerms")
        private String customerPaymentTerms;
        public static EntityField<String, SalesOrderItem> CUSTOMER_PAYMENT_TERMS = new EntityField("CustomerPaymentTerms");
        @ElementName(value="SalesDocumentRjcnReason")
        private String salesDocumentRjcnReason;
        public static EntityField<String, SalesOrderItem> SALES_DOCUMENT_RJCN_REASON = new EntityField("SalesDocumentRjcnReason");
        @ElementName(value="HigherLevelItem")
        private String higherLevelItem;
        public static EntityField<String, SalesOrderItem> HIGHER_LEVEL_ITEM = new EntityField("HigherLevelItem");
        @ElementName(value="ItemBillingBlockReason")
        private String itemBillingBlockReason;
        public static EntityField<String, SalesOrderItem> ITEM_BILLING_BLOCK_REASON = new EntityField("ItemBillingBlockReason");
        @ElementName(value="SDProcessStatus")
        private String sDProcessStatus;
        public static EntityField<String, SalesOrderItem> S_D_PROCESS_STATUS = new EntityField("SDProcessStatus");
        @ElementName(value="DeliveryStatus")
        private String deliveryStatus;
        public static EntityField<String, SalesOrderItem> DELIVERY_STATUS = new EntityField("DeliveryStatus");
        @ElementName(value="OrderRelatedBillingStatus")
        private String orderRelatedBillingStatus;
        public static EntityField<String, SalesOrderItem> ORDER_RELATED_BILLING_STATUS = new EntityField("OrderRelatedBillingStatus");
        @ElementName(value="SalesOrderItemCategory")
        private String salesOrderItemCategory;
        public static EntityField<String, SalesOrderItem> SALES_ORDER_ITEM_CATEGORY = new EntityField("SalesOrderItemCategory");
        @ElementName(value="SalesOrderItemText")
        private String salesOrderItemText;
        public static EntityField<String, SalesOrderItem> SALES_ORDER_ITEM_TEXT = new EntityField("SalesOrderItemText");
        @ElementName(value="PurchaseOrderByCustomer")
        private String purchaseOrderByCustomer;
        public static EntityField<String, SalesOrderItem> PURCHASE_ORDER_BY_CUSTOMER = new EntityField("PurchaseOrderByCustomer");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, SalesOrderItem> MATERIAL = new EntityField("Material");
        @ElementName(value="MaterialByCustomer")
        private String materialByCustomer;
        public static EntityField<String, SalesOrderItem> MATERIAL_BY_CUSTOMER = new EntityField("MaterialByCustomer");
        @ElementName(value="PricingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar pricingDate;
        public static EntityField<Calendar, SalesOrderItem> PRICING_DATE = new EntityField("PricingDate");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrderItem";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<SalesOrderItemPartner> fetchPartner() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Partner");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(SalesOrderItemPartner.class);
            for (SalesOrderItemPartner entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<SalesOrderItemPrElement> fetchPricingElement() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PricingElement");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(SalesOrderItemPrElement.class);
            for (SalesOrderItemPrElement entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public SalesOrder fetchSalesOrder() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrder");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrder entityList = (SalesOrder)result.as(SalesOrder.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        @JsonIgnore
        public List<SalesOrderScheduleLine> fetchScheduleLine() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",SalesOrderItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrderItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_ScheduleLine");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(SalesOrderScheduleLine.class);
            for (SalesOrderScheduleLine entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrderItem(salesOrder=" + this.salesOrder + ", requestedQuantity=" + this.requestedQuantity + ", requestedQuantityUnit=" + this.requestedQuantityUnit + ", itemGrossWeight=" + this.itemGrossWeight + ", itemNetWeight=" + this.itemNetWeight + ", itemWeightUnit=" + this.itemWeightUnit + ", itemVolume=" + this.itemVolume + ", itemVolumeUnit=" + this.itemVolumeUnit + ", transactionCurrency=" + this.transactionCurrency + ", netAmount=" + this.netAmount + ", materialGroup=" + this.materialGroup + ", salesOrderItem=" + this.salesOrderItem + ", batch=" + this.batch + ", productionPlant=" + this.productionPlant + ", storageLocation=" + this.storageLocation + ", shippingPoint=" + this.shippingPoint + ", shippingType=" + this.shippingType + ", deliveryPriority=" + this.deliveryPriority + ", incotermsClassification=" + this.incotermsClassification + ", incotermsTransferLocation=" + this.incotermsTransferLocation + ", customerPaymentTerms=" + this.customerPaymentTerms + ", salesDocumentRjcnReason=" + this.salesDocumentRjcnReason + ", higherLevelItem=" + this.higherLevelItem + ", itemBillingBlockReason=" + this.itemBillingBlockReason + ", sDProcessStatus=" + this.sDProcessStatus + ", deliveryStatus=" + this.deliveryStatus + ", orderRelatedBillingStatus=" + this.orderRelatedBillingStatus + ", salesOrderItemCategory=" + this.salesOrderItemCategory + ", salesOrderItemText=" + this.salesOrderItemText + ", purchaseOrderByCustomer=" + this.purchaseOrderByCustomer + ", material=" + this.material + ", materialByCustomer=" + this.materialByCustomer + ", pricingDate=" + this.pricingDate + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrderItem)) {
                return false;
            }
            SalesOrderItem other = (SalesOrderItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            BigDecimal this$requestedQuantity = this.requestedQuantity;
            BigDecimal other$requestedQuantity = other.requestedQuantity;
            if (this$requestedQuantity == null ? other$requestedQuantity != null : !((Object)this$requestedQuantity).equals(other$requestedQuantity)) {
                return false;
            }
            String this$requestedQuantityUnit = this.requestedQuantityUnit;
            String other$requestedQuantityUnit = other.requestedQuantityUnit;
            if (this$requestedQuantityUnit == null ? other$requestedQuantityUnit != null : !this$requestedQuantityUnit.equals(other$requestedQuantityUnit)) {
                return false;
            }
            BigDecimal this$itemGrossWeight = this.itemGrossWeight;
            BigDecimal other$itemGrossWeight = other.itemGrossWeight;
            if (this$itemGrossWeight == null ? other$itemGrossWeight != null : !((Object)this$itemGrossWeight).equals(other$itemGrossWeight)) {
                return false;
            }
            BigDecimal this$itemNetWeight = this.itemNetWeight;
            BigDecimal other$itemNetWeight = other.itemNetWeight;
            if (this$itemNetWeight == null ? other$itemNetWeight != null : !((Object)this$itemNetWeight).equals(other$itemNetWeight)) {
                return false;
            }
            String this$itemWeightUnit = this.itemWeightUnit;
            String other$itemWeightUnit = other.itemWeightUnit;
            if (this$itemWeightUnit == null ? other$itemWeightUnit != null : !this$itemWeightUnit.equals(other$itemWeightUnit)) {
                return false;
            }
            BigDecimal this$itemVolume = this.itemVolume;
            BigDecimal other$itemVolume = other.itemVolume;
            if (this$itemVolume == null ? other$itemVolume != null : !((Object)this$itemVolume).equals(other$itemVolume)) {
                return false;
            }
            String this$itemVolumeUnit = this.itemVolumeUnit;
            String other$itemVolumeUnit = other.itemVolumeUnit;
            if (this$itemVolumeUnit == null ? other$itemVolumeUnit != null : !this$itemVolumeUnit.equals(other$itemVolumeUnit)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            BigDecimal this$netAmount = this.netAmount;
            BigDecimal other$netAmount = other.netAmount;
            if (this$netAmount == null ? other$netAmount != null : !((Object)this$netAmount).equals(other$netAmount)) {
                return false;
            }
            String this$materialGroup = this.materialGroup;
            String other$materialGroup = other.materialGroup;
            if (this$materialGroup == null ? other$materialGroup != null : !this$materialGroup.equals(other$materialGroup)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$batch = this.batch;
            String other$batch = other.batch;
            if (this$batch == null ? other$batch != null : !this$batch.equals(other$batch)) {
                return false;
            }
            String this$productionPlant = this.productionPlant;
            String other$productionPlant = other.productionPlant;
            if (this$productionPlant == null ? other$productionPlant != null : !this$productionPlant.equals(other$productionPlant)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$shippingPoint = this.shippingPoint;
            String other$shippingPoint = other.shippingPoint;
            if (this$shippingPoint == null ? other$shippingPoint != null : !this$shippingPoint.equals(other$shippingPoint)) {
                return false;
            }
            String this$shippingType = this.shippingType;
            String other$shippingType = other.shippingType;
            if (this$shippingType == null ? other$shippingType != null : !this$shippingType.equals(other$shippingType)) {
                return false;
            }
            String this$deliveryPriority = this.deliveryPriority;
            String other$deliveryPriority = other.deliveryPriority;
            if (this$deliveryPriority == null ? other$deliveryPriority != null : !this$deliveryPriority.equals(other$deliveryPriority)) {
                return false;
            }
            String this$incotermsClassification = this.incotermsClassification;
            String other$incotermsClassification = other.incotermsClassification;
            if (this$incotermsClassification == null ? other$incotermsClassification != null : !this$incotermsClassification.equals(other$incotermsClassification)) {
                return false;
            }
            String this$incotermsTransferLocation = this.incotermsTransferLocation;
            String other$incotermsTransferLocation = other.incotermsTransferLocation;
            if (this$incotermsTransferLocation == null ? other$incotermsTransferLocation != null : !this$incotermsTransferLocation.equals(other$incotermsTransferLocation)) {
                return false;
            }
            String this$customerPaymentTerms = this.customerPaymentTerms;
            String other$customerPaymentTerms = other.customerPaymentTerms;
            if (this$customerPaymentTerms == null ? other$customerPaymentTerms != null : !this$customerPaymentTerms.equals(other$customerPaymentTerms)) {
                return false;
            }
            String this$salesDocumentRjcnReason = this.salesDocumentRjcnReason;
            String other$salesDocumentRjcnReason = other.salesDocumentRjcnReason;
            if (this$salesDocumentRjcnReason == null ? other$salesDocumentRjcnReason != null : !this$salesDocumentRjcnReason.equals(other$salesDocumentRjcnReason)) {
                return false;
            }
            String this$higherLevelItem = this.higherLevelItem;
            String other$higherLevelItem = other.higherLevelItem;
            if (this$higherLevelItem == null ? other$higherLevelItem != null : !this$higherLevelItem.equals(other$higherLevelItem)) {
                return false;
            }
            String this$itemBillingBlockReason = this.itemBillingBlockReason;
            String other$itemBillingBlockReason = other.itemBillingBlockReason;
            if (this$itemBillingBlockReason == null ? other$itemBillingBlockReason != null : !this$itemBillingBlockReason.equals(other$itemBillingBlockReason)) {
                return false;
            }
            String this$sDProcessStatus = this.sDProcessStatus;
            String other$sDProcessStatus = other.sDProcessStatus;
            if (this$sDProcessStatus == null ? other$sDProcessStatus != null : !this$sDProcessStatus.equals(other$sDProcessStatus)) {
                return false;
            }
            String this$deliveryStatus = this.deliveryStatus;
            String other$deliveryStatus = other.deliveryStatus;
            if (this$deliveryStatus == null ? other$deliveryStatus != null : !this$deliveryStatus.equals(other$deliveryStatus)) {
                return false;
            }
            String this$orderRelatedBillingStatus = this.orderRelatedBillingStatus;
            String other$orderRelatedBillingStatus = other.orderRelatedBillingStatus;
            if (this$orderRelatedBillingStatus == null ? other$orderRelatedBillingStatus != null : !this$orderRelatedBillingStatus.equals(other$orderRelatedBillingStatus)) {
                return false;
            }
            String this$salesOrderItemCategory = this.salesOrderItemCategory;
            String other$salesOrderItemCategory = other.salesOrderItemCategory;
            if (this$salesOrderItemCategory == null ? other$salesOrderItemCategory != null : !this$salesOrderItemCategory.equals(other$salesOrderItemCategory)) {
                return false;
            }
            String this$salesOrderItemText = this.salesOrderItemText;
            String other$salesOrderItemText = other.salesOrderItemText;
            if (this$salesOrderItemText == null ? other$salesOrderItemText != null : !this$salesOrderItemText.equals(other$salesOrderItemText)) {
                return false;
            }
            String this$purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            String other$purchaseOrderByCustomer = other.purchaseOrderByCustomer;
            if (this$purchaseOrderByCustomer == null ? other$purchaseOrderByCustomer != null : !this$purchaseOrderByCustomer.equals(other$purchaseOrderByCustomer)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$materialByCustomer = this.materialByCustomer;
            String other$materialByCustomer = other.materialByCustomer;
            if (this$materialByCustomer == null ? other$materialByCustomer != null : !this$materialByCustomer.equals(other$materialByCustomer)) {
                return false;
            }
            Calendar this$pricingDate = this.pricingDate;
            Calendar other$pricingDate = other.pricingDate;
            return !(this$pricingDate == null ? other$pricingDate != null : !((Object)this$pricingDate).equals(other$pricingDate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrderItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            BigDecimal $requestedQuantity = this.requestedQuantity;
            result = result * 59 + ($requestedQuantity == null ? 43 : ((Object)$requestedQuantity).hashCode());
            String $requestedQuantityUnit = this.requestedQuantityUnit;
            result = result * 59 + ($requestedQuantityUnit == null ? 43 : $requestedQuantityUnit.hashCode());
            BigDecimal $itemGrossWeight = this.itemGrossWeight;
            result = result * 59 + ($itemGrossWeight == null ? 43 : ((Object)$itemGrossWeight).hashCode());
            BigDecimal $itemNetWeight = this.itemNetWeight;
            result = result * 59 + ($itemNetWeight == null ? 43 : ((Object)$itemNetWeight).hashCode());
            String $itemWeightUnit = this.itemWeightUnit;
            result = result * 59 + ($itemWeightUnit == null ? 43 : $itemWeightUnit.hashCode());
            BigDecimal $itemVolume = this.itemVolume;
            result = result * 59 + ($itemVolume == null ? 43 : ((Object)$itemVolume).hashCode());
            String $itemVolumeUnit = this.itemVolumeUnit;
            result = result * 59 + ($itemVolumeUnit == null ? 43 : $itemVolumeUnit.hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            BigDecimal $netAmount = this.netAmount;
            result = result * 59 + ($netAmount == null ? 43 : ((Object)$netAmount).hashCode());
            String $materialGroup = this.materialGroup;
            result = result * 59 + ($materialGroup == null ? 43 : $materialGroup.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $batch = this.batch;
            result = result * 59 + ($batch == null ? 43 : $batch.hashCode());
            String $productionPlant = this.productionPlant;
            result = result * 59 + ($productionPlant == null ? 43 : $productionPlant.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $shippingPoint = this.shippingPoint;
            result = result * 59 + ($shippingPoint == null ? 43 : $shippingPoint.hashCode());
            String $shippingType = this.shippingType;
            result = result * 59 + ($shippingType == null ? 43 : $shippingType.hashCode());
            String $deliveryPriority = this.deliveryPriority;
            result = result * 59 + ($deliveryPriority == null ? 43 : $deliveryPriority.hashCode());
            String $incotermsClassification = this.incotermsClassification;
            result = result * 59 + ($incotermsClassification == null ? 43 : $incotermsClassification.hashCode());
            String $incotermsTransferLocation = this.incotermsTransferLocation;
            result = result * 59 + ($incotermsTransferLocation == null ? 43 : $incotermsTransferLocation.hashCode());
            String $customerPaymentTerms = this.customerPaymentTerms;
            result = result * 59 + ($customerPaymentTerms == null ? 43 : $customerPaymentTerms.hashCode());
            String $salesDocumentRjcnReason = this.salesDocumentRjcnReason;
            result = result * 59 + ($salesDocumentRjcnReason == null ? 43 : $salesDocumentRjcnReason.hashCode());
            String $higherLevelItem = this.higherLevelItem;
            result = result * 59 + ($higherLevelItem == null ? 43 : $higherLevelItem.hashCode());
            String $itemBillingBlockReason = this.itemBillingBlockReason;
            result = result * 59 + ($itemBillingBlockReason == null ? 43 : $itemBillingBlockReason.hashCode());
            String $sDProcessStatus = this.sDProcessStatus;
            result = result * 59 + ($sDProcessStatus == null ? 43 : $sDProcessStatus.hashCode());
            String $deliveryStatus = this.deliveryStatus;
            result = result * 59 + ($deliveryStatus == null ? 43 : $deliveryStatus.hashCode());
            String $orderRelatedBillingStatus = this.orderRelatedBillingStatus;
            result = result * 59 + ($orderRelatedBillingStatus == null ? 43 : $orderRelatedBillingStatus.hashCode());
            String $salesOrderItemCategory = this.salesOrderItemCategory;
            result = result * 59 + ($salesOrderItemCategory == null ? 43 : $salesOrderItemCategory.hashCode());
            String $salesOrderItemText = this.salesOrderItemText;
            result = result * 59 + ($salesOrderItemText == null ? 43 : $salesOrderItemText.hashCode());
            String $purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            result = result * 59 + ($purchaseOrderByCustomer == null ? 43 : $purchaseOrderByCustomer.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $materialByCustomer = this.materialByCustomer;
            result = result * 59 + ($materialByCustomer == null ? 43 : $materialByCustomer.hashCode());
            Calendar $pricingDate = this.pricingDate;
            result = result * 59 + ($pricingDate == null ? 43 : ((Object)$pricingDate).hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrderItem setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public BigDecimal getRequestedQuantity() {
            return this.requestedQuantity;
        }

        public SalesOrderItem setRequestedQuantity(BigDecimal requestedQuantity) {
            this.requestedQuantity = requestedQuantity;
            return this;
        }

        public String getRequestedQuantityUnit() {
            return this.requestedQuantityUnit;
        }

        public SalesOrderItem setRequestedQuantityUnit(String requestedQuantityUnit) {
            this.requestedQuantityUnit = requestedQuantityUnit;
            return this;
        }

        public BigDecimal getItemGrossWeight() {
            return this.itemGrossWeight;
        }

        public SalesOrderItem setItemGrossWeight(BigDecimal itemGrossWeight) {
            this.itemGrossWeight = itemGrossWeight;
            return this;
        }

        public BigDecimal getItemNetWeight() {
            return this.itemNetWeight;
        }

        public SalesOrderItem setItemNetWeight(BigDecimal itemNetWeight) {
            this.itemNetWeight = itemNetWeight;
            return this;
        }

        public String getItemWeightUnit() {
            return this.itemWeightUnit;
        }

        public SalesOrderItem setItemWeightUnit(String itemWeightUnit) {
            this.itemWeightUnit = itemWeightUnit;
            return this;
        }

        public BigDecimal getItemVolume() {
            return this.itemVolume;
        }

        public SalesOrderItem setItemVolume(BigDecimal itemVolume) {
            this.itemVolume = itemVolume;
            return this;
        }

        public String getItemVolumeUnit() {
            return this.itemVolumeUnit;
        }

        public SalesOrderItem setItemVolumeUnit(String itemVolumeUnit) {
            this.itemVolumeUnit = itemVolumeUnit;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public SalesOrderItem setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public BigDecimal getNetAmount() {
            return this.netAmount;
        }

        public SalesOrderItem setNetAmount(BigDecimal netAmount) {
            this.netAmount = netAmount;
            return this;
        }

        public String getMaterialGroup() {
            return this.materialGroup;
        }

        public SalesOrderItem setMaterialGroup(String materialGroup) {
            this.materialGroup = materialGroup;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public SalesOrderItem setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getBatch() {
            return this.batch;
        }

        public SalesOrderItem setBatch(String batch) {
            this.batch = batch;
            return this;
        }

        public String getProductionPlant() {
            return this.productionPlant;
        }

        public SalesOrderItem setProductionPlant(String productionPlant) {
            this.productionPlant = productionPlant;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public SalesOrderItem setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getShippingPoint() {
            return this.shippingPoint;
        }

        public SalesOrderItem setShippingPoint(String shippingPoint) {
            this.shippingPoint = shippingPoint;
            return this;
        }

        public String getShippingType() {
            return this.shippingType;
        }

        public SalesOrderItem setShippingType(String shippingType) {
            this.shippingType = shippingType;
            return this;
        }

        public String getDeliveryPriority() {
            return this.deliveryPriority;
        }

        public SalesOrderItem setDeliveryPriority(String deliveryPriority) {
            this.deliveryPriority = deliveryPriority;
            return this;
        }

        public String getIncotermsClassification() {
            return this.incotermsClassification;
        }

        public SalesOrderItem setIncotermsClassification(String incotermsClassification) {
            this.incotermsClassification = incotermsClassification;
            return this;
        }

        public String getIncotermsTransferLocation() {
            return this.incotermsTransferLocation;
        }

        public SalesOrderItem setIncotermsTransferLocation(String incotermsTransferLocation) {
            this.incotermsTransferLocation = incotermsTransferLocation;
            return this;
        }

        public String getCustomerPaymentTerms() {
            return this.customerPaymentTerms;
        }

        public SalesOrderItem setCustomerPaymentTerms(String customerPaymentTerms) {
            this.customerPaymentTerms = customerPaymentTerms;
            return this;
        }

        public String getSalesDocumentRjcnReason() {
            return this.salesDocumentRjcnReason;
        }

        public SalesOrderItem setSalesDocumentRjcnReason(String salesDocumentRjcnReason) {
            this.salesDocumentRjcnReason = salesDocumentRjcnReason;
            return this;
        }

        public String getHigherLevelItem() {
            return this.higherLevelItem;
        }

        public SalesOrderItem setHigherLevelItem(String higherLevelItem) {
            this.higherLevelItem = higherLevelItem;
            return this;
        }

        public String getItemBillingBlockReason() {
            return this.itemBillingBlockReason;
        }

        public SalesOrderItem setItemBillingBlockReason(String itemBillingBlockReason) {
            this.itemBillingBlockReason = itemBillingBlockReason;
            return this;
        }

        public String getSDProcessStatus() {
            return this.sDProcessStatus;
        }

        public SalesOrderItem setSDProcessStatus(String sDProcessStatus) {
            this.sDProcessStatus = sDProcessStatus;
            return this;
        }

        public String getDeliveryStatus() {
            return this.deliveryStatus;
        }

        public SalesOrderItem setDeliveryStatus(String deliveryStatus) {
            this.deliveryStatus = deliveryStatus;
            return this;
        }

        public String getOrderRelatedBillingStatus() {
            return this.orderRelatedBillingStatus;
        }

        public SalesOrderItem setOrderRelatedBillingStatus(String orderRelatedBillingStatus) {
            this.orderRelatedBillingStatus = orderRelatedBillingStatus;
            return this;
        }

        public String getSalesOrderItemCategory() {
            return this.salesOrderItemCategory;
        }

        public SalesOrderItem setSalesOrderItemCategory(String salesOrderItemCategory) {
            this.salesOrderItemCategory = salesOrderItemCategory;
            return this;
        }

        public String getSalesOrderItemText() {
            return this.salesOrderItemText;
        }

        public SalesOrderItem setSalesOrderItemText(String salesOrderItemText) {
            this.salesOrderItemText = salesOrderItemText;
            return this;
        }

        public String getPurchaseOrderByCustomer() {
            return this.purchaseOrderByCustomer;
        }

        public SalesOrderItem setPurchaseOrderByCustomer(String purchaseOrderByCustomer) {
            this.purchaseOrderByCustomer = purchaseOrderByCustomer;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public SalesOrderItem setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getMaterialByCustomer() {
            return this.materialByCustomer;
        }

        public SalesOrderItem setMaterialByCustomer(String materialByCustomer) {
            this.materialByCustomer = materialByCustomer;
            return this;
        }

        public Calendar getPricingDate() {
            return this.pricingDate;
        }

        public SalesOrderItem setPricingDate(Calendar pricingDate) {
            this.pricingDate = pricingDate;
            return this;
        }

        public SalesOrderItem setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class SalesOrderHeaderPrElementFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderHeaderPrElement");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderHeaderPrElementFluentHelper filter(ExpressionFluentHelper<SalesOrderHeaderPrElement> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderHeaderPrElementFluentHelper orderBy(EntityField<?, SalesOrderHeaderPrElement> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderHeaderPrElementFluentHelper select(EntityField<?, SalesOrderHeaderPrElement> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderHeaderPrElementFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderHeaderPrElementFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderHeaderPrElementFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrderHeaderPrElement> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrderHeaderPrElement.class);
            for (SalesOrderHeaderPrElement entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderHeaderPrElementByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderHeaderPrElementByKeyFluentHelper(String salesOrder, String pricingProcedureStep, String pricingProcedureCounter) {
            this.values.add(salesOrder);
            this.values.add(pricingProcedureStep);
            this.values.add(pricingProcedureCounter);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderHeaderPrElement");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            keys.put("PricingProcedureStep", this.values.get(1));
            keys.put("PricingProcedureCounter", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderHeaderPrElementByKeyFluentHelper select(EntityField<?, SalesOrderHeaderPrElement> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderHeaderPrElementByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrderHeaderPrElement execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrderHeaderPrElement entity = (SalesOrderHeaderPrElement)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrderHeaderPrElement.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrderHeaderPrElement {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrderHeaderPrElement> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="ConditionQuantity")
        private BigDecimal conditionQuantity;
        public static EntityField<BigDecimal, SalesOrderHeaderPrElement> CONDITION_QUANTITY = new EntityField("ConditionQuantity");
        @ElementName(value="ConditionQuantityUnit")
        private String conditionQuantityUnit;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_QUANTITY_UNIT = new EntityField("ConditionQuantityUnit");
        @ElementName(value="ConditionCategory")
        private String conditionCategory;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_CATEGORY = new EntityField("ConditionCategory");
        @ElementName(value="ConditionIsForStatistics")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForStatistics;
        public static EntityField<Boolean, SalesOrderHeaderPrElement> CONDITION_IS_FOR_STATISTICS = new EntityField("ConditionIsForStatistics");
        @ElementName(value="PricingScaleType")
        private String pricingScaleType;
        public static EntityField<String, SalesOrderHeaderPrElement> PRICING_SCALE_TYPE = new EntityField("PricingScaleType");
        @ElementName(value="ConditionOrigin")
        private String conditionOrigin;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_ORIGIN = new EntityField("ConditionOrigin");
        @ElementName(value="IsGroupCondition")
        private String isGroupCondition;
        public static EntityField<String, SalesOrderHeaderPrElement> IS_GROUP_CONDITION = new EntityField("IsGroupCondition");
        @ElementName(value="ConditionRecord")
        private String conditionRecord;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_RECORD = new EntityField("ConditionRecord");
        @ElementName(value="ConditionSequentialNumber")
        private String conditionSequentialNumber;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_SEQUENTIAL_NUMBER = new EntityField("ConditionSequentialNumber");
        @ElementName(value="TaxCode")
        private String taxCode;
        public static EntityField<String, SalesOrderHeaderPrElement> TAX_CODE = new EntityField("TaxCode");
        @ElementName(value="PricingProcedureStep")
        private String pricingProcedureStep;
        public static EntityField<String, SalesOrderHeaderPrElement> PRICING_PROCEDURE_STEP = new EntityField("PricingProcedureStep");
        @ElementName(value="WithholdingTaxCode")
        private String withholdingTaxCode;
        public static EntityField<String, SalesOrderHeaderPrElement> WITHHOLDING_TAX_CODE = new EntityField("WithholdingTaxCode");
        @ElementName(value="CndnRoundingOffDiffAmount")
        private BigDecimal cndnRoundingOffDiffAmount;
        public static EntityField<BigDecimal, SalesOrderHeaderPrElement> CNDN_ROUNDING_OFF_DIFF_AMOUNT = new EntityField("CndnRoundingOffDiffAmount");
        @ElementName(value="ConditionAmount")
        private BigDecimal conditionAmount;
        public static EntityField<BigDecimal, SalesOrderHeaderPrElement> CONDITION_AMOUNT = new EntityField("ConditionAmount");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, SalesOrderHeaderPrElement> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="ConditionControl")
        private String conditionControl;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_CONTROL = new EntityField("ConditionControl");
        @ElementName(value="ConditionInactiveReason")
        private String conditionInactiveReason;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_INACTIVE_REASON = new EntityField("ConditionInactiveReason");
        @ElementName(value="ConditionClass")
        private String conditionClass;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_CLASS = new EntityField("ConditionClass");
        @ElementName(value="PrcgProcedureCounterForHeader")
        private String prcgProcedureCounterForHeader;
        public static EntityField<String, SalesOrderHeaderPrElement> PRCG_PROCEDURE_COUNTER_FOR_HEADER = new EntityField("PrcgProcedureCounterForHeader");
        @ElementName(value="FactorForConditionBasisValue")
        private Double factorForConditionBasisValue;
        public static EntityField<Double, SalesOrderHeaderPrElement> FACTOR_FOR_CONDITION_BASIS_VALUE = new EntityField("FactorForConditionBasisValue");
        @ElementName(value="StructureCondition")
        private String structureCondition;
        public static EntityField<String, SalesOrderHeaderPrElement> STRUCTURE_CONDITION = new EntityField("StructureCondition");
        @ElementName(value="PricingProcedureCounter")
        private String pricingProcedureCounter;
        public static EntityField<String, SalesOrderHeaderPrElement> PRICING_PROCEDURE_COUNTER = new EntityField("PricingProcedureCounter");
        @ElementName(value="PeriodFactorForCndnBasisValue")
        private Double periodFactorForCndnBasisValue;
        public static EntityField<Double, SalesOrderHeaderPrElement> PERIOD_FACTOR_FOR_CNDN_BASIS_VALUE = new EntityField("PeriodFactorForCndnBasisValue");
        @ElementName(value="PricingScaleBasis")
        private String pricingScaleBasis;
        public static EntityField<String, SalesOrderHeaderPrElement> PRICING_SCALE_BASIS = new EntityField("PricingScaleBasis");
        @ElementName(value="ConditionScaleBasisValue")
        private BigDecimal conditionScaleBasisValue;
        public static EntityField<BigDecimal, SalesOrderHeaderPrElement> CONDITION_SCALE_BASIS_VALUE = new EntityField("ConditionScaleBasisValue");
        @ElementName(value="ConditionScaleBasisUnit")
        private String conditionScaleBasisUnit;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_SCALE_BASIS_UNIT = new EntityField("ConditionScaleBasisUnit");
        @ElementName(value="ConditionScaleBasisCurrency")
        private String conditionScaleBasisCurrency;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_SCALE_BASIS_CURRENCY = new EntityField("ConditionScaleBasisCurrency");
        @ElementName(value="CndnIsRelevantForIntcoBilling")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean cndnIsRelevantForIntcoBilling;
        public static EntityField<Boolean, SalesOrderHeaderPrElement> CNDN_IS_RELEVANT_FOR_INTCO_BILLING = new EntityField("CndnIsRelevantForIntcoBilling");
        @ElementName(value="ConditionIsManuallyChanged")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsManuallyChanged;
        public static EntityField<Boolean, SalesOrderHeaderPrElement> CONDITION_IS_MANUALLY_CHANGED = new EntityField("ConditionIsManuallyChanged");
        @ElementName(value="ConditionIsForConfiguration")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean conditionIsForConfiguration;
        public static EntityField<Boolean, SalesOrderHeaderPrElement> CONDITION_IS_FOR_CONFIGURATION = new EntityField("ConditionIsForConfiguration");
        @ElementName(value="VariantCondition")
        private String variantCondition;
        public static EntityField<String, SalesOrderHeaderPrElement> VARIANT_CONDITION = new EntityField("VariantCondition");
        @ElementName(value="ConditionType")
        private String conditionType;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_TYPE = new EntityField("ConditionType");
        @ElementName(value="PricingDateTime")
        private String pricingDateTime;
        public static EntityField<String, SalesOrderHeaderPrElement> PRICING_DATE_TIME = new EntityField("PricingDateTime");
        @ElementName(value="ConditionCalculationType")
        private String conditionCalculationType;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_CALCULATION_TYPE = new EntityField("ConditionCalculationType");
        @ElementName(value="ConditionBaseValue")
        private BigDecimal conditionBaseValue;
        public static EntityField<BigDecimal, SalesOrderHeaderPrElement> CONDITION_BASE_VALUE = new EntityField("ConditionBaseValue");
        @ElementName(value="ConditionRateValue")
        private BigDecimal conditionRateValue;
        public static EntityField<BigDecimal, SalesOrderHeaderPrElement> CONDITION_RATE_VALUE = new EntityField("ConditionRateValue");
        @ElementName(value="ConditionCurrency")
        private String conditionCurrency;
        public static EntityField<String, SalesOrderHeaderPrElement> CONDITION_CURRENCY = new EntityField("ConditionCurrency");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrderHeaderPrElement";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public SalesOrder fetchSalesOrder() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",PricingProcedureStep=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureStep));
            odataResourceUrl.append(",PricingProcedureCounter=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.pricingProcedureCounter));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrder");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrder entityList = (SalesOrder)result.as(SalesOrder.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrderHeaderPrElement(salesOrder=" + this.salesOrder + ", conditionQuantity=" + this.conditionQuantity + ", conditionQuantityUnit=" + this.conditionQuantityUnit + ", conditionCategory=" + this.conditionCategory + ", conditionIsForStatistics=" + this.conditionIsForStatistics + ", pricingScaleType=" + this.pricingScaleType + ", conditionOrigin=" + this.conditionOrigin + ", isGroupCondition=" + this.isGroupCondition + ", conditionRecord=" + this.conditionRecord + ", conditionSequentialNumber=" + this.conditionSequentialNumber + ", taxCode=" + this.taxCode + ", pricingProcedureStep=" + this.pricingProcedureStep + ", withholdingTaxCode=" + this.withholdingTaxCode + ", cndnRoundingOffDiffAmount=" + this.cndnRoundingOffDiffAmount + ", conditionAmount=" + this.conditionAmount + ", transactionCurrency=" + this.transactionCurrency + ", conditionControl=" + this.conditionControl + ", conditionInactiveReason=" + this.conditionInactiveReason + ", conditionClass=" + this.conditionClass + ", prcgProcedureCounterForHeader=" + this.prcgProcedureCounterForHeader + ", factorForConditionBasisValue=" + this.factorForConditionBasisValue + ", structureCondition=" + this.structureCondition + ", pricingProcedureCounter=" + this.pricingProcedureCounter + ", periodFactorForCndnBasisValue=" + this.periodFactorForCndnBasisValue + ", pricingScaleBasis=" + this.pricingScaleBasis + ", conditionScaleBasisValue=" + this.conditionScaleBasisValue + ", conditionScaleBasisUnit=" + this.conditionScaleBasisUnit + ", conditionScaleBasisCurrency=" + this.conditionScaleBasisCurrency + ", cndnIsRelevantForIntcoBilling=" + this.cndnIsRelevantForIntcoBilling + ", conditionIsManuallyChanged=" + this.conditionIsManuallyChanged + ", conditionIsForConfiguration=" + this.conditionIsForConfiguration + ", variantCondition=" + this.variantCondition + ", conditionType=" + this.conditionType + ", pricingDateTime=" + this.pricingDateTime + ", conditionCalculationType=" + this.conditionCalculationType + ", conditionBaseValue=" + this.conditionBaseValue + ", conditionRateValue=" + this.conditionRateValue + ", conditionCurrency=" + this.conditionCurrency + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrderHeaderPrElement)) {
                return false;
            }
            SalesOrderHeaderPrElement other = (SalesOrderHeaderPrElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            BigDecimal this$conditionQuantity = this.conditionQuantity;
            BigDecimal other$conditionQuantity = other.conditionQuantity;
            if (this$conditionQuantity == null ? other$conditionQuantity != null : !((Object)this$conditionQuantity).equals(other$conditionQuantity)) {
                return false;
            }
            String this$conditionQuantityUnit = this.conditionQuantityUnit;
            String other$conditionQuantityUnit = other.conditionQuantityUnit;
            if (this$conditionQuantityUnit == null ? other$conditionQuantityUnit != null : !this$conditionQuantityUnit.equals(other$conditionQuantityUnit)) {
                return false;
            }
            String this$conditionCategory = this.conditionCategory;
            String other$conditionCategory = other.conditionCategory;
            if (this$conditionCategory == null ? other$conditionCategory != null : !this$conditionCategory.equals(other$conditionCategory)) {
                return false;
            }
            Boolean this$conditionIsForStatistics = this.conditionIsForStatistics;
            Boolean other$conditionIsForStatistics = other.conditionIsForStatistics;
            if (this$conditionIsForStatistics == null ? other$conditionIsForStatistics != null : !((Object)this$conditionIsForStatistics).equals(other$conditionIsForStatistics)) {
                return false;
            }
            String this$pricingScaleType = this.pricingScaleType;
            String other$pricingScaleType = other.pricingScaleType;
            if (this$pricingScaleType == null ? other$pricingScaleType != null : !this$pricingScaleType.equals(other$pricingScaleType)) {
                return false;
            }
            String this$conditionOrigin = this.conditionOrigin;
            String other$conditionOrigin = other.conditionOrigin;
            if (this$conditionOrigin == null ? other$conditionOrigin != null : !this$conditionOrigin.equals(other$conditionOrigin)) {
                return false;
            }
            String this$isGroupCondition = this.isGroupCondition;
            String other$isGroupCondition = other.isGroupCondition;
            if (this$isGroupCondition == null ? other$isGroupCondition != null : !this$isGroupCondition.equals(other$isGroupCondition)) {
                return false;
            }
            String this$conditionRecord = this.conditionRecord;
            String other$conditionRecord = other.conditionRecord;
            if (this$conditionRecord == null ? other$conditionRecord != null : !this$conditionRecord.equals(other$conditionRecord)) {
                return false;
            }
            String this$conditionSequentialNumber = this.conditionSequentialNumber;
            String other$conditionSequentialNumber = other.conditionSequentialNumber;
            if (this$conditionSequentialNumber == null ? other$conditionSequentialNumber != null : !this$conditionSequentialNumber.equals(other$conditionSequentialNumber)) {
                return false;
            }
            String this$taxCode = this.taxCode;
            String other$taxCode = other.taxCode;
            if (this$taxCode == null ? other$taxCode != null : !this$taxCode.equals(other$taxCode)) {
                return false;
            }
            String this$pricingProcedureStep = this.pricingProcedureStep;
            String other$pricingProcedureStep = other.pricingProcedureStep;
            if (this$pricingProcedureStep == null ? other$pricingProcedureStep != null : !this$pricingProcedureStep.equals(other$pricingProcedureStep)) {
                return false;
            }
            String this$withholdingTaxCode = this.withholdingTaxCode;
            String other$withholdingTaxCode = other.withholdingTaxCode;
            if (this$withholdingTaxCode == null ? other$withholdingTaxCode != null : !this$withholdingTaxCode.equals(other$withholdingTaxCode)) {
                return false;
            }
            BigDecimal this$cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            BigDecimal other$cndnRoundingOffDiffAmount = other.cndnRoundingOffDiffAmount;
            if (this$cndnRoundingOffDiffAmount == null ? other$cndnRoundingOffDiffAmount != null : !((Object)this$cndnRoundingOffDiffAmount).equals(other$cndnRoundingOffDiffAmount)) {
                return false;
            }
            BigDecimal this$conditionAmount = this.conditionAmount;
            BigDecimal other$conditionAmount = other.conditionAmount;
            if (this$conditionAmount == null ? other$conditionAmount != null : !((Object)this$conditionAmount).equals(other$conditionAmount)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            String this$conditionControl = this.conditionControl;
            String other$conditionControl = other.conditionControl;
            if (this$conditionControl == null ? other$conditionControl != null : !this$conditionControl.equals(other$conditionControl)) {
                return false;
            }
            String this$conditionInactiveReason = this.conditionInactiveReason;
            String other$conditionInactiveReason = other.conditionInactiveReason;
            if (this$conditionInactiveReason == null ? other$conditionInactiveReason != null : !this$conditionInactiveReason.equals(other$conditionInactiveReason)) {
                return false;
            }
            String this$conditionClass = this.conditionClass;
            String other$conditionClass = other.conditionClass;
            if (this$conditionClass == null ? other$conditionClass != null : !this$conditionClass.equals(other$conditionClass)) {
                return false;
            }
            String this$prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            String other$prcgProcedureCounterForHeader = other.prcgProcedureCounterForHeader;
            if (this$prcgProcedureCounterForHeader == null ? other$prcgProcedureCounterForHeader != null : !this$prcgProcedureCounterForHeader.equals(other$prcgProcedureCounterForHeader)) {
                return false;
            }
            Double this$factorForConditionBasisValue = this.factorForConditionBasisValue;
            Double other$factorForConditionBasisValue = other.factorForConditionBasisValue;
            if (this$factorForConditionBasisValue == null ? other$factorForConditionBasisValue != null : !((Object)this$factorForConditionBasisValue).equals(other$factorForConditionBasisValue)) {
                return false;
            }
            String this$structureCondition = this.structureCondition;
            String other$structureCondition = other.structureCondition;
            if (this$structureCondition == null ? other$structureCondition != null : !this$structureCondition.equals(other$structureCondition)) {
                return false;
            }
            String this$pricingProcedureCounter = this.pricingProcedureCounter;
            String other$pricingProcedureCounter = other.pricingProcedureCounter;
            if (this$pricingProcedureCounter == null ? other$pricingProcedureCounter != null : !this$pricingProcedureCounter.equals(other$pricingProcedureCounter)) {
                return false;
            }
            Double this$periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            Double other$periodFactorForCndnBasisValue = other.periodFactorForCndnBasisValue;
            if (this$periodFactorForCndnBasisValue == null ? other$periodFactorForCndnBasisValue != null : !((Object)this$periodFactorForCndnBasisValue).equals(other$periodFactorForCndnBasisValue)) {
                return false;
            }
            String this$pricingScaleBasis = this.pricingScaleBasis;
            String other$pricingScaleBasis = other.pricingScaleBasis;
            if (this$pricingScaleBasis == null ? other$pricingScaleBasis != null : !this$pricingScaleBasis.equals(other$pricingScaleBasis)) {
                return false;
            }
            BigDecimal this$conditionScaleBasisValue = this.conditionScaleBasisValue;
            BigDecimal other$conditionScaleBasisValue = other.conditionScaleBasisValue;
            if (this$conditionScaleBasisValue == null ? other$conditionScaleBasisValue != null : !((Object)this$conditionScaleBasisValue).equals(other$conditionScaleBasisValue)) {
                return false;
            }
            String this$conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            String other$conditionScaleBasisUnit = other.conditionScaleBasisUnit;
            if (this$conditionScaleBasisUnit == null ? other$conditionScaleBasisUnit != null : !this$conditionScaleBasisUnit.equals(other$conditionScaleBasisUnit)) {
                return false;
            }
            String this$conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            String other$conditionScaleBasisCurrency = other.conditionScaleBasisCurrency;
            if (this$conditionScaleBasisCurrency == null ? other$conditionScaleBasisCurrency != null : !this$conditionScaleBasisCurrency.equals(other$conditionScaleBasisCurrency)) {
                return false;
            }
            Boolean this$cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            Boolean other$cndnIsRelevantForIntcoBilling = other.cndnIsRelevantForIntcoBilling;
            if (this$cndnIsRelevantForIntcoBilling == null ? other$cndnIsRelevantForIntcoBilling != null : !((Object)this$cndnIsRelevantForIntcoBilling).equals(other$cndnIsRelevantForIntcoBilling)) {
                return false;
            }
            Boolean this$conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            Boolean other$conditionIsManuallyChanged = other.conditionIsManuallyChanged;
            if (this$conditionIsManuallyChanged == null ? other$conditionIsManuallyChanged != null : !((Object)this$conditionIsManuallyChanged).equals(other$conditionIsManuallyChanged)) {
                return false;
            }
            Boolean this$conditionIsForConfiguration = this.conditionIsForConfiguration;
            Boolean other$conditionIsForConfiguration = other.conditionIsForConfiguration;
            if (this$conditionIsForConfiguration == null ? other$conditionIsForConfiguration != null : !((Object)this$conditionIsForConfiguration).equals(other$conditionIsForConfiguration)) {
                return false;
            }
            String this$variantCondition = this.variantCondition;
            String other$variantCondition = other.variantCondition;
            if (this$variantCondition == null ? other$variantCondition != null : !this$variantCondition.equals(other$variantCondition)) {
                return false;
            }
            String this$conditionType = this.conditionType;
            String other$conditionType = other.conditionType;
            if (this$conditionType == null ? other$conditionType != null : !this$conditionType.equals(other$conditionType)) {
                return false;
            }
            String this$pricingDateTime = this.pricingDateTime;
            String other$pricingDateTime = other.pricingDateTime;
            if (this$pricingDateTime == null ? other$pricingDateTime != null : !this$pricingDateTime.equals(other$pricingDateTime)) {
                return false;
            }
            String this$conditionCalculationType = this.conditionCalculationType;
            String other$conditionCalculationType = other.conditionCalculationType;
            if (this$conditionCalculationType == null ? other$conditionCalculationType != null : !this$conditionCalculationType.equals(other$conditionCalculationType)) {
                return false;
            }
            BigDecimal this$conditionBaseValue = this.conditionBaseValue;
            BigDecimal other$conditionBaseValue = other.conditionBaseValue;
            if (this$conditionBaseValue == null ? other$conditionBaseValue != null : !((Object)this$conditionBaseValue).equals(other$conditionBaseValue)) {
                return false;
            }
            BigDecimal this$conditionRateValue = this.conditionRateValue;
            BigDecimal other$conditionRateValue = other.conditionRateValue;
            if (this$conditionRateValue == null ? other$conditionRateValue != null : !((Object)this$conditionRateValue).equals(other$conditionRateValue)) {
                return false;
            }
            String this$conditionCurrency = this.conditionCurrency;
            String other$conditionCurrency = other.conditionCurrency;
            return !(this$conditionCurrency == null ? other$conditionCurrency != null : !this$conditionCurrency.equals(other$conditionCurrency));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrderHeaderPrElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            BigDecimal $conditionQuantity = this.conditionQuantity;
            result = result * 59 + ($conditionQuantity == null ? 43 : ((Object)$conditionQuantity).hashCode());
            String $conditionQuantityUnit = this.conditionQuantityUnit;
            result = result * 59 + ($conditionQuantityUnit == null ? 43 : $conditionQuantityUnit.hashCode());
            String $conditionCategory = this.conditionCategory;
            result = result * 59 + ($conditionCategory == null ? 43 : $conditionCategory.hashCode());
            Boolean $conditionIsForStatistics = this.conditionIsForStatistics;
            result = result * 59 + ($conditionIsForStatistics == null ? 43 : ((Object)$conditionIsForStatistics).hashCode());
            String $pricingScaleType = this.pricingScaleType;
            result = result * 59 + ($pricingScaleType == null ? 43 : $pricingScaleType.hashCode());
            String $conditionOrigin = this.conditionOrigin;
            result = result * 59 + ($conditionOrigin == null ? 43 : $conditionOrigin.hashCode());
            String $isGroupCondition = this.isGroupCondition;
            result = result * 59 + ($isGroupCondition == null ? 43 : $isGroupCondition.hashCode());
            String $conditionRecord = this.conditionRecord;
            result = result * 59 + ($conditionRecord == null ? 43 : $conditionRecord.hashCode());
            String $conditionSequentialNumber = this.conditionSequentialNumber;
            result = result * 59 + ($conditionSequentialNumber == null ? 43 : $conditionSequentialNumber.hashCode());
            String $taxCode = this.taxCode;
            result = result * 59 + ($taxCode == null ? 43 : $taxCode.hashCode());
            String $pricingProcedureStep = this.pricingProcedureStep;
            result = result * 59 + ($pricingProcedureStep == null ? 43 : $pricingProcedureStep.hashCode());
            String $withholdingTaxCode = this.withholdingTaxCode;
            result = result * 59 + ($withholdingTaxCode == null ? 43 : $withholdingTaxCode.hashCode());
            BigDecimal $cndnRoundingOffDiffAmount = this.cndnRoundingOffDiffAmount;
            result = result * 59 + ($cndnRoundingOffDiffAmount == null ? 43 : ((Object)$cndnRoundingOffDiffAmount).hashCode());
            BigDecimal $conditionAmount = this.conditionAmount;
            result = result * 59 + ($conditionAmount == null ? 43 : ((Object)$conditionAmount).hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            String $conditionControl = this.conditionControl;
            result = result * 59 + ($conditionControl == null ? 43 : $conditionControl.hashCode());
            String $conditionInactiveReason = this.conditionInactiveReason;
            result = result * 59 + ($conditionInactiveReason == null ? 43 : $conditionInactiveReason.hashCode());
            String $conditionClass = this.conditionClass;
            result = result * 59 + ($conditionClass == null ? 43 : $conditionClass.hashCode());
            String $prcgProcedureCounterForHeader = this.prcgProcedureCounterForHeader;
            result = result * 59 + ($prcgProcedureCounterForHeader == null ? 43 : $prcgProcedureCounterForHeader.hashCode());
            Double $factorForConditionBasisValue = this.factorForConditionBasisValue;
            result = result * 59 + ($factorForConditionBasisValue == null ? 43 : ((Object)$factorForConditionBasisValue).hashCode());
            String $structureCondition = this.structureCondition;
            result = result * 59 + ($structureCondition == null ? 43 : $structureCondition.hashCode());
            String $pricingProcedureCounter = this.pricingProcedureCounter;
            result = result * 59 + ($pricingProcedureCounter == null ? 43 : $pricingProcedureCounter.hashCode());
            Double $periodFactorForCndnBasisValue = this.periodFactorForCndnBasisValue;
            result = result * 59 + ($periodFactorForCndnBasisValue == null ? 43 : ((Object)$periodFactorForCndnBasisValue).hashCode());
            String $pricingScaleBasis = this.pricingScaleBasis;
            result = result * 59 + ($pricingScaleBasis == null ? 43 : $pricingScaleBasis.hashCode());
            BigDecimal $conditionScaleBasisValue = this.conditionScaleBasisValue;
            result = result * 59 + ($conditionScaleBasisValue == null ? 43 : ((Object)$conditionScaleBasisValue).hashCode());
            String $conditionScaleBasisUnit = this.conditionScaleBasisUnit;
            result = result * 59 + ($conditionScaleBasisUnit == null ? 43 : $conditionScaleBasisUnit.hashCode());
            String $conditionScaleBasisCurrency = this.conditionScaleBasisCurrency;
            result = result * 59 + ($conditionScaleBasisCurrency == null ? 43 : $conditionScaleBasisCurrency.hashCode());
            Boolean $cndnIsRelevantForIntcoBilling = this.cndnIsRelevantForIntcoBilling;
            result = result * 59 + ($cndnIsRelevantForIntcoBilling == null ? 43 : ((Object)$cndnIsRelevantForIntcoBilling).hashCode());
            Boolean $conditionIsManuallyChanged = this.conditionIsManuallyChanged;
            result = result * 59 + ($conditionIsManuallyChanged == null ? 43 : ((Object)$conditionIsManuallyChanged).hashCode());
            Boolean $conditionIsForConfiguration = this.conditionIsForConfiguration;
            result = result * 59 + ($conditionIsForConfiguration == null ? 43 : ((Object)$conditionIsForConfiguration).hashCode());
            String $variantCondition = this.variantCondition;
            result = result * 59 + ($variantCondition == null ? 43 : $variantCondition.hashCode());
            String $conditionType = this.conditionType;
            result = result * 59 + ($conditionType == null ? 43 : $conditionType.hashCode());
            String $pricingDateTime = this.pricingDateTime;
            result = result * 59 + ($pricingDateTime == null ? 43 : $pricingDateTime.hashCode());
            String $conditionCalculationType = this.conditionCalculationType;
            result = result * 59 + ($conditionCalculationType == null ? 43 : $conditionCalculationType.hashCode());
            BigDecimal $conditionBaseValue = this.conditionBaseValue;
            result = result * 59 + ($conditionBaseValue == null ? 43 : ((Object)$conditionBaseValue).hashCode());
            BigDecimal $conditionRateValue = this.conditionRateValue;
            result = result * 59 + ($conditionRateValue == null ? 43 : ((Object)$conditionRateValue).hashCode());
            String $conditionCurrency = this.conditionCurrency;
            result = result * 59 + ($conditionCurrency == null ? 43 : $conditionCurrency.hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrderHeaderPrElement setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public BigDecimal getConditionQuantity() {
            return this.conditionQuantity;
        }

        public SalesOrderHeaderPrElement setConditionQuantity(BigDecimal conditionQuantity) {
            this.conditionQuantity = conditionQuantity;
            return this;
        }

        public String getConditionQuantityUnit() {
            return this.conditionQuantityUnit;
        }

        public SalesOrderHeaderPrElement setConditionQuantityUnit(String conditionQuantityUnit) {
            this.conditionQuantityUnit = conditionQuantityUnit;
            return this;
        }

        public String getConditionCategory() {
            return this.conditionCategory;
        }

        public SalesOrderHeaderPrElement setConditionCategory(String conditionCategory) {
            this.conditionCategory = conditionCategory;
            return this;
        }

        public Boolean getConditionIsForStatistics() {
            return this.conditionIsForStatistics;
        }

        public SalesOrderHeaderPrElement setConditionIsForStatistics(Boolean conditionIsForStatistics) {
            this.conditionIsForStatistics = conditionIsForStatistics;
            return this;
        }

        public String getPricingScaleType() {
            return this.pricingScaleType;
        }

        public SalesOrderHeaderPrElement setPricingScaleType(String pricingScaleType) {
            this.pricingScaleType = pricingScaleType;
            return this;
        }

        public String getConditionOrigin() {
            return this.conditionOrigin;
        }

        public SalesOrderHeaderPrElement setConditionOrigin(String conditionOrigin) {
            this.conditionOrigin = conditionOrigin;
            return this;
        }

        public String getIsGroupCondition() {
            return this.isGroupCondition;
        }

        public SalesOrderHeaderPrElement setIsGroupCondition(String isGroupCondition) {
            this.isGroupCondition = isGroupCondition;
            return this;
        }

        public String getConditionRecord() {
            return this.conditionRecord;
        }

        public SalesOrderHeaderPrElement setConditionRecord(String conditionRecord) {
            this.conditionRecord = conditionRecord;
            return this;
        }

        public String getConditionSequentialNumber() {
            return this.conditionSequentialNumber;
        }

        public SalesOrderHeaderPrElement setConditionSequentialNumber(String conditionSequentialNumber) {
            this.conditionSequentialNumber = conditionSequentialNumber;
            return this;
        }

        public String getTaxCode() {
            return this.taxCode;
        }

        public SalesOrderHeaderPrElement setTaxCode(String taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public String getPricingProcedureStep() {
            return this.pricingProcedureStep;
        }

        public SalesOrderHeaderPrElement setPricingProcedureStep(String pricingProcedureStep) {
            this.pricingProcedureStep = pricingProcedureStep;
            return this;
        }

        public String getWithholdingTaxCode() {
            return this.withholdingTaxCode;
        }

        public SalesOrderHeaderPrElement setWithholdingTaxCode(String withholdingTaxCode) {
            this.withholdingTaxCode = withholdingTaxCode;
            return this;
        }

        public BigDecimal getCndnRoundingOffDiffAmount() {
            return this.cndnRoundingOffDiffAmount;
        }

        public SalesOrderHeaderPrElement setCndnRoundingOffDiffAmount(BigDecimal cndnRoundingOffDiffAmount) {
            this.cndnRoundingOffDiffAmount = cndnRoundingOffDiffAmount;
            return this;
        }

        public BigDecimal getConditionAmount() {
            return this.conditionAmount;
        }

        public SalesOrderHeaderPrElement setConditionAmount(BigDecimal conditionAmount) {
            this.conditionAmount = conditionAmount;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public SalesOrderHeaderPrElement setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public String getConditionControl() {
            return this.conditionControl;
        }

        public SalesOrderHeaderPrElement setConditionControl(String conditionControl) {
            this.conditionControl = conditionControl;
            return this;
        }

        public String getConditionInactiveReason() {
            return this.conditionInactiveReason;
        }

        public SalesOrderHeaderPrElement setConditionInactiveReason(String conditionInactiveReason) {
            this.conditionInactiveReason = conditionInactiveReason;
            return this;
        }

        public String getConditionClass() {
            return this.conditionClass;
        }

        public SalesOrderHeaderPrElement setConditionClass(String conditionClass) {
            this.conditionClass = conditionClass;
            return this;
        }

        public String getPrcgProcedureCounterForHeader() {
            return this.prcgProcedureCounterForHeader;
        }

        public SalesOrderHeaderPrElement setPrcgProcedureCounterForHeader(String prcgProcedureCounterForHeader) {
            this.prcgProcedureCounterForHeader = prcgProcedureCounterForHeader;
            return this;
        }

        public Double getFactorForConditionBasisValue() {
            return this.factorForConditionBasisValue;
        }

        public SalesOrderHeaderPrElement setFactorForConditionBasisValue(Double factorForConditionBasisValue) {
            this.factorForConditionBasisValue = factorForConditionBasisValue;
            return this;
        }

        public String getStructureCondition() {
            return this.structureCondition;
        }

        public SalesOrderHeaderPrElement setStructureCondition(String structureCondition) {
            this.structureCondition = structureCondition;
            return this;
        }

        public String getPricingProcedureCounter() {
            return this.pricingProcedureCounter;
        }

        public SalesOrderHeaderPrElement setPricingProcedureCounter(String pricingProcedureCounter) {
            this.pricingProcedureCounter = pricingProcedureCounter;
            return this;
        }

        public Double getPeriodFactorForCndnBasisValue() {
            return this.periodFactorForCndnBasisValue;
        }

        public SalesOrderHeaderPrElement setPeriodFactorForCndnBasisValue(Double periodFactorForCndnBasisValue) {
            this.periodFactorForCndnBasisValue = periodFactorForCndnBasisValue;
            return this;
        }

        public String getPricingScaleBasis() {
            return this.pricingScaleBasis;
        }

        public SalesOrderHeaderPrElement setPricingScaleBasis(String pricingScaleBasis) {
            this.pricingScaleBasis = pricingScaleBasis;
            return this;
        }

        public BigDecimal getConditionScaleBasisValue() {
            return this.conditionScaleBasisValue;
        }

        public SalesOrderHeaderPrElement setConditionScaleBasisValue(BigDecimal conditionScaleBasisValue) {
            this.conditionScaleBasisValue = conditionScaleBasisValue;
            return this;
        }

        public String getConditionScaleBasisUnit() {
            return this.conditionScaleBasisUnit;
        }

        public SalesOrderHeaderPrElement setConditionScaleBasisUnit(String conditionScaleBasisUnit) {
            this.conditionScaleBasisUnit = conditionScaleBasisUnit;
            return this;
        }

        public String getConditionScaleBasisCurrency() {
            return this.conditionScaleBasisCurrency;
        }

        public SalesOrderHeaderPrElement setConditionScaleBasisCurrency(String conditionScaleBasisCurrency) {
            this.conditionScaleBasisCurrency = conditionScaleBasisCurrency;
            return this;
        }

        public Boolean getCndnIsRelevantForIntcoBilling() {
            return this.cndnIsRelevantForIntcoBilling;
        }

        public SalesOrderHeaderPrElement setCndnIsRelevantForIntcoBilling(Boolean cndnIsRelevantForIntcoBilling) {
            this.cndnIsRelevantForIntcoBilling = cndnIsRelevantForIntcoBilling;
            return this;
        }

        public Boolean getConditionIsManuallyChanged() {
            return this.conditionIsManuallyChanged;
        }

        public SalesOrderHeaderPrElement setConditionIsManuallyChanged(Boolean conditionIsManuallyChanged) {
            this.conditionIsManuallyChanged = conditionIsManuallyChanged;
            return this;
        }

        public Boolean getConditionIsForConfiguration() {
            return this.conditionIsForConfiguration;
        }

        public SalesOrderHeaderPrElement setConditionIsForConfiguration(Boolean conditionIsForConfiguration) {
            this.conditionIsForConfiguration = conditionIsForConfiguration;
            return this;
        }

        public String getVariantCondition() {
            return this.variantCondition;
        }

        public SalesOrderHeaderPrElement setVariantCondition(String variantCondition) {
            this.variantCondition = variantCondition;
            return this;
        }

        public String getConditionType() {
            return this.conditionType;
        }

        public SalesOrderHeaderPrElement setConditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        public String getPricingDateTime() {
            return this.pricingDateTime;
        }

        public SalesOrderHeaderPrElement setPricingDateTime(String pricingDateTime) {
            this.pricingDateTime = pricingDateTime;
            return this;
        }

        public String getConditionCalculationType() {
            return this.conditionCalculationType;
        }

        public SalesOrderHeaderPrElement setConditionCalculationType(String conditionCalculationType) {
            this.conditionCalculationType = conditionCalculationType;
            return this;
        }

        public BigDecimal getConditionBaseValue() {
            return this.conditionBaseValue;
        }

        public SalesOrderHeaderPrElement setConditionBaseValue(BigDecimal conditionBaseValue) {
            this.conditionBaseValue = conditionBaseValue;
            return this;
        }

        public BigDecimal getConditionRateValue() {
            return this.conditionRateValue;
        }

        public SalesOrderHeaderPrElement setConditionRateValue(BigDecimal conditionRateValue) {
            this.conditionRateValue = conditionRateValue;
            return this;
        }

        public String getConditionCurrency() {
            return this.conditionCurrency;
        }

        public SalesOrderHeaderPrElement setConditionCurrency(String conditionCurrency) {
            this.conditionCurrency = conditionCurrency;
            return this;
        }

        public SalesOrderHeaderPrElement setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class SalesOrderHeaderPartnerFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderHeaderPartner");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderHeaderPartnerFluentHelper filter(ExpressionFluentHelper<SalesOrderHeaderPartner> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderHeaderPartnerFluentHelper orderBy(EntityField<?, SalesOrderHeaderPartner> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderHeaderPartnerFluentHelper select(EntityField<?, SalesOrderHeaderPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderHeaderPartnerFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderHeaderPartnerFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderHeaderPartnerFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrderHeaderPartner> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrderHeaderPartner.class);
            for (SalesOrderHeaderPartner entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderHeaderPartnerByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderHeaderPartnerByKeyFluentHelper(String salesOrder, String partnerFunction) {
            this.values.add(salesOrder);
            this.values.add(partnerFunction);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrderHeaderPartner");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            keys.put("PartnerFunction", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderHeaderPartnerByKeyFluentHelper select(EntityField<?, SalesOrderHeaderPartner> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderHeaderPartnerByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrderHeaderPartner execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrderHeaderPartner entity = (SalesOrderHeaderPartner)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrderHeaderPartner.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrderHeaderPartner {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrderHeaderPartner> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="PartnerFunction")
        private String partnerFunction;
        public static EntityField<String, SalesOrderHeaderPartner> PARTNER_FUNCTION = new EntityField("PartnerFunction");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, SalesOrderHeaderPartner> CUSTOMER = new EntityField("Customer");
        @ElementName(value="Supplier")
        private String supplier;
        public static EntityField<String, SalesOrderHeaderPartner> SUPPLIER = new EntityField("Supplier");
        @ElementName(value="Personnel")
        private String personnel;
        public static EntityField<String, SalesOrderHeaderPartner> PERSONNEL = new EntityField("Personnel");
        @ElementName(value="ContactPerson")
        private String contactPerson;
        public static EntityField<String, SalesOrderHeaderPartner> CONTACT_PERSON = new EntityField("ContactPerson");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrderHeaderPartner";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public SalesOrder fetchSalesOrder() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(",PartnerFunction=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.partnerFunction));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_SalesOrder");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            SalesOrder entityList = (SalesOrder)result.as(SalesOrder.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrderHeaderPartner(salesOrder=" + this.salesOrder + ", partnerFunction=" + this.partnerFunction + ", customer=" + this.customer + ", supplier=" + this.supplier + ", personnel=" + this.personnel + ", contactPerson=" + this.contactPerson + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrderHeaderPartner)) {
                return false;
            }
            SalesOrderHeaderPartner other = (SalesOrderHeaderPartner)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$partnerFunction = this.partnerFunction;
            String other$partnerFunction = other.partnerFunction;
            if (this$partnerFunction == null ? other$partnerFunction != null : !this$partnerFunction.equals(other$partnerFunction)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$supplier = this.supplier;
            String other$supplier = other.supplier;
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            String this$personnel = this.personnel;
            String other$personnel = other.personnel;
            if (this$personnel == null ? other$personnel != null : !this$personnel.equals(other$personnel)) {
                return false;
            }
            String this$contactPerson = this.contactPerson;
            String other$contactPerson = other.contactPerson;
            return !(this$contactPerson == null ? other$contactPerson != null : !this$contactPerson.equals(other$contactPerson));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrderHeaderPartner;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $partnerFunction = this.partnerFunction;
            result = result * 59 + ($partnerFunction == null ? 43 : $partnerFunction.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $supplier = this.supplier;
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            String $personnel = this.personnel;
            result = result * 59 + ($personnel == null ? 43 : $personnel.hashCode());
            String $contactPerson = this.contactPerson;
            result = result * 59 + ($contactPerson == null ? 43 : $contactPerson.hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrderHeaderPartner setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getPartnerFunction() {
            return this.partnerFunction;
        }

        public SalesOrderHeaderPartner setPartnerFunction(String partnerFunction) {
            this.partnerFunction = partnerFunction;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public SalesOrderHeaderPartner setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public SalesOrderHeaderPartner setSupplier(String supplier) {
            this.supplier = supplier;
            return this;
        }

        public String getPersonnel() {
            return this.personnel;
        }

        public SalesOrderHeaderPartner setPersonnel(String personnel) {
            this.personnel = personnel;
            return this;
        }

        public String getContactPerson() {
            return this.contactPerson;
        }

        public SalesOrderHeaderPartner setContactPerson(String contactPerson) {
            this.contactPerson = contactPerson;
            return this;
        }

        public SalesOrderHeaderPartner setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class SalesOrderFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrder");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public SalesOrderFluentHelper filter(ExpressionFluentHelper<SalesOrder> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public SalesOrderFluentHelper orderBy(EntityField<?, SalesOrder> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final SalesOrderFluentHelper select(EntityField<?, SalesOrder> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public SalesOrderFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public SalesOrderFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public SalesOrderFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<SalesOrder> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(SalesOrder.class);
            for (SalesOrder entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class SalesOrderByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public SalesOrderByKeyFluentHelper(String salesOrder) {
            this.values.add(salesOrder);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_SALES_ORDER_SRV", (String)"A_SalesOrder");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("SalesOrder", this.values.get(0));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final SalesOrderByKeyFluentHelper select(EntityField<?, SalesOrder> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public SalesOrderByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public SalesOrder execute(ErpConfigContext erpConfigContext) throws ODataException {
            SalesOrder entity = (SalesOrder)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(SalesOrder.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class SalesOrder {
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, SalesOrder> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="CreationDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar creationDate;
        public static EntityField<Calendar, SalesOrder> CREATION_DATE = new EntityField("CreationDate");
        @ElementName(value="CreatedByUser")
        private String createdByUser;
        public static EntityField<String, SalesOrder> CREATED_BY_USER = new EntityField("CreatedByUser");
        @ElementName(value="LastChangeDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDate;
        public static EntityField<Calendar, SalesOrder> LAST_CHANGE_DATE = new EntityField("LastChangeDate");
        @ElementName(value="LastChangeDateTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDateTime;
        public static EntityField<Calendar, SalesOrder> LAST_CHANGE_DATE_TIME = new EntityField("LastChangeDateTime");
        @ElementName(value="PurchaseOrderByCustomer")
        private String purchaseOrderByCustomer;
        public static EntityField<String, SalesOrder> PURCHASE_ORDER_BY_CUSTOMER = new EntityField("PurchaseOrderByCustomer");
        @ElementName(value="CustomerPurchaseOrderType")
        private String customerPurchaseOrderType;
        public static EntityField<String, SalesOrder> CUSTOMER_PURCHASE_ORDER_TYPE = new EntityField("CustomerPurchaseOrderType");
        @ElementName(value="CustomerPurchaseOrderDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar customerPurchaseOrderDate;
        public static EntityField<Calendar, SalesOrder> CUSTOMER_PURCHASE_ORDER_DATE = new EntityField("CustomerPurchaseOrderDate");
        @ElementName(value="SalesOrderDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar salesOrderDate;
        public static EntityField<Calendar, SalesOrder> SALES_ORDER_DATE = new EntityField("SalesOrderDate");
        @ElementName(value="TotalNetAmount")
        private BigDecimal totalNetAmount;
        public static EntityField<BigDecimal, SalesOrder> TOTAL_NET_AMOUNT = new EntityField("TotalNetAmount");
        @ElementName(value="TransactionCurrency")
        private String transactionCurrency;
        public static EntityField<String, SalesOrder> TRANSACTION_CURRENCY = new EntityField("TransactionCurrency");
        @ElementName(value="SalesOrderType")
        private String salesOrderType;
        public static EntityField<String, SalesOrder> SALES_ORDER_TYPE = new EntityField("SalesOrderType");
        @ElementName(value="SDDocumentReason")
        private String sDDocumentReason;
        public static EntityField<String, SalesOrder> S_D_DOCUMENT_REASON = new EntityField("SDDocumentReason");
        @ElementName(value="PricingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar pricingDate;
        public static EntityField<Calendar, SalesOrder> PRICING_DATE = new EntityField("PricingDate");
        @ElementName(value="RequestedDeliveryDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar requestedDeliveryDate;
        public static EntityField<Calendar, SalesOrder> REQUESTED_DELIVERY_DATE = new EntityField("RequestedDeliveryDate");
        @ElementName(value="ShippingCondition")
        private String shippingCondition;
        public static EntityField<String, SalesOrder> SHIPPING_CONDITION = new EntityField("ShippingCondition");
        @ElementName(value="CompleteDeliveryIsDefined")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean completeDeliveryIsDefined;
        public static EntityField<Boolean, SalesOrder> COMPLETE_DELIVERY_IS_DEFINED = new EntityField("CompleteDeliveryIsDefined");
        @ElementName(value="ShippingType")
        private String shippingType;
        public static EntityField<String, SalesOrder> SHIPPING_TYPE = new EntityField("ShippingType");
        @ElementName(value="HeaderBillingBlockReason")
        private String headerBillingBlockReason;
        public static EntityField<String, SalesOrder> HEADER_BILLING_BLOCK_REASON = new EntityField("HeaderBillingBlockReason");
        @ElementName(value="DeliveryBlockReason")
        private String deliveryBlockReason;
        public static EntityField<String, SalesOrder> DELIVERY_BLOCK_REASON = new EntityField("DeliveryBlockReason");
        @ElementName(value="IncotermsClassification")
        private String incotermsClassification;
        public static EntityField<String, SalesOrder> INCOTERMS_CLASSIFICATION = new EntityField("IncotermsClassification");
        @ElementName(value="IncotermsTransferLocation")
        private String incotermsTransferLocation;
        public static EntityField<String, SalesOrder> INCOTERMS_TRANSFER_LOCATION = new EntityField("IncotermsTransferLocation");
        @ElementName(value="SalesOrganization")
        private String salesOrganization;
        public static EntityField<String, SalesOrder> SALES_ORGANIZATION = new EntityField("SalesOrganization");
        @ElementName(value="CustomerPaymentTerms")
        private String customerPaymentTerms;
        public static EntityField<String, SalesOrder> CUSTOMER_PAYMENT_TERMS = new EntityField("CustomerPaymentTerms");
        @ElementName(value="PaymentMethod")
        private String paymentMethod;
        public static EntityField<String, SalesOrder> PAYMENT_METHOD = new EntityField("PaymentMethod");
        @ElementName(value="OverallSDProcessStatus")
        private String overallSDProcessStatus;
        public static EntityField<String, SalesOrder> OVERALL_S_D_PROCESS_STATUS = new EntityField("OverallSDProcessStatus");
        @ElementName(value="TotalCreditCheckStatus")
        private String totalCreditCheckStatus;
        public static EntityField<String, SalesOrder> TOTAL_CREDIT_CHECK_STATUS = new EntityField("TotalCreditCheckStatus");
        @ElementName(value="OverallTotalDeliveryStatus")
        private String overallTotalDeliveryStatus;
        public static EntityField<String, SalesOrder> OVERALL_TOTAL_DELIVERY_STATUS = new EntityField("OverallTotalDeliveryStatus");
        @ElementName(value="OverallSDDocumentRejectionSts")
        private String overallSDDocumentRejectionSts;
        public static EntityField<String, SalesOrder> OVERALL_S_D_DOCUMENT_REJECTION_STS = new EntityField("OverallSDDocumentRejectionSts");
        @ElementName(value="DistributionChannel")
        private String distributionChannel;
        public static EntityField<String, SalesOrder> DISTRIBUTION_CHANNEL = new EntityField("DistributionChannel");
        @ElementName(value="OrganizationDivision")
        private String organizationDivision;
        public static EntityField<String, SalesOrder> ORGANIZATION_DIVISION = new EntityField("OrganizationDivision");
        @ElementName(value="SalesGroup")
        private String salesGroup;
        public static EntityField<String, SalesOrder> SALES_GROUP = new EntityField("SalesGroup");
        @ElementName(value="SalesOffice")
        private String salesOffice;
        public static EntityField<String, SalesOrder> SALES_OFFICE = new EntityField("SalesOffice");
        @ElementName(value="SalesDistrict")
        private String salesDistrict;
        public static EntityField<String, SalesOrder> SALES_DISTRICT = new EntityField("SalesDistrict");
        @ElementName(value="SoldToParty")
        private String soldToParty;
        public static EntityField<String, SalesOrder> SOLD_TO_PARTY = new EntityField("SoldToParty");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_SALES_ORDER_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_SalesOrder";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<SalesOrderItem> fetchItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Item");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(SalesOrderItem.class);
            for (SalesOrderItem entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<SalesOrderHeaderPartner> fetchPartner() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_Partner");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(SalesOrderHeaderPartner.class);
            for (SalesOrderHeaderPartner entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        @JsonIgnore
        public List<SalesOrderHeaderPrElement> fetchPricingElement() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("SalesOrder=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.salesOrder));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PricingElement");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(SalesOrderHeaderPrElement.class);
            for (SalesOrderHeaderPrElement entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ProcessSalesOrdersNamespace.SalesOrder(salesOrder=" + this.salesOrder + ", creationDate=" + this.creationDate + ", createdByUser=" + this.createdByUser + ", lastChangeDate=" + this.lastChangeDate + ", lastChangeDateTime=" + this.lastChangeDateTime + ", purchaseOrderByCustomer=" + this.purchaseOrderByCustomer + ", customerPurchaseOrderType=" + this.customerPurchaseOrderType + ", customerPurchaseOrderDate=" + this.customerPurchaseOrderDate + ", salesOrderDate=" + this.salesOrderDate + ", totalNetAmount=" + this.totalNetAmount + ", transactionCurrency=" + this.transactionCurrency + ", salesOrderType=" + this.salesOrderType + ", sDDocumentReason=" + this.sDDocumentReason + ", pricingDate=" + this.pricingDate + ", requestedDeliveryDate=" + this.requestedDeliveryDate + ", shippingCondition=" + this.shippingCondition + ", completeDeliveryIsDefined=" + this.completeDeliveryIsDefined + ", shippingType=" + this.shippingType + ", headerBillingBlockReason=" + this.headerBillingBlockReason + ", deliveryBlockReason=" + this.deliveryBlockReason + ", incotermsClassification=" + this.incotermsClassification + ", incotermsTransferLocation=" + this.incotermsTransferLocation + ", salesOrganization=" + this.salesOrganization + ", customerPaymentTerms=" + this.customerPaymentTerms + ", paymentMethod=" + this.paymentMethod + ", overallSDProcessStatus=" + this.overallSDProcessStatus + ", totalCreditCheckStatus=" + this.totalCreditCheckStatus + ", overallTotalDeliveryStatus=" + this.overallTotalDeliveryStatus + ", overallSDDocumentRejectionSts=" + this.overallSDDocumentRejectionSts + ", distributionChannel=" + this.distributionChannel + ", organizationDivision=" + this.organizationDivision + ", salesGroup=" + this.salesGroup + ", salesOffice=" + this.salesOffice + ", salesDistrict=" + this.salesDistrict + ", soldToParty=" + this.soldToParty + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SalesOrder)) {
                return false;
            }
            SalesOrder other = (SalesOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            Calendar this$creationDate = this.creationDate;
            Calendar other$creationDate = other.creationDate;
            if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
                return false;
            }
            String this$createdByUser = this.createdByUser;
            String other$createdByUser = other.createdByUser;
            if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
                return false;
            }
            Calendar this$lastChangeDate = this.lastChangeDate;
            Calendar other$lastChangeDate = other.lastChangeDate;
            if (this$lastChangeDate == null ? other$lastChangeDate != null : !((Object)this$lastChangeDate).equals(other$lastChangeDate)) {
                return false;
            }
            Calendar this$lastChangeDateTime = this.lastChangeDateTime;
            Calendar other$lastChangeDateTime = other.lastChangeDateTime;
            if (this$lastChangeDateTime == null ? other$lastChangeDateTime != null : !((Object)this$lastChangeDateTime).equals(other$lastChangeDateTime)) {
                return false;
            }
            String this$purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            String other$purchaseOrderByCustomer = other.purchaseOrderByCustomer;
            if (this$purchaseOrderByCustomer == null ? other$purchaseOrderByCustomer != null : !this$purchaseOrderByCustomer.equals(other$purchaseOrderByCustomer)) {
                return false;
            }
            String this$customerPurchaseOrderType = this.customerPurchaseOrderType;
            String other$customerPurchaseOrderType = other.customerPurchaseOrderType;
            if (this$customerPurchaseOrderType == null ? other$customerPurchaseOrderType != null : !this$customerPurchaseOrderType.equals(other$customerPurchaseOrderType)) {
                return false;
            }
            Calendar this$customerPurchaseOrderDate = this.customerPurchaseOrderDate;
            Calendar other$customerPurchaseOrderDate = other.customerPurchaseOrderDate;
            if (this$customerPurchaseOrderDate == null ? other$customerPurchaseOrderDate != null : !((Object)this$customerPurchaseOrderDate).equals(other$customerPurchaseOrderDate)) {
                return false;
            }
            Calendar this$salesOrderDate = this.salesOrderDate;
            Calendar other$salesOrderDate = other.salesOrderDate;
            if (this$salesOrderDate == null ? other$salesOrderDate != null : !((Object)this$salesOrderDate).equals(other$salesOrderDate)) {
                return false;
            }
            BigDecimal this$totalNetAmount = this.totalNetAmount;
            BigDecimal other$totalNetAmount = other.totalNetAmount;
            if (this$totalNetAmount == null ? other$totalNetAmount != null : !((Object)this$totalNetAmount).equals(other$totalNetAmount)) {
                return false;
            }
            String this$transactionCurrency = this.transactionCurrency;
            String other$transactionCurrency = other.transactionCurrency;
            if (this$transactionCurrency == null ? other$transactionCurrency != null : !this$transactionCurrency.equals(other$transactionCurrency)) {
                return false;
            }
            String this$salesOrderType = this.salesOrderType;
            String other$salesOrderType = other.salesOrderType;
            if (this$salesOrderType == null ? other$salesOrderType != null : !this$salesOrderType.equals(other$salesOrderType)) {
                return false;
            }
            String this$sDDocumentReason = this.sDDocumentReason;
            String other$sDDocumentReason = other.sDDocumentReason;
            if (this$sDDocumentReason == null ? other$sDDocumentReason != null : !this$sDDocumentReason.equals(other$sDDocumentReason)) {
                return false;
            }
            Calendar this$pricingDate = this.pricingDate;
            Calendar other$pricingDate = other.pricingDate;
            if (this$pricingDate == null ? other$pricingDate != null : !((Object)this$pricingDate).equals(other$pricingDate)) {
                return false;
            }
            Calendar this$requestedDeliveryDate = this.requestedDeliveryDate;
            Calendar other$requestedDeliveryDate = other.requestedDeliveryDate;
            if (this$requestedDeliveryDate == null ? other$requestedDeliveryDate != null : !((Object)this$requestedDeliveryDate).equals(other$requestedDeliveryDate)) {
                return false;
            }
            String this$shippingCondition = this.shippingCondition;
            String other$shippingCondition = other.shippingCondition;
            if (this$shippingCondition == null ? other$shippingCondition != null : !this$shippingCondition.equals(other$shippingCondition)) {
                return false;
            }
            Boolean this$completeDeliveryIsDefined = this.completeDeliveryIsDefined;
            Boolean other$completeDeliveryIsDefined = other.completeDeliveryIsDefined;
            if (this$completeDeliveryIsDefined == null ? other$completeDeliveryIsDefined != null : !((Object)this$completeDeliveryIsDefined).equals(other$completeDeliveryIsDefined)) {
                return false;
            }
            String this$shippingType = this.shippingType;
            String other$shippingType = other.shippingType;
            if (this$shippingType == null ? other$shippingType != null : !this$shippingType.equals(other$shippingType)) {
                return false;
            }
            String this$headerBillingBlockReason = this.headerBillingBlockReason;
            String other$headerBillingBlockReason = other.headerBillingBlockReason;
            if (this$headerBillingBlockReason == null ? other$headerBillingBlockReason != null : !this$headerBillingBlockReason.equals(other$headerBillingBlockReason)) {
                return false;
            }
            String this$deliveryBlockReason = this.deliveryBlockReason;
            String other$deliveryBlockReason = other.deliveryBlockReason;
            if (this$deliveryBlockReason == null ? other$deliveryBlockReason != null : !this$deliveryBlockReason.equals(other$deliveryBlockReason)) {
                return false;
            }
            String this$incotermsClassification = this.incotermsClassification;
            String other$incotermsClassification = other.incotermsClassification;
            if (this$incotermsClassification == null ? other$incotermsClassification != null : !this$incotermsClassification.equals(other$incotermsClassification)) {
                return false;
            }
            String this$incotermsTransferLocation = this.incotermsTransferLocation;
            String other$incotermsTransferLocation = other.incotermsTransferLocation;
            if (this$incotermsTransferLocation == null ? other$incotermsTransferLocation != null : !this$incotermsTransferLocation.equals(other$incotermsTransferLocation)) {
                return false;
            }
            String this$salesOrganization = this.salesOrganization;
            String other$salesOrganization = other.salesOrganization;
            if (this$salesOrganization == null ? other$salesOrganization != null : !this$salesOrganization.equals(other$salesOrganization)) {
                return false;
            }
            String this$customerPaymentTerms = this.customerPaymentTerms;
            String other$customerPaymentTerms = other.customerPaymentTerms;
            if (this$customerPaymentTerms == null ? other$customerPaymentTerms != null : !this$customerPaymentTerms.equals(other$customerPaymentTerms)) {
                return false;
            }
            String this$paymentMethod = this.paymentMethod;
            String other$paymentMethod = other.paymentMethod;
            if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
                return false;
            }
            String this$overallSDProcessStatus = this.overallSDProcessStatus;
            String other$overallSDProcessStatus = other.overallSDProcessStatus;
            if (this$overallSDProcessStatus == null ? other$overallSDProcessStatus != null : !this$overallSDProcessStatus.equals(other$overallSDProcessStatus)) {
                return false;
            }
            String this$totalCreditCheckStatus = this.totalCreditCheckStatus;
            String other$totalCreditCheckStatus = other.totalCreditCheckStatus;
            if (this$totalCreditCheckStatus == null ? other$totalCreditCheckStatus != null : !this$totalCreditCheckStatus.equals(other$totalCreditCheckStatus)) {
                return false;
            }
            String this$overallTotalDeliveryStatus = this.overallTotalDeliveryStatus;
            String other$overallTotalDeliveryStatus = other.overallTotalDeliveryStatus;
            if (this$overallTotalDeliveryStatus == null ? other$overallTotalDeliveryStatus != null : !this$overallTotalDeliveryStatus.equals(other$overallTotalDeliveryStatus)) {
                return false;
            }
            String this$overallSDDocumentRejectionSts = this.overallSDDocumentRejectionSts;
            String other$overallSDDocumentRejectionSts = other.overallSDDocumentRejectionSts;
            if (this$overallSDDocumentRejectionSts == null ? other$overallSDDocumentRejectionSts != null : !this$overallSDDocumentRejectionSts.equals(other$overallSDDocumentRejectionSts)) {
                return false;
            }
            String this$distributionChannel = this.distributionChannel;
            String other$distributionChannel = other.distributionChannel;
            if (this$distributionChannel == null ? other$distributionChannel != null : !this$distributionChannel.equals(other$distributionChannel)) {
                return false;
            }
            String this$organizationDivision = this.organizationDivision;
            String other$organizationDivision = other.organizationDivision;
            if (this$organizationDivision == null ? other$organizationDivision != null : !this$organizationDivision.equals(other$organizationDivision)) {
                return false;
            }
            String this$salesGroup = this.salesGroup;
            String other$salesGroup = other.salesGroup;
            if (this$salesGroup == null ? other$salesGroup != null : !this$salesGroup.equals(other$salesGroup)) {
                return false;
            }
            String this$salesOffice = this.salesOffice;
            String other$salesOffice = other.salesOffice;
            if (this$salesOffice == null ? other$salesOffice != null : !this$salesOffice.equals(other$salesOffice)) {
                return false;
            }
            String this$salesDistrict = this.salesDistrict;
            String other$salesDistrict = other.salesDistrict;
            if (this$salesDistrict == null ? other$salesDistrict != null : !this$salesDistrict.equals(other$salesDistrict)) {
                return false;
            }
            String this$soldToParty = this.soldToParty;
            String other$soldToParty = other.soldToParty;
            return !(this$soldToParty == null ? other$soldToParty != null : !this$soldToParty.equals(other$soldToParty));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SalesOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            Calendar $creationDate = this.creationDate;
            result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
            String $createdByUser = this.createdByUser;
            result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
            Calendar $lastChangeDate = this.lastChangeDate;
            result = result * 59 + ($lastChangeDate == null ? 43 : ((Object)$lastChangeDate).hashCode());
            Calendar $lastChangeDateTime = this.lastChangeDateTime;
            result = result * 59 + ($lastChangeDateTime == null ? 43 : ((Object)$lastChangeDateTime).hashCode());
            String $purchaseOrderByCustomer = this.purchaseOrderByCustomer;
            result = result * 59 + ($purchaseOrderByCustomer == null ? 43 : $purchaseOrderByCustomer.hashCode());
            String $customerPurchaseOrderType = this.customerPurchaseOrderType;
            result = result * 59 + ($customerPurchaseOrderType == null ? 43 : $customerPurchaseOrderType.hashCode());
            Calendar $customerPurchaseOrderDate = this.customerPurchaseOrderDate;
            result = result * 59 + ($customerPurchaseOrderDate == null ? 43 : ((Object)$customerPurchaseOrderDate).hashCode());
            Calendar $salesOrderDate = this.salesOrderDate;
            result = result * 59 + ($salesOrderDate == null ? 43 : ((Object)$salesOrderDate).hashCode());
            BigDecimal $totalNetAmount = this.totalNetAmount;
            result = result * 59 + ($totalNetAmount == null ? 43 : ((Object)$totalNetAmount).hashCode());
            String $transactionCurrency = this.transactionCurrency;
            result = result * 59 + ($transactionCurrency == null ? 43 : $transactionCurrency.hashCode());
            String $salesOrderType = this.salesOrderType;
            result = result * 59 + ($salesOrderType == null ? 43 : $salesOrderType.hashCode());
            String $sDDocumentReason = this.sDDocumentReason;
            result = result * 59 + ($sDDocumentReason == null ? 43 : $sDDocumentReason.hashCode());
            Calendar $pricingDate = this.pricingDate;
            result = result * 59 + ($pricingDate == null ? 43 : ((Object)$pricingDate).hashCode());
            Calendar $requestedDeliveryDate = this.requestedDeliveryDate;
            result = result * 59 + ($requestedDeliveryDate == null ? 43 : ((Object)$requestedDeliveryDate).hashCode());
            String $shippingCondition = this.shippingCondition;
            result = result * 59 + ($shippingCondition == null ? 43 : $shippingCondition.hashCode());
            Boolean $completeDeliveryIsDefined = this.completeDeliveryIsDefined;
            result = result * 59 + ($completeDeliveryIsDefined == null ? 43 : ((Object)$completeDeliveryIsDefined).hashCode());
            String $shippingType = this.shippingType;
            result = result * 59 + ($shippingType == null ? 43 : $shippingType.hashCode());
            String $headerBillingBlockReason = this.headerBillingBlockReason;
            result = result * 59 + ($headerBillingBlockReason == null ? 43 : $headerBillingBlockReason.hashCode());
            String $deliveryBlockReason = this.deliveryBlockReason;
            result = result * 59 + ($deliveryBlockReason == null ? 43 : $deliveryBlockReason.hashCode());
            String $incotermsClassification = this.incotermsClassification;
            result = result * 59 + ($incotermsClassification == null ? 43 : $incotermsClassification.hashCode());
            String $incotermsTransferLocation = this.incotermsTransferLocation;
            result = result * 59 + ($incotermsTransferLocation == null ? 43 : $incotermsTransferLocation.hashCode());
            String $salesOrganization = this.salesOrganization;
            result = result * 59 + ($salesOrganization == null ? 43 : $salesOrganization.hashCode());
            String $customerPaymentTerms = this.customerPaymentTerms;
            result = result * 59 + ($customerPaymentTerms == null ? 43 : $customerPaymentTerms.hashCode());
            String $paymentMethod = this.paymentMethod;
            result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
            String $overallSDProcessStatus = this.overallSDProcessStatus;
            result = result * 59 + ($overallSDProcessStatus == null ? 43 : $overallSDProcessStatus.hashCode());
            String $totalCreditCheckStatus = this.totalCreditCheckStatus;
            result = result * 59 + ($totalCreditCheckStatus == null ? 43 : $totalCreditCheckStatus.hashCode());
            String $overallTotalDeliveryStatus = this.overallTotalDeliveryStatus;
            result = result * 59 + ($overallTotalDeliveryStatus == null ? 43 : $overallTotalDeliveryStatus.hashCode());
            String $overallSDDocumentRejectionSts = this.overallSDDocumentRejectionSts;
            result = result * 59 + ($overallSDDocumentRejectionSts == null ? 43 : $overallSDDocumentRejectionSts.hashCode());
            String $distributionChannel = this.distributionChannel;
            result = result * 59 + ($distributionChannel == null ? 43 : $distributionChannel.hashCode());
            String $organizationDivision = this.organizationDivision;
            result = result * 59 + ($organizationDivision == null ? 43 : $organizationDivision.hashCode());
            String $salesGroup = this.salesGroup;
            result = result * 59 + ($salesGroup == null ? 43 : $salesGroup.hashCode());
            String $salesOffice = this.salesOffice;
            result = result * 59 + ($salesOffice == null ? 43 : $salesOffice.hashCode());
            String $salesDistrict = this.salesDistrict;
            result = result * 59 + ($salesDistrict == null ? 43 : $salesDistrict.hashCode());
            String $soldToParty = this.soldToParty;
            result = result * 59 + ($soldToParty == null ? 43 : $soldToParty.hashCode());
            return result;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public SalesOrder setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public Calendar getCreationDate() {
            return this.creationDate;
        }

        public SalesOrder setCreationDate(Calendar creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public String getCreatedByUser() {
            return this.createdByUser;
        }

        public SalesOrder setCreatedByUser(String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        public Calendar getLastChangeDate() {
            return this.lastChangeDate;
        }

        public SalesOrder setLastChangeDate(Calendar lastChangeDate) {
            this.lastChangeDate = lastChangeDate;
            return this;
        }

        public Calendar getLastChangeDateTime() {
            return this.lastChangeDateTime;
        }

        public SalesOrder setLastChangeDateTime(Calendar lastChangeDateTime) {
            this.lastChangeDateTime = lastChangeDateTime;
            return this;
        }

        public String getPurchaseOrderByCustomer() {
            return this.purchaseOrderByCustomer;
        }

        public SalesOrder setPurchaseOrderByCustomer(String purchaseOrderByCustomer) {
            this.purchaseOrderByCustomer = purchaseOrderByCustomer;
            return this;
        }

        public String getCustomerPurchaseOrderType() {
            return this.customerPurchaseOrderType;
        }

        public SalesOrder setCustomerPurchaseOrderType(String customerPurchaseOrderType) {
            this.customerPurchaseOrderType = customerPurchaseOrderType;
            return this;
        }

        public Calendar getCustomerPurchaseOrderDate() {
            return this.customerPurchaseOrderDate;
        }

        public SalesOrder setCustomerPurchaseOrderDate(Calendar customerPurchaseOrderDate) {
            this.customerPurchaseOrderDate = customerPurchaseOrderDate;
            return this;
        }

        public Calendar getSalesOrderDate() {
            return this.salesOrderDate;
        }

        public SalesOrder setSalesOrderDate(Calendar salesOrderDate) {
            this.salesOrderDate = salesOrderDate;
            return this;
        }

        public BigDecimal getTotalNetAmount() {
            return this.totalNetAmount;
        }

        public SalesOrder setTotalNetAmount(BigDecimal totalNetAmount) {
            this.totalNetAmount = totalNetAmount;
            return this;
        }

        public String getTransactionCurrency() {
            return this.transactionCurrency;
        }

        public SalesOrder setTransactionCurrency(String transactionCurrency) {
            this.transactionCurrency = transactionCurrency;
            return this;
        }

        public String getSalesOrderType() {
            return this.salesOrderType;
        }

        public SalesOrder setSalesOrderType(String salesOrderType) {
            this.salesOrderType = salesOrderType;
            return this;
        }

        public String getSDDocumentReason() {
            return this.sDDocumentReason;
        }

        public SalesOrder setSDDocumentReason(String sDDocumentReason) {
            this.sDDocumentReason = sDDocumentReason;
            return this;
        }

        public Calendar getPricingDate() {
            return this.pricingDate;
        }

        public SalesOrder setPricingDate(Calendar pricingDate) {
            this.pricingDate = pricingDate;
            return this;
        }

        public Calendar getRequestedDeliveryDate() {
            return this.requestedDeliveryDate;
        }

        public SalesOrder setRequestedDeliveryDate(Calendar requestedDeliveryDate) {
            this.requestedDeliveryDate = requestedDeliveryDate;
            return this;
        }

        public String getShippingCondition() {
            return this.shippingCondition;
        }

        public SalesOrder setShippingCondition(String shippingCondition) {
            this.shippingCondition = shippingCondition;
            return this;
        }

        public Boolean getCompleteDeliveryIsDefined() {
            return this.completeDeliveryIsDefined;
        }

        public SalesOrder setCompleteDeliveryIsDefined(Boolean completeDeliveryIsDefined) {
            this.completeDeliveryIsDefined = completeDeliveryIsDefined;
            return this;
        }

        public String getShippingType() {
            return this.shippingType;
        }

        public SalesOrder setShippingType(String shippingType) {
            this.shippingType = shippingType;
            return this;
        }

        public String getHeaderBillingBlockReason() {
            return this.headerBillingBlockReason;
        }

        public SalesOrder setHeaderBillingBlockReason(String headerBillingBlockReason) {
            this.headerBillingBlockReason = headerBillingBlockReason;
            return this;
        }

        public String getDeliveryBlockReason() {
            return this.deliveryBlockReason;
        }

        public SalesOrder setDeliveryBlockReason(String deliveryBlockReason) {
            this.deliveryBlockReason = deliveryBlockReason;
            return this;
        }

        public String getIncotermsClassification() {
            return this.incotermsClassification;
        }

        public SalesOrder setIncotermsClassification(String incotermsClassification) {
            this.incotermsClassification = incotermsClassification;
            return this;
        }

        public String getIncotermsTransferLocation() {
            return this.incotermsTransferLocation;
        }

        public SalesOrder setIncotermsTransferLocation(String incotermsTransferLocation) {
            this.incotermsTransferLocation = incotermsTransferLocation;
            return this;
        }

        public String getSalesOrganization() {
            return this.salesOrganization;
        }

        public SalesOrder setSalesOrganization(String salesOrganization) {
            this.salesOrganization = salesOrganization;
            return this;
        }

        public String getCustomerPaymentTerms() {
            return this.customerPaymentTerms;
        }

        public SalesOrder setCustomerPaymentTerms(String customerPaymentTerms) {
            this.customerPaymentTerms = customerPaymentTerms;
            return this;
        }

        public String getPaymentMethod() {
            return this.paymentMethod;
        }

        public SalesOrder setPaymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public String getOverallSDProcessStatus() {
            return this.overallSDProcessStatus;
        }

        public SalesOrder setOverallSDProcessStatus(String overallSDProcessStatus) {
            this.overallSDProcessStatus = overallSDProcessStatus;
            return this;
        }

        public String getTotalCreditCheckStatus() {
            return this.totalCreditCheckStatus;
        }

        public SalesOrder setTotalCreditCheckStatus(String totalCreditCheckStatus) {
            this.totalCreditCheckStatus = totalCreditCheckStatus;
            return this;
        }

        public String getOverallTotalDeliveryStatus() {
            return this.overallTotalDeliveryStatus;
        }

        public SalesOrder setOverallTotalDeliveryStatus(String overallTotalDeliveryStatus) {
            this.overallTotalDeliveryStatus = overallTotalDeliveryStatus;
            return this;
        }

        public String getOverallSDDocumentRejectionSts() {
            return this.overallSDDocumentRejectionSts;
        }

        public SalesOrder setOverallSDDocumentRejectionSts(String overallSDDocumentRejectionSts) {
            this.overallSDDocumentRejectionSts = overallSDDocumentRejectionSts;
            return this;
        }

        public String getDistributionChannel() {
            return this.distributionChannel;
        }

        public SalesOrder setDistributionChannel(String distributionChannel) {
            this.distributionChannel = distributionChannel;
            return this;
        }

        public String getOrganizationDivision() {
            return this.organizationDivision;
        }

        public SalesOrder setOrganizationDivision(String organizationDivision) {
            this.organizationDivision = organizationDivision;
            return this;
        }

        public String getSalesGroup() {
            return this.salesGroup;
        }

        public SalesOrder setSalesGroup(String salesGroup) {
            this.salesGroup = salesGroup;
            return this;
        }

        public String getSalesOffice() {
            return this.salesOffice;
        }

        public SalesOrder setSalesOffice(String salesOffice) {
            this.salesOffice = salesOffice;
            return this;
        }

        public String getSalesDistrict() {
            return this.salesDistrict;
        }

        public SalesOrder setSalesDistrict(String salesDistrict) {
            this.salesDistrict = salesDistrict;
            return this;
        }

        public String getSoldToParty() {
            return this.soldToParty;
        }

        public SalesOrder setSoldToParty(String soldToParty) {
            this.soldToParty = soldToParty;
            return this;
        }

        public SalesOrder setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }
}

