/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.FilterExpression;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryBuilder;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQueryResult;
import com.sap.cloud.sdk.odatav2.connectivity.ODataType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.EntityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ExpressionFluentHelper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FilterExpressionWrapper;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FunctionImportResponseParser;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataVdmErrorResultHandler;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.Order;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class ProcessPhysicalInventoryDocumentsNamespace {

    public static class PostDifferencesOnItemFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public PostDifferencesOnItemFluentHelper(String physicalInventoryDocumentItem, String material, String physicalInventoryDocument, String fiscalYear, String batch, String reasonForPhysInvtryDifference, Calendar postingDate) {
            this.values.add(physicalInventoryDocumentItem);
            this.values.add(material);
            this.values.add(physicalInventoryDocument);
            this.values.add(fiscalYear);
            this.values.add(batch);
            this.values.add(reasonForPhysInvtryDifference);
            this.values.add(postingDate);
        }

        public PhysInventoryDocItem execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpPost(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV/PostDifferencesOnItem?PhysicalInventoryDocumentItem=%s&Material=%s&PhysicalInventoryDocument=%s&FiscalYear=%s&Batch=%s&ReasonForPhysInvtryDifference=%s&PostingDate=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(3)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(4)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(5)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(6))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (PhysInventoryDocItem)FunctionImportResponseParser.getResultElementFromContent(content, "PostDifferencesOnItem").getAsObject().as(PhysInventoryDocItem.class);
        }
    }

    public static class PostDifferencesFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public PostDifferencesFluentHelper(BigDecimal postingThresholdValue, Calendar postingDate, String physicalInventoryDocument, String fiscalYear) {
            this.values.add(postingThresholdValue);
            this.values.add(postingDate);
            this.values.add(physicalInventoryDocument);
            this.values.add(fiscalYear);
        }

        public PhysInventoryDocHeader execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpPost(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV/PostDifferences?PostingThresholdValue=%s&PostingDate=%s&PhysicalInventoryDocument=%s&FiscalYear=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.Decimal).toUri((BigDecimal)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(3))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (PhysInventoryDocHeader)FunctionImportResponseParser.getResultElementFromContent(content, "PostDifferences").getAsObject().as(PhysInventoryDocHeader.class);
        }
    }

    public static class PhysInventoryDocItemFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV", (String)"A_PhysInventoryDocItem");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public PhysInventoryDocItemFluentHelper filter(ExpressionFluentHelper<PhysInventoryDocItem> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public PhysInventoryDocItemFluentHelper orderBy(EntityField<?, PhysInventoryDocItem> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final PhysInventoryDocItemFluentHelper select(EntityField<?, PhysInventoryDocItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public PhysInventoryDocItemFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public PhysInventoryDocItemFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public PhysInventoryDocItemFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<PhysInventoryDocItem> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(PhysInventoryDocItem.class);
            for (PhysInventoryDocItem entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class PhysInventoryDocItemByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public PhysInventoryDocItemByKeyFluentHelper(String fiscalYear, String physicalInventoryDocument, String physicalInventoryDocumentItem) {
            this.values.add(fiscalYear);
            this.values.add(physicalInventoryDocument);
            this.values.add(physicalInventoryDocumentItem);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV", (String)"A_PhysInventoryDocItem");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("FiscalYear", this.values.get(0));
            keys.put("PhysicalInventoryDocument", this.values.get(1));
            keys.put("PhysicalInventoryDocumentItem", this.values.get(2));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final PhysInventoryDocItemByKeyFluentHelper select(EntityField<?, PhysInventoryDocItem> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public PhysInventoryDocItemByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public PhysInventoryDocItem execute(ErpConfigContext erpConfigContext) throws ODataException {
            PhysInventoryDocItem entity = (PhysInventoryDocItem)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(PhysInventoryDocItem.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class PhysInventoryDocItem {
        @ElementName(value="FiscalYear")
        private String fiscalYear;
        public static EntityField<String, PhysInventoryDocItem> FISCAL_YEAR = new EntityField("FiscalYear");
        @ElementName(value="PhysicalInventoryDocument")
        private String physicalInventoryDocument;
        public static EntityField<String, PhysInventoryDocItem> PHYSICAL_INVENTORY_DOCUMENT = new EntityField("PhysicalInventoryDocument");
        @ElementName(value="PhysicalInventoryDocumentItem")
        private String physicalInventoryDocumentItem;
        public static EntityField<String, PhysInventoryDocItem> PHYSICAL_INVENTORY_DOCUMENT_ITEM = new EntityField("PhysicalInventoryDocumentItem");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, PhysInventoryDocItem> PLANT = new EntityField("Plant");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, PhysInventoryDocItem> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="Material")
        private String material;
        public static EntityField<String, PhysInventoryDocItem> MATERIAL = new EntityField("Material");
        @ElementName(value="Batch")
        private String batch;
        public static EntityField<String, PhysInventoryDocItem> BATCH = new EntityField("Batch");
        @ElementName(value="InventorySpecialStockType")
        private String inventorySpecialStockType;
        public static EntityField<String, PhysInventoryDocItem> INVENTORY_SPECIAL_STOCK_TYPE = new EntityField("InventorySpecialStockType");
        @ElementName(value="PhysicalInventoryStockType")
        private String physicalInventoryStockType;
        public static EntityField<String, PhysInventoryDocItem> PHYSICAL_INVENTORY_STOCK_TYPE = new EntityField("PhysicalInventoryStockType");
        @ElementName(value="SalesOrder")
        private String salesOrder;
        public static EntityField<String, PhysInventoryDocItem> SALES_ORDER = new EntityField("SalesOrder");
        @ElementName(value="SalesOrderItem")
        private String salesOrderItem;
        public static EntityField<String, PhysInventoryDocItem> SALES_ORDER_ITEM = new EntityField("SalesOrderItem");
        @ElementName(value="Supplier")
        private String supplier;
        public static EntityField<String, PhysInventoryDocItem> SUPPLIER = new EntityField("Supplier");
        @ElementName(value="Customer")
        private String customer;
        public static EntityField<String, PhysInventoryDocItem> CUSTOMER = new EntityField("Customer");
        @ElementName(value="WBSElement")
        private String wBSElement;
        public static EntityField<String, PhysInventoryDocItem> W_B_S_ELEMENT = new EntityField("WBSElement");
        @ElementName(value="LastChangeUser")
        private String lastChangeUser;
        public static EntityField<String, PhysInventoryDocItem> LAST_CHANGE_USER = new EntityField("LastChangeUser");
        @ElementName(value="LastChangeDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDate;
        public static EntityField<Calendar, PhysInventoryDocItem> LAST_CHANGE_DATE = new EntityField("LastChangeDate");
        @ElementName(value="CountedByUser")
        private String countedByUser;
        public static EntityField<String, PhysInventoryDocItem> COUNTED_BY_USER = new EntityField("CountedByUser");
        @ElementName(value="PhysicalInventoryLastCountDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar physicalInventoryLastCountDate;
        public static EntityField<Calendar, PhysInventoryDocItem> PHYSICAL_INVENTORY_LAST_COUNT_DATE = new EntityField("PhysicalInventoryLastCountDate");
        @ElementName(value="AdjustmentPostingMadeByUser")
        private String adjustmentPostingMadeByUser;
        public static EntityField<String, PhysInventoryDocItem> ADJUSTMENT_POSTING_MADE_BY_USER = new EntityField("AdjustmentPostingMadeByUser");
        @ElementName(value="PostingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar postingDate;
        public static EntityField<Calendar, PhysInventoryDocItem> POSTING_DATE = new EntityField("PostingDate");
        @ElementName(value="PhysicalInventoryItemIsCounted")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean physicalInventoryItemIsCounted;
        public static EntityField<Boolean, PhysInventoryDocItem> PHYSICAL_INVENTORY_ITEM_IS_COUNTED = new EntityField("PhysicalInventoryItemIsCounted");
        @ElementName(value="PhysInvtryDifferenceIsPosted")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean physInvtryDifferenceIsPosted;
        public static EntityField<Boolean, PhysInventoryDocItem> PHYS_INVTRY_DIFFERENCE_IS_POSTED = new EntityField("PhysInvtryDifferenceIsPosted");
        @ElementName(value="PhysInvtryItemIsRecounted")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean physInvtryItemIsRecounted;
        public static EntityField<Boolean, PhysInventoryDocItem> PHYS_INVTRY_ITEM_IS_RECOUNTED = new EntityField("PhysInvtryItemIsRecounted");
        @ElementName(value="PhysInvtryItemIsDeleted")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean physInvtryItemIsDeleted;
        public static EntityField<Boolean, PhysInventoryDocItem> PHYS_INVTRY_ITEM_IS_DELETED = new EntityField("PhysInvtryItemIsDeleted");
        @ElementName(value="IsHandledInAltvUnitOfMsr")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isHandledInAltvUnitOfMsr;
        public static EntityField<Boolean, PhysInventoryDocItem> IS_HANDLED_IN_ALTV_UNIT_OF_MSR = new EntityField("IsHandledInAltvUnitOfMsr");
        @ElementName(value="CycleCountType")
        private String cycleCountType;
        public static EntityField<String, PhysInventoryDocItem> CYCLE_COUNT_TYPE = new EntityField("CycleCountType");
        @ElementName(value="IsValueOnlyMaterial")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean isValueOnlyMaterial;
        public static EntityField<Boolean, PhysInventoryDocItem> IS_VALUE_ONLY_MATERIAL = new EntityField("IsValueOnlyMaterial");
        @ElementName(value="PhysInventoryReferenceNumber")
        private String physInventoryReferenceNumber;
        public static EntityField<String, PhysInventoryDocItem> PHYS_INVENTORY_REFERENCE_NUMBER = new EntityField("PhysInventoryReferenceNumber");
        @ElementName(value="MaterialDocument")
        private String materialDocument;
        public static EntityField<String, PhysInventoryDocItem> MATERIAL_DOCUMENT = new EntityField("MaterialDocument");
        @ElementName(value="MaterialDocumentYear")
        private String materialDocumentYear;
        public static EntityField<String, PhysInventoryDocItem> MATERIAL_DOCUMENT_YEAR = new EntityField("MaterialDocumentYear");
        @ElementName(value="MaterialDocumentItem")
        private String materialDocumentItem;
        public static EntityField<String, PhysInventoryDocItem> MATERIAL_DOCUMENT_ITEM = new EntityField("MaterialDocumentItem");
        @ElementName(value="PhysInvtryRecountDocument")
        private String physInvtryRecountDocument;
        public static EntityField<String, PhysInventoryDocItem> PHYS_INVTRY_RECOUNT_DOCUMENT = new EntityField("PhysInvtryRecountDocument");
        @ElementName(value="PhysicalInventoryItemIsZero")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean physicalInventoryItemIsZero;
        public static EntityField<Boolean, PhysInventoryDocItem> PHYSICAL_INVENTORY_ITEM_IS_ZERO = new EntityField("PhysicalInventoryItemIsZero");
        @ElementName(value="ReasonForPhysInvtryDifference")
        private String reasonForPhysInvtryDifference;
        public static EntityField<String, PhysInventoryDocItem> REASON_FOR_PHYS_INVTRY_DIFFERENCE = new EntityField("ReasonForPhysInvtryDifference");
        @ElementName(value="MaterialBaseUnit")
        private String materialBaseUnit;
        public static EntityField<String, PhysInventoryDocItem> MATERIAL_BASE_UNIT = new EntityField("MaterialBaseUnit");
        @ElementName(value="BookQtyBfrCountInMatlBaseUnit")
        private BigDecimal bookQtyBfrCountInMatlBaseUnit;
        public static EntityField<BigDecimal, PhysInventoryDocItem> BOOK_QTY_BFR_COUNT_IN_MATL_BASE_UNIT = new EntityField("BookQtyBfrCountInMatlBaseUnit");
        @ElementName(value="Quantity")
        private BigDecimal quantity;
        public static EntityField<BigDecimal, PhysInventoryDocItem> QUANTITY = new EntityField("Quantity");
        @ElementName(value="UnitOfEntry")
        private String unitOfEntry;
        public static EntityField<String, PhysInventoryDocItem> UNIT_OF_ENTRY = new EntityField("UnitOfEntry");
        @ElementName(value="QuantityInUnitOfEntry")
        private BigDecimal quantityInUnitOfEntry;
        public static EntityField<BigDecimal, PhysInventoryDocItem> QUANTITY_IN_UNIT_OF_ENTRY = new EntityField("QuantityInUnitOfEntry");
        @ElementName(value="Currency")
        private String currency;
        public static EntityField<String, PhysInventoryDocItem> CURRENCY = new EntityField("Currency");
        @ElementName(value="DifferenceAmountInCoCodeCrcy")
        private BigDecimal differenceAmountInCoCodeCrcy;
        public static EntityField<BigDecimal, PhysInventoryDocItem> DIFFERENCE_AMOUNT_IN_CO_CODE_CRCY = new EntityField("DifferenceAmountInCoCodeCrcy");
        @ElementName(value="EnteredSlsAmtInCoCodeCrcy")
        private BigDecimal enteredSlsAmtInCoCodeCrcy;
        public static EntityField<BigDecimal, PhysInventoryDocItem> ENTERED_SLS_AMT_IN_CO_CODE_CRCY = new EntityField("EnteredSlsAmtInCoCodeCrcy");
        @ElementName(value="SlsPriceAmountInCoCodeCrcy")
        private BigDecimal slsPriceAmountInCoCodeCrcy;
        public static EntityField<BigDecimal, PhysInventoryDocItem> SLS_PRICE_AMOUNT_IN_CO_CODE_CRCY = new EntityField("SlsPriceAmountInCoCodeCrcy");
        @ElementName(value="PhysInvtryCtAmtInCoCodeCrcy")
        private BigDecimal physInvtryCtAmtInCoCodeCrcy;
        public static EntityField<BigDecimal, PhysInventoryDocItem> PHYS_INVTRY_CT_AMT_IN_CO_CODE_CRCY = new EntityField("PhysInvtryCtAmtInCoCodeCrcy");
        @ElementName(value="BookQtyAmountInCoCodeCrcy")
        private BigDecimal bookQtyAmountInCoCodeCrcy;
        public static EntityField<BigDecimal, PhysInventoryDocItem> BOOK_QTY_AMOUNT_IN_CO_CODE_CRCY = new EntityField("BookQtyAmountInCoCodeCrcy");
        @ElementName(value="LastChangeDateTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDateTime;
        public static EntityField<Calendar, PhysInventoryDocItem> LAST_CHANGE_DATE_TIME = new EntityField("LastChangeDateTime");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_PhysInventoryDocItem";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public PhysInventoryDocHeader fetchPhysicalInventoryDocument() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("FiscalYear=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.fiscalYear));
            odataResourceUrl.append(",PhysicalInventoryDocument=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.physicalInventoryDocument));
            odataResourceUrl.append(",PhysicalInventoryDocumentItem=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.physicalInventoryDocumentItem));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PhysicalInventoryDocument");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            PhysInventoryDocHeader entityList = (PhysInventoryDocHeader)result.as(PhysInventoryDocHeader.class);
            entityList.setErpConfigContext(this.erpConfigContext);
            return entityList;
        }

        public String toString() {
            return "ProcessPhysicalInventoryDocumentsNamespace.PhysInventoryDocItem(fiscalYear=" + this.fiscalYear + ", physicalInventoryDocument=" + this.physicalInventoryDocument + ", physicalInventoryDocumentItem=" + this.physicalInventoryDocumentItem + ", plant=" + this.plant + ", storageLocation=" + this.storageLocation + ", material=" + this.material + ", batch=" + this.batch + ", inventorySpecialStockType=" + this.inventorySpecialStockType + ", physicalInventoryStockType=" + this.physicalInventoryStockType + ", salesOrder=" + this.salesOrder + ", salesOrderItem=" + this.salesOrderItem + ", supplier=" + this.supplier + ", customer=" + this.customer + ", wBSElement=" + this.wBSElement + ", lastChangeUser=" + this.lastChangeUser + ", lastChangeDate=" + this.lastChangeDate + ", countedByUser=" + this.countedByUser + ", physicalInventoryLastCountDate=" + this.physicalInventoryLastCountDate + ", adjustmentPostingMadeByUser=" + this.adjustmentPostingMadeByUser + ", postingDate=" + this.postingDate + ", physicalInventoryItemIsCounted=" + this.physicalInventoryItemIsCounted + ", physInvtryDifferenceIsPosted=" + this.physInvtryDifferenceIsPosted + ", physInvtryItemIsRecounted=" + this.physInvtryItemIsRecounted + ", physInvtryItemIsDeleted=" + this.physInvtryItemIsDeleted + ", isHandledInAltvUnitOfMsr=" + this.isHandledInAltvUnitOfMsr + ", cycleCountType=" + this.cycleCountType + ", isValueOnlyMaterial=" + this.isValueOnlyMaterial + ", physInventoryReferenceNumber=" + this.physInventoryReferenceNumber + ", materialDocument=" + this.materialDocument + ", materialDocumentYear=" + this.materialDocumentYear + ", materialDocumentItem=" + this.materialDocumentItem + ", physInvtryRecountDocument=" + this.physInvtryRecountDocument + ", physicalInventoryItemIsZero=" + this.physicalInventoryItemIsZero + ", reasonForPhysInvtryDifference=" + this.reasonForPhysInvtryDifference + ", materialBaseUnit=" + this.materialBaseUnit + ", bookQtyBfrCountInMatlBaseUnit=" + this.bookQtyBfrCountInMatlBaseUnit + ", quantity=" + this.quantity + ", unitOfEntry=" + this.unitOfEntry + ", quantityInUnitOfEntry=" + this.quantityInUnitOfEntry + ", currency=" + this.currency + ", differenceAmountInCoCodeCrcy=" + this.differenceAmountInCoCodeCrcy + ", enteredSlsAmtInCoCodeCrcy=" + this.enteredSlsAmtInCoCodeCrcy + ", slsPriceAmountInCoCodeCrcy=" + this.slsPriceAmountInCoCodeCrcy + ", physInvtryCtAmtInCoCodeCrcy=" + this.physInvtryCtAmtInCoCodeCrcy + ", bookQtyAmountInCoCodeCrcy=" + this.bookQtyAmountInCoCodeCrcy + ", lastChangeDateTime=" + this.lastChangeDateTime + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhysInventoryDocItem)) {
                return false;
            }
            PhysInventoryDocItem other = (PhysInventoryDocItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fiscalYear = this.fiscalYear;
            String other$fiscalYear = other.fiscalYear;
            if (this$fiscalYear == null ? other$fiscalYear != null : !this$fiscalYear.equals(other$fiscalYear)) {
                return false;
            }
            String this$physicalInventoryDocument = this.physicalInventoryDocument;
            String other$physicalInventoryDocument = other.physicalInventoryDocument;
            if (this$physicalInventoryDocument == null ? other$physicalInventoryDocument != null : !this$physicalInventoryDocument.equals(other$physicalInventoryDocument)) {
                return false;
            }
            String this$physicalInventoryDocumentItem = this.physicalInventoryDocumentItem;
            String other$physicalInventoryDocumentItem = other.physicalInventoryDocumentItem;
            if (this$physicalInventoryDocumentItem == null ? other$physicalInventoryDocumentItem != null : !this$physicalInventoryDocumentItem.equals(other$physicalInventoryDocumentItem)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$material = this.material;
            String other$material = other.material;
            if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                return false;
            }
            String this$batch = this.batch;
            String other$batch = other.batch;
            if (this$batch == null ? other$batch != null : !this$batch.equals(other$batch)) {
                return false;
            }
            String this$inventorySpecialStockType = this.inventorySpecialStockType;
            String other$inventorySpecialStockType = other.inventorySpecialStockType;
            if (this$inventorySpecialStockType == null ? other$inventorySpecialStockType != null : !this$inventorySpecialStockType.equals(other$inventorySpecialStockType)) {
                return false;
            }
            String this$physicalInventoryStockType = this.physicalInventoryStockType;
            String other$physicalInventoryStockType = other.physicalInventoryStockType;
            if (this$physicalInventoryStockType == null ? other$physicalInventoryStockType != null : !this$physicalInventoryStockType.equals(other$physicalInventoryStockType)) {
                return false;
            }
            String this$salesOrder = this.salesOrder;
            String other$salesOrder = other.salesOrder;
            if (this$salesOrder == null ? other$salesOrder != null : !this$salesOrder.equals(other$salesOrder)) {
                return false;
            }
            String this$salesOrderItem = this.salesOrderItem;
            String other$salesOrderItem = other.salesOrderItem;
            if (this$salesOrderItem == null ? other$salesOrderItem != null : !this$salesOrderItem.equals(other$salesOrderItem)) {
                return false;
            }
            String this$supplier = this.supplier;
            String other$supplier = other.supplier;
            if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
                return false;
            }
            String this$customer = this.customer;
            String other$customer = other.customer;
            if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                return false;
            }
            String this$wBSElement = this.wBSElement;
            String other$wBSElement = other.wBSElement;
            if (this$wBSElement == null ? other$wBSElement != null : !this$wBSElement.equals(other$wBSElement)) {
                return false;
            }
            String this$lastChangeUser = this.lastChangeUser;
            String other$lastChangeUser = other.lastChangeUser;
            if (this$lastChangeUser == null ? other$lastChangeUser != null : !this$lastChangeUser.equals(other$lastChangeUser)) {
                return false;
            }
            Calendar this$lastChangeDate = this.lastChangeDate;
            Calendar other$lastChangeDate = other.lastChangeDate;
            if (this$lastChangeDate == null ? other$lastChangeDate != null : !((Object)this$lastChangeDate).equals(other$lastChangeDate)) {
                return false;
            }
            String this$countedByUser = this.countedByUser;
            String other$countedByUser = other.countedByUser;
            if (this$countedByUser == null ? other$countedByUser != null : !this$countedByUser.equals(other$countedByUser)) {
                return false;
            }
            Calendar this$physicalInventoryLastCountDate = this.physicalInventoryLastCountDate;
            Calendar other$physicalInventoryLastCountDate = other.physicalInventoryLastCountDate;
            if (this$physicalInventoryLastCountDate == null ? other$physicalInventoryLastCountDate != null : !((Object)this$physicalInventoryLastCountDate).equals(other$physicalInventoryLastCountDate)) {
                return false;
            }
            String this$adjustmentPostingMadeByUser = this.adjustmentPostingMadeByUser;
            String other$adjustmentPostingMadeByUser = other.adjustmentPostingMadeByUser;
            if (this$adjustmentPostingMadeByUser == null ? other$adjustmentPostingMadeByUser != null : !this$adjustmentPostingMadeByUser.equals(other$adjustmentPostingMadeByUser)) {
                return false;
            }
            Calendar this$postingDate = this.postingDate;
            Calendar other$postingDate = other.postingDate;
            if (this$postingDate == null ? other$postingDate != null : !((Object)this$postingDate).equals(other$postingDate)) {
                return false;
            }
            Boolean this$physicalInventoryItemIsCounted = this.physicalInventoryItemIsCounted;
            Boolean other$physicalInventoryItemIsCounted = other.physicalInventoryItemIsCounted;
            if (this$physicalInventoryItemIsCounted == null ? other$physicalInventoryItemIsCounted != null : !((Object)this$physicalInventoryItemIsCounted).equals(other$physicalInventoryItemIsCounted)) {
                return false;
            }
            Boolean this$physInvtryDifferenceIsPosted = this.physInvtryDifferenceIsPosted;
            Boolean other$physInvtryDifferenceIsPosted = other.physInvtryDifferenceIsPosted;
            if (this$physInvtryDifferenceIsPosted == null ? other$physInvtryDifferenceIsPosted != null : !((Object)this$physInvtryDifferenceIsPosted).equals(other$physInvtryDifferenceIsPosted)) {
                return false;
            }
            Boolean this$physInvtryItemIsRecounted = this.physInvtryItemIsRecounted;
            Boolean other$physInvtryItemIsRecounted = other.physInvtryItemIsRecounted;
            if (this$physInvtryItemIsRecounted == null ? other$physInvtryItemIsRecounted != null : !((Object)this$physInvtryItemIsRecounted).equals(other$physInvtryItemIsRecounted)) {
                return false;
            }
            Boolean this$physInvtryItemIsDeleted = this.physInvtryItemIsDeleted;
            Boolean other$physInvtryItemIsDeleted = other.physInvtryItemIsDeleted;
            if (this$physInvtryItemIsDeleted == null ? other$physInvtryItemIsDeleted != null : !((Object)this$physInvtryItemIsDeleted).equals(other$physInvtryItemIsDeleted)) {
                return false;
            }
            Boolean this$isHandledInAltvUnitOfMsr = this.isHandledInAltvUnitOfMsr;
            Boolean other$isHandledInAltvUnitOfMsr = other.isHandledInAltvUnitOfMsr;
            if (this$isHandledInAltvUnitOfMsr == null ? other$isHandledInAltvUnitOfMsr != null : !((Object)this$isHandledInAltvUnitOfMsr).equals(other$isHandledInAltvUnitOfMsr)) {
                return false;
            }
            String this$cycleCountType = this.cycleCountType;
            String other$cycleCountType = other.cycleCountType;
            if (this$cycleCountType == null ? other$cycleCountType != null : !this$cycleCountType.equals(other$cycleCountType)) {
                return false;
            }
            Boolean this$isValueOnlyMaterial = this.isValueOnlyMaterial;
            Boolean other$isValueOnlyMaterial = other.isValueOnlyMaterial;
            if (this$isValueOnlyMaterial == null ? other$isValueOnlyMaterial != null : !((Object)this$isValueOnlyMaterial).equals(other$isValueOnlyMaterial)) {
                return false;
            }
            String this$physInventoryReferenceNumber = this.physInventoryReferenceNumber;
            String other$physInventoryReferenceNumber = other.physInventoryReferenceNumber;
            if (this$physInventoryReferenceNumber == null ? other$physInventoryReferenceNumber != null : !this$physInventoryReferenceNumber.equals(other$physInventoryReferenceNumber)) {
                return false;
            }
            String this$materialDocument = this.materialDocument;
            String other$materialDocument = other.materialDocument;
            if (this$materialDocument == null ? other$materialDocument != null : !this$materialDocument.equals(other$materialDocument)) {
                return false;
            }
            String this$materialDocumentYear = this.materialDocumentYear;
            String other$materialDocumentYear = other.materialDocumentYear;
            if (this$materialDocumentYear == null ? other$materialDocumentYear != null : !this$materialDocumentYear.equals(other$materialDocumentYear)) {
                return false;
            }
            String this$materialDocumentItem = this.materialDocumentItem;
            String other$materialDocumentItem = other.materialDocumentItem;
            if (this$materialDocumentItem == null ? other$materialDocumentItem != null : !this$materialDocumentItem.equals(other$materialDocumentItem)) {
                return false;
            }
            String this$physInvtryRecountDocument = this.physInvtryRecountDocument;
            String other$physInvtryRecountDocument = other.physInvtryRecountDocument;
            if (this$physInvtryRecountDocument == null ? other$physInvtryRecountDocument != null : !this$physInvtryRecountDocument.equals(other$physInvtryRecountDocument)) {
                return false;
            }
            Boolean this$physicalInventoryItemIsZero = this.physicalInventoryItemIsZero;
            Boolean other$physicalInventoryItemIsZero = other.physicalInventoryItemIsZero;
            if (this$physicalInventoryItemIsZero == null ? other$physicalInventoryItemIsZero != null : !((Object)this$physicalInventoryItemIsZero).equals(other$physicalInventoryItemIsZero)) {
                return false;
            }
            String this$reasonForPhysInvtryDifference = this.reasonForPhysInvtryDifference;
            String other$reasonForPhysInvtryDifference = other.reasonForPhysInvtryDifference;
            if (this$reasonForPhysInvtryDifference == null ? other$reasonForPhysInvtryDifference != null : !this$reasonForPhysInvtryDifference.equals(other$reasonForPhysInvtryDifference)) {
                return false;
            }
            String this$materialBaseUnit = this.materialBaseUnit;
            String other$materialBaseUnit = other.materialBaseUnit;
            if (this$materialBaseUnit == null ? other$materialBaseUnit != null : !this$materialBaseUnit.equals(other$materialBaseUnit)) {
                return false;
            }
            BigDecimal this$bookQtyBfrCountInMatlBaseUnit = this.bookQtyBfrCountInMatlBaseUnit;
            BigDecimal other$bookQtyBfrCountInMatlBaseUnit = other.bookQtyBfrCountInMatlBaseUnit;
            if (this$bookQtyBfrCountInMatlBaseUnit == null ? other$bookQtyBfrCountInMatlBaseUnit != null : !((Object)this$bookQtyBfrCountInMatlBaseUnit).equals(other$bookQtyBfrCountInMatlBaseUnit)) {
                return false;
            }
            BigDecimal this$quantity = this.quantity;
            BigDecimal other$quantity = other.quantity;
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            String this$unitOfEntry = this.unitOfEntry;
            String other$unitOfEntry = other.unitOfEntry;
            if (this$unitOfEntry == null ? other$unitOfEntry != null : !this$unitOfEntry.equals(other$unitOfEntry)) {
                return false;
            }
            BigDecimal this$quantityInUnitOfEntry = this.quantityInUnitOfEntry;
            BigDecimal other$quantityInUnitOfEntry = other.quantityInUnitOfEntry;
            if (this$quantityInUnitOfEntry == null ? other$quantityInUnitOfEntry != null : !((Object)this$quantityInUnitOfEntry).equals(other$quantityInUnitOfEntry)) {
                return false;
            }
            String this$currency = this.currency;
            String other$currency = other.currency;
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            BigDecimal this$differenceAmountInCoCodeCrcy = this.differenceAmountInCoCodeCrcy;
            BigDecimal other$differenceAmountInCoCodeCrcy = other.differenceAmountInCoCodeCrcy;
            if (this$differenceAmountInCoCodeCrcy == null ? other$differenceAmountInCoCodeCrcy != null : !((Object)this$differenceAmountInCoCodeCrcy).equals(other$differenceAmountInCoCodeCrcy)) {
                return false;
            }
            BigDecimal this$enteredSlsAmtInCoCodeCrcy = this.enteredSlsAmtInCoCodeCrcy;
            BigDecimal other$enteredSlsAmtInCoCodeCrcy = other.enteredSlsAmtInCoCodeCrcy;
            if (this$enteredSlsAmtInCoCodeCrcy == null ? other$enteredSlsAmtInCoCodeCrcy != null : !((Object)this$enteredSlsAmtInCoCodeCrcy).equals(other$enteredSlsAmtInCoCodeCrcy)) {
                return false;
            }
            BigDecimal this$slsPriceAmountInCoCodeCrcy = this.slsPriceAmountInCoCodeCrcy;
            BigDecimal other$slsPriceAmountInCoCodeCrcy = other.slsPriceAmountInCoCodeCrcy;
            if (this$slsPriceAmountInCoCodeCrcy == null ? other$slsPriceAmountInCoCodeCrcy != null : !((Object)this$slsPriceAmountInCoCodeCrcy).equals(other$slsPriceAmountInCoCodeCrcy)) {
                return false;
            }
            BigDecimal this$physInvtryCtAmtInCoCodeCrcy = this.physInvtryCtAmtInCoCodeCrcy;
            BigDecimal other$physInvtryCtAmtInCoCodeCrcy = other.physInvtryCtAmtInCoCodeCrcy;
            if (this$physInvtryCtAmtInCoCodeCrcy == null ? other$physInvtryCtAmtInCoCodeCrcy != null : !((Object)this$physInvtryCtAmtInCoCodeCrcy).equals(other$physInvtryCtAmtInCoCodeCrcy)) {
                return false;
            }
            BigDecimal this$bookQtyAmountInCoCodeCrcy = this.bookQtyAmountInCoCodeCrcy;
            BigDecimal other$bookQtyAmountInCoCodeCrcy = other.bookQtyAmountInCoCodeCrcy;
            if (this$bookQtyAmountInCoCodeCrcy == null ? other$bookQtyAmountInCoCodeCrcy != null : !((Object)this$bookQtyAmountInCoCodeCrcy).equals(other$bookQtyAmountInCoCodeCrcy)) {
                return false;
            }
            Calendar this$lastChangeDateTime = this.lastChangeDateTime;
            Calendar other$lastChangeDateTime = other.lastChangeDateTime;
            return !(this$lastChangeDateTime == null ? other$lastChangeDateTime != null : !((Object)this$lastChangeDateTime).equals(other$lastChangeDateTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PhysInventoryDocItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fiscalYear = this.fiscalYear;
            result = result * 59 + ($fiscalYear == null ? 43 : $fiscalYear.hashCode());
            String $physicalInventoryDocument = this.physicalInventoryDocument;
            result = result * 59 + ($physicalInventoryDocument == null ? 43 : $physicalInventoryDocument.hashCode());
            String $physicalInventoryDocumentItem = this.physicalInventoryDocumentItem;
            result = result * 59 + ($physicalInventoryDocumentItem == null ? 43 : $physicalInventoryDocumentItem.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $material = this.material;
            result = result * 59 + ($material == null ? 43 : $material.hashCode());
            String $batch = this.batch;
            result = result * 59 + ($batch == null ? 43 : $batch.hashCode());
            String $inventorySpecialStockType = this.inventorySpecialStockType;
            result = result * 59 + ($inventorySpecialStockType == null ? 43 : $inventorySpecialStockType.hashCode());
            String $physicalInventoryStockType = this.physicalInventoryStockType;
            result = result * 59 + ($physicalInventoryStockType == null ? 43 : $physicalInventoryStockType.hashCode());
            String $salesOrder = this.salesOrder;
            result = result * 59 + ($salesOrder == null ? 43 : $salesOrder.hashCode());
            String $salesOrderItem = this.salesOrderItem;
            result = result * 59 + ($salesOrderItem == null ? 43 : $salesOrderItem.hashCode());
            String $supplier = this.supplier;
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            String $customer = this.customer;
            result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
            String $wBSElement = this.wBSElement;
            result = result * 59 + ($wBSElement == null ? 43 : $wBSElement.hashCode());
            String $lastChangeUser = this.lastChangeUser;
            result = result * 59 + ($lastChangeUser == null ? 43 : $lastChangeUser.hashCode());
            Calendar $lastChangeDate = this.lastChangeDate;
            result = result * 59 + ($lastChangeDate == null ? 43 : ((Object)$lastChangeDate).hashCode());
            String $countedByUser = this.countedByUser;
            result = result * 59 + ($countedByUser == null ? 43 : $countedByUser.hashCode());
            Calendar $physicalInventoryLastCountDate = this.physicalInventoryLastCountDate;
            result = result * 59 + ($physicalInventoryLastCountDate == null ? 43 : ((Object)$physicalInventoryLastCountDate).hashCode());
            String $adjustmentPostingMadeByUser = this.adjustmentPostingMadeByUser;
            result = result * 59 + ($adjustmentPostingMadeByUser == null ? 43 : $adjustmentPostingMadeByUser.hashCode());
            Calendar $postingDate = this.postingDate;
            result = result * 59 + ($postingDate == null ? 43 : ((Object)$postingDate).hashCode());
            Boolean $physicalInventoryItemIsCounted = this.physicalInventoryItemIsCounted;
            result = result * 59 + ($physicalInventoryItemIsCounted == null ? 43 : ((Object)$physicalInventoryItemIsCounted).hashCode());
            Boolean $physInvtryDifferenceIsPosted = this.physInvtryDifferenceIsPosted;
            result = result * 59 + ($physInvtryDifferenceIsPosted == null ? 43 : ((Object)$physInvtryDifferenceIsPosted).hashCode());
            Boolean $physInvtryItemIsRecounted = this.physInvtryItemIsRecounted;
            result = result * 59 + ($physInvtryItemIsRecounted == null ? 43 : ((Object)$physInvtryItemIsRecounted).hashCode());
            Boolean $physInvtryItemIsDeleted = this.physInvtryItemIsDeleted;
            result = result * 59 + ($physInvtryItemIsDeleted == null ? 43 : ((Object)$physInvtryItemIsDeleted).hashCode());
            Boolean $isHandledInAltvUnitOfMsr = this.isHandledInAltvUnitOfMsr;
            result = result * 59 + ($isHandledInAltvUnitOfMsr == null ? 43 : ((Object)$isHandledInAltvUnitOfMsr).hashCode());
            String $cycleCountType = this.cycleCountType;
            result = result * 59 + ($cycleCountType == null ? 43 : $cycleCountType.hashCode());
            Boolean $isValueOnlyMaterial = this.isValueOnlyMaterial;
            result = result * 59 + ($isValueOnlyMaterial == null ? 43 : ((Object)$isValueOnlyMaterial).hashCode());
            String $physInventoryReferenceNumber = this.physInventoryReferenceNumber;
            result = result * 59 + ($physInventoryReferenceNumber == null ? 43 : $physInventoryReferenceNumber.hashCode());
            String $materialDocument = this.materialDocument;
            result = result * 59 + ($materialDocument == null ? 43 : $materialDocument.hashCode());
            String $materialDocumentYear = this.materialDocumentYear;
            result = result * 59 + ($materialDocumentYear == null ? 43 : $materialDocumentYear.hashCode());
            String $materialDocumentItem = this.materialDocumentItem;
            result = result * 59 + ($materialDocumentItem == null ? 43 : $materialDocumentItem.hashCode());
            String $physInvtryRecountDocument = this.physInvtryRecountDocument;
            result = result * 59 + ($physInvtryRecountDocument == null ? 43 : $physInvtryRecountDocument.hashCode());
            Boolean $physicalInventoryItemIsZero = this.physicalInventoryItemIsZero;
            result = result * 59 + ($physicalInventoryItemIsZero == null ? 43 : ((Object)$physicalInventoryItemIsZero).hashCode());
            String $reasonForPhysInvtryDifference = this.reasonForPhysInvtryDifference;
            result = result * 59 + ($reasonForPhysInvtryDifference == null ? 43 : $reasonForPhysInvtryDifference.hashCode());
            String $materialBaseUnit = this.materialBaseUnit;
            result = result * 59 + ($materialBaseUnit == null ? 43 : $materialBaseUnit.hashCode());
            BigDecimal $bookQtyBfrCountInMatlBaseUnit = this.bookQtyBfrCountInMatlBaseUnit;
            result = result * 59 + ($bookQtyBfrCountInMatlBaseUnit == null ? 43 : ((Object)$bookQtyBfrCountInMatlBaseUnit).hashCode());
            BigDecimal $quantity = this.quantity;
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            String $unitOfEntry = this.unitOfEntry;
            result = result * 59 + ($unitOfEntry == null ? 43 : $unitOfEntry.hashCode());
            BigDecimal $quantityInUnitOfEntry = this.quantityInUnitOfEntry;
            result = result * 59 + ($quantityInUnitOfEntry == null ? 43 : ((Object)$quantityInUnitOfEntry).hashCode());
            String $currency = this.currency;
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            BigDecimal $differenceAmountInCoCodeCrcy = this.differenceAmountInCoCodeCrcy;
            result = result * 59 + ($differenceAmountInCoCodeCrcy == null ? 43 : ((Object)$differenceAmountInCoCodeCrcy).hashCode());
            BigDecimal $enteredSlsAmtInCoCodeCrcy = this.enteredSlsAmtInCoCodeCrcy;
            result = result * 59 + ($enteredSlsAmtInCoCodeCrcy == null ? 43 : ((Object)$enteredSlsAmtInCoCodeCrcy).hashCode());
            BigDecimal $slsPriceAmountInCoCodeCrcy = this.slsPriceAmountInCoCodeCrcy;
            result = result * 59 + ($slsPriceAmountInCoCodeCrcy == null ? 43 : ((Object)$slsPriceAmountInCoCodeCrcy).hashCode());
            BigDecimal $physInvtryCtAmtInCoCodeCrcy = this.physInvtryCtAmtInCoCodeCrcy;
            result = result * 59 + ($physInvtryCtAmtInCoCodeCrcy == null ? 43 : ((Object)$physInvtryCtAmtInCoCodeCrcy).hashCode());
            BigDecimal $bookQtyAmountInCoCodeCrcy = this.bookQtyAmountInCoCodeCrcy;
            result = result * 59 + ($bookQtyAmountInCoCodeCrcy == null ? 43 : ((Object)$bookQtyAmountInCoCodeCrcy).hashCode());
            Calendar $lastChangeDateTime = this.lastChangeDateTime;
            result = result * 59 + ($lastChangeDateTime == null ? 43 : ((Object)$lastChangeDateTime).hashCode());
            return result;
        }

        public String getFiscalYear() {
            return this.fiscalYear;
        }

        public PhysInventoryDocItem setFiscalYear(String fiscalYear) {
            this.fiscalYear = fiscalYear;
            return this;
        }

        public String getPhysicalInventoryDocument() {
            return this.physicalInventoryDocument;
        }

        public PhysInventoryDocItem setPhysicalInventoryDocument(String physicalInventoryDocument) {
            this.physicalInventoryDocument = physicalInventoryDocument;
            return this;
        }

        public String getPhysicalInventoryDocumentItem() {
            return this.physicalInventoryDocumentItem;
        }

        public PhysInventoryDocItem setPhysicalInventoryDocumentItem(String physicalInventoryDocumentItem) {
            this.physicalInventoryDocumentItem = physicalInventoryDocumentItem;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public PhysInventoryDocItem setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public PhysInventoryDocItem setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getMaterial() {
            return this.material;
        }

        public PhysInventoryDocItem setMaterial(String material) {
            this.material = material;
            return this;
        }

        public String getBatch() {
            return this.batch;
        }

        public PhysInventoryDocItem setBatch(String batch) {
            this.batch = batch;
            return this;
        }

        public String getInventorySpecialStockType() {
            return this.inventorySpecialStockType;
        }

        public PhysInventoryDocItem setInventorySpecialStockType(String inventorySpecialStockType) {
            this.inventorySpecialStockType = inventorySpecialStockType;
            return this;
        }

        public String getPhysicalInventoryStockType() {
            return this.physicalInventoryStockType;
        }

        public PhysInventoryDocItem setPhysicalInventoryStockType(String physicalInventoryStockType) {
            this.physicalInventoryStockType = physicalInventoryStockType;
            return this;
        }

        public String getSalesOrder() {
            return this.salesOrder;
        }

        public PhysInventoryDocItem setSalesOrder(String salesOrder) {
            this.salesOrder = salesOrder;
            return this;
        }

        public String getSalesOrderItem() {
            return this.salesOrderItem;
        }

        public PhysInventoryDocItem setSalesOrderItem(String salesOrderItem) {
            this.salesOrderItem = salesOrderItem;
            return this;
        }

        public String getSupplier() {
            return this.supplier;
        }

        public PhysInventoryDocItem setSupplier(String supplier) {
            this.supplier = supplier;
            return this;
        }

        public String getCustomer() {
            return this.customer;
        }

        public PhysInventoryDocItem setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public String getWBSElement() {
            return this.wBSElement;
        }

        public PhysInventoryDocItem setWBSElement(String wBSElement) {
            this.wBSElement = wBSElement;
            return this;
        }

        public String getLastChangeUser() {
            return this.lastChangeUser;
        }

        public PhysInventoryDocItem setLastChangeUser(String lastChangeUser) {
            this.lastChangeUser = lastChangeUser;
            return this;
        }

        public Calendar getLastChangeDate() {
            return this.lastChangeDate;
        }

        public PhysInventoryDocItem setLastChangeDate(Calendar lastChangeDate) {
            this.lastChangeDate = lastChangeDate;
            return this;
        }

        public String getCountedByUser() {
            return this.countedByUser;
        }

        public PhysInventoryDocItem setCountedByUser(String countedByUser) {
            this.countedByUser = countedByUser;
            return this;
        }

        public Calendar getPhysicalInventoryLastCountDate() {
            return this.physicalInventoryLastCountDate;
        }

        public PhysInventoryDocItem setPhysicalInventoryLastCountDate(Calendar physicalInventoryLastCountDate) {
            this.physicalInventoryLastCountDate = physicalInventoryLastCountDate;
            return this;
        }

        public String getAdjustmentPostingMadeByUser() {
            return this.adjustmentPostingMadeByUser;
        }

        public PhysInventoryDocItem setAdjustmentPostingMadeByUser(String adjustmentPostingMadeByUser) {
            this.adjustmentPostingMadeByUser = adjustmentPostingMadeByUser;
            return this;
        }

        public Calendar getPostingDate() {
            return this.postingDate;
        }

        public PhysInventoryDocItem setPostingDate(Calendar postingDate) {
            this.postingDate = postingDate;
            return this;
        }

        public Boolean getPhysicalInventoryItemIsCounted() {
            return this.physicalInventoryItemIsCounted;
        }

        public PhysInventoryDocItem setPhysicalInventoryItemIsCounted(Boolean physicalInventoryItemIsCounted) {
            this.physicalInventoryItemIsCounted = physicalInventoryItemIsCounted;
            return this;
        }

        public Boolean getPhysInvtryDifferenceIsPosted() {
            return this.physInvtryDifferenceIsPosted;
        }

        public PhysInventoryDocItem setPhysInvtryDifferenceIsPosted(Boolean physInvtryDifferenceIsPosted) {
            this.physInvtryDifferenceIsPosted = physInvtryDifferenceIsPosted;
            return this;
        }

        public Boolean getPhysInvtryItemIsRecounted() {
            return this.physInvtryItemIsRecounted;
        }

        public PhysInventoryDocItem setPhysInvtryItemIsRecounted(Boolean physInvtryItemIsRecounted) {
            this.physInvtryItemIsRecounted = physInvtryItemIsRecounted;
            return this;
        }

        public Boolean getPhysInvtryItemIsDeleted() {
            return this.physInvtryItemIsDeleted;
        }

        public PhysInventoryDocItem setPhysInvtryItemIsDeleted(Boolean physInvtryItemIsDeleted) {
            this.physInvtryItemIsDeleted = physInvtryItemIsDeleted;
            return this;
        }

        public Boolean getIsHandledInAltvUnitOfMsr() {
            return this.isHandledInAltvUnitOfMsr;
        }

        public PhysInventoryDocItem setIsHandledInAltvUnitOfMsr(Boolean isHandledInAltvUnitOfMsr) {
            this.isHandledInAltvUnitOfMsr = isHandledInAltvUnitOfMsr;
            return this;
        }

        public String getCycleCountType() {
            return this.cycleCountType;
        }

        public PhysInventoryDocItem setCycleCountType(String cycleCountType) {
            this.cycleCountType = cycleCountType;
            return this;
        }

        public Boolean getIsValueOnlyMaterial() {
            return this.isValueOnlyMaterial;
        }

        public PhysInventoryDocItem setIsValueOnlyMaterial(Boolean isValueOnlyMaterial) {
            this.isValueOnlyMaterial = isValueOnlyMaterial;
            return this;
        }

        public String getPhysInventoryReferenceNumber() {
            return this.physInventoryReferenceNumber;
        }

        public PhysInventoryDocItem setPhysInventoryReferenceNumber(String physInventoryReferenceNumber) {
            this.physInventoryReferenceNumber = physInventoryReferenceNumber;
            return this;
        }

        public String getMaterialDocument() {
            return this.materialDocument;
        }

        public PhysInventoryDocItem setMaterialDocument(String materialDocument) {
            this.materialDocument = materialDocument;
            return this;
        }

        public String getMaterialDocumentYear() {
            return this.materialDocumentYear;
        }

        public PhysInventoryDocItem setMaterialDocumentYear(String materialDocumentYear) {
            this.materialDocumentYear = materialDocumentYear;
            return this;
        }

        public String getMaterialDocumentItem() {
            return this.materialDocumentItem;
        }

        public PhysInventoryDocItem setMaterialDocumentItem(String materialDocumentItem) {
            this.materialDocumentItem = materialDocumentItem;
            return this;
        }

        public String getPhysInvtryRecountDocument() {
            return this.physInvtryRecountDocument;
        }

        public PhysInventoryDocItem setPhysInvtryRecountDocument(String physInvtryRecountDocument) {
            this.physInvtryRecountDocument = physInvtryRecountDocument;
            return this;
        }

        public Boolean getPhysicalInventoryItemIsZero() {
            return this.physicalInventoryItemIsZero;
        }

        public PhysInventoryDocItem setPhysicalInventoryItemIsZero(Boolean physicalInventoryItemIsZero) {
            this.physicalInventoryItemIsZero = physicalInventoryItemIsZero;
            return this;
        }

        public String getReasonForPhysInvtryDifference() {
            return this.reasonForPhysInvtryDifference;
        }

        public PhysInventoryDocItem setReasonForPhysInvtryDifference(String reasonForPhysInvtryDifference) {
            this.reasonForPhysInvtryDifference = reasonForPhysInvtryDifference;
            return this;
        }

        public String getMaterialBaseUnit() {
            return this.materialBaseUnit;
        }

        public PhysInventoryDocItem setMaterialBaseUnit(String materialBaseUnit) {
            this.materialBaseUnit = materialBaseUnit;
            return this;
        }

        public BigDecimal getBookQtyBfrCountInMatlBaseUnit() {
            return this.bookQtyBfrCountInMatlBaseUnit;
        }

        public PhysInventoryDocItem setBookQtyBfrCountInMatlBaseUnit(BigDecimal bookQtyBfrCountInMatlBaseUnit) {
            this.bookQtyBfrCountInMatlBaseUnit = bookQtyBfrCountInMatlBaseUnit;
            return this;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public PhysInventoryDocItem setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
            return this;
        }

        public String getUnitOfEntry() {
            return this.unitOfEntry;
        }

        public PhysInventoryDocItem setUnitOfEntry(String unitOfEntry) {
            this.unitOfEntry = unitOfEntry;
            return this;
        }

        public BigDecimal getQuantityInUnitOfEntry() {
            return this.quantityInUnitOfEntry;
        }

        public PhysInventoryDocItem setQuantityInUnitOfEntry(BigDecimal quantityInUnitOfEntry) {
            this.quantityInUnitOfEntry = quantityInUnitOfEntry;
            return this;
        }

        public String getCurrency() {
            return this.currency;
        }

        public PhysInventoryDocItem setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public BigDecimal getDifferenceAmountInCoCodeCrcy() {
            return this.differenceAmountInCoCodeCrcy;
        }

        public PhysInventoryDocItem setDifferenceAmountInCoCodeCrcy(BigDecimal differenceAmountInCoCodeCrcy) {
            this.differenceAmountInCoCodeCrcy = differenceAmountInCoCodeCrcy;
            return this;
        }

        public BigDecimal getEnteredSlsAmtInCoCodeCrcy() {
            return this.enteredSlsAmtInCoCodeCrcy;
        }

        public PhysInventoryDocItem setEnteredSlsAmtInCoCodeCrcy(BigDecimal enteredSlsAmtInCoCodeCrcy) {
            this.enteredSlsAmtInCoCodeCrcy = enteredSlsAmtInCoCodeCrcy;
            return this;
        }

        public BigDecimal getSlsPriceAmountInCoCodeCrcy() {
            return this.slsPriceAmountInCoCodeCrcy;
        }

        public PhysInventoryDocItem setSlsPriceAmountInCoCodeCrcy(BigDecimal slsPriceAmountInCoCodeCrcy) {
            this.slsPriceAmountInCoCodeCrcy = slsPriceAmountInCoCodeCrcy;
            return this;
        }

        public BigDecimal getPhysInvtryCtAmtInCoCodeCrcy() {
            return this.physInvtryCtAmtInCoCodeCrcy;
        }

        public PhysInventoryDocItem setPhysInvtryCtAmtInCoCodeCrcy(BigDecimal physInvtryCtAmtInCoCodeCrcy) {
            this.physInvtryCtAmtInCoCodeCrcy = physInvtryCtAmtInCoCodeCrcy;
            return this;
        }

        public BigDecimal getBookQtyAmountInCoCodeCrcy() {
            return this.bookQtyAmountInCoCodeCrcy;
        }

        public PhysInventoryDocItem setBookQtyAmountInCoCodeCrcy(BigDecimal bookQtyAmountInCoCodeCrcy) {
            this.bookQtyAmountInCoCodeCrcy = bookQtyAmountInCoCodeCrcy;
            return this;
        }

        public Calendar getLastChangeDateTime() {
            return this.lastChangeDateTime;
        }

        public PhysInventoryDocItem setLastChangeDateTime(Calendar lastChangeDateTime) {
            this.lastChangeDateTime = lastChangeDateTime;
            return this;
        }

        public PhysInventoryDocItem setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class PhysInventoryDocHeaderFluentHelper {
        private ODataQueryBuilder queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV", (String)"A_PhysInventoryDocHeader");
        private ErrorResultHandler<?> errorResultHandler = new ODataVdmErrorResultHandler();

        public PhysInventoryDocHeaderFluentHelper filter(ExpressionFluentHelper<PhysInventoryDocHeader> expression) {
            for (FilterExpressionWrapper<?> filterExpressionWrapper : expression.evaluate()) {
                Object comparisonValue = filterExpressionWrapper.getComparisonValue();
                if (comparisonValue instanceof Integer) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Integer)((Integer)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof String) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((String)((String)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Long) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Long)((Long)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Double) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Double)((Double)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Float) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Float)((Float)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDate) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDate)((LocalDate)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof LocalDateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((LocalDateTime)((LocalDateTime)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof Date) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((Date)((Date)comparisonValue))));
                    continue;
                }
                if (comparisonValue instanceof DateTime) {
                    this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of((DateTime)((DateTime)comparisonValue))));
                    continue;
                }
                this.queryBuilder.filter(new FilterExpression(filterExpressionWrapper.getFieldName(), filterExpressionWrapper.getOperator().getFunction(), ODataType.of(comparisonValue)));
            }
            return this;
        }

        public PhysInventoryDocHeaderFluentHelper orderBy(EntityField<?, PhysInventoryDocHeader> field, Order order) {
            String orderingDirection = order == Order.ASC ? " asc" : " desc";
            this.queryBuilder.param("orderby", (Object)(field.getFieldName() + orderingDirection));
            return this;
        }

        @SafeVarargs
        public final PhysInventoryDocHeaderFluentHelper select(EntityField<?, PhysInventoryDocHeader> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public PhysInventoryDocHeaderFluentHelper top(Number top) {
            this.queryBuilder.top(top);
            return this;
        }

        public PhysInventoryDocHeaderFluentHelper skip(Number skip) {
            this.queryBuilder.skip(skip);
            return this;
        }

        public PhysInventoryDocHeaderFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.errorHandler(this.errorResultHandler).build();
        }

        public List<PhysInventoryDocHeader> execute(ErpConfigContext erpConfigContext) throws ODataException {
            List entityList = this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).asList(PhysInventoryDocHeader.class);
            for (PhysInventoryDocHeader entity : entityList) {
                entity.setErpConfigContext(erpConfigContext);
            }
            return entityList;
        }
    }

    public static class PhysInventoryDocHeaderByKeyFluentHelper {
        private ODataQueryBuilder queryBuilder;
        private ErrorResultHandler<?> errorResultHandler;
        private List<Object> values = new LinkedList<Object>();

        public PhysInventoryDocHeaderByKeyFluentHelper(String fiscalYear, String physicalInventoryDocument) {
            this.values.add(fiscalYear);
            this.values.add(physicalInventoryDocument);
            this.queryBuilder = ODataQueryBuilder.withEntity((String)"/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV", (String)"A_PhysInventoryDocHeader");
            HashMap<String, Object> keys = new HashMap<String, Object>();
            keys.put("FiscalYear", this.values.get(0));
            keys.put("PhysicalInventoryDocument", this.values.get(1));
            this.queryBuilder.keys(keys);
        }

        @SafeVarargs
        public final PhysInventoryDocHeaderByKeyFluentHelper select(EntityField<?, PhysInventoryDocHeader> ... fields) {
            String[] strings = new String[fields.length];
            Integer i = 0;
            while (i < fields.length) {
                strings[i.intValue()] = fields[i].getFieldName();
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.queryBuilder.select(strings);
            return this;
        }

        public ODataQuery toQuery() {
            return this.queryBuilder.build();
        }

        public PhysInventoryDocHeaderByKeyFluentHelper withErrorHandler(ErrorResultHandler<?> errorResultHandler) {
            this.errorResultHandler = errorResultHandler;
            return this;
        }

        public PhysInventoryDocHeader execute(ErpConfigContext erpConfigContext) throws ODataException {
            PhysInventoryDocHeader entity = (PhysInventoryDocHeader)this.toQuery().execute((WithDestinationName)new ErpEndpoint(erpConfigContext)).as(PhysInventoryDocHeader.class);
            entity.setErpConfigContext(erpConfigContext);
            return entity;
        }
    }

    public static class PhysInventoryDocHeader {
        @ElementName(value="FiscalYear")
        private String fiscalYear;
        public static EntityField<String, PhysInventoryDocHeader> FISCAL_YEAR = new EntityField("FiscalYear");
        @ElementName(value="PhysicalInventoryDocument")
        private String physicalInventoryDocument;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_DOCUMENT = new EntityField("PhysicalInventoryDocument");
        @ElementName(value="InventoryTransactionType")
        private String inventoryTransactionType;
        public static EntityField<String, PhysInventoryDocHeader> INVENTORY_TRANSACTION_TYPE = new EntityField("InventoryTransactionType");
        @ElementName(value="Plant")
        private String plant;
        public static EntityField<String, PhysInventoryDocHeader> PLANT = new EntityField("Plant");
        @ElementName(value="StorageLocation")
        private String storageLocation;
        public static EntityField<String, PhysInventoryDocHeader> STORAGE_LOCATION = new EntityField("StorageLocation");
        @ElementName(value="InventorySpecialStockType")
        private String inventorySpecialStockType;
        public static EntityField<String, PhysInventoryDocHeader> INVENTORY_SPECIAL_STOCK_TYPE = new EntityField("InventorySpecialStockType");
        @ElementName(value="DocumentDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar documentDate;
        public static EntityField<Calendar, PhysInventoryDocHeader> DOCUMENT_DATE = new EntityField("DocumentDate");
        @ElementName(value="PhysInventoryPlannedCountDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar physInventoryPlannedCountDate;
        public static EntityField<Calendar, PhysInventoryDocHeader> PHYS_INVENTORY_PLANNED_COUNT_DATE = new EntityField("PhysInventoryPlannedCountDate");
        @ElementName(value="PhysicalInventoryLastCountDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar physicalInventoryLastCountDate;
        public static EntityField<Calendar, PhysInventoryDocHeader> PHYSICAL_INVENTORY_LAST_COUNT_DATE = new EntityField("PhysicalInventoryLastCountDate");
        @ElementName(value="PostingDate")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar postingDate;
        public static EntityField<Calendar, PhysInventoryDocHeader> POSTING_DATE = new EntityField("PostingDate");
        @ElementName(value="FiscalPeriod")
        private String fiscalPeriod;
        public static EntityField<String, PhysInventoryDocHeader> FISCAL_PERIOD = new EntityField("FiscalPeriod");
        @ElementName(value="CreatedByUser")
        private String createdByUser;
        public static EntityField<String, PhysInventoryDocHeader> CREATED_BY_USER = new EntityField("CreatedByUser");
        @ElementName(value="PostingIsBlockedForPhysInvtry")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean postingIsBlockedForPhysInvtry;
        public static EntityField<Boolean, PhysInventoryDocHeader> POSTING_IS_BLOCKED_FOR_PHYS_INVTRY = new EntityField("PostingIsBlockedForPhysInvtry");
        @ElementName(value="PhysicalInventoryCountStatus")
        private String physicalInventoryCountStatus;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_COUNT_STATUS = new EntityField("PhysicalInventoryCountStatus");
        @ElementName(value="PhysInvtryAdjustmentPostingSts")
        private String physInvtryAdjustmentPostingSts;
        public static EntityField<String, PhysInventoryDocHeader> PHYS_INVTRY_ADJUSTMENT_POSTING_STS = new EntityField("PhysInvtryAdjustmentPostingSts");
        @ElementName(value="PhysInvtryDeletionStatus")
        private String physInvtryDeletionStatus;
        public static EntityField<String, PhysInventoryDocHeader> PHYS_INVTRY_DELETION_STATUS = new EntityField("PhysInvtryDeletionStatus");
        @ElementName(value="PhysInvtryDocHasQtySnapshot")
        @JsonAdapter(value=ODataBooleanAdapter.class)
        private Boolean physInvtryDocHasQtySnapshot;
        public static EntityField<Boolean, PhysInventoryDocHeader> PHYS_INVTRY_DOC_HAS_QTY_SNAPSHOT = new EntityField("PhysInvtryDocHasQtySnapshot");
        @ElementName(value="PhysicalInventoryGroupType")
        private String physicalInventoryGroupType;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_GROUP_TYPE = new EntityField("PhysicalInventoryGroupType");
        @ElementName(value="PhysicalInventoryGroup")
        private String physicalInventoryGroup;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_GROUP = new EntityField("PhysicalInventoryGroup");
        @ElementName(value="PhysicalInventoryNumber")
        private String physicalInventoryNumber;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_NUMBER = new EntityField("PhysicalInventoryNumber");
        @ElementName(value="PhysInventoryReferenceNumber")
        private String physInventoryReferenceNumber;
        public static EntityField<String, PhysInventoryDocHeader> PHYS_INVENTORY_REFERENCE_NUMBER = new EntityField("PhysInventoryReferenceNumber");
        @ElementName(value="PhysicalInventoryDocumentDesc")
        private String physicalInventoryDocumentDesc;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_DOCUMENT_DESC = new EntityField("PhysicalInventoryDocumentDesc");
        @ElementName(value="PhysicalInventoryType")
        private String physicalInventoryType;
        public static EntityField<String, PhysInventoryDocHeader> PHYSICAL_INVENTORY_TYPE = new EntityField("PhysicalInventoryType");
        @ElementName(value="LastChangeDateTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar lastChangeDateTime;
        public static EntityField<Calendar, PhysInventoryDocHeader> LAST_CHANGE_DATE_TIME = new EntityField("LastChangeDateTime");
        private static final transient String ODATA_ENDPOINT_URL = "/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV";
        private static final transient String ODATA_ENTITY_COLLECTION = "A_PhysInventoryDocHeader";
        private transient ErpConfigContext erpConfigContext;

        @JsonIgnore
        public List<PhysInventoryDocItem> fetchPhysicalInventoryDocumentItem() throws ODataException {
            StringBuilder odataResourceUrl = new StringBuilder(ODATA_ENTITY_COLLECTION);
            odataResourceUrl.append("(");
            odataResourceUrl.append("FiscalYear=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.fiscalYear));
            odataResourceUrl.append(",PhysicalInventoryDocument=");
            odataResourceUrl.append(ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri(this.physicalInventoryDocument));
            odataResourceUrl.append(")/");
            odataResourceUrl.append("to_PhysicalInventoryDocumentItem");
            ODataQueryBuilder builder = ODataQueryBuilder.withEntity((String)ODATA_ENDPOINT_URL, (String)odataResourceUrl.toString());
            ODataQuery query = builder.build();
            ErpEndpoint erpEndpoint = new ErpEndpoint(this.erpConfigContext);
            ODataQueryResult result = query.execute((WithDestinationName)erpEndpoint);
            List entityList = result.asList(PhysInventoryDocItem.class);
            for (PhysInventoryDocItem entity : entityList) {
                entity.setErpConfigContext(this.erpConfigContext);
            }
            return entityList;
        }

        public String toString() {
            return "ProcessPhysicalInventoryDocumentsNamespace.PhysInventoryDocHeader(fiscalYear=" + this.fiscalYear + ", physicalInventoryDocument=" + this.physicalInventoryDocument + ", inventoryTransactionType=" + this.inventoryTransactionType + ", plant=" + this.plant + ", storageLocation=" + this.storageLocation + ", inventorySpecialStockType=" + this.inventorySpecialStockType + ", documentDate=" + this.documentDate + ", physInventoryPlannedCountDate=" + this.physInventoryPlannedCountDate + ", physicalInventoryLastCountDate=" + this.physicalInventoryLastCountDate + ", postingDate=" + this.postingDate + ", fiscalPeriod=" + this.fiscalPeriod + ", createdByUser=" + this.createdByUser + ", postingIsBlockedForPhysInvtry=" + this.postingIsBlockedForPhysInvtry + ", physicalInventoryCountStatus=" + this.physicalInventoryCountStatus + ", physInvtryAdjustmentPostingSts=" + this.physInvtryAdjustmentPostingSts + ", physInvtryDeletionStatus=" + this.physInvtryDeletionStatus + ", physInvtryDocHasQtySnapshot=" + this.physInvtryDocHasQtySnapshot + ", physicalInventoryGroupType=" + this.physicalInventoryGroupType + ", physicalInventoryGroup=" + this.physicalInventoryGroup + ", physicalInventoryNumber=" + this.physicalInventoryNumber + ", physInventoryReferenceNumber=" + this.physInventoryReferenceNumber + ", physicalInventoryDocumentDesc=" + this.physicalInventoryDocumentDesc + ", physicalInventoryType=" + this.physicalInventoryType + ", lastChangeDateTime=" + this.lastChangeDateTime + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PhysInventoryDocHeader)) {
                return false;
            }
            PhysInventoryDocHeader other = (PhysInventoryDocHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fiscalYear = this.fiscalYear;
            String other$fiscalYear = other.fiscalYear;
            if (this$fiscalYear == null ? other$fiscalYear != null : !this$fiscalYear.equals(other$fiscalYear)) {
                return false;
            }
            String this$physicalInventoryDocument = this.physicalInventoryDocument;
            String other$physicalInventoryDocument = other.physicalInventoryDocument;
            if (this$physicalInventoryDocument == null ? other$physicalInventoryDocument != null : !this$physicalInventoryDocument.equals(other$physicalInventoryDocument)) {
                return false;
            }
            String this$inventoryTransactionType = this.inventoryTransactionType;
            String other$inventoryTransactionType = other.inventoryTransactionType;
            if (this$inventoryTransactionType == null ? other$inventoryTransactionType != null : !this$inventoryTransactionType.equals(other$inventoryTransactionType)) {
                return false;
            }
            String this$plant = this.plant;
            String other$plant = other.plant;
            if (this$plant == null ? other$plant != null : !this$plant.equals(other$plant)) {
                return false;
            }
            String this$storageLocation = this.storageLocation;
            String other$storageLocation = other.storageLocation;
            if (this$storageLocation == null ? other$storageLocation != null : !this$storageLocation.equals(other$storageLocation)) {
                return false;
            }
            String this$inventorySpecialStockType = this.inventorySpecialStockType;
            String other$inventorySpecialStockType = other.inventorySpecialStockType;
            if (this$inventorySpecialStockType == null ? other$inventorySpecialStockType != null : !this$inventorySpecialStockType.equals(other$inventorySpecialStockType)) {
                return false;
            }
            Calendar this$documentDate = this.documentDate;
            Calendar other$documentDate = other.documentDate;
            if (this$documentDate == null ? other$documentDate != null : !((Object)this$documentDate).equals(other$documentDate)) {
                return false;
            }
            Calendar this$physInventoryPlannedCountDate = this.physInventoryPlannedCountDate;
            Calendar other$physInventoryPlannedCountDate = other.physInventoryPlannedCountDate;
            if (this$physInventoryPlannedCountDate == null ? other$physInventoryPlannedCountDate != null : !((Object)this$physInventoryPlannedCountDate).equals(other$physInventoryPlannedCountDate)) {
                return false;
            }
            Calendar this$physicalInventoryLastCountDate = this.physicalInventoryLastCountDate;
            Calendar other$physicalInventoryLastCountDate = other.physicalInventoryLastCountDate;
            if (this$physicalInventoryLastCountDate == null ? other$physicalInventoryLastCountDate != null : !((Object)this$physicalInventoryLastCountDate).equals(other$physicalInventoryLastCountDate)) {
                return false;
            }
            Calendar this$postingDate = this.postingDate;
            Calendar other$postingDate = other.postingDate;
            if (this$postingDate == null ? other$postingDate != null : !((Object)this$postingDate).equals(other$postingDate)) {
                return false;
            }
            String this$fiscalPeriod = this.fiscalPeriod;
            String other$fiscalPeriod = other.fiscalPeriod;
            if (this$fiscalPeriod == null ? other$fiscalPeriod != null : !this$fiscalPeriod.equals(other$fiscalPeriod)) {
                return false;
            }
            String this$createdByUser = this.createdByUser;
            String other$createdByUser = other.createdByUser;
            if (this$createdByUser == null ? other$createdByUser != null : !this$createdByUser.equals(other$createdByUser)) {
                return false;
            }
            Boolean this$postingIsBlockedForPhysInvtry = this.postingIsBlockedForPhysInvtry;
            Boolean other$postingIsBlockedForPhysInvtry = other.postingIsBlockedForPhysInvtry;
            if (this$postingIsBlockedForPhysInvtry == null ? other$postingIsBlockedForPhysInvtry != null : !((Object)this$postingIsBlockedForPhysInvtry).equals(other$postingIsBlockedForPhysInvtry)) {
                return false;
            }
            String this$physicalInventoryCountStatus = this.physicalInventoryCountStatus;
            String other$physicalInventoryCountStatus = other.physicalInventoryCountStatus;
            if (this$physicalInventoryCountStatus == null ? other$physicalInventoryCountStatus != null : !this$physicalInventoryCountStatus.equals(other$physicalInventoryCountStatus)) {
                return false;
            }
            String this$physInvtryAdjustmentPostingSts = this.physInvtryAdjustmentPostingSts;
            String other$physInvtryAdjustmentPostingSts = other.physInvtryAdjustmentPostingSts;
            if (this$physInvtryAdjustmentPostingSts == null ? other$physInvtryAdjustmentPostingSts != null : !this$physInvtryAdjustmentPostingSts.equals(other$physInvtryAdjustmentPostingSts)) {
                return false;
            }
            String this$physInvtryDeletionStatus = this.physInvtryDeletionStatus;
            String other$physInvtryDeletionStatus = other.physInvtryDeletionStatus;
            if (this$physInvtryDeletionStatus == null ? other$physInvtryDeletionStatus != null : !this$physInvtryDeletionStatus.equals(other$physInvtryDeletionStatus)) {
                return false;
            }
            Boolean this$physInvtryDocHasQtySnapshot = this.physInvtryDocHasQtySnapshot;
            Boolean other$physInvtryDocHasQtySnapshot = other.physInvtryDocHasQtySnapshot;
            if (this$physInvtryDocHasQtySnapshot == null ? other$physInvtryDocHasQtySnapshot != null : !((Object)this$physInvtryDocHasQtySnapshot).equals(other$physInvtryDocHasQtySnapshot)) {
                return false;
            }
            String this$physicalInventoryGroupType = this.physicalInventoryGroupType;
            String other$physicalInventoryGroupType = other.physicalInventoryGroupType;
            if (this$physicalInventoryGroupType == null ? other$physicalInventoryGroupType != null : !this$physicalInventoryGroupType.equals(other$physicalInventoryGroupType)) {
                return false;
            }
            String this$physicalInventoryGroup = this.physicalInventoryGroup;
            String other$physicalInventoryGroup = other.physicalInventoryGroup;
            if (this$physicalInventoryGroup == null ? other$physicalInventoryGroup != null : !this$physicalInventoryGroup.equals(other$physicalInventoryGroup)) {
                return false;
            }
            String this$physicalInventoryNumber = this.physicalInventoryNumber;
            String other$physicalInventoryNumber = other.physicalInventoryNumber;
            if (this$physicalInventoryNumber == null ? other$physicalInventoryNumber != null : !this$physicalInventoryNumber.equals(other$physicalInventoryNumber)) {
                return false;
            }
            String this$physInventoryReferenceNumber = this.physInventoryReferenceNumber;
            String other$physInventoryReferenceNumber = other.physInventoryReferenceNumber;
            if (this$physInventoryReferenceNumber == null ? other$physInventoryReferenceNumber != null : !this$physInventoryReferenceNumber.equals(other$physInventoryReferenceNumber)) {
                return false;
            }
            String this$physicalInventoryDocumentDesc = this.physicalInventoryDocumentDesc;
            String other$physicalInventoryDocumentDesc = other.physicalInventoryDocumentDesc;
            if (this$physicalInventoryDocumentDesc == null ? other$physicalInventoryDocumentDesc != null : !this$physicalInventoryDocumentDesc.equals(other$physicalInventoryDocumentDesc)) {
                return false;
            }
            String this$physicalInventoryType = this.physicalInventoryType;
            String other$physicalInventoryType = other.physicalInventoryType;
            if (this$physicalInventoryType == null ? other$physicalInventoryType != null : !this$physicalInventoryType.equals(other$physicalInventoryType)) {
                return false;
            }
            Calendar this$lastChangeDateTime = this.lastChangeDateTime;
            Calendar other$lastChangeDateTime = other.lastChangeDateTime;
            return !(this$lastChangeDateTime == null ? other$lastChangeDateTime != null : !((Object)this$lastChangeDateTime).equals(other$lastChangeDateTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PhysInventoryDocHeader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fiscalYear = this.fiscalYear;
            result = result * 59 + ($fiscalYear == null ? 43 : $fiscalYear.hashCode());
            String $physicalInventoryDocument = this.physicalInventoryDocument;
            result = result * 59 + ($physicalInventoryDocument == null ? 43 : $physicalInventoryDocument.hashCode());
            String $inventoryTransactionType = this.inventoryTransactionType;
            result = result * 59 + ($inventoryTransactionType == null ? 43 : $inventoryTransactionType.hashCode());
            String $plant = this.plant;
            result = result * 59 + ($plant == null ? 43 : $plant.hashCode());
            String $storageLocation = this.storageLocation;
            result = result * 59 + ($storageLocation == null ? 43 : $storageLocation.hashCode());
            String $inventorySpecialStockType = this.inventorySpecialStockType;
            result = result * 59 + ($inventorySpecialStockType == null ? 43 : $inventorySpecialStockType.hashCode());
            Calendar $documentDate = this.documentDate;
            result = result * 59 + ($documentDate == null ? 43 : ((Object)$documentDate).hashCode());
            Calendar $physInventoryPlannedCountDate = this.physInventoryPlannedCountDate;
            result = result * 59 + ($physInventoryPlannedCountDate == null ? 43 : ((Object)$physInventoryPlannedCountDate).hashCode());
            Calendar $physicalInventoryLastCountDate = this.physicalInventoryLastCountDate;
            result = result * 59 + ($physicalInventoryLastCountDate == null ? 43 : ((Object)$physicalInventoryLastCountDate).hashCode());
            Calendar $postingDate = this.postingDate;
            result = result * 59 + ($postingDate == null ? 43 : ((Object)$postingDate).hashCode());
            String $fiscalPeriod = this.fiscalPeriod;
            result = result * 59 + ($fiscalPeriod == null ? 43 : $fiscalPeriod.hashCode());
            String $createdByUser = this.createdByUser;
            result = result * 59 + ($createdByUser == null ? 43 : $createdByUser.hashCode());
            Boolean $postingIsBlockedForPhysInvtry = this.postingIsBlockedForPhysInvtry;
            result = result * 59 + ($postingIsBlockedForPhysInvtry == null ? 43 : ((Object)$postingIsBlockedForPhysInvtry).hashCode());
            String $physicalInventoryCountStatus = this.physicalInventoryCountStatus;
            result = result * 59 + ($physicalInventoryCountStatus == null ? 43 : $physicalInventoryCountStatus.hashCode());
            String $physInvtryAdjustmentPostingSts = this.physInvtryAdjustmentPostingSts;
            result = result * 59 + ($physInvtryAdjustmentPostingSts == null ? 43 : $physInvtryAdjustmentPostingSts.hashCode());
            String $physInvtryDeletionStatus = this.physInvtryDeletionStatus;
            result = result * 59 + ($physInvtryDeletionStatus == null ? 43 : $physInvtryDeletionStatus.hashCode());
            Boolean $physInvtryDocHasQtySnapshot = this.physInvtryDocHasQtySnapshot;
            result = result * 59 + ($physInvtryDocHasQtySnapshot == null ? 43 : ((Object)$physInvtryDocHasQtySnapshot).hashCode());
            String $physicalInventoryGroupType = this.physicalInventoryGroupType;
            result = result * 59 + ($physicalInventoryGroupType == null ? 43 : $physicalInventoryGroupType.hashCode());
            String $physicalInventoryGroup = this.physicalInventoryGroup;
            result = result * 59 + ($physicalInventoryGroup == null ? 43 : $physicalInventoryGroup.hashCode());
            String $physicalInventoryNumber = this.physicalInventoryNumber;
            result = result * 59 + ($physicalInventoryNumber == null ? 43 : $physicalInventoryNumber.hashCode());
            String $physInventoryReferenceNumber = this.physInventoryReferenceNumber;
            result = result * 59 + ($physInventoryReferenceNumber == null ? 43 : $physInventoryReferenceNumber.hashCode());
            String $physicalInventoryDocumentDesc = this.physicalInventoryDocumentDesc;
            result = result * 59 + ($physicalInventoryDocumentDesc == null ? 43 : $physicalInventoryDocumentDesc.hashCode());
            String $physicalInventoryType = this.physicalInventoryType;
            result = result * 59 + ($physicalInventoryType == null ? 43 : $physicalInventoryType.hashCode());
            Calendar $lastChangeDateTime = this.lastChangeDateTime;
            result = result * 59 + ($lastChangeDateTime == null ? 43 : ((Object)$lastChangeDateTime).hashCode());
            return result;
        }

        public String getFiscalYear() {
            return this.fiscalYear;
        }

        public PhysInventoryDocHeader setFiscalYear(String fiscalYear) {
            this.fiscalYear = fiscalYear;
            return this;
        }

        public String getPhysicalInventoryDocument() {
            return this.physicalInventoryDocument;
        }

        public PhysInventoryDocHeader setPhysicalInventoryDocument(String physicalInventoryDocument) {
            this.physicalInventoryDocument = physicalInventoryDocument;
            return this;
        }

        public String getInventoryTransactionType() {
            return this.inventoryTransactionType;
        }

        public PhysInventoryDocHeader setInventoryTransactionType(String inventoryTransactionType) {
            this.inventoryTransactionType = inventoryTransactionType;
            return this;
        }

        public String getPlant() {
            return this.plant;
        }

        public PhysInventoryDocHeader setPlant(String plant) {
            this.plant = plant;
            return this;
        }

        public String getStorageLocation() {
            return this.storageLocation;
        }

        public PhysInventoryDocHeader setStorageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public String getInventorySpecialStockType() {
            return this.inventorySpecialStockType;
        }

        public PhysInventoryDocHeader setInventorySpecialStockType(String inventorySpecialStockType) {
            this.inventorySpecialStockType = inventorySpecialStockType;
            return this;
        }

        public Calendar getDocumentDate() {
            return this.documentDate;
        }

        public PhysInventoryDocHeader setDocumentDate(Calendar documentDate) {
            this.documentDate = documentDate;
            return this;
        }

        public Calendar getPhysInventoryPlannedCountDate() {
            return this.physInventoryPlannedCountDate;
        }

        public PhysInventoryDocHeader setPhysInventoryPlannedCountDate(Calendar physInventoryPlannedCountDate) {
            this.physInventoryPlannedCountDate = physInventoryPlannedCountDate;
            return this;
        }

        public Calendar getPhysicalInventoryLastCountDate() {
            return this.physicalInventoryLastCountDate;
        }

        public PhysInventoryDocHeader setPhysicalInventoryLastCountDate(Calendar physicalInventoryLastCountDate) {
            this.physicalInventoryLastCountDate = physicalInventoryLastCountDate;
            return this;
        }

        public Calendar getPostingDate() {
            return this.postingDate;
        }

        public PhysInventoryDocHeader setPostingDate(Calendar postingDate) {
            this.postingDate = postingDate;
            return this;
        }

        public String getFiscalPeriod() {
            return this.fiscalPeriod;
        }

        public PhysInventoryDocHeader setFiscalPeriod(String fiscalPeriod) {
            this.fiscalPeriod = fiscalPeriod;
            return this;
        }

        public String getCreatedByUser() {
            return this.createdByUser;
        }

        public PhysInventoryDocHeader setCreatedByUser(String createdByUser) {
            this.createdByUser = createdByUser;
            return this;
        }

        public Boolean getPostingIsBlockedForPhysInvtry() {
            return this.postingIsBlockedForPhysInvtry;
        }

        public PhysInventoryDocHeader setPostingIsBlockedForPhysInvtry(Boolean postingIsBlockedForPhysInvtry) {
            this.postingIsBlockedForPhysInvtry = postingIsBlockedForPhysInvtry;
            return this;
        }

        public String getPhysicalInventoryCountStatus() {
            return this.physicalInventoryCountStatus;
        }

        public PhysInventoryDocHeader setPhysicalInventoryCountStatus(String physicalInventoryCountStatus) {
            this.physicalInventoryCountStatus = physicalInventoryCountStatus;
            return this;
        }

        public String getPhysInvtryAdjustmentPostingSts() {
            return this.physInvtryAdjustmentPostingSts;
        }

        public PhysInventoryDocHeader setPhysInvtryAdjustmentPostingSts(String physInvtryAdjustmentPostingSts) {
            this.physInvtryAdjustmentPostingSts = physInvtryAdjustmentPostingSts;
            return this;
        }

        public String getPhysInvtryDeletionStatus() {
            return this.physInvtryDeletionStatus;
        }

        public PhysInventoryDocHeader setPhysInvtryDeletionStatus(String physInvtryDeletionStatus) {
            this.physInvtryDeletionStatus = physInvtryDeletionStatus;
            return this;
        }

        public Boolean getPhysInvtryDocHasQtySnapshot() {
            return this.physInvtryDocHasQtySnapshot;
        }

        public PhysInventoryDocHeader setPhysInvtryDocHasQtySnapshot(Boolean physInvtryDocHasQtySnapshot) {
            this.physInvtryDocHasQtySnapshot = physInvtryDocHasQtySnapshot;
            return this;
        }

        public String getPhysicalInventoryGroupType() {
            return this.physicalInventoryGroupType;
        }

        public PhysInventoryDocHeader setPhysicalInventoryGroupType(String physicalInventoryGroupType) {
            this.physicalInventoryGroupType = physicalInventoryGroupType;
            return this;
        }

        public String getPhysicalInventoryGroup() {
            return this.physicalInventoryGroup;
        }

        public PhysInventoryDocHeader setPhysicalInventoryGroup(String physicalInventoryGroup) {
            this.physicalInventoryGroup = physicalInventoryGroup;
            return this;
        }

        public String getPhysicalInventoryNumber() {
            return this.physicalInventoryNumber;
        }

        public PhysInventoryDocHeader setPhysicalInventoryNumber(String physicalInventoryNumber) {
            this.physicalInventoryNumber = physicalInventoryNumber;
            return this;
        }

        public String getPhysInventoryReferenceNumber() {
            return this.physInventoryReferenceNumber;
        }

        public PhysInventoryDocHeader setPhysInventoryReferenceNumber(String physInventoryReferenceNumber) {
            this.physInventoryReferenceNumber = physInventoryReferenceNumber;
            return this;
        }

        public String getPhysicalInventoryDocumentDesc() {
            return this.physicalInventoryDocumentDesc;
        }

        public PhysInventoryDocHeader setPhysicalInventoryDocumentDesc(String physicalInventoryDocumentDesc) {
            this.physicalInventoryDocumentDesc = physicalInventoryDocumentDesc;
            return this;
        }

        public String getPhysicalInventoryType() {
            return this.physicalInventoryType;
        }

        public PhysInventoryDocHeader setPhysicalInventoryType(String physicalInventoryType) {
            this.physicalInventoryType = physicalInventoryType;
            return this;
        }

        public Calendar getLastChangeDateTime() {
            return this.lastChangeDateTime;
        }

        public PhysInventoryDocHeader setLastChangeDateTime(Calendar lastChangeDateTime) {
            this.lastChangeDateTime = lastChangeDateTime;
            return this;
        }

        public PhysInventoryDocHeader setErpConfigContext(ErpConfigContext erpConfigContext) {
            this.erpConfigContext = erpConfigContext;
            return this;
        }
    }

    public static class InitiateRecountOnItemFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public InitiateRecountOnItemFluentHelper(String physicalInventoryDocument, String fiscalYear, String physicalInventoryDocumentItem, Calendar physInventoryPlannedCountDate, Calendar documentDate, String physicalInventoryNumber, String physInventoryReferenceNumber, String physicalInventoryDocumentDesc, Boolean physInvtryDocHasQtySnapshot, Boolean postingIsBlockedForPhysInvtry) {
            this.values.add(physicalInventoryDocument);
            this.values.add(fiscalYear);
            this.values.add(physicalInventoryDocumentItem);
            this.values.add(physInventoryPlannedCountDate);
            this.values.add(documentDate);
            this.values.add(physicalInventoryNumber);
            this.values.add(physInventoryReferenceNumber);
            this.values.add(physicalInventoryDocumentDesc);
            this.values.add(physInvtryDocHasQtySnapshot);
            this.values.add(postingIsBlockedForPhysInvtry);
        }

        public PhysInventoryDocItem execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpPost(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV/InitiateRecountOnItem?PhysicalInventoryDocument=%s&FiscalYear=%s&PhysicalInventoryDocumentItem=%s&PhysInventoryPlannedCountDate=%s&DocumentDate=%s&PhysicalInventoryNumber=%s&PhysInventoryReferenceNumber=%s&PhysicalInventoryDocumentDesc=%s&PhysInvtryDocHasQtySnapshot=%s&PostingIsBlockedForPhysInvtry=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(3)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(4)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(5)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(6)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(7)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Boolean).toUri((Boolean)this.values.get(8)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Boolean).toUri((Boolean)this.values.get(9))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (PhysInventoryDocItem)FunctionImportResponseParser.getResultElementFromContent(content, "InitiateRecountOnItem").getAsObject().as(PhysInventoryDocItem.class);
        }
    }

    public static class InitiateRecountFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public InitiateRecountFluentHelper(String physicalInventoryDocument, String fiscalYear, Calendar physInventoryPlannedCountDate, Calendar documentDate, String physicalInventoryNumber, String physInventoryReferenceNumber, String physicalInventoryDocumentDesc, BigDecimal postingThresholdValue, Boolean physInvtryDocHasQtySnapshot, Boolean postingIsBlockedForPhysInvtry) {
            this.values.add(physicalInventoryDocument);
            this.values.add(fiscalYear);
            this.values.add(physInventoryPlannedCountDate);
            this.values.add(documentDate);
            this.values.add(physicalInventoryNumber);
            this.values.add(physInventoryReferenceNumber);
            this.values.add(physicalInventoryDocumentDesc);
            this.values.add(postingThresholdValue);
            this.values.add(physInvtryDocHasQtySnapshot);
            this.values.add(postingIsBlockedForPhysInvtry);
        }

        public PhysInventoryDocHeader execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpPost(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PHYSICAL_INVENTORY_DOC_SRV/InitiateRecount?PhysicalInventoryDocument=%s&FiscalYear=%s&PhysInventoryPlannedCountDate=%s&DocumentDate=%s&PhysicalInventoryNumber=%s&PhysInventoryReferenceNumber=%s&PhysicalInventoryDocumentDesc=%s&PostingThresholdValue=%s&PhysInvtryDocHasQtySnapshot=%s&PostingIsBlockedForPhysInvtry=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTime).toUri((Calendar)this.values.get(3)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(4)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(5)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(6)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Decimal).toUri((BigDecimal)this.values.get(7)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Boolean).toUri((Boolean)this.values.get(8)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.Boolean).toUri((Boolean)this.values.get(9))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (PhysInventoryDocHeader)FunctionImportResponseParser.getResultElementFromContent(content, "InitiateRecount").getAsObject().as(PhysInventoryDocHeader.class);
        }
    }
}

