/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces;

import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataExceptionType;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.FunctionImportResponseParser;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataCalendarAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.helper.ODataTypeValueSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;

public class BasicProductAvailabilityInformationApiNamespace {

    public static class DetermineAvailabilityOfFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public DetermineAvailabilityOfFluentHelper(BigDecimal requestedQuantityInBaseUnit, String material, String supplyingPlant, String aTPCheckingRule) {
            this.values.add(requestedQuantityInBaseUnit);
            this.values.add(material);
            this.values.add(supplyingPlant);
            this.values.add(aTPCheckingRule);
        }

        public AvailabilityRecord execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpGet(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PRODUCT_AVAILY_INFO_BASIC/DetermineAvailabilityOf?RequestedQuantityInBaseUnit=%s&Material=%s&SupplyingPlant=%s&ATPCheckingRule=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.Decimal).toUri((BigDecimal)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(3))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (AvailabilityRecord)FunctionImportResponseParser.getResultElementFromContent(content, "DetermineAvailabilityOf").getAsObject().as(AvailabilityRecord.class);
        }
    }

    public static class DetermineAvailabilityAtFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public DetermineAvailabilityAtFluentHelper(String supplyingPlant, String material, String aTPCheckingRule, Calendar requestedUTCDateTime) {
            this.values.add(supplyingPlant);
            this.values.add(material);
            this.values.add(aTPCheckingRule);
            this.values.add(requestedUTCDateTime);
        }

        public AvailabilityRecord execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpGet(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PRODUCT_AVAILY_INFO_BASIC/DetermineAvailabilityAt?SupplyingPlant=%s&Material=%s&ATPCheckingRule=%s&RequestedUTCDateTime=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(2)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.DateTimeOffset).toUri((Calendar)this.values.get(3))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return (AvailabilityRecord)FunctionImportResponseParser.getResultElementFromContent(content, "DetermineAvailabilityAt").getAsObject().as(AvailabilityRecord.class);
        }
    }

    public static class CalculateAvailabilityTimeseriesFluentHelper {
        private List<Object> values = new LinkedList<Object>();

        public CalculateAvailabilityTimeseriesFluentHelper(String aTPCheckingRule, String material, String supplyingPlant) {
            this.values.add(aTPCheckingRule);
            this.values.add(material);
            this.values.add(supplyingPlant);
        }

        public List<AvailabilityRecord> execute(ErpConfigContext erpConfigContext) throws ODataException, IOException {
            String uriString;
            URI uri;
            HttpResponse response;
            Integer statusCode;
            Integer destinationUriStringLastIndex;
            String destinationName = erpConfigContext.getDestinationName();
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)destinationName);
            String destinationUriString = DestinationAccessor.getDestination((String)destinationName).getUri().toString();
            if (destinationUriString.charAt(destinationUriStringLastIndex = Integer.valueOf(destinationUriString.length() - 1)) == '/') {
                destinationUriString = destinationUriString.substring(0, destinationUriStringLastIndex);
            }
            if ((statusCode = Integer.valueOf((response = httpClient.execute((HttpUriRequest)new HttpGet(uri = URI.create(uriString = destinationUriString + String.format("/sap/opu/odata/sap/API_PRODUCT_AVAILY_INFO_BASIC/CalculateAvailabilityTimeseries?ATPCheckingRule=%s&Material=%s&SupplyingPlant=%s&$format=json", ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(0)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(1)), ODataTypeValueSerializer.of(EdmSimpleTypeKind.String).toUri((String)this.values.get(2))))))).getStatusLine().getStatusCode())) >= 400 & statusCode <= 599) {
                throw new ODataException(ODataExceptionType.ODATA_OPERATION_EXECUTION_FAILED, "Execution of the function import returned HTTP error code " + statusCode, null);
            }
            InputStream content = response.getEntity().getContent();
            return FunctionImportResponseParser.getResultElementFromContent(content, "CalculateAvailabilityTimeseries").getAsCollection().asList(AvailabilityRecord.class);
        }
    }

    public static class AvailabilityRecord {
        @ElementName(value="PeriodStartUTCDateTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar periodStartUTCDateTime;
        @ElementName(value="PeriodStartTimeZone")
        private String periodStartTimeZone;
        @ElementName(value="PeriodEndUTCDateTime")
        @JsonAdapter(value=ODataCalendarAdapter.class)
        private Calendar periodEndUTCDateTime;
        @ElementName(value="PeriodEndTimeZone")
        private String periodEndTimeZone;
        @ElementName(value="AvailableQuantityInBaseUnit")
        private BigDecimal availableQuantityInBaseUnit;
        @ElementName(value="BaseUnit")
        private String baseUnit;

        public Calendar getPeriodStartUTCDateTime() {
            return this.periodStartUTCDateTime;
        }

        public String getPeriodStartTimeZone() {
            return this.periodStartTimeZone;
        }

        public Calendar getPeriodEndUTCDateTime() {
            return this.periodEndUTCDateTime;
        }

        public String getPeriodEndTimeZone() {
            return this.periodEndTimeZone;
        }

        public BigDecimal getAvailableQuantityInBaseUnit() {
            return this.availableQuantityInBaseUnit;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        public AvailabilityRecord setPeriodStartUTCDateTime(Calendar periodStartUTCDateTime) {
            this.periodStartUTCDateTime = periodStartUTCDateTime;
            return this;
        }

        public AvailabilityRecord setPeriodStartTimeZone(String periodStartTimeZone) {
            this.periodStartTimeZone = periodStartTimeZone;
            return this;
        }

        public AvailabilityRecord setPeriodEndUTCDateTime(Calendar periodEndUTCDateTime) {
            this.periodEndUTCDateTime = periodEndUTCDateTime;
            return this;
        }

        public AvailabilityRecord setPeriodEndTimeZone(String periodEndTimeZone) {
            this.periodEndTimeZone = periodEndTimeZone;
            return this;
        }

        public AvailabilityRecord setAvailableQuantityInBaseUnit(BigDecimal availableQuantityInBaseUnit) {
            this.availableQuantityInBaseUnit = availableQuantityInBaseUnit;
            return this;
        }

        public AvailabilityRecord setBaseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AvailabilityRecord)) {
                return false;
            }
            AvailabilityRecord other = (AvailabilityRecord)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Calendar this$periodStartUTCDateTime = this.getPeriodStartUTCDateTime();
            Calendar other$periodStartUTCDateTime = other.getPeriodStartUTCDateTime();
            if (this$periodStartUTCDateTime == null ? other$periodStartUTCDateTime != null : !((Object)this$periodStartUTCDateTime).equals(other$periodStartUTCDateTime)) {
                return false;
            }
            String this$periodStartTimeZone = this.getPeriodStartTimeZone();
            String other$periodStartTimeZone = other.getPeriodStartTimeZone();
            if (this$periodStartTimeZone == null ? other$periodStartTimeZone != null : !this$periodStartTimeZone.equals(other$periodStartTimeZone)) {
                return false;
            }
            Calendar this$periodEndUTCDateTime = this.getPeriodEndUTCDateTime();
            Calendar other$periodEndUTCDateTime = other.getPeriodEndUTCDateTime();
            if (this$periodEndUTCDateTime == null ? other$periodEndUTCDateTime != null : !((Object)this$periodEndUTCDateTime).equals(other$periodEndUTCDateTime)) {
                return false;
            }
            String this$periodEndTimeZone = this.getPeriodEndTimeZone();
            String other$periodEndTimeZone = other.getPeriodEndTimeZone();
            if (this$periodEndTimeZone == null ? other$periodEndTimeZone != null : !this$periodEndTimeZone.equals(other$periodEndTimeZone)) {
                return false;
            }
            BigDecimal this$availableQuantityInBaseUnit = this.getAvailableQuantityInBaseUnit();
            BigDecimal other$availableQuantityInBaseUnit = other.getAvailableQuantityInBaseUnit();
            if (this$availableQuantityInBaseUnit == null ? other$availableQuantityInBaseUnit != null : !((Object)this$availableQuantityInBaseUnit).equals(other$availableQuantityInBaseUnit)) {
                return false;
            }
            String this$baseUnit = this.getBaseUnit();
            String other$baseUnit = other.getBaseUnit();
            return !(this$baseUnit == null ? other$baseUnit != null : !this$baseUnit.equals(other$baseUnit));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AvailabilityRecord;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Calendar $periodStartUTCDateTime = this.getPeriodStartUTCDateTime();
            result = result * 59 + ($periodStartUTCDateTime == null ? 43 : ((Object)$periodStartUTCDateTime).hashCode());
            String $periodStartTimeZone = this.getPeriodStartTimeZone();
            result = result * 59 + ($periodStartTimeZone == null ? 43 : $periodStartTimeZone.hashCode());
            Calendar $periodEndUTCDateTime = this.getPeriodEndUTCDateTime();
            result = result * 59 + ($periodEndUTCDateTime == null ? 43 : ((Object)$periodEndUTCDateTime).hashCode());
            String $periodEndTimeZone = this.getPeriodEndTimeZone();
            result = result * 59 + ($periodEndTimeZone == null ? 43 : $periodEndTimeZone.hashCode());
            BigDecimal $availableQuantityInBaseUnit = this.getAvailableQuantityInBaseUnit();
            result = result * 59 + ($availableQuantityInBaseUnit == null ? 43 : ((Object)$availableQuantityInBaseUnit).hashCode());
            String $baseUnit = this.getBaseUnit();
            result = result * 59 + ($baseUnit == null ? 43 : $baseUnit.hashCode());
            return result;
        }

        public String toString() {
            return "BasicProductAvailabilityInformationApiNamespace.AvailabilityRecord(periodStartUTCDateTime=" + this.getPeriodStartUTCDateTime() + ", periodStartTimeZone=" + this.getPeriodStartTimeZone() + ", periodEndUTCDateTime=" + this.getPeriodEndUTCDateTime() + ", periodEndTimeZone=" + this.getPeriodEndTimeZone() + ", availableQuantityInBaseUnit=" + this.getAvailableQuantityInBaseUnit() + ", baseUnit=" + this.getBaseUnit() + ")";
        }
    }
}

