/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.helper;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.sap.cloud.sdk.odatav2.connectivity.ErrorResultHandler;
import com.sap.cloud.sdk.odatav2.connectivity.ODataException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataQuery;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class ODataVdmErrorResultHandler
implements ErrorResultHandler<ErpODataException> {
    protected Class<ErpODataException> getExceptionType() {
        return ErpODataException.class;
    }

    public ErpODataException createError(String message, Object origin, int httpStatusCode) {
        String errorMessage;
        boolean isHtml = StringUtils.startsWith((CharSequence)message, (CharSequence)"<");
        boolean isJson = StringUtils.startsWith((CharSequence)message, (CharSequence)"{");
        if (isHtml) {
            String messageFromHtml = this.getMessageFromHtml(message);
            errorMessage = this.assembleMessage(messageFromHtml, httpStatusCode);
        } else if (isJson) {
            String messageFromJson = this.getMessageFromJson(message);
            errorMessage = this.assembleMessage(messageFromJson, httpStatusCode);
        } else {
            errorMessage = this.assembleMessage("", httpStatusCode);
        }
        ErpODataException exception = new ErpODataException();
        exception.setMessage(errorMessage);
        if (origin instanceof ODataQuery) {
            exception.setQuery((ODataQuery)origin);
        }
        return exception;
    }

    private String assembleMessage(String message, int httpStatusCode) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("The endpoint responded with HTTP error code ").append(httpStatusCode).append(". ").append(message).append("\n").append(this.getMeaningfulAddition(message));
        return messageBuilder.toString();
    }

    private String getMeaningfulAddition(String message) {
        if (message.equals("Service cannot be reached.")) {
            return "Please check the path to the service endpoint you provided in the ODataQuery.";
        }
        if (message.startsWith("Resource not found for the segment")) {
            return "Please make sure that you specified all the entities and fields correctly.";
        }
        return "";
    }

    private String getMessageFromJson(String message) {
        JsonElement jsonElement = new JsonParser().parse(message);
        return jsonElement.getAsJsonObject().get("error").getAsJsonObject().get("message").getAsJsonObject().get("value").toString().replaceAll("\"", "").replaceAll("\\$", "");
    }

    private String getMessageFromHtml(String message) {
        Document document = Jsoup.parse((String)message);
        return document.title() + ".";
    }

    public static class ErpODataException
    extends ODataException {
        private static final long serialVersionUID = -1995254562234140438L;
        private transient ODataQuery query;
        private String code;

        public void setQuery(ODataQuery query) {
            this.query = query;
        }

        public ODataQuery getQuery() {
            return this.query;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }
}

