/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.odata.helper;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.odatav2.connectivity.ODataProperty;
import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;

public final class ODataTypeValueSerializer {
    private static final boolean KEEP_SECOND_FRACTIONS = false;
    @NonNull
    private final EdmType type;

    public static ODataTypeValueSerializer of(EdmSimpleTypeKind typeKind) {
        return ODataTypeValueSerializer.of((EdmType)typeKind.getEdmSimpleTypeInstance());
    }

    public String toUri(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof ODataProperty) {
            return ((ODataProperty)value).getField();
        }
        if (this.type instanceof EdmSimpleType) {
            if (this.type instanceof EdmDateTime || this.type instanceof EdmDateTimeOffset) {
                if (value instanceof LocalDate) {
                    value = ((LocalDate)value).toDateTime(LocalTime.MIDNIGHT, DateTimeZone.UTC).getMillis();
                } else if (value instanceof LocalDateTime) {
                    value = ((LocalDateTime)value).toDateTime(DateTimeZone.UTC).getMillis();
                } else if (value instanceof ReadableInstant) {
                    long ms = ((ReadableInstant)value).getMillis();
                    long offsetInMilliseconds = ((ReadableInstant)value).getZone().getOffset(ms);
                    value = ms + offsetInMilliseconds;
                }
                if (value instanceof Long) {
                    value = (Long)value / 1000L * 1000L;
                }
            }
            try {
                return ((EdmSimpleType)this.type).valueToString(value, EdmLiteralKind.URI, null);
            }
            catch (EdmSimpleTypeException e) {
                try {
                    throw new ShouldNotHappenException("Failed to use \"" + this.type.getName() + "\" deserializer.", (Throwable)e);
                }
                catch (EdmException e1) {
                    throw new ShouldNotHappenException("Failed to get name of \"" + this.type.getClass().getSimpleName() + "\".", (Throwable)e1);
                }
            }
        }
        throw new UnsupportedOperationException("Not yet implemented mapping complex EDM types.");
    }

    @ConstructorProperties(value={"type"})
    private ODataTypeValueSerializer(@NonNull EdmType type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        this.type = type;
    }

    public static ODataTypeValueSerializer of(@NonNull EdmType type) {
        return new ODataTypeValueSerializer(type);
    }
}

