/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.structures;

import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.AccountingDocumentLineItemNumber;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.ConditionKey;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.GLAccountNumber;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.PercentageRatePackedWithSignNnnnNnnv;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.TaxJurisdiction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.TaxesOnSalesPuchasesCode;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpInteger;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;

public final class TaxItem {
    @ElementName(value="ITEMNO_ACC")
    @Nullable
    private final AccountingDocumentLineItemNumber itemnoAcc;
    @ElementName(value="GL_ACCOUNT")
    @Nullable
    private final GLAccountNumber glAccount;
    @ElementName(value="COND_KEY")
    @Nullable
    private final ConditionKey condKey;
    @ElementName(value="ACCT_KEY")
    @Nullable
    private final String acctKey;
    @ElementName(value="TAX_CODE")
    @Nullable
    private final TaxesOnSalesPuchasesCode taxCode;
    @ElementName(value="TAX_RATE")
    @Nullable
    private final PercentageRatePackedWithSignNnnnNnnv taxRate;
    @ElementName(value="TAX_DATE")
    @Nullable
    private final LocalDate taxDate;
    @ElementName(value="TAXJURCODE")
    @Nullable
    private final TaxJurisdiction taxjurcode;
    @ElementName(value="TAXJURCODE_DEEP")
    @Nullable
    private final TaxJurisdiction taxjurcodeDeep;
    @ElementName(value="TAXJURCODE_LEVEL")
    @Nullable
    private final String taxjurcodeLevel;
    @ElementName(value="ITEMNO_TAX")
    @Nullable
    private final ErpInteger itemnoTax;
    @ElementName(value="DIRECT_TAX")
    @Nullable
    private final ErpBoolean directTax;

    public void validate() throws IllegalArgumentException {
        if (this.acctKey != null && this.acctKey.length() > 3) {
            throw new IllegalArgumentException("Bapi method parameter \"acctKey\" contains an invalid structure. Structure attribute \"ACCT_KEY\" / Function parameter \"acctKey\" must have at most 3 characters. The given value is too long.");
        }
        if (this.taxjurcodeLevel != null && this.taxjurcodeLevel.length() > 1) {
            throw new IllegalArgumentException("Bapi method parameter \"taxjurcodeLevel\" contains an invalid structure. Structure attribute \"TAXJURCODE_LEVEL\" / Function parameter \"taxjurcodeLevel\" must have at most 1 characters. The given value is too long.");
        }
    }

    @ConstructorProperties(value={"itemnoAcc", "glAccount", "condKey", "acctKey", "taxCode", "taxRate", "taxDate", "taxjurcode", "taxjurcodeDeep", "taxjurcodeLevel", "itemnoTax", "directTax"})
    TaxItem(@Nullable AccountingDocumentLineItemNumber itemnoAcc, @Nullable GLAccountNumber glAccount, @Nullable ConditionKey condKey, @Nullable String acctKey, @Nullable TaxesOnSalesPuchasesCode taxCode, @Nullable PercentageRatePackedWithSignNnnnNnnv taxRate, @Nullable LocalDate taxDate, @Nullable TaxJurisdiction taxjurcode, @Nullable TaxJurisdiction taxjurcodeDeep, @Nullable String taxjurcodeLevel, @Nullable ErpInteger itemnoTax, @Nullable ErpBoolean directTax) {
        this.itemnoAcc = itemnoAcc;
        this.glAccount = glAccount;
        this.condKey = condKey;
        this.acctKey = acctKey;
        this.taxCode = taxCode;
        this.taxRate = taxRate;
        this.taxDate = taxDate;
        this.taxjurcode = taxjurcode;
        this.taxjurcodeDeep = taxjurcodeDeep;
        this.taxjurcodeLevel = taxjurcodeLevel;
        this.itemnoTax = itemnoTax;
        this.directTax = directTax;
    }

    public static TaxItemBuilder builder() {
        return new TaxItemBuilder();
    }

    @Nullable
    public AccountingDocumentLineItemNumber getItemnoAcc() {
        return this.itemnoAcc;
    }

    @Nullable
    public GLAccountNumber getGlAccount() {
        return this.glAccount;
    }

    @Nullable
    public ConditionKey getCondKey() {
        return this.condKey;
    }

    @Nullable
    public String getAcctKey() {
        return this.acctKey;
    }

    @Nullable
    public TaxesOnSalesPuchasesCode getTaxCode() {
        return this.taxCode;
    }

    @Nullable
    public PercentageRatePackedWithSignNnnnNnnv getTaxRate() {
        return this.taxRate;
    }

    @Nullable
    public LocalDate getTaxDate() {
        return this.taxDate;
    }

    @Nullable
    public TaxJurisdiction getTaxjurcode() {
        return this.taxjurcode;
    }

    @Nullable
    public TaxJurisdiction getTaxjurcodeDeep() {
        return this.taxjurcodeDeep;
    }

    @Nullable
    public String getTaxjurcodeLevel() {
        return this.taxjurcodeLevel;
    }

    @Nullable
    public ErpInteger getItemnoTax() {
        return this.itemnoTax;
    }

    @Nullable
    public ErpBoolean getDirectTax() {
        return this.directTax;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaxItem)) {
            return false;
        }
        TaxItem other = (TaxItem)o;
        AccountingDocumentLineItemNumber this$itemnoAcc = this.getItemnoAcc();
        AccountingDocumentLineItemNumber other$itemnoAcc = other.getItemnoAcc();
        if (this$itemnoAcc == null ? other$itemnoAcc != null : !((Object)this$itemnoAcc).equals(other$itemnoAcc)) {
            return false;
        }
        GLAccountNumber this$glAccount = this.getGlAccount();
        GLAccountNumber other$glAccount = other.getGlAccount();
        if (this$glAccount == null ? other$glAccount != null : !((Object)((Object)this$glAccount)).equals((Object)other$glAccount)) {
            return false;
        }
        ConditionKey this$condKey = this.getCondKey();
        ConditionKey other$condKey = other.getCondKey();
        if (this$condKey == null ? other$condKey != null : !((Object)((Object)this$condKey)).equals((Object)other$condKey)) {
            return false;
        }
        String this$acctKey = this.getAcctKey();
        String other$acctKey = other.getAcctKey();
        if (this$acctKey == null ? other$acctKey != null : !this$acctKey.equals(other$acctKey)) {
            return false;
        }
        TaxesOnSalesPuchasesCode this$taxCode = this.getTaxCode();
        TaxesOnSalesPuchasesCode other$taxCode = other.getTaxCode();
        if (this$taxCode == null ? other$taxCode != null : !((Object)((Object)this$taxCode)).equals((Object)other$taxCode)) {
            return false;
        }
        PercentageRatePackedWithSignNnnnNnnv this$taxRate = this.getTaxRate();
        PercentageRatePackedWithSignNnnnNnnv other$taxRate = other.getTaxRate();
        if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
            return false;
        }
        LocalDate this$taxDate = this.getTaxDate();
        LocalDate other$taxDate = other.getTaxDate();
        if (this$taxDate == null ? other$taxDate != null : !this$taxDate.equals(other$taxDate)) {
            return false;
        }
        TaxJurisdiction this$taxjurcode = this.getTaxjurcode();
        TaxJurisdiction other$taxjurcode = other.getTaxjurcode();
        if (this$taxjurcode == null ? other$taxjurcode != null : !((Object)((Object)this$taxjurcode)).equals((Object)other$taxjurcode)) {
            return false;
        }
        TaxJurisdiction this$taxjurcodeDeep = this.getTaxjurcodeDeep();
        TaxJurisdiction other$taxjurcodeDeep = other.getTaxjurcodeDeep();
        if (this$taxjurcodeDeep == null ? other$taxjurcodeDeep != null : !((Object)((Object)this$taxjurcodeDeep)).equals((Object)other$taxjurcodeDeep)) {
            return false;
        }
        String this$taxjurcodeLevel = this.getTaxjurcodeLevel();
        String other$taxjurcodeLevel = other.getTaxjurcodeLevel();
        if (this$taxjurcodeLevel == null ? other$taxjurcodeLevel != null : !this$taxjurcodeLevel.equals(other$taxjurcodeLevel)) {
            return false;
        }
        ErpInteger this$itemnoTax = this.getItemnoTax();
        ErpInteger other$itemnoTax = other.getItemnoTax();
        if (this$itemnoTax == null ? other$itemnoTax != null : !((Object)this$itemnoTax).equals(other$itemnoTax)) {
            return false;
        }
        ErpBoolean this$directTax = this.getDirectTax();
        ErpBoolean other$directTax = other.getDirectTax();
        return !(this$directTax == null ? other$directTax != null : !this$directTax.equals(other$directTax));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountingDocumentLineItemNumber $itemnoAcc = this.getItemnoAcc();
        result = result * 59 + ($itemnoAcc == null ? 43 : ((Object)$itemnoAcc).hashCode());
        GLAccountNumber $glAccount = this.getGlAccount();
        result = result * 59 + ($glAccount == null ? 43 : ((Object)((Object)$glAccount)).hashCode());
        ConditionKey $condKey = this.getCondKey();
        result = result * 59 + ($condKey == null ? 43 : ((Object)((Object)$condKey)).hashCode());
        String $acctKey = this.getAcctKey();
        result = result * 59 + ($acctKey == null ? 43 : $acctKey.hashCode());
        TaxesOnSalesPuchasesCode $taxCode = this.getTaxCode();
        result = result * 59 + ($taxCode == null ? 43 : ((Object)((Object)$taxCode)).hashCode());
        PercentageRatePackedWithSignNnnnNnnv $taxRate = this.getTaxRate();
        result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
        LocalDate $taxDate = this.getTaxDate();
        result = result * 59 + ($taxDate == null ? 43 : $taxDate.hashCode());
        TaxJurisdiction $taxjurcode = this.getTaxjurcode();
        result = result * 59 + ($taxjurcode == null ? 43 : ((Object)((Object)$taxjurcode)).hashCode());
        TaxJurisdiction $taxjurcodeDeep = this.getTaxjurcodeDeep();
        result = result * 59 + ($taxjurcodeDeep == null ? 43 : ((Object)((Object)$taxjurcodeDeep)).hashCode());
        String $taxjurcodeLevel = this.getTaxjurcodeLevel();
        result = result * 59 + ($taxjurcodeLevel == null ? 43 : $taxjurcodeLevel.hashCode());
        ErpInteger $itemnoTax = this.getItemnoTax();
        result = result * 59 + ($itemnoTax == null ? 43 : ((Object)$itemnoTax).hashCode());
        ErpBoolean $directTax = this.getDirectTax();
        result = result * 59 + ($directTax == null ? 43 : $directTax.hashCode());
        return result;
    }

    public String toString() {
        return "TaxItem(itemnoAcc=" + this.getItemnoAcc() + ", glAccount=" + (Object)((Object)this.getGlAccount()) + ", condKey=" + (Object)((Object)this.getCondKey()) + ", acctKey=" + this.getAcctKey() + ", taxCode=" + (Object)((Object)this.getTaxCode()) + ", taxRate=" + this.getTaxRate() + ", taxDate=" + this.getTaxDate() + ", taxjurcode=" + (Object)((Object)this.getTaxjurcode()) + ", taxjurcodeDeep=" + (Object)((Object)this.getTaxjurcodeDeep()) + ", taxjurcodeLevel=" + this.getTaxjurcodeLevel() + ", itemnoTax=" + this.getItemnoTax() + ", directTax=" + this.getDirectTax() + ")";
    }

    public static class TaxItemBuilder {
        private AccountingDocumentLineItemNumber itemnoAcc;
        private GLAccountNumber glAccount;
        private ConditionKey condKey;
        private String acctKey;
        private TaxesOnSalesPuchasesCode taxCode;
        private PercentageRatePackedWithSignNnnnNnnv taxRate;
        private LocalDate taxDate;
        private TaxJurisdiction taxjurcode;
        private TaxJurisdiction taxjurcodeDeep;
        private String taxjurcodeLevel;
        private ErpInteger itemnoTax;
        private ErpBoolean directTax;

        TaxItemBuilder() {
        }

        public TaxItemBuilder itemnoAcc(AccountingDocumentLineItemNumber itemnoAcc) {
            this.itemnoAcc = itemnoAcc;
            return this;
        }

        public TaxItemBuilder glAccount(GLAccountNumber glAccount) {
            this.glAccount = glAccount;
            return this;
        }

        public TaxItemBuilder condKey(ConditionKey condKey) {
            this.condKey = condKey;
            return this;
        }

        public TaxItemBuilder acctKey(String acctKey) {
            this.acctKey = acctKey;
            return this;
        }

        public TaxItemBuilder taxCode(TaxesOnSalesPuchasesCode taxCode) {
            this.taxCode = taxCode;
            return this;
        }

        public TaxItemBuilder taxRate(PercentageRatePackedWithSignNnnnNnnv taxRate) {
            this.taxRate = taxRate;
            return this;
        }

        public TaxItemBuilder taxDate(LocalDate taxDate) {
            this.taxDate = taxDate;
            return this;
        }

        public TaxItemBuilder taxjurcode(TaxJurisdiction taxjurcode) {
            this.taxjurcode = taxjurcode;
            return this;
        }

        public TaxItemBuilder taxjurcodeDeep(TaxJurisdiction taxjurcodeDeep) {
            this.taxjurcodeDeep = taxjurcodeDeep;
            return this;
        }

        public TaxItemBuilder taxjurcodeLevel(String taxjurcodeLevel) {
            this.taxjurcodeLevel = taxjurcodeLevel;
            return this;
        }

        public TaxItemBuilder itemnoTax(ErpInteger itemnoTax) {
            this.itemnoTax = itemnoTax;
            return this;
        }

        public TaxItemBuilder directTax(ErpBoolean directTax) {
            this.directTax = directTax;
            return this;
        }

        public TaxItem build() {
            return new TaxItem(this.itemnoAcc, this.glAccount, this.condKey, this.acctKey, this.taxCode, this.taxRate, this.taxDate, this.taxjurcode, this.taxjurcodeDeep, this.taxjurcodeLevel, this.itemnoTax, this.directTax);
        }

        public String toString() {
            return "TaxItem.TaxItemBuilder(itemnoAcc=" + this.itemnoAcc + ", glAccount=" + (Object)((Object)this.glAccount) + ", condKey=" + (Object)((Object)this.condKey) + ", acctKey=" + this.acctKey + ", taxCode=" + (Object)((Object)this.taxCode) + ", taxRate=" + this.taxRate + ", taxDate=" + this.taxDate + ", taxjurcode=" + (Object)((Object)this.taxjurcode) + ", taxjurcodeDeep=" + (Object)((Object)this.taxjurcodeDeep) + ", taxjurcodeLevel=" + this.taxjurcodeLevel + ", itemnoTax=" + this.itemnoTax + ", directTax=" + this.directTax + ")";
        }
    }
}

