/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.structures;

import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.AccountNumberOfSupplier;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.AssetSubnumber;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.Company;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CountryIsoCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CountryKey;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CurrencyAmountsInBapiInterfaces;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CurrencyKey;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.IsoCodeCurrency;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.MainAssetNumber;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.PackedPercentageNnnNn;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.TypeNameOfCommodity;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.types.Year;
import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;

public final class FixedAssetOrigin {
    @ElementName(value="VENDOR_NO")
    @Nullable
    private final AccountNumberOfSupplier vendorNo;
    @ElementName(value="VENDOR")
    @Nullable
    private final String vendor;
    @ElementName(value="MANUFACTURER")
    @Nullable
    private final String manufacturer;
    @ElementName(value="PURCH_NEW")
    @Nullable
    private final ErpBoolean purchNew;
    @ElementName(value="TRADE_ID")
    @Nullable
    private final Company tradeId;
    @ElementName(value="COUNTRY")
    @Nullable
    private final CountryKey country;
    @ElementName(value="COUNTRY_ISO")
    @Nullable
    private final CountryIsoCode countryIso;
    @ElementName(value="TYPE_NAME")
    @Nullable
    private final TypeNameOfCommodity typeName;
    @ElementName(value="ORIG_ASSET")
    @Nullable
    private final MainAssetNumber origAsset;
    @ElementName(value="ORIG_ASSET_SUBNO")
    @Nullable
    private final AssetSubnumber origAssetSubno;
    @ElementName(value="ORIG_ACQ_DATE")
    @Nullable
    private final LocalDate origAcqDate;
    @ElementName(value="ORIG_ACQ_YR")
    @Nullable
    private final Year origAcqYr;
    @ElementName(value="ORIG_VALUE")
    @Nullable
    private final CurrencyAmountsInBapiInterfaces origValue;
    @ElementName(value="CURRENCY")
    @Nullable
    private final CurrencyKey currency;
    @ElementName(value="CURRENCY_ISO")
    @Nullable
    private final IsoCodeCurrency currencyIso;
    @ElementName(value="INHOUSE_PROD_PERCENTAGE")
    @Nullable
    private final PackedPercentageNnnNn inhouseProdPercentage;

    public void validate() throws IllegalArgumentException {
        if (this.vendor != null && this.vendor.length() > 30) {
            throw new IllegalArgumentException("Bapi method parameter \"vendor\" contains an invalid structure. Structure attribute \"VENDOR\" / Function parameter \"vendor\" must have at most 30 characters. The given value is too long.");
        }
        if (this.manufacturer != null && this.manufacturer.length() > 30) {
            throw new IllegalArgumentException("Bapi method parameter \"manufacturer\" contains an invalid structure. Structure attribute \"MANUFACTURER\" / Function parameter \"manufacturer\" must have at most 30 characters. The given value is too long.");
        }
    }

    @ConstructorProperties(value={"vendorNo", "vendor", "manufacturer", "purchNew", "tradeId", "country", "countryIso", "typeName", "origAsset", "origAssetSubno", "origAcqDate", "origAcqYr", "origValue", "currency", "currencyIso", "inhouseProdPercentage"})
    FixedAssetOrigin(@Nullable AccountNumberOfSupplier vendorNo, @Nullable String vendor, @Nullable String manufacturer, @Nullable ErpBoolean purchNew, @Nullable Company tradeId, @Nullable CountryKey country, @Nullable CountryIsoCode countryIso, @Nullable TypeNameOfCommodity typeName, @Nullable MainAssetNumber origAsset, @Nullable AssetSubnumber origAssetSubno, @Nullable LocalDate origAcqDate, @Nullable Year origAcqYr, @Nullable CurrencyAmountsInBapiInterfaces origValue, @Nullable CurrencyKey currency, @Nullable IsoCodeCurrency currencyIso, @Nullable PackedPercentageNnnNn inhouseProdPercentage) {
        this.vendorNo = vendorNo;
        this.vendor = vendor;
        this.manufacturer = manufacturer;
        this.purchNew = purchNew;
        this.tradeId = tradeId;
        this.country = country;
        this.countryIso = countryIso;
        this.typeName = typeName;
        this.origAsset = origAsset;
        this.origAssetSubno = origAssetSubno;
        this.origAcqDate = origAcqDate;
        this.origAcqYr = origAcqYr;
        this.origValue = origValue;
        this.currency = currency;
        this.currencyIso = currencyIso;
        this.inhouseProdPercentage = inhouseProdPercentage;
    }

    public static FixedAssetOriginBuilder builder() {
        return new FixedAssetOriginBuilder();
    }

    @Nullable
    public AccountNumberOfSupplier getVendorNo() {
        return this.vendorNo;
    }

    @Nullable
    public String getVendor() {
        return this.vendor;
    }

    @Nullable
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Nullable
    public ErpBoolean getPurchNew() {
        return this.purchNew;
    }

    @Nullable
    public Company getTradeId() {
        return this.tradeId;
    }

    @Nullable
    public CountryKey getCountry() {
        return this.country;
    }

    @Nullable
    public CountryIsoCode getCountryIso() {
        return this.countryIso;
    }

    @Nullable
    public TypeNameOfCommodity getTypeName() {
        return this.typeName;
    }

    @Nullable
    public MainAssetNumber getOrigAsset() {
        return this.origAsset;
    }

    @Nullable
    public AssetSubnumber getOrigAssetSubno() {
        return this.origAssetSubno;
    }

    @Nullable
    public LocalDate getOrigAcqDate() {
        return this.origAcqDate;
    }

    @Nullable
    public Year getOrigAcqYr() {
        return this.origAcqYr;
    }

    @Nullable
    public CurrencyAmountsInBapiInterfaces getOrigValue() {
        return this.origValue;
    }

    @Nullable
    public CurrencyKey getCurrency() {
        return this.currency;
    }

    @Nullable
    public IsoCodeCurrency getCurrencyIso() {
        return this.currencyIso;
    }

    @Nullable
    public PackedPercentageNnnNn getInhouseProdPercentage() {
        return this.inhouseProdPercentage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedAssetOrigin)) {
            return false;
        }
        FixedAssetOrigin other = (FixedAssetOrigin)o;
        AccountNumberOfSupplier this$vendorNo = this.getVendorNo();
        AccountNumberOfSupplier other$vendorNo = other.getVendorNo();
        if (this$vendorNo == null ? other$vendorNo != null : !((Object)((Object)this$vendorNo)).equals((Object)other$vendorNo)) {
            return false;
        }
        String this$vendor = this.getVendor();
        String other$vendor = other.getVendor();
        if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
            return false;
        }
        String this$manufacturer = this.getManufacturer();
        String other$manufacturer = other.getManufacturer();
        if (this$manufacturer == null ? other$manufacturer != null : !this$manufacturer.equals(other$manufacturer)) {
            return false;
        }
        ErpBoolean this$purchNew = this.getPurchNew();
        ErpBoolean other$purchNew = other.getPurchNew();
        if (this$purchNew == null ? other$purchNew != null : !this$purchNew.equals(other$purchNew)) {
            return false;
        }
        Company this$tradeId = this.getTradeId();
        Company other$tradeId = other.getTradeId();
        if (this$tradeId == null ? other$tradeId != null : !((Object)((Object)this$tradeId)).equals((Object)other$tradeId)) {
            return false;
        }
        CountryKey this$country = this.getCountry();
        CountryKey other$country = other.getCountry();
        if (this$country == null ? other$country != null : !((Object)((Object)this$country)).equals((Object)other$country)) {
            return false;
        }
        CountryIsoCode this$countryIso = this.getCountryIso();
        CountryIsoCode other$countryIso = other.getCountryIso();
        if (this$countryIso == null ? other$countryIso != null : !((Object)((Object)this$countryIso)).equals((Object)other$countryIso)) {
            return false;
        }
        TypeNameOfCommodity this$typeName = this.getTypeName();
        TypeNameOfCommodity other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !((Object)((Object)this$typeName)).equals((Object)other$typeName)) {
            return false;
        }
        MainAssetNumber this$origAsset = this.getOrigAsset();
        MainAssetNumber other$origAsset = other.getOrigAsset();
        if (this$origAsset == null ? other$origAsset != null : !((Object)((Object)this$origAsset)).equals((Object)other$origAsset)) {
            return false;
        }
        AssetSubnumber this$origAssetSubno = this.getOrigAssetSubno();
        AssetSubnumber other$origAssetSubno = other.getOrigAssetSubno();
        if (this$origAssetSubno == null ? other$origAssetSubno != null : !((Object)((Object)this$origAssetSubno)).equals((Object)other$origAssetSubno)) {
            return false;
        }
        LocalDate this$origAcqDate = this.getOrigAcqDate();
        LocalDate other$origAcqDate = other.getOrigAcqDate();
        if (this$origAcqDate == null ? other$origAcqDate != null : !this$origAcqDate.equals(other$origAcqDate)) {
            return false;
        }
        Year this$origAcqYr = this.getOrigAcqYr();
        Year other$origAcqYr = other.getOrigAcqYr();
        if (this$origAcqYr == null ? other$origAcqYr != null : !this$origAcqYr.equals(other$origAcqYr)) {
            return false;
        }
        CurrencyAmountsInBapiInterfaces this$origValue = this.getOrigValue();
        CurrencyAmountsInBapiInterfaces other$origValue = other.getOrigValue();
        if (this$origValue == null ? other$origValue != null : !((Object)this$origValue).equals(other$origValue)) {
            return false;
        }
        CurrencyKey this$currency = this.getCurrency();
        CurrencyKey other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !((Object)((Object)this$currency)).equals((Object)other$currency)) {
            return false;
        }
        IsoCodeCurrency this$currencyIso = this.getCurrencyIso();
        IsoCodeCurrency other$currencyIso = other.getCurrencyIso();
        if (this$currencyIso == null ? other$currencyIso != null : !((Object)((Object)this$currencyIso)).equals((Object)other$currencyIso)) {
            return false;
        }
        PackedPercentageNnnNn this$inhouseProdPercentage = this.getInhouseProdPercentage();
        PackedPercentageNnnNn other$inhouseProdPercentage = other.getInhouseProdPercentage();
        return !(this$inhouseProdPercentage == null ? other$inhouseProdPercentage != null : !((Object)this$inhouseProdPercentage).equals(other$inhouseProdPercentage));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccountNumberOfSupplier $vendorNo = this.getVendorNo();
        result = result * 59 + ($vendorNo == null ? 43 : ((Object)((Object)$vendorNo)).hashCode());
        String $vendor = this.getVendor();
        result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
        String $manufacturer = this.getManufacturer();
        result = result * 59 + ($manufacturer == null ? 43 : $manufacturer.hashCode());
        ErpBoolean $purchNew = this.getPurchNew();
        result = result * 59 + ($purchNew == null ? 43 : $purchNew.hashCode());
        Company $tradeId = this.getTradeId();
        result = result * 59 + ($tradeId == null ? 43 : ((Object)((Object)$tradeId)).hashCode());
        CountryKey $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : ((Object)((Object)$country)).hashCode());
        CountryIsoCode $countryIso = this.getCountryIso();
        result = result * 59 + ($countryIso == null ? 43 : ((Object)((Object)$countryIso)).hashCode());
        TypeNameOfCommodity $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : ((Object)((Object)$typeName)).hashCode());
        MainAssetNumber $origAsset = this.getOrigAsset();
        result = result * 59 + ($origAsset == null ? 43 : ((Object)((Object)$origAsset)).hashCode());
        AssetSubnumber $origAssetSubno = this.getOrigAssetSubno();
        result = result * 59 + ($origAssetSubno == null ? 43 : ((Object)((Object)$origAssetSubno)).hashCode());
        LocalDate $origAcqDate = this.getOrigAcqDate();
        result = result * 59 + ($origAcqDate == null ? 43 : $origAcqDate.hashCode());
        Year $origAcqYr = this.getOrigAcqYr();
        result = result * 59 + ($origAcqYr == null ? 43 : $origAcqYr.hashCode());
        CurrencyAmountsInBapiInterfaces $origValue = this.getOrigValue();
        result = result * 59 + ($origValue == null ? 43 : ((Object)$origValue).hashCode());
        CurrencyKey $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : ((Object)((Object)$currency)).hashCode());
        IsoCodeCurrency $currencyIso = this.getCurrencyIso();
        result = result * 59 + ($currencyIso == null ? 43 : ((Object)((Object)$currencyIso)).hashCode());
        PackedPercentageNnnNn $inhouseProdPercentage = this.getInhouseProdPercentage();
        result = result * 59 + ($inhouseProdPercentage == null ? 43 : ((Object)$inhouseProdPercentage).hashCode());
        return result;
    }

    public String toString() {
        return "FixedAssetOrigin(vendorNo=" + (Object)((Object)this.getVendorNo()) + ", vendor=" + this.getVendor() + ", manufacturer=" + this.getManufacturer() + ", purchNew=" + this.getPurchNew() + ", tradeId=" + (Object)((Object)this.getTradeId()) + ", country=" + (Object)((Object)this.getCountry()) + ", countryIso=" + (Object)((Object)this.getCountryIso()) + ", typeName=" + (Object)((Object)this.getTypeName()) + ", origAsset=" + (Object)((Object)this.getOrigAsset()) + ", origAssetSubno=" + (Object)((Object)this.getOrigAssetSubno()) + ", origAcqDate=" + this.getOrigAcqDate() + ", origAcqYr=" + this.getOrigAcqYr() + ", origValue=" + this.getOrigValue() + ", currency=" + (Object)((Object)this.getCurrency()) + ", currencyIso=" + (Object)((Object)this.getCurrencyIso()) + ", inhouseProdPercentage=" + this.getInhouseProdPercentage() + ")";
    }

    public static class FixedAssetOriginBuilder {
        private AccountNumberOfSupplier vendorNo;
        private String vendor;
        private String manufacturer;
        private ErpBoolean purchNew;
        private Company tradeId;
        private CountryKey country;
        private CountryIsoCode countryIso;
        private TypeNameOfCommodity typeName;
        private MainAssetNumber origAsset;
        private AssetSubnumber origAssetSubno;
        private LocalDate origAcqDate;
        private Year origAcqYr;
        private CurrencyAmountsInBapiInterfaces origValue;
        private CurrencyKey currency;
        private IsoCodeCurrency currencyIso;
        private PackedPercentageNnnNn inhouseProdPercentage;

        FixedAssetOriginBuilder() {
        }

        public FixedAssetOriginBuilder vendorNo(AccountNumberOfSupplier vendorNo) {
            this.vendorNo = vendorNo;
            return this;
        }

        public FixedAssetOriginBuilder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public FixedAssetOriginBuilder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public FixedAssetOriginBuilder purchNew(ErpBoolean purchNew) {
            this.purchNew = purchNew;
            return this;
        }

        public FixedAssetOriginBuilder tradeId(Company tradeId) {
            this.tradeId = tradeId;
            return this;
        }

        public FixedAssetOriginBuilder country(CountryKey country) {
            this.country = country;
            return this;
        }

        public FixedAssetOriginBuilder countryIso(CountryIsoCode countryIso) {
            this.countryIso = countryIso;
            return this;
        }

        public FixedAssetOriginBuilder typeName(TypeNameOfCommodity typeName) {
            this.typeName = typeName;
            return this;
        }

        public FixedAssetOriginBuilder origAsset(MainAssetNumber origAsset) {
            this.origAsset = origAsset;
            return this;
        }

        public FixedAssetOriginBuilder origAssetSubno(AssetSubnumber origAssetSubno) {
            this.origAssetSubno = origAssetSubno;
            return this;
        }

        public FixedAssetOriginBuilder origAcqDate(LocalDate origAcqDate) {
            this.origAcqDate = origAcqDate;
            return this;
        }

        public FixedAssetOriginBuilder origAcqYr(Year origAcqYr) {
            this.origAcqYr = origAcqYr;
            return this;
        }

        public FixedAssetOriginBuilder origValue(CurrencyAmountsInBapiInterfaces origValue) {
            this.origValue = origValue;
            return this;
        }

        public FixedAssetOriginBuilder currency(CurrencyKey currency) {
            this.currency = currency;
            return this;
        }

        public FixedAssetOriginBuilder currencyIso(IsoCodeCurrency currencyIso) {
            this.currencyIso = currencyIso;
            return this;
        }

        public FixedAssetOriginBuilder inhouseProdPercentage(PackedPercentageNnnNn inhouseProdPercentage) {
            this.inhouseProdPercentage = inhouseProdPercentage;
            return this;
        }

        public FixedAssetOrigin build() {
            return new FixedAssetOrigin(this.vendorNo, this.vendor, this.manufacturer, this.purchNew, this.tradeId, this.country, this.countryIso, this.typeName, this.origAsset, this.origAssetSubno, this.origAcqDate, this.origAcqYr, this.origValue, this.currency, this.currencyIso, this.inhouseProdPercentage);
        }

        public String toString() {
            return "FixedAssetOrigin.FixedAssetOriginBuilder(vendorNo=" + (Object)((Object)this.vendorNo) + ", vendor=" + this.vendor + ", manufacturer=" + this.manufacturer + ", purchNew=" + this.purchNew + ", tradeId=" + (Object)((Object)this.tradeId) + ", country=" + (Object)((Object)this.country) + ", countryIso=" + (Object)((Object)this.countryIso) + ", typeName=" + (Object)((Object)this.typeName) + ", origAsset=" + (Object)((Object)this.origAsset) + ", origAssetSubno=" + (Object)((Object)this.origAssetSubno) + ", origAcqDate=" + this.origAcqDate + ", origAcqYr=" + this.origAcqYr + ", origValue=" + this.origValue + ", currency=" + (Object)((Object)this.currency) + ", currencyIso=" + (Object)((Object)this.currencyIso) + ", inhouseProdPercentage=" + this.inhouseProdPercentage + ")";
        }
    }
}

