/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ChangeForexTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ChangeStructureForCashSettlementData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ChangeStructureForForexTransaction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureChangeInformationForChangeMethod;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureChangeInformationForFlow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureChangeInformationForPaymentDetail;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForCashSettlementData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForChangingTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForFlow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForPaymentDetail;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RefStructureForParameterExtensioninExtensionout;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.IndicatorIfTransferredDataIsComplete;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.Transaction;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;

public class ForeignExchangeDealChangeCommand {
    private final ChangeForexTransaction forex;
    private final ChangeStructureForForexTransaction forexx;
    private final FtrStructureForChangingTransactions generalcontractdata;
    private final FtrStructureChangeInformationForChangeMethod generalcontractdatax;
    private IndicatorIfTransferredDataIsComplete paydetCompleteIndicator = null;
    private IndicatorIfTransferredDataIsComplete addflowCompleteIndicator = null;
    private ErpBoolean testrun = null;
    private FtrStructureForCashSettlementData cashSettlement = null;
    private ChangeStructureForCashSettlementData cashSettlementX = null;
    private final CompanyCode companycode;
    private final Transaction financialtransaction;
    @NonNull
    private final Iterable<FtrStructureForPaymentDetail> paymentdetail;
    @NonNull
    private final Iterable<FtrStructureChangeInformationForPaymentDetail> paymentdetailx;
    @NonNull
    private final Iterable<FtrStructureForFlow> addflow;
    @NonNull
    private final Iterable<FtrStructureChangeInformationForFlow> addflowx;
    @NonNull
    private Iterable<RefStructureForParameterExtensioninExtensionout> extensionIn = Lists.newArrayList();

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        TableRow row;
        this.forex.validate();
        this.forexx.validate();
        this.generalcontractdata.validate();
        this.generalcontractdatax.validate();
        if (this.cashSettlement != null) {
            this.cashSettlement.validate();
        }
        if (this.cashSettlementX != null) {
            this.cashSettlementX.validate();
        }
        for (FtrStructureForPaymentDetail ftrStructureForPaymentDetail : this.paymentdetail) {
            ftrStructureForPaymentDetail.validate();
        }
        for (FtrStructureChangeInformationForPaymentDetail ftrStructureChangeInformationForPaymentDetail : this.paymentdetailx) {
            ftrStructureChangeInformationForPaymentDetail.validate();
        }
        for (FtrStructureForFlow ftrStructureForFlow : this.addflow) {
            ftrStructureForFlow.validate();
        }
        for (FtrStructureChangeInformationForFlow ftrStructureChangeInformationForFlow : this.addflowx) {
            ftrStructureChangeInformationForFlow.validate();
        }
        if (this.extensionIn != null) {
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extensionIn) {
                refStructureForParameterExtensioninExtensionout.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_FTR_FXT_DEALCHANGE");
        if (this.paydetCompleteIndicator != null) {
            query.withExporting("PAYDET_COMPLETE_INDICATOR", "TB_COMPLETE_INDICATOR", (ErpType)this.paydetCompleteIndicator);
        }
        if (this.addflowCompleteIndicator != null) {
            query.withExporting("ADDFLOW_COMPLETE_INDICATOR", "TB_COMPLETE_INDICATOR", (ErpType)this.addflowCompleteIndicator);
        }
        if (this.testrun != null) {
            query.withExporting("TESTRUN", "TESTRUN", (ErpType)this.testrun);
        }
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companycode);
        query.withExporting("FINANCIALTRANSACTION", "TB_RFHA", (ErpType)this.financialtransaction);
        ParameterFields parameterFields = query.withExportingFields("FOREX", "BAPI_FTR_CHANGE_FXT");
        if (this.forex.getBuyAmount() != null) {
            parameterFields.field("BUY_AMOUNT", "BAPITB_BZBETR", (ErpType)this.forex.getBuyAmount());
        }
        if (this.forex.getSellAmount() != null) {
            parameterFields.field("SELL_AMOUNT", "BAPITB_BZBETR", (ErpType)this.forex.getSellAmount());
        }
        if (this.forex.getValueDate() != null) {
            parameterFields.field("VALUE_DATE", "TB_DVALUTA", this.forex.getValueDate());
        }
        if (this.forex.getForwardRate() != null) {
            parameterFields.field("FORWARD_RATE", "TB_KKURS", (ErpType)this.forex.getForwardRate());
        }
        if (this.forex.getSpotRate() != null) {
            parameterFields.field("SPOT_RATE", "TB_KKASSA", (ErpType)this.forex.getSpotRate());
        }
        if (this.forex.getSwapRate() != null) {
            parameterFields.field("SWAP_RATE", "TB_KSWAP", (ErpType)this.forex.getSwapRate());
        }
        if (this.forex.getNdfFixingCurrency() != null) {
            parameterFields.field("NDF_FIXING_CURRENCY", "TB_WGSCHFT", (ErpType)this.forex.getNdfFixingCurrency());
        }
        if (this.forex.getNdfFixingCurrencyIso() != null) {
            parameterFields.field("NDF_FIXING_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getNdfFixingCurrencyIso());
        }
        if (this.forex.getNdfFixingDate() != null) {
            parameterFields.field("NDF_FIXING_DATE", "TB_DFIX", this.forex.getNdfFixingDate());
        }
        if (this.forex.getRolloverLiquidityEffect() != null) {
            parameterFields.field("ROLLOVER_LIQUIDITY_EFFECT", "TX_KWLIQ", (ErpType)this.forex.getRolloverLiquidityEffect());
        }
        parameterFields.end();
        ParameterFields parameterFields2 = query.withExportingFields("FOREXX", "BAPI_FTR_CHANGE_FXTX");
        if (this.forexx.getBuyAmount() != null) {
            parameterFields2.field("BUY_AMOUNT", "BAPIUPDATE", (ErpType)this.forexx.getBuyAmount());
        }
        if (this.forexx.getSellAmount() != null) {
            parameterFields2.field("SELL_AMOUNT", "BAPIUPDATE", (ErpType)this.forexx.getSellAmount());
        }
        if (this.forexx.getValueDate() != null) {
            parameterFields2.field("VALUE_DATE", "BAPIUPDATE", (ErpType)this.forexx.getValueDate());
        }
        if (this.forexx.getForwardRate() != null) {
            parameterFields2.field("FORWARD_RATE", "BAPIUPDATE", (ErpType)this.forexx.getForwardRate());
        }
        if (this.forexx.getSpotRate() != null) {
            parameterFields2.field("SPOT_RATE", "BAPIUPDATE", (ErpType)this.forexx.getSpotRate());
        }
        if (this.forexx.getSwapRate() != null) {
            parameterFields2.field("SWAP_RATE", "BAPIUPDATE", (ErpType)this.forexx.getSwapRate());
        }
        if (this.forexx.getNdfFixingCurrency() != null) {
            parameterFields2.field("NDF_FIXING_CURRENCY", "BAPIUPDATE", (ErpType)this.forexx.getNdfFixingCurrency());
        }
        if (this.forexx.getNdfFixingCurrencyIso() != null) {
            parameterFields2.field("NDF_FIXING_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.forexx.getNdfFixingCurrencyIso());
        }
        if (this.forexx.getNdfFixingDate() != null) {
            parameterFields2.field("NDF_FIXING_DATE", "BAPIUPDATE", (ErpType)this.forexx.getNdfFixingDate());
        }
        if (this.forexx.getRolloverLiquidityEffect() != null) {
            parameterFields2.field("ROLLOVER_LIQUIDITY_EFFECT", "BAPIUPDATE", (ErpType)this.forexx.getRolloverLiquidityEffect());
        }
        parameterFields2.end();
        ParameterFields parameterFields3 = query.withExportingFields("GENERALCONTRACTDATA", "BAPI_FTR_CHANGE");
        if (this.generalcontractdata.getContractDate() != null) {
            parameterFields3.field("CONTRACT_DATE", "TB_DVTRAB", this.generalcontractdata.getContractDate());
        }
        if (this.generalcontractdata.getContractTime() != null) {
            parameterFields3.field("CONTRACT_TIME", "TB_TVTRAB", this.generalcontractdata.getContractTime());
        }
        if (this.generalcontractdata.getContactPerson() != null) {
            parameterFields3.field("CONTACT_PERSON", "TB_GSPPART", this.generalcontractdata.getContactPerson());
        }
        if (this.generalcontractdata.getTrader() != null) {
            parameterFields3.field("TRADER", "RDEALER", (ErpType)this.generalcontractdata.getTrader());
        }
        if (this.generalcontractdata.getAcctAssignmentRef() != null) {
            parameterFields3.field("ACCT_ASSIGNMENT_REF", "RREFKONT_OBSOLETE", (ErpType)this.generalcontractdata.getAcctAssignmentRef());
        }
        if (this.generalcontractdata.getPortfolio() != null) {
            parameterFields3.field("PORTFOLIO", "RPORTB", (ErpType)this.generalcontractdata.getPortfolio());
        }
        if (this.generalcontractdata.getFinanceProject() != null) {
            parameterFields3.field("FINANCE_PROJECT", "TB_TFPROJ", (ErpType)this.generalcontractdata.getFinanceProject());
        }
        if (this.generalcontractdata.getGuarantor() != null) {
            parameterFields3.field("GUARANTOR", "TB_RGARANT_NEW", (ErpType)this.generalcontractdata.getGuarantor());
        }
        if (this.generalcontractdata.getAssignment() != null) {
            parameterFields3.field("ASSIGNMENT", "TB_ZUOND", this.generalcontractdata.getAssignment());
        }
        if (this.generalcontractdata.getExternalReference() != null) {
            parameterFields3.field("EXTERNAL_REFERENCE", "TB_NORDEXT", (ErpType)this.generalcontractdata.getExternalReference());
        }
        if (this.generalcontractdata.getInternalReference() != null) {
            parameterFields3.field("INTERNAL_REFERENCE", "TB_REFER", this.generalcontractdata.getInternalReference());
        }
        if (this.generalcontractdata.getCharacteristics() != null) {
            parameterFields3.field("CHARACTERISTICS", "TB_MERKM", this.generalcontractdata.getCharacteristics());
        }
        if (this.generalcontractdata.getAuthGroup() != null) {
            parameterFields3.field("AUTH_GROUP", "TBEGRU", (ErpType)this.generalcontractdata.getAuthGroup());
        }
        if (this.generalcontractdata.getFacility() != null) {
            parameterFields3.field("FACILITY", "TB_FACILITYNR", (ErpType)this.generalcontractdata.getFacility());
        }
        if (this.generalcontractdata.getFacilityCompanyCode() != null) {
            parameterFields3.field("FACILITY_COMPANY_CODE", "TB_FACILITYBUKRS", (ErpType)this.generalcontractdata.getFacilityCompanyCode());
        }
        if (this.generalcontractdata.getValuationClass() != null) {
            parameterFields3.field("VALUATION_CLASS", "TPM_COM_VAL_CLASS", (ErpType)this.generalcontractdata.getValuationClass());
        }
        if (this.generalcontractdata.getFund() != null) {
            parameterFields3.field("FUND", "FM_FUND", (ErpType)this.generalcontractdata.getFund());
        }
        if (this.generalcontractdata.getGrantNbr() != null) {
            parameterFields3.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)this.generalcontractdata.getGrantNbr());
        }
        if (this.generalcontractdata.getExpenseKey() != null) {
            parameterFields3.field("EXPENSE_KEY", "TB_SPESEN", (ErpType)this.generalcontractdata.getExpenseKey());
        }
        if (this.generalcontractdata.getReservReason() != null) {
            parameterFields3.field("RESERV_REASON", "TB_SANST", (ErpType)this.generalcontractdata.getReservReason());
        }
        if (this.generalcontractdata.getClearingOption() != null) {
            parameterFields3.field("CLEARING_OPTION", "TPM_TREA_CLEARING_OPT", (ErpType)this.generalcontractdata.getClearingOption());
        }
        if (this.generalcontractdata.getClearingStatus() != null) {
            parameterFields3.field("CLEARING_STATUS", "TPM_TREA_CLEARING_STATUS", (ErpType)this.generalcontractdata.getClearingStatus());
        }
        if (this.generalcontractdata.getClearingDate() != null) {
            parameterFields3.field("CLEARING_DATE", "TPM_TREA_CLEARING_DATE", this.generalcontractdata.getClearingDate());
        }
        if (this.generalcontractdata.getExtAccount() != null) {
            parameterFields3.field("EXT_ACCOUNT", "TPM_EXT_ACCOUNT", (ErpType)this.generalcontractdata.getExtAccount());
        }
        if (this.generalcontractdata.getClearDateAct() != null) {
            parameterFields3.field("CLEAR_DATE_ACT", "TPM_TREA_CLEARING_DATE_ACT", this.generalcontractdata.getClearDateAct());
        }
        if (this.generalcontractdata.getRiskMitigation() != null) {
            parameterFields3.field("RISK_MITIGATION", "FTR_THRESHOLD_RISK_MITIGATING", (ErpType)this.generalcontractdata.getRiskMitigation());
        }
        if (this.generalcontractdata.getLegalBasis() != null) {
            parameterFields3.field("LEGAL_BASIS", "FTR_THRESHOLD_SCHEME", (ErpType)this.generalcontractdata.getLegalBasis());
        }
        if (this.generalcontractdata.getExternalTradeId() != null) {
            parameterFields3.field("EXTERNAL_TRADE_ID", "FTR_TARO_TRADE_ID", (ErpType)this.generalcontractdata.getExternalTradeId());
        }
        if (this.generalcontractdata.getProfitCenter() != null) {
            parameterFields3.field("PROFIT_CENTER", "PRCTR", (ErpType)this.generalcontractdata.getProfitCenter());
        }
        if (this.generalcontractdata.getCostCenter() != null) {
            parameterFields3.field("COST_CENTER", "KOSTL", (ErpType)this.generalcontractdata.getCostCenter());
        }
        if (this.generalcontractdata.getWbsElement() != null) {
            parameterFields3.field("WBS_ELEMENT", "PS_PSP_PNR", (ErpType)this.generalcontractdata.getWbsElement());
        }
        if (this.generalcontractdata.getBusinessArea() != null) {
            parameterFields3.field("BUSINESS_AREA", "GSBER", (ErpType)this.generalcontractdata.getBusinessArea());
        }
        if (this.generalcontractdata.getHedgeClassification() != null) {
            parameterFields3.field("HEDGE_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION_OLD", (ErpType)this.generalcontractdata.getHedgeClassification());
        }
        if (this.generalcontractdata.getInitClassifier() != null) {
            parameterFields3.field("INIT_CLASSIFIER", "TRPA_INITIAL_STAGE", (ErpType)this.generalcontractdata.getInitClassifier());
        }
        if (this.generalcontractdata.getCountry() != null) {
            parameterFields3.field("COUNTRY", "LAND1", (ErpType)this.generalcontractdata.getCountry());
        }
        if (this.generalcontractdata.getCountryIso() != null) {
            parameterFields3.field("COUNTRY_ISO", "INTCA", (ErpType)this.generalcontractdata.getCountryIso());
        }
        if (this.generalcontractdata.getSegment() != null) {
            parameterFields3.field("SEGMENT", "FB_SEGMENT", (ErpType)this.generalcontractdata.getSegment());
        }
        if (this.generalcontractdata.getOnBehalfOfCompany() != null) {
            parameterFields3.field("ON_BEHALF_OF_COMPANY", "TRBA_BEHALF_OF_COMPANY", (ErpType)this.generalcontractdata.getOnBehalfOfCompany());
        }
        if (this.generalcontractdata.getHedgingClassification() != null) {
            parameterFields3.field("HEDGING_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION", (ErpType)this.generalcontractdata.getHedgingClassification());
        }
        if (this.generalcontractdata.getHedgeRequestId() != null) {
            parameterFields3.field("HEDGE_REQUEST_ID", "TOE_REQUEST_ID", (ErpType)this.generalcontractdata.getHedgeRequestId());
        }
        parameterFields3.end();
        ParameterFields parameterFields4 = query.withExportingFields("GENERALCONTRACTDATAX", "BAPI_FTR_CHANGEX");
        if (this.generalcontractdatax.getContractDate() != null) {
            parameterFields4.field("CONTRACT_DATE", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getContractDate());
        }
        if (this.generalcontractdatax.getContractTime() != null) {
            parameterFields4.field("CONTRACT_TIME", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getContractTime());
        }
        if (this.generalcontractdatax.getContactPerson() != null) {
            parameterFields4.field("CONTACT_PERSON", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getContactPerson());
        }
        if (this.generalcontractdatax.getTrader() != null) {
            parameterFields4.field("TRADER", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getTrader());
        }
        if (this.generalcontractdatax.getAcctAssignmentRef() != null) {
            parameterFields4.field("ACCT_ASSIGNMENT_REF", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getAcctAssignmentRef());
        }
        if (this.generalcontractdatax.getPortfolio() != null) {
            parameterFields4.field("PORTFOLIO", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getPortfolio());
        }
        if (this.generalcontractdatax.getFinanceProject() != null) {
            parameterFields4.field("FINANCE_PROJECT", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getFinanceProject());
        }
        if (this.generalcontractdatax.getGuarantor() != null) {
            parameterFields4.field("GUARANTOR", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getGuarantor());
        }
        if (this.generalcontractdatax.getAssignment() != null) {
            parameterFields4.field("ASSIGNMENT", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getAssignment());
        }
        if (this.generalcontractdatax.getExternalReference() != null) {
            parameterFields4.field("EXTERNAL_REFERENCE", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getExternalReference());
        }
        if (this.generalcontractdatax.getInternalReference() != null) {
            parameterFields4.field("INTERNAL_REFERENCE", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getInternalReference());
        }
        if (this.generalcontractdatax.getCharacteristics() != null) {
            parameterFields4.field("CHARACTERISTICS", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getCharacteristics());
        }
        if (this.generalcontractdatax.getAuthGroup() != null) {
            parameterFields4.field("AUTH_GROUP", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getAuthGroup());
        }
        if (this.generalcontractdatax.getFacility() != null) {
            parameterFields4.field("FACILITY", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getFacility());
        }
        if (this.generalcontractdatax.getFacilityCompanyCode() != null) {
            parameterFields4.field("FACILITY_COMPANY_CODE", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getFacilityCompanyCode());
        }
        if (this.generalcontractdatax.getValuationClass() != null) {
            parameterFields4.field("VALUATION_CLASS", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getValuationClass());
        }
        if (this.generalcontractdatax.getFund() != null) {
            parameterFields4.field("FUND", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getFund());
        }
        if (this.generalcontractdatax.getGrantNbr() != null) {
            parameterFields4.field("GRANT_NBR", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getGrantNbr());
        }
        if (this.generalcontractdatax.getExpenseKey() != null) {
            parameterFields4.field("EXPENSE_KEY", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getExpenseKey());
        }
        if (this.generalcontractdatax.getReservReason() != null) {
            parameterFields4.field("RESERV_REASON", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getReservReason());
        }
        if (this.generalcontractdatax.getClearingOption() != null) {
            parameterFields4.field("CLEARING_OPTION", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getClearingOption());
        }
        if (this.generalcontractdatax.getClearingStatus() != null) {
            parameterFields4.field("CLEARING_STATUS", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getClearingStatus());
        }
        if (this.generalcontractdatax.getClearingDate() != null) {
            parameterFields4.field("CLEARING_DATE", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getClearingDate());
        }
        if (this.generalcontractdatax.getExtAccount() != null) {
            parameterFields4.field("EXT_ACCOUNT", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getExtAccount());
        }
        if (this.generalcontractdatax.getClearDateAct() != null) {
            parameterFields4.field("CLEAR_DATE_ACT", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getClearDateAct());
        }
        if (this.generalcontractdatax.getRiskMitigation() != null) {
            parameterFields4.field("RISK_MITIGATION", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getRiskMitigation());
        }
        if (this.generalcontractdatax.getLegalBasis() != null) {
            parameterFields4.field("LEGAL_BASIS", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getLegalBasis());
        }
        if (this.generalcontractdatax.getExternalTradeId() != null) {
            parameterFields4.field("EXTERNAL_TRADE_ID", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getExternalTradeId());
        }
        if (this.generalcontractdatax.getProfitCenter() != null) {
            parameterFields4.field("PROFIT_CENTER", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getProfitCenter());
        }
        if (this.generalcontractdatax.getCostCenter() != null) {
            parameterFields4.field("COST_CENTER", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getCostCenter());
        }
        if (this.generalcontractdatax.getWbsElement() != null) {
            parameterFields4.field("WBS_ELEMENT", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getWbsElement());
        }
        if (this.generalcontractdatax.getBusinessArea() != null) {
            parameterFields4.field("BUSINESS_AREA", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getBusinessArea());
        }
        if (this.generalcontractdatax.getHedgeClassification() != null) {
            parameterFields4.field("HEDGE_CLASSIFICATION", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getHedgeClassification());
        }
        if (this.generalcontractdatax.getInitClassifier() != null) {
            parameterFields4.field("INIT_CLASSIFIER", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getInitClassifier());
        }
        if (this.generalcontractdatax.getCountry() != null) {
            parameterFields4.field("COUNTRY", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getCountry());
        }
        if (this.generalcontractdatax.getCountryIso() != null) {
            parameterFields4.field("COUNTRY_ISO", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getCountryIso());
        }
        if (this.generalcontractdatax.getSegment() != null) {
            parameterFields4.field("SEGMENT", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getSegment());
        }
        if (this.generalcontractdatax.getOnBehalfOfCompany() != null) {
            parameterFields4.field("ON_BEHALF_OF_COMPANY", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getOnBehalfOfCompany());
        }
        if (this.generalcontractdatax.getHedgingClassification() != null) {
            parameterFields4.field("HEDGING_CLASSIFICATION", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getHedgingClassification());
        }
        if (this.generalcontractdatax.getHedgeRequestId() != null) {
            parameterFields4.field("HEDGE_REQUEST_ID", "BAPIUPDATE", (ErpType)this.generalcontractdatax.getHedgeRequestId());
        }
        parameterFields4.end();
        if (this.cashSettlement != null) {
            ParameterFields parameterFields5 = query.withExportingFields("CASHSETTLEMENT", "BAPI_FTR_CASH_SETTLEMENT");
            if (this.cashSettlement.getCashSettlementRate() != null) {
                parameterFields5.field("CASH_SETTLEMENT_RATE", "TB_KKURS", (ErpType)this.cashSettlement.getCashSettlementRate());
            }
            if (this.cashSettlement.getCashSettlementDate() != null) {
                parameterFields5.field("CASH_SETTLEMENT_DATE", "TB_DZTERM", this.cashSettlement.getCashSettlementDate());
            }
            if (this.cashSettlement.getCashSettlementAmount() != null) {
                parameterFields5.field("CASH_SETTLEMENT_AMOUNT", "BAPITB_BZBETR", (ErpType)this.cashSettlement.getCashSettlementAmount());
            }
            if (this.cashSettlement.getCashSettlementCurrency() != null) {
                parameterFields5.field("CASH_SETTLEMENT_CURRENCY", "TB_WZBETR", (ErpType)this.cashSettlement.getCashSettlementCurrency());
            }
            if (this.cashSettlement.getCashSettlementCurrencyIso() != null) {
                parameterFields5.field("CASH_SETTLEMENT_CURRENCY_ISO", "ISOCD", (ErpType)this.cashSettlement.getCashSettlementCurrencyIso());
            }
            if (this.cashSettlement.getCashSettlementDirection() != null) {
                parameterFields5.field("CASH_SETTLEMENT_DIRECTION", "TB_SSIGN", (ErpType)this.cashSettlement.getCashSettlementDirection());
            }
            if (this.cashSettlement.getNdfFixingRate() != null) {
                parameterFields5.field("NDF_FIXING_RATE", "TB_KKURS", (ErpType)this.cashSettlement.getNdfFixingRate());
            }
            if (this.cashSettlement.getNdfFixingBuyAmount() != null) {
                parameterFields5.field("NDF_FIXING_BUY_AMOUNT", "BAPITB_BZBETR", (ErpType)this.cashSettlement.getNdfFixingBuyAmount());
            }
            if (this.cashSettlement.getNdfFixingBuyCurrency() != null) {
                parameterFields5.field("NDF_FIXING_BUY_CURRENCY", "TB_WZBETR", (ErpType)this.cashSettlement.getNdfFixingBuyCurrency());
            }
            if (this.cashSettlement.getNdfFixingBuyCurrencyIso() != null) {
                parameterFields5.field("NDF_FIXING_BUY_CURRENCY_ISO", "ISOCD", (ErpType)this.cashSettlement.getNdfFixingBuyCurrencyIso());
            }
            if (this.cashSettlement.getNdfFixingSellAmount() != null) {
                parameterFields5.field("NDF_FIXING_SELL_AMOUNT", "BAPITB_BZBETR", (ErpType)this.cashSettlement.getNdfFixingSellAmount());
            }
            if (this.cashSettlement.getNdfFixingSellCurrency() != null) {
                parameterFields5.field("NDF_FIXING_SELL_CURRENCY", "TB_WZBETR", (ErpType)this.cashSettlement.getNdfFixingSellCurrency());
            }
            if (this.cashSettlement.getNdfFixingSellCurrencyIso() != null) {
                parameterFields5.field("NDF_FIXING_SELL_CURRENCY_ISO", "ISOCD", (ErpType)this.cashSettlement.getNdfFixingSellCurrencyIso());
            }
            parameterFields5.end();
        }
        if (this.cashSettlementX != null) {
            ParameterFields parameterFields6 = query.withExportingFields("CASHSETTLEMENTX", "BAPI_FTR_CASH_SETTLEMENTX");
            if (this.cashSettlementX.getCashSettlementRate() != null) {
                parameterFields6.field("CASH_SETTLEMENT_RATE", "BAPIUPDATE", (ErpType)this.cashSettlementX.getCashSettlementRate());
            }
            if (this.cashSettlementX.getCashSettlementDate() != null) {
                parameterFields6.field("CASH_SETTLEMENT_DATE", "BAPIUPDATE", (ErpType)this.cashSettlementX.getCashSettlementDate());
            }
            if (this.cashSettlementX.getCashSettlementAmount() != null) {
                parameterFields6.field("CASH_SETTLEMENT_AMOUNT", "BAPIUPDATE", (ErpType)this.cashSettlementX.getCashSettlementAmount());
            }
            if (this.cashSettlementX.getCashSettlementCurrency() != null) {
                parameterFields6.field("CASH_SETTLEMENT_CURRENCY", "BAPIUPDATE", (ErpType)this.cashSettlementX.getCashSettlementCurrency());
            }
            if (this.cashSettlementX.getCashSettlementCurrencyIso() != null) {
                parameterFields6.field("CASH_SETTLEMENT_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.cashSettlementX.getCashSettlementCurrencyIso());
            }
            if (this.cashSettlementX.getCashSettlementDirection() != null) {
                parameterFields6.field("CASH_SETTLEMENT_DIRECTION", "BAPIUPDATE", (ErpType)this.cashSettlementX.getCashSettlementDirection());
            }
            if (this.cashSettlementX.getNdfFixingRate() != null) {
                parameterFields6.field("NDF_FIXING_RATE", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingRate());
            }
            if (this.cashSettlementX.getNdfFixingBuyAmount() != null) {
                parameterFields6.field("NDF_FIXING_BUY_AMOUNT", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingBuyAmount());
            }
            if (this.cashSettlementX.getNdfFixingBuyCurrency() != null) {
                parameterFields6.field("NDF_FIXING_BUY_CURRENCY", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingBuyCurrency());
            }
            if (this.cashSettlementX.getNdfFixingBuyCurrencyIso() != null) {
                parameterFields6.field("NDF_FIXING_BUY_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingBuyCurrencyIso());
            }
            if (this.cashSettlementX.getNdfFixingSellAmount() != null) {
                parameterFields6.field("NDF_FIXING_SELL_AMOUNT", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingSellAmount());
            }
            if (this.cashSettlementX.getNdfFixingSellCurrency() != null) {
                parameterFields6.field("NDF_FIXING_SELL_CURRENCY", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingSellCurrency());
            }
            if (this.cashSettlementX.getNdfFixingSellCurrencyIso() != null) {
                parameterFields6.field("NDF_FIXING_SELL_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.cashSettlementX.getNdfFixingSellCurrencyIso());
            }
            parameterFields6.end();
        }
        if (this.paymentdetail.iterator().hasNext()) {
            Table table = query.withTable("PAYMENTDETAIL", "BAPI_FTR_PAYDET");
            for (FtrStructureForPaymentDetail ftrStructureForPaymentDetail : this.paymentdetail) {
                row = table.row();
                if (ftrStructureForPaymentDetail.getTableindex() != null) {
                    row.field("TABLEINDEX", "TB_TABLEINDEX", (ErpType)ftrStructureForPaymentDetail.getTableindex());
                }
                if (ftrStructureForPaymentDetail.getDirection() != null) {
                    row.field("DIRECTION", "TB_SSIGN", (ErpType)ftrStructureForPaymentDetail.getDirection());
                }
                if (ftrStructureForPaymentDetail.getPaymentCurrency() != null) {
                    row.field("PAYMENT_CURRENCY", "WAERS", (ErpType)ftrStructureForPaymentDetail.getPaymentCurrency());
                }
                if (ftrStructureForPaymentDetail.getPaymentCurrencyIso() != null) {
                    row.field("PAYMENT_CURRENCY_ISO", "ISOCD", (ErpType)ftrStructureForPaymentDetail.getPaymentCurrencyIso());
                }
                if (ftrStructureForPaymentDetail.getEffectiveDate() != null) {
                    row.field("EFFECTIVE_DATE", "TB_DZVERB", ftrStructureForPaymentDetail.getEffectiveDate());
                }
                if (ftrStructureForPaymentDetail.getFlowType() != null) {
                    row.field("FLOW_TYPE", "SBEWART", (ErpType)ftrStructureForPaymentDetail.getFlowType());
                }
                if (ftrStructureForPaymentDetail.getHouseBank() != null) {
                    row.field("HOUSE_BANK", "HBKID", (ErpType)ftrStructureForPaymentDetail.getHouseBank());
                }
                if (ftrStructureForPaymentDetail.getAccountId() != null) {
                    row.field("ACCOUNT_ID", "HKTID", (ErpType)ftrStructureForPaymentDetail.getAccountId());
                }
                if (ftrStructureForPaymentDetail.getPaymentActivity() != null) {
                    row.field("PAYMENT_ACTIVITY", "TB_SZART", (ErpType)ftrStructureForPaymentDetail.getPaymentActivity());
                }
                if (ftrStructureForPaymentDetail.getPaymentRequest() != null) {
                    row.field("PAYMENT_REQUEST", "TB_SPAYRQK", (ErpType)ftrStructureForPaymentDetail.getPaymentRequest());
                }
                if (ftrStructureForPaymentDetail.getPayer() != null) {
                    row.field("PAYER", "TB_RPZAHL_NEW", (ErpType)ftrStructureForPaymentDetail.getPayer());
                }
                if (ftrStructureForPaymentDetail.getPartnerBank() != null) {
                    row.field("PARTNER_BANK", "TB_RPBANK", (ErpType)ftrStructureForPaymentDetail.getPartnerBank());
                }
                if (ftrStructureForPaymentDetail.getPaymentMethod() != null) {
                    row.field("PAYMENT_METHOD", "DZLSCH", (ErpType)ftrStructureForPaymentDetail.getPaymentMethod());
                }
                if (ftrStructureForPaymentDetail.getPaymentMethodSuppl() != null) {
                    row.field("PAYMENT_METHOD_SUPPL", "UZAWE", (ErpType)ftrStructureForPaymentDetail.getPaymentMethodSuppl());
                }
                if (ftrStructureForPaymentDetail.getDetGroupDefinition() != null) {
                    row.field("DET_GROUP_DEFINITION", "TB_SPRGRD", (ErpType)ftrStructureForPaymentDetail.getDetGroupDefinition());
                }
                if (ftrStructureForPaymentDetail.getIndividualPayment() != null) {
                    row.field("INDIVIDUAL_PAYMENT", "TB_SPRSNGK", (ErpType)ftrStructureForPaymentDetail.getIndividualPayment());
                }
                if (ftrStructureForPaymentDetail.getEqualDirection() != null) {
                    row.field("EQUAL_DIRECTION", "TB_SCSPAY", (ErpType)ftrStructureForPaymentDetail.getEqualDirection());
                }
                if (ftrStructureForPaymentDetail.getConsideredPaymntMeth() != null) {
                    row.field("CONSIDERED_PAYMNT_METH", "DZWELS", (ErpType)ftrStructureForPaymentDetail.getConsideredPaymntMeth());
                }
                if (ftrStructureForPaymentDetail.getPayerTransaction() != null) {
                    row.field("PAYER_TRANSACTION", "TB_RPZAHL_NEW", (ErpType)ftrStructureForPaymentDetail.getPayerTransaction());
                }
                if (ftrStructureForPaymentDetail.getAlternativePayerTrans() != null) {
                    row.field("ALTERNATIVE_PAYER_TRANS", "TB_RPZAHLA", (ErpType)ftrStructureForPaymentDetail.getAlternativePayerTrans());
                }
                if (ftrStructureForPaymentDetail.getRepetitiveCode() != null) {
                    row.field("REPETITIVE_CODE", "RPCODE", (ErpType)ftrStructureForPaymentDetail.getRepetitiveCode());
                }
                if (ftrStructureForPaymentDetail.getRepetitiveCodeText() != null) {
                    row.field("REPETITIVE_CODE_TEXT", "RPCODE_TEXT", ftrStructureForPaymentDetail.getRepetitiveCodeText());
                }
                if (ftrStructureForPaymentDetail.getScbankInd() != null) {
                    row.field("SCBANK_IND", "LZBKZ", (ErpType)ftrStructureForPaymentDetail.getScbankInd());
                }
                if (ftrStructureForPaymentDetail.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "LANDL", (ErpType)ftrStructureForPaymentDetail.getSupcountry());
                }
                if (ftrStructureForPaymentDetail.getBankAccount() != null) {
                    row.field("BANK_ACCOUNT", "BANKN", (ErpType)ftrStructureForPaymentDetail.getBankAccount());
                }
                if (ftrStructureForPaymentDetail.getBankControlKey() != null) {
                    row.field("BANK_CONTROL_KEY", "BKONT", (ErpType)ftrStructureForPaymentDetail.getBankControlKey());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCurrency() != null) {
                    row.field("BANK_ACCOUNT_CURRENCY", "WAERS", (ErpType)ftrStructureForPaymentDetail.getBankAccountCurrency());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCurrencyIso() != null) {
                    row.field("BANK_ACCOUNT_CURRENCY_ISO", "ISOCD", (ErpType)ftrStructureForPaymentDetail.getBankAccountCurrencyIso());
                }
                if (ftrStructureForPaymentDetail.getBankAccountName() != null) {
                    row.field("BANK_ACCOUNT_NAME", "TEXT1", ftrStructureForPaymentDetail.getBankAccountName());
                }
                if (ftrStructureForPaymentDetail.getBankAccount2() != null) {
                    row.field("BANK_ACCOUNT_2", "BNKN2_BF", ftrStructureForPaymentDetail.getBankAccount2());
                }
                if (ftrStructureForPaymentDetail.getBankAccountGlAccount() != null) {
                    row.field("BANK_ACCOUNT_GL_ACCOUNT", "HKONT", (ErpType)ftrStructureForPaymentDetail.getBankAccountGlAccount());
                }
                if (ftrStructureForPaymentDetail.getBankAccountBankref() != null) {
                    row.field("BANK_ACCOUNT_BANKREF", "REFZL", ftrStructureForPaymentDetail.getBankAccountBankref());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCountry() != null) {
                    row.field("BANK_ACCOUNT_COUNTRY", "BANKS", (ErpType)ftrStructureForPaymentDetail.getBankAccountCountry());
                }
                if (ftrStructureForPaymentDetail.getBankAccountCountryIso() != null) {
                    row.field("BANK_ACCOUNT_COUNTRY_ISO", "INTCA", (ErpType)ftrStructureForPaymentDetail.getBankAccountCountryIso());
                }
                if (ftrStructureForPaymentDetail.getBankAccountBankKey() != null) {
                    row.field("BANK_ACCOUNT_BANK_KEY", "BANKK", (ErpType)ftrStructureForPaymentDetail.getBankAccountBankKey());
                }
                if (ftrStructureForPaymentDetail.getSepaMandateId() == null) continue;
                row.field("SEPA_MANDATE_ID", "SEPA_MNDID", (ErpType)ftrStructureForPaymentDetail.getSepaMandateId());
            }
            table.end();
        }
        if (this.paymentdetailx.iterator().hasNext()) {
            Table table = query.withTable("PAYMENTDETAILX", "BAPI_FTR_PAYDETX");
            for (FtrStructureChangeInformationForPaymentDetail ftrStructureChangeInformationForPaymentDetail : this.paymentdetailx) {
                row = table.row();
                if (ftrStructureChangeInformationForPaymentDetail.getTableindex() != null) {
                    row.field("TABLEINDEX", "TB_TABLEINDEX", (ErpType)ftrStructureChangeInformationForPaymentDetail.getTableindex());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getDirection() != null) {
                    row.field("DIRECTION", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getDirection());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPaymentCurrency() != null) {
                    row.field("PAYMENT_CURRENCY", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPaymentCurrency());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPaymentCurrencyIso() != null) {
                    row.field("PAYMENT_CURRENCY_ISO", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPaymentCurrencyIso());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getEffectiveDate() != null) {
                    row.field("EFFECTIVE_DATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getEffectiveDate());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getFlowType() != null) {
                    row.field("FLOW_TYPE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getFlowType());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getHouseBank() != null) {
                    row.field("HOUSE_BANK", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getHouseBank());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getAccountId() != null) {
                    row.field("ACCOUNT_ID", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getAccountId());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPaymentActivity() != null) {
                    row.field("PAYMENT_ACTIVITY", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPaymentActivity());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPaymentRequest() != null) {
                    row.field("PAYMENT_REQUEST", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPaymentRequest());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPayer() != null) {
                    row.field("PAYER", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPayer());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPartnerBank() != null) {
                    row.field("PARTNER_BANK", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPartnerBank());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPaymentMethod() != null) {
                    row.field("PAYMENT_METHOD", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPaymentMethod());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getPaymentMethodSuppl() != null) {
                    row.field("PAYMENT_METHOD_SUPPL", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getPaymentMethodSuppl());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getDetGroupDefinition() != null) {
                    row.field("DET_GROUP_DEFINITION", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getDetGroupDefinition());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getIndividualPayment() != null) {
                    row.field("INDIVIDUAL_PAYMENT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getIndividualPayment());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getEqualDirection() != null) {
                    row.field("EQUAL_DIRECTION", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getEqualDirection());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getConsideredPaymntMeth() != null) {
                    row.field("CONSIDERED_PAYMNT_METH", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getConsideredPaymntMeth());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getRepetitiveCode() != null) {
                    row.field("REPETITIVE_CODE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getRepetitiveCode());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getScbankInd() != null) {
                    row.field("SCBANK_IND", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getScbankInd());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getSupcountry());
                }
                if (ftrStructureChangeInformationForPaymentDetail.getSepaMandateId() == null) continue;
                row.field("SEPA_MANDATE_ID", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForPaymentDetail.getSepaMandateId());
            }
            table.end();
        }
        if (this.addflow.iterator().hasNext()) {
            Table table = query.withTable("ADDFLOW", "BAPI_FTR_FLOW");
            for (FtrStructureForFlow ftrStructureForFlow : this.addflow) {
                row = table.row();
                if (ftrStructureForFlow.getTableindex() != null) {
                    row.field("TABLEINDEX", "TB_TABLEINDEX", (ErpType)ftrStructureForFlow.getTableindex());
                }
                if (ftrStructureForFlow.getFlowKey() != null) {
                    row.field("FLOW_KEY", "TB_BAPI_FLOW_KEY", (ErpType)ftrStructureForFlow.getFlowKey());
                }
                if (ftrStructureForFlow.getFlowSide() != null) {
                    row.field("FLOW_SIDE", "TB_RKONDGR", (ErpType)ftrStructureForFlow.getFlowSide());
                }
                if (ftrStructureForFlow.getFlowType() != null) {
                    row.field("FLOW_TYPE", "TB_SFHAZBA", (ErpType)ftrStructureForFlow.getFlowType());
                }
                if (ftrStructureForFlow.getFlowSign() != null) {
                    row.field("FLOW_SIGN", "TB_SSIGN", (ErpType)ftrStructureForFlow.getFlowSign());
                }
                if (ftrStructureForFlow.getPaymentDate() != null) {
                    row.field("PAYMENT_DATE", "TB_DZTERM", ftrStructureForFlow.getPaymentDate());
                }
                if (ftrStructureForFlow.getPaymentAmount() != null) {
                    row.field("PAYMENT_AMOUNT", "BAPITB_BZBETR", (ErpType)ftrStructureForFlow.getPaymentAmount());
                }
                if (ftrStructureForFlow.getPaymentAmountChar() != null) {
                    row.field("PAYMENT_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getPaymentAmountChar());
                }
                if (ftrStructureForFlow.getPaymentCur() != null) {
                    row.field("PAYMENT_CUR", "TB_WZBETR", (ErpType)ftrStructureForFlow.getPaymentCur());
                }
                if (ftrStructureForFlow.getPaymentCurIso() != null) {
                    row.field("PAYMENT_CUR_ISO", "ISOCD", (ErpType)ftrStructureForFlow.getPaymentCurIso());
                }
                if (ftrStructureForFlow.getLocalCurRate() != null) {
                    row.field("LOCAL_CUR_RATE", "TB_KHWKURS", (ErpType)ftrStructureForFlow.getLocalCurRate());
                }
                if (ftrStructureForFlow.getLocalCurAmount() != null) {
                    row.field("LOCAL_CUR_AMOUNT", "BAPITB_HWBETR", (ErpType)ftrStructureForFlow.getLocalCurAmount());
                }
                if (ftrStructureForFlow.getLocalCurAmountChar() != null) {
                    row.field("LOCAL_CUR_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getLocalCurAmountChar());
                }
                if (ftrStructureForFlow.getCurrentRate() != null) {
                    row.field("CURRENT_RATE", "TB_SHWKAKT", (ErpType)ftrStructureForFlow.getCurrentRate());
                }
                if (ftrStructureForFlow.getFixedRate() != null) {
                    row.field("FIXED_RATE", "TB_SHWKFIX", (ErpType)ftrStructureForFlow.getFixedRate());
                }
                if (ftrStructureForFlow.getFixedAmount() != null) {
                    row.field("FIXED_AMOUNT", "TB_SHWBFIX", (ErpType)ftrStructureForFlow.getFixedAmount());
                }
                if (ftrStructureForFlow.getCalcFrom() != null) {
                    row.field("CALC_FROM", "DBERVON", ftrStructureForFlow.getCalcFrom());
                }
                if (ftrStructureForFlow.getCalcFromIncl() != null) {
                    row.field("CALC_FROM_INCL", "TB_SINCLV", (ErpType)ftrStructureForFlow.getCalcFromIncl());
                }
                if (ftrStructureForFlow.getCalcFromMonthEnd() != null) {
                    row.field("CALC_FROM_MONTH_END", "VVSULTVON", (ErpType)ftrStructureForFlow.getCalcFromMonthEnd());
                }
                if (ftrStructureForFlow.getCalcTo() != null) {
                    row.field("CALC_TO", "DBERBIS", ftrStructureForFlow.getCalcTo());
                }
                if (ftrStructureForFlow.getCalcToIncl() != null) {
                    row.field("CALC_TO_INCL", "TB_SINCLB", (ErpType)ftrStructureForFlow.getCalcToIncl());
                }
                if (ftrStructureForFlow.getCalcToMonthEnd() != null) {
                    row.field("CALC_TO_MONTH_END", "VVSULTBIS", (ErpType)ftrStructureForFlow.getCalcToMonthEnd());
                }
                if (ftrStructureForFlow.getInterestCalcMethod() != null) {
                    row.field("INTEREST_CALC_METHOD", "SZBMETH", (ErpType)ftrStructureForFlow.getInterestCalcMethod());
                }
                if (ftrStructureForFlow.getInterestCalcExpon() != null) {
                    row.field("INTEREST_CALC_EXPON", "TB_JZINSRE", (ErpType)ftrStructureForFlow.getInterestCalcExpon());
                }
                if (ftrStructureForFlow.getInterestCalendar() != null) {
                    row.field("INTEREST_CALENDAR", "TFMSKALIDWT", (ErpType)ftrStructureForFlow.getInterestCalendar());
                }
                if (ftrStructureForFlow.getInterestCalcDays() != null) {
                    row.field("INTEREST_CALC_DAYS", "VVATAGE", (ErpType)ftrStructureForFlow.getInterestCalcDays());
                }
                if (ftrStructureForFlow.getCalcBaseDays() != null) {
                    row.field("CALC_BASE_DAYS", "ABASTAGE", (ErpType)ftrStructureForFlow.getCalcBaseDays());
                }
                if (ftrStructureForFlow.getCalcBaseAmount() != null) {
                    row.field("CALC_BASE_AMOUNT", "BAPIBBASIS", (ErpType)ftrStructureForFlow.getCalcBaseAmount());
                }
                if (ftrStructureForFlow.getCalcBaseAmountChar() != null) {
                    row.field("CALC_BASE_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getCalcBaseAmountChar());
                }
                if (ftrStructureForFlow.getCalcBaseCur() != null) {
                    row.field("CALC_BASE_CUR", "TB_WBASIS", (ErpType)ftrStructureForFlow.getCalcBaseCur());
                }
                if (ftrStructureForFlow.getCalcBaseCurIso() != null) {
                    row.field("CALC_BASE_CUR_ISO", "ISOCD", (ErpType)ftrStructureForFlow.getCalcBaseCurIso());
                }
                if (ftrStructureForFlow.getPercentageRate() != null) {
                    row.field("PERCENTAGE_RATE", "PKOND", (ErpType)ftrStructureForFlow.getPercentageRate());
                }
                if (ftrStructureForFlow.getAssignment() != null) {
                    row.field("ASSIGNMENT", "DZUONR", (ErpType)ftrStructureForFlow.getAssignment());
                }
                if (ftrStructureForFlow.getPostingStatus() != null) {
                    row.field("POSTING_STATUS", "TB_SBEWEBE", (ErpType)ftrStructureForFlow.getPostingStatus());
                }
                if (ftrStructureForFlow.getCalcDate() != null) {
                    row.field("CALC_DATE", "DVALUT", ftrStructureForFlow.getCalcDate());
                }
                if (ftrStructureForFlow.getPositionAmount() != null) {
                    row.field("POSITION_AMOUNT", "BAPITB_BBBETR", (ErpType)ftrStructureForFlow.getPositionAmount());
                }
                if (ftrStructureForFlow.getPositionAmountChar() != null) {
                    row.field("POSITION_AMOUNT_CHAR", "TM_XBETRAG", (ErpType)ftrStructureForFlow.getPositionAmountChar());
                }
                if (ftrStructureForFlow.getPosAmountFixed() == null) continue;
                row.field("POS_AMOUNT_FIXED", "TB_SBWBFIX", (ErpType)ftrStructureForFlow.getPosAmountFixed());
            }
            table.end();
        }
        if (this.addflowx.iterator().hasNext()) {
            Table table = query.withTable("ADDFLOWX", "BAPI_FTR_FLOWX");
            for (FtrStructureChangeInformationForFlow ftrStructureChangeInformationForFlow : this.addflowx) {
                row = table.row();
                if (ftrStructureChangeInformationForFlow.getTableindex() != null) {
                    row.field("TABLEINDEX", "TB_TABLEINDEX", (ErpType)ftrStructureChangeInformationForFlow.getTableindex());
                }
                if (ftrStructureChangeInformationForFlow.getFlowKey() != null) {
                    row.field("FLOW_KEY", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getFlowKey());
                }
                if (ftrStructureChangeInformationForFlow.getFlowSide() != null) {
                    row.field("FLOW_SIDE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getFlowSide());
                }
                if (ftrStructureChangeInformationForFlow.getFlowType() != null) {
                    row.field("FLOW_TYPE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getFlowType());
                }
                if (ftrStructureChangeInformationForFlow.getFlowSign() != null) {
                    row.field("FLOW_SIGN", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getFlowSign());
                }
                if (ftrStructureChangeInformationForFlow.getPaymentDate() != null) {
                    row.field("PAYMENT_DATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPaymentDate());
                }
                if (ftrStructureChangeInformationForFlow.getPaymentAmount() != null) {
                    row.field("PAYMENT_AMOUNT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPaymentAmount());
                }
                if (ftrStructureChangeInformationForFlow.getPaymentAmountChar() != null) {
                    row.field("PAYMENT_AMOUNT_CHAR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPaymentAmountChar());
                }
                if (ftrStructureChangeInformationForFlow.getPaymentCur() != null) {
                    row.field("PAYMENT_CUR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPaymentCur());
                }
                if (ftrStructureChangeInformationForFlow.getPaymentCurIso() != null) {
                    row.field("PAYMENT_CUR_ISO", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPaymentCurIso());
                }
                if (ftrStructureChangeInformationForFlow.getLocalCurRate() != null) {
                    row.field("LOCAL_CUR_RATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getLocalCurRate());
                }
                if (ftrStructureChangeInformationForFlow.getLocalCurAmount() != null) {
                    row.field("LOCAL_CUR_AMOUNT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getLocalCurAmount());
                }
                if (ftrStructureChangeInformationForFlow.getLocalCurAmountChar() != null) {
                    row.field("LOCAL_CUR_AMOUNT_CHAR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getLocalCurAmountChar());
                }
                if (ftrStructureChangeInformationForFlow.getCurrentRate() != null) {
                    row.field("CURRENT_RATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCurrentRate());
                }
                if (ftrStructureChangeInformationForFlow.getFixedRate() != null) {
                    row.field("FIXED_RATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getFixedRate());
                }
                if (ftrStructureChangeInformationForFlow.getFixedAmount() != null) {
                    row.field("FIXED_AMOUNT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getFixedAmount());
                }
                if (ftrStructureChangeInformationForFlow.getCalcFrom() != null) {
                    row.field("CALC_FROM", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcFrom());
                }
                if (ftrStructureChangeInformationForFlow.getCalcFromIncl() != null) {
                    row.field("CALC_FROM_INCL", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcFromIncl());
                }
                if (ftrStructureChangeInformationForFlow.getCalcFromMonthEnd() != null) {
                    row.field("CALC_FROM_MONTH_END", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcFromMonthEnd());
                }
                if (ftrStructureChangeInformationForFlow.getCalcTo() != null) {
                    row.field("CALC_TO", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcTo());
                }
                if (ftrStructureChangeInformationForFlow.getCalcToIncl() != null) {
                    row.field("CALC_TO_INCL", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcToIncl());
                }
                if (ftrStructureChangeInformationForFlow.getCalcToMonthEnd() != null) {
                    row.field("CALC_TO_MONTH_END", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcToMonthEnd());
                }
                if (ftrStructureChangeInformationForFlow.getInterestCalcMethod() != null) {
                    row.field("INTEREST_CALC_METHOD", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getInterestCalcMethod());
                }
                if (ftrStructureChangeInformationForFlow.getInterestCalcExpon() != null) {
                    row.field("INTEREST_CALC_EXPON", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getInterestCalcExpon());
                }
                if (ftrStructureChangeInformationForFlow.getInterestCalendar() != null) {
                    row.field("INTEREST_CALENDAR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getInterestCalendar());
                }
                if (ftrStructureChangeInformationForFlow.getInterestCalcDays() != null) {
                    row.field("INTEREST_CALC_DAYS", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getInterestCalcDays());
                }
                if (ftrStructureChangeInformationForFlow.getCalcBaseDays() != null) {
                    row.field("CALC_BASE_DAYS", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcBaseDays());
                }
                if (ftrStructureChangeInformationForFlow.getCalcBaseAmount() != null) {
                    row.field("CALC_BASE_AMOUNT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcBaseAmount());
                }
                if (ftrStructureChangeInformationForFlow.getCalcBaseAmountChar() != null) {
                    row.field("CALC_BASE_AMOUNT_CHAR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcBaseAmountChar());
                }
                if (ftrStructureChangeInformationForFlow.getCalcBaseCur() != null) {
                    row.field("CALC_BASE_CUR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcBaseCur());
                }
                if (ftrStructureChangeInformationForFlow.getCalcBaseCurIso() != null) {
                    row.field("CALC_BASE_CUR_ISO", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcBaseCurIso());
                }
                if (ftrStructureChangeInformationForFlow.getPercentageRate() != null) {
                    row.field("PERCENTAGE_RATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPercentageRate());
                }
                if (ftrStructureChangeInformationForFlow.getAssignment() != null) {
                    row.field("ASSIGNMENT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getAssignment());
                }
                if (ftrStructureChangeInformationForFlow.getPostingStatus() != null) {
                    row.field("POSTING_STATUS", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPostingStatus());
                }
                if (ftrStructureChangeInformationForFlow.getCalcDate() != null) {
                    row.field("CALC_DATE", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getCalcDate());
                }
                if (ftrStructureChangeInformationForFlow.getPositionAmount() != null) {
                    row.field("POSITION_AMOUNT", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPositionAmount());
                }
                if (ftrStructureChangeInformationForFlow.getPositionAmountChar() != null) {
                    row.field("POSITION_AMOUNT_CHAR", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPositionAmountChar());
                }
                if (ftrStructureChangeInformationForFlow.getPosAmountFixed() == null) continue;
                row.field("POS_AMOUNT_FIXED", "BAPIUPDATE", (ErpType)ftrStructureChangeInformationForFlow.getPosAmountFixed());
            }
            table.end();
        }
        if (this.extensionIn != null && this.extensionIn.iterator().hasNext()) {
            Table table = query.withTable("EXTENSIONIN", "BAPIPAREX");
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extensionIn) {
                row = table.row();
                if (refStructureForParameterExtensioninExtensionout.getStructure() != null) {
                    row.field("STRUCTURE", "TE_STRUC", (ErpType)refStructureForParameterExtensioninExtensionout.getStructure());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart1() != null) {
                    row.field("VALUEPART1", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart1());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart2() != null) {
                    row.field("VALUEPART2", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart2());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart3() != null) {
                    row.field("VALUEPART3", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart3());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart4() == null) continue;
                row.field("VALUEPART4", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart4());
            }
            table.end();
        }
        query.withImportingAsReturn("RETURNCOMPANYCODE", "BAPI2042");
        query.withImportingAsReturn("RETURNFINANCIALTRANSACTION", "BAPI2042");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult bapiQueryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(bapiQueryResult);
    }

    public ForeignExchangeDealChangeCommand extensionIn(RefStructureForParameterExtensioninExtensionout ... items) {
        this.extensionIn = Lists.newArrayList((Object[])items);
        return this;
    }

    public ForeignExchangeDealChangeCommand paydetCompleteIndicator(IndicatorIfTransferredDataIsComplete paydetCompleteIndicator) {
        this.paydetCompleteIndicator = paydetCompleteIndicator;
        return this;
    }

    public ForeignExchangeDealChangeCommand addflowCompleteIndicator(IndicatorIfTransferredDataIsComplete addflowCompleteIndicator) {
        this.addflowCompleteIndicator = addflowCompleteIndicator;
        return this;
    }

    public ForeignExchangeDealChangeCommand testrun(ErpBoolean testrun) {
        this.testrun = testrun;
        return this;
    }

    public ForeignExchangeDealChangeCommand cashSettlement(FtrStructureForCashSettlementData cashSettlement) {
        this.cashSettlement = cashSettlement;
        return this;
    }

    public ForeignExchangeDealChangeCommand cashSettlementX(ChangeStructureForCashSettlementData cashSettlementX) {
        this.cashSettlementX = cashSettlementX;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForeignExchangeDealChangeCommand)) {
            return false;
        }
        ForeignExchangeDealChangeCommand other = (ForeignExchangeDealChangeCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChangeForexTransaction this$forex = this.forex;
        ChangeForexTransaction other$forex = other.forex;
        if (this$forex == null ? other$forex != null : !((Object)this$forex).equals(other$forex)) {
            return false;
        }
        ChangeStructureForForexTransaction this$forexx = this.forexx;
        ChangeStructureForForexTransaction other$forexx = other.forexx;
        if (this$forexx == null ? other$forexx != null : !((Object)this$forexx).equals(other$forexx)) {
            return false;
        }
        FtrStructureForChangingTransactions this$generalcontractdata = this.generalcontractdata;
        FtrStructureForChangingTransactions other$generalcontractdata = other.generalcontractdata;
        if (this$generalcontractdata == null ? other$generalcontractdata != null : !((Object)this$generalcontractdata).equals(other$generalcontractdata)) {
            return false;
        }
        FtrStructureChangeInformationForChangeMethod this$generalcontractdatax = this.generalcontractdatax;
        FtrStructureChangeInformationForChangeMethod other$generalcontractdatax = other.generalcontractdatax;
        if (this$generalcontractdatax == null ? other$generalcontractdatax != null : !((Object)this$generalcontractdatax).equals(other$generalcontractdatax)) {
            return false;
        }
        IndicatorIfTransferredDataIsComplete this$paydetCompleteIndicator = this.paydetCompleteIndicator;
        IndicatorIfTransferredDataIsComplete other$paydetCompleteIndicator = other.paydetCompleteIndicator;
        if (this$paydetCompleteIndicator == null ? other$paydetCompleteIndicator != null : !((Object)((Object)this$paydetCompleteIndicator)).equals((Object)other$paydetCompleteIndicator)) {
            return false;
        }
        IndicatorIfTransferredDataIsComplete this$addflowCompleteIndicator = this.addflowCompleteIndicator;
        IndicatorIfTransferredDataIsComplete other$addflowCompleteIndicator = other.addflowCompleteIndicator;
        if (this$addflowCompleteIndicator == null ? other$addflowCompleteIndicator != null : !((Object)((Object)this$addflowCompleteIndicator)).equals((Object)other$addflowCompleteIndicator)) {
            return false;
        }
        ErpBoolean this$testrun = this.testrun;
        ErpBoolean other$testrun = other.testrun;
        if (this$testrun == null ? other$testrun != null : !this$testrun.equals(other$testrun)) {
            return false;
        }
        FtrStructureForCashSettlementData this$cashSettlement = this.cashSettlement;
        FtrStructureForCashSettlementData other$cashSettlement = other.cashSettlement;
        if (this$cashSettlement == null ? other$cashSettlement != null : !((Object)this$cashSettlement).equals(other$cashSettlement)) {
            return false;
        }
        ChangeStructureForCashSettlementData this$cashSettlementX = this.cashSettlementX;
        ChangeStructureForCashSettlementData other$cashSettlementX = other.cashSettlementX;
        if (this$cashSettlementX == null ? other$cashSettlementX != null : !((Object)this$cashSettlementX).equals(other$cashSettlementX)) {
            return false;
        }
        CompanyCode this$companycode = this.companycode;
        CompanyCode other$companycode = other.companycode;
        if (this$companycode == null ? other$companycode != null : !((Object)((Object)this$companycode)).equals((Object)other$companycode)) {
            return false;
        }
        Transaction this$financialtransaction = this.financialtransaction;
        Transaction other$financialtransaction = other.financialtransaction;
        if (this$financialtransaction == null ? other$financialtransaction != null : !((Object)((Object)this$financialtransaction)).equals((Object)other$financialtransaction)) {
            return false;
        }
        Iterable<FtrStructureForPaymentDetail> this$paymentdetail = this.paymentdetail;
        Iterable<FtrStructureForPaymentDetail> other$paymentdetail = other.paymentdetail;
        if (this$paymentdetail == null ? other$paymentdetail != null : !this$paymentdetail.equals(other$paymentdetail)) {
            return false;
        }
        Iterable<FtrStructureChangeInformationForPaymentDetail> this$paymentdetailx = this.paymentdetailx;
        Iterable<FtrStructureChangeInformationForPaymentDetail> other$paymentdetailx = other.paymentdetailx;
        if (this$paymentdetailx == null ? other$paymentdetailx != null : !this$paymentdetailx.equals(other$paymentdetailx)) {
            return false;
        }
        Iterable<FtrStructureForFlow> this$addflow = this.addflow;
        Iterable<FtrStructureForFlow> other$addflow = other.addflow;
        if (this$addflow == null ? other$addflow != null : !this$addflow.equals(other$addflow)) {
            return false;
        }
        Iterable<FtrStructureChangeInformationForFlow> this$addflowx = this.addflowx;
        Iterable<FtrStructureChangeInformationForFlow> other$addflowx = other.addflowx;
        if (this$addflowx == null ? other$addflowx != null : !this$addflowx.equals(other$addflowx)) {
            return false;
        }
        Iterable<RefStructureForParameterExtensioninExtensionout> this$extensionIn = this.extensionIn;
        Iterable<RefStructureForParameterExtensioninExtensionout> other$extensionIn = other.extensionIn;
        return !(this$extensionIn == null ? other$extensionIn != null : !this$extensionIn.equals(other$extensionIn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForeignExchangeDealChangeCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChangeForexTransaction $forex = this.forex;
        result = result * 59 + ($forex == null ? 43 : ((Object)$forex).hashCode());
        ChangeStructureForForexTransaction $forexx = this.forexx;
        result = result * 59 + ($forexx == null ? 43 : ((Object)$forexx).hashCode());
        FtrStructureForChangingTransactions $generalcontractdata = this.generalcontractdata;
        result = result * 59 + ($generalcontractdata == null ? 43 : ((Object)$generalcontractdata).hashCode());
        FtrStructureChangeInformationForChangeMethod $generalcontractdatax = this.generalcontractdatax;
        result = result * 59 + ($generalcontractdatax == null ? 43 : ((Object)$generalcontractdatax).hashCode());
        IndicatorIfTransferredDataIsComplete $paydetCompleteIndicator = this.paydetCompleteIndicator;
        result = result * 59 + ($paydetCompleteIndicator == null ? 43 : ((Object)((Object)$paydetCompleteIndicator)).hashCode());
        IndicatorIfTransferredDataIsComplete $addflowCompleteIndicator = this.addflowCompleteIndicator;
        result = result * 59 + ($addflowCompleteIndicator == null ? 43 : ((Object)((Object)$addflowCompleteIndicator)).hashCode());
        ErpBoolean $testrun = this.testrun;
        result = result * 59 + ($testrun == null ? 43 : $testrun.hashCode());
        FtrStructureForCashSettlementData $cashSettlement = this.cashSettlement;
        result = result * 59 + ($cashSettlement == null ? 43 : ((Object)$cashSettlement).hashCode());
        ChangeStructureForCashSettlementData $cashSettlementX = this.cashSettlementX;
        result = result * 59 + ($cashSettlementX == null ? 43 : ((Object)$cashSettlementX).hashCode());
        CompanyCode $companycode = this.companycode;
        result = result * 59 + ($companycode == null ? 43 : ((Object)((Object)$companycode)).hashCode());
        Transaction $financialtransaction = this.financialtransaction;
        result = result * 59 + ($financialtransaction == null ? 43 : ((Object)((Object)$financialtransaction)).hashCode());
        Iterable<FtrStructureForPaymentDetail> $paymentdetail = this.paymentdetail;
        result = result * 59 + ($paymentdetail == null ? 43 : $paymentdetail.hashCode());
        Iterable<FtrStructureChangeInformationForPaymentDetail> $paymentdetailx = this.paymentdetailx;
        result = result * 59 + ($paymentdetailx == null ? 43 : $paymentdetailx.hashCode());
        Iterable<FtrStructureForFlow> $addflow = this.addflow;
        result = result * 59 + ($addflow == null ? 43 : $addflow.hashCode());
        Iterable<FtrStructureChangeInformationForFlow> $addflowx = this.addflowx;
        result = result * 59 + ($addflowx == null ? 43 : $addflowx.hashCode());
        Iterable<RefStructureForParameterExtensioninExtensionout> $extensionIn = this.extensionIn;
        result = result * 59 + ($extensionIn == null ? 43 : $extensionIn.hashCode());
        return result;
    }

    public String toString() {
        return "ForeignExchangeDealChangeCommand(forex=" + this.forex + ", forexx=" + this.forexx + ", generalcontractdata=" + this.generalcontractdata + ", generalcontractdatax=" + this.generalcontractdatax + ", paydetCompleteIndicator=" + (Object)((Object)this.paydetCompleteIndicator) + ", addflowCompleteIndicator=" + (Object)((Object)this.addflowCompleteIndicator) + ", testrun=" + this.testrun + ", cashSettlement=" + this.cashSettlement + ", cashSettlementX=" + this.cashSettlementX + ", companycode=" + (Object)((Object)this.companycode) + ", financialtransaction=" + (Object)((Object)this.financialtransaction) + ", paymentdetail=" + this.paymentdetail + ", paymentdetailx=" + this.paymentdetailx + ", addflow=" + this.addflow + ", addflowx=" + this.addflowx + ", extensionIn=" + this.extensionIn + ")";
    }

    @ConstructorProperties(value={"forex", "forexx", "generalcontractdata", "generalcontractdatax", "companycode", "financialtransaction", "paymentdetail", "paymentdetailx", "addflow", "addflowx"})
    public ForeignExchangeDealChangeCommand(ChangeForexTransaction forex, ChangeStructureForForexTransaction forexx, FtrStructureForChangingTransactions generalcontractdata, FtrStructureChangeInformationForChangeMethod generalcontractdatax, CompanyCode companycode, Transaction financialtransaction, @NonNull Iterable<FtrStructureForPaymentDetail> paymentdetail, @NonNull Iterable<FtrStructureChangeInformationForPaymentDetail> paymentdetailx, @NonNull Iterable<FtrStructureForFlow> addflow, @NonNull Iterable<FtrStructureChangeInformationForFlow> addflowx) {
        if (paymentdetail == null) {
            throw new NullPointerException("paymentdetail");
        }
        if (paymentdetailx == null) {
            throw new NullPointerException("paymentdetailx");
        }
        if (addflow == null) {
            throw new NullPointerException("addflow");
        }
        if (addflowx == null) {
            throw new NullPointerException("addflowx");
        }
        this.forex = forex;
        this.forexx = forexx;
        this.generalcontractdata = generalcontractdata;
        this.generalcontractdatax = generalcontractdatax;
        this.companycode = companycode;
        this.financialtransaction = financialtransaction;
        this.paymentdetail = paymentdetail;
        this.paymentdetailx = paymentdetailx;
        this.addflow = addflow;
        this.addflowx = addflowx;
    }

    public static class Result {
        private final BapiQueryResult result;

        public CompanyCode getCompanyCode() {
            return (CompanyCode)((Object)this.result.get("RETURNCOMPANYCODE").getAsObject().as(CompanyCode.class));
        }

        public Transaction getFinancialTransaction() {
            return (Transaction)((Object)this.result.get("RETURNFINANCIALTRANSACTION").getAsObject().as(Transaction.class));
        }

        public List<FtrStructureForPaymentDetail> getChangePaymentDetails() {
            return this.result.get("PAYMENTDETAIL").getAsCollection().asList(FtrStructureForPaymentDetail.class);
        }

        public List<FtrStructureChangeInformationForPaymentDetail> getChangeInformationForPaymentDetails() {
            return this.result.get("PAYMENTDETAILX").getAsCollection().asList(FtrStructureChangeInformationForPaymentDetail.class);
        }

        public List<FtrStructureForFlow> getChangeOtherFlows() {
            return this.result.get("ADDFLOW").getAsCollection().asList(FtrStructureForFlow.class);
        }

        public List<FtrStructureChangeInformationForFlow> getChangeInformationForOtherFlows() {
            return this.result.get("ADDFLOWX").getAsCollection().asList(FtrStructureChangeInformationForFlow.class);
        }

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "ForeignExchangeDealChangeCommand.Result(result=" + this.result + ")";
        }
    }
}

