/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetAllocation;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetDepreciationAreasSelectedValue;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistDepreciationArea;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistGeneralData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistInventory;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistInvestmentAccountAssignment;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistLeasing;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistNetWorthValuation;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistOrigin;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistPostingInformation;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetGetlistTimeDependentData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetInvestmentSupportMeasure;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetRealEstateAndSimilarRight;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetSelectionsForGetlist;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FixedAssetSpecificationOfTheDataToBeReturnedByGetlist;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RefStructureForParameterExtensioninExtensionout;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.DepreciationAreaForAssets;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.Int4FieldsWithOutputLength11InStructureSyst;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;
import org.joda.time.LocalDate;

public class FixedAssetGetListCommand {
    private final CompanyCode companyCode;
    private LocalDate evaluationDate = null;
    private DepreciationAreaForAssets depreciationArea = null;
    private Int4FieldsWithOutputLength11InStructureSyst maxEntries = null;
    private FixedAssetSpecificationOfTheDataToBeReturnedByGetlist requestedTablesX = null;
    @NonNull
    private Iterable<FixedAssetSelectionsForGetlist> selectionCriteria = Lists.newArrayList();
    @NonNull
    private Iterable<FixedAssetInvestmentSupportMeasure> investment_support = Lists.newArrayList();

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        TableRow row;
        if (this.requestedTablesX != null) {
            this.requestedTablesX.validate();
        }
        if (this.selectionCriteria != null) {
            for (FixedAssetSelectionsForGetlist fixedAssetSelectionsForGetlist : this.selectionCriteria) {
                fixedAssetSelectionsForGetlist.validate();
            }
        }
        if (this.investment_support != null) {
            for (FixedAssetInvestmentSupportMeasure fixedAssetInvestmentSupportMeasure : this.investment_support) {
                fixedAssetInvestmentSupportMeasure.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_FIXEDASSET_GETLIST");
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companyCode);
        if (this.evaluationDate != null) {
            query.withExporting("EVALUATIONDATE", "DATE_", this.evaluationDate);
        }
        if (this.depreciationArea != null) {
            query.withExporting("DEPRECIATIONAREA", "BF_AFABE_D", (ErpType)this.depreciationArea);
        }
        if (this.maxEntries != null) {
            query.withExporting("MAXENTRIES", "BAPIMAXROW", (ErpType)this.maxEntries);
        }
        if (this.requestedTablesX != null) {
            ParameterFields parameterFields = query.withExportingFields("REQUESTEDTABLESX", "BAPI1022_REQUESTEDTABLESX");
            if (this.requestedTablesX.getGeneraldata() != null) {
                parameterFields.field("GENERALDATA", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getGeneraldata());
            }
            if (this.requestedTablesX.getInventory() != null) {
                parameterFields.field("INVENTORY", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInventory());
            }
            if (this.requestedTablesX.getPostinginformation() != null) {
                parameterFields.field("POSTINGINFORMATION", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getPostinginformation());
            }
            if (this.requestedTablesX.getTimedependentdata() != null) {
                parameterFields.field("TIMEDEPENDENTDATA", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getTimedependentdata());
            }
            if (this.requestedTablesX.getAllocations() != null) {
                parameterFields.field("ALLOCATIONS", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getAllocations());
            }
            if (this.requestedTablesX.getOrigin() != null) {
                parameterFields.field("ORIGIN", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getOrigin());
            }
            if (this.requestedTablesX.getInvestacctassignmnt() != null) {
                parameterFields.field("INVESTACCTASSIGNMNT", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInvestacctassignmnt());
            }
            if (this.requestedTablesX.getNetworthvaluation() != null) {
                parameterFields.field("NETWORTHVALUATION", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getNetworthvaluation());
            }
            if (this.requestedTablesX.getRealestate() != null) {
                parameterFields.field("REALESTATE", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getRealestate());
            }
            if (this.requestedTablesX.getInsurance() != null) {
                parameterFields.field("INSURANCE", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInsurance());
            }
            if (this.requestedTablesX.getLeasing() != null) {
                parameterFields.field("LEASING", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getLeasing());
            }
            if (this.requestedTablesX.getDepreciationareas() != null) {
                parameterFields.field("DEPRECIATIONAREAS", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getDepreciationareas());
            }
            if (this.requestedTablesX.getDepreciationareavals() != null) {
                parameterFields.field("DEPRECIATIONAREAVALS", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getDepreciationareavals());
            }
            if (this.requestedTablesX.getExtensionout() != null) {
                parameterFields.field("EXTENSIONOUT", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getExtensionout());
            }
            if (this.requestedTablesX.getInvestmentSupport() != null) {
                parameterFields.field("INVESTMENT_SUPPORT", "BAPI1022_REQUESTED", (ErpType)this.requestedTablesX.getInvestmentSupport());
            }
            parameterFields.end();
        }
        if (this.selectionCriteria != null && this.selectionCriteria.iterator().hasNext()) {
            Table table = query.withTable("SELECTIONCRITERIA", "BAPI1022_SELECTIONCRITERIA");
            for (FixedAssetSelectionsForGetlist fixedAssetSelectionsForGetlist : this.selectionCriteria) {
                row = table.row();
                if (fixedAssetSelectionsForGetlist.getParameter() != null) {
                    row.field("PARAMETER", "BAPI1022_PARAM", (ErpType)fixedAssetSelectionsForGetlist.getParameter());
                }
                if (fixedAssetSelectionsForGetlist.getField() != null) {
                    row.field("FIELD", "BAPI1022_FIELD", (ErpType)fixedAssetSelectionsForGetlist.getField());
                }
                if (fixedAssetSelectionsForGetlist.getSign() != null) {
                    row.field("SIGN", "BAPISIGN", (ErpType)fixedAssetSelectionsForGetlist.getSign());
                }
                if (fixedAssetSelectionsForGetlist.getOption() != null) {
                    row.field("OPTION", "BAPIOPTION", (ErpType)fixedAssetSelectionsForGetlist.getOption());
                }
                if (fixedAssetSelectionsForGetlist.getLow() != null) {
                    row.field("LOW", "BAPI1022_LOW", (ErpType)fixedAssetSelectionsForGetlist.getLow());
                }
                if (fixedAssetSelectionsForGetlist.getHigh() == null) continue;
                row.field("HIGH", "BAPI1022_HIGH", (ErpType)fixedAssetSelectionsForGetlist.getHigh());
            }
            table.end();
        }
        if (this.investment_support != null && this.investment_support.iterator().hasNext()) {
            Table table = query.withTable("INVESTMENT_SUPPORT", "BAPI1022_INV_SUPPORT_PID");
            for (FixedAssetInvestmentSupportMeasure fixedAssetInvestmentSupportMeasure : this.investment_support) {
                row = table.row();
                if (fixedAssetInvestmentSupportMeasure.getAsset() != null) {
                    row.field("ASSET", "BF_ANLN1", (ErpType)fixedAssetInvestmentSupportMeasure.getAsset());
                }
                if (fixedAssetInvestmentSupportMeasure.getSubnumber() != null) {
                    row.field("SUBNUMBER", "BF_ANLN2", (ErpType)fixedAssetInvestmentSupportMeasure.getSubnumber());
                }
                if (fixedAssetInvestmentSupportMeasure.getInvSupportKey() != null) {
                    row.field("INV_SUPPORT_KEY", "INVSL", (ErpType)fixedAssetInvestmentSupportMeasure.getInvSupportKey());
                }
                if (fixedAssetInvestmentSupportMeasure.getChangeInd() == null) continue;
                row.field("CHANGE_IND", "CDCHNGIND", (ErpType)fixedAssetInvestmentSupportMeasure.getChangeInd());
            }
            table.end();
        }
        query.withImportingAsReturn("RETURN", "BAPIRET2");
        query.withTableAsReturn("GENERALDATA", "BAPI1022_FEGLG001_PID");
        query.withTableAsReturn("INVENTORY", "BAPI1022_FEGLG011_PID");
        query.withTableAsReturn("POSTINGINFORMATION", "BAPI1022_FEGLG002_PID");
        query.withTableAsReturn("TIMEDEPENDENTDATA", "BAPI1022_FEGLG003_PID");
        query.withTableAsReturn("ALLOCATIONS", "BAPI1022_FEGLG004_PID");
        query.withTableAsReturn("ORIGIN", "BAPI1022_FEGLG009_PID");
        query.withTableAsReturn("INVESTACCTASSIGNMNT", "BAPI1022_FEGLG010_PID");
        query.withTableAsReturn("NETWORTHVALUATION", "BAPI1022_FEGLG006_PID");
        query.withTableAsReturn("REALESTATE", "BAPI1022_FEGLG007_PID");
        query.withTableAsReturn("INSURANCE", "BAPI1022_FEGLG008_PID");
        query.withTableAsReturn("LEASING", "BAPI1022_FEGLG005_PID");
        query.withTableAsReturn("DEPRECIATIONAREAS", "BAPI1022_DEP_AREAS_PID");
        query.withTableAsReturn("DEPRECIATIONAREAVALS", "BAPI1022_VALUES");
        query.withTableAsReturn("EXTENSIONOUT", "BAPIPAREX");
        BapiQueryResult bapiQueryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(bapiQueryResult);
    }

    public FixedAssetGetListCommand selectionCriteria(FixedAssetSelectionsForGetlist ... items) {
        this.selectionCriteria = Lists.newArrayList((Object[])items);
        return this;
    }

    public FixedAssetGetListCommand investment_support(FixedAssetInvestmentSupportMeasure ... items) {
        this.investment_support = Lists.newArrayList((Object[])items);
        return this;
    }

    public FixedAssetGetListCommand evaluationDate(LocalDate evaluationDate) {
        this.evaluationDate = evaluationDate;
        return this;
    }

    public FixedAssetGetListCommand depreciationArea(DepreciationAreaForAssets depreciationArea) {
        this.depreciationArea = depreciationArea;
        return this;
    }

    public FixedAssetGetListCommand maxEntries(Int4FieldsWithOutputLength11InStructureSyst maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    public FixedAssetGetListCommand requestedTablesX(FixedAssetSpecificationOfTheDataToBeReturnedByGetlist requestedTablesX) {
        this.requestedTablesX = requestedTablesX;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedAssetGetListCommand)) {
            return false;
        }
        FixedAssetGetListCommand other = (FixedAssetGetListCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompanyCode this$companyCode = this.companyCode;
        CompanyCode other$companyCode = other.companyCode;
        if (this$companyCode == null ? other$companyCode != null : !((Object)((Object)this$companyCode)).equals((Object)other$companyCode)) {
            return false;
        }
        LocalDate this$evaluationDate = this.evaluationDate;
        LocalDate other$evaluationDate = other.evaluationDate;
        if (this$evaluationDate == null ? other$evaluationDate != null : !this$evaluationDate.equals(other$evaluationDate)) {
            return false;
        }
        DepreciationAreaForAssets this$depreciationArea = this.depreciationArea;
        DepreciationAreaForAssets other$depreciationArea = other.depreciationArea;
        if (this$depreciationArea == null ? other$depreciationArea != null : !((Object)this$depreciationArea).equals(other$depreciationArea)) {
            return false;
        }
        Int4FieldsWithOutputLength11InStructureSyst this$maxEntries = this.maxEntries;
        Int4FieldsWithOutputLength11InStructureSyst other$maxEntries = other.maxEntries;
        if (this$maxEntries == null ? other$maxEntries != null : !((Object)this$maxEntries).equals(other$maxEntries)) {
            return false;
        }
        FixedAssetSpecificationOfTheDataToBeReturnedByGetlist this$requestedTablesX = this.requestedTablesX;
        FixedAssetSpecificationOfTheDataToBeReturnedByGetlist other$requestedTablesX = other.requestedTablesX;
        if (this$requestedTablesX == null ? other$requestedTablesX != null : !((Object)this$requestedTablesX).equals(other$requestedTablesX)) {
            return false;
        }
        Iterable<FixedAssetSelectionsForGetlist> this$selectionCriteria = this.selectionCriteria;
        Iterable<FixedAssetSelectionsForGetlist> other$selectionCriteria = other.selectionCriteria;
        if (this$selectionCriteria == null ? other$selectionCriteria != null : !this$selectionCriteria.equals(other$selectionCriteria)) {
            return false;
        }
        Iterable<FixedAssetInvestmentSupportMeasure> this$investment_support = this.investment_support;
        Iterable<FixedAssetInvestmentSupportMeasure> other$investment_support = other.investment_support;
        return !(this$investment_support == null ? other$investment_support != null : !this$investment_support.equals(other$investment_support));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FixedAssetGetListCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompanyCode $companyCode = this.companyCode;
        result = result * 59 + ($companyCode == null ? 43 : ((Object)((Object)$companyCode)).hashCode());
        LocalDate $evaluationDate = this.evaluationDate;
        result = result * 59 + ($evaluationDate == null ? 43 : $evaluationDate.hashCode());
        DepreciationAreaForAssets $depreciationArea = this.depreciationArea;
        result = result * 59 + ($depreciationArea == null ? 43 : ((Object)$depreciationArea).hashCode());
        Int4FieldsWithOutputLength11InStructureSyst $maxEntries = this.maxEntries;
        result = result * 59 + ($maxEntries == null ? 43 : ((Object)$maxEntries).hashCode());
        FixedAssetSpecificationOfTheDataToBeReturnedByGetlist $requestedTablesX = this.requestedTablesX;
        result = result * 59 + ($requestedTablesX == null ? 43 : ((Object)$requestedTablesX).hashCode());
        Iterable<FixedAssetSelectionsForGetlist> $selectionCriteria = this.selectionCriteria;
        result = result * 59 + ($selectionCriteria == null ? 43 : $selectionCriteria.hashCode());
        Iterable<FixedAssetInvestmentSupportMeasure> $investment_support = this.investment_support;
        result = result * 59 + ($investment_support == null ? 43 : $investment_support.hashCode());
        return result;
    }

    public String toString() {
        return "FixedAssetGetListCommand(companyCode=" + (Object)((Object)this.companyCode) + ", evaluationDate=" + this.evaluationDate + ", depreciationArea=" + this.depreciationArea + ", maxEntries=" + this.maxEntries + ", requestedTablesX=" + this.requestedTablesX + ", selectionCriteria=" + this.selectionCriteria + ", investment_support=" + this.investment_support + ")";
    }

    @ConstructorProperties(value={"companyCode"})
    public FixedAssetGetListCommand(CompanyCode companyCode) {
        this.companyCode = companyCode;
    }

    public static class Result {
        private final BapiQueryResult result;

        public ReturnParameter getMessage() {
            return (ReturnParameter)this.result.get("RETURN").getAsObject().as(ReturnParameter.class);
        }

        public List<FixedAssetGetlistGeneralData> getGeneralData() {
            return this.result.get("GENERALDATA").getAsCollection().asList(FixedAssetGetlistGeneralData.class);
        }

        public List<FixedAssetGetlistInventory> getPhysicalInventory() {
            return this.result.get("INVENTORY").getAsCollection().asList(FixedAssetGetlistInventory.class);
        }

        public List<FixedAssetGetlistPostingInformation> getPostingInformation() {
            return this.result.get("POSTINGINFORMATION").getAsCollection().asList(FixedAssetGetlistPostingInformation.class);
        }

        public List<FixedAssetGetlistTimeDependentData> getTimeDependentData() {
            return this.result.get("TIMEDEPENDENTDATA").getAsCollection().asList(FixedAssetGetlistTimeDependentData.class);
        }

        public List<FixedAssetAllocation> getAssignments() {
            return this.result.get("ALLOCATIONS").getAsCollection().asList(FixedAssetAllocation.class);
        }

        public List<FixedAssetGetlistOrigin> getOrigin() {
            return this.result.get("ORIGIN").getAsCollection().asList(FixedAssetGetlistOrigin.class);
        }

        public List<FixedAssetGetlistInvestmentAccountAssignment> getAccountAssignmentForInvestment() {
            return this.result.get("INVESTACCTASSIGNMNT").getAsCollection().asList(FixedAssetGetlistInvestmentAccountAssignment.class);
        }

        public List<FixedAssetGetlistNetWorthValuation> getNetWorthValuation() {
            return this.result.get("NETWORTHVALUATION").getAsCollection().asList(FixedAssetGetlistNetWorthValuation.class);
        }

        public List<FixedAssetRealEstateAndSimilarRight> getRealEstateAndSimilarRights() {
            return this.result.get("REALESTATE").getAsCollection().asList(FixedAssetRealEstateAndSimilarRight.class);
        }

        public List<FixedAssetGetlistInsurance> getInsurance() {
            return this.result.get("INSURANCE").getAsCollection().asList(FixedAssetGetlistInsurance.class);
        }

        public List<FixedAssetGetlistLeasing> getLeasing() {
            return this.result.get("LEASING").getAsCollection().asList(FixedAssetGetlistLeasing.class);
        }

        public List<FixedAssetGetlistDepreciationArea> getDepreciationAreas() {
            return this.result.get("DEPRECIATIONAREAS").getAsCollection().asList(FixedAssetGetlistDepreciationArea.class);
        }

        public List<FixedAssetDepreciationAreasSelectedValue> getSelectedValues() {
            return this.result.get("DEPRECIATIONAREAVALS").getAsCollection().asList(FixedAssetDepreciationAreasSelectedValue.class);
        }

        public List<RefStructureForParameterExtensioninExtensionout> getCustomerEnhancements() {
            return this.result.get("EXTENSIONOUT").getAsCollection().asList(RefStructureForParameterExtensioninExtensionout.class);
        }

        public List<FixedAssetInvestmentSupportMeasure> getInvestmentSupport() {
            return this.result.get("INVESTMENT_SUPPORT").getAsCollection().asList(FixedAssetInvestmentSupportMeasure.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "FixedAssetGetListCommand.Result(result=" + this.result + ")";
        }
    }
}

