/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.DetailsOfAnFxOption;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ForeignExchangeOptionGetdetailFtrStructureForCreatingTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.Transaction;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;

public class FXOptionGetDetailCommand {
    private final CompanyCode companycode;
    private final Transaction financialtransaction;

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        BapiQuery query = new BapiQuery("BAPI_FTR_FXOPTION_GETDETAIL");
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companycode);
        query.withExporting("FINANCIALTRANSACTION", "TB_RFHA", (ErpType)this.financialtransaction);
        query.withImportingAsReturn("RETURNFOREX", "BAPI_FTR_GETDETAIL_FXOPTION");
        query.withImportingAsReturn("RETURNGENERALCONTRACTDATA", "BAPI_FTR_GETDETAIL");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult queryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(queryResult);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FXOptionGetDetailCommand)) {
            return false;
        }
        FXOptionGetDetailCommand other = (FXOptionGetDetailCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CompanyCode this$companycode = this.companycode;
        CompanyCode other$companycode = other.companycode;
        if (this$companycode == null ? other$companycode != null : !((Object)((Object)this$companycode)).equals((Object)other$companycode)) {
            return false;
        }
        Transaction this$financialtransaction = this.financialtransaction;
        Transaction other$financialtransaction = other.financialtransaction;
        return !(this$financialtransaction == null ? other$financialtransaction != null : !((Object)((Object)this$financialtransaction)).equals((Object)other$financialtransaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FXOptionGetDetailCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CompanyCode $companycode = this.companycode;
        result = result * 59 + ($companycode == null ? 43 : ((Object)((Object)$companycode)).hashCode());
        Transaction $financialtransaction = this.financialtransaction;
        result = result * 59 + ($financialtransaction == null ? 43 : ((Object)((Object)$financialtransaction)).hashCode());
        return result;
    }

    public String toString() {
        return "FXOptionGetDetailCommand(companycode=" + (Object)((Object)this.companycode) + ", financialtransaction=" + (Object)((Object)this.financialtransaction) + ")";
    }

    @ConstructorProperties(value={"companycode", "financialtransaction"})
    public FXOptionGetDetailCommand(CompanyCode companycode, Transaction financialtransaction) {
        this.companycode = companycode;
        this.financialtransaction = financialtransaction;
    }

    public static class Result {
        private final BapiQueryResult result;

        public DetailsOfAnFxOption getDetailsOfAnFxOption() {
            return (DetailsOfAnFxOption)this.result.get("RETURNFOREX").getAsObject().as(DetailsOfAnFxOption.class);
        }

        public ForeignExchangeOptionGetdetailFtrStructureForCreatingTransactions getFtrBapiStructureForCreatingTransactions() {
            return (ForeignExchangeOptionGetdetailFtrStructureForCreatingTransactions)this.result.get("RETURNGENERALCONTRACTDATA").getAsObject().as(ForeignExchangeOptionGetdetailFtrStructureForCreatingTransactions.class);
        }

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "FXOptionGetDetailCommand.Result(result=" + this.result + ")";
        }
    }
}

