/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CreateAnFxOption;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForCreatingTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.Transaction;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.TransactionActivityCategory;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;

public class FXOptionCreateCommand {
    private final CreateAnFxOption forex;
    private final FtrStructureForCreatingTransactions generalContractData;
    private ErpBoolean testRun = null;
    private TransactionActivityCategory activityCategory = null;

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        this.forex.validate();
        this.generalContractData.validate();
        BapiQuery query = new BapiQuery("BAPI_FTR_CREATE_FXOPTIONS");
        if (this.testRun != null) {
            query.withExporting("TESTRUN", "TESTRUN", (ErpType)this.testRun);
        }
        if (this.activityCategory != null) {
            query.withExporting("ACTIVITY_CATEGORY", "TB_SFGZUTY", (ErpType)this.activityCategory);
        }
        ParameterFields row = query.withExportingFields("FOREX", "BAPI_FTR_CREATE_FXOPTION");
        if (this.forex.getOptionType() != null) {
            row.field("OPTION_TYPE", "TV_OPTTYP", (ErpType)this.forex.getOptionType());
        }
        if (this.forex.getLeadCurrency() != null) {
            row.field("LEAD_CURRENCY", "TB_WLWAERS", (ErpType)this.forex.getLeadCurrency());
        }
        if (this.forex.getLeadCurrencyIso() != null) {
            row.field("LEAD_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getLeadCurrencyIso());
        }
        if (this.forex.getFollowCurrency() != null) {
            row.field("FOLLOW_CURRENCY", "TB_WFWAERS", (ErpType)this.forex.getFollowCurrency());
        }
        if (this.forex.getFollowCurrencyIso() != null) {
            row.field("FOLLOW_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getFollowCurrencyIso());
        }
        if (this.forex.getStrikeRate() != null) {
            row.field("STRIKE_RATE", "TB_KKURS", (ErpType)this.forex.getStrikeRate());
        }
        if (this.forex.getUnderlyingAmount() != null) {
            row.field("UNDERLYING_AMOUNT", "BAPITM_BZBETR", (ErpType)this.forex.getUnderlyingAmount());
        }
        if (this.forex.getUnderlyingCurrency() != null) {
            row.field("UNDERLYING_CURRENCY", "TB_WZBETR", (ErpType)this.forex.getUnderlyingCurrency());
        }
        if (this.forex.getUnderlyingCurrencyIso() != null) {
            row.field("UNDERLYING_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getUnderlyingCurrencyIso());
        }
        if (this.forex.getUnderlyingValueDate() != null) {
            row.field("UNDERLYING_VALUE_DATE", "TB_DVALUTA", this.forex.getUnderlyingValueDate());
        }
        if (this.forex.getExpirationDate() != null) {
            row.field("EXPIRATION_DATE", "TB_DMATUR", this.forex.getExpirationDate());
        }
        if (this.forex.getExerciseType() != null) {
            row.field("EXERCISE_TYPE", "SOPTAUS", (ErpType)this.forex.getExerciseType());
        }
        if (this.forex.getSettlementIndicator() != null) {
            row.field("SETTLEMENT_INDICATOR", "TI_SETTLFL", (ErpType)this.forex.getSettlementIndicator());
        }
        if (this.forex.getBarrierRate1() != null) {
            row.field("BARRIER_RATE_1", "TX_KWKURB1", (ErpType)this.forex.getBarrierRate1());
        }
        if (this.forex.getBarrierRate2() != null) {
            row.field("BARRIER_RATE_2", "TX_KWKURB2", (ErpType)this.forex.getBarrierRate2());
        }
        if (this.forex.getPutCallIndicator() != null) {
            row.field("PUT_CALL_INDICATOR", "TI_SPUTCAL", (ErpType)this.forex.getPutCallIndicator());
        }
        if (this.forex.getRatePercentage() != null) {
            row.field("RATE_PERCENTAGE", "TB_PWKURS", (ErpType)this.forex.getRatePercentage());
        }
        if (this.forex.getFlowType() != null) {
            row.field("FLOW_TYPE", "TB_SFHAZBA", (ErpType)this.forex.getFlowType());
        }
        if (this.forex.getCurrencyOptionPremium() != null) {
            row.field("CURRENCY_OPTION_PREMIUM", "TI_PRKUR", (ErpType)this.forex.getCurrencyOptionPremium());
        }
        if (this.forex.getPaymentDateOption() != null) {
            row.field("PAYMENT_DATE_OPTION", "TB_DZTERM", this.forex.getPaymentDateOption());
        }
        if (this.forex.getPaymentAmount() != null) {
            row.field("PAYMENT_AMOUNT", "BAPITM_BZBETR", (ErpType)this.forex.getPaymentAmount());
        }
        if (this.forex.getPaymentCurrency() != null) {
            row.field("PAYMENT_CURRENCY", "TB_WZBETR", (ErpType)this.forex.getPaymentCurrency());
        }
        if (this.forex.getPaymentCurrencyIso() != null) {
            row.field("PAYMENT_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getPaymentCurrencyIso());
        }
        if (this.forex.getSpotRate() != null) {
            row.field("SPOT_RATE", "TB_KKASSA", (ErpType)this.forex.getSpotRate());
        }
        if (this.forex.getSwapRate() != null) {
            row.field("SWAP_RATE", "TB_KSWAP", (ErpType)this.forex.getSwapRate());
        }
        row.end();
        row = query.withExportingFields("GENERALCONTRACTDATA", "BAPI_FTR_CREATE");
        if (this.generalContractData.getCompanyCode() != null) {
            row.field("COMPANY_CODE", "BUKRS", (ErpType)this.generalContractData.getCompanyCode());
        }
        if (this.generalContractData.getProductType() != null) {
            row.field("PRODUCT_TYPE", "VVSART", (ErpType)this.generalContractData.getProductType());
        }
        if (this.generalContractData.getTransactionType() != null) {
            row.field("TRANSACTION_TYPE", "TB_SFHAART", (ErpType)this.generalContractData.getTransactionType());
        }
        if (this.generalContractData.getExternalTransactionNumber() != null) {
            row.field("EXTERNAL_TRANSACTION_NUMBER", "TB_RFHA", (ErpType)this.generalContractData.getExternalTransactionNumber());
        }
        if (this.generalContractData.getPartner() != null) {
            row.field("PARTNER", "TB_KUNNR_NEW", (ErpType)this.generalContractData.getPartner());
        }
        if (this.generalContractData.getContractDate() != null) {
            row.field("CONTRACT_DATE", "TB_DVTRAB", this.generalContractData.getContractDate());
        }
        if (this.generalContractData.getContractTime() != null) {
            row.field("CONTRACT_TIME", "TB_TVTRAB", this.generalContractData.getContractTime());
        }
        if (this.generalContractData.getContactPerson() != null) {
            row.field("CONTACT_PERSON", "TB_GSPPART", this.generalContractData.getContactPerson());
        }
        if (this.generalContractData.getTrader() != null) {
            row.field("TRADER", "RDEALER", (ErpType)this.generalContractData.getTrader());
        }
        if (this.generalContractData.getAcctAssignmentRef() != null) {
            row.field("ACCT_ASSIGNMENT_REF", "RREFKONT_OBSOLETE", (ErpType)this.generalContractData.getAcctAssignmentRef());
        }
        if (this.generalContractData.getPortfolio() != null) {
            row.field("PORTFOLIO", "RPORTB", (ErpType)this.generalContractData.getPortfolio());
        }
        if (this.generalContractData.getFinanceProject() != null) {
            row.field("FINANCE_PROJECT", "TB_TFPROJ", (ErpType)this.generalContractData.getFinanceProject());
        }
        if (this.generalContractData.getGuarantor() != null) {
            row.field("GUARANTOR", "TB_RGARANT_NEW", (ErpType)this.generalContractData.getGuarantor());
        }
        if (this.generalContractData.getMasterAgreement() != null) {
            row.field("MASTER_AGREEMENT", "TB_RMAID", (ErpType)this.generalContractData.getMasterAgreement());
        }
        if (this.generalContractData.getAssignment() != null) {
            row.field("ASSIGNMENT", "TB_ZUOND", this.generalContractData.getAssignment());
        }
        if (this.generalContractData.getExternalReference() != null) {
            row.field("EXTERNAL_REFERENCE", "TB_NORDEXT", (ErpType)this.generalContractData.getExternalReference());
        }
        if (this.generalContractData.getInternalReference() != null) {
            row.field("INTERNAL_REFERENCE", "TB_REFER", this.generalContractData.getInternalReference());
        }
        if (this.generalContractData.getCharacteristics() != null) {
            row.field("CHARACTERISTICS", "TB_MERKM", this.generalContractData.getCharacteristics());
        }
        if (this.generalContractData.getAuthGroup() != null) {
            row.field("AUTH_GROUP", "TBEGRU", (ErpType)this.generalContractData.getAuthGroup());
        }
        if (this.generalContractData.getCreateUser() != null) {
            row.field("CREATE_USER", "TB_CRUSER", this.generalContractData.getCreateUser());
        }
        if (this.generalContractData.getEntryDate() != null) {
            row.field("ENTRY_DATE", "TB_DCRDAT", this.generalContractData.getEntryDate());
        }
        if (this.generalContractData.getFacility() != null) {
            row.field("FACILITY", "TB_FACILITYNR", (ErpType)this.generalContractData.getFacility());
        }
        if (this.generalContractData.getFacilityCompanyCode() != null) {
            row.field("FACILITY_COMPANY_CODE", "TB_FACILITYBUKRS", (ErpType)this.generalContractData.getFacilityCompanyCode());
        }
        if (this.generalContractData.getValuationClass() != null) {
            row.field("VALUATION_CLASS", "TPM_COM_VAL_CLASS", (ErpType)this.generalContractData.getValuationClass());
        }
        if (this.generalContractData.getFund() != null) {
            row.field("FUND", "FM_FUND", (ErpType)this.generalContractData.getFund());
        }
        if (this.generalContractData.getGrantNbr() != null) {
            row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)this.generalContractData.getGrantNbr());
        }
        if (this.generalContractData.getExpenseKey() != null) {
            row.field("EXPENSE_KEY", "TB_SPESEN", (ErpType)this.generalContractData.getExpenseKey());
        }
        if (this.generalContractData.getReservReason() != null) {
            row.field("RESERV_REASON", "TB_SANST", (ErpType)this.generalContractData.getReservReason());
        }
        if (this.generalContractData.getClearingOption() != null) {
            row.field("CLEARING_OPTION", "TPM_TREA_CLEARING_OPT", (ErpType)this.generalContractData.getClearingOption());
        }
        if (this.generalContractData.getClearingStatus() != null) {
            row.field("CLEARING_STATUS", "TPM_TREA_CLEARING_STATUS", (ErpType)this.generalContractData.getClearingStatus());
        }
        if (this.generalContractData.getClearingDate() != null) {
            row.field("CLEARING_DATE", "TPM_TREA_CLEARING_DATE", this.generalContractData.getClearingDate());
        }
        if (this.generalContractData.getExtAccount() != null) {
            row.field("EXT_ACCOUNT", "TPM_EXT_ACCOUNT", (ErpType)this.generalContractData.getExtAccount());
        }
        if (this.generalContractData.getClearDateAct() != null) {
            row.field("CLEAR_DATE_ACT", "TPM_TREA_CLEARING_DATE_ACT", this.generalContractData.getClearDateAct());
        }
        if (this.generalContractData.getRiskMitigation() != null) {
            row.field("RISK_MITIGATION", "FTR_THRESHOLD_RISK_MITIGATING", (ErpType)this.generalContractData.getRiskMitigation());
        }
        if (this.generalContractData.getLegalBasis() != null) {
            row.field("LEGAL_BASIS", "FTR_THRESHOLD_SCHEME", (ErpType)this.generalContractData.getLegalBasis());
        }
        if (this.generalContractData.getExternalTradeId() != null) {
            row.field("EXTERNAL_TRADE_ID", "FTR_TARO_TRADE_ID", (ErpType)this.generalContractData.getExternalTradeId());
        }
        if (this.generalContractData.getProfitCenter() != null) {
            row.field("PROFIT_CENTER", "PRCTR", (ErpType)this.generalContractData.getProfitCenter());
        }
        if (this.generalContractData.getCostCenter() != null) {
            row.field("COST_CENTER", "KOSTL", (ErpType)this.generalContractData.getCostCenter());
        }
        if (this.generalContractData.getWbsElement() != null) {
            row.field("WBS_ELEMENT", "PS_PSP_PNR", (ErpType)this.generalContractData.getWbsElement());
        }
        if (this.generalContractData.getBusinessArea() != null) {
            row.field("BUSINESS_AREA", "GSBER", (ErpType)this.generalContractData.getBusinessArea());
        }
        if (this.generalContractData.getHedgeClassification() != null) {
            row.field("HEDGE_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION_OLD", (ErpType)this.generalContractData.getHedgeClassification());
        }
        if (this.generalContractData.getInitClassifier() != null) {
            row.field("INIT_CLASSIFIER", "TRPA_INITIAL_STAGE", (ErpType)this.generalContractData.getInitClassifier());
        }
        if (this.generalContractData.getCountry() != null) {
            row.field("COUNTRY", "LAND1", (ErpType)this.generalContractData.getCountry());
        }
        if (this.generalContractData.getCountryIso() != null) {
            row.field("COUNTRY_ISO", "INTCA", (ErpType)this.generalContractData.getCountryIso());
        }
        if (this.generalContractData.getSegment() != null) {
            row.field("SEGMENT", "FB_SEGMENT", (ErpType)this.generalContractData.getSegment());
        }
        if (this.generalContractData.getOnBehalfOfCompany() != null) {
            row.field("ON_BEHALF_OF_COMPANY", "TRBA_BEHALF_OF_COMPANY", (ErpType)this.generalContractData.getOnBehalfOfCompany());
        }
        if (this.generalContractData.getHedgingClassification() != null) {
            row.field("HEDGING_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION", (ErpType)this.generalContractData.getHedgingClassification());
        }
        if (this.generalContractData.getHedgeRequestId() != null) {
            row.field("HEDGE_REQUEST_ID", "TOE_REQUEST_ID", (ErpType)this.generalContractData.getHedgeRequestId());
        }
        row.end();
        query.withImportingAsReturn("FINANCIALTRANSACTION", "BAPI2042");
        query.withImportingAsReturn("COMPANYCODE", "BAPI2042");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult queryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(queryResult);
    }

    public FXOptionCreateCommand testRun(ErpBoolean testRun) {
        this.testRun = testRun;
        return this;
    }

    public FXOptionCreateCommand activityCategory(TransactionActivityCategory activityCategory) {
        this.activityCategory = activityCategory;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FXOptionCreateCommand)) {
            return false;
        }
        FXOptionCreateCommand other = (FXOptionCreateCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CreateAnFxOption this$forex = this.forex;
        CreateAnFxOption other$forex = other.forex;
        if (this$forex == null ? other$forex != null : !((Object)this$forex).equals(other$forex)) {
            return false;
        }
        FtrStructureForCreatingTransactions this$generalContractData = this.generalContractData;
        FtrStructureForCreatingTransactions other$generalContractData = other.generalContractData;
        if (this$generalContractData == null ? other$generalContractData != null : !((Object)this$generalContractData).equals(other$generalContractData)) {
            return false;
        }
        ErpBoolean this$testRun = this.testRun;
        ErpBoolean other$testRun = other.testRun;
        if (this$testRun == null ? other$testRun != null : !this$testRun.equals(other$testRun)) {
            return false;
        }
        TransactionActivityCategory this$activityCategory = this.activityCategory;
        TransactionActivityCategory other$activityCategory = other.activityCategory;
        return !(this$activityCategory == null ? other$activityCategory != null : !((Object)this$activityCategory).equals(other$activityCategory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FXOptionCreateCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CreateAnFxOption $forex = this.forex;
        result = result * 59 + ($forex == null ? 43 : ((Object)$forex).hashCode());
        FtrStructureForCreatingTransactions $generalContractData = this.generalContractData;
        result = result * 59 + ($generalContractData == null ? 43 : ((Object)$generalContractData).hashCode());
        ErpBoolean $testRun = this.testRun;
        result = result * 59 + ($testRun == null ? 43 : $testRun.hashCode());
        TransactionActivityCategory $activityCategory = this.activityCategory;
        result = result * 59 + ($activityCategory == null ? 43 : ((Object)$activityCategory).hashCode());
        return result;
    }

    public String toString() {
        return "FXOptionCreateCommand(forex=" + this.forex + ", generalContractData=" + this.generalContractData + ", testRun=" + this.testRun + ", activityCategory=" + this.activityCategory + ")";
    }

    @ConstructorProperties(value={"forex", "generalContractData"})
    public FXOptionCreateCommand(CreateAnFxOption forex, FtrStructureForCreatingTransactions generalContractData) {
        this.forex = forex;
        this.generalContractData = generalContractData;
    }

    public static class Result {
        private final BapiQueryResult result;

        public Transaction getFinancialtransaction() {
            return (Transaction)((Object)this.result.get("FINANCIALTRANSACTION").getAsObject().as(Transaction.class));
        }

        public CompanyCode getCompanycode() {
            return (CompanyCode)((Object)this.result.get("COMPANYCODE").getAsObject().as(CompanyCode.class));
        }

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "FXOptionCreateCommand.Result(result=" + this.result + ")";
        }
    }
}

