/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ChangeAnFxOption;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ChangeStructureForAnFxOption;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureChangeInformationForChangeMethod;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.FtrStructureForChangingTransactions;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.CompanyCode;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.Transaction;
import com.sap.cloud.sdk.s4hana.serialization.ErpBoolean;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;

public class FXOptionChangeCommand {
    private final FtrStructureChangeInformationForChangeMethod generalContractdataX;
    private final FtrStructureForChangingTransactions generalContractData;
    private final ChangeStructureForAnFxOption forexX;
    private final ChangeAnFxOption forex;
    private ErpBoolean testRun = null;
    private final CompanyCode companycode;
    private final Transaction financialtransaction;

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        this.generalContractdataX.validate();
        this.generalContractData.validate();
        this.forexX.validate();
        this.forex.validate();
        BapiQuery query = new BapiQuery("BAPI_FTR_CHANGE_FXOPTIONS");
        if (this.testRun != null) {
            query.withExporting("TESTRUN", "TESTRUN", (ErpType)this.testRun);
        }
        query.withExporting("COMPANYCODE", "BUKRS", (ErpType)this.companycode);
        query.withExporting("FINANCIALTRANSACTION", "TB_RFHA", (ErpType)this.financialtransaction);
        ParameterFields row = query.withExportingFields("GENERALCONTRACTDATAX", "BAPI_FTR_CHANGEX");
        if (this.generalContractdataX.getContractDate() != null) {
            row.field("CONTRACT_DATE", "BAPIUPDATE", (ErpType)this.generalContractdataX.getContractDate());
        }
        if (this.generalContractdataX.getContractTime() != null) {
            row.field("CONTRACT_TIME", "BAPIUPDATE", (ErpType)this.generalContractdataX.getContractTime());
        }
        if (this.generalContractdataX.getContactPerson() != null) {
            row.field("CONTACT_PERSON", "BAPIUPDATE", (ErpType)this.generalContractdataX.getContactPerson());
        }
        if (this.generalContractdataX.getTrader() != null) {
            row.field("TRADER", "BAPIUPDATE", (ErpType)this.generalContractdataX.getTrader());
        }
        if (this.generalContractdataX.getAcctAssignmentRef() != null) {
            row.field("ACCT_ASSIGNMENT_REF", "BAPIUPDATE", (ErpType)this.generalContractdataX.getAcctAssignmentRef());
        }
        if (this.generalContractdataX.getPortfolio() != null) {
            row.field("PORTFOLIO", "BAPIUPDATE", (ErpType)this.generalContractdataX.getPortfolio());
        }
        if (this.generalContractdataX.getFinanceProject() != null) {
            row.field("FINANCE_PROJECT", "BAPIUPDATE", (ErpType)this.generalContractdataX.getFinanceProject());
        }
        if (this.generalContractdataX.getGuarantor() != null) {
            row.field("GUARANTOR", "BAPIUPDATE", (ErpType)this.generalContractdataX.getGuarantor());
        }
        if (this.generalContractdataX.getAssignment() != null) {
            row.field("ASSIGNMENT", "BAPIUPDATE", (ErpType)this.generalContractdataX.getAssignment());
        }
        if (this.generalContractdataX.getExternalReference() != null) {
            row.field("EXTERNAL_REFERENCE", "BAPIUPDATE", (ErpType)this.generalContractdataX.getExternalReference());
        }
        if (this.generalContractdataX.getInternalReference() != null) {
            row.field("INTERNAL_REFERENCE", "BAPIUPDATE", (ErpType)this.generalContractdataX.getInternalReference());
        }
        if (this.generalContractdataX.getCharacteristics() != null) {
            row.field("CHARACTERISTICS", "BAPIUPDATE", (ErpType)this.generalContractdataX.getCharacteristics());
        }
        if (this.generalContractdataX.getAuthGroup() != null) {
            row.field("AUTH_GROUP", "BAPIUPDATE", (ErpType)this.generalContractdataX.getAuthGroup());
        }
        if (this.generalContractdataX.getFacility() != null) {
            row.field("FACILITY", "BAPIUPDATE", (ErpType)this.generalContractdataX.getFacility());
        }
        if (this.generalContractdataX.getFacilityCompanyCode() != null) {
            row.field("FACILITY_COMPANY_CODE", "BAPIUPDATE", (ErpType)this.generalContractdataX.getFacilityCompanyCode());
        }
        if (this.generalContractdataX.getValuationClass() != null) {
            row.field("VALUATION_CLASS", "BAPIUPDATE", (ErpType)this.generalContractdataX.getValuationClass());
        }
        if (this.generalContractdataX.getFund() != null) {
            row.field("FUND", "BAPIUPDATE", (ErpType)this.generalContractdataX.getFund());
        }
        if (this.generalContractdataX.getGrantNbr() != null) {
            row.field("GRANT_NBR", "BAPIUPDATE", (ErpType)this.generalContractdataX.getGrantNbr());
        }
        if (this.generalContractdataX.getExpenseKey() != null) {
            row.field("EXPENSE_KEY", "BAPIUPDATE", (ErpType)this.generalContractdataX.getExpenseKey());
        }
        if (this.generalContractdataX.getReservReason() != null) {
            row.field("RESERV_REASON", "BAPIUPDATE", (ErpType)this.generalContractdataX.getReservReason());
        }
        if (this.generalContractdataX.getClearingOption() != null) {
            row.field("CLEARING_OPTION", "BAPIUPDATE", (ErpType)this.generalContractdataX.getClearingOption());
        }
        if (this.generalContractdataX.getClearingStatus() != null) {
            row.field("CLEARING_STATUS", "BAPIUPDATE", (ErpType)this.generalContractdataX.getClearingStatus());
        }
        if (this.generalContractdataX.getClearingDate() != null) {
            row.field("CLEARING_DATE", "BAPIUPDATE", (ErpType)this.generalContractdataX.getClearingDate());
        }
        if (this.generalContractdataX.getExtAccount() != null) {
            row.field("EXT_ACCOUNT", "BAPIUPDATE", (ErpType)this.generalContractdataX.getExtAccount());
        }
        if (this.generalContractdataX.getClearDateAct() != null) {
            row.field("CLEAR_DATE_ACT", "BAPIUPDATE", (ErpType)this.generalContractdataX.getClearDateAct());
        }
        if (this.generalContractdataX.getRiskMitigation() != null) {
            row.field("RISK_MITIGATION", "BAPIUPDATE", (ErpType)this.generalContractdataX.getRiskMitigation());
        }
        if (this.generalContractdataX.getLegalBasis() != null) {
            row.field("LEGAL_BASIS", "BAPIUPDATE", (ErpType)this.generalContractdataX.getLegalBasis());
        }
        if (this.generalContractdataX.getExternalTradeId() != null) {
            row.field("EXTERNAL_TRADE_ID", "BAPIUPDATE", (ErpType)this.generalContractdataX.getExternalTradeId());
        }
        if (this.generalContractdataX.getProfitCenter() != null) {
            row.field("PROFIT_CENTER", "BAPIUPDATE", (ErpType)this.generalContractdataX.getProfitCenter());
        }
        if (this.generalContractdataX.getCostCenter() != null) {
            row.field("COST_CENTER", "BAPIUPDATE", (ErpType)this.generalContractdataX.getCostCenter());
        }
        if (this.generalContractdataX.getWbsElement() != null) {
            row.field("WBS_ELEMENT", "BAPIUPDATE", (ErpType)this.generalContractdataX.getWbsElement());
        }
        if (this.generalContractdataX.getBusinessArea() != null) {
            row.field("BUSINESS_AREA", "BAPIUPDATE", (ErpType)this.generalContractdataX.getBusinessArea());
        }
        if (this.generalContractdataX.getHedgeClassification() != null) {
            row.field("HEDGE_CLASSIFICATION", "BAPIUPDATE", (ErpType)this.generalContractdataX.getHedgeClassification());
        }
        if (this.generalContractdataX.getInitClassifier() != null) {
            row.field("INIT_CLASSIFIER", "BAPIUPDATE", (ErpType)this.generalContractdataX.getInitClassifier());
        }
        if (this.generalContractdataX.getCountry() != null) {
            row.field("COUNTRY", "BAPIUPDATE", (ErpType)this.generalContractdataX.getCountry());
        }
        if (this.generalContractdataX.getCountryIso() != null) {
            row.field("COUNTRY_ISO", "BAPIUPDATE", (ErpType)this.generalContractdataX.getCountryIso());
        }
        if (this.generalContractdataX.getSegment() != null) {
            row.field("SEGMENT", "BAPIUPDATE", (ErpType)this.generalContractdataX.getSegment());
        }
        if (this.generalContractdataX.getOnBehalfOfCompany() != null) {
            row.field("ON_BEHALF_OF_COMPANY", "BAPIUPDATE", (ErpType)this.generalContractdataX.getOnBehalfOfCompany());
        }
        if (this.generalContractdataX.getHedgingClassification() != null) {
            row.field("HEDGING_CLASSIFICATION", "BAPIUPDATE", (ErpType)this.generalContractdataX.getHedgingClassification());
        }
        if (this.generalContractdataX.getHedgeRequestId() != null) {
            row.field("HEDGE_REQUEST_ID", "BAPIUPDATE", (ErpType)this.generalContractdataX.getHedgeRequestId());
        }
        row.end();
        row = query.withExportingFields("GENERALCONTRACTDATA", "BAPI_FTR_CHANGE");
        if (this.generalContractData.getContractDate() != null) {
            row.field("CONTRACT_DATE", "TB_DVTRAB", this.generalContractData.getContractDate());
        }
        if (this.generalContractData.getContractTime() != null) {
            row.field("CONTRACT_TIME", "TB_TVTRAB", this.generalContractData.getContractTime());
        }
        if (this.generalContractData.getContactPerson() != null) {
            row.field("CONTACT_PERSON", "TB_GSPPART", this.generalContractData.getContactPerson());
        }
        if (this.generalContractData.getTrader() != null) {
            row.field("TRADER", "RDEALER", (ErpType)this.generalContractData.getTrader());
        }
        if (this.generalContractData.getAcctAssignmentRef() != null) {
            row.field("ACCT_ASSIGNMENT_REF", "RREFKONT_OBSOLETE", (ErpType)this.generalContractData.getAcctAssignmentRef());
        }
        if (this.generalContractData.getPortfolio() != null) {
            row.field("PORTFOLIO", "RPORTB", (ErpType)this.generalContractData.getPortfolio());
        }
        if (this.generalContractData.getFinanceProject() != null) {
            row.field("FINANCE_PROJECT", "TB_TFPROJ", (ErpType)this.generalContractData.getFinanceProject());
        }
        if (this.generalContractData.getGuarantor() != null) {
            row.field("GUARANTOR", "TB_RGARANT_NEW", (ErpType)this.generalContractData.getGuarantor());
        }
        if (this.generalContractData.getAssignment() != null) {
            row.field("ASSIGNMENT", "TB_ZUOND", this.generalContractData.getAssignment());
        }
        if (this.generalContractData.getExternalReference() != null) {
            row.field("EXTERNAL_REFERENCE", "TB_NORDEXT", (ErpType)this.generalContractData.getExternalReference());
        }
        if (this.generalContractData.getInternalReference() != null) {
            row.field("INTERNAL_REFERENCE", "TB_REFER", this.generalContractData.getInternalReference());
        }
        if (this.generalContractData.getCharacteristics() != null) {
            row.field("CHARACTERISTICS", "TB_MERKM", this.generalContractData.getCharacteristics());
        }
        if (this.generalContractData.getAuthGroup() != null) {
            row.field("AUTH_GROUP", "TBEGRU", (ErpType)this.generalContractData.getAuthGroup());
        }
        if (this.generalContractData.getFacility() != null) {
            row.field("FACILITY", "TB_FACILITYNR", (ErpType)this.generalContractData.getFacility());
        }
        if (this.generalContractData.getFacilityCompanyCode() != null) {
            row.field("FACILITY_COMPANY_CODE", "TB_FACILITYBUKRS", (ErpType)this.generalContractData.getFacilityCompanyCode());
        }
        if (this.generalContractData.getValuationClass() != null) {
            row.field("VALUATION_CLASS", "TPM_COM_VAL_CLASS", (ErpType)this.generalContractData.getValuationClass());
        }
        if (this.generalContractData.getFund() != null) {
            row.field("FUND", "FM_FUND", (ErpType)this.generalContractData.getFund());
        }
        if (this.generalContractData.getGrantNbr() != null) {
            row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)this.generalContractData.getGrantNbr());
        }
        if (this.generalContractData.getExpenseKey() != null) {
            row.field("EXPENSE_KEY", "TB_SPESEN", (ErpType)this.generalContractData.getExpenseKey());
        }
        if (this.generalContractData.getReservReason() != null) {
            row.field("RESERV_REASON", "TB_SANST", (ErpType)this.generalContractData.getReservReason());
        }
        if (this.generalContractData.getClearingOption() != null) {
            row.field("CLEARING_OPTION", "TPM_TREA_CLEARING_OPT", (ErpType)this.generalContractData.getClearingOption());
        }
        if (this.generalContractData.getClearingStatus() != null) {
            row.field("CLEARING_STATUS", "TPM_TREA_CLEARING_STATUS", (ErpType)this.generalContractData.getClearingStatus());
        }
        if (this.generalContractData.getClearingDate() != null) {
            row.field("CLEARING_DATE", "TPM_TREA_CLEARING_DATE", this.generalContractData.getClearingDate());
        }
        if (this.generalContractData.getExtAccount() != null) {
            row.field("EXT_ACCOUNT", "TPM_EXT_ACCOUNT", (ErpType)this.generalContractData.getExtAccount());
        }
        if (this.generalContractData.getClearDateAct() != null) {
            row.field("CLEAR_DATE_ACT", "TPM_TREA_CLEARING_DATE_ACT", this.generalContractData.getClearDateAct());
        }
        if (this.generalContractData.getRiskMitigation() != null) {
            row.field("RISK_MITIGATION", "FTR_THRESHOLD_RISK_MITIGATING", (ErpType)this.generalContractData.getRiskMitigation());
        }
        if (this.generalContractData.getLegalBasis() != null) {
            row.field("LEGAL_BASIS", "FTR_THRESHOLD_SCHEME", (ErpType)this.generalContractData.getLegalBasis());
        }
        if (this.generalContractData.getExternalTradeId() != null) {
            row.field("EXTERNAL_TRADE_ID", "FTR_TARO_TRADE_ID", (ErpType)this.generalContractData.getExternalTradeId());
        }
        if (this.generalContractData.getProfitCenter() != null) {
            row.field("PROFIT_CENTER", "PRCTR", (ErpType)this.generalContractData.getProfitCenter());
        }
        if (this.generalContractData.getCostCenter() != null) {
            row.field("COST_CENTER", "KOSTL", (ErpType)this.generalContractData.getCostCenter());
        }
        if (this.generalContractData.getWbsElement() != null) {
            row.field("WBS_ELEMENT", "PS_PSP_PNR", (ErpType)this.generalContractData.getWbsElement());
        }
        if (this.generalContractData.getBusinessArea() != null) {
            row.field("BUSINESS_AREA", "GSBER", (ErpType)this.generalContractData.getBusinessArea());
        }
        if (this.generalContractData.getHedgeClassification() != null) {
            row.field("HEDGE_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION_OLD", (ErpType)this.generalContractData.getHedgeClassification());
        }
        if (this.generalContractData.getInitClassifier() != null) {
            row.field("INIT_CLASSIFIER", "TRPA_INITIAL_STAGE", (ErpType)this.generalContractData.getInitClassifier());
        }
        if (this.generalContractData.getCountry() != null) {
            row.field("COUNTRY", "LAND1", (ErpType)this.generalContractData.getCountry());
        }
        if (this.generalContractData.getCountryIso() != null) {
            row.field("COUNTRY_ISO", "INTCA", (ErpType)this.generalContractData.getCountryIso());
        }
        if (this.generalContractData.getSegment() != null) {
            row.field("SEGMENT", "FB_SEGMENT", (ErpType)this.generalContractData.getSegment());
        }
        if (this.generalContractData.getOnBehalfOfCompany() != null) {
            row.field("ON_BEHALF_OF_COMPANY", "TRBA_BEHALF_OF_COMPANY", (ErpType)this.generalContractData.getOnBehalfOfCompany());
        }
        if (this.generalContractData.getHedgingClassification() != null) {
            row.field("HEDGING_CLASSIFICATION", "TOE_HEDGING_CLASSIFICATION", (ErpType)this.generalContractData.getHedgingClassification());
        }
        if (this.generalContractData.getHedgeRequestId() != null) {
            row.field("HEDGE_REQUEST_ID", "TOE_REQUEST_ID", (ErpType)this.generalContractData.getHedgeRequestId());
        }
        row.end();
        row = query.withExportingFields("FOREXX", "BAPI_FTR_CHANGE_FXOPTIONX");
        if (this.forexX.getOptionType() != null) {
            row.field("OPTION_TYPE", "BAPIUPDATE", (ErpType)this.forexX.getOptionType());
        }
        if (this.forexX.getLeadCurrency() != null) {
            row.field("LEAD_CURRENCY", "BAPIUPDATE", (ErpType)this.forexX.getLeadCurrency());
        }
        if (this.forexX.getLeadCurrencyIso() != null) {
            row.field("LEAD_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.forexX.getLeadCurrencyIso());
        }
        if (this.forexX.getFollowCurrency() != null) {
            row.field("FOLLOW_CURRENCY", "BAPIUPDATE", (ErpType)this.forexX.getFollowCurrency());
        }
        if (this.forexX.getFollowCurrencyIso() != null) {
            row.field("FOLLOW_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.forexX.getFollowCurrencyIso());
        }
        if (this.forexX.getStrikeRate() != null) {
            row.field("STRIKE_RATE", "BAPIUPDATE", (ErpType)this.forexX.getStrikeRate());
        }
        if (this.forexX.getUnderlyingAmount() != null) {
            row.field("UNDERLYING_AMOUNT", "BAPIUPDATE", (ErpType)this.forexX.getUnderlyingAmount());
        }
        if (this.forexX.getUnderlyingCurrency() != null) {
            row.field("UNDERLYING_CURRENCY", "BAPIUPDATE", (ErpType)this.forexX.getUnderlyingCurrency());
        }
        if (this.forexX.getUnderlyingCurrencyIso() != null) {
            row.field("UNDERLYING_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.forexX.getUnderlyingCurrencyIso());
        }
        if (this.forexX.getUnderlyingValueDate() != null) {
            row.field("UNDERLYING_VALUE_DATE", "BAPIUPDATE", (ErpType)this.forexX.getUnderlyingValueDate());
        }
        if (this.forexX.getExpirationDate() != null) {
            row.field("EXPIRATION_DATE", "BAPIUPDATE", (ErpType)this.forexX.getExpirationDate());
        }
        if (this.forexX.getExerciseType() != null) {
            row.field("EXERCISE_TYPE", "BAPIUPDATE", (ErpType)this.forexX.getExerciseType());
        }
        if (this.forexX.getSettlementIndicator() != null) {
            row.field("SETTLEMENT_INDICATOR", "BAPIUPDATE", (ErpType)this.forexX.getSettlementIndicator());
        }
        if (this.forexX.getBarrierRate1() != null) {
            row.field("BARRIER_RATE_1", "BAPIUPDATE", (ErpType)this.forexX.getBarrierRate1());
        }
        if (this.forexX.getBarrierRate2() != null) {
            row.field("BARRIER_RATE_2", "BAPIUPDATE", (ErpType)this.forexX.getBarrierRate2());
        }
        if (this.forexX.getPutCallIndicator() != null) {
            row.field("PUT_CALL_INDICATOR", "BAPIUPDATE", (ErpType)this.forexX.getPutCallIndicator());
        }
        if (this.forexX.getRatePercentage() != null) {
            row.field("RATE_PERCENTAGE", "BAPIUPDATE", (ErpType)this.forexX.getRatePercentage());
        }
        if (this.forexX.getFlowType() != null) {
            row.field("FLOW_TYPE", "BAPIUPDATE", (ErpType)this.forexX.getFlowType());
        }
        if (this.forexX.getCurrencyOptionPremium() != null) {
            row.field("CURRENCY_OPTION_PREMIUM", "BAPIUPDATE", (ErpType)this.forexX.getCurrencyOptionPremium());
        }
        if (this.forexX.getPaymentDateOption() != null) {
            row.field("PAYMENT_DATE_OPTION", "BAPIUPDATE", (ErpType)this.forexX.getPaymentDateOption());
        }
        if (this.forexX.getPaymentAmount() != null) {
            row.field("PAYMENT_AMOUNT", "BAPIUPDATE", (ErpType)this.forexX.getPaymentAmount());
        }
        if (this.forexX.getPaymentCurrency() != null) {
            row.field("PAYMENT_CURRENCY", "BAPIUPDATE", (ErpType)this.forexX.getPaymentCurrency());
        }
        if (this.forexX.getPaymentCurrencyIso() != null) {
            row.field("PAYMENT_CURRENCY_ISO", "BAPIUPDATE", (ErpType)this.forexX.getPaymentCurrencyIso());
        }
        if (this.forexX.getSpotRate() != null) {
            row.field("SPOT_RATE", "BAPIUPDATE", (ErpType)this.forexX.getSpotRate());
        }
        if (this.forexX.getSwapRate() != null) {
            row.field("SWAP_RATE", "BAPIUPDATE", (ErpType)this.forexX.getSwapRate());
        }
        row.end();
        row = query.withExportingFields("FOREX", "BAPI_FTR_CHANGE_FXOPTION");
        if (this.forex.getOptionType() != null) {
            row.field("OPTION_TYPE", "TV_OPTTYP", (ErpType)this.forex.getOptionType());
        }
        if (this.forex.getLeadCurrency() != null) {
            row.field("LEAD_CURRENCY", "TB_WLWAERS", (ErpType)this.forex.getLeadCurrency());
        }
        if (this.forex.getLeadCurrencyIso() != null) {
            row.field("LEAD_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getLeadCurrencyIso());
        }
        if (this.forex.getFollowCurrency() != null) {
            row.field("FOLLOW_CURRENCY", "TB_WFWAERS", (ErpType)this.forex.getFollowCurrency());
        }
        if (this.forex.getFollowCurrencyIso() != null) {
            row.field("FOLLOW_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getFollowCurrencyIso());
        }
        if (this.forex.getStrikeRate() != null) {
            row.field("STRIKE_RATE", "TB_KKURS", (ErpType)this.forex.getStrikeRate());
        }
        if (this.forex.getUnderlyingAmount() != null) {
            row.field("UNDERLYING_AMOUNT", "BAPITM_BZBETR", (ErpType)this.forex.getUnderlyingAmount());
        }
        if (this.forex.getUnderlyingCurrency() != null) {
            row.field("UNDERLYING_CURRENCY", "TB_WZBETR", (ErpType)this.forex.getUnderlyingCurrency());
        }
        if (this.forex.getUnderlyingCurrencyIso() != null) {
            row.field("UNDERLYING_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getUnderlyingCurrencyIso());
        }
        if (this.forex.getUnderlyingValueDate() != null) {
            row.field("UNDERLYING_VALUE_DATE", "TB_DVALUTA", this.forex.getUnderlyingValueDate());
        }
        if (this.forex.getExpirationDate() != null) {
            row.field("EXPIRATION_DATE", "TB_DMATUR", this.forex.getExpirationDate());
        }
        if (this.forex.getExerciseType() != null) {
            row.field("EXERCISE_TYPE", "SOPTAUS", (ErpType)this.forex.getExerciseType());
        }
        if (this.forex.getSettlementIndicator() != null) {
            row.field("SETTLEMENT_INDICATOR", "TI_SETTLFL", (ErpType)this.forex.getSettlementIndicator());
        }
        if (this.forex.getBarrierRate1() != null) {
            row.field("BARRIER_RATE_1", "TX_KWKURB1", (ErpType)this.forex.getBarrierRate1());
        }
        if (this.forex.getBarrierRate2() != null) {
            row.field("BARRIER_RATE_2", "TX_KWKURB2", (ErpType)this.forex.getBarrierRate2());
        }
        if (this.forex.getPutCallIndicator() != null) {
            row.field("PUT_CALL_INDICATOR", "TI_SPUTCAL", (ErpType)this.forex.getPutCallIndicator());
        }
        if (this.forex.getRatePercentage() != null) {
            row.field("RATE_PERCENTAGE", "TB_PWKURS", (ErpType)this.forex.getRatePercentage());
        }
        if (this.forex.getFlowType() != null) {
            row.field("FLOW_TYPE", "TB_SFHAZBA", (ErpType)this.forex.getFlowType());
        }
        if (this.forex.getCurrencyOptionPremium() != null) {
            row.field("CURRENCY_OPTION_PREMIUM", "TI_PRKUR", (ErpType)this.forex.getCurrencyOptionPremium());
        }
        if (this.forex.getPaymentDateOption() != null) {
            row.field("PAYMENT_DATE_OPTION", "TB_DZTERM", this.forex.getPaymentDateOption());
        }
        if (this.forex.getPaymentAmount() != null) {
            row.field("PAYMENT_AMOUNT", "BAPITM_BZBETR", (ErpType)this.forex.getPaymentAmount());
        }
        if (this.forex.getPaymentCurrency() != null) {
            row.field("PAYMENT_CURRENCY", "TB_WZBETR", (ErpType)this.forex.getPaymentCurrency());
        }
        if (this.forex.getPaymentCurrencyIso() != null) {
            row.field("PAYMENT_CURRENCY_ISO", "ISOCD", (ErpType)this.forex.getPaymentCurrencyIso());
        }
        if (this.forex.getSpotRate() != null) {
            row.field("SPOT_RATE", "TB_KKASSA", (ErpType)this.forex.getSpotRate());
        }
        if (this.forex.getSwapRate() != null) {
            row.field("SWAP_RATE", "TB_KSWAP", (ErpType)this.forex.getSwapRate());
        }
        row.end();
        query.withImportingAsReturn("RETURNFINANCIALTRANSACTION", "BAPI2042");
        query.withImportingAsReturn("RETURNCOMPANYCODE", "BAPI2042");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult queryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(queryResult);
    }

    public FXOptionChangeCommand testRun(ErpBoolean testRun) {
        this.testRun = testRun;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FXOptionChangeCommand)) {
            return false;
        }
        FXOptionChangeCommand other = (FXOptionChangeCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FtrStructureChangeInformationForChangeMethod this$generalContractdataX = this.generalContractdataX;
        FtrStructureChangeInformationForChangeMethod other$generalContractdataX = other.generalContractdataX;
        if (this$generalContractdataX == null ? other$generalContractdataX != null : !((Object)this$generalContractdataX).equals(other$generalContractdataX)) {
            return false;
        }
        FtrStructureForChangingTransactions this$generalContractData = this.generalContractData;
        FtrStructureForChangingTransactions other$generalContractData = other.generalContractData;
        if (this$generalContractData == null ? other$generalContractData != null : !((Object)this$generalContractData).equals(other$generalContractData)) {
            return false;
        }
        ChangeStructureForAnFxOption this$forexX = this.forexX;
        ChangeStructureForAnFxOption other$forexX = other.forexX;
        if (this$forexX == null ? other$forexX != null : !((Object)this$forexX).equals(other$forexX)) {
            return false;
        }
        ChangeAnFxOption this$forex = this.forex;
        ChangeAnFxOption other$forex = other.forex;
        if (this$forex == null ? other$forex != null : !((Object)this$forex).equals(other$forex)) {
            return false;
        }
        ErpBoolean this$testRun = this.testRun;
        ErpBoolean other$testRun = other.testRun;
        if (this$testRun == null ? other$testRun != null : !this$testRun.equals(other$testRun)) {
            return false;
        }
        CompanyCode this$companycode = this.companycode;
        CompanyCode other$companycode = other.companycode;
        if (this$companycode == null ? other$companycode != null : !((Object)((Object)this$companycode)).equals((Object)other$companycode)) {
            return false;
        }
        Transaction this$financialtransaction = this.financialtransaction;
        Transaction other$financialtransaction = other.financialtransaction;
        return !(this$financialtransaction == null ? other$financialtransaction != null : !((Object)((Object)this$financialtransaction)).equals((Object)other$financialtransaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FXOptionChangeCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FtrStructureChangeInformationForChangeMethod $generalContractdataX = this.generalContractdataX;
        result = result * 59 + ($generalContractdataX == null ? 43 : ((Object)$generalContractdataX).hashCode());
        FtrStructureForChangingTransactions $generalContractData = this.generalContractData;
        result = result * 59 + ($generalContractData == null ? 43 : ((Object)$generalContractData).hashCode());
        ChangeStructureForAnFxOption $forexX = this.forexX;
        result = result * 59 + ($forexX == null ? 43 : ((Object)$forexX).hashCode());
        ChangeAnFxOption $forex = this.forex;
        result = result * 59 + ($forex == null ? 43 : ((Object)$forex).hashCode());
        ErpBoolean $testRun = this.testRun;
        result = result * 59 + ($testRun == null ? 43 : $testRun.hashCode());
        CompanyCode $companycode = this.companycode;
        result = result * 59 + ($companycode == null ? 43 : ((Object)((Object)$companycode)).hashCode());
        Transaction $financialtransaction = this.financialtransaction;
        result = result * 59 + ($financialtransaction == null ? 43 : ((Object)((Object)$financialtransaction)).hashCode());
        return result;
    }

    public String toString() {
        return "FXOptionChangeCommand(generalContractdataX=" + this.generalContractdataX + ", generalContractData=" + this.generalContractData + ", forexX=" + this.forexX + ", forex=" + this.forex + ", testRun=" + this.testRun + ", companycode=" + (Object)((Object)this.companycode) + ", financialtransaction=" + (Object)((Object)this.financialtransaction) + ")";
    }

    @ConstructorProperties(value={"generalContractdataX", "generalContractData", "forexX", "forex", "companycode", "financialtransaction"})
    public FXOptionChangeCommand(FtrStructureChangeInformationForChangeMethod generalContractdataX, FtrStructureForChangingTransactions generalContractData, ChangeStructureForAnFxOption forexX, ChangeAnFxOption forex, CompanyCode companycode, Transaction financialtransaction) {
        this.generalContractdataX = generalContractdataX;
        this.generalContractData = generalContractData;
        this.forexX = forexX;
        this.forex = forex;
        this.companycode = companycode;
        this.financialtransaction = financialtransaction;
    }

    public static class Result {
        private final BapiQueryResult result;

        public Transaction getFinancialTransaction() {
            return (Transaction)((Object)this.result.get("RETURNFINANCIALTRANSACTION").getAsObject().as(Transaction.class));
        }

        public CompanyCode getCompanyCode() {
            return (CompanyCode)((Object)this.result.get("RETURNCOMPANYCODE").getAsObject().as(CompanyCode.class));
        }

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "FXOptionChangeCommand.Result(result=" + this.result + ")";
        }
    }
}

