/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ContainerForCustomerExitParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.DocumentHeaderPostCostsRevenuesActualPostings;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.LineItemsRepostPrimaryCostsActualPosting;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingCoPaAcctAssignmentCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.NumberOfAControllingDocument;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;

public class AcctngRepstPrimCostsPostCommand {
    private final DocumentHeaderPostCostsRevenuesActualPostings docHeader;
    private String ignoreWarnings = null;
    @NonNull
    private final Iterable<LineItemsRepostPrimaryCostsActualPosting> docItems;
    @NonNull
    private Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> sendCriteria = Lists.newArrayList();
    @NonNull
    private Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> recCriteria = Lists.newArrayList();
    @NonNull
    private Iterable<ContainerForCustomerExitParameter> customerFields = Lists.newArrayList();

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        TableRow row;
        this.docHeader.validate();
        if (this.ignoreWarnings != null && this.ignoreWarnings.length() > 1) {
            throw new IllegalArgumentException("Bapi method parameter \"ignoreWarnings\" contains an invalid structure. Structure attribute \"IGNWARN\" / Function parameter \"ignoreWarnings\" must have at most 1 characters. The given value is too long.");
        }
        for (LineItemsRepostPrimaryCostsActualPosting lineItemsRepostPrimaryCostsActualPosting : this.docItems) {
            lineItemsRepostPrimaryCostsActualPosting.validate();
        }
        if (this.sendCriteria != null) {
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.sendCriteria) {
                postingInAccountingCoPaAcctAssignmentCharacteristic.validate();
            }
        }
        if (this.recCriteria != null) {
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.recCriteria) {
                postingInAccountingCoPaAcctAssignmentCharacteristic.validate();
            }
        }
        if (this.customerFields != null) {
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.customerFields) {
                containerForCustomerExitParameter.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_ACC_PRIMARY_COSTS_POST");
        if (this.ignoreWarnings != null) {
            query.withExporting("IGNORE_WARNINGS", "BAPIIGNWAR", this.ignoreWarnings);
        }
        ParameterFields parameterFields = query.withExportingFields("DOC_HEADER", "BAPIDOCHDRU12P");
        if (this.docHeader.getCoArea() != null) {
            parameterFields.field("CO_AREA", "KOKRS", (ErpType)this.docHeader.getCoArea());
        }
        if (this.docHeader.getDocdate() != null) {
            parameterFields.field("DOCDATE", "CO_BLDAT", this.docHeader.getDocdate());
        }
        if (this.docHeader.getPostgdate() != null) {
            parameterFields.field("POSTGDATE", "CO_BUDAT", this.docHeader.getPostgdate());
        }
        if (this.docHeader.getPeriod() != null) {
            parameterFields.field("PERIOD", "CO_PERIO", (ErpType)this.docHeader.getPeriod());
        }
        if (this.docHeader.getDocNo() != null) {
            parameterFields.field("DOC_NO", "CO_BELNR", (ErpType)this.docHeader.getDocNo());
        }
        if (this.docHeader.getVariant() != null) {
            parameterFields.field("VARIANT", "CO_VARNR", (ErpType)this.docHeader.getVariant());
        }
        if (this.docHeader.getDocHdrTx() != null) {
            parameterFields.field("DOC_HDR_TX", "CO_BLTXT", this.docHeader.getDocHdrTx());
        }
        if (this.docHeader.getUsername() != null) {
            parameterFields.field("USERNAME", "USNAM", (ErpType)this.docHeader.getUsername());
        }
        if (this.docHeader.getObjKey() != null) {
            parameterFields.field("OBJ_KEY", "AWKEY", (ErpType)this.docHeader.getObjKey());
        }
        if (this.docHeader.getObjType() != null) {
            parameterFields.field("OBJ_TYPE", "AWTYP", (ErpType)this.docHeader.getObjType());
        }
        if (this.docHeader.getObjSys() != null) {
            parameterFields.field("OBJ_SYS", "AWSYS", (ErpType)this.docHeader.getObjSys());
        }
        if (this.docHeader.getTransCurr() != null) {
            parameterFields.field("TRANS_CURR", "TWAER", (ErpType)this.docHeader.getTransCurr());
        }
        if (this.docHeader.getTransCurrIso() != null) {
            parameterFields.field("TRANS_CURR_ISO", "ISOCD", (ErpType)this.docHeader.getTransCurrIso());
        }
        if (this.docHeader.getDocType() != null) {
            parameterFields.field("DOC_TYPE", "BLART", (ErpType)this.docHeader.getDocType());
        }
        if (this.docHeader.getLedgerGroup() != null) {
            parameterFields.field("LEDGER_GROUP", "LEDGER_GROUP", (ErpType)this.docHeader.getLedgerGroup());
        }
        if (this.docHeader.getAccPrinciple() != null) {
            parameterFields.field("ACC_PRINCIPLE", "ACCOUNTING_PRINCIPLE", (ErpType)this.docHeader.getAccPrinciple());
        }
        if (this.docHeader.getValuedate() != null) {
            parameterFields.field("VALUEDATE", "CO_WSDAT", this.docHeader.getValuedate());
        }
        parameterFields.end();
        if (this.docItems.iterator().hasNext()) {
            Table table = query.withTable("DOC_ITEMS", "BAPIRCITM");
            for (LineItemsRepostPrimaryCostsActualPosting lineItemsRepostPrimaryCostsActualPosting : this.docItems) {
                row = table.row();
                if (lineItemsRepostPrimaryCostsActualPosting.getSendCctr() != null) {
                    row.field("SEND_CCTR", "SKOSTL", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSendCctr());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenOrder() != null) {
                    row.field("SEN_ORDER", "SAUFNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenOrder());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenWbsEl() != null) {
                    row.field("SEN_WBS_EL", "S_PS_POSID", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenWbsEl());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenNetwrk() != null) {
                    row.field("SEN_NETWRK", "SNPLN", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenNetwrk());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenoperatn() != null) {
                    row.field("SENOPERATN", "SVORG", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenoperatn());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSensaleord() != null) {
                    row.field("SENSALEORD", "SKDAU", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSensaleord());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenitem() != null) {
                    row.field("SENITEM", "SKDPO", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenitem());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSencostobj() != null) {
                    row.field("SENCOSTOBJ", "SKSTRG", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSencostobj());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getCostElem() != null) {
                    row.field("COST_ELEM", "KSTAR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getCostElem());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getValueTcur() != null) {
                    row.field("VALUE_TCUR", "BGTXXX", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getValueTcur());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getQuantity() != null) {
                    row.field("QUANTITY", "MBGXXX", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getQuantity());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getPostquun() != null) {
                    row.field("POSTQUUN", "MEINB", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getPostquun());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getPostquunIso() != null) {
                    row.field("POSTQUUN_ISO", "ISOCD_UNIT", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getPostquunIso());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getPersonNo() != null) {
                    row.field("PERSON_NO", "PERNR_D", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getPersonNo());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSegText() != null) {
                    row.field("SEG_TEXT", "CO_SGTXT", lineItemsRepostPrimaryCostsActualPosting.getSegText());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecCctr() != null) {
                    row.field("REC_CCTR", "EKOSTL", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecCctr());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecOrder() != null) {
                    row.field("REC_ORDER", "EAUFNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecOrder());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecWbsEl() != null) {
                    row.field("REC_WBS_EL", "E_PS_POSID", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecWbsEl());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecNetwrk() != null) {
                    row.field("REC_NETWRK", "ENPLN", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecNetwrk());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecoperatn() != null) {
                    row.field("RECOPERATN", "EVORG", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecoperatn());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecsaleord() != null) {
                    row.field("RECSALEORD", "EKDAU", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecsaleord());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecitem() != null) {
                    row.field("RECITEM", "EKDPO", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecitem());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getReccostobj() != null) {
                    row.field("RECCOSTOBJ", "EKSTR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getReccostobj());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecacttype() != null) {
                    row.field("RECACTTYPE", "E_LSTAR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecacttype());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenCalcMotive() != null) {
                    row.field("SEN_CALC_MOTIVE", "SBEMOT", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenCalcMotive());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecCalcMotive() != null) {
                    row.field("REC_CALC_MOTIVE", "EBEMOT", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecCalcMotive());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenacttype() != null) {
                    row.field("SENACTTYPE", "S_LSTAR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenacttype());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenbusproc() != null) {
                    row.field("SENBUSPROC", "SPRZNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenbusproc());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecbusproc() != null) {
                    row.field("RECBUSPROC", "EPRZNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecbusproc());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreCompCode() != null) {
                    row.field("SRE_COMP_CODE", "VVSBUKRS", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreCompCode());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreBusEnt() != null) {
                    row.field("SRE_BUS_ENT", "SSWENR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreBusEnt());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreProperty() != null) {
                    row.field("SRE_PROPERTY", "SSGRNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreProperty());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreBuilding() != null) {
                    row.field("SRE_BUILDING", "SSGENR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreBuilding());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreRentUnit() != null) {
                    row.field("SRE_RENT_UNIT", "SSMENR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreRentUnit());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreLease() != null) {
                    row.field("SRE_LEASE", "SSMIVE", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreLease());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreMgmtCon() != null) {
                    row.field("SRE_MGMT_CON", "VVSSVWNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreMgmtCon());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreIncExp() != null) {
                    row.field("SRE_INC_EXP", "SSNKSL", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreIncExp());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreSettUnit() != null) {
                    row.field("SRE_SETT_UNIT", "SSEMPSL", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreSettUnit());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreRefDate() != null) {
                    row.field("SRE_REF_DATE", "SDABRBEZ", lineItemsRepostPrimaryCostsActualPosting.getSreRefDate());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSreConNo() != null) {
                    row.field("SRE_CON_NO", "RESCNNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSreConNo());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreCompCode() != null) {
                    row.field("RRE_COMP_CODE", "EBUKRS", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreCompCode());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreBusEnt() != null) {
                    row.field("RRE_BUS_ENT", "ESWENR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreBusEnt());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreProperty() != null) {
                    row.field("RRE_PROPERTY", "ESGRNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreProperty());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreBuilding() != null) {
                    row.field("RRE_BUILDING", "ESGENR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreBuilding());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreRentUnit() != null) {
                    row.field("RRE_RENT_UNIT", "ESMENR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreRentUnit());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreLease() != null) {
                    row.field("RRE_LEASE", "ESMIVE", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreLease());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreMgmtCon() != null) {
                    row.field("RRE_MGMT_CON", "VVESVWNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreMgmtCon());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreIncExp() != null) {
                    row.field("RRE_INC_EXP", "ESNKSL", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreIncExp());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreSettUnit() != null) {
                    row.field("RRE_SETT_UNIT", "ESEMPSL", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreSettUnit());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreRefDate() != null) {
                    row.field("RRE_REF_DATE", "EDABRBEZ", lineItemsRepostPrimaryCostsActualPosting.getRreRefDate());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRreConNo() != null) {
                    row.field("RRE_CON_NO", "REECNNR", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRreConNo());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSendFund() != null) {
                    row.field("SEND_FUND", "FM_SFONDS", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSendFund());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSendFunction() != null) {
                    row.field("SEND_FUNCTION", "SFKTBER", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSendFunction());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecFund() != null) {
                    row.field("REC_FUND", "FM_EFONDS", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecFund());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecFunction() != null) {
                    row.field("REC_FUNCTION", "EFKTBER", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecFunction());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSendGrant() != null) {
                    row.field("SEND_GRANT", "GM_GRANT_SENDER", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSendGrant());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecGrant() != null) {
                    row.field("REC_GRANT", "GM_GRANT_RECEIVER", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecGrant());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getTransCurr() != null) {
                    row.field("TRANS_CURR", "TWAER", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getTransCurr());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getTransCurrIso() != null) {
                    row.field("TRANS_CURR_ISO", "ISOCD", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getTransCurrIso());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getItemnoAcc());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getEpaobj() != null) {
                    row.field("EPAOBJ", "EPAOBJNR_ABA", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getEpaobj());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSendFundLong() != null) {
                    row.field("SEND_FUND_LONG", "FM_SGEBER_LONG", lineItemsRepostPrimaryCostsActualPosting.getSendFundLong());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecFundLong() != null) {
                    row.field("REC_FUND_LONG", "FM_RGEBER_LONG", lineItemsRepostPrimaryCostsActualPosting.getRecFundLong());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSendBudgetPeriod() != null) {
                    row.field("SEND_BUDGET_PERIOD", "FM_SBUDGET_PERIOD", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSendBudgetPeriod());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecBudgetPeriod() != null) {
                    row.field("REC_BUDGET_PERIOD", "FM_EBUDGET_PERIOD", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecBudgetPeriod());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenRsrce() != null) {
                    row.field("SEN_RSRCE", "SRSRCE", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getSenRsrce());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecRsrce() != null) {
                    row.field("REC_RSRCE", "ERSRCE", (ErpType)lineItemsRepostPrimaryCostsActualPosting.getRecRsrce());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getRecWorkItm() != null) {
                    row.field("REC_WORK_ITM", "EWORKITM", lineItemsRepostPrimaryCostsActualPosting.getRecWorkItm());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getServDate() != null) {
                    row.field("SERV_DATE", "BAPI_FBUDA", lineItemsRepostPrimaryCostsActualPosting.getServDate());
                }
                if (lineItemsRepostPrimaryCostsActualPosting.getSenWorkItm() == null) continue;
                row.field("SEN_WORK_ITM", "SWORKITM", lineItemsRepostPrimaryCostsActualPosting.getSenWorkItm());
            }
            table.end();
        }
        if (this.sendCriteria != null && this.sendCriteria.iterator().hasNext()) {
            Table table = query.withTable("SEND_CRITERIA", "BAPIACKECR");
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.sendCriteria) {
                row = table.row();
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter() == null) continue;
                row.field("CHARACTER", "RKE_CRIGEN", postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter());
            }
            table.end();
        }
        if (this.recCriteria != null && this.recCriteria.iterator().hasNext()) {
            Table table = query.withTable("REC_CRITERIA", "BAPIACKECR");
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.recCriteria) {
                row = table.row();
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter() == null) continue;
                row.field("CHARACTER", "RKE_CRIGEN", postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter());
            }
            table.end();
        }
        if (this.customerFields != null && this.customerFields.iterator().hasNext()) {
            Table table = query.withTable("CUSTOMER_FIELDS", "BAPIEXTC");
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.customerFields) {
                row = table.row();
                if (containerForCustomerExitParameter.getField1() != null) {
                    row.field("FIELD1", "STRNG250", containerForCustomerExitParameter.getField1());
                }
                if (containerForCustomerExitParameter.getField2() != null) {
                    row.field("FIELD2", "STRNG250", containerForCustomerExitParameter.getField2());
                }
                if (containerForCustomerExitParameter.getField3() != null) {
                    row.field("FIELD3", "STRNG250", containerForCustomerExitParameter.getField3());
                }
                if (containerForCustomerExitParameter.getField4() == null) continue;
                row.field("FIELD4", "STRNG250", containerForCustomerExitParameter.getField4());
            }
            table.end();
        }
        query.withImportingAsReturn("DOC_NO", "BAPIDOCHDRU12P");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult bapiQueryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(bapiQueryResult);
    }

    public AcctngRepstPrimCostsPostCommand sendCriteria(PostingInAccountingCoPaAcctAssignmentCharacteristic ... items) {
        this.sendCriteria = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngRepstPrimCostsPostCommand recCriteria(PostingInAccountingCoPaAcctAssignmentCharacteristic ... items) {
        this.recCriteria = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngRepstPrimCostsPostCommand customerFields(ContainerForCustomerExitParameter ... items) {
        this.customerFields = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngRepstPrimCostsPostCommand ignoreWarnings(String ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcctngRepstPrimCostsPostCommand)) {
            return false;
        }
        AcctngRepstPrimCostsPostCommand other = (AcctngRepstPrimCostsPostCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DocumentHeaderPostCostsRevenuesActualPostings this$docHeader = this.docHeader;
        DocumentHeaderPostCostsRevenuesActualPostings other$docHeader = other.docHeader;
        if (this$docHeader == null ? other$docHeader != null : !((Object)this$docHeader).equals(other$docHeader)) {
            return false;
        }
        String this$ignoreWarnings = this.ignoreWarnings;
        String other$ignoreWarnings = other.ignoreWarnings;
        if (this$ignoreWarnings == null ? other$ignoreWarnings != null : !this$ignoreWarnings.equals(other$ignoreWarnings)) {
            return false;
        }
        Iterable<LineItemsRepostPrimaryCostsActualPosting> this$docItems = this.docItems;
        Iterable<LineItemsRepostPrimaryCostsActualPosting> other$docItems = other.docItems;
        if (this$docItems == null ? other$docItems != null : !this$docItems.equals(other$docItems)) {
            return false;
        }
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> this$sendCriteria = this.sendCriteria;
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> other$sendCriteria = other.sendCriteria;
        if (this$sendCriteria == null ? other$sendCriteria != null : !this$sendCriteria.equals(other$sendCriteria)) {
            return false;
        }
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> this$recCriteria = this.recCriteria;
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> other$recCriteria = other.recCriteria;
        if (this$recCriteria == null ? other$recCriteria != null : !this$recCriteria.equals(other$recCriteria)) {
            return false;
        }
        Iterable<ContainerForCustomerExitParameter> this$customerFields = this.customerFields;
        Iterable<ContainerForCustomerExitParameter> other$customerFields = other.customerFields;
        return !(this$customerFields == null ? other$customerFields != null : !this$customerFields.equals(other$customerFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcctngRepstPrimCostsPostCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocumentHeaderPostCostsRevenuesActualPostings $docHeader = this.docHeader;
        result = result * 59 + ($docHeader == null ? 43 : ((Object)$docHeader).hashCode());
        String $ignoreWarnings = this.ignoreWarnings;
        result = result * 59 + ($ignoreWarnings == null ? 43 : $ignoreWarnings.hashCode());
        Iterable<LineItemsRepostPrimaryCostsActualPosting> $docItems = this.docItems;
        result = result * 59 + ($docItems == null ? 43 : $docItems.hashCode());
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> $sendCriteria = this.sendCriteria;
        result = result * 59 + ($sendCriteria == null ? 43 : $sendCriteria.hashCode());
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> $recCriteria = this.recCriteria;
        result = result * 59 + ($recCriteria == null ? 43 : $recCriteria.hashCode());
        Iterable<ContainerForCustomerExitParameter> $customerFields = this.customerFields;
        result = result * 59 + ($customerFields == null ? 43 : $customerFields.hashCode());
        return result;
    }

    public String toString() {
        return "AcctngRepstPrimCostsPostCommand(docHeader=" + this.docHeader + ", ignoreWarnings=" + this.ignoreWarnings + ", docItems=" + this.docItems + ", sendCriteria=" + this.sendCriteria + ", recCriteria=" + this.recCriteria + ", customerFields=" + this.customerFields + ")";
    }

    @ConstructorProperties(value={"docHeader", "docItems"})
    public AcctngRepstPrimCostsPostCommand(DocumentHeaderPostCostsRevenuesActualPostings docHeader, @NonNull Iterable<LineItemsRepostPrimaryCostsActualPosting> docItems) {
        if (docItems == null) {
            throw new NullPointerException("docItems");
        }
        this.docHeader = docHeader;
        this.docItems = docItems;
    }

    public static class Result {
        private final BapiQueryResult result;

        public NumberOfAControllingDocument getDocumentNumber() {
            return (NumberOfAControllingDocument)((Object)this.result.get("DOC_NO").getAsObject().as(NumberOfAControllingDocument.class));
        }

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "AcctngRepstPrimCostsPostCommand.Result(result=" + this.result + ")";
        }
    }
}

