/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.AddContractAccountsRecAndPayableDocumentLineItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.AddContractAccountsRecievableAndPayableHeaderLine;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ContainerForCustomerExitParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CurrencyItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CustomerItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.GLAccountItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.Header;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PaymentCardInformation;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingCoPaAcctAssignmentCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingCoPaAcctAssignmentValueField;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingPartnerBillingDoc;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RealEstateAccountAssignmentData;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.RefStructureForParameterExtensioninExtensionout;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.TaxItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.VendorItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.WithholdingTaxInformation;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.InterfaceInformationCallingApplicationKey;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.InterfaceInformationObjectTypeForCallingApplication;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.types.LogicalSystem;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;

public class AcctngDocumentPostCommand {
    private final Header documentHeader;
    private PostingInAccountingPartnerBillingDoc customerCPD = null;
    private AddContractAccountsRecievableAndPayableHeaderLine contractHeader = null;
    @NonNull
    private Iterable<GLAccountItem> accountGl = Lists.newArrayList();
    @NonNull
    private Iterable<CustomerItem> accountReceivable = Lists.newArrayList();
    @NonNull
    private Iterable<VendorItem> accountPayable = Lists.newArrayList();
    @NonNull
    private Iterable<TaxItem> accountTax = Lists.newArrayList();
    @NonNull
    private final Iterable<CurrencyItem> currencyAmount;
    @NonNull
    private Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> criteria = Lists.newArrayList();
    @NonNull
    private Iterable<PostingInAccountingCoPaAcctAssignmentValueField> valuefield = Lists.newArrayList();
    @NonNull
    private Iterable<RealEstateAccountAssignmentData> realEstate = Lists.newArrayList();
    @NonNull
    private Iterable<ContainerForCustomerExitParameter> extension1 = Lists.newArrayList();
    @NonNull
    private Iterable<RefStructureForParameterExtensioninExtensionout> extension2 = Lists.newArrayList();
    @NonNull
    private Iterable<PaymentCardInformation> paymentCard = Lists.newArrayList();
    @NonNull
    private Iterable<AddContractAccountsRecAndPayableDocumentLineItem> contractItem = Lists.newArrayList();
    @NonNull
    private Iterable<WithholdingTaxInformation> withholdingTax = Lists.newArrayList();

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        TableRow row;
        this.documentHeader.validate();
        if (this.customerCPD != null) {
            this.customerCPD.validate();
        }
        if (this.contractHeader != null) {
            this.contractHeader.validate();
        }
        if (this.accountGl != null) {
            for (GLAccountItem gLAccountItem : this.accountGl) {
                gLAccountItem.validate();
            }
        }
        if (this.accountReceivable != null) {
            for (CustomerItem customerItem : this.accountReceivable) {
                customerItem.validate();
            }
        }
        if (this.accountPayable != null) {
            for (VendorItem vendorItem : this.accountPayable) {
                vendorItem.validate();
            }
        }
        if (this.accountTax != null) {
            for (TaxItem taxItem : this.accountTax) {
                taxItem.validate();
            }
        }
        for (CurrencyItem currencyItem : this.currencyAmount) {
            currencyItem.validate();
        }
        if (this.criteria != null) {
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.criteria) {
                postingInAccountingCoPaAcctAssignmentCharacteristic.validate();
            }
        }
        if (this.valuefield != null) {
            for (PostingInAccountingCoPaAcctAssignmentValueField postingInAccountingCoPaAcctAssignmentValueField : this.valuefield) {
                postingInAccountingCoPaAcctAssignmentValueField.validate();
            }
        }
        if (this.realEstate != null) {
            for (RealEstateAccountAssignmentData realEstateAccountAssignmentData : this.realEstate) {
                realEstateAccountAssignmentData.validate();
            }
        }
        if (this.extension1 != null) {
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.extension1) {
                containerForCustomerExitParameter.validate();
            }
        }
        if (this.extension2 != null) {
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extension2) {
                refStructureForParameterExtensioninExtensionout.validate();
            }
        }
        if (this.paymentCard != null) {
            for (PaymentCardInformation paymentCardInformation : this.paymentCard) {
                paymentCardInformation.validate();
            }
        }
        if (this.contractItem != null) {
            for (AddContractAccountsRecAndPayableDocumentLineItem addContractAccountsRecAndPayableDocumentLineItem : this.contractItem) {
                addContractAccountsRecAndPayableDocumentLineItem.validate();
            }
        }
        if (this.withholdingTax != null) {
            for (WithholdingTaxInformation withholdingTaxInformation : this.withholdingTax) {
                withholdingTaxInformation.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_ACC_DOCUMENT_POST");
        ParameterFields parameterFields = query.withExportingFields("DOCUMENTHEADER", "BAPIACHE09");
        if (this.documentHeader.getObjType() != null) {
            parameterFields.field("OBJ_TYPE", "AWTYP", (ErpType)this.documentHeader.getObjType());
        }
        if (this.documentHeader.getObjKey() != null) {
            parameterFields.field("OBJ_KEY", "AWKEY", (ErpType)this.documentHeader.getObjKey());
        }
        if (this.documentHeader.getObjSys() != null) {
            parameterFields.field("OBJ_SYS", "AWSYS", (ErpType)this.documentHeader.getObjSys());
        }
        if (this.documentHeader.getBusAct() != null) {
            parameterFields.field("BUS_ACT", "GLVOR", this.documentHeader.getBusAct());
        }
        if (this.documentHeader.getUsername() != null) {
            parameterFields.field("USERNAME", "USNAM", (ErpType)this.documentHeader.getUsername());
        }
        if (this.documentHeader.getHeaderTxt() != null) {
            parameterFields.field("HEADER_TXT", "BKTXT", this.documentHeader.getHeaderTxt());
        }
        if (this.documentHeader.getCompCode() != null) {
            parameterFields.field("COMP_CODE", "BUKRS", (ErpType)this.documentHeader.getCompCode());
        }
        if (this.documentHeader.getDocDate() != null) {
            parameterFields.field("DOC_DATE", "BLDAT", this.documentHeader.getDocDate());
        }
        if (this.documentHeader.getPstngDate() != null) {
            parameterFields.field("PSTNG_DATE", "BUDAT", this.documentHeader.getPstngDate());
        }
        if (this.documentHeader.getTransDate() != null) {
            parameterFields.field("TRANS_DATE", "WWERT_D", this.documentHeader.getTransDate());
        }
        if (this.documentHeader.getFiscYear() != null) {
            parameterFields.field("FISC_YEAR", "GJAHR", this.documentHeader.getFiscYear());
        }
        if (this.documentHeader.getFisPeriod() != null) {
            parameterFields.field("FIS_PERIOD", "MONAT", (ErpType)this.documentHeader.getFisPeriod());
        }
        if (this.documentHeader.getDocType() != null) {
            parameterFields.field("DOC_TYPE", "BLART", (ErpType)this.documentHeader.getDocType());
        }
        if (this.documentHeader.getRefDocNo() != null) {
            parameterFields.field("REF_DOC_NO", "XBLNR", (ErpType)this.documentHeader.getRefDocNo());
        }
        if (this.documentHeader.getAcDocNo() != null) {
            parameterFields.field("AC_DOC_NO", "BELNR_D", (ErpType)this.documentHeader.getAcDocNo());
        }
        if (this.documentHeader.getObjKeyR() != null) {
            parameterFields.field("OBJ_KEY_R", "AWKEY_REV", (ErpType)this.documentHeader.getObjKeyR());
        }
        if (this.documentHeader.getReasonRev() != null) {
            parameterFields.field("REASON_REV", "ACPI_STGRD", this.documentHeader.getReasonRev());
        }
        if (this.documentHeader.getCompoAcc() != null) {
            parameterFields.field("COMPO_ACC", "COMPO", (ErpType)this.documentHeader.getCompoAcc());
        }
        if (this.documentHeader.getRefDocNoLong() != null) {
            parameterFields.field("REF_DOC_NO_LONG", "XBLNR_LONG", (ErpType)this.documentHeader.getRefDocNoLong());
        }
        if (this.documentHeader.getAccPrinciple() != null) {
            parameterFields.field("ACC_PRINCIPLE", "ACCOUNTING_PRINCIPLE", (ErpType)this.documentHeader.getAccPrinciple());
        }
        if (this.documentHeader.getNegPostng() != null) {
            parameterFields.field("NEG_POSTNG", "XNEGP", (ErpType)this.documentHeader.getNegPostng());
        }
        if (this.documentHeader.getObjKeyInv() != null) {
            parameterFields.field("OBJ_KEY_INV", "AWKEY_REB", (ErpType)this.documentHeader.getObjKeyInv());
        }
        if (this.documentHeader.getBillCategory() != null) {
            parameterFields.field("BILL_CATEGORY", "FKTYP", (ErpType)this.documentHeader.getBillCategory());
        }
        if (this.documentHeader.getVatdate() != null) {
            parameterFields.field("VATDATE", "VATDATE", this.documentHeader.getVatdate());
        }
        if (this.documentHeader.getInvoiceRecDate() != null) {
            parameterFields.field("INVOICE_REC_DATE", "REINDAT", this.documentHeader.getInvoiceRecDate());
        }
        if (this.documentHeader.getEcsEnv() != null) {
            parameterFields.field("ECS_ENV", "ACC_DTE_ECS_IF_TYPE", (ErpType)this.documentHeader.getEcsEnv());
        }
        if (this.documentHeader.getPartialRev() != null) {
            parameterFields.field("PARTIAL_REV", "BAPI_PART_REV", (ErpType)this.documentHeader.getPartialRev());
        }
        if (this.documentHeader.getDocStatus() != null) {
            parameterFields.field("DOC_STATUS", "BAPI_ACC_DOC_STATUS", (ErpType)this.documentHeader.getDocStatus());
        }
        parameterFields.end();
        if (this.customerCPD != null) {
            ParameterFields parameterFields2 = query.withExportingFields("CUSTOMERCPD", "BAPIACPA09");
            if (this.customerCPD.getName() != null) {
                parameterFields2.field("NAME", "NAME1_GP", (ErpType)this.customerCPD.getName());
            }
            if (this.customerCPD.getName2() != null) {
                parameterFields2.field("NAME_2", "NAME2_GP", (ErpType)this.customerCPD.getName2());
            }
            if (this.customerCPD.getName3() != null) {
                parameterFields2.field("NAME_3", "NAME3_GP", (ErpType)this.customerCPD.getName3());
            }
            if (this.customerCPD.getName4() != null) {
                parameterFields2.field("NAME_4", "NAME4_GP", (ErpType)this.customerCPD.getName4());
            }
            if (this.customerCPD.getPostlCode() != null) {
                parameterFields2.field("POSTL_CODE", "PSTLZ", (ErpType)this.customerCPD.getPostlCode());
            }
            if (this.customerCPD.getCity() != null) {
                parameterFields2.field("CITY", "ORT01_GP", this.customerCPD.getCity());
            }
            if (this.customerCPD.getCountry() != null) {
                parameterFields2.field("COUNTRY", "LAND1_GP", (ErpType)this.customerCPD.getCountry());
            }
            if (this.customerCPD.getCountryIso() != null) {
                parameterFields2.field("COUNTRY_ISO", "LAND1_ISO", (ErpType)this.customerCPD.getCountryIso());
            }
            if (this.customerCPD.getStreet() != null) {
                parameterFields2.field("STREET", "STRAS_GP", this.customerCPD.getStreet());
            }
            if (this.customerCPD.getPoBox() != null) {
                parameterFields2.field("PO_BOX", "PFACH", (ErpType)this.customerCPD.getPoBox());
            }
            if (this.customerCPD.getPobxPcd() != null) {
                parameterFields2.field("POBX_PCD", "PSTL2", (ErpType)this.customerCPD.getPobxPcd());
            }
            if (this.customerCPD.getPobkCurac() != null) {
                parameterFields2.field("POBK_CURAC", "PSKTO", (ErpType)this.customerCPD.getPobkCurac());
            }
            if (this.customerCPD.getBankAcct() != null) {
                parameterFields2.field("BANK_ACCT", "BANKN", (ErpType)this.customerCPD.getBankAcct());
            }
            if (this.customerCPD.getBankNo() != null) {
                parameterFields2.field("BANK_NO", "BANKL", (ErpType)this.customerCPD.getBankNo());
            }
            if (this.customerCPD.getBankCtry() != null) {
                parameterFields2.field("BANK_CTRY", "BANKS", (ErpType)this.customerCPD.getBankCtry());
            }
            if (this.customerCPD.getBankCtryIso() != null) {
                parameterFields2.field("BANK_CTRY_ISO", "BANKS_ISO", (ErpType)this.customerCPD.getBankCtryIso());
            }
            if (this.customerCPD.getTaxNo1() != null) {
                parameterFields2.field("TAX_NO_1", "STCD1", (ErpType)this.customerCPD.getTaxNo1());
            }
            if (this.customerCPD.getTaxNo2() != null) {
                parameterFields2.field("TAX_NO_2", "STCD2", (ErpType)this.customerCPD.getTaxNo2());
            }
            if (this.customerCPD.getTax() != null) {
                parameterFields2.field("TAX", "STKZU", (ErpType)this.customerCPD.getTax());
            }
            if (this.customerCPD.getEqualTax() != null) {
                parameterFields2.field("EQUAL_TAX", "ACPI_STKZA", this.customerCPD.getEqualTax());
            }
            if (this.customerCPD.getRegion() != null) {
                parameterFields2.field("REGION", "REGIO", (ErpType)this.customerCPD.getRegion());
            }
            if (this.customerCPD.getCtrlKey() != null) {
                parameterFields2.field("CTRL_KEY", "BKONT", (ErpType)this.customerCPD.getCtrlKey());
            }
            if (this.customerCPD.getInstrKey() != null) {
                parameterFields2.field("INSTR_KEY", "DTAWS", (ErpType)this.customerCPD.getInstrKey());
            }
            if (this.customerCPD.getDmeInd() != null) {
                parameterFields2.field("DME_IND", "DTAMS", (ErpType)this.customerCPD.getDmeInd());
            }
            if (this.customerCPD.getLanguIso() != null) {
                parameterFields2.field("LANGU_ISO", "LAISO", (ErpType)this.customerCPD.getLanguIso());
            }
            if (this.customerCPD.getIban() != null) {
                parameterFields2.field("IBAN", "IBAN", (ErpType)this.customerCPD.getIban());
            }
            if (this.customerCPD.getSwiftCode() != null) {
                parameterFields2.field("SWIFT_CODE", "SWIFT", (ErpType)this.customerCPD.getSwiftCode());
            }
            if (this.customerCPD.getTaxNo3() != null) {
                parameterFields2.field("TAX_NO_3", "STCD3", this.customerCPD.getTaxNo3());
            }
            if (this.customerCPD.getTaxNo4() != null) {
                parameterFields2.field("TAX_NO_4", "STCD4", this.customerCPD.getTaxNo4());
            }
            if (this.customerCPD.getTitle() != null) {
                parameterFields2.field("TITLE", "ANRED", this.customerCPD.getTitle());
            }
            parameterFields2.end();
        }
        if (this.contractHeader != null) {
            ParameterFields parameterFields3 = query.withExportingFields("CONTRACTHEADER", "BAPIACCAHD");
            if (this.contractHeader.getDocNo() != null) {
                parameterFields3.field("DOC_NO", "ACPI_DOC_NO", this.contractHeader.getDocNo());
            }
            if (this.contractHeader.getDocTypeCa() != null) {
                parameterFields3.field("DOC_TYPE_CA", "ACPI_DOC_TYPE_CA", this.contractHeader.getDocTypeCa());
            }
            if (this.contractHeader.getResKey() != null) {
                parameterFields3.field("RES_KEY", "ACPI_RES_KEY", this.contractHeader.getResKey());
            }
            if (this.contractHeader.getFikey() != null) {
                parameterFields3.field("FIKEY", "ACPI_FIKEY", this.contractHeader.getFikey());
            }
            if (this.contractHeader.getPaymentFormRef() != null) {
                parameterFields3.field("PAYMENT_FORM_REF", "ACPI_PMNT_FORM_REF", this.contractHeader.getPaymentFormRef());
            }
            parameterFields3.end();
        }
        if (this.accountGl != null && this.accountGl.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTGL", "BAPIACGL09");
            for (GLAccountItem gLAccountItem : this.accountGl) {
                row = table.row();
                if (gLAccountItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)gLAccountItem.getItemnoAcc());
                }
                if (gLAccountItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)gLAccountItem.getGlAccount());
                }
                if (gLAccountItem.getItemText() != null) {
                    row.field("ITEM_TEXT", "SGTXT", gLAccountItem.getItemText());
                }
                if (gLAccountItem.getStatCon() != null) {
                    row.field("STAT_CON", "ACPI_KSTAZ", gLAccountItem.getStatCon());
                }
                if (gLAccountItem.getLogProc() != null) {
                    row.field("LOG_PROC", "LOGVO", (ErpType)gLAccountItem.getLogProc());
                }
                if (gLAccountItem.getAcDocNo() != null) {
                    row.field("AC_DOC_NO", "BELNR_D", (ErpType)gLAccountItem.getAcDocNo());
                }
                if (gLAccountItem.getRefKey1() != null) {
                    row.field("REF_KEY_1", "XREF1", gLAccountItem.getRefKey1());
                }
                if (gLAccountItem.getRefKey2() != null) {
                    row.field("REF_KEY_2", "XREF2", gLAccountItem.getRefKey2());
                }
                if (gLAccountItem.getRefKey3() != null) {
                    row.field("REF_KEY_3", "XREF3", gLAccountItem.getRefKey3());
                }
                if (gLAccountItem.getAcctKey() != null) {
                    row.field("ACCT_KEY", "KTOSL", gLAccountItem.getAcctKey());
                }
                if (gLAccountItem.getAcctType() != null) {
                    row.field("ACCT_TYPE", "KOART", (ErpType)gLAccountItem.getAcctType());
                }
                if (gLAccountItem.getDocType() != null) {
                    row.field("DOC_TYPE", "BLART", (ErpType)gLAccountItem.getDocType());
                }
                if (gLAccountItem.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)gLAccountItem.getCompCode());
                }
                if (gLAccountItem.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)gLAccountItem.getBusArea());
                }
                if (gLAccountItem.getFuncArea() != null) {
                    row.field("FUNC_AREA", "FKBER_SHORT", (ErpType)gLAccountItem.getFuncArea());
                }
                if (gLAccountItem.getPlant() != null) {
                    row.field("PLANT", "WERKS_D", (ErpType)gLAccountItem.getPlant());
                }
                if (gLAccountItem.getFisPeriod() != null) {
                    row.field("FIS_PERIOD", "MONAT", (ErpType)gLAccountItem.getFisPeriod());
                }
                if (gLAccountItem.getFiscYear() != null) {
                    row.field("FISC_YEAR", "GJAHR", gLAccountItem.getFiscYear());
                }
                if (gLAccountItem.getPstngDate() != null) {
                    row.field("PSTNG_DATE", "BUDAT", gLAccountItem.getPstngDate());
                }
                if (gLAccountItem.getValueDate() != null) {
                    row.field("VALUE_DATE", "VALUT", gLAccountItem.getValueDate());
                }
                if (gLAccountItem.getFmArea() != null) {
                    row.field("FM_AREA", "FIKRS", (ErpType)gLAccountItem.getFmArea());
                }
                if (gLAccountItem.getCustomer() != null) {
                    row.field("CUSTOMER", "KUNNR", (ErpType)gLAccountItem.getCustomer());
                }
                if (gLAccountItem.getCshdisInd() != null) {
                    row.field("CSHDIS_IND", "XSKRL", (ErpType)gLAccountItem.getCshdisInd());
                }
                if (gLAccountItem.getVendorNo() != null) {
                    row.field("VENDOR_NO", "LIFNR", (ErpType)gLAccountItem.getVendorNo());
                }
                if (gLAccountItem.getAllocNmbr() != null) {
                    row.field("ALLOC_NMBR", "ACPI_ZUONR", (ErpType)gLAccountItem.getAllocNmbr());
                }
                if (gLAccountItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)gLAccountItem.getTaxCode());
                }
                if (gLAccountItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)gLAccountItem.getTaxjurcode());
                }
                if (gLAccountItem.getExtObjectId() != null) {
                    row.field("EXT_OBJECT_ID", "ACPI_IAOM_EO_ID", gLAccountItem.getExtObjectId());
                }
                if (gLAccountItem.getBusScenario() != null) {
                    row.field("BUS_SCENARIO", "ACPI_IAOM_BS_ID", gLAccountItem.getBusScenario());
                }
                if (gLAccountItem.getCostobject() != null) {
                    row.field("COSTOBJECT", "KSTRG", (ErpType)gLAccountItem.getCostobject());
                }
                if (gLAccountItem.getCostcenter() != null) {
                    row.field("COSTCENTER", "KOSTL", (ErpType)gLAccountItem.getCostcenter());
                }
                if (gLAccountItem.getActtype() != null) {
                    row.field("ACTTYPE", "LSTAR", (ErpType)gLAccountItem.getActtype());
                }
                if (gLAccountItem.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)gLAccountItem.getProfitCtr());
                }
                if (gLAccountItem.getPartPrctr() != null) {
                    row.field("PART_PRCTR", "PPRCTR", (ErpType)gLAccountItem.getPartPrctr());
                }
                if (gLAccountItem.getNetwork() != null) {
                    row.field("NETWORK", "NPLNR", (ErpType)gLAccountItem.getNetwork());
                }
                if (gLAccountItem.getWbsElement() != null) {
                    row.field("WBS_ELEMENT", "PS_POSID", (ErpType)gLAccountItem.getWbsElement());
                }
                if (gLAccountItem.getOrderid() != null) {
                    row.field("ORDERID", "AUFNR", (ErpType)gLAccountItem.getOrderid());
                }
                if (gLAccountItem.getOrderItno() != null) {
                    row.field("ORDER_ITNO", "CO_POSNR", (ErpType)gLAccountItem.getOrderItno());
                }
                if (gLAccountItem.getRoutingNo() != null) {
                    row.field("ROUTING_NO", "CO_AUFPL", (ErpType)gLAccountItem.getRoutingNo());
                }
                if (gLAccountItem.getActivity() != null) {
                    row.field("ACTIVITY", "VORNR", (ErpType)gLAccountItem.getActivity());
                }
                if (gLAccountItem.getCondType() != null) {
                    row.field("COND_TYPE", "KSCHA", (ErpType)gLAccountItem.getCondType());
                }
                if (gLAccountItem.getCondCount() != null) {
                    row.field("COND_COUNT", "ACPI_DZAEHK", (ErpType)gLAccountItem.getCondCount());
                }
                if (gLAccountItem.getCondStNo() != null) {
                    row.field("COND_ST_NO", "ACPI_STUNR", (ErpType)gLAccountItem.getCondStNo());
                }
                if (gLAccountItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)gLAccountItem.getFund());
                }
                if (gLAccountItem.getFundsCtr() != null) {
                    row.field("FUNDS_CTR", "FISTL", (ErpType)gLAccountItem.getFundsCtr());
                }
                if (gLAccountItem.getCmmtItem() != null) {
                    row.field("CMMT_ITEM", "FIPOS", (ErpType)gLAccountItem.getCmmtItem());
                }
                if (gLAccountItem.getCoBusproc() != null) {
                    row.field("CO_BUSPROC", "CO_PRZNR", (ErpType)gLAccountItem.getCoBusproc());
                }
                if (gLAccountItem.getAssetNo() != null) {
                    row.field("ASSET_NO", "ANLN1", (ErpType)gLAccountItem.getAssetNo());
                }
                if (gLAccountItem.getSubNumber() != null) {
                    row.field("SUB_NUMBER", "ANLN2", (ErpType)gLAccountItem.getSubNumber());
                }
                if (gLAccountItem.getBillType() != null) {
                    row.field("BILL_TYPE", "FKART", (ErpType)gLAccountItem.getBillType());
                }
                if (gLAccountItem.getSalesOrd() != null) {
                    row.field("SALES_ORD", "KDAUF", (ErpType)gLAccountItem.getSalesOrd());
                }
                if (gLAccountItem.getSOrdItem() != null) {
                    row.field("S_ORD_ITEM", "KDPOS", (ErpType)gLAccountItem.getSOrdItem());
                }
                if (gLAccountItem.getDistrChan() != null) {
                    row.field("DISTR_CHAN", "VTWEG", (ErpType)gLAccountItem.getDistrChan());
                }
                if (gLAccountItem.getDivision() != null) {
                    row.field("DIVISION", "SPART", (ErpType)gLAccountItem.getDivision());
                }
                if (gLAccountItem.getSalesorg() != null) {
                    row.field("SALESORG", "VKORG", (ErpType)gLAccountItem.getSalesorg());
                }
                if (gLAccountItem.getSalesGrp() != null) {
                    row.field("SALES_GRP", "VKGRP", (ErpType)gLAccountItem.getSalesGrp());
                }
                if (gLAccountItem.getSalesOff() != null) {
                    row.field("SALES_OFF", "VKBUR", (ErpType)gLAccountItem.getSalesOff());
                }
                if (gLAccountItem.getSoldTo() != null) {
                    row.field("SOLD_TO", "KUNAG", (ErpType)gLAccountItem.getSoldTo());
                }
                if (gLAccountItem.getDeCreInd() != null) {
                    row.field("DE_CRE_IND", "ACPI_TBTKZ", gLAccountItem.getDeCreInd());
                }
                if (gLAccountItem.getPElPrctr() != null) {
                    row.field("P_EL_PRCTR", "ACPI_EPRCTR", (ErpType)gLAccountItem.getPElPrctr());
                }
                if (gLAccountItem.getXmfrw() != null) {
                    row.field("XMFRW", "ACPI_XMFRW", (ErpType)gLAccountItem.getXmfrw());
                }
                if (gLAccountItem.getQuantity() != null) {
                    row.field("QUANTITY", "MENGE_D", (ErpType)gLAccountItem.getQuantity());
                }
                if (gLAccountItem.getBaseUom() != null) {
                    row.field("BASE_UOM", "MEINS", (ErpType)gLAccountItem.getBaseUom());
                }
                if (gLAccountItem.getBaseUomIso() != null) {
                    row.field("BASE_UOM_ISO", "MEINS_ISO", (ErpType)gLAccountItem.getBaseUomIso());
                }
                if (gLAccountItem.getInvQty() != null) {
                    row.field("INV_QTY", "ACPI_FKIMG", (ErpType)gLAccountItem.getInvQty());
                }
                if (gLAccountItem.getInvQtySu() != null) {
                    row.field("INV_QTY_SU", "ACPI_FKLMG", (ErpType)gLAccountItem.getInvQtySu());
                }
                if (gLAccountItem.getSalesUnit() != null) {
                    row.field("SALES_UNIT", "VRKME", (ErpType)gLAccountItem.getSalesUnit());
                }
                if (gLAccountItem.getSalesUnitIso() != null) {
                    row.field("SALES_UNIT_ISO", "ACPI_VRKME_ISO", (ErpType)gLAccountItem.getSalesUnitIso());
                }
                if (gLAccountItem.getPoPrQnt() != null) {
                    row.field("PO_PR_QNT", "ACPI_BPMNG", (ErpType)gLAccountItem.getPoPrQnt());
                }
                if (gLAccountItem.getPoPrUom() != null) {
                    row.field("PO_PR_UOM", "ACPI_BPRME", (ErpType)gLAccountItem.getPoPrUom());
                }
                if (gLAccountItem.getPoPrUomIso() != null) {
                    row.field("PO_PR_UOM_ISO", "BPRME_ISO", (ErpType)gLAccountItem.getPoPrUomIso());
                }
                if (gLAccountItem.getEntryQnt() != null) {
                    row.field("ENTRY_QNT", "ERFMG", (ErpType)gLAccountItem.getEntryQnt());
                }
                if (gLAccountItem.getEntryUom() != null) {
                    row.field("ENTRY_UOM", "ERFME", (ErpType)gLAccountItem.getEntryUom());
                }
                if (gLAccountItem.getEntryUomIso() != null) {
                    row.field("ENTRY_UOM_ISO", "ERFME_ISO", (ErpType)gLAccountItem.getEntryUomIso());
                }
                if (gLAccountItem.getVolume() != null) {
                    row.field("VOLUME", "ACPI_VOLUM_15", (ErpType)gLAccountItem.getVolume());
                }
                if (gLAccountItem.getVolumeunit() != null) {
                    row.field("VOLUMEUNIT", "ACPI_VOLEH", (ErpType)gLAccountItem.getVolumeunit());
                }
                if (gLAccountItem.getVolumeunitIso() != null) {
                    row.field("VOLUMEUNIT_ISO", "ACPI_VOLEH_ISO", (ErpType)gLAccountItem.getVolumeunitIso());
                }
                if (gLAccountItem.getGrossWt() != null) {
                    row.field("GROSS_WT", "ACPI_BRGEW_15", (ErpType)gLAccountItem.getGrossWt());
                }
                if (gLAccountItem.getNetWeight() != null) {
                    row.field("NET_WEIGHT", "ACPI_NTGEW_15", (ErpType)gLAccountItem.getNetWeight());
                }
                if (gLAccountItem.getUnitOfWt() != null) {
                    row.field("UNIT_OF_WT", "ACPI_GEWEI", (ErpType)gLAccountItem.getUnitOfWt());
                }
                if (gLAccountItem.getUnitOfWtIso() != null) {
                    row.field("UNIT_OF_WT_ISO", "ACPI_GEWEI_ISO", (ErpType)gLAccountItem.getUnitOfWtIso());
                }
                if (gLAccountItem.getItemCat() != null) {
                    row.field("ITEM_CAT", "ACPI_PSTYP", gLAccountItem.getItemCat());
                }
                if (gLAccountItem.getMaterial() != null) {
                    row.field("MATERIAL", "MATNR18", (ErpType)gLAccountItem.getMaterial());
                }
                if (gLAccountItem.getMatlType() != null) {
                    row.field("MATL_TYPE", "ACPI_MTART", gLAccountItem.getMatlType());
                }
                if (gLAccountItem.getMvtInd() != null) {
                    row.field("MVT_IND", "KZBEW", (ErpType)gLAccountItem.getMvtInd());
                }
                if (gLAccountItem.getRevalInd() != null) {
                    row.field("REVAL_IND", "ACPI_XUMBW", (ErpType)gLAccountItem.getRevalInd());
                }
                if (gLAccountItem.getOrigGroup() != null) {
                    row.field("ORIG_GROUP", "HRKFT", (ErpType)gLAccountItem.getOrigGroup());
                }
                if (gLAccountItem.getOrigMat() != null) {
                    row.field("ORIG_MAT", "HKMAT", (ErpType)gLAccountItem.getOrigMat());
                }
                if (gLAccountItem.getSerialNo() != null) {
                    row.field("SERIAL_NO", "ACPI_DZEKKN", (ErpType)gLAccountItem.getSerialNo());
                }
                if (gLAccountItem.getPartAcct() != null) {
                    row.field("PART_ACCT", "JV_PART", (ErpType)gLAccountItem.getPartAcct());
                }
                if (gLAccountItem.getTrPartBa() != null) {
                    row.field("TR_PART_BA", "PARGB", (ErpType)gLAccountItem.getTrPartBa());
                }
                if (gLAccountItem.getTradeId() != null) {
                    row.field("TRADE_ID", "RASSC", (ErpType)gLAccountItem.getTradeId());
                }
                if (gLAccountItem.getValArea() != null) {
                    row.field("VAL_AREA", "BWKEY", (ErpType)gLAccountItem.getValArea());
                }
                if (gLAccountItem.getValType() != null) {
                    row.field("VAL_TYPE", "BWTAR_D", (ErpType)gLAccountItem.getValType());
                }
                if (gLAccountItem.getAsvalDate() != null) {
                    row.field("ASVAL_DATE", "BF_BZDAT", gLAccountItem.getAsvalDate());
                }
                if (gLAccountItem.getPoNumber() != null) {
                    row.field("PO_NUMBER", "EBELN", (ErpType)gLAccountItem.getPoNumber());
                }
                if (gLAccountItem.getPoItem() != null) {
                    row.field("PO_ITEM", "EBELP", (ErpType)gLAccountItem.getPoItem());
                }
                if (gLAccountItem.getItmNumber() != null) {
                    row.field("ITM_NUMBER", "POSNR", (ErpType)gLAccountItem.getItmNumber());
                }
                if (gLAccountItem.getCondCategory() != null) {
                    row.field("COND_CATEGORY", "ACPI_KNTYP", (ErpType)gLAccountItem.getCondCategory());
                }
                if (gLAccountItem.getFuncAreaLong() != null) {
                    row.field("FUNC_AREA_LONG", "FKBER", (ErpType)gLAccountItem.getFuncAreaLong());
                }
                if (gLAccountItem.getCmmtItemLong() != null) {
                    row.field("CMMT_ITEM_LONG", "FM_FIPEX", (ErpType)gLAccountItem.getCmmtItemLong());
                }
                if (gLAccountItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)gLAccountItem.getGrantNbr());
                }
                if (gLAccountItem.getCsTransT() != null) {
                    row.field("CS_TRANS_T", "RMVCT", (ErpType)gLAccountItem.getCsTransT());
                }
                if (gLAccountItem.getMeasure() != null) {
                    row.field("MEASURE", "FM_MEASURE", (ErpType)gLAccountItem.getMeasure());
                }
                if (gLAccountItem.getSegment() != null) {
                    row.field("SEGMENT", "FB_SEGMENT", (ErpType)gLAccountItem.getSegment());
                }
                if (gLAccountItem.getPartnerSegment() != null) {
                    row.field("PARTNER_SEGMENT", "FB_PSEGMENT", (ErpType)gLAccountItem.getPartnerSegment());
                }
                if (gLAccountItem.getResDoc() != null) {
                    row.field("RES_DOC", "KBLNR", (ErpType)gLAccountItem.getResDoc());
                }
                if (gLAccountItem.getResItem() != null) {
                    row.field("RES_ITEM", "KBLPOS", (ErpType)gLAccountItem.getResItem());
                }
                if (gLAccountItem.getBillingPeriodStartDate() != null) {
                    row.field("BILLING_PERIOD_START_DATE", "FM_PEROP_FI_LOW", gLAccountItem.getBillingPeriodStartDate());
                }
                if (gLAccountItem.getBillingPeriodEndDate() != null) {
                    row.field("BILLING_PERIOD_END_DATE", "FM_PEROP_FI_HIGH", gLAccountItem.getBillingPeriodEndDate());
                }
                if (gLAccountItem.getPpaExInd() != null) {
                    row.field("PPA_EX_IND", "EXCLUDE_FLG", (ErpType)gLAccountItem.getPpaExInd());
                }
                if (gLAccountItem.getFastpay() != null) {
                    row.field("FASTPAY", "FMFG_FASTPAY_FLG", (ErpType)gLAccountItem.getFastpay());
                }
                if (gLAccountItem.getPartnerGrantNbr() != null) {
                    row.field("PARTNER_GRANT_NBR", "GM_PGRANT_NBR", (ErpType)gLAccountItem.getPartnerGrantNbr());
                }
                if (gLAccountItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)gLAccountItem.getBudgetPeriod());
                }
                if (gLAccountItem.getPartnerBudgetPeriod() != null) {
                    row.field("PARTNER_BUDGET_PERIOD", "FM_PBUDGET_PERIOD", (ErpType)gLAccountItem.getPartnerBudgetPeriod());
                }
                if (gLAccountItem.getPartnerFund() != null) {
                    row.field("PARTNER_FUND", "FM_PFUND", (ErpType)gLAccountItem.getPartnerFund());
                }
                if (gLAccountItem.getItemnoTax() != null) {
                    row.field("ITEMNO_TAX", "TAXPS", (ErpType)gLAccountItem.getItemnoTax());
                }
                if (gLAccountItem.getPaymentType() != null) {
                    row.field("PAYMENT_TYPE", "GTR_CRM_PAYMENT_TYPE", (ErpType)gLAccountItem.getPaymentType());
                }
                if (gLAccountItem.getExpenseType() != null) {
                    row.field("EXPENSE_TYPE", "GTR_CRM_EXPENSE_CAT", (ErpType)gLAccountItem.getExpenseType());
                }
                if (gLAccountItem.getProgramProfile() != null) {
                    row.field("PROGRAM_PROFILE", "GTR_CRM_PROG_PROFILE", gLAccountItem.getProgramProfile());
                }
                if (gLAccountItem.getMaterialLong() != null) {
                    row.field("MATERIAL_LONG", "MATNR40", (ErpType)gLAccountItem.getMaterialLong());
                }
                if (gLAccountItem.getHousebankid() != null) {
                    row.field("HOUSEBANKID", "HBKID", (ErpType)gLAccountItem.getHousebankid());
                }
                if (gLAccountItem.getHousebankacctid() != null) {
                    row.field("HOUSEBANKACCTID", "HKTID", (ErpType)gLAccountItem.getHousebankacctid());
                }
                if (gLAccountItem.getPersonNo() == null) continue;
                row.field("PERSON_NO", "PERNR_D", (ErpType)gLAccountItem.getPersonNo());
            }
            table.end();
        }
        if (this.accountReceivable != null && this.accountReceivable.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTRECEIVABLE", "BAPIACAR09");
            for (CustomerItem customerItem : this.accountReceivable) {
                row = table.row();
                if (customerItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)customerItem.getItemnoAcc());
                }
                if (customerItem.getCustomer() != null) {
                    row.field("CUSTOMER", "KUNNR", (ErpType)customerItem.getCustomer());
                }
                if (customerItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)customerItem.getGlAccount());
                }
                if (customerItem.getRefKey1() != null) {
                    row.field("REF_KEY_1", "XREF1", customerItem.getRefKey1());
                }
                if (customerItem.getRefKey2() != null) {
                    row.field("REF_KEY_2", "XREF2", customerItem.getRefKey2());
                }
                if (customerItem.getRefKey3() != null) {
                    row.field("REF_KEY_3", "XREF3", customerItem.getRefKey3());
                }
                if (customerItem.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)customerItem.getCompCode());
                }
                if (customerItem.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)customerItem.getBusArea());
                }
                if (customerItem.getPmnttrms() != null) {
                    row.field("PMNTTRMS", "ACPI_ZTERM", customerItem.getPmnttrms());
                }
                if (customerItem.getBlineDate() != null) {
                    row.field("BLINE_DATE", "ACPI_ZFBDT", customerItem.getBlineDate());
                }
                if (customerItem.getDsctDays1() != null) {
                    row.field("DSCT_DAYS1", "ACPI_ZBD1T", (ErpType)customerItem.getDsctDays1());
                }
                if (customerItem.getDsctDays2() != null) {
                    row.field("DSCT_DAYS2", "ACPI_ZBD2T", (ErpType)customerItem.getDsctDays2());
                }
                if (customerItem.getNetterms() != null) {
                    row.field("NETTERMS", "ACPI_ZBD3T", (ErpType)customerItem.getNetterms());
                }
                if (customerItem.getDsctPct1() != null) {
                    row.field("DSCT_PCT1", "ACPI_ZBD1P", (ErpType)customerItem.getDsctPct1());
                }
                if (customerItem.getDsctPct2() != null) {
                    row.field("DSCT_PCT2", "ACPI_ZBD2P", (ErpType)customerItem.getDsctPct2());
                }
                if (customerItem.getPymtMeth() != null) {
                    row.field("PYMT_METH", "ACPI_ZLSCH", (ErpType)customerItem.getPymtMeth());
                }
                if (customerItem.getPmtmthsupl() != null) {
                    row.field("PMTMTHSUPL", "UZAWE", (ErpType)customerItem.getPmtmthsupl());
                }
                if (customerItem.getPaymtRef() != null) {
                    row.field("PAYMT_REF", "ACPI_KIDNO", customerItem.getPaymtRef());
                }
                if (customerItem.getDunnKey() != null) {
                    row.field("DUNN_KEY", "ACPI_MSCHL", customerItem.getDunnKey());
                }
                if (customerItem.getDunnBlock() != null) {
                    row.field("DUNN_BLOCK", "ACPI_MANSP", customerItem.getDunnBlock());
                }
                if (customerItem.getPmntBlock() != null) {
                    row.field("PMNT_BLOCK", "ACPI_ZLSPR", customerItem.getPmntBlock());
                }
                if (customerItem.getVatRegNo() != null) {
                    row.field("VAT_REG_NO", "STCEG", (ErpType)customerItem.getVatRegNo());
                }
                if (customerItem.getAllocNmbr() != null) {
                    row.field("ALLOC_NMBR", "ACPI_ZUONR", (ErpType)customerItem.getAllocNmbr());
                }
                if (customerItem.getItemText() != null) {
                    row.field("ITEM_TEXT", "SGTXT", customerItem.getItemText());
                }
                if (customerItem.getPartnerBk() != null) {
                    row.field("PARTNER_BK", "BVTYP", (ErpType)customerItem.getPartnerBk());
                }
                if (customerItem.getScbankInd() != null) {
                    row.field("SCBANK_IND", "LZBKZ", (ErpType)customerItem.getScbankInd());
                }
                if (customerItem.getBusinessplace() != null) {
                    row.field("BUSINESSPLACE", "ACPI_BRANCH", customerItem.getBusinessplace());
                }
                if (customerItem.getSectioncode() != null) {
                    row.field("SECTIONCODE", "ACPI_SECCO1", customerItem.getSectioncode());
                }
                if (customerItem.getBranch() != null) {
                    row.field("BRANCH", "ACPI_FILKD", (ErpType)customerItem.getBranch());
                }
                if (customerItem.getPymtCur() != null) {
                    row.field("PYMT_CUR", "ACPI_PYCUR", (ErpType)customerItem.getPymtCur());
                }
                if (customerItem.getPymtCurIso() != null) {
                    row.field("PYMT_CUR_ISO", "WAERS_ISO", (ErpType)customerItem.getPymtCurIso());
                }
                if (customerItem.getPymtAmt() != null) {
                    row.field("PYMT_AMT", "ACPI_PYAMT", (ErpType)customerItem.getPymtAmt());
                }
                if (customerItem.getCCtrArea() != null) {
                    row.field("C_CTR_AREA", "ACPI_KKBER", customerItem.getCCtrArea());
                }
                if (customerItem.getBankId() != null) {
                    row.field("BANK_ID", "HBKID", (ErpType)customerItem.getBankId());
                }
                if (customerItem.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "LANDL", (ErpType)customerItem.getSupcountry());
                }
                if (customerItem.getSupcountryIso() != null) {
                    row.field("SUPCOUNTRY_ISO", "LANDL_ISO", (ErpType)customerItem.getSupcountryIso());
                }
                if (customerItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)customerItem.getTaxCode());
                }
                if (customerItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)customerItem.getTaxjurcode());
                }
                if (customerItem.getTaxDate() != null) {
                    row.field("TAX_DATE", "ACPI_TXDAT", customerItem.getTaxDate());
                }
                if (customerItem.getSpGlInd() != null) {
                    row.field("SP_GL_IND", "ACPI_UMSKZ", customerItem.getSpGlInd());
                }
                if (customerItem.getPartnerGuid() != null) {
                    row.field("PARTNER_GUID", "ACPI_GC_PARTNEG", customerItem.getPartnerGuid());
                }
                if (customerItem.getAltPayee() != null) {
                    row.field("ALT_PAYEE", "VVABWZE", (ErpType)customerItem.getAltPayee());
                }
                if (customerItem.getAltPayeeBank() != null) {
                    row.field("ALT_PAYEE_BANK", "VVBVTYPABW", (ErpType)customerItem.getAltPayeeBank());
                }
                if (customerItem.getDunnArea() != null) {
                    row.field("DUNN_AREA", "ACPI_MABER", (ErpType)customerItem.getDunnArea());
                }
                if (customerItem.getCaseGuid() != null) {
                    row.field("CASE_GUID", "SCMG_CASE_GUID", (ErpType)customerItem.getCaseGuid());
                }
                if (customerItem.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)customerItem.getProfitCtr());
                }
                if (customerItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)customerItem.getFund());
                }
                if (customerItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)customerItem.getGrantNbr());
                }
                if (customerItem.getMeasure() != null) {
                    row.field("MEASURE", "FM_MEASURE", (ErpType)customerItem.getMeasure());
                }
                if (customerItem.getHousebankacctid() != null) {
                    row.field("HOUSEBANKACCTID", "HKTID", (ErpType)customerItem.getHousebankacctid());
                }
                if (customerItem.getResDoc() != null) {
                    row.field("RES_DOC", "KBLNR", (ErpType)customerItem.getResDoc());
                }
                if (customerItem.getResItem() != null) {
                    row.field("RES_ITEM", "KBLPOS", (ErpType)customerItem.getResItem());
                }
                if (customerItem.getFundLong() != null) {
                    row.field("FUND_LONG", "FM_FUND_LONG", (ErpType)customerItem.getFundLong());
                }
                if (customerItem.getDisputeIfType() != null) {
                    row.field("DISPUTE_IF_TYPE", "DISPUTE_IF_TYPE", (ErpType)customerItem.getDisputeIfType());
                }
                if (customerItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)customerItem.getBudgetPeriod());
                }
                if (customerItem.getPaysProv() != null) {
                    row.field("PAYS_PROV", "COM_WEC_PAYMENT_SRV_PROVIDER", (ErpType)customerItem.getPaysProv());
                }
                if (customerItem.getPaysTran() != null) {
                    row.field("PAYS_TRAN", "FPS_TRANSACTION", (ErpType)customerItem.getPaysTran());
                }
                if (customerItem.getSepaMandateId() != null) {
                    row.field("SEPA_MANDATE_ID", "SEPA_MNDID", (ErpType)customerItem.getSepaMandateId());
                }
                if (customerItem.getPartBusinessplace() != null) {
                    row.field("PART_BUSINESSPLACE", "BCODE", (ErpType)customerItem.getPartBusinessplace());
                }
                if (customerItem.getRepCountryEu() == null) continue;
                row.field("REP_COUNTRY_EU", "EGMLD_BSEZ", (ErpType)customerItem.getRepCountryEu());
            }
            table.end();
        }
        if (this.accountPayable != null && this.accountPayable.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTPAYABLE", "BAPIACAP09");
            for (VendorItem vendorItem : this.accountPayable) {
                row = table.row();
                if (vendorItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)vendorItem.getItemnoAcc());
                }
                if (vendorItem.getVendorNo() != null) {
                    row.field("VENDOR_NO", "LIFNR", (ErpType)vendorItem.getVendorNo());
                }
                if (vendorItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)vendorItem.getGlAccount());
                }
                if (vendorItem.getRefKey1() != null) {
                    row.field("REF_KEY_1", "XREF1", vendorItem.getRefKey1());
                }
                if (vendorItem.getRefKey2() != null) {
                    row.field("REF_KEY_2", "XREF2", vendorItem.getRefKey2());
                }
                if (vendorItem.getRefKey3() != null) {
                    row.field("REF_KEY_3", "XREF3", vendorItem.getRefKey3());
                }
                if (vendorItem.getCompCode() != null) {
                    row.field("COMP_CODE", "BUKRS", (ErpType)vendorItem.getCompCode());
                }
                if (vendorItem.getBusArea() != null) {
                    row.field("BUS_AREA", "GSBER", (ErpType)vendorItem.getBusArea());
                }
                if (vendorItem.getPmnttrms() != null) {
                    row.field("PMNTTRMS", "ACPI_ZTERM", vendorItem.getPmnttrms());
                }
                if (vendorItem.getBlineDate() != null) {
                    row.field("BLINE_DATE", "ACPI_ZFBDT", vendorItem.getBlineDate());
                }
                if (vendorItem.getDsctDays1() != null) {
                    row.field("DSCT_DAYS1", "ACPI_ZBD1T", (ErpType)vendorItem.getDsctDays1());
                }
                if (vendorItem.getDsctDays2() != null) {
                    row.field("DSCT_DAYS2", "ACPI_ZBD2T", (ErpType)vendorItem.getDsctDays2());
                }
                if (vendorItem.getNetterms() != null) {
                    row.field("NETTERMS", "ACPI_ZBD3T", (ErpType)vendorItem.getNetterms());
                }
                if (vendorItem.getDsctPct1() != null) {
                    row.field("DSCT_PCT1", "ACPI_ZBD1P", (ErpType)vendorItem.getDsctPct1());
                }
                if (vendorItem.getDsctPct2() != null) {
                    row.field("DSCT_PCT2", "ACPI_ZBD2P", (ErpType)vendorItem.getDsctPct2());
                }
                if (vendorItem.getPymtMeth() != null) {
                    row.field("PYMT_METH", "ACPI_ZLSCH", (ErpType)vendorItem.getPymtMeth());
                }
                if (vendorItem.getPmtmthsupl() != null) {
                    row.field("PMTMTHSUPL", "UZAWE", (ErpType)vendorItem.getPmtmthsupl());
                }
                if (vendorItem.getPmntBlock() != null) {
                    row.field("PMNT_BLOCK", "ACPI_ZLSPR", vendorItem.getPmntBlock());
                }
                if (vendorItem.getScbankInd() != null) {
                    row.field("SCBANK_IND", "LZBKZ", (ErpType)vendorItem.getScbankInd());
                }
                if (vendorItem.getSupcountry() != null) {
                    row.field("SUPCOUNTRY", "LANDL", (ErpType)vendorItem.getSupcountry());
                }
                if (vendorItem.getSupcountryIso() != null) {
                    row.field("SUPCOUNTRY_ISO", "LANDL_ISO", (ErpType)vendorItem.getSupcountryIso());
                }
                if (vendorItem.getBllsrvInd() != null) {
                    row.field("BLLSRV_IND", "DIEKZ", (ErpType)vendorItem.getBllsrvInd());
                }
                if (vendorItem.getAllocNmbr() != null) {
                    row.field("ALLOC_NMBR", "ACPI_ZUONR", (ErpType)vendorItem.getAllocNmbr());
                }
                if (vendorItem.getItemText() != null) {
                    row.field("ITEM_TEXT", "SGTXT", vendorItem.getItemText());
                }
                if (vendorItem.getPoSubNo() != null) {
                    row.field("PO_SUB_NO", "ESRNR", (ErpType)vendorItem.getPoSubNo());
                }
                if (vendorItem.getPoCheckdg() != null) {
                    row.field("PO_CHECKDG", "ESRPZ", vendorItem.getPoCheckdg());
                }
                if (vendorItem.getPoRefNo() != null) {
                    row.field("PO_REF_NO", "ESRRE", (ErpType)vendorItem.getPoRefNo());
                }
                if (vendorItem.getWTaxCode() != null) {
                    row.field("W_TAX_CODE", "ACPI_QSSKZ", vendorItem.getWTaxCode());
                }
                if (vendorItem.getBusinessplace() != null) {
                    row.field("BUSINESSPLACE", "ACPI_BRANCH", vendorItem.getBusinessplace());
                }
                if (vendorItem.getSectioncode() != null) {
                    row.field("SECTIONCODE", "ACPI_SECCO1", vendorItem.getSectioncode());
                }
                if (vendorItem.getInstr1() != null) {
                    row.field("INSTR1", "DTAT16", (ErpType)vendorItem.getInstr1());
                }
                if (vendorItem.getInstr2() != null) {
                    row.field("INSTR2", "DTAT17", (ErpType)vendorItem.getInstr2());
                }
                if (vendorItem.getInstr3() != null) {
                    row.field("INSTR3", "DTAT18", (ErpType)vendorItem.getInstr3());
                }
                if (vendorItem.getInstr4() != null) {
                    row.field("INSTR4", "DTAT19", (ErpType)vendorItem.getInstr4());
                }
                if (vendorItem.getBranch() != null) {
                    row.field("BRANCH", "ACPI_FILKD", (ErpType)vendorItem.getBranch());
                }
                if (vendorItem.getPymtCur() != null) {
                    row.field("PYMT_CUR", "ACPI_PYCUR", (ErpType)vendorItem.getPymtCur());
                }
                if (vendorItem.getPymtAmt() != null) {
                    row.field("PYMT_AMT", "ACPI_PYAMT", (ErpType)vendorItem.getPymtAmt());
                }
                if (vendorItem.getPymtCurIso() != null) {
                    row.field("PYMT_CUR_ISO", "WAERS_ISO", (ErpType)vendorItem.getPymtCurIso());
                }
                if (vendorItem.getSpGlInd() != null) {
                    row.field("SP_GL_IND", "ACPI_UMSKZ", vendorItem.getSpGlInd());
                }
                if (vendorItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)vendorItem.getTaxCode());
                }
                if (vendorItem.getTaxDate() != null) {
                    row.field("TAX_DATE", "ACPI_TXDAT", vendorItem.getTaxDate());
                }
                if (vendorItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)vendorItem.getTaxjurcode());
                }
                if (vendorItem.getAltPayee() != null) {
                    row.field("ALT_PAYEE", "VVABWZE", (ErpType)vendorItem.getAltPayee());
                }
                if (vendorItem.getAltPayeeBank() != null) {
                    row.field("ALT_PAYEE_BANK", "VVBVTYPABW", (ErpType)vendorItem.getAltPayeeBank());
                }
                if (vendorItem.getPartnerBk() != null) {
                    row.field("PARTNER_BK", "BVTYP", (ErpType)vendorItem.getPartnerBk());
                }
                if (vendorItem.getBankId() != null) {
                    row.field("BANK_ID", "HBKID", (ErpType)vendorItem.getBankId());
                }
                if (vendorItem.getPartnerGuid() != null) {
                    row.field("PARTNER_GUID", "ACPI_GC_PARTNEG", vendorItem.getPartnerGuid());
                }
                if (vendorItem.getProfitCtr() != null) {
                    row.field("PROFIT_CTR", "PRCTR", (ErpType)vendorItem.getProfitCtr());
                }
                if (vendorItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)vendorItem.getFund());
                }
                if (vendorItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)vendorItem.getGrantNbr());
                }
                if (vendorItem.getMeasure() != null) {
                    row.field("MEASURE", "FM_MEASURE", (ErpType)vendorItem.getMeasure());
                }
                if (vendorItem.getHousebankacctid() != null) {
                    row.field("HOUSEBANKACCTID", "HKTID", (ErpType)vendorItem.getHousebankacctid());
                }
                if (vendorItem.getBudgetPeriod() != null) {
                    row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)vendorItem.getBudgetPeriod());
                }
                if (vendorItem.getPpaExInd() != null) {
                    row.field("PPA_EX_IND", "EXCLUDE_FLG", (ErpType)vendorItem.getPpaExInd());
                }
                if (vendorItem.getPartBusinessplace() != null) {
                    row.field("PART_BUSINESSPLACE", "BCODE", (ErpType)vendorItem.getPartBusinessplace());
                }
                if (vendorItem.getPaymtRef() == null) continue;
                row.field("PAYMT_REF", "ACPI_KIDNO", vendorItem.getPaymtRef());
            }
            table.end();
        }
        if (this.accountTax != null && this.accountTax.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTTAX", "BAPIACTX09");
            for (TaxItem taxItem : this.accountTax) {
                row = table.row();
                if (taxItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)taxItem.getItemnoAcc());
                }
                if (taxItem.getGlAccount() != null) {
                    row.field("GL_ACCOUNT", "HKONT", (ErpType)taxItem.getGlAccount());
                }
                if (taxItem.getCondKey() != null) {
                    row.field("COND_KEY", "KSCHL", (ErpType)taxItem.getCondKey());
                }
                if (taxItem.getAcctKey() != null) {
                    row.field("ACCT_KEY", "KTOSL", taxItem.getAcctKey());
                }
                if (taxItem.getTaxCode() != null) {
                    row.field("TAX_CODE", "MWSKZ", (ErpType)taxItem.getTaxCode());
                }
                if (taxItem.getTaxRate() != null) {
                    row.field("TAX_RATE", "MSATZ_F05L", (ErpType)taxItem.getTaxRate());
                }
                if (taxItem.getTaxDate() != null) {
                    row.field("TAX_DATE", "ACPI_TXDAT", taxItem.getTaxDate());
                }
                if (taxItem.getTaxjurcode() != null) {
                    row.field("TAXJURCODE", "TXJCD", (ErpType)taxItem.getTaxjurcode());
                }
                if (taxItem.getTaxjurcodeDeep() != null) {
                    row.field("TAXJURCODE_DEEP", "ACPI_TXJCD_DEEP", (ErpType)taxItem.getTaxjurcodeDeep());
                }
                if (taxItem.getTaxjurcodeLevel() != null) {
                    row.field("TAXJURCODE_LEVEL", "ACPI_TXJCD_LEVEL", taxItem.getTaxjurcodeLevel());
                }
                if (taxItem.getItemnoTax() != null) {
                    row.field("ITEMNO_TAX", "TAXPS", (ErpType)taxItem.getItemnoTax());
                }
                if (taxItem.getDirectTax() == null) continue;
                row.field("DIRECT_TAX", "BAPI_FLG_DIR", (ErpType)taxItem.getDirectTax());
            }
            table.end();
        }
        if (this.currencyAmount.iterator().hasNext()) {
            Table table = query.withTable("CURRENCYAMOUNT", "BAPIACCR09");
            for (CurrencyItem currencyItem : this.currencyAmount) {
                row = table.row();
                if (currencyItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)currencyItem.getItemnoAcc());
                }
                if (currencyItem.getCurrType() != null) {
                    row.field("CURR_TYPE", "CURTP", (ErpType)currencyItem.getCurrType());
                }
                if (currencyItem.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)currencyItem.getCurrency());
                }
                if (currencyItem.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)currencyItem.getCurrencyIso());
                }
                if (currencyItem.getAmtDoccur() != null) {
                    row.field("AMT_DOCCUR", "BAPIDOCCUR", (ErpType)currencyItem.getAmtDoccur());
                }
                if (currencyItem.getExchRate() != null) {
                    row.field("EXCH_RATE", "KURSF", (ErpType)currencyItem.getExchRate());
                }
                if (currencyItem.getExchRateV() != null) {
                    row.field("EXCH_RATE_V", "ACPI_UKURSM", (ErpType)currencyItem.getExchRateV());
                }
                if (currencyItem.getAmtBase() != null) {
                    row.field("AMT_BASE", "BAPIAMTBASE", (ErpType)currencyItem.getAmtBase());
                }
                if (currencyItem.getDiscBase() != null) {
                    row.field("DISC_BASE", "ACPI_SKFBT", (ErpType)currencyItem.getDiscBase());
                }
                if (currencyItem.getDiscAmt() != null) {
                    row.field("DISC_AMT", "ACPI_ACSKT", (ErpType)currencyItem.getDiscAmt());
                }
                if (currencyItem.getTaxAmt() == null) continue;
                row.field("TAX_AMT", "BAPITAXAMT", (ErpType)currencyItem.getTaxAmt());
            }
            table.end();
        }
        if (this.criteria != null && this.criteria.iterator().hasNext()) {
            Table table = query.withTable("CRITERIA", "BAPIACKEC9");
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.criteria) {
                row = table.row();
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter() == null) continue;
                row.field("CHARACTER", "ACPI_RKE_CRIGEN", postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter());
            }
            table.end();
        }
        if (this.valuefield != null && this.valuefield.iterator().hasNext()) {
            Table table = query.withTable("VALUEFIELD", "BAPIACKEV9");
            for (PostingInAccountingCoPaAcctAssignmentValueField postingInAccountingCoPaAcctAssignmentValueField : this.valuefield) {
                row = table.row();
                if (postingInAccountingCoPaAcctAssignmentValueField.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getItemnoAcc());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getFieldname());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getCurrType() != null) {
                    row.field("CURR_TYPE", "CURTP", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getCurrType());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getCurrency());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getCurrencyIso());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getAmtValcom() != null) {
                    row.field("AMT_VALCOM", "BAPIRKEVAL", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getAmtValcom());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getBaseUom() != null) {
                    row.field("BASE_UOM", "MEINS", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getBaseUom());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getBaseUomIso() != null) {
                    row.field("BASE_UOM_ISO", "MEINS_ISO", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getBaseUomIso());
                }
                if (postingInAccountingCoPaAcctAssignmentValueField.getQuaValcom() == null) continue;
                row.field("QUA_VALCOM", "QUA_VALCOM", (ErpType)postingInAccountingCoPaAcctAssignmentValueField.getQuaValcom());
            }
            table.end();
        }
        if (this.realEstate != null && this.realEstate.iterator().hasNext()) {
            Table table = query.withTable("REALESTATE", "BAPIACRE09");
            for (RealEstateAccountAssignmentData realEstateAccountAssignmentData : this.realEstate) {
                row = table.row();
                if (realEstateAccountAssignmentData.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)realEstateAccountAssignmentData.getItemnoAcc());
                }
                if (realEstateAccountAssignmentData.getBusinessEntity() != null) {
                    row.field("BUSINESS_ENTITY", "SWENR", (ErpType)realEstateAccountAssignmentData.getBusinessEntity());
                }
                if (realEstateAccountAssignmentData.getBuilding() != null) {
                    row.field("BUILDING", "SGENR", (ErpType)realEstateAccountAssignmentData.getBuilding());
                }
                if (realEstateAccountAssignmentData.getProperty() != null) {
                    row.field("PROPERTY", "SGRNR", (ErpType)realEstateAccountAssignmentData.getProperty());
                }
                if (realEstateAccountAssignmentData.getRentalObject() != null) {
                    row.field("RENTAL_OBJECT", "REBDRONRBAPI", (ErpType)realEstateAccountAssignmentData.getRentalObject());
                }
                if (realEstateAccountAssignmentData.getServChargeKey() != null) {
                    row.field("SERV_CHARGE_KEY", "SNKSL", (ErpType)realEstateAccountAssignmentData.getServChargeKey());
                }
                if (realEstateAccountAssignmentData.getSettlementUnit() != null) {
                    row.field("SETTLEMENT_UNIT", "SEMPSL", (ErpType)realEstateAccountAssignmentData.getSettlementUnit());
                }
                if (realEstateAccountAssignmentData.getContractNo() != null) {
                    row.field("CONTRACT_NO", "RANL", (ErpType)realEstateAccountAssignmentData.getContractNo());
                }
                if (realEstateAccountAssignmentData.getFlowType() != null) {
                    row.field("FLOW_TYPE", "SBEWART", (ErpType)realEstateAccountAssignmentData.getFlowType());
                }
                if (realEstateAccountAssignmentData.getCorrItem() != null) {
                    row.field("CORR_ITEM", "SBERI", (ErpType)realEstateAccountAssignmentData.getCorrItem());
                }
                if (realEstateAccountAssignmentData.getRefDate() != null) {
                    row.field("REF_DATE", "DABRBEZ", realEstateAccountAssignmentData.getRefDate());
                }
                if (realEstateAccountAssignmentData.getOptionRate() == null) continue;
                row.field("OPTION_RATE", "POPTSATZ", (ErpType)realEstateAccountAssignmentData.getOptionRate());
            }
            table.end();
        }
        if (this.extension1 != null && this.extension1.iterator().hasNext()) {
            Table table = query.withTable("EXTENSION1", "BAPIACEXTC");
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.extension1) {
                row = table.row();
                if (containerForCustomerExitParameter.getField1() != null) {
                    row.field("FIELD1", "STRNG250", containerForCustomerExitParameter.getField1());
                }
                if (containerForCustomerExitParameter.getField2() != null) {
                    row.field("FIELD2", "STRNG250", containerForCustomerExitParameter.getField2());
                }
                if (containerForCustomerExitParameter.getField3() != null) {
                    row.field("FIELD3", "STRNG250", containerForCustomerExitParameter.getField3());
                }
                if (containerForCustomerExitParameter.getField4() == null) continue;
                row.field("FIELD4", "STRNG250", containerForCustomerExitParameter.getField4());
            }
            table.end();
        }
        if (this.extension2 != null && this.extension2.iterator().hasNext()) {
            Table table = query.withTable("EXTENSION2", "BAPIPAREX");
            for (RefStructureForParameterExtensioninExtensionout refStructureForParameterExtensioninExtensionout : this.extension2) {
                row = table.row();
                if (refStructureForParameterExtensioninExtensionout.getStructure() != null) {
                    row.field("STRUCTURE", "TE_STRUC", (ErpType)refStructureForParameterExtensioninExtensionout.getStructure());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart1() != null) {
                    row.field("VALUEPART1", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart1());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart2() != null) {
                    row.field("VALUEPART2", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart2());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart3() != null) {
                    row.field("VALUEPART3", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart3());
                }
                if (refStructureForParameterExtensioninExtensionout.getValuepart4() == null) continue;
                row.field("VALUEPART4", "VALUEPART", refStructureForParameterExtensioninExtensionout.getValuepart4());
            }
            table.end();
        }
        if (this.paymentCard != null && this.paymentCard.iterator().hasNext()) {
            Table table = query.withTable("PAYMENTCARD", "BAPIACPC09");
            for (PaymentCardInformation paymentCardInformation : this.paymentCard) {
                row = table.row();
                if (paymentCardInformation.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)paymentCardInformation.getItemnoAcc());
                }
                if (paymentCardInformation.getCcGlaccount() != null) {
                    row.field("CC_GLACCOUNT", "ACPI_CCACT", (ErpType)paymentCardInformation.getCcGlaccount());
                }
                if (paymentCardInformation.getCcType() != null) {
                    row.field("CC_TYPE", "CCINS", (ErpType)paymentCardInformation.getCcType());
                }
                if (paymentCardInformation.getCcNumber() != null) {
                    row.field("CC_NUMBER", "CCNUM", (ErpType)paymentCardInformation.getCcNumber());
                }
                if (paymentCardInformation.getCcSeqNo() != null) {
                    row.field("CC_SEQ_NO", "CCFOL", paymentCardInformation.getCcSeqNo());
                }
                if (paymentCardInformation.getCcValidF() != null) {
                    row.field("CC_VALID_F", "DATAB_CC", paymentCardInformation.getCcValidF());
                }
                if (paymentCardInformation.getCcValidT() != null) {
                    row.field("CC_VALID_T", "DATBI_CC", paymentCardInformation.getCcValidT());
                }
                if (paymentCardInformation.getCcName() != null) {
                    row.field("CC_NAME", "CCNAME", paymentCardInformation.getCcName());
                }
                if (paymentCardInformation.getDataorigin() != null) {
                    row.field("DATAORIGIN", "CSOUR", (ErpType)paymentCardInformation.getDataorigin());
                }
                if (paymentCardInformation.getAuthamount() != null) {
                    row.field("AUTHAMOUNT", "ACPI_CAUTW", (ErpType)paymentCardInformation.getAuthamount());
                }
                if (paymentCardInformation.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)paymentCardInformation.getCurrency());
                }
                if (paymentCardInformation.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "WAERS_ISO", (ErpType)paymentCardInformation.getCurrencyIso());
                }
                if (paymentCardInformation.getCcAutthNo() != null) {
                    row.field("CC_AUTTH_NO", "AUNUM", paymentCardInformation.getCcAutthNo());
                }
                if (paymentCardInformation.getAuthRefno() != null) {
                    row.field("AUTH_REFNO", "AUTRA", paymentCardInformation.getAuthRefno());
                }
                if (paymentCardInformation.getAuthDate() != null) {
                    row.field("AUTH_DATE", "AUDAT_CC", paymentCardInformation.getAuthDate());
                }
                if (paymentCardInformation.getAuthTime() != null) {
                    row.field("AUTH_TIME", "AUTIM", paymentCardInformation.getAuthTime());
                }
                if (paymentCardInformation.getMerchidcl() != null) {
                    row.field("MERCHIDCL", "MERCH", (ErpType)paymentCardInformation.getMerchidcl());
                }
                if (paymentCardInformation.getPointOfReceipt() != null) {
                    row.field("POINT_OF_RECEIPT", "LOCID_CC", (ErpType)paymentCardInformation.getPointOfReceipt());
                }
                if (paymentCardInformation.getTerminal() != null) {
                    row.field("TERMINAL", "TRMID", paymentCardInformation.getTerminal());
                }
                if (paymentCardInformation.getCctyp() == null) continue;
                row.field("CCTYP", "ACPI_CCTYP", paymentCardInformation.getCctyp());
            }
            table.end();
        }
        if (this.contractItem != null && this.contractItem.iterator().hasNext()) {
            Table table = query.withTable("CONTRACTITEM", "BAPIACCAIT");
            for (AddContractAccountsRecAndPayableDocumentLineItem addContractAccountsRecAndPayableDocumentLineItem : this.contractItem) {
                row = table.row();
                if (addContractAccountsRecAndPayableDocumentLineItem.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getItemnoAcc());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getContAcct() != null) {
                    row.field("CONT_ACCT", "ACPI_CONT_ACCT", addContractAccountsRecAndPayableDocumentLineItem.getContAcct());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getMainTrans() != null) {
                    row.field("MAIN_TRANS", "ACPI_MAIN_TRANS", addContractAccountsRecAndPayableDocumentLineItem.getMainTrans());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getSubTrans() != null) {
                    row.field("SUB_TRANS", "ACPI_SUB_TRANS", addContractAccountsRecAndPayableDocumentLineItem.getSubTrans());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFuncArea() != null) {
                    row.field("FUNC_AREA", "FKBER_SHORT", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFuncArea());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFmArea() != null) {
                    row.field("FM_AREA", "FIKRS", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFmArea());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getCmmtItem() != null) {
                    row.field("CMMT_ITEM", "FIPOS", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getCmmtItem());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFundsCtr() != null) {
                    row.field("FUNDS_CTR", "FISTL", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFundsCtr());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFund() != null) {
                    row.field("FUND", "BP_GEBER", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFund());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getAgreementGuid() != null) {
                    row.field("AGREEMENT_GUID", "SYSUUID_X", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getAgreementGuid());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getFuncAreaLong() != null) {
                    row.field("FUNC_AREA_LONG", "FKBER", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getFuncAreaLong());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getCmmtItemLong() != null) {
                    row.field("CMMT_ITEM_LONG", "FM_FIPEX", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getCmmtItemLong());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getGrantNbr() != null) {
                    row.field("GRANT_NBR", "GM_GRANT_NBR", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getGrantNbr());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getVtref() != null) {
                    row.field("VTREF", "ACPI_CONT_REF", addContractAccountsRecAndPayableDocumentLineItem.getVtref());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getVtrefGuid() != null) {
                    row.field("VTREF_GUID", "SYSUUID_X", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getVtrefGuid());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getExtObjectId() != null) {
                    row.field("EXT_OBJECT_ID", "ACPI_IAOM_EO_ID", addContractAccountsRecAndPayableDocumentLineItem.getExtObjectId());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getBusScenario() != null) {
                    row.field("BUS_SCENARIO", "ACPI_IAOM_BS_ID", addContractAccountsRecAndPayableDocumentLineItem.getBusScenario());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getReferenceNo() != null) {
                    row.field("REFERENCE_NO", "ACPI_CA_DOC_REF", addContractAccountsRecAndPayableDocumentLineItem.getReferenceNo());
                }
                if (addContractAccountsRecAndPayableDocumentLineItem.getBudgetPeriod() == null) continue;
                row.field("BUDGET_PERIOD", "FM_BUDGET_PERIOD", (ErpType)addContractAccountsRecAndPayableDocumentLineItem.getBudgetPeriod());
            }
            table.end();
        }
        if (this.withholdingTax != null && this.withholdingTax.iterator().hasNext()) {
            Table table = query.withTable("ACCOUNTWT", "BAPIACWT09");
            for (WithholdingTaxInformation withholdingTaxInformation : this.withholdingTax) {
                row = table.row();
                if (withholdingTaxInformation.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)withholdingTaxInformation.getItemnoAcc());
                }
                if (withholdingTaxInformation.getWtType() != null) {
                    row.field("WT_TYPE", "WITHT", (ErpType)withholdingTaxInformation.getWtType());
                }
                if (withholdingTaxInformation.getWtCode() != null) {
                    row.field("WT_CODE", "WT_WITHCD", (ErpType)withholdingTaxInformation.getWtCode());
                }
                if (withholdingTaxInformation.getBasAmtLc() != null) {
                    row.field("BAS_AMT_LC", "BAPIWT_BS", (ErpType)withholdingTaxInformation.getBasAmtLc());
                }
                if (withholdingTaxInformation.getBasAmtTc() != null) {
                    row.field("BAS_AMT_TC", "BAPIWT_BS1", (ErpType)withholdingTaxInformation.getBasAmtTc());
                }
                if (withholdingTaxInformation.getBasAmtL2() != null) {
                    row.field("BAS_AMT_L2", "BAPIWT_BS2", (ErpType)withholdingTaxInformation.getBasAmtL2());
                }
                if (withholdingTaxInformation.getBasAmtL3() != null) {
                    row.field("BAS_AMT_L3", "BAPIWT_BS3", (ErpType)withholdingTaxInformation.getBasAmtL3());
                }
                if (withholdingTaxInformation.getManAmtLc() != null) {
                    row.field("MAN_AMT_LC", "BAPIWT_QBUIHH", (ErpType)withholdingTaxInformation.getManAmtLc());
                }
                if (withholdingTaxInformation.getManAmtTc() != null) {
                    row.field("MAN_AMT_TC", "BAPIWT_QBUIHB", (ErpType)withholdingTaxInformation.getManAmtTc());
                }
                if (withholdingTaxInformation.getManAmtL2() != null) {
                    row.field("MAN_AMT_L2", "BAPIWT_QBUIH2", (ErpType)withholdingTaxInformation.getManAmtL2());
                }
                if (withholdingTaxInformation.getManAmtL3() != null) {
                    row.field("MAN_AMT_L3", "BAPIWT_QBUIH3", (ErpType)withholdingTaxInformation.getManAmtL3());
                }
                if (withholdingTaxInformation.getAwhAmtLc() != null) {
                    row.field("AWH_AMT_LC", "BAPIWT_AWT", (ErpType)withholdingTaxInformation.getAwhAmtLc());
                }
                if (withholdingTaxInformation.getAwhAmtTc() != null) {
                    row.field("AWH_AMT_TC", "BAPIWT_AWT1", (ErpType)withholdingTaxInformation.getAwhAmtTc());
                }
                if (withholdingTaxInformation.getAwhAmtL2() != null) {
                    row.field("AWH_AMT_L2", "BAPIWT_AWT2", (ErpType)withholdingTaxInformation.getAwhAmtL2());
                }
                if (withholdingTaxInformation.getAwhAmtL3() != null) {
                    row.field("AWH_AMT_L3", "BAPIWT_AWT3", (ErpType)withholdingTaxInformation.getAwhAmtL3());
                }
                if (withholdingTaxInformation.getBasAmtInd() != null) {
                    row.field("BAS_AMT_IND", "WT_BASMAN", (ErpType)withholdingTaxInformation.getBasAmtInd());
                }
                if (withholdingTaxInformation.getManAmtInd() == null) continue;
                row.field("MAN_AMT_IND", "WT_AMNMAN", (ErpType)withholdingTaxInformation.getManAmtInd());
            }
            table.end();
        }
        query.withImportingAsReturn("OBJ_TYPE", "BAPIACHE09");
        query.withImportingAsReturn("OBJ_KEY", "BAPIACHE09");
        query.withImportingAsReturn("OBJ_SYS", "BAPIACHE09");
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult bapiQueryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(bapiQueryResult);
    }

    public AcctngDocumentPostCommand accountGl(GLAccountItem ... items) {
        this.accountGl = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand accountReceivable(CustomerItem ... items) {
        this.accountReceivable = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand accountPayable(VendorItem ... items) {
        this.accountPayable = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand accountTax(TaxItem ... items) {
        this.accountTax = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand criteria(PostingInAccountingCoPaAcctAssignmentCharacteristic ... items) {
        this.criteria = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand valuefield(PostingInAccountingCoPaAcctAssignmentValueField ... items) {
        this.valuefield = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand realEstate(RealEstateAccountAssignmentData ... items) {
        this.realEstate = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand extension1(ContainerForCustomerExitParameter ... items) {
        this.extension1 = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand extension2(RefStructureForParameterExtensioninExtensionout ... items) {
        this.extension2 = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand paymentCard(PaymentCardInformation ... items) {
        this.paymentCard = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand contractItem(AddContractAccountsRecAndPayableDocumentLineItem ... items) {
        this.contractItem = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand withholdingTax(WithholdingTaxInformation ... items) {
        this.withholdingTax = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngDocumentPostCommand customerCPD(PostingInAccountingPartnerBillingDoc customerCPD) {
        this.customerCPD = customerCPD;
        return this;
    }

    public AcctngDocumentPostCommand contractHeader(AddContractAccountsRecievableAndPayableHeaderLine contractHeader) {
        this.contractHeader = contractHeader;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcctngDocumentPostCommand)) {
            return false;
        }
        AcctngDocumentPostCommand other = (AcctngDocumentPostCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Header this$documentHeader = this.documentHeader;
        Header other$documentHeader = other.documentHeader;
        if (this$documentHeader == null ? other$documentHeader != null : !((Object)this$documentHeader).equals(other$documentHeader)) {
            return false;
        }
        PostingInAccountingPartnerBillingDoc this$customerCPD = this.customerCPD;
        PostingInAccountingPartnerBillingDoc other$customerCPD = other.customerCPD;
        if (this$customerCPD == null ? other$customerCPD != null : !((Object)this$customerCPD).equals(other$customerCPD)) {
            return false;
        }
        AddContractAccountsRecievableAndPayableHeaderLine this$contractHeader = this.contractHeader;
        AddContractAccountsRecievableAndPayableHeaderLine other$contractHeader = other.contractHeader;
        if (this$contractHeader == null ? other$contractHeader != null : !((Object)this$contractHeader).equals(other$contractHeader)) {
            return false;
        }
        Iterable<GLAccountItem> this$accountGl = this.accountGl;
        Iterable<GLAccountItem> other$accountGl = other.accountGl;
        if (this$accountGl == null ? other$accountGl != null : !this$accountGl.equals(other$accountGl)) {
            return false;
        }
        Iterable<CustomerItem> this$accountReceivable = this.accountReceivable;
        Iterable<CustomerItem> other$accountReceivable = other.accountReceivable;
        if (this$accountReceivable == null ? other$accountReceivable != null : !this$accountReceivable.equals(other$accountReceivable)) {
            return false;
        }
        Iterable<VendorItem> this$accountPayable = this.accountPayable;
        Iterable<VendorItem> other$accountPayable = other.accountPayable;
        if (this$accountPayable == null ? other$accountPayable != null : !this$accountPayable.equals(other$accountPayable)) {
            return false;
        }
        Iterable<TaxItem> this$accountTax = this.accountTax;
        Iterable<TaxItem> other$accountTax = other.accountTax;
        if (this$accountTax == null ? other$accountTax != null : !this$accountTax.equals(other$accountTax)) {
            return false;
        }
        Iterable<CurrencyItem> this$currencyAmount = this.currencyAmount;
        Iterable<CurrencyItem> other$currencyAmount = other.currencyAmount;
        if (this$currencyAmount == null ? other$currencyAmount != null : !this$currencyAmount.equals(other$currencyAmount)) {
            return false;
        }
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> this$criteria = this.criteria;
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> other$criteria = other.criteria;
        if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
            return false;
        }
        Iterable<PostingInAccountingCoPaAcctAssignmentValueField> this$valuefield = this.valuefield;
        Iterable<PostingInAccountingCoPaAcctAssignmentValueField> other$valuefield = other.valuefield;
        if (this$valuefield == null ? other$valuefield != null : !this$valuefield.equals(other$valuefield)) {
            return false;
        }
        Iterable<RealEstateAccountAssignmentData> this$realEstate = this.realEstate;
        Iterable<RealEstateAccountAssignmentData> other$realEstate = other.realEstate;
        if (this$realEstate == null ? other$realEstate != null : !this$realEstate.equals(other$realEstate)) {
            return false;
        }
        Iterable<ContainerForCustomerExitParameter> this$extension1 = this.extension1;
        Iterable<ContainerForCustomerExitParameter> other$extension1 = other.extension1;
        if (this$extension1 == null ? other$extension1 != null : !this$extension1.equals(other$extension1)) {
            return false;
        }
        Iterable<RefStructureForParameterExtensioninExtensionout> this$extension2 = this.extension2;
        Iterable<RefStructureForParameterExtensioninExtensionout> other$extension2 = other.extension2;
        if (this$extension2 == null ? other$extension2 != null : !this$extension2.equals(other$extension2)) {
            return false;
        }
        Iterable<PaymentCardInformation> this$paymentCard = this.paymentCard;
        Iterable<PaymentCardInformation> other$paymentCard = other.paymentCard;
        if (this$paymentCard == null ? other$paymentCard != null : !this$paymentCard.equals(other$paymentCard)) {
            return false;
        }
        Iterable<AddContractAccountsRecAndPayableDocumentLineItem> this$contractItem = this.contractItem;
        Iterable<AddContractAccountsRecAndPayableDocumentLineItem> other$contractItem = other.contractItem;
        if (this$contractItem == null ? other$contractItem != null : !this$contractItem.equals(other$contractItem)) {
            return false;
        }
        Iterable<WithholdingTaxInformation> this$withholdingTax = this.withholdingTax;
        Iterable<WithholdingTaxInformation> other$withholdingTax = other.withholdingTax;
        return !(this$withholdingTax == null ? other$withholdingTax != null : !this$withholdingTax.equals(other$withholdingTax));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcctngDocumentPostCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Header $documentHeader = this.documentHeader;
        result = result * 59 + ($documentHeader == null ? 43 : ((Object)$documentHeader).hashCode());
        PostingInAccountingPartnerBillingDoc $customerCPD = this.customerCPD;
        result = result * 59 + ($customerCPD == null ? 43 : ((Object)$customerCPD).hashCode());
        AddContractAccountsRecievableAndPayableHeaderLine $contractHeader = this.contractHeader;
        result = result * 59 + ($contractHeader == null ? 43 : ((Object)$contractHeader).hashCode());
        Iterable<GLAccountItem> $accountGl = this.accountGl;
        result = result * 59 + ($accountGl == null ? 43 : $accountGl.hashCode());
        Iterable<CustomerItem> $accountReceivable = this.accountReceivable;
        result = result * 59 + ($accountReceivable == null ? 43 : $accountReceivable.hashCode());
        Iterable<VendorItem> $accountPayable = this.accountPayable;
        result = result * 59 + ($accountPayable == null ? 43 : $accountPayable.hashCode());
        Iterable<TaxItem> $accountTax = this.accountTax;
        result = result * 59 + ($accountTax == null ? 43 : $accountTax.hashCode());
        Iterable<CurrencyItem> $currencyAmount = this.currencyAmount;
        result = result * 59 + ($currencyAmount == null ? 43 : $currencyAmount.hashCode());
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> $criteria = this.criteria;
        result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
        Iterable<PostingInAccountingCoPaAcctAssignmentValueField> $valuefield = this.valuefield;
        result = result * 59 + ($valuefield == null ? 43 : $valuefield.hashCode());
        Iterable<RealEstateAccountAssignmentData> $realEstate = this.realEstate;
        result = result * 59 + ($realEstate == null ? 43 : $realEstate.hashCode());
        Iterable<ContainerForCustomerExitParameter> $extension1 = this.extension1;
        result = result * 59 + ($extension1 == null ? 43 : $extension1.hashCode());
        Iterable<RefStructureForParameterExtensioninExtensionout> $extension2 = this.extension2;
        result = result * 59 + ($extension2 == null ? 43 : $extension2.hashCode());
        Iterable<PaymentCardInformation> $paymentCard = this.paymentCard;
        result = result * 59 + ($paymentCard == null ? 43 : $paymentCard.hashCode());
        Iterable<AddContractAccountsRecAndPayableDocumentLineItem> $contractItem = this.contractItem;
        result = result * 59 + ($contractItem == null ? 43 : $contractItem.hashCode());
        Iterable<WithholdingTaxInformation> $withholdingTax = this.withholdingTax;
        result = result * 59 + ($withholdingTax == null ? 43 : $withholdingTax.hashCode());
        return result;
    }

    public String toString() {
        return "AcctngDocumentPostCommand(documentHeader=" + this.documentHeader + ", customerCPD=" + this.customerCPD + ", contractHeader=" + this.contractHeader + ", accountGl=" + this.accountGl + ", accountReceivable=" + this.accountReceivable + ", accountPayable=" + this.accountPayable + ", accountTax=" + this.accountTax + ", currencyAmount=" + this.currencyAmount + ", criteria=" + this.criteria + ", valuefield=" + this.valuefield + ", realEstate=" + this.realEstate + ", extension1=" + this.extension1 + ", extension2=" + this.extension2 + ", paymentCard=" + this.paymentCard + ", contractItem=" + this.contractItem + ", withholdingTax=" + this.withholdingTax + ")";
    }

    @ConstructorProperties(value={"documentHeader", "currencyAmount"})
    public AcctngDocumentPostCommand(Header documentHeader, @NonNull Iterable<CurrencyItem> currencyAmount) {
        if (currencyAmount == null) {
            throw new NullPointerException("currencyAmount");
        }
        this.documentHeader = documentHeader;
        this.currencyAmount = currencyAmount;
    }

    public static class Result {
        private final BapiQueryResult result;

        public InterfaceInformationObjectTypeForCallingApplication getReferenceProcedure() {
            return (InterfaceInformationObjectTypeForCallingApplication)((Object)this.result.get("OBJ_TYPE").getAsObject().as(InterfaceInformationObjectTypeForCallingApplication.class));
        }

        public InterfaceInformationCallingApplicationKey getReferenceKey() {
            return (InterfaceInformationCallingApplicationKey)((Object)this.result.get("OBJ_KEY").getAsObject().as(InterfaceInformationCallingApplicationKey.class));
        }

        public LogicalSystem getLogicalSystemOfSourceDocument() {
            return (LogicalSystem)((Object)this.result.get("OBJ_SYS").getAsObject().as(LogicalSystem.class));
        }

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "AcctngDocumentPostCommand.Result(result=" + this.result + ")";
        }
    }
}

