/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQuery;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.BapiQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.ParameterFields;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.Table;
import com.sap.cloud.sdk.s4hana.connectivity.rfc.TableRow;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ContainerForCustomerExitParameter;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.DocumentHeaderPostActAllocActualPostings;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.LineItemsActivityAllocationActualPosting;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.PostingInAccountingCoPaAcctAssignmentCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.ReturnParameter;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.NonNull;

public class AcctngActivityAllocCheckCommand {
    private final DocumentHeaderPostActAllocActualPostings docHeader;
    private String ignoreWarnings = null;
    @NonNull
    private final Iterable<LineItemsActivityAllocationActualPosting> docItems;
    @NonNull
    private Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> criteria = Lists.newArrayList();
    @NonNull
    private Iterable<ContainerForCustomerExitParameter> customerFields = Lists.newArrayList();

    public Result execute(ErpConfigContext erpConfigContext) throws QueryExecutionException {
        TableRow row;
        this.docHeader.validate();
        if (this.ignoreWarnings != null && this.ignoreWarnings.length() > 1) {
            throw new IllegalArgumentException("Bapi method parameter \"ignoreWarnings\" contains an invalid structure. Structure attribute \"IGNWARN\" / Function parameter \"ignoreWarnings\" must have at most 1 characters. The given value is too long.");
        }
        for (LineItemsActivityAllocationActualPosting lineItemsActivityAllocationActualPosting : this.docItems) {
            lineItemsActivityAllocationActualPosting.validate();
        }
        if (this.criteria != null) {
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.criteria) {
                postingInAccountingCoPaAcctAssignmentCharacteristic.validate();
            }
        }
        if (this.customerFields != null) {
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.customerFields) {
                containerForCustomerExitParameter.validate();
            }
        }
        BapiQuery query = new BapiQuery("BAPI_ACC_ACTIVITY_ALLOC_CHECK");
        if (this.ignoreWarnings != null) {
            query.withExporting("IGNORE_WARNINGS", "BAPIIGNWAR", this.ignoreWarnings);
        }
        ParameterFields parameterFields = query.withExportingFields("DOC_HEADER", "BAPIDOCHDRP");
        if (this.docHeader.getCoArea() != null) {
            parameterFields.field("CO_AREA", "KOKRS", (ErpType)this.docHeader.getCoArea());
        }
        if (this.docHeader.getDocdate() != null) {
            parameterFields.field("DOCDATE", "CO_BLDAT", this.docHeader.getDocdate());
        }
        if (this.docHeader.getPostgdate() != null) {
            parameterFields.field("POSTGDATE", "CO_BUDAT", this.docHeader.getPostgdate());
        }
        if (this.docHeader.getVersion() != null) {
            parameterFields.field("VERSION", "VERSN", (ErpType)this.docHeader.getVersion());
        }
        if (this.docHeader.getDocNo() != null) {
            parameterFields.field("DOC_NO", "CO_BELNR", (ErpType)this.docHeader.getDocNo());
        }
        if (this.docHeader.getVariant() != null) {
            parameterFields.field("VARIANT", "CO_VARNR", (ErpType)this.docHeader.getVariant());
        }
        if (this.docHeader.getDocHdrTx() != null) {
            parameterFields.field("DOC_HDR_TX", "CO_BLTXT", this.docHeader.getDocHdrTx());
        }
        if (this.docHeader.getUsername() != null) {
            parameterFields.field("USERNAME", "USNAM", (ErpType)this.docHeader.getUsername());
        }
        if (this.docHeader.getObjKey() != null) {
            parameterFields.field("OBJ_KEY", "AWKEY", (ErpType)this.docHeader.getObjKey());
        }
        if (this.docHeader.getObjType() != null) {
            parameterFields.field("OBJ_TYPE", "AWTYP", (ErpType)this.docHeader.getObjType());
        }
        if (this.docHeader.getObjSys() != null) {
            parameterFields.field("OBJ_SYS", "AWSYS", (ErpType)this.docHeader.getObjSys());
        }
        if (this.docHeader.getValPeriod() != null) {
            parameterFields.field("VAL_PERIOD", "CO_PERIO", (ErpType)this.docHeader.getValPeriod());
        }
        if (this.docHeader.getValFisyear() != null) {
            parameterFields.field("VAL_FISYEAR", "GJAHR", this.docHeader.getValFisyear());
        }
        if (this.docHeader.getDocType() != null) {
            parameterFields.field("DOC_TYPE", "BLART", (ErpType)this.docHeader.getDocType());
        }
        if (this.docHeader.getValuedate() != null) {
            parameterFields.field("VALUEDATE", "CO_WSDAT", this.docHeader.getValuedate());
        }
        parameterFields.end();
        if (this.docItems.iterator().hasNext()) {
            Table table = query.withTable("DOC_ITEMS", "BAPIAAITM");
            for (LineItemsActivityAllocationActualPosting lineItemsActivityAllocationActualPosting : this.docItems) {
                row = table.row();
                if (lineItemsActivityAllocationActualPosting.getSendCctr() != null) {
                    row.field("SEND_CCTR", "SKOST", (ErpType)lineItemsActivityAllocationActualPosting.getSendCctr());
                }
                if (lineItemsActivityAllocationActualPosting.getActtype() != null) {
                    row.field("ACTTYPE", "LSTAR", (ErpType)lineItemsActivityAllocationActualPosting.getActtype());
                }
                if (lineItemsActivityAllocationActualPosting.getSenbusproc() != null) {
                    row.field("SENBUSPROC", "SPRZNR", (ErpType)lineItemsActivityAllocationActualPosting.getSenbusproc());
                }
                if (lineItemsActivityAllocationActualPosting.getActvtyQty() != null) {
                    row.field("ACTVTY_QTY", "LSTXX", (ErpType)lineItemsActivityAllocationActualPosting.getActvtyQty());
                }
                if (lineItemsActivityAllocationActualPosting.getActivityun() != null) {
                    row.field("ACTIVITYUN", "CO_MEINH_L", (ErpType)lineItemsActivityAllocationActualPosting.getActivityun());
                }
                if (lineItemsActivityAllocationActualPosting.getActivityunIso() != null) {
                    row.field("ACTIVITYUN_ISO", "ISOCD_UNIT", (ErpType)lineItemsActivityAllocationActualPosting.getActivityunIso());
                }
                if (lineItemsActivityAllocationActualPosting.getPrice() != null) {
                    row.field("PRICE", "BAPITAG", (ErpType)lineItemsActivityAllocationActualPosting.getPrice());
                }
                if (lineItemsActivityAllocationActualPosting.getCurrency() != null) {
                    row.field("CURRENCY", "WAERS", (ErpType)lineItemsActivityAllocationActualPosting.getCurrency());
                }
                if (lineItemsActivityAllocationActualPosting.getCurrencyIso() != null) {
                    row.field("CURRENCY_ISO", "ISOCD", (ErpType)lineItemsActivityAllocationActualPosting.getCurrencyIso());
                }
                if (lineItemsActivityAllocationActualPosting.getPosOutqty() != null) {
                    row.field("POS_OUTQTY", "AUBXX", (ErpType)lineItemsActivityAllocationActualPosting.getPosOutqty());
                }
                if (lineItemsActivityAllocationActualPosting.getPostoutun() != null) {
                    row.field("POSTOUTUN", "CO_MEINB_A", (ErpType)lineItemsActivityAllocationActualPosting.getPostoutun());
                }
                if (lineItemsActivityAllocationActualPosting.getPostoutunIso() != null) {
                    row.field("POSTOUTUN_ISO", "ISOCD_UNIT", (ErpType)lineItemsActivityAllocationActualPosting.getPostoutunIso());
                }
                if (lineItemsActivityAllocationActualPosting.getPersonNo() != null) {
                    row.field("PERSON_NO", "PERNR_D", (ErpType)lineItemsActivityAllocationActualPosting.getPersonNo());
                }
                if (lineItemsActivityAllocationActualPosting.getSegText() != null) {
                    row.field("SEG_TEXT", "CO_SGTXT", lineItemsActivityAllocationActualPosting.getSegText());
                }
                if (lineItemsActivityAllocationActualPosting.getRecCctr() != null) {
                    row.field("REC_CCTR", "EKOSTL", (ErpType)lineItemsActivityAllocationActualPosting.getRecCctr());
                }
                if (lineItemsActivityAllocationActualPosting.getRecOrder() != null) {
                    row.field("REC_ORDER", "EAUFNR", (ErpType)lineItemsActivityAllocationActualPosting.getRecOrder());
                }
                if (lineItemsActivityAllocationActualPosting.getRecWbsEl() != null) {
                    row.field("REC_WBS_EL", "E_PS_POSID", (ErpType)lineItemsActivityAllocationActualPosting.getRecWbsEl());
                }
                if (lineItemsActivityAllocationActualPosting.getRecsaleord() != null) {
                    row.field("RECSALEORD", "EKDAU", (ErpType)lineItemsActivityAllocationActualPosting.getRecsaleord());
                }
                if (lineItemsActivityAllocationActualPosting.getRecitem() != null) {
                    row.field("RECITEM", "EKDPO", (ErpType)lineItemsActivityAllocationActualPosting.getRecitem());
                }
                if (lineItemsActivityAllocationActualPosting.getReccostobj() != null) {
                    row.field("RECCOSTOBJ", "EKSTR", (ErpType)lineItemsActivityAllocationActualPosting.getReccostobj());
                }
                if (lineItemsActivityAllocationActualPosting.getRecbusproc() != null) {
                    row.field("RECBUSPROC", "EPRZNR", (ErpType)lineItemsActivityAllocationActualPosting.getRecbusproc());
                }
                if (lineItemsActivityAllocationActualPosting.getRecNetwrk() != null) {
                    row.field("REC_NETWRK", "ENPLN", (ErpType)lineItemsActivityAllocationActualPosting.getRecNetwrk());
                }
                if (lineItemsActivityAllocationActualPosting.getRecoperatn() != null) {
                    row.field("RECOPERATN", "EVORG", (ErpType)lineItemsActivityAllocationActualPosting.getRecoperatn());
                }
                if (lineItemsActivityAllocationActualPosting.getRecrunschd() != null) {
                    row.field("RECRUNSCHD", "ESAUFNR", (ErpType)lineItemsActivityAllocationActualPosting.getRecrunschd());
                }
                if (lineItemsActivityAllocationActualPosting.getMaterial() != null) {
                    row.field("MATERIAL", "CO_EMATNR18", (ErpType)lineItemsActivityAllocationActualPosting.getMaterial());
                }
                if (lineItemsActivityAllocationActualPosting.getProdVersn() != null) {
                    row.field("PROD_VERSN", "CO_EVERID", (ErpType)lineItemsActivityAllocationActualPosting.getProdVersn());
                }
                if (lineItemsActivityAllocationActualPosting.getPlant() != null) {
                    row.field("PLANT", "CO_EWERKS", (ErpType)lineItemsActivityAllocationActualPosting.getPlant());
                }
                if (lineItemsActivityAllocationActualPosting.getRecprcmtproc() != null) {
                    row.field("RECPRCMTPROC", "EPROCNR", (ErpType)lineItemsActivityAllocationActualPosting.getRecprcmtproc());
                }
                if (lineItemsActivityAllocationActualPosting.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)lineItemsActivityAllocationActualPosting.getItemnoAcc());
                }
                if (lineItemsActivityAllocationActualPosting.getRecCalcMotive() != null) {
                    row.field("REC_CALC_MOTIVE", "EBEMOT", (ErpType)lineItemsActivityAllocationActualPosting.getRecCalcMotive());
                }
                if (lineItemsActivityAllocationActualPosting.getRecacttype() != null) {
                    row.field("RECACTTYPE", "E_LSTAR", (ErpType)lineItemsActivityAllocationActualPosting.getRecacttype());
                }
                if (lineItemsActivityAllocationActualPosting.getSreCompCode() != null) {
                    row.field("SRE_COMP_CODE", "VVSBUKRS", (ErpType)lineItemsActivityAllocationActualPosting.getSreCompCode());
                }
                if (lineItemsActivityAllocationActualPosting.getSreBusEnt() != null) {
                    row.field("SRE_BUS_ENT", "SSWENR", (ErpType)lineItemsActivityAllocationActualPosting.getSreBusEnt());
                }
                if (lineItemsActivityAllocationActualPosting.getSreProperty() != null) {
                    row.field("SRE_PROPERTY", "SSGRNR", (ErpType)lineItemsActivityAllocationActualPosting.getSreProperty());
                }
                if (lineItemsActivityAllocationActualPosting.getSreBuilding() != null) {
                    row.field("SRE_BUILDING", "SSGENR", (ErpType)lineItemsActivityAllocationActualPosting.getSreBuilding());
                }
                if (lineItemsActivityAllocationActualPosting.getSreRentUnit() != null) {
                    row.field("SRE_RENT_UNIT", "SSMENR", (ErpType)lineItemsActivityAllocationActualPosting.getSreRentUnit());
                }
                if (lineItemsActivityAllocationActualPosting.getSreLease() != null) {
                    row.field("SRE_LEASE", "SSMIVE", (ErpType)lineItemsActivityAllocationActualPosting.getSreLease());
                }
                if (lineItemsActivityAllocationActualPosting.getSreMgmtCon() != null) {
                    row.field("SRE_MGMT_CON", "VVSSVWNR", (ErpType)lineItemsActivityAllocationActualPosting.getSreMgmtCon());
                }
                if (lineItemsActivityAllocationActualPosting.getSreIncExp() != null) {
                    row.field("SRE_INC_EXP", "SSNKSL", (ErpType)lineItemsActivityAllocationActualPosting.getSreIncExp());
                }
                if (lineItemsActivityAllocationActualPosting.getSreSettUnit() != null) {
                    row.field("SRE_SETT_UNIT", "SSEMPSL", (ErpType)lineItemsActivityAllocationActualPosting.getSreSettUnit());
                }
                if (lineItemsActivityAllocationActualPosting.getSreRefDate() != null) {
                    row.field("SRE_REF_DATE", "SDABRBEZ", lineItemsActivityAllocationActualPosting.getSreRefDate());
                }
                if (lineItemsActivityAllocationActualPosting.getSreConNo() != null) {
                    row.field("SRE_CON_NO", "RESCNNR", (ErpType)lineItemsActivityAllocationActualPosting.getSreConNo());
                }
                if (lineItemsActivityAllocationActualPosting.getRreCompCode() != null) {
                    row.field("RRE_COMP_CODE", "EBUKRS", (ErpType)lineItemsActivityAllocationActualPosting.getRreCompCode());
                }
                if (lineItemsActivityAllocationActualPosting.getRreBusEnt() != null) {
                    row.field("RRE_BUS_ENT", "ESWENR", (ErpType)lineItemsActivityAllocationActualPosting.getRreBusEnt());
                }
                if (lineItemsActivityAllocationActualPosting.getRreProperty() != null) {
                    row.field("RRE_PROPERTY", "ESGRNR", (ErpType)lineItemsActivityAllocationActualPosting.getRreProperty());
                }
                if (lineItemsActivityAllocationActualPosting.getRreBuilding() != null) {
                    row.field("RRE_BUILDING", "ESGENR", (ErpType)lineItemsActivityAllocationActualPosting.getRreBuilding());
                }
                if (lineItemsActivityAllocationActualPosting.getRreRentUnit() != null) {
                    row.field("RRE_RENT_UNIT", "ESMENR", (ErpType)lineItemsActivityAllocationActualPosting.getRreRentUnit());
                }
                if (lineItemsActivityAllocationActualPosting.getRreLease() != null) {
                    row.field("RRE_LEASE", "ESMIVE", (ErpType)lineItemsActivityAllocationActualPosting.getRreLease());
                }
                if (lineItemsActivityAllocationActualPosting.getRreMgmtCon() != null) {
                    row.field("RRE_MGMT_CON", "VVESVWNR", (ErpType)lineItemsActivityAllocationActualPosting.getRreMgmtCon());
                }
                if (lineItemsActivityAllocationActualPosting.getRreIncExp() != null) {
                    row.field("RRE_INC_EXP", "ESNKSL", (ErpType)lineItemsActivityAllocationActualPosting.getRreIncExp());
                }
                if (lineItemsActivityAllocationActualPosting.getRreSettUnit() != null) {
                    row.field("RRE_SETT_UNIT", "ESEMPSL", (ErpType)lineItemsActivityAllocationActualPosting.getRreSettUnit());
                }
                if (lineItemsActivityAllocationActualPosting.getRreRefDate() != null) {
                    row.field("RRE_REF_DATE", "EDABRBEZ", lineItemsActivityAllocationActualPosting.getRreRefDate());
                }
                if (lineItemsActivityAllocationActualPosting.getRreConNo() != null) {
                    row.field("RRE_CON_NO", "REECNNR", (ErpType)lineItemsActivityAllocationActualPosting.getRreConNo());
                }
                if (lineItemsActivityAllocationActualPosting.getMaterialExternal() != null) {
                    row.field("MATERIAL_EXTERNAL", "MGV_MATERIAL_EXTERNAL", (ErpType)lineItemsActivityAllocationActualPosting.getMaterialExternal());
                }
                if (lineItemsActivityAllocationActualPosting.getMaterialGuid() != null) {
                    row.field("MATERIAL_GUID", "MGV_MATERIAL_GUID", (ErpType)lineItemsActivityAllocationActualPosting.getMaterialGuid());
                }
                if (lineItemsActivityAllocationActualPosting.getMaterialVersion() != null) {
                    row.field("MATERIAL_VERSION", "MGV_MATERIAL_VERSION", (ErpType)lineItemsActivityAllocationActualPosting.getMaterialVersion());
                }
                if (lineItemsActivityAllocationActualPosting.getRecFund() != null) {
                    row.field("REC_FUND", "FM_EFONDS", (ErpType)lineItemsActivityAllocationActualPosting.getRecFund());
                }
                if (lineItemsActivityAllocationActualPosting.getRecFunction() != null) {
                    row.field("REC_FUNCTION", "EFKTBER", (ErpType)lineItemsActivityAllocationActualPosting.getRecFunction());
                }
                if (lineItemsActivityAllocationActualPosting.getRecGrant() != null) {
                    row.field("REC_GRANT", "GM_GRANT_RECEIVER", (ErpType)lineItemsActivityAllocationActualPosting.getRecGrant());
                }
                if (lineItemsActivityAllocationActualPosting.getSendFund() != null) {
                    row.field("SEND_FUND", "FM_SFONDS", (ErpType)lineItemsActivityAllocationActualPosting.getSendFund());
                }
                if (lineItemsActivityAllocationActualPosting.getSendFunction() != null) {
                    row.field("SEND_FUNCTION", "SFKTBER", (ErpType)lineItemsActivityAllocationActualPosting.getSendFunction());
                }
                if (lineItemsActivityAllocationActualPosting.getSendGrant() != null) {
                    row.field("SEND_GRANT", "GM_GRANT_SENDER", (ErpType)lineItemsActivityAllocationActualPosting.getSendGrant());
                }
                if (lineItemsActivityAllocationActualPosting.getPriceFix() != null) {
                    row.field("PRICE_FIX", "BAPITAF", (ErpType)lineItemsActivityAllocationActualPosting.getPriceFix());
                }
                if (lineItemsActivityAllocationActualPosting.getPriceVar() != null) {
                    row.field("PRICE_VAR", "BAPITAV", (ErpType)lineItemsActivityAllocationActualPosting.getPriceVar());
                }
                if (lineItemsActivityAllocationActualPosting.getPriceUnit() != null) {
                    row.field("PRICE_UNIT", "BAPITEH", (ErpType)lineItemsActivityAllocationActualPosting.getPriceUnit());
                }
                if (lineItemsActivityAllocationActualPosting.getValueTotal() != null) {
                    row.field("VALUE_TOTAL", "BAPIWTG", (ErpType)lineItemsActivityAllocationActualPosting.getValueTotal());
                }
                if (lineItemsActivityAllocationActualPosting.getValueFix() != null) {
                    row.field("VALUE_FIX", "BAPIWTF", (ErpType)lineItemsActivityAllocationActualPosting.getValueFix());
                }
                if (lineItemsActivityAllocationActualPosting.getValueVar() != null) {
                    row.field("VALUE_VAR", "BAPIWTV", (ErpType)lineItemsActivityAllocationActualPosting.getValueVar());
                }
                if (lineItemsActivityAllocationActualPosting.getRecFundLong() != null) {
                    row.field("REC_FUND_LONG", "FM_RGEBER_LONG", lineItemsActivityAllocationActualPosting.getRecFundLong());
                }
                if (lineItemsActivityAllocationActualPosting.getSendFundLong() != null) {
                    row.field("SEND_FUND_LONG", "FM_SGEBER_LONG", lineItemsActivityAllocationActualPosting.getSendFundLong());
                }
                if (lineItemsActivityAllocationActualPosting.getRecBudgetPeriod() != null) {
                    row.field("REC_BUDGET_PERIOD", "FM_EBUDGET_PERIOD", (ErpType)lineItemsActivityAllocationActualPosting.getRecBudgetPeriod());
                }
                if (lineItemsActivityAllocationActualPosting.getSendBudgetPeriod() != null) {
                    row.field("SEND_BUDGET_PERIOD", "FM_SBUDGET_PERIOD", (ErpType)lineItemsActivityAllocationActualPosting.getSendBudgetPeriod());
                }
                if (lineItemsActivityAllocationActualPosting.getMaterialLong() != null) {
                    row.field("MATERIAL_LONG", "CO_EMATNR40", (ErpType)lineItemsActivityAllocationActualPosting.getMaterialLong());
                }
                if (lineItemsActivityAllocationActualPosting.getSenRsrce() != null) {
                    row.field("SEN_RSRCE", "SRSRCE", (ErpType)lineItemsActivityAllocationActualPosting.getSenRsrce());
                }
                if (lineItemsActivityAllocationActualPosting.getRecRsrce() != null) {
                    row.field("REC_RSRCE", "ERSRCE", (ErpType)lineItemsActivityAllocationActualPosting.getRecRsrce());
                }
                if (lineItemsActivityAllocationActualPosting.getRecWorkItm() != null) {
                    row.field("REC_WORK_ITM", "EWORKITM", lineItemsActivityAllocationActualPosting.getRecWorkItm());
                }
                if (lineItemsActivityAllocationActualPosting.getServDate() == null) continue;
                row.field("SERV_DATE", "BAPI_FBUDA", lineItemsActivityAllocationActualPosting.getServDate());
            }
            table.end();
        }
        if (this.criteria != null && this.criteria.iterator().hasNext()) {
            Table table = query.withTable("CRITERIA", "BAPIACKECR");
            for (PostingInAccountingCoPaAcctAssignmentCharacteristic postingInAccountingCoPaAcctAssignmentCharacteristic : this.criteria) {
                row = table.row();
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc() != null) {
                    row.field("ITEMNO_ACC", "POSNR_ACC", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getItemnoAcc());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname() != null) {
                    row.field("FIELDNAME", "FIELDNAME", (ErpType)postingInAccountingCoPaAcctAssignmentCharacteristic.getFieldname());
                }
                if (postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter() == null) continue;
                row.field("CHARACTER", "RKE_CRIGEN", postingInAccountingCoPaAcctAssignmentCharacteristic.getCharacter());
            }
            table.end();
        }
        if (this.customerFields != null && this.customerFields.iterator().hasNext()) {
            Table table = query.withTable("CUSTOMER_FIELDS", "BAPIEXTC");
            for (ContainerForCustomerExitParameter containerForCustomerExitParameter : this.customerFields) {
                row = table.row();
                if (containerForCustomerExitParameter.getField1() != null) {
                    row.field("FIELD1", "STRNG250", containerForCustomerExitParameter.getField1());
                }
                if (containerForCustomerExitParameter.getField2() != null) {
                    row.field("FIELD2", "STRNG250", containerForCustomerExitParameter.getField2());
                }
                if (containerForCustomerExitParameter.getField3() != null) {
                    row.field("FIELD3", "STRNG250", containerForCustomerExitParameter.getField3());
                }
                if (containerForCustomerExitParameter.getField4() == null) continue;
                row.field("FIELD4", "STRNG250", containerForCustomerExitParameter.getField4());
            }
            table.end();
        }
        query.withTableAsReturn("RETURN", "BAPIRET2");
        BapiQueryResult bapiQueryResult = query.execute(new ErpEndpoint(erpConfigContext));
        return new Result(bapiQueryResult);
    }

    public AcctngActivityAllocCheckCommand criteria(PostingInAccountingCoPaAcctAssignmentCharacteristic ... items) {
        this.criteria = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngActivityAllocCheckCommand customerFields(ContainerForCustomerExitParameter ... items) {
        this.customerFields = Lists.newArrayList((Object[])items);
        return this;
    }

    public AcctngActivityAllocCheckCommand ignoreWarnings(String ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AcctngActivityAllocCheckCommand)) {
            return false;
        }
        AcctngActivityAllocCheckCommand other = (AcctngActivityAllocCheckCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DocumentHeaderPostActAllocActualPostings this$docHeader = this.docHeader;
        DocumentHeaderPostActAllocActualPostings other$docHeader = other.docHeader;
        if (this$docHeader == null ? other$docHeader != null : !((Object)this$docHeader).equals(other$docHeader)) {
            return false;
        }
        String this$ignoreWarnings = this.ignoreWarnings;
        String other$ignoreWarnings = other.ignoreWarnings;
        if (this$ignoreWarnings == null ? other$ignoreWarnings != null : !this$ignoreWarnings.equals(other$ignoreWarnings)) {
            return false;
        }
        Iterable<LineItemsActivityAllocationActualPosting> this$docItems = this.docItems;
        Iterable<LineItemsActivityAllocationActualPosting> other$docItems = other.docItems;
        if (this$docItems == null ? other$docItems != null : !this$docItems.equals(other$docItems)) {
            return false;
        }
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> this$criteria = this.criteria;
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> other$criteria = other.criteria;
        if (this$criteria == null ? other$criteria != null : !this$criteria.equals(other$criteria)) {
            return false;
        }
        Iterable<ContainerForCustomerExitParameter> this$customerFields = this.customerFields;
        Iterable<ContainerForCustomerExitParameter> other$customerFields = other.customerFields;
        return !(this$customerFields == null ? other$customerFields != null : !this$customerFields.equals(other$customerFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AcctngActivityAllocCheckCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocumentHeaderPostActAllocActualPostings $docHeader = this.docHeader;
        result = result * 59 + ($docHeader == null ? 43 : ((Object)$docHeader).hashCode());
        String $ignoreWarnings = this.ignoreWarnings;
        result = result * 59 + ($ignoreWarnings == null ? 43 : $ignoreWarnings.hashCode());
        Iterable<LineItemsActivityAllocationActualPosting> $docItems = this.docItems;
        result = result * 59 + ($docItems == null ? 43 : $docItems.hashCode());
        Iterable<PostingInAccountingCoPaAcctAssignmentCharacteristic> $criteria = this.criteria;
        result = result * 59 + ($criteria == null ? 43 : $criteria.hashCode());
        Iterable<ContainerForCustomerExitParameter> $customerFields = this.customerFields;
        result = result * 59 + ($customerFields == null ? 43 : $customerFields.hashCode());
        return result;
    }

    public String toString() {
        return "AcctngActivityAllocCheckCommand(docHeader=" + this.docHeader + ", ignoreWarnings=" + this.ignoreWarnings + ", docItems=" + this.docItems + ", criteria=" + this.criteria + ", customerFields=" + this.customerFields + ")";
    }

    @ConstructorProperties(value={"docHeader", "docItems"})
    public AcctngActivityAllocCheckCommand(DocumentHeaderPostActAllocActualPostings docHeader, @NonNull Iterable<LineItemsActivityAllocationActualPosting> docItems) {
        if (docItems == null) {
            throw new NullPointerException("docItems");
        }
        this.docHeader = docHeader;
        this.docItems = docItems;
    }

    public static class Result {
        private final BapiQueryResult result;

        public List<ReturnParameter> getMessages() {
            return this.result.get("RETURN").getAsCollection().asList(ReturnParameter.class);
        }

        @ConstructorProperties(value={"result"})
        public Result(BapiQueryResult result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BapiQueryResult this$result = this.result;
            BapiQueryResult other$result = other.result;
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BapiQueryResult $result = this.result;
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "AcctngActivityAllocCheckCommand.Result(result=" + this.result + ")";
        }
    }
}

