/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.datamodel.bapi.services;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands.AcctngDocumentCheckCommand;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.services.commands.AcctngDocumentPostCommand;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.CurrencyItem;
import com.sap.cloud.sdk.s4hana.datamodel.bapi.structures.Header;
import lombok.NonNull;

public class AccountingDocumentService {
    public static AcctngDocumentCheckCommand check(@NonNull Header documentHeader) {
        if (documentHeader == null) {
            throw new NullPointerException("documentHeader");
        }
        return new AcctngDocumentCheckCommand(documentHeader);
    }

    public static AcctngDocumentPostCommand post(@NonNull Header documentHeader, @NonNull Iterable<CurrencyItem> currencyAmount) {
        if (documentHeader == null) {
            throw new NullPointerException("documentHeader");
        }
        if (currencyAmount == null) {
            throw new NullPointerException("currencyAmount");
        }
        return new AcctngDocumentPostCommand(documentHeader, currencyAmount);
    }

    public static AcctngDocumentPostCommand post(@NonNull Header documentHeader, CurrencyItem ... currencyAmount) {
        if (documentHeader == null) {
            throw new NullPointerException("documentHeader");
        }
        if (currencyAmount.length < 1) {
            throw new IllegalArgumentException("Parameter \"currencyAmount\" needs to have at least one value.");
        }
        return new AcctngDocumentPostCommand(documentHeader, Lists.newArrayList((Object[])currencyAmount));
    }
}

