/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.annotation.Nonnull;

public class ServiceUriBuilder {
    protected static final String ERP_ENDPOINT_CLOUD = "/sap/bc/rest/sap/fi_map/";
    protected static final String ERP_ENDPOINT_ON_PREMISE = "/sap/hcpint/map/bm/";
    private static final Set<String> testSystemPaths = Sets.newHashSet();

    public static synchronized void registerTestSystem(URI uri) {
        testSystemPaths.add(ServiceUriBuilder.encloseSlashesIfMissing(uri.getPath()));
    }

    protected static String prependSlashIfMissing(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    protected static String appendSlashIfMissing(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    protected static String encloseSlashesIfMissing(String path) {
        return ServiceUriBuilder.prependSlashIfMissing(ServiceUriBuilder.appendSlashIfMissing(path));
    }

    protected String removeErpEndpointPaths(URI baseUri) {
        String path = ServiceUriBuilder.encloseSlashesIfMissing(baseUri.getPath());
        path = path.replaceAll(ERP_ENDPOINT_CLOUD, "");
        path = path.replaceAll(ERP_ENDPOINT_ON_PREMISE, "");
        for (String testSystemPath : testSystemPaths) {
            path = path.replaceAll(testSystemPath, "");
        }
        return ServiceUriBuilder.encloseSlashesIfMissing(path);
    }

    public URI build(@Nonnull URI baseUri, @Nonnull String relativePath) {
        try {
            String path = this.removeErpEndpointPaths(baseUri) + relativePath.replaceFirst("^/", "");
            return new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), path, baseUri.getQuery(), baseUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to build ERP service URI.", e);
        }
    }
}

