/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.QueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Query<QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends QueryResult<QueryT, QueryResultT>> {
    private static final AtomicLong requestIdCounter = new AtomicLong();
    private final long requestId;
    @Nullable
    private Duration longRunningRequestThreshold = null;
    @Nonnull
    private final List<Header> customHttpHeaders = new LinkedList<Header>();

    protected Query() {
        this.requestId = requestIdCounter.incrementAndGet();
    }

    @Nonnull
    public abstract String getConstructedByMethod();

    @Nullable
    public String getReadAccessData() {
        return null;
    }

    @Nonnull
    protected QueryT getThis() {
        return (QueryT)this;
    }

    @Deprecated
    @Nonnull
    public List<Header> getHeaderParameters() {
        return this.customHttpHeaders;
    }

    @Nonnull
    public QueryT withCustomHttpHeader(@Nonnull String name, @Nullable String value) {
        return this.withCustomHttpHeader(new Header(name, value));
    }

    @Nonnull
    public QueryT withCustomHttpHeader(@Nonnull Header header) {
        this.customHttpHeaders.add(header);
        return this.getThis();
    }

    @Nonnull
    public QueryT withSameCustomHttpHeadersAs(@Nonnull Query<?, ?> otherQuery) {
        this.customHttpHeaders.addAll(otherQuery.getCustomHttpHeaders());
        return this.getThis();
    }

    @Nonnull
    public abstract QueryResultT execute(@Nonnull ErpConfigContext var1) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException;

    @Nonnull
    public QueryResultT execute() throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        return this.execute(new ErpConfigContext());
    }

    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public Duration getLongRunningRequestThreshold() {
        return this.longRunningRequestThreshold;
    }

    public void setLongRunningRequestThreshold(@Nullable Duration longRunningRequestThreshold) {
        this.longRunningRequestThreshold = longRunningRequestThreshold;
    }

    @Nonnull
    public List<Header> getCustomHttpHeaders() {
        return this.customHttpHeaders;
    }
}

