/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogger;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataObject;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditedDataSubject;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpointMonitor;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutionMeasurements;
import com.sap.cloud.sdk.s4hana.connectivity.QueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.QuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.RequestMethod;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.ServiceUriBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.exception.AccessDeniedException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.CloudConnectorException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.LogonErrorException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.MissingConfigException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.Logger;

public class HttpRequestExecutor<QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends QueryResult<QueryT, QueryResultT>> {
    private static final Logger logger = CloudLoggerFactory.getLogger(HttpRequestExecutor.class);
    private final QueryExecutionMeasurements measurements = new QueryExecutionMeasurements();
    private static final int MAX_UNCOMPRESSED_PAYLOAD_LENGTH = 1400;
    private static final Duration DEFAULT_LONG_RUNNING_REQUEST_THRESHOLD = Duration.ofMillis(2000L);

    private void assertValidConfigContext(ErpConfigContext configContext) throws MissingConfigException {
        if (configContext.getDestinationName() == null) {
            throw new MissingConfigException("No destination name configured (is null). Please provide a destination name in " + ErpConfigContext.class.getSimpleName() + ".");
        }
        if (configContext.getSapClient() == null) {
            throw new MissingConfigException("No " + SapClient.class.getSimpleName() + " configured (is null). Please set a " + SapClient.class.getSimpleName() + " in property '" + "sap-client" + "' of destination '" + configContext.getDestinationName() + "' or provide the " + SapClient.class.getSimpleName() + " as an explicit argument of " + ErpConfigContext.class.getSimpleName() + ".");
        }
        if (configContext.getLocale() == null) {
            throw new MissingConfigException("No " + Locale.class.getSimpleName() + " configured (is null). Please set a " + Locale.class.getSimpleName() + " in property '" + "sap-language" + "' of destination '" + configContext.getDestinationName() + "' or provide the " + Locale.class.getSimpleName() + " as an explicit argument of " + ErpConfigContext.class.getSimpleName() + ".");
        }
    }

    @Nonnull
    private ByteArrayEntity getBodyAsCompressedEntity(@Nonnull String body) throws QuerySerializationException {
        ByteArrayEntity entity;
        byte[] content;
        try {
            content = body.getBytes(StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new QuerySerializationException("Failed to to convert payload from String to UTF8 byte[].", e);
        }
        if (content.length > 1400) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                gzipOutputStream.write(content);
            }
            catch (IOException e) {
                throw new QuerySerializationException("Failed to write to GZIP-compressed stream.", e);
            }
            entity = new ByteArrayEntity(outputStream.toByteArray());
            entity.setContentEncoding("gzip");
            if (logger.isInfoEnabled()) {
                logger.info("Compressed length of ERP query body: " + entity.getContentLength() + " bytes, was " + content.length + " bytes.");
            }
        } else {
            entity = new ByteArrayEntity(content);
            entity.setContentEncoding(StandardCharsets.UTF_8.toString());
            if (logger.isInfoEnabled()) {
                logger.info("Length of ERP query body: " + entity.getContentLength() + " bytes.");
            }
        }
        return entity;
    }

    @Nonnull
    private URI appendQueryParam(@Nonnull URI uri, @Nullable String queryParamKey, @Nullable String queryParamValue) throws QuerySerializationException {
        String query = uri.getQuery();
        String queryParam = queryParamKey + "=" + queryParamValue;
        String newQuery = Strings.isNullOrEmpty((String)query) ? queryParam : query + "&" + queryParam;
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), newQuery, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new QuerySerializationException(e);
        }
    }

    private void handleHttpStatus(@Nonnull ErpConfigContext configContext, int statusCode, @Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws QueryExecutionException {
        if (statusCode == 200) {
            if (logger.isTraceEnabled()) {
                logger.trace("Query execution finished successfully. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".");
            }
        } else {
            this.handleHttpError(configContext, statusCode, responseBody, responseHeaders);
        }
    }

    private void handleHttpError(@Nonnull ErpConfigContext configContext, int statusCode, @Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws QueryExecutionException {
        switch (statusCode) {
            case 401: {
                this.handleUnauthorized(responseBody, responseHeaders);
                return;
            }
            case 403: {
                this.handleForbidden(responseBody, responseHeaders);
                return;
            }
            case 500: {
                this.handleInternalServerError(responseBody, responseHeaders);
                return;
            }
            case 503: {
                this.handleServiceUnavailableError(configContext, responseBody, responseHeaders);
                return;
            }
            case 502: {
                this.handleBadGateway(responseBody, responseHeaders);
                return;
            }
        }
        String message = "Query execution failed with status code " + statusCode + ". Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new QueryExecutionException(message);
    }

    private void handleUnauthorized(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws LogonErrorException {
        String message = "401 Unauthorized. The connection attempt was refused. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new LogonErrorException(message);
    }

    @Nullable
    private String getMissingAuthorization(@Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) {
        for (com.sap.cloud.sdk.cloudplatform.connectivity.Header header : responseHeaders) {
            if (!header.getName().equals("failed-authorization-object")) continue;
            return header.getValue();
        }
        return null;
    }

    private void handleForbidden(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws AccessDeniedException {
        String prefix = "403 Forbidden. ";
        if (responseBody != null && responseBody.startsWith("CX_FINS_MAP_NO_AUTH_QUERY_EXEC")) {
            String missingAuthorization = this.getMissingAuthorization(responseHeaders);
            throw AccessDeniedException.raiseMissingAuthorizations(null, missingAuthorization != null ? Collections.singleton(new ErpAuthorization(missingAuthorization)) : null);
        }
        String message = "403 Forbidden. Failed to establish a trusted connection to the ERP. This may be caused by a misconfiguration of the SAP Cloud Connector or a misconfiguration of the trust certificate. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new AccessDeniedException(message);
    }

    private void handleInternalServerError(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws QueryExecutionException {
        String prefix = "500 Internal Server Error. ";
        if (responseBody != null && responseBody.contains("ICF") && responseBody.contains("HCPMAPBM")) {
            String message = "500 Internal Server Error. Failed to invoke ICF service. Does the user have authorization HCPMAPBM? Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            throw new AccessDeniedException(message);
        }
        String message = "500 Internal Server Error. Query execution failed with unexpected error. Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new QueryExecutionException(message);
    }

    private void handleServiceUnavailableError(@Nonnull ErpConfigContext configContext, @Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws QueryExecutionException {
        if (responseBody != null && responseBody.contains("No tunnels subscribed for tunnelId")) {
            String message = "503 Service Unavailable. Failed to connect to ERP system. Please check the configuration of destination '" + configContext.getDestinationName() + "'. In an on-premise setup, ensure that the cloud connector is connected.";
            throw new CloudConnectorException(503, message);
        }
        this.handleInternalServerError(responseBody, responseHeaders);
    }

    private void handleBadGateway(@Nullable String responseBody, @Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders) throws QueryExecutionException {
        if (responseBody != null && responseBody.contains("Unable to open connection to backend system")) {
            String message = "502 Bad Gateway. Cloud connector failed to open connection to backend system. Is the internal host configured correctly? Response body: " + responseBody + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            throw new CloudConnectorException(502, message);
        }
        this.handleInternalServerError(responseBody, responseHeaders);
    }

    @Nonnull
    private String getNonSensitiveHeadersAsString(@Nonnull List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers) {
        StringBuilder sb = new StringBuilder();
        Iterator<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headerIt = headers.iterator();
        while (headerIt.hasNext()) {
            com.sap.cloud.sdk.cloudplatform.connectivity.Header header = headerIt.next();
            String name = header.getName();
            String value = header.getValue();
            if ("set-cookie".equalsIgnoreCase(name) || "authorization".equalsIgnoreCase(name)) {
                value = "(hidden)";
            }
            sb.append(name).append(": ").append(value).append(headerIt.hasNext() ? ", " : "");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public QueryResultT execute(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query, @Nonnull QuerySerializer<QueryT, QueryResultT> querySerializer) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        this.assertValidConfigContext(configContext);
        this.measurements.resetMeasurements();
        this.measurements.setBeginTotal(System.nanoTime());
        try {
            SerializedQuery<QueryT> serializedQuery = this.serializeQuery(configContext, query, querySerializer);
            String responseBody = this.execute(configContext, serializedQuery);
            QueryResultT QueryResultT = this.deserializeQuery(configContext, query, querySerializer, responseBody);
            return QueryResultT;
        }
        finally {
            this.measurements.setEndTotal(System.nanoTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private SerializedQuery<QueryT> serializeQuery(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query, @Nonnull QuerySerializer<QueryT, QueryResultT> querySerializer) throws QuerySerializationException, DestinationNotFoundException, DestinationAccessException {
        long beginBuildReq = System.nanoTime();
        try {
            SerializedQuery<QueryT> serializedQuery = querySerializer.serialize(query);
            return serializedQuery;
        }
        finally {
            long endBuildReq = System.nanoTime();
            this.measurements.addBuildRequestDuration(Duration.ofNanos(endBuildReq - beginBuildReq));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private QueryResultT deserializeQuery(@Nonnull ErpConfigContext configContext, @Nonnull QueryT query, @Nonnull QuerySerializer<QueryT, QueryResultT> querySerializer, @Nonnull String responseBody) throws QuerySerializationException, DestinationNotFoundException, DestinationAccessException {
        long beginParseResp = System.nanoTime();
        try {
            SerializedQueryResult<QueryT> serializedQueryResult = new SerializedQueryResult<QueryT>(query, responseBody);
            QueryResultT QueryResultT = querySerializer.deserialize(serializedQueryResult);
            return QueryResultT;
        }
        finally {
            long endParseResp = System.nanoTime();
            this.measurements.addParseResponseDuration(Duration.ofNanos(endParseResp - beginParseResp));
        }
    }

    @Nonnull
    private RequestMethod getRequestMethod(@Nonnull SerializedQuery<QueryT> serializedQuery) {
        return serializedQuery.getRequestMethod();
    }

    @Nonnull
    protected URI getRequestUri(@Nonnull ErpConfigContext configContext, @Nonnull Destination destination, @Nonnull SerializedQuery<QueryT> serializedQuery) {
        return new ServiceUriBuilder().build(destination.getUri(), serializedQuery.getRequestPath());
    }

    @Nonnull
    private List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> getRequestHeaders(ErpConfigContext configContext, @Nonnull SerializedQuery<QueryT> serializedQuery) {
        ArrayList requestHeaders = Lists.newArrayList(serializedQuery.getRequestHeaders());
        if (configContext != null) {
            Locale locale;
            SapClient sapClient = configContext.getSapClient();
            if (sapClient != null && !sapClient.isDefault() && !sapClient.isEmpty()) {
                requestHeaders.add(new com.sap.cloud.sdk.cloudplatform.connectivity.Header("sap-client", sapClient.getValue()));
            }
            if ((locale = configContext.getLocale()) != null && !Strings.isNullOrEmpty((String)locale.getLanguage())) {
                requestHeaders.add(new com.sap.cloud.sdk.cloudplatform.connectivity.Header("sap-language", locale.getLanguage()));
            }
        }
        return requestHeaders;
    }

    private HttpUriRequest newRequest(RequestMethod requestMethod, URI requestUri) {
        switch (requestMethod) {
            case GET: {
                return new HttpGet(requestUri);
            }
            case HEAD: {
                return new HttpHead(requestUri);
            }
            case POST: {
                return new HttpPost(requestUri);
            }
            case PUT: {
                return new HttpPut(requestUri);
            }
            case PATCH: {
                return new HttpPatch(requestUri);
            }
            case DELETE: {
                return new HttpDelete(requestUri);
            }
            case OPTIONS: {
                return new HttpOptions(requestUri);
            }
        }
        throw new ShouldNotHappenException("Unsupported request method: " + (Object)((Object)requestMethod) + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpUriRequest newRequest(@Nonnull RequestMethod requestMethod, @Nonnull URI requestUri, @Nonnull RequestBodyWithHeader bodyWithHeader) throws QuerySerializationException {
        long beginBuildRequest = System.nanoTime();
        try {
            HttpUriRequest request = this.newRequest(requestMethod, requestUri);
            if (request instanceof HttpEntityEnclosingRequest) {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)this.getBodyAsCompressedEntity(bodyWithHeader.body));
            }
            request.setHeader("User-Agent", "ErpEndpointSCP");
            request.setHeader("Accept-Encoding", "gzip");
            for (com.sap.cloud.sdk.cloudplatform.connectivity.Header header : bodyWithHeader.headers) {
                request.setHeader(header.getName(), header.getValue());
            }
            if (logger.isTraceEnabled()) {
                Thread currentThread = Thread.currentThread();
                logger.trace("Successfully prepared HTTP request for query execution (thread: " + currentThread + ", threat id: " + currentThread.getId() + ") URI: " + requestUri + " Body: " + bodyWithHeader.body + " Headers: " + this.getNonSensitiveHeadersAsString(bodyWithHeader.headers) + ".");
            }
            HttpUriRequest httpUriRequest = request;
            return httpUriRequest;
        }
        finally {
            this.measurements.addBuildRequestDuration(Duration.ofNanos(System.nanoTime() - beginBuildRequest));
        }
    }

    private void logReadAccessAttempt(Query<?, ?> query, ErpConfigContext context) {
        String readAccessData = query.getReadAccessData();
        if (readAccessData != null) {
            AuditLogger.logDataReadAttempt((AuditedDataObject)new AuditedDataObject(query.getClass().getSimpleName()), (AuditedDataSubject)new AuditedDataSubject(context.getDestinationName(), context.getSapClient().getValue()), (AccessedAttribute)new AccessedAttribute(readAccessData, AccessedAttribute.Operation.READ), (AccessedAttribute[])new AccessedAttribute[0]);
        }
    }

    private String getQueryExecutionFailedMessage(Query<?, ?> query) {
        return query.getClass().getSimpleName() + " " + query.getConstructedByMethod() + " failed [" + this.measurements.getMeasurementsString() + "]";
    }

    private void recordExecutionDuration(SerializedQuery<? extends Query<?, ?>> serializedQuery, RequestLine requestLine, StatusLine statusLine, List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders, String responseBody) {
        Duration currLongRunningRequestThreshold;
        Duration executeRequestDuration = this.measurements.getExecuteRequestDuration();
        Duration longRunningRequestThreshold = serializedQuery.getQuery().getLongRunningRequestThreshold();
        Duration duration = currLongRunningRequestThreshold = longRunningRequestThreshold != null ? longRunningRequestThreshold : DEFAULT_LONG_RUNNING_REQUEST_THRESHOLD;
        if (executeRequestDuration != null && currLongRunningRequestThreshold.compareTo(executeRequestDuration) < 0) {
            ErpEndpointMonitor.getInstance().trackLongRunningRequest(this.measurements.getExecuteRequestDuration(), requestLine.toString(), serializedQuery.getRequestBody(), statusLine.toString(), responseHeaders, responseBody.length());
        }
    }

    @Nonnull
    public String execute(@Nonnull ErpConfigContext configContext, @Nonnull SerializedQuery<QueryT> serializedQuery) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        String responseBody;
        HttpResponse response;
        QueryT query = serializedQuery.getQuery();
        ErpEndpointMonitor.getInstance().incrementErpQueryCount(query);
        Destination destination = DestinationAccessor.getDestination((String)configContext.getDestinationName());
        HttpClient httpClient = HttpClientAccessor.getHttpClient((Destination)destination);
        RequestMethod requestMethod = this.getRequestMethod(serializedQuery);
        URI requestUri = this.getRequestUri(configContext, destination, serializedQuery);
        RequestBodyWithHeader bodyWithHeader = this.getRequestBodyWithHeader(configContext, serializedQuery);
        HttpUriRequest request = this.newRequest(requestMethod, requestUri, bodyWithHeader);
        ArrayList<com.sap.cloud.sdk.cloudplatform.connectivity.Header> responseHeaders = new ArrayList<com.sap.cloud.sdk.cloudplatform.connectivity.Header>();
        long beginExecute = System.nanoTime();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing " + query.getClass().getSimpleName() + " constructed by: " + ((Query)query).getConstructedByMethod() + ".");
            }
            this.logReadAccessAttempt((Query<?, ?>)query, configContext);
            response = httpClient.execute(request);
            for (Header header : response.getAllHeaders()) {
                responseHeaders.add(new com.sap.cloud.sdk.cloudplatform.connectivity.Header(header.getName(), header.getValue()));
            }
            responseBody = HttpEntityUtil.getResponseBody((HttpResponse)response);
        }
        catch (QuerySerializationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.getQueryExecutionFailedMessage((Query<?, ?>)query), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String message = this.getQueryExecutionFailedMessage((Query<?, ?>)query);
            throw new QueryExecutionException(message, e);
        }
        finally {
            this.measurements.addExecuteRequestDuration(Duration.ofNanos(System.nanoTime() - beginExecute));
        }
        if (responseBody == null) {
            throw new QueryExecutionException("Failed to execute query: no body returned in response.");
        }
        this.recordExecutionDuration(serializedQuery, request.getRequestLine(), response.getStatusLine(), responseHeaders, responseBody);
        this.handleHttpStatus(configContext, response.getStatusLine().getStatusCode(), responseBody, responseHeaders);
        return responseBody;
    }

    @Nonnull
    protected RequestBodyWithHeader getRequestBodyWithHeader(ErpConfigContext configContext, @Nonnull SerializedQuery<QueryT> query) {
        return new RequestBodyWithHeader(this.getRequestHeaders(configContext, query), query.getRequestBody());
    }

    public QueryExecutionMeasurements getMeasurements() {
        return this.measurements;
    }

    static final class RequestBodyWithHeader {
        private final List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers;
        private final String body;

        public RequestBodyWithHeader(List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers, String body) {
            this.headers = headers;
            this.body = body;
        }

        public List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RequestBodyWithHeader)) {
                return false;
            }
            RequestBodyWithHeader other = (RequestBodyWithHeader)o;
            List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> this$headers = this.getHeaders();
            List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "HttpRequestExecutor.RequestBodyWithHeader(headers=" + this.getHeaders() + ", body=" + this.getBody() + ")";
        }
    }

    private static class ErpAuthorization
    extends Authorization {
        ErpAuthorization(@Nonnull String missingAuthorization) {
            super(missingAuthorization);
        }
    }
}

