/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.serialization.ErpType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;

public class ErpTypeGsonTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (ErpType.class.isAssignableFrom(rawType)) {
            return new ErpTypeAdapter(rawType);
        }
        return null;
    }

    private static class ErpTypeAdapter<ErpTypeT extends ErpType<ErpTypeT>>
    extends TypeAdapter<ErpTypeT> {
        private static final Logger logger = CloudLoggerFactory.getLogger(ErpTypeAdapter.class);
        private final Class<ErpTypeT> rawType;

        public ErpTypeAdapter(Class<ErpTypeT> rawType) {
            this.rawType = rawType;
        }

        public void write(JsonWriter out, ErpTypeT value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value((String)value.getTypeConverter().toDomain(value).orNull());
            }
        }

        public ErpTypeT read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            try {
                Class<?> cls = Class.forName(this.rawType.getName());
                String erpObject = reader.nextString();
                if (cls.isEnum()) {
                    ErpType enumConstant = (ErpType)cls.getEnumConstants()[0];
                    return (ErpTypeT)((ErpType)enumConstant.getTypeConverter().fromDomain((Object)erpObject).orNull());
                }
                Constructor<?> stringConstructor = cls.getConstructor(String.class);
                ErpType erpType = (ErpType)stringConstructor.newInstance("");
                return (ErpTypeT)((ErpType)erpType.getTypeConverter().fromDomain((Object)erpObject).orNull());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to instantiate ERP type: " + this.rawType.getName() + ".", (Throwable)e);
                }
                return null;
            }
        }
    }
}

