/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.monitoring.JmxMonitor;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpointMonitorMXBean;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;

@WebListener
public class ErpEndpointMonitor
extends JmxMonitor
implements ErpEndpointMonitorMXBean {
    private static final ErpEndpointMonitor instance = new ErpEndpointMonitor();
    private final Map<String, AtomicLong> erpQueryCounts = Maps.newConcurrentMap();
    private final BlockingQueue<LongRunningRequestInfo> longRunningRequests = new PriorityBlockingQueue(20, Collections.reverseOrder());
    private final BlockingQueue<ZonedDateTime> longRunningRequestTimes1h = new PriorityBlockingQueue<ZonedDateTime>();

    public <QueryT extends Query<QueryT, ?>> void incrementErpQueryCount(QueryT query) {
        String name = query.getClass().getSimpleName();
        AtomicLong queryCount = this.erpQueryCounts.get(name);
        if (queryCount == null) {
            queryCount = new AtomicLong();
            this.erpQueryCounts.put(name, queryCount);
        }
        queryCount.incrementAndGet();
    }

    @Override
    public Map<String, Long> getErpQueryCounts() {
        TreeMap counts = Maps.newTreeMap();
        for (Map.Entry<String, AtomicLong> stringAtomicLongEntry : this.erpQueryCounts.entrySet()) {
            counts.put(stringAtomicLongEntry.getKey(), stringAtomicLongEntry.getValue().get());
        }
        return counts;
    }

    @Override
    public int getLongRunningRequestsLast1h() {
        return this.longRunningRequestTimes1h.size();
    }

    @Override
    public List<String> getLongRunningRequests() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.longRunningRequests.size());
        for (LongRunningRequestInfo longRunningRequestInfo : this.longRunningRequests) {
            result.add(longRunningRequestInfo.toString());
        }
        return result;
    }

    public void trackLongRunningRequest(Duration duration, String requestLine, String requestBody, String responseLine, List<Header> responseHeaders, int responseLength) {
        ZonedDateTime now = ZonedDateTime.now();
        LongRunningRequestInfo longRunningRequestInfo = new LongRunningRequestInfo(now, duration, requestLine, requestBody, responseLine, responseHeaders.stream().map(Object::toString).collect(Collectors.joining(", ")), responseLength);
        this.longRunningRequests.add(longRunningRequestInfo);
        this.addNewAndDropOldEntries(now);
    }

    void addNewAndDropOldEntries(ZonedDateTime toAdd) {
        ZonedDateTime oldest;
        ZonedDateTime threshold = toAdd.minus(Duration.ofHours(1L));
        while ((oldest = (ZonedDateTime)this.longRunningRequestTimes1h.peek()) != null && oldest.compareTo(threshold) < 0) {
            if (oldest.compareTo(threshold) >= 0) continue;
            this.longRunningRequestTimes1h.poll();
        }
        this.longRunningRequestTimes1h.add(toAdd);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        instance.registerJmxBean();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        instance.unregisterJmxBean();
    }

    public static ErpEndpointMonitor getInstance() {
        return instance;
    }

    private static class LongRunningRequestInfo
    implements Comparable<LongRunningRequestInfo> {
        private final ZonedDateTime timeStamp;
        private final Duration duration;
        private final String requestLine;
        private final String requestBody;
        private final String responseLine;
        private final String responseHeaders;
        private final int responseLength;

        @Override
        public int compareTo(@Nonnull LongRunningRequestInfo o) {
            return this.getDuration().compareTo(o.getDuration());
        }

        public LongRunningRequestInfo(ZonedDateTime timeStamp, Duration duration, String requestLine, String requestBody, String responseLine, String responseHeaders, int responseLength) {
            this.timeStamp = timeStamp;
            this.duration = duration;
            this.requestLine = requestLine;
            this.requestBody = requestBody;
            this.responseLine = responseLine;
            this.responseHeaders = responseHeaders;
            this.responseLength = responseLength;
        }

        public ZonedDateTime getTimeStamp() {
            return this.timeStamp;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String getRequestLine() {
            return this.requestLine;
        }

        public String getRequestBody() {
            return this.requestBody;
        }

        public String getResponseLine() {
            return this.responseLine;
        }

        public String getResponseHeaders() {
            return this.responseHeaders;
        }

        public int getResponseLength() {
            return this.responseLength;
        }

        public String toString() {
            return "ErpEndpointMonitor.LongRunningRequestInfo(timeStamp=" + this.getTimeStamp() + ", duration=" + this.getDuration() + ", requestLine=" + this.getRequestLine() + ", requestBody=" + this.getRequestBody() + ", responseLine=" + this.getResponseLine() + ", responseHeaders=" + this.getResponseHeaders() + ", responseLength=" + this.getResponseLength() + ")";
        }
    }
}

