/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationTypeNotSupportedException;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleAccessor;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErpDestinationPropertyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ErpDestinationPropertyExtractor.class);

    private ErpDestinationPropertyExtractor() {
    }

    static boolean destinationHasSapClientProperty(@Nonnull GenericDestination destination) {
        String propertyName = ErpDestinationPropertyExtractor.getDefaultSapClientPropertyName(destination);
        return destination.getPropertiesByName().containsKey(propertyName);
    }

    private static String getDefaultSapClientPropertyName(@Nonnull GenericDestination destination) {
        switch (destination.getDestinationType()) {
            case HTTP: {
                return "sap-client";
            }
            case RFC: {
                return "jco.client.client";
            }
        }
        throw new DestinationTypeNotSupportedException(destination.getName(), destination.getDestinationType());
    }

    static SapClient extractSapClient(@Nonnull GenericDestination destination) {
        return ErpDestinationPropertyExtractor.extractSapClient(destination.getName(), null);
    }

    static SapClient extractSapClient(@Nonnull String destinationName, @Nullable String sapClientPropertyName) {
        GenericDestination destination = DestinationAccessor.getGenericDestination((String)destinationName);
        String propertyName = sapClientPropertyName == null ? ErpDestinationPropertyExtractor.getDefaultSapClientPropertyName(destination) : sapClientPropertyName;
        String property = (String)destination.getPropertiesByName().get(propertyName);
        if (property == null && log.isInfoEnabled()) {
            log.info("Unable to retrieve SAP client from destination property '" + propertyName + "'. Falling back to default SAP client. To specify the SAP client, set the property on destination '" + destination.getName() + "' or provide the SAP client as explicit argument.");
        }
        return property != null ? new SapClient(property) : SapClient.DEFAULT;
    }

    static Locale extractLocale(@Nonnull GenericDestination destination) {
        return ErpDestinationPropertyExtractor.extractLocale(destination.getName(), null);
    }

    static Locale extractLocale(@Nonnull String destinationName, @Nullable String localePropertyName) {
        Locale fallback;
        GenericDestination destination;
        block8: {
            String propertyName;
            destination = null;
            if (localePropertyName == null) {
                destination = DestinationAccessor.getGenericDestination((String)destinationName);
                propertyName = ErpDestinationPropertyExtractor.getDefaultLocaleClientPropertyName(destination);
            } else {
                propertyName = localePropertyName;
            }
            fallback = null;
            try {
                String localeString;
                if (destination == null) {
                    destination = DestinationAccessor.getGenericDestination((String)destinationName);
                }
                if ((localeString = (String)destination.getPropertiesByName().get(propertyName)) != null) {
                    fallback = Locale.forLanguageTag(localeString.replace('_', '-'));
                }
            }
            catch (DestinationAccessException | DestinationNotFoundException e) {
                if (!log.isInfoEnabled()) break block8;
                log.info("Unable to retrieve locale from destination property '" + propertyName + "'.", e);
            }
        }
        if (fallback == null) {
            fallback = LocaleAccessor.getCurrentLocale();
            if (log.isInfoEnabled()) {
                log.info("Falling back to locale '" + fallback + "'. To specify the locale, set the property on destination '" + destination.getName() + "' or provide the locale as explicit argument.");
            }
        }
        return fallback;
    }

    private static String getDefaultLocaleClientPropertyName(@Nonnull GenericDestination destination) {
        DestinationType destinationType = destination.getDestinationType();
        switch (destinationType) {
            case HTTP: {
                return "sap-language";
            }
            case RFC: {
                return "jco.client.lang";
            }
        }
        throw new DestinationTypeNotSupportedException(destination.getName(), destinationType);
    }

    static boolean destinationHasLocaleProperty(@Nonnull GenericDestination destination) {
        String propertyName = ErpDestinationPropertyExtractor.getDefaultLocaleClientPropertyName(destination);
        return destination.getPropertiesByName().containsKey(propertyName);
    }
}

