/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationHeaderProvider;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestinationPropertyExtractor;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ErpDestinationHeaderProvider
implements DestinationHeaderProvider {
    @Nonnull
    public List<Header> getHeaders(@Nonnull Destination destination) {
        Option<Header> maybeSapLanguageHeader;
        ArrayList<Header> result = new ArrayList<Header>();
        Option<Header> maybeSapClientHeader = this.getSapClientHeader(destination);
        if (maybeSapClientHeader.isDefined()) {
            result.add((Header)maybeSapClientHeader.get());
        }
        if ((maybeSapLanguageHeader = this.getSapLanguageHeader(destination)).isDefined()) {
            result.add((Header)maybeSapLanguageHeader.get());
        }
        return result;
    }

    private Option<Header> getSapClientHeader(@Nonnull Destination destination) {
        if (ErpDestinationPropertyExtractor.destinationHasSapClientProperty((GenericDestination)destination)) {
            return Option.of((Object)new Header("sap-client", ErpDestinationPropertyExtractor.extractSapClient((GenericDestination)destination).getValue()));
        }
        return Option.none();
    }

    private Option<Header> getSapLanguageHeader(@Nonnull Destination destination) {
        if (ErpDestinationPropertyExtractor.destinationHasLocaleProperty((GenericDestination)destination)) {
            return Option.of((Object)new Header("sap-language", ErpDestinationPropertyExtractor.extractLocale((GenericDestination)destination).getLanguage()));
        }
        return Option.none();
    }
}

