/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestination;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestinationPropertyExtractor;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ErpConfigContext
implements ConfigContext,
WithDestinationName {
    public static final String DESTINATION_NAME_SUFFIX_RFC = "_RFC";
    public static final String DEFAULT_SAP_CLIENT_PROPERTY = "sap-client";
    public static final String DEFAULT_LOCALE_PROPERTY = "sap-language";
    public static final String DEFAULT_SAP_CLIENT_PROPERTY_RFC = "jco.client.client";
    public static final String DEFAULT_LOCALE_PROPERTY_RFC = "jco.client.lang";
    private static final Logger logger = CloudLoggerFactory.getSanitizedLogger(ErpConfigContext.class);
    @Nonnull
    private final String destinationName;
    @Nonnull
    private final String destinationNameRfc;
    @Nonnull
    private final SapClient sapClient;
    @Nonnull
    private final Locale locale;

    public ErpConfigContext(@Nullable String destinationName, @Nullable SapClient sapClient, @Nullable Locale locale) throws DestinationAccessException {
        this(destinationName, sapClient, null, locale, null);
    }

    public ErpConfigContext(@Nullable String destinationName, @Nullable SapClient sapClient, @Nullable String sapClientProperty, @Nullable Locale locale, @Nullable String localeProperty) throws DestinationAccessException {
        this(destinationName, null, sapClient, sapClientProperty, locale, localeProperty);
    }

    public ErpConfigContext(@Nullable String destinationName, @Nullable String destinationNameRfc, @Nullable SapClient sapClient, @Nullable String sapClientProperty, @Nullable Locale locale, @Nullable String localeProperty) throws DestinationAccessException {
        this.destinationName = destinationName == null ? ErpDestination.getDefaultName() : destinationName;
        this.destinationNameRfc = destinationNameRfc == null ? this.destinationName + DESTINATION_NAME_SUFFIX_RFC : destinationNameRfc;
        Object destination = null;
        this.sapClient = sapClient == null ? ErpDestinationPropertyExtractor.extractSapClient(this.destinationName, sapClientProperty) : sapClient;
        this.locale = locale == null ? ErpDestinationPropertyExtractor.extractLocale(this.destinationName, localeProperty) : locale;
    }

    public ErpConfigContext(@Nullable String destinationName, @Nullable SapClient sapClient) {
        this(destinationName, sapClient, null, null, null);
    }

    public ErpConfigContext(@Nullable String destinationName) {
        this(destinationName, null, null, null, null);
    }

    public ErpConfigContext(@Nullable SapClient sapClient) {
        this(null, sapClient, null, null, null);
    }

    public ErpConfigContext(@Nullable Locale locale) {
        this(null, null, null, locale, null);
    }

    public ErpConfigContext() {
        this(null, null, null, null, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErpConfigContext)) {
            return false;
        }
        ErpConfigContext other = (ErpConfigContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$destinationName = this.getDestinationName();
        String other$destinationName = other.getDestinationName();
        if (this$destinationName == null ? other$destinationName != null : !this$destinationName.equals(other$destinationName)) {
            return false;
        }
        String this$destinationNameRfc = this.getDestinationNameRfc();
        String other$destinationNameRfc = other.getDestinationNameRfc();
        if (this$destinationNameRfc == null ? other$destinationNameRfc != null : !this$destinationNameRfc.equals(other$destinationNameRfc)) {
            return false;
        }
        SapClient this$sapClient = this.getSapClient();
        SapClient other$sapClient = other.getSapClient();
        if (this$sapClient == null ? other$sapClient != null : !this$sapClient.equals(other$sapClient)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        return !(this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErpConfigContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $destinationName = this.getDestinationName();
        result = result * 59 + ($destinationName == null ? 43 : $destinationName.hashCode());
        String $destinationNameRfc = this.getDestinationNameRfc();
        result = result * 59 + ($destinationNameRfc == null ? 43 : $destinationNameRfc.hashCode());
        SapClient $sapClient = this.getSapClient();
        result = result * 59 + ($sapClient == null ? 43 : $sapClient.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        return result;
    }

    public String toString() {
        return "ErpConfigContext(destinationName=" + this.getDestinationName() + ", destinationNameRfc=" + this.getDestinationNameRfc() + ", sapClient=" + this.getSapClient() + ", locale=" + this.getLocale() + ")";
    }

    @Nonnull
    public String getDestinationName() {
        return this.destinationName;
    }

    @Nonnull
    public String getDestinationNameRfc() {
        return this.destinationNameRfc;
    }

    @Nonnull
    public SapClient getSapClient() {
        return this.sapClient;
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }
}

