/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.netflix.hystrix.HystrixCommand;
import com.sap.cloud.sdk.frameworks.hystrix.Command;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.WithErpConfigContext;
import javax.annotation.Nonnull;

public abstract class ErpCommand<T>
extends Command<T>
implements WithErpConfigContext {
    @Nonnull
    private final ErpConfigContext configContext;

    protected ErpCommand(@Nonnull HystrixCommand.Setter setter) {
        super(setter);
        this.configContext = new ErpConfigContext();
    }

    protected ErpCommand(@Nonnull HystrixCommand.Setter setter, @Nonnull ErpConfigContext configContext) {
        super(setter);
        this.configContext = configContext;
    }

    protected ErpCommand(@Nonnull Class<?> commandType) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), new ErpConfigContext());
    }

    protected ErpCommand(@Nonnull Class<?> commandType, @Nonnull ErpConfigContext erpConfigContext) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), erpConfigContext);
    }

    @Override
    @Nonnull
    public ErpConfigContext getConfigContext() {
        return this.configContext;
    }
}

