/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.Duration;
import javax.annotation.Nullable;

public class DurationDeserializer
implements JsonDeserializer<Duration> {
    @Nullable
    private static Duration toDuration(String microsecsStr) {
        long microsecs;
        if (microsecsStr == null) {
            return null;
        }
        try {
            microsecs = Long.parseLong(microsecsStr.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
        return Duration.ofNanos(microsecs * 1000L);
    }

    public Duration deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        return DurationDeserializer.toDuration(json.getAsString());
    }
}

