/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.netflix.hystrix.HystrixCommand;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.frameworks.hystrix.CachingCommand;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.WithErpConfigContext;
import javax.annotation.Nonnull;

public abstract class CachingErpCommand<T>
extends CachingCommand<T>
implements WithErpConfigContext {
    @Nonnull
    private final ErpConfigContext configContext;

    protected CachingErpCommand(@Nonnull HystrixCommand.Setter setter) {
        this(setter, new ErpConfigContext());
    }

    protected CachingErpCommand(@Nonnull HystrixCommand.Setter setter, @Nonnull ErpConfigContext configContext) {
        super(setter);
        this.configContext = configContext;
    }

    protected CachingErpCommand(@Nonnull Class<?> commandType) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType));
    }

    protected CachingErpCommand(@Nonnull Class<?> commandType, @Nonnull ErpConfigContext erpConfigContext) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), erpConfigContext);
    }

    @Nonnull
    protected CacheKey getCommandCacheKey() {
        return super.getCommandCacheKey().append(new Object[]{this.getConfigContext()});
    }

    @Override
    @Nonnull
    public ErpConfigContext getConfigContext() {
        return this.configContext;
    }
}

