/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.QueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.QuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public abstract class AbstractQuerySerializer<QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends QueryResult<QueryT, QueryResultT>>
implements QuerySerializer<QueryT, QueryResultT> {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractQuerySerializer.class);

    @Override
    @Nonnull
    public final SerializedQuery<QueryT> serialize(@Nonnull QueryT query) throws QuerySerializationException {
        try {
            SerializedQuery<QueryT> result = this.serializeQuery(query);
            result.getRequestHeaders().addAll(((Query)query).getCustomHttpHeaders());
            return result;
        }
        catch (Exception e) {
            throw new QuerySerializationException(e);
        }
    }

    @Override
    @Nonnull
    public final QueryResultT deserialize(@Nonnull SerializedQueryResult<QueryT> queryResult) throws QuerySerializationException {
        try {
            return this.deserializeQueryResult(queryResult);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to deserialize query result from {}: {}", (Object)queryResult.getQuery().getClass().getSimpleName(), (Object)e.getMessage());
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Unable to deserialize result body: {}", (Object)queryResult.getBody());
            }
            throw new QuerySerializationException(e);
        }
    }

    @Nonnull
    protected abstract SerializedQuery<QueryT> serializeQuery(@Nonnull QueryT var1) throws Exception;

    @Nonnull
    protected abstract QueryResultT deserializeQueryResult(@Nonnull SerializedQueryResult<QueryT> var1) throws Exception;
}

