/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.signing;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStore;
import com.sap.cloud.sdk.cloudplatform.security.secret.SecretStoreAccessor;
import com.sap.cloud.sdk.cloudplatform.security.secret.exception.SecretStoreException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public final class TrustSignatureKey {
    private static final Logger logger = CloudLoggerFactory.getLogger(TrustSignatureKey.class);
    public static final String PASSWORD_STORE_NAME = "trustcert";
    public static final String KEY_STORE_NAME = "trustcert";
    public static final String KEY_ALIAS = "trustcert";
    private static final AtomicReference<PrivateKey> PRIVATE_KEY = new AtomicReference();
    private static final AtomicReference<Certificate> CERTIFICATE = new AtomicReference();

    static Optional<PrivateKey> getPrivateKey() {
        return Optional.fromNullable((Object)PRIVATE_KEY.get());
    }

    static Optional<Certificate> getCertificate() {
        return Optional.fromNullable((Object)CERTIFICATE.get());
    }

    private static SecretStore getKeyStorePassword() throws SecretStoreException {
        return SecretStoreAccessor.getSecretStore((String)"trustcert");
    }

    private static KeyStore getKeyStore(SecretStore password) throws com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreException {
        return SecretStoreAccessor.getKeyStore((String)"trustcert", (SecretStore)password);
    }

    public static synchronized void initialize() {
        SecretStore password;
        try {
            password = TrustSignatureKey.getKeyStorePassword();
        }
        catch (SecretStoreException e) {
            logger.warn("Failed to retrieve key store password from password store \"trustcert\".", (Throwable)e);
            return;
        }
        if (password == null) {
            logger.warn("Key store password is null in password store \"trustcert\".");
            return;
        }
        logger.info("Successfully loaded key store password.");
        try {
            KeyStore keyStore = TrustSignatureKey.getKeyStore(password);
            if (keyStore == null) {
                logger.warn("Key store \"trustcert\" is null.");
                return;
            }
            logger.info("Successfully loaded key store.");
            PRIVATE_KEY.set((PrivateKey)keyStore.getKey("trustcert", password.getSecret()));
            CERTIFICATE.set(keyStore.getCertificate("trustcert"));
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.warn("Failed to retrieve private key with alias \"trustcert\".", (Throwable)e);
            return;
        }
        catch (com.sap.cloud.sdk.cloudplatform.security.secret.exception.KeyStoreException | KeyStoreException e) {
            logger.warn("Failed to load data from key store.", e);
            return;
        }
        if (!TrustSignatureKey.getPrivateKey().isPresent()) {
            logger.warn("Private key with alias \"trustcert\" not found in key store \"trustcert\".");
        } else {
            logger.info("Successfully initialized private key.");
        }
        if (!TrustSignatureKey.getCertificate().isPresent()) {
            logger.warn("Public certificate with alias \"trustcert\" not found in key store \"trustcert\".");
        } else {
            logger.info("Successfully initialized public certificate.");
        }
    }
}

