/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.signing;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpQuerySigner;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpQuerySignerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpQuerySigningStrategy;
import com.sap.cloud.sdk.s4hana.connectivity.signing.KeyStoreErpQuerySigner;
import com.sap.cloud.sdk.s4hana.connectivity.signing.NoSigningErpQuerySigner;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SigningAlgorithm;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SigningServiceDestination;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SigningServiceErpQuerySigner;
import com.sap.cloud.sdk.s4hana.connectivity.signing.TrustSignatureKey;
import java.security.PrivateKey;

public class StrategyBasedErpQuerySignerFactory
implements ErpQuerySignerFactory {
    private static ErpQuerySigningStrategy STRATEGY = StrategyBasedErpQuerySignerFactory.getDefaultStrategy();
    private final String signingServiceDestinationName;

    public static ErpQuerySigningStrategy getDefaultStrategy() {
        return ErpQuerySigningStrategy.KEY_STORE_BEFORE_QUERY_SERVICE;
    }

    public static void setStrategy(ErpQuerySigningStrategy querySigningStrategy) {
        STRATEGY = querySigningStrategy;
    }

    public StrategyBasedErpQuerySignerFactory() {
        this.signingServiceDestinationName = SigningServiceDestination.getDefaultName();
    }

    public StrategyBasedErpQuerySignerFactory(String signingServiceDestinationName) {
        this.signingServiceDestinationName = signingServiceDestinationName;
    }

    @Override
    public ErpQuerySigner newQuerySigner(SigningAlgorithm signingAlgorithm) {
        switch (STRATEGY) {
            case KEY_STORE_ONLY: {
                return new KeyStoreErpQuerySigner(signingAlgorithm);
            }
            case QUERY_SERVICE_ONLY: {
                return new SigningServiceErpQuerySigner(this.signingServiceDestinationName, signingAlgorithm);
            }
            case NO_SIGNING: {
                return new NoSigningErpQuerySigner();
            }
        }
        Optional<PrivateKey> privateKey = TrustSignatureKey.getPrivateKey();
        if (privateKey.isPresent()) {
            return new KeyStoreErpQuerySigner(signingAlgorithm);
        }
        return new SigningServiceErpQuerySigner(this.signingServiceDestinationName, signingAlgorithm);
    }
}

