/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.signing;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SignedErpQuery;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SigningAlgorithm;
import com.sap.cloud.sdk.s4hana.util.DateTimeUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.joda.time.Duration;
import org.slf4j.Logger;
import rx.Observable;

public class SigningServiceCommand
extends HystrixObservableCommand<SignedErpQuery> {
    private static final Logger logger = CloudLoggerFactory.getLogger(SigningServiceCommand.class);
    private final String destinationName;
    private final String query;
    private final SigningAlgorithm signingAlgorithm;

    public SigningServiceCommand(String destinationName, String query, SigningAlgorithm signingAlgorithm) {
        super(HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)HystrixCommandGroupKey.Factory.asKey((String)SigningServiceCommand.class.getName())).andCommandPropertiesDefaults(HystrixCommandProperties.Setter().withCircuitBreakerEnabled(false).withExecutionTimeoutInMilliseconds(5000)));
        this.destinationName = destinationName;
        this.query = query;
        this.signingAlgorithm = signingAlgorithm;
    }

    protected Observable<SignedErpQuery> construct() {
        try {
            HttpClient httpClient = HttpClientAccessor.getHttpClient((String)this.destinationName);
            HttpPost post = new HttpPost();
            post.setHeader("erp-signing-algorithm", this.signingAlgorithm.name());
            post.setHeader("Accept-Encoding", "gzip");
            post.setEntity((HttpEntity)new StringEntity(this.query, "UTF-8"));
            long start = System.nanoTime();
            HttpResponse response = httpClient.execute((HttpUriRequest)post);
            SignedErpQuery result = this.extractSignedErpQuery(response);
            long end = System.nanoTime();
            if (logger.isInfoEnabled()) {
                logger.info("Calling the signing service took " + DateTimeUtil.formatDuration((Duration)DateTimeUtil.newDuration((long)start, (long)end)) + ". Query length: " + this.query.length() + ".");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Query: " + this.query);
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ShouldNotHappenException("Failed to call the signing service: " + result + ".");
            }
            return Observable.just((Object)result);
        }
        catch (Exception e) {
            throw new ShouldNotHappenException("Failed to connect to signing service.", (Throwable)e);
        }
    }

    private SignedErpQuery extractSignedErpQuery(HttpResponse response) throws IOException {
        String payload = HttpEntityUtil.getResponsePayload((HttpResponse)response);
        String query = StringUtils.substringBeforeLast((String)payload, (String)"\n");
        String signature = StringUtils.substringAfterLast((String)payload, (String)"\n");
        if (StringUtils.isBlank((CharSequence)signature)) {
            throw new ShouldNotHappenException("Payload did not contain a signature.");
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            throw new ShouldNotHappenException("Payload did not contain a query.");
        }
        return new SignedErpQuery(query, signature);
    }
}

