/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.signing;

import com.sap.cloud.sdk.s4hana.connectivity.signing.SigningAlgorithm;
import java.beans.ConstructorProperties;

public class ErpSignature {
    public static final ErpSignature PKCS7_IN_HEADER = new ErpSignature(SigningAlgorithm.PKCS7, SignatureLocation.SIGNATURE_IN_HEADER);
    public static final ErpSignature PKCS1_IN_HEADER = new ErpSignature(SigningAlgorithm.PKCS1, SignatureLocation.SIGNATURE_IN_HEADER);
    public static final ErpSignature PKCS1_IN_PAYLOAD = new ErpSignature(SigningAlgorithm.PKCS1, SignatureLocation.SIGNATURE_IN_PAYLOAD);
    public static final ErpSignature NO_SIGNATURE = new ErpSignature(SigningAlgorithm.NONE, SignatureLocation.SIGNATURE_IN_PAYLOAD);
    private final SigningAlgorithm signingAlgorithm;
    private final SignatureLocation signatureLocation;

    public boolean useSignature() {
        return this.signingAlgorithm != SigningAlgorithm.NONE;
    }

    @ConstructorProperties(value={"signingAlgorithm", "signatureLocation"})
    public ErpSignature(SigningAlgorithm signingAlgorithm, SignatureLocation signatureLocation) {
        this.signingAlgorithm = signingAlgorithm;
        this.signatureLocation = signatureLocation;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public SignatureLocation getSignatureLocation() {
        return this.signatureLocation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErpSignature)) {
            return false;
        }
        ErpSignature other = (ErpSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SigningAlgorithm this$signingAlgorithm = this.getSigningAlgorithm();
        SigningAlgorithm other$signingAlgorithm = other.getSigningAlgorithm();
        if (this$signingAlgorithm == null ? other$signingAlgorithm != null : !this$signingAlgorithm.equals(other$signingAlgorithm)) {
            return false;
        }
        SignatureLocation this$signatureLocation = this.getSignatureLocation();
        SignatureLocation other$signatureLocation = other.getSignatureLocation();
        return !(this$signatureLocation == null ? other$signatureLocation != null : !((Object)((Object)this$signatureLocation)).equals((Object)other$signatureLocation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErpSignature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SigningAlgorithm $signingAlgorithm = this.getSigningAlgorithm();
        result = result * 59 + ($signingAlgorithm == null ? 43 : $signingAlgorithm.hashCode());
        SignatureLocation $signatureLocation = this.getSignatureLocation();
        result = result * 59 + ($signatureLocation == null ? 43 : ((Object)((Object)$signatureLocation)).hashCode());
        return result;
    }

    public String toString() {
        return "ErpSignature(signingAlgorithm=" + this.getSigningAlgorithm() + ", signatureLocation=" + (Object)((Object)this.getSignatureLocation()) + ")";
    }

    public static enum SignatureLocation {
        SIGNATURE_IN_HEADER,
        SIGNATURE_IN_PAYLOAD;

    }
}

