/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.exception;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.user.User;
import com.sap.cloud.sdk.cloudplatform.servlet.response.AccessDeniedResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import java.util.Set;
import javax.annotation.Nullable;

public class AccessDeniedException
extends QueryExecutionException {
    private static final long serialVersionUID = 8256471661877663966L;
    @Nullable
    protected User user = null;
    @Nullable
    protected Set<Authorization> missingAuthorizations = null;

    public static AccessDeniedException raiseMissingAuthorizations(@Nullable User user, @Nullable Iterable<? extends Authorization> missingAuthorizations) {
        return new AccessDeniedException(user, Sets.newHashSet(missingAuthorizations));
    }

    public AccessDeniedException(String message) {
        super(message);
    }

    public AccessDeniedException(Throwable cause) {
        super(cause);
    }

    public AccessDeniedException(String message, Throwable cause) {
        super(message, cause);
    }

    public AccessDeniedException(@Nullable User user, @Nullable Set<Authorization> missingAuthorizations) {
        super(AccessDeniedException.buildErrorMessage(user, missingAuthorizations));
        this.user = user;
        this.missingAuthorizations = missingAuthorizations;
    }

    private static String buildErrorMessage(@Nullable User user, @Nullable Iterable<? extends Authorization> missingAuthorizations) {
        if (user != null) {
            return "User " + user + " does not have the required authorizations" + (missingAuthorizations != null ? ": " + missingAuthorizations : "") + ".";
        }
        return "Missing authorizations" + (missingAuthorizations != null ? ": " + missingAuthorizations : "") + ".";
    }

    @Override
    public ResponseWithErrorCode getErrorResponse() {
        return new AccessDeniedResponse(null, null, "Access denied.");
    }

    public AccessDeniedException() {
    }

    @Nullable
    public User getUser() {
        return this.user;
    }

    @Nullable
    public Set<Authorization> getMissingAuthorizations() {
        return this.missingAuthorizations;
    }
}

