/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class SerializedQuery<QueryT extends Query<QueryT, ?>> {
    private final QueryT query;
    private final String body;
    private final List<Header> headers;
    @Nullable
    private final String relativeRequestPath;
    private final boolean isAbapInterfaceRequired;

    public Optional<String> getRelativeRequestPath() {
        return Optional.fromNullable((Object)this.relativeRequestPath);
    }

    private SerializedQuery(QueryT query, String body, @Nullable List<Header> headers, @Nullable String relativeRequestPath, boolean isAbapInterfaceRequired) {
        this.query = query;
        this.body = body;
        this.headers = headers != null ? headers : Collections.emptyList();
        this.relativeRequestPath = relativeRequestPath;
        this.isAbapInterfaceRequired = isAbapInterfaceRequired;
    }

    public static <QueryT extends Query<QueryT, ?>> SerializedQuery<QueryT> ofAbapInterfaceQuery(QueryT query, String body) {
        return new SerializedQuery<QueryT>(query, body, Collections.singletonList(new Header("Content-Type", "application/json; charset=UTF-8")), null, true);
    }

    public static <QueryT extends Query<QueryT, ?>> SerializedQuery<QueryT> of(QueryT query, String body, @Nullable List<Header> headers, @Nullable String relativeRequestPath) {
        return new SerializedQuery<QueryT>(query, body, headers, relativeRequestPath, false);
    }

    public QueryT getQuery() {
        return this.query;
    }

    public String getBody() {
        return this.body;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SerializedQuery)) {
            return false;
        }
        SerializedQuery other = (SerializedQuery)o;
        QueryT this$query = this.getQuery();
        QueryT other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        List<Header> this$headers = this.getHeaders();
        List<Header> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Optional<String> this$relativeRequestPath = this.getRelativeRequestPath();
        Optional<String> other$relativeRequestPath = other.getRelativeRequestPath();
        if (this$relativeRequestPath == null ? other$relativeRequestPath != null : !this$relativeRequestPath.equals(other$relativeRequestPath)) {
            return false;
        }
        return this.isAbapInterfaceRequired() == other.isAbapInterfaceRequired();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QueryT $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        List<Header> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Optional<String> $relativeRequestPath = this.getRelativeRequestPath();
        result = result * 59 + ($relativeRequestPath == null ? 43 : $relativeRequestPath.hashCode());
        result = result * 59 + (this.isAbapInterfaceRequired() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SerializedQuery(query=" + this.getQuery() + ", body=" + this.getBody() + ", headers=" + this.getHeaders() + ", relativeRequestPath=" + this.getRelativeRequestPath() + ", isAbapInterfaceRequired=" + this.isAbapInterfaceRequired() + ")";
    }

    public boolean isAbapInterfaceRequired() {
        return this.isAbapInterfaceRequired;
    }
}

