/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.s4hana.util.DateTimeUtil;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class QueryExecutionMeasurements {
    @Nullable
    private Long beginTotal;
    @Nullable
    private Long endTotal;
    @Nullable
    private Duration buildJsonDuration;
    @Nullable
    private Duration buildRequestDuration;
    @Nullable
    private Duration executeRequestDuration;
    @Nullable
    private Duration parseResponseDuration;
    @Nullable
    private Duration querySigningDuration;

    public void addBuildJsonDuration(Duration duration) {
        this.buildJsonDuration = this.buildJsonDuration == null ? duration : this.buildJsonDuration.plus((ReadableDuration)duration);
    }

    public void addBuildRequestDuration(Duration duration) {
        this.buildRequestDuration = this.buildRequestDuration == null ? duration : this.buildRequestDuration.plus((ReadableDuration)duration);
    }

    public void addExecuteRequestDuration(Duration duration) {
        this.executeRequestDuration = this.executeRequestDuration == null ? duration : this.executeRequestDuration.plus((ReadableDuration)duration);
    }

    public void addParseResponseDuration(Duration duration) {
        this.parseResponseDuration = this.parseResponseDuration == null ? duration : this.parseResponseDuration.plus((ReadableDuration)duration);
    }

    public void addQuerySigningDuration(Duration duration) {
        this.querySigningDuration = this.querySigningDuration == null ? duration : this.querySigningDuration.plus((ReadableDuration)duration);
    }

    public void resetMeasurements() {
        this.beginTotal = null;
        this.endTotal = null;
        this.buildJsonDuration = null;
        this.buildRequestDuration = null;
        this.executeRequestDuration = null;
        this.querySigningDuration = null;
        this.parseResponseDuration = null;
    }

    public String getMeasurementsString() {
        Duration total = this.beginTotal != null && this.endTotal != null ? DateTimeUtil.newDuration((long)this.beginTotal, (long)this.endTotal) : null;
        return "total: " + DateTimeUtil.formatDuration(total) + ", build JSON: " + DateTimeUtil.formatDuration((Duration)this.buildJsonDuration) + ", build payload: " + DateTimeUtil.formatDuration((Duration)this.buildRequestDuration) + ", sign query: " + DateTimeUtil.formatDuration((Duration)this.querySigningDuration) + ", execute request: " + DateTimeUtil.formatDuration((Duration)this.executeRequestDuration) + ", parse response: " + DateTimeUtil.formatDuration((Duration)this.parseResponseDuration);
    }

    @Nullable
    public Long getBeginTotal() {
        return this.beginTotal;
    }

    @Nullable
    public Long getEndTotal() {
        return this.endTotal;
    }

    @Nullable
    public Duration getBuildJsonDuration() {
        return this.buildJsonDuration;
    }

    @Nullable
    public Duration getBuildRequestDuration() {
        return this.buildRequestDuration;
    }

    @Nullable
    public Duration getExecuteRequestDuration() {
        return this.executeRequestDuration;
    }

    @Nullable
    public Duration getParseResponseDuration() {
        return this.parseResponseDuration;
    }

    @Nullable
    public Duration getQuerySigningDuration() {
        return this.querySigningDuration;
    }

    public void setBeginTotal(@Nullable Long beginTotal) {
        this.beginTotal = beginTotal;
    }

    public void setEndTotal(@Nullable Long endTotal) {
        this.endTotal = endTotal;
    }
}

