/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import com.sap.cloud.sdk.s4hana.connectivity.ErpCommand;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.connectivity.ErpSystemInfo;
import com.sap.cloud.sdk.s4hana.connectivity.InfoQuery;
import com.sap.cloud.sdk.s4hana.connectivity.InfoQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.SoftwareComponent;
import com.sap.cloud.sdk.s4hana.connectivity.SoftwareComponentVersion;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpSignature;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

class ErpSystemInfoCommand
extends ErpCommand<ErpSystemInfo> {
    private static final Logger logger = CloudLoggerFactory.getLogger(ErpSystemInfoCommand.class);
    private final ErpEdition erpEdition;
    private final ErpSignature erpSignature;

    ErpSystemInfoCommand(ErpConfigContext erpConfigContext, ErpEdition erpEdition, ErpSignature erpSignature) {
        super(HystrixUtil.getDefaultErpCommandSetter(ErpSystemInfoCommand.class).andCommandPropertiesDefaults(HystrixUtil.getDefaultErpCommandProperties().withExecutionTimeoutInMilliseconds(5000).withCircuitBreakerEnabled(false).withFallbackEnabled(false)), erpConfigContext);
        this.erpEdition = erpEdition;
        this.erpSignature = erpSignature;
    }

    protected ErpSystemInfo run() throws QuerySerializationException, QueryExecutionException {
        return this.sendInfoQuery(this.erpEdition, this.erpSignature);
    }

    private ErpSystemInfo sendInfoQuery(ErpEdition erpEdition, ErpSignature erpSignature) throws QuerySerializationException, QueryExecutionException {
        SapClient sapClient;
        InfoQueryResult queryResult = new InfoQuery(erpEdition, erpSignature).execute(this.getErpEndpoint());
        if (StringUtils.isBlank((CharSequence)queryResult.getSapClient())) {
            sapClient = this.getConfigContext().getSapClient();
            if (logger.isWarnEnabled()) {
                logger.warn("No " + SapClient.class.getSimpleName() + " returned by ERP, falling back to configured " + SapClient.class.getSimpleName() + " " + sapClient + ".");
            }
        } else {
            sapClient = new SapClient(queryResult.getSapClient());
        }
        ErpSystemInfo erpSystemInfo = new ErpSystemInfo(queryResult.getInterfaceVersion(), erpEdition, queryResult.getErpRelease(), queryResult.getDatabaseSystem(), queryResult.getDatabaseSchema(), erpSignature, sapClient, queryResult.getSystemTimeZone(), queryResult.getUserTimeZone(), queryResult.getUserName());
        this.addSoftwareComponentVersions(erpSystemInfo, queryResult);
        return erpSystemInfo;
    }

    private void addSoftwareComponentVersions(ErpSystemInfo erpSystemInfo, InfoQueryResult queryResult) {
        List<InfoQueryResult.SoftwareComponentVersion> softwareComponentVersions = queryResult.getSoftwareComponentVersions();
        if (softwareComponentVersions != null) {
            for (InfoQueryResult.SoftwareComponentVersion softwareComponentVersion : softwareComponentVersions) {
                SoftwareComponent component = new SoftwareComponent(softwareComponentVersion.getSoftwareComponent());
                String release = softwareComponentVersion.getRelease();
                erpSystemInfo.getSoftwareComponentVersions().put(component, new SoftwareComponentVersion(component, release));
            }
        }
    }
}

