/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.s4hana.connectivity.DatabaseSystem;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.connectivity.ErpRelease;
import com.sap.cloud.sdk.s4hana.connectivity.SoftwareComponent;
import com.sap.cloud.sdk.s4hana.connectivity.SoftwareComponentVersion;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpSignature;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;

public final class ErpSystemInfo {
    public static final int MIN_SUPPORTED_INTERFACE_VERSION = 4;
    public static final int MAX_SUPPORTED_INTERFACE_VERSION = 14;
    private final int interfaceVersion;
    private final ErpEdition erpEdition;
    @Nullable
    private final ErpRelease erpRelease;
    @Nullable
    private final DatabaseSystem databaseSystem;
    @Nullable
    private final String databaseSchema;
    private final ErpSignature erpSignature;
    private final SapClient sapClient;
    @Nullable
    private final String systemTimeZone;
    @Nullable
    private final String userTimeZone;
    @Nullable
    private final String userName;
    public Map<SoftwareComponent, SoftwareComponentVersion> softwareComponentVersions = Maps.newHashMap();

    public Optional<ErpRelease> getErpRelease() {
        return Optional.fromNullable((Object)((Object)this.erpRelease));
    }

    public Optional<DatabaseSystem> getDatabaseSystem() {
        return Optional.fromNullable((Object)((Object)this.databaseSystem));
    }

    public Optional<String> getDatabaseSchema() {
        return Optional.fromNullable((Object)this.databaseSchema);
    }

    public Optional<String> getSystemTimeZone() {
        return Optional.fromNullable((Object)this.systemTimeZone);
    }

    public Optional<String> getUserTimeZone() {
        return Optional.fromNullable((Object)this.userTimeZone);
    }

    public Optional<String> getUserName() {
        return Optional.fromNullable((Object)this.userName);
    }

    public ErpSystemInfo(int interfaceVersion, @NonNull ErpEdition erpEdition, @Nullable ErpRelease erpRelease, @Nullable DatabaseSystem databaseSystem, @Nullable String databaseSchema, @NonNull ErpSignature erpSignature, @NonNull SapClient sapClient, @Nullable String systemTimeZone, @Nullable String userTimeZone, @Nullable String userName) {
        if (erpEdition == null) {
            throw new NullPointerException("erpEdition");
        }
        if (erpSignature == null) {
            throw new NullPointerException("erpSignature");
        }
        if (sapClient == null) {
            throw new NullPointerException("sapClient");
        }
        this.interfaceVersion = interfaceVersion;
        this.erpEdition = erpEdition;
        this.erpRelease = erpRelease;
        this.databaseSystem = databaseSystem;
        this.databaseSchema = databaseSchema;
        this.erpSignature = erpSignature;
        this.sapClient = sapClient;
        this.systemTimeZone = systemTimeZone;
        this.userTimeZone = userTimeZone;
        this.userName = userName;
    }

    public Map<SoftwareComponent, SoftwareComponentVersion> getSoftwareComponentVersions() {
        return this.softwareComponentVersions;
    }

    public void setSoftwareComponentVersions(Map<SoftwareComponent, SoftwareComponentVersion> softwareComponentVersions) {
        this.softwareComponentVersions = softwareComponentVersions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErpSystemInfo)) {
            return false;
        }
        ErpSystemInfo other = (ErpSystemInfo)o;
        if (this.getInterfaceVersion() != other.getInterfaceVersion()) {
            return false;
        }
        ErpEdition this$erpEdition = this.getErpEdition();
        ErpEdition other$erpEdition = other.getErpEdition();
        if (this$erpEdition == null ? other$erpEdition != null : !((Object)((Object)this$erpEdition)).equals((Object)other$erpEdition)) {
            return false;
        }
        Optional<ErpRelease> this$erpRelease = this.getErpRelease();
        Optional<ErpRelease> other$erpRelease = other.getErpRelease();
        if (this$erpRelease == null ? other$erpRelease != null : !this$erpRelease.equals(other$erpRelease)) {
            return false;
        }
        Optional<DatabaseSystem> this$databaseSystem = this.getDatabaseSystem();
        Optional<DatabaseSystem> other$databaseSystem = other.getDatabaseSystem();
        if (this$databaseSystem == null ? other$databaseSystem != null : !this$databaseSystem.equals(other$databaseSystem)) {
            return false;
        }
        Optional<String> this$databaseSchema = this.getDatabaseSchema();
        Optional<String> other$databaseSchema = other.getDatabaseSchema();
        if (this$databaseSchema == null ? other$databaseSchema != null : !this$databaseSchema.equals(other$databaseSchema)) {
            return false;
        }
        ErpSignature this$erpSignature = this.getErpSignature();
        ErpSignature other$erpSignature = other.getErpSignature();
        if (this$erpSignature == null ? other$erpSignature != null : !((Object)this$erpSignature).equals(other$erpSignature)) {
            return false;
        }
        SapClient this$sapClient = this.getSapClient();
        SapClient other$sapClient = other.getSapClient();
        if (this$sapClient == null ? other$sapClient != null : !this$sapClient.equals(other$sapClient)) {
            return false;
        }
        Optional<String> this$systemTimeZone = this.getSystemTimeZone();
        Optional<String> other$systemTimeZone = other.getSystemTimeZone();
        if (this$systemTimeZone == null ? other$systemTimeZone != null : !this$systemTimeZone.equals(other$systemTimeZone)) {
            return false;
        }
        Optional<String> this$userTimeZone = this.getUserTimeZone();
        Optional<String> other$userTimeZone = other.getUserTimeZone();
        if (this$userTimeZone == null ? other$userTimeZone != null : !this$userTimeZone.equals(other$userTimeZone)) {
            return false;
        }
        Optional<String> this$userName = this.getUserName();
        Optional<String> other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Map<SoftwareComponent, SoftwareComponentVersion> this$softwareComponentVersions = this.getSoftwareComponentVersions();
        Map<SoftwareComponent, SoftwareComponentVersion> other$softwareComponentVersions = other.getSoftwareComponentVersions();
        return !(this$softwareComponentVersions == null ? other$softwareComponentVersions != null : !((Object)this$softwareComponentVersions).equals(other$softwareComponentVersions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInterfaceVersion();
        ErpEdition $erpEdition = this.getErpEdition();
        result = result * 59 + ($erpEdition == null ? 43 : ((Object)((Object)$erpEdition)).hashCode());
        Optional<ErpRelease> $erpRelease = this.getErpRelease();
        result = result * 59 + ($erpRelease == null ? 43 : $erpRelease.hashCode());
        Optional<DatabaseSystem> $databaseSystem = this.getDatabaseSystem();
        result = result * 59 + ($databaseSystem == null ? 43 : $databaseSystem.hashCode());
        Optional<String> $databaseSchema = this.getDatabaseSchema();
        result = result * 59 + ($databaseSchema == null ? 43 : $databaseSchema.hashCode());
        ErpSignature $erpSignature = this.getErpSignature();
        result = result * 59 + ($erpSignature == null ? 43 : ((Object)$erpSignature).hashCode());
        SapClient $sapClient = this.getSapClient();
        result = result * 59 + ($sapClient == null ? 43 : $sapClient.hashCode());
        Optional<String> $systemTimeZone = this.getSystemTimeZone();
        result = result * 59 + ($systemTimeZone == null ? 43 : $systemTimeZone.hashCode());
        Optional<String> $userTimeZone = this.getUserTimeZone();
        result = result * 59 + ($userTimeZone == null ? 43 : $userTimeZone.hashCode());
        Optional<String> $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Map<SoftwareComponent, SoftwareComponentVersion> $softwareComponentVersions = this.getSoftwareComponentVersions();
        result = result * 59 + ($softwareComponentVersions == null ? 43 : ((Object)$softwareComponentVersions).hashCode());
        return result;
    }

    public String toString() {
        return "ErpSystemInfo(interfaceVersion=" + this.getInterfaceVersion() + ", erpEdition=" + (Object)((Object)this.getErpEdition()) + ", erpRelease=" + this.getErpRelease() + ", databaseSystem=" + this.getDatabaseSystem() + ", databaseSchema=" + this.getDatabaseSchema() + ", erpSignature=" + this.getErpSignature() + ", sapClient=" + this.getSapClient() + ", systemTimeZone=" + this.getSystemTimeZone() + ", userTimeZone=" + this.getUserTimeZone() + ", userName=" + this.getUserName() + ", softwareComponentVersions=" + this.getSoftwareComponentVersions() + ")";
    }

    public int getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public ErpEdition getErpEdition() {
        return this.erpEdition;
    }

    public ErpSignature getErpSignature() {
        return this.erpSignature;
    }

    public SapClient getSapClient() {
        return this.sapClient;
    }
}

