/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.collect.Sets;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ErpServiceUriBuilder {
    private static final Logger logger = CloudLoggerFactory.getLogger(ErpServiceUriBuilder.class);
    protected static final String ERP_ENDPOINT_CLOUD = "/sap/bc/rest/sap/fi_map/";
    protected static final String ERP_ENDPOINT_ON_PREMISE = "/sap/hcpint/map/bm/";
    private static final Set<String> testSystemPaths = Sets.newHashSet();

    public static synchronized void registerTestSystem(URI uri) {
        testSystemPaths.add(ErpServiceUriBuilder.encloseSlashesIfMissing(uri.getPath()));
    }

    private static String prependSlashIfMissing(String path) {
        return StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private static String appendSlashIfMissing(String path) {
        return StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    private static String encloseSlashesIfMissing(String path) {
        return ErpServiceUriBuilder.prependSlashIfMissing(ErpServiceUriBuilder.appendSlashIfMissing(path));
    }

    protected String removeErpEndpointPaths(URI baseUri) {
        String path = ErpServiceUriBuilder.encloseSlashesIfMissing(baseUri.getPath());
        path = StringUtils.remove((String)path, (String)ERP_ENDPOINT_CLOUD);
        path = StringUtils.remove((String)path, (String)ERP_ENDPOINT_ON_PREMISE);
        for (String testSystemPath : testSystemPaths) {
            path = StringUtils.remove((String)path, (String)testSystemPath);
        }
        return ErpServiceUriBuilder.encloseSlashesIfMissing(path);
    }

    public URI build(URI baseUri, ErpEdition erpEdition) {
        String erpEndpoint;
        boolean useOriginalUri;
        if (logger.isDebugEnabled()) {
            logger.debug("Building ERP service URI for " + baseUri + ".");
        }
        String path = ErpServiceUriBuilder.encloseSlashesIfMissing(baseUri.getPath());
        if (logger.isDebugEnabled()) {
            logger.debug("Path: " + path + ".");
        }
        boolean isErpEndpointUri = path.contains(ERP_ENDPOINT_CLOUD) || path.contains(ERP_ENDPOINT_ON_PREMISE);
        boolean bl = useOriginalUri = !path.isEmpty() && !path.equals("/") && !isErpEndpointUri;
        if (useOriginalUri) {
            if (logger.isDebugEnabled()) {
                logger.debug("Returning original URI " + baseUri + ".");
            }
            return baseUri;
        }
        switch (erpEdition) {
            case CLOUD: {
                erpEndpoint = ERP_ENDPOINT_CLOUD;
                break;
            }
            default: {
                erpEndpoint = ERP_ENDPOINT_ON_PREMISE;
            }
        }
        path = StringUtils.removeEnd((String)this.removeErpEndpointPaths(baseUri), (String)"/") + erpEndpoint;
        if (logger.isDebugEnabled()) {
            logger.debug("Using ERP-specific path: " + path + ".");
        }
        try {
            return new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), path, baseUri.getQuery(), baseUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to build ERP service URI.", e);
        }
    }

    public URI build(URI baseUri, String relativePath) {
        try {
            String path = StringUtils.removeEnd((String)this.removeErpEndpointPaths(baseUri), (String)"/") + ErpServiceUriBuilder.prependSlashIfMissing(relativePath);
            return new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), baseUri.getPort(), path, baseUri.getQuery(), baseUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to build ERP service URI.", e);
        }
    }

    public URI build(URI baseUri) {
        return this.build(baseUri, "");
    }
}

