/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.cache.CacheManager;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.AbstractErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.connectivity.ErpSystemInfo;
import com.sap.cloud.sdk.s4hana.connectivity.ErpSystemInfoCommand;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpSignature;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;

class ErpInfoEndpoint
extends AbstractErpEndpoint {
    private static final Logger logger = CloudLoggerFactory.getLogger(ErpInfoEndpoint.class);
    private static final Cache<CacheKey, ErpSystemInfo> cache = CacheManager.register((Cache)CacheBuilder.newBuilder().concurrencyLevel(10).maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build());
    private static final List<ErpSignature> signingStrategies = ImmutableList.of((Object)ErpSignature.PKCS7_IN_HEADER, (Object)ErpSignature.PKCS1_IN_HEADER, (Object)ErpSignature.PKCS1_IN_PAYLOAD, (Object)ErpSignature.NO_SIGNATURE);

    static ErpEdition getErpEdition(Destination destination) {
        return ProxyType.ON_PREMISE == destination.getProxyType() ? ErpEdition.ON_PREMISE : ErpEdition.CLOUD;
    }

    ErpInfoEndpoint() {
        this(null);
    }

    ErpInfoEndpoint(@Nullable ErpConfigContext erpConfigContext) {
        super(erpConfigContext);
    }

    private CacheKey getCacheKey() {
        return CacheKey.newUserIsolatedKey().append((Object)this.getConfigContext(), new Object[0]);
    }

    private ErpSystemInfo executeCommand(boolean useCache, final ErpEdition erpEdition, final ErpSignature erpSignature) throws QueryExecutionException {
        if (useCache) {
            try {
                return (ErpSystemInfo)cache.get((Object)this.getCacheKey(), (Callable)new Callable<ErpSystemInfo>(){

                    @Override
                    public ErpSystemInfo call() {
                        return (ErpSystemInfo)new ErpSystemInfoCommand(ErpInfoEndpoint.this.erpConfigContext, erpEdition, erpSignature).execute();
                    }
                });
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                throw new QueryExecutionException("Failed to retrieve " + ErpSystemInfo.class.getSimpleName() + ".", e);
            }
        }
        try {
            return (ErpSystemInfo)new ErpSystemInfoCommand(this.erpConfigContext, erpEdition, erpSignature).execute();
        }
        catch (HystrixBadRequestException | HystrixRuntimeException | IllegalStateException e) {
            throw new QueryExecutionException("Failed to run Hystrix command.", e);
        }
    }

    @Nullable
    private ErpSignature parseSignature(@Nullable String str) {
        ErpSignature erpSignature = null;
        if (str != null) {
            switch (str) {
                case "pkcs7-header": {
                    erpSignature = ErpSignature.PKCS7_IN_HEADER;
                    break;
                }
                case "pkcs1-header": {
                    erpSignature = ErpSignature.PKCS1_IN_HEADER;
                    break;
                }
                case "pkcs1-payload": {
                    erpSignature = ErpSignature.PKCS1_IN_PAYLOAD;
                    break;
                }
                case "none": {
                    erpSignature = ErpSignature.NO_SIGNATURE;
                    break;
                }
            }
        }
        return erpSignature;
    }

    private ErpSystemInfo getErpSystemInfo(boolean useCache) throws QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        Destination destination = DestinationAccessor.getDestination((String)this.getDestinationName());
        ErpEdition erpEdition = ErpInfoEndpoint.getErpEdition(destination);
        String propertySignature = (String)destination.getPropertiesByName().get("erp-signature");
        ErpSignature parsedSignature = this.parseSignature(propertySignature);
        if (parsedSignature != null) {
            return this.executeCommand(useCache, erpEdition, parsedSignature);
        }
        Iterator<ErpSignature> strategyIt = signingStrategies.iterator();
        while (strategyIt.hasNext()) {
            ErpSignature erpSignature = strategyIt.next();
            try {
                return this.executeCommand(useCache, erpEdition, erpSignature);
            }
            catch (QueryExecutionException e) {
                if (!strategyIt.hasNext()) {
                    throw e;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Failed to retrieve ERP system info with strategy " + erpSignature + ". Retrying with next strategy.", (Throwable)e);
            }
        }
        throw new QueryExecutionException("Unable to retrieve ERP system info: all signing strategies failed.");
    }

    ErpSystemInfo getErpSystemInfo() throws QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        return this.getErpSystemInfo(true);
    }

    ErpSystemInfo getErpSystemInfoIgnoringCache() throws QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        return this.getErpSystemInfo(false);
    }

    static Cache<CacheKey, ErpSystemInfo> getCache() {
        return cache;
    }

    static List<ErpSignature> getSigningStrategies() {
        return signingStrategies;
    }
}

