/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.monitoring.JmxMonitor;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpointMonitorMXBean;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;
import org.apache.http.Header;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

@WebListener
public class ErpEndpointMonitor
extends JmxMonitor
implements ErpEndpointMonitorMXBean {
    private static final ErpEndpointMonitor instance = new ErpEndpointMonitor();
    private final Map<String, AtomicLong> erpQueryCounts = Maps.newConcurrentMap();
    private final BlockingQueue<LongRunningRequestInfo> longRunningRequests = new PriorityBlockingQueue(20, Collections.reverseOrder());
    private final BlockingQueue<LongRunningQuerySigningInfo> longRunningQuerySigning = new PriorityBlockingQueue(20, Collections.reverseOrder());
    private final BlockingQueue<DateTime> longRunningRequestTimes1h = new PriorityBlockingQueue<DateTime>();

    public <QueryT extends Query<QueryT, ?>> void incrementErpQueryCount(QueryT query) {
        String name = query.getClass().getSimpleName();
        AtomicLong queryCount = this.erpQueryCounts.get(name);
        if (queryCount == null) {
            queryCount = new AtomicLong();
            this.erpQueryCounts.put(name, queryCount);
        }
        queryCount.incrementAndGet();
    }

    @Override
    public Map<String, Long> getErpQueryCounts() {
        TreeMap counts = Maps.newTreeMap();
        for (Map.Entry<String, AtomicLong> stringAtomicLongEntry : this.erpQueryCounts.entrySet()) {
            counts.put(stringAtomicLongEntry.getKey(), stringAtomicLongEntry.getValue().get());
        }
        return counts;
    }

    @Override
    public int getLongRunningRequestsLast1h() {
        return this.longRunningRequestTimes1h.size();
    }

    @Override
    public List<String> getLongRunningQuerySigning() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.longRunningQuerySigning.size());
        for (LongRunningQuerySigningInfo longRunningQuerySigningInfo : this.longRunningQuerySigning) {
            result.add(longRunningQuerySigningInfo.toString());
        }
        return result;
    }

    @Override
    public List<String> getLongRunningRequests() {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.longRunningRequests.size());
        for (LongRunningRequestInfo longRunningRequestInfo : this.longRunningRequests) {
            result.add(longRunningRequestInfo.toString());
        }
        return result;
    }

    public void trackLongRunningRequest(Duration duration, Duration querySigningDuration, String requestLine, String requestPayload, String responseLine, Header[] allHeaders, int responseLength) {
        DateTime now = DateTime.now();
        LongRunningRequestInfo longRunningRequestInfo = new LongRunningRequestInfo(now, duration, querySigningDuration, requestLine, requestPayload, responseLine, Arrays.toString(allHeaders), responseLength);
        this.longRunningRequests.add(longRunningRequestInfo);
        this.addNewAndDropOldEntries(now);
    }

    public void trackLongRunningQuerySigning(Duration duration, String querySignerName, String query) {
        this.longRunningQuerySigning.add(new LongRunningQuerySigningInfo(DateTime.now(), duration, querySignerName, query));
    }

    void addNewAndDropOldEntries(DateTime toAdd) {
        DateTime oldest;
        DateTime threshold = toAdd.minus((ReadableDuration)Duration.standardHours((long)1L));
        while ((oldest = (DateTime)this.longRunningRequestTimes1h.peek()) != null && oldest.compareTo((ReadableInstant)threshold) < 0) {
            if (oldest.compareTo((ReadableInstant)threshold) >= 0) continue;
            this.longRunningRequestTimes1h.poll();
        }
        this.longRunningRequestTimes1h.add(toAdd);
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        instance.registerJmxBean();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        instance.unregisterJmxBean();
    }

    public static ErpEndpointMonitor getInstance() {
        return instance;
    }

    private static class LongRunningQuerySigningInfo
    implements Comparable<LongRunningQuerySigningInfo> {
        private final DateTime timeStamp;
        private final Duration duration;
        private final String querySignerName;
        private final String query;

        @Override
        public int compareTo(LongRunningQuerySigningInfo o) {
            return this.getDuration().compareTo((ReadableDuration)o.getDuration());
        }

        @ConstructorProperties(value={"timeStamp", "duration", "querySignerName", "query"})
        public LongRunningQuerySigningInfo(DateTime timeStamp, Duration duration, String querySignerName, String query) {
            this.timeStamp = timeStamp;
            this.duration = duration;
            this.querySignerName = querySignerName;
            this.query = query;
        }

        public DateTime getTimeStamp() {
            return this.timeStamp;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public String getQuerySignerName() {
            return this.querySignerName;
        }

        public String getQuery() {
            return this.query;
        }

        public String toString() {
            return "ErpEndpointMonitor.LongRunningQuerySigningInfo(timeStamp=" + this.getTimeStamp() + ", duration=" + this.getDuration() + ", querySignerName=" + this.getQuerySignerName() + ", query=" + this.getQuery() + ")";
        }
    }

    private static class LongRunningRequestInfo
    implements Comparable<LongRunningRequestInfo> {
        private final DateTime timeStamp;
        private final Duration duration;
        private final Duration querySigningDuration;
        private final String requestLine;
        private final String requestPayload;
        private final String responseLine;
        private final String headers;
        private final int responseLength;

        @Override
        public int compareTo(LongRunningRequestInfo o) {
            return this.getDuration().compareTo((ReadableDuration)o.getDuration());
        }

        @ConstructorProperties(value={"timeStamp", "duration", "querySigningDuration", "requestLine", "requestPayload", "responseLine", "headers", "responseLength"})
        public LongRunningRequestInfo(DateTime timeStamp, Duration duration, Duration querySigningDuration, String requestLine, String requestPayload, String responseLine, String headers, int responseLength) {
            this.timeStamp = timeStamp;
            this.duration = duration;
            this.querySigningDuration = querySigningDuration;
            this.requestLine = requestLine;
            this.requestPayload = requestPayload;
            this.responseLine = responseLine;
            this.headers = headers;
            this.responseLength = responseLength;
        }

        public DateTime getTimeStamp() {
            return this.timeStamp;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public Duration getQuerySigningDuration() {
            return this.querySigningDuration;
        }

        public String getRequestLine() {
            return this.requestLine;
        }

        public String getRequestPayload() {
            return this.requestPayload;
        }

        public String getResponseLine() {
            return this.responseLine;
        }

        public String getHeaders() {
            return this.headers;
        }

        public int getResponseLength() {
            return this.responseLength;
        }

        public String toString() {
            return "ErpEndpointMonitor.LongRunningRequestInfo(timeStamp=" + this.getTimeStamp() + ", duration=" + this.getDuration() + ", querySigningDuration=" + this.getQuerySigningDuration() + ", requestLine=" + this.getRequestLine() + ", requestPayload=" + this.getRequestPayload() + ", responseLine=" + this.getResponseLine() + ", headers=" + this.getHeaders() + ", responseLength=" + this.getResponseLength() + ")";
        }
    }
}

