/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.sap.cloud.sdk.cloudplatform.auditlog.AccessedAttribute;
import com.sap.cloud.sdk.cloudplatform.auditlog.AuditLogger;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpEntityUtil;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.s4hana.connectivity.AbstractErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEdition;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpointMonitor;
import com.sap.cloud.sdk.s4hana.connectivity.ErpInfoEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.ErpServiceUriBuilder;
import com.sap.cloud.sdk.s4hana.connectivity.ErpSystemInfo;
import com.sap.cloud.sdk.s4hana.connectivity.InfoQuery;
import com.sap.cloud.sdk.s4hana.connectivity.Query;
import com.sap.cloud.sdk.s4hana.connectivity.QueryExecutionMeasurements;
import com.sap.cloud.sdk.s4hana.connectivity.QueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.QuerySerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQuery;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedQueryResult;
import com.sap.cloud.sdk.s4hana.connectivity.exception.AbapInterfaceNotSupportedException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.AccessDeniedException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.CloudConnectorException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.LogonErrorException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.MissingConfigException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QueryExecutionException;
import com.sap.cloud.sdk.s4hana.connectivity.exception.QuerySerializationException;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpQuerySigner;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpQuerySignerFactory;
import com.sap.cloud.sdk.s4hana.connectivity.signing.ErpSignature;
import com.sap.cloud.sdk.s4hana.connectivity.signing.NoSigningErpQuerySigner;
import com.sap.cloud.sdk.s4hana.connectivity.signing.SignedErpQuery;
import com.sap.cloud.sdk.s4hana.connectivity.signing.StrategyBasedErpQuerySignerFactory;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import com.sap.cloud.sdk.s4hana.util.DateTimeUtil;
import com.sap.cloud.sdk.s4hana.util.XmlPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.xml.sax.SAXException;

public final class ErpEndpoint
extends AbstractErpEndpoint {
    private static final Logger logger = CloudLoggerFactory.getLogger(ErpEndpoint.class);
    @Nullable
    private ErpSystemInfo erpSystemInfoCache;
    private static final Duration LONG_RUNNING_REQUEST_THRESHOLD = Duration.millis((long)2000L);
    private static final Duration LONG_RUNNING_QUERY_SIGNING_THRESHOLD = Duration.millis((long)100L);
    private static final int MAX_UNCOMPRESSED_PAYLOAD_LENGTH = 1400;
    private final QueryExecutionMeasurements measurements = new QueryExecutionMeasurements();
    private final ErpQuerySignerFactory querySignerFactory;
    private static final Pattern HTML_TAGS_PATTERN = Pattern.compile("<meta(.+?)>|<style(.+?)>(.+?)</style>", 2);

    public ErpEndpoint() {
        this(null);
    }

    public ErpEndpoint(@Nullable ErpConfigContext erpConfigContext) {
        this(erpConfigContext, null);
    }

    public ErpEndpoint(@Nullable ErpConfigContext erpConfigContext, @Nullable ErpQuerySignerFactory querySignerFactory) {
        super(erpConfigContext);
        this.querySignerFactory = querySignerFactory == null ? new StrategyBasedErpQuerySignerFactory() : querySignerFactory;
    }

    public void assertMinInterfaceVersion(int minVersionRequired) throws QueryExecutionException {
        if (this.getErpSystemInfo().getInterfaceVersion() < minVersionRequired) {
            throw new AbapInterfaceNotSupportedException(minVersionRequired);
        }
    }

    public ErpSystemInfo getErpSystemInfo() throws QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        if (this.erpSystemInfoCache == null) {
            this.erpSystemInfoCache = new ErpInfoEndpoint(this.erpConfigContext).getErpSystemInfo();
        }
        return this.erpSystemInfoCache;
    }

    public Optional<ErpSystemInfo> getErpSystemInfoIfPresent() {
        if (this.getConfigContext() == null) {
            return Optional.absent();
        }
        try {
            return Optional.of((Object)this.getErpSystemInfo());
        }
        catch (DestinationAccessException | DestinationNotFoundException | QueryExecutionException e) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to retrieve ERP system info.", e);
            }
            return Optional.absent();
        }
    }

    public ErpSystemInfo getErpSystemInfoIgnoringCache() throws QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        return new ErpInfoEndpoint(this.erpConfigContext).getErpSystemInfoIgnoringCache();
    }

    public <QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends QueryResult<QueryT, QueryResultT>, QuerySerializerT extends QuerySerializer<QueryT, QueryResultT>> QueryResultT executeQuery(QueryT query, QuerySerializerT querySerializer) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        ErpEndpointMonitor.getInstance().incrementErpQueryCount(query);
        this.measurements.resetMeasurements();
        this.measurements.setBeginTotal(System.nanoTime());
        long beginBuildReq = System.nanoTime();
        SerializedQuery<QueryT> serializedQuery = querySerializer.serialize(query);
        long endBuildReq = System.nanoTime();
        this.measurements.addBuildJsonDuration(DateTimeUtil.newDuration((long)beginBuildReq, (long)endBuildReq));
        SerializedQueryResult<QueryT> serializedQueryResult = this.executeQuery(serializedQuery);
        long beginParseResp = System.nanoTime();
        QueryResultT result = querySerializer.deserialize(serializedQueryResult);
        long endParseResp = System.nanoTime();
        this.measurements.addParseResponseDuration(DateTimeUtil.newDuration((long)beginParseResp, (long)endParseResp));
        this.measurements.setEndTotal(System.nanoTime());
        return result;
    }

    private void assertValidConfigContext() throws MissingConfigException {
        if (this.erpConfigContext.getDestinationName() == null) {
            throw new MissingConfigException("No destination name configured (is null). Please provide a destination name in " + ErpConfigContext.class.getSimpleName() + ".");
        }
        if (this.erpConfigContext.getSapClient() == null) {
            throw new MissingConfigException("No " + SapClient.class.getSimpleName() + " configured (is null). " + "Please set a " + SapClient.class.getSimpleName() + " in property \"" + "sap-client" + "\" of destination \"" + this.erpConfigContext.getDestinationName() + "\" or provide the " + SapClient.class.getSimpleName() + " as an explicit argument of " + ErpConfigContext.class.getSimpleName() + ".");
        }
        if (this.erpConfigContext.getLocale() == null) {
            throw new MissingConfigException("No " + Locale.class.getSimpleName() + " configured (is null). " + "Please set a " + Locale.class.getSimpleName() + " in property \"" + "sap-language" + "\" of destination \"" + this.erpConfigContext.getDestinationName() + "\" or provide the " + Locale.class.getSimpleName() + " as an explicit argument of " + ErpConfigContext.class.getSimpleName() + ".");
        }
    }

    private <QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends QueryResult<QueryT, QueryResultT>> String getQueryExecutionFailedMessage(QueryT query) {
        return query.getClass().getSimpleName() + " " + query.getConstructedByMethod() + " failed [" + this.measurements.getMeasurementsString() + "]";
    }

    public <QueryT extends Query<QueryT, QueryResultT>, QueryResultT extends QueryResult<QueryT, QueryResultT>> SerializedQueryResult<QueryT> executeQuery(SerializedQuery<QueryT> serializedQuery) throws QuerySerializationException, QueryExecutionException {
        String responseBody;
        String readAccessData;
        QueryT query = serializedQuery.getQuery();
        if (logger.isDebugEnabled()) {
            logger.debug("Executing " + query.getClass().getSimpleName() + " constructed by: " + ((Query)query).getConstructedByMethod() + ".");
        }
        if ((readAccessData = ((Query)query).getReadAccessData()) != null) {
            AuditLogger.logDataReadAttempt((String)query.getClass().getSimpleName(), null, (Iterable)Lists.newArrayList((Object[])new AccessedAttribute[]{new AccessedAttribute(readAccessData, AccessedAttribute.Operation.READ)}), (String)"Execute ERP query");
        }
        try {
            responseBody = this.sendPayload(serializedQuery);
        }
        catch (QueryExecutionException | QuerySerializationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(this.getQueryExecutionFailedMessage(query), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            String message = this.getQueryExecutionFailedMessage(query);
            throw new QueryExecutionException(message, e);
        }
        long beginParseResp = System.nanoTime();
        SerializedQueryResult<QueryT> serializedQueryResult = new SerializedQueryResult<QueryT>(query, responseBody);
        long endParseResp = System.nanoTime();
        this.measurements.addParseResponseDuration(DateTimeUtil.newDuration((long)beginParseResp, (long)endParseResp));
        return serializedQueryResult;
    }

    private ByteArrayEntity compressPayload(String payload) throws QuerySerializationException {
        ByteArrayEntity entity;
        byte[] content = new byte[]{};
        try {
            content = payload.getBytes(Charsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new QuerySerializationException("Failed to to convert payload from String to UTF8 byte[].", e);
        }
        if (content.length > 1400) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(outputStream);){
                gzipOutputStream.write(content);
            }
            catch (IOException e) {
                throw new QuerySerializationException("Failed to write to GZIP-compressed stream.", e);
            }
            entity = new ByteArrayEntity(outputStream.toByteArray());
            entity.setContentEncoding("gzip");
            if (logger.isInfoEnabled()) {
                logger.info("Compressed length of ERP query body: " + entity.getContentLength() + " bytes, was " + content.length + " bytes.");
            }
        } else {
            entity = new ByteArrayEntity(content);
            entity.setContentEncoding(Charsets.UTF_8.toString());
            if (logger.isInfoEnabled()) {
                logger.info("Length of ERP query body: " + entity.getContentLength() + " bytes.");
            }
        }
        return entity;
    }

    private SignedErpQuery signPayload(String payload, ErpQuerySigner querySigner) throws SignatureException {
        long start = System.nanoTime();
        SignedErpQuery signedErpQuery = querySigner.signQuery(payload);
        this.measurements.addQuerySigningDuration(DateTimeUtil.newDuration((long)start, (long)System.nanoTime()));
        Duration querySigningDuration = this.measurements.getQuerySigningDuration();
        if (querySigningDuration != null && LONG_RUNNING_QUERY_SIGNING_THRESHOLD.compareTo((ReadableDuration)querySigningDuration) < 0) {
            ErpEndpointMonitor.getInstance().trackLongRunningQuerySigning(this.measurements.getQuerySigningDuration(), querySigner.getClass().getSimpleName(), payload);
        }
        return signedErpQuery;
    }

    private String appendSignatureToBody(SignedErpQuery signedErpQuery) {
        String query = signedErpQuery.getQuery();
        String signature = (String)signedErpQuery.getSignature().orNull();
        if (signature == null || signature.isEmpty()) {
            return query;
        }
        return query + "\n" + signature;
    }

    private HttpPost buildRequest(SignedErpQuery query, URI requestUri, List<com.sap.cloud.sdk.cloudplatform.connectivity.Header> headers, @Nullable ErpSignature erpSignature) throws QuerySerializationException {
        HttpPost request;
        long beginBuildRequest = System.nanoTime();
        try {
            ByteArrayEntity entity = erpSignature != null && erpSignature.getSignatureLocation() == ErpSignature.SignatureLocation.SIGNATURE_IN_PAYLOAD ? this.compressPayload(this.appendSignatureToBody(query)) : this.compressPayload(query.getQuery());
            request = new HttpPost(requestUri + "?sap-client=" + this.erpConfigContext.getSapClient() + "&sap-language=" + this.erpConfigContext.getLocale().getLanguage());
            request.setEntity((HttpEntity)entity);
            request.setHeader("User-Agent", "ErpEndpointSCP");
            request.setHeader("Accept-Encoding", "gzip");
            for (com.sap.cloud.sdk.cloudplatform.connectivity.Header header : headers) {
                request.setHeader(header.getName(), header.getValue());
            }
            if (erpSignature != null && query.getSignature().isPresent() && erpSignature.getSignatureLocation() == ErpSignature.SignatureLocation.SIGNATURE_IN_HEADER) {
                request.setHeader("erp-request-signature", (String)query.getSignature().get());
            }
        }
        catch (IllegalArgumentException e) {
            throw new ShouldNotHappenException((Throwable)e);
        }
        finally {
            this.measurements.addBuildRequestDuration(DateTimeUtil.newDuration((long)beginBuildRequest, (long)System.nanoTime()));
        }
        return request;
    }

    private void handleHttpStatus(int statusCode, String responsePayload, List<Header> responseHeaders) throws QueryExecutionException {
        if (statusCode == 200) {
            if (logger.isTraceEnabled()) {
                logger.trace("Query execution finished successfully. Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".");
            }
        } else {
            this.handleHttpError(statusCode, responsePayload, responseHeaders);
        }
    }

    private void handleHttpError(int statusCode, String payload, List<Header> headers) throws QueryExecutionException {
        switch (statusCode) {
            case 401: {
                this.handleUnauthorized(payload, headers);
                return;
            }
            case 403: {
                this.handleForbidden(payload, headers);
                return;
            }
            case 500: {
                this.handleInternalServerError(payload, headers);
                return;
            }
            case 503: {
                this.handleServiceUnavailableError(payload, headers);
                return;
            }
            case 502: {
                this.handleBadGateway(payload, headers);
                return;
            }
        }
        String message = "Query execution failed with status code " + statusCode + ". Response body: " + payload + " Headers: " + this.getNonSensitiveHeadersAsString(headers) + ".";
        throw new QueryExecutionException(message);
    }

    private void handleUnauthorized(String responsePayload, List<Header> responseHeaders) throws LogonErrorException {
        block3: {
            if (responsePayload.matches(".*\\<[^>]+>.*")) {
                String xml = HTML_TAGS_PATTERN.matcher(responsePayload).replaceAll("");
                try {
                    responsePayload = new XmlPrettyPrinter(xml, Charsets.UTF_8).prettyPrint();
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Failed to pretty-print payload.", (Throwable)e);
                }
            }
        }
        String message = "401 Unauthorized. The connection attempt was refused. Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new LogonErrorException(message);
    }

    @Nullable
    private String getMissingAuthorization(List<Header> headers) {
        for (Header header : headers) {
            if (!header.getName().equals("failed-authorization-object")) continue;
            return header.getValue();
        }
        return null;
    }

    private void handleForbidden(String responsePayload, List<Header> responseHeaders) throws AccessDeniedException {
        String prefix = "403 Forbidden. ";
        if (responsePayload != null && responsePayload.startsWith("CX_FINS_MAP_NO_AUTH_QUERY_EXEC")) {
            String message = "403 Forbidden. The ERP refused to execute the given query. This may be caused by a missing role in the ERP system. Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            String missingAuthorization = this.getMissingAuthorization(responseHeaders);
            throw AccessDeniedException.raiseMissingAuthorizations(null, Collections.singleton(new ErpAuthorization(missingAuthorization)));
        }
        String message = "403 Forbidden. Failed to establish a trusted connection to the ERP. This may be caused by a misconfiguration of the SAP Cloud Connector or a misconfiguration of the trust certificate. Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new AccessDeniedException(message);
    }

    private void handleInternalServerError(String responsePayload, List<Header> responseHeaders) throws QueryExecutionException {
        String prefix = "500 Internal Server Error. ";
        if (responsePayload != null && responsePayload.contains("ICF") && responsePayload.contains("HCPMAPBM")) {
            String message = "500 Internal Server Error. Failed to invoke ICF service. Does the user have authorization HCPMAPBM? Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            throw new AccessDeniedException(message);
        }
        String message = "500 Internal Server Error. Query execution failed with unexpected error. Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
        throw new QueryExecutionException(message);
    }

    private void handleServiceUnavailableError(String responsePayload, List<Header> responseHeaders) throws QueryExecutionException {
        if (responsePayload != null && responsePayload.contains("No tunnels subscribed for tunnelId")) {
            String message = "503 Service Unavailable. Failed to connect to ERP system. Please check the configuration of destination '" + this.erpConfigContext.getDestinationName() + "'. In an on-premise setup, ensure that the cloud connector is connected.";
            throw new CloudConnectorException(message);
        }
        this.handleInternalServerError(responsePayload, responseHeaders);
    }

    private void handleBadGateway(String responsePayload, List<Header> responseHeaders) throws QueryExecutionException {
        if (responsePayload != null && responsePayload.contains("Unable to open connection to backend system")) {
            String message = "502 Bad Gateway. Cloud connector failed to open connection to backend system. Is the internal host configured correctly? Response body: " + responsePayload + " Headers: " + this.getNonSensitiveHeadersAsString(responseHeaders) + ".";
            throw new CloudConnectorException(message);
        }
        this.handleInternalServerError(responsePayload, responseHeaders);
    }

    private String getNonSensitiveHeadersAsString(List<Header> headers) {
        StringBuilder sb = new StringBuilder();
        Iterator<Header> headerIt = headers.iterator();
        while (headerIt.hasNext()) {
            Header header = headerIt.next();
            String name = header.getName();
            String value = header.getValue();
            if ("set-cookie".equalsIgnoreCase(name) || "authorization".equalsIgnoreCase(name)) {
                value = "(hidden)";
            }
            sb.append(name).append(": ").append(value).append(headerIt.hasNext() ? ", " : "");
        }
        return sb.toString();
    }

    private SignedErpQuery newSignedErpQuery(SerializedQuery<?> serializedQuery, ErpSignature erpSignature) {
        SignedErpQuery signedErpQuery;
        String payload = serializedQuery.getBody();
        if (serializedQuery.isAbapInterfaceRequired()) {
            try {
                if (erpSignature.useSignature()) {
                    signedErpQuery = this.signPayload(payload, this.querySignerFactory.newQuerySigner(erpSignature.getSigningAlgorithm()));
                }
                signedErpQuery = this.signPayload(payload, new NoSigningErpQuerySigner());
            }
            catch (Exception ignored) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to sign query, continuing without signature. This behavior may be expected when running tests.", (Throwable)ignored);
                }
                try {
                    signedErpQuery = this.signPayload(payload, new NoSigningErpQuerySigner());
                }
                catch (Exception e) {
                    throw new QuerySerializationException("Failed to sign query.", e);
                }
            }
        } else {
            signedErpQuery = new SignedErpQuery(payload, null);
        }
        return signedErpQuery;
    }

    private URI buildRequestUri(SerializedQuery<?> serializedQuery, URI destinationUri, ErpEdition erpEdition) {
        Optional<String> relativeRequestPath = serializedQuery.getRelativeRequestPath();
        URI requestUri = relativeRequestPath.isPresent() ? new ErpServiceUriBuilder().build(destinationUri, (String)relativeRequestPath.get()) : new ErpServiceUriBuilder().build(destinationUri, erpEdition);
        return requestUri;
    }

    private String sendPayload(SerializedQuery<?> serializedQuery) throws QuerySerializationException, QueryExecutionException, DestinationNotFoundException, DestinationAccessException {
        List<Header> responseHeaders;
        String responsePayload;
        HttpResponse response;
        ErpSignature erpSignature;
        ErpEdition erpEdition;
        this.assertValidConfigContext();
        String destinationName = this.erpConfigContext.getDestinationName();
        Destination destination = DestinationAccessor.getDestination((String)destinationName);
        URI destinationUri = destination.getUri();
        HttpClient httpClient = HttpClientAccessor.getHttpClient((Destination)destination);
        if (serializedQuery.isAbapInterfaceRequired()) {
            if (serializedQuery.getQuery() instanceof InfoQuery) {
                InfoQuery infoQuery = (InfoQuery)serializedQuery.getQuery();
                erpEdition = infoQuery.getErpEdition();
                erpSignature = infoQuery.getErpSignature();
            } else {
                ErpSystemInfo erpSystemInfo = this.getErpSystemInfo();
                erpEdition = erpSystemInfo.getErpEdition();
                erpSignature = erpSystemInfo.getErpSignature();
            }
        } else {
            erpEdition = ErpInfoEndpoint.getErpEdition(DestinationAccessor.getDestination((String)this.getDestinationName()));
            erpSignature = ErpSignature.NO_SIGNATURE;
        }
        long beginBuildRequest = System.nanoTime();
        SignedErpQuery signedErpQuery = this.newSignedErpQuery(serializedQuery, erpSignature);
        this.measurements.addBuildRequestDuration(DateTimeUtil.newDuration((long)beginBuildRequest, (long)System.nanoTime()));
        URI requestUri = this.buildRequestUri(serializedQuery, destinationUri, erpEdition);
        HttpPost request = this.buildRequest(signedErpQuery, requestUri, serializedQuery.getHeaders(), erpSignature);
        long beginExecute = System.nanoTime();
        try {
            if (logger.isTraceEnabled()) {
                Thread currentThread = Thread.currentThread();
                logger.trace("Sending POST (thread id: " + currentThread.getId() + ", name: " + currentThread + ")" + " to destination " + destinationUri + " with request URI " + request.getURI() + ". Query: " + signedErpQuery.getQuery() + " Signature: " + signedErpQuery.getSignature() + " Headers: " + Arrays.toString(request.getAllHeaders()) + ".");
            }
            response = httpClient.execute((HttpUriRequest)request);
            responsePayload = HttpEntityUtil.getResponsePayload((HttpResponse)response);
            responseHeaders = Arrays.asList(response.getAllHeaders());
        }
        catch (Exception e) {
            throw new QueryExecutionException("Failed to execute query.", e);
        }
        finally {
            this.measurements.addExecuteRequestDuration(DateTimeUtil.newDuration((long)beginExecute, (long)System.nanoTime()));
        }
        Duration executeRequestDuration = this.measurements.getExecuteRequestDuration();
        if (executeRequestDuration != null && LONG_RUNNING_REQUEST_THRESHOLD.compareTo((ReadableDuration)executeRequestDuration) < 0) {
            ErpEndpointMonitor.getInstance().trackLongRunningRequest(this.measurements.getExecuteRequestDuration(), this.measurements.getQuerySigningDuration(), request.getRequestLine().toString(), serializedQuery.getBody(), response.getStatusLine().toString(), response.getAllHeaders(), responsePayload.length());
        }
        this.handleHttpStatus(response.getStatusLine().getStatusCode(), responsePayload, responseHeaders);
        return responsePayload;
    }

    public QueryExecutionMeasurements getMeasurements() {
        return this.measurements;
    }

    private static class ErpAuthorization
    implements Authorization {
        private final String missingAuthorization;

        ErpAuthorization(String missingAuthorization) {
            this.missingAuthorization = missingAuthorization;
        }

        public String getName() {
            return this.missingAuthorization;
        }
    }
}

