/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.GenericDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.WithDestinationName;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationNotFoundException;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationTypeNotSupportedException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleAccessor;
import com.sap.cloud.sdk.s4hana.connectivity.ConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpDestination;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import java.util.Locale;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class ErpConfigContext
implements ConfigContext,
WithDestinationName {
    private static final Logger logger = CloudLoggerFactory.getLogger(ErpConfigContext.class);
    public static final String DEFAULT_SAP_CLIENT_PROPERTY = "sap-client";
    public static final String DEFAULT_LOCALE_PROPERTY = "sap-language";
    public static final String DEFAULT_SAP_CLIENT_PROPERTY_RFC = "jco.client.client";
    public static final String DEFAULT_LOCALE_PROPERTY_RFC = "jco.client.lang";
    private final String destinationName;
    private final SapClient sapClient;
    private final Locale locale;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ErpConfigContext(@Nullable String destinationName, @Nullable SapClient sapClient, @Nullable String sapClientProperty, @Nullable Locale locale, @Nullable String localeProperty) throws DestinationAccessException {
        String propertyName;
        DestinationType destinationType;
        this.destinationName = destinationName == null ? ErpDestination.getDefaultName() : destinationName;
        GenericDestination destination = null;
        if (sapClient == null) {
            String property;
            destination = DestinationAccessor.getGenericDestination((String)this.destinationName);
            if (sapClientProperty == null) {
                destinationType = destination.getDestinationType();
                if (DestinationType.HTTP.equals((Object)destinationType)) {
                    propertyName = DEFAULT_SAP_CLIENT_PROPERTY;
                } else {
                    if (!DestinationType.RFC.equals((Object)destinationType)) throw new DestinationTypeNotSupportedException(this.destinationName, destinationType);
                    propertyName = DEFAULT_SAP_CLIENT_PROPERTY_RFC;
                }
            } else {
                propertyName = sapClientProperty;
            }
            if ((property = (String)destination.getPropertiesByName().get(propertyName)) == null && logger.isInfoEnabled()) {
                logger.info("Unable to retrieve SAP client from destination property \"" + propertyName + "\". Falling back to default SAP client. " + "To specify the SAP client, set the property on destination \"" + this.destinationName + "\" or provide the SAP client as explicit argument.");
            }
            this.sapClient = property != null ? new SapClient(property) : SapClient.DEFAULT;
        } else {
            this.sapClient = sapClient;
        }
        if (locale == null) {
            Locale fallback;
            block19: {
                if (localeProperty == null) {
                    if (destination == null) {
                        destination = DestinationAccessor.getGenericDestination((String)this.destinationName);
                    }
                    if (DestinationType.HTTP.equals((Object)(destinationType = destination.getDestinationType()))) {
                        propertyName = DEFAULT_LOCALE_PROPERTY;
                    } else {
                        if (!DestinationType.RFC.equals((Object)destinationType)) throw new DestinationTypeNotSupportedException(this.destinationName, destinationType);
                        propertyName = DEFAULT_LOCALE_PROPERTY_RFC;
                    }
                } else {
                    propertyName = localeProperty;
                }
                fallback = null;
                try {
                    String localeString;
                    if (destination == null) {
                        destination = DestinationAccessor.getGenericDestination((String)this.destinationName);
                    }
                    if ((localeString = (String)destination.getPropertiesByName().get(propertyName)) != null) {
                        fallback = new Locale(localeString);
                    }
                }
                catch (DestinationAccessException | DestinationNotFoundException e) {
                    if (!logger.isInfoEnabled()) break block19;
                    logger.info("Unable to retrieve locale from destination property \"" + propertyName + "\".", e);
                }
            }
            if (fallback == null) {
                fallback = LocaleAccessor.getCurrentLocale();
                if (logger.isInfoEnabled()) {
                    logger.info("Falling back to locale \"" + fallback + "\". To specify the locale, set the property on destination \"" + this.destinationName + "\" or provide the locale as explicit argument.");
                }
            }
            this.locale = fallback;
            return;
        }
        this.locale = locale;
    }

    public ErpConfigContext(@Nullable String destinationName, @Nullable SapClient sapClient, @Nullable Locale locale) throws DestinationAccessException {
        this(destinationName, sapClient, null, locale, null);
    }

    public ErpConfigContext(@Nullable String destinationName, @Nullable SapClient sapClient) {
        this(destinationName, sapClient, null, null, null);
    }

    public ErpConfigContext(@Nullable String destinationName) {
        this(destinationName, null, null, null, null);
    }

    public ErpConfigContext(@Nullable SapClient sapClient) {
        this(null, sapClient, null, null, null);
    }

    public ErpConfigContext(@Nullable Locale locale) {
        this(null, null, null, locale, null);
    }

    public ErpConfigContext() {
        this(null, null, null, null, null);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public SapClient getSapClient() {
        return this.sapClient;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErpConfigContext)) {
            return false;
        }
        ErpConfigContext other = (ErpConfigContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$destinationName = this.getDestinationName();
        String other$destinationName = other.getDestinationName();
        if (this$destinationName == null ? other$destinationName != null : !this$destinationName.equals(other$destinationName)) {
            return false;
        }
        SapClient this$sapClient = this.getSapClient();
        SapClient other$sapClient = other.getSapClient();
        if (this$sapClient == null ? other$sapClient != null : !this$sapClient.equals(other$sapClient)) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        return !(this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErpConfigContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $destinationName = this.getDestinationName();
        result = result * 59 + ($destinationName == null ? 43 : $destinationName.hashCode());
        SapClient $sapClient = this.getSapClient();
        result = result * 59 + ($sapClient == null ? 43 : $sapClient.hashCode());
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        return result;
    }

    public String toString() {
        return "ErpConfigContext(destinationName=" + this.getDestinationName() + ", sapClient=" + this.getSapClient() + ", locale=" + this.getLocale() + ")";
    }
}

