/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.netflix.hystrix.HystrixCommand;
import com.sap.cloud.sdk.frameworks.hystrix.Command;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.WithErpEndpoint;

public abstract class ErpCommand<T>
extends Command<T>
implements WithErpEndpoint {
    private final ErpEndpoint erpEndpoint;

    protected ErpCommand(HystrixCommand.Setter setter, ErpEndpoint erpEndpoint) {
        super(setter);
        this.erpEndpoint = erpEndpoint;
    }

    protected ErpCommand(HystrixCommand.Setter setter, ErpConfigContext erpConfigContext) {
        super(setter);
        this.erpEndpoint = new ErpEndpoint(erpConfigContext);
    }

    protected ErpCommand(Class<?> commandType, ErpEndpoint erpEndpoint) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), erpEndpoint);
    }

    protected ErpCommand(Class<?> commandType, ErpConfigContext erpConfigContext) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), erpConfigContext);
    }

    @Override
    public ErpConfigContext getConfigContext() {
        return this.erpEndpoint.getConfigContext();
    }

    @Override
    public ErpEndpoint getErpEndpoint() {
        return this.erpEndpoint;
    }
}

