/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.netflix.hystrix.HystrixCommand;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.frameworks.hystrix.CachingCommand;
import com.sap.cloud.sdk.frameworks.hystrix.HystrixUtil;
import com.sap.cloud.sdk.s4hana.connectivity.ErpConfigContext;
import com.sap.cloud.sdk.s4hana.connectivity.ErpEndpoint;
import com.sap.cloud.sdk.s4hana.connectivity.WithErpEndpoint;

public abstract class CachingErpCommand<T>
extends CachingCommand<T>
implements WithErpEndpoint {
    private final ErpEndpoint erpEndpoint;

    protected CachingErpCommand(HystrixCommand.Setter setter, ErpEndpoint erpEndpoint) {
        super(setter);
        this.erpEndpoint = erpEndpoint;
    }

    protected CachingErpCommand(HystrixCommand.Setter setter, ErpConfigContext erpConfigContext) {
        super(setter);
        this.erpEndpoint = new ErpEndpoint(erpConfigContext);
    }

    protected CachingErpCommand(Class<?> commandType, ErpEndpoint erpEndpoint) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), erpEndpoint);
    }

    protected CachingErpCommand(Class<?> commandType, ErpConfigContext erpConfigContext) {
        this(HystrixUtil.getDefaultErpCommandSetter(commandType), erpConfigContext);
    }

    @Override
    public ErpConfigContext getConfigContext() {
        return this.erpEndpoint.getConfigContext();
    }

    protected CacheKey getCommandCacheKey() {
        return super.getCommandCacheKey().append((Object)this.getConfigContext(), new Object[0]);
    }

    @Override
    public ErpEndpoint getErpEndpoint() {
        return this.erpEndpoint;
    }
}

