/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TenantAccessor {
    @Nullable
    private static TenantFacade tenantFacade = (TenantFacade)FacadeLocator.getFacade(TenantFacade.class);

    @Nonnull
    static TenantFacade facade() throws ShouldNotHappenException {
        if (tenantFacade == null) {
            throw new ShouldNotHappenException("Failed to determine the current Cloud platform while accessing tenant information. Make sure to specify the targeted platform by declaring a dependency to either com.sap.cloud.s4hana.cloudplatform:scp-cf for SAP Cloud Platform Cloud Foundry or com.sap.cloud.s4hana.cloudplatform:scp-neo for SAP Cloud Platform Neo. Within tests, make sure to declare a dependency on com.sap.cloud.s4hana:testutil, add 'private static final MockUtil mockUtil = new MockUtil();' to your test class, and invoke 'mockUtil.mockDefaults();' before running the tests.");
        }
        return tenantFacade;
    }

    public static void setTenantFacade(@Nonnull TenantFacade tenantFacade) {
        TenantAccessor.tenantFacade = tenantFacade;
    }

    @Nonnull
    public static Tenant getCurrentTenant() throws TenantNotAvailableException, TenantAccessException {
        return TenantAccessor.facade().getCurrentTenant();
    }

    @Nonnull
    public static Optional<Tenant> getCurrentTenantIfAvailable() throws TenantAccessException {
        return TenantAccessor.facade().getCurrentTenantIfAvailable();
    }

    @Nonnull
    public static Try<Tenant> tryGetCurrentTenant() {
        return TenantAccessor.facade().tryGetCurrentTenant();
    }

    @Nullable
    public static TenantFacade getTenantFacade() {
        return tenantFacade;
    }
}

