/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextExecutor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantNotAvailableException;
import io.vavr.control.Try;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;

public abstract class AbstractTenantFacade
implements TenantFacade {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractTenantFacade.class);
    private static final String VARIABLE_USE_MOCKED_TENANT = "USE_MOCKED_TENANT";

    @Nonnull
    protected abstract Tenant newMockedTenant();

    @Nonnull
    public Optional<Tenant> getMockedTenant() {
        String env = System.getenv(VARIABLE_USE_MOCKED_TENANT);
        if (Boolean.valueOf(env).booleanValue()) {
            logger.error("Using a mocked tenant with blank tenant identifier since environment variable 'USE_MOCKED_TENANT' is set to 'true'. SECURITY WARNING: This variable must never be used in productive environments!");
            return Optional.of(this.newMockedTenant());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Tenant getCurrentTenant() throws TenantNotAvailableException, TenantAccessException {
        Optional<Tenant> currentTenant = this.getCurrentTenantIfAvailable();
        if (!currentTenant.isPresent()) {
            throw new TenantNotAvailableException("Failed to get current tenant: tenant not available. For details on the security configuration, please refer to the SAP Cloud Platform documentation. Tutorials on the configuration are available at 'https://help.sap.com/viewer/p/SAP_CLOUD_SDK'.");
        }
        return currentTenant.get();
    }

    @Override
    @Nonnull
    public Optional<Tenant> getCurrentTenantIfAvailable() throws TenantAccessException {
        Optional property;
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (!requestContext.isPresent()) {
            throw new TenantAccessException("Failed to get current tenant: no " + RequestContext.class.getSimpleName() + " available. Have you correctly configured a " + RequestContextServletFilter.class.getSimpleName() + " or have you wrapped your logic in a " + RequestContextExecutor.class.getSimpleName() + " when executing background tasks that are not triggered by a request?");
        }
        try {
            property = ((RequestContext)requestContext.get()).getProperty(TenantRequestContextListener.PROPERTY_TENANT);
        }
        catch (RequestContextPropertyException e) {
            throw new TenantAccessException("Failed to get current tenant: failed to get " + RequestContext.class.getSimpleName() + " property.", e);
        }
        if (!property.isPresent()) {
            throw new TenantAccessException("Failed to get current tenant: " + RequestContext.class.getSimpleName() + " property '" + TenantRequestContextListener.PROPERTY_TENANT + "' not initialized. Have you correctly configured a " + TenantRequestContextListener.class.getSimpleName() + " in the relevant " + RequestContextServletFilter.class.getSimpleName() + " or " + RequestContextExecutor.class.getSimpleName() + "?");
        }
        Exception exception = ((Property)property.get()).getException();
        if (exception != null) {
            throw new TenantAccessException("Failed to get current tenant.", exception);
        }
        Tenant tenant = (Tenant)((Property)property.get()).getValue();
        return Optional.ofNullable(tenant);
    }

    @Override
    @Nonnull
    public Try<Tenant> tryGetCurrentTenant() {
        return Try.of(this::getCurrentTenant);
    }
}

