/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet.response.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.sap.cloud.sdk.cloudplatform.exception.StringParsingException;
import com.sap.cloud.sdk.cloudplatform.servlet.response.serializer.GsonSerializer;
import com.sap.cloud.sdk.cloudplatform.util.StringConverter;
import java.lang.reflect.Type;
import java.util.Date;

public class DateGsonSerializer
implements GsonSerializer<Date> {
    public JsonElement serialize(Date date, Type typeOfSrc, JsonSerializationContext context) {
        String str = StringConverter.toString((Date)date);
        if (str == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(str);
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        try {
            return StringConverter.toDate((String)json.getAsString());
        }
        catch (StringParsingException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

