/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.DefaultRequestContextFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextCallable;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChain;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListenerChainBuilder;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;

@WebFilter(filterName="RequestContextServletFilter", urlPatterns={"/*"})
public class RequestContextServletFilter
implements Filter {
    private static final Logger logger = CloudLoggerFactory.getLogger(RequestContextServletFilter.class);
    public static final String INIT_PARAMETER_REQUEST_CONTEXT_FACTORY = "factory";
    public static final String INIT_PARAMETER_REQUEST_CONTEXT_LISTENERS = "listeners";
    public static final String INIT_PARAMETER_DISABLE_DEFAULT_LISTENERS = "disableDefaultListeners";
    public static final String INIT_PARAMETER_USE_PARENT_CONTEXT = "useParentContext";
    protected RequestContextFactory requestContextFactory;
    protected RequestContextListenerChain requestContextListenerChain;
    protected Boolean useParentContext;

    public void init(FilterConfig filterConfig) {
        this.loadFactory(filterConfig.getInitParameter(INIT_PARAMETER_REQUEST_CONTEXT_FACTORY));
        this.loadListeners(filterConfig.getInitParameter(INIT_PARAMETER_REQUEST_CONTEXT_LISTENERS), Boolean.valueOf(filterConfig.getInitParameter(INIT_PARAMETER_DISABLE_DEFAULT_LISTENERS)));
        this.useParentContext = Boolean.valueOf(filterConfig.getInitParameter(INIT_PARAMETER_USE_PARENT_CONTEXT));
    }

    protected void loadFactory(String factoryName) {
        block9: {
            if (!Strings.isNullOrEmpty((String)factoryName)) {
                try {
                    String trimmedFactoryName = factoryName.trim();
                    Class<?> cls = Class.forName(trimmedFactoryName);
                    Constructor<?> constructor = cls.getConstructor(new Class[0]);
                    Object object = constructor.newInstance(new Object[0]);
                    if (object instanceof RequestContextFactory) {
                        this.requestContextFactory = (RequestContextFactory)object;
                        if (logger.isInfoEnabled()) {
                            logger.info("Successfully created " + trimmedFactoryName + ".");
                        }
                        break block9;
                    }
                    logger.error("Failed to create " + RequestContextFactory.class.getSimpleName() + ": unsupported type " + trimmedFactoryName + ".");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.error("Failed to create " + this.getClass().getSimpleName() + ".", (Throwable)e);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Filter initialization parameter factory not defined.");
            }
        }
        if (this.requestContextFactory == null) {
            if (logger.isInfoEnabled()) {
                logger.info("No " + RequestContextFactory.class.getSimpleName() + " configured. Falling back to " + DefaultRequestContextFactory.class.getSimpleName() + ".");
            }
            this.requestContextFactory = new DefaultRequestContextFactory();
        }
    }

    protected void loadListeners(String listenerNames, Boolean disableDefaultListeners) {
        RequestContextListenerChainBuilder builder = RequestContextListenerChain.builder();
        if (disableDefaultListeners.booleanValue()) {
            builder.withoutDefaultListeners();
        }
        if (!Strings.isNullOrEmpty((String)listenerNames)) {
            Iterable splits = Splitter.on((char)',').split((CharSequence)listenerNames);
            for (String listenerName : splits) {
                try {
                    String trimmedListenerName = listenerName.trim();
                    Class<?> cls = Class.forName(trimmedListenerName);
                    Constructor<?> constructor = cls.getConstructor(new Class[0]);
                    Object object = constructor.newInstance(new Object[0]);
                    if (object instanceof RequestContextListener) {
                        builder.withListeners((RequestContextListener)object);
                        if (!logger.isInfoEnabled()) continue;
                        logger.info("Successfully added " + trimmedListenerName + ".");
                        continue;
                    }
                    logger.error("Failed to create " + RequestContextListener.class.getSimpleName() + ": unsupported type " + trimmedListenerName + ".");
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.error("Failed to create " + this.getClass().getSimpleName() + ".", (Throwable)e);
                }
            }
        }
        this.requestContextListenerChain = builder.build();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            RequestContext requestContext = this.requestContextFactory.newRequestContext((HttpServletRequest)request);
            RequestContext parentRequestContext = RequestContextAccessor.getCurrentRequestContext().orElse(null);
            if (this.useParentContext.booleanValue() && parentRequestContext == null) {
                throw new ShouldNotHappenException("Asked for execution with parent context but no parent context found.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Successfully created " + RequestContext.class.getSimpleName() + ": " + requestContext + ".");
                if (this.useParentContext.booleanValue()) {
                    logger.debug("Successfully load parent request context:" + parentRequestContext);
                }
            }
            Callable<Void> doFilter = () -> {
                filterChain.doFilter(request, response);
                return null;
            };
            try {
                if (this.useParentContext.booleanValue()) {
                    new RequestContextCallable<Void>(requestContext, this.requestContextListenerChain, doFilter, parentRequestContext).call();
                }
                new RequestContextCallable<Void>(requestContext, this.requestContextListenerChain, doFilter).call();
            }
            catch (IOException | ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ShouldNotHappenException((Throwable)e);
            }
        } else {
            logger.error("Failed to initialize " + RequestContext.class.getSimpleName() + ": request not of type " + HttpServletRequest.class.getName() + ".");
        }
    }

    public void destroy() {
    }
}

